/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.suretrak;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.FileHelper;
import net.sf.mpxj.common.FixedLengthInputStream;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.primavera.common.Blast;
import net.sf.mpxj.primavera.suretrak.SureTrakDatabaseReader;
import net.sf.mpxj.reader.AbstractProjectStreamReader;

public final class SureTrakSTXFileReader
extends AbstractProjectStreamReader {
    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        ProjectFile projectFile;
        File tempDir = null;
        try {
            InputStreamHelper.skip(stream, 32772L);
            tempDir = FileHelper.createTempDir();
            while (stream.available() > 0) {
                this.extractFile(stream, tempDir);
            }
            projectFile = SureTrakDatabaseReader.setProjectNameAndRead(tempDir);
        }
        catch (IOException ex) {
            try {
                throw new MPXJException("Failed to parse file", ex);
            }
            catch (Throwable throwable) {
                FileHelper.deleteQuietly(tempDir);
                throw throwable;
            }
        }
        FileHelper.deleteQuietly(tempDir);
        return projectFile;
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        return Collections.singletonList(this.read(inputStream));
    }

    private void extractFile(InputStream stream, File dir) throws IOException {
        byte[] dataSize = InputStreamHelper.read(stream, 4);
        InputStreamHelper.skip(stream, 4L);
        byte[] fileName = InputStreamHelper.read(stream, 260);
        int dataSizeValue = this.getInt(dataSize, 0);
        String fileNameValue = this.getString(fileName, 0);
        File file = new File(dir, fileNameValue);
        if (dataSizeValue == 0) {
            FileHelper.createNewFile(file);
        } else {
            OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            FixedLengthInputStream inputStream = new FixedLengthInputStream(stream, dataSizeValue);
            Blast blast = new Blast();
            blast.blast(inputStream, os);
            os.close();
        }
    }

    private int getInt(byte[] data, int offset) {
        int result = 0;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            result |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    private String getString(byte[] data, int offset) {
        char c;
        StringBuilder buffer = new StringBuilder();
        int loop = 0;
        while (offset + loop < data.length && (c = (char)data[offset + loop]) != '\u0000') {
            buffer.append(c);
            ++loop;
        }
        return buffer.toString();
    }
}

