/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public enum JavaModifier {
    PUBLIC(EnumSet.allOf(ApplicableType.class), 1),
    PROTECTED(EnumSet.allOf(ApplicableType.class), 4),
    PRIVATE(EnumSet.allOf(ApplicableType.class), 2),
    STATIC(EnumSet.allOf(ApplicableType.class), 8),
    FINAL(EnumSet.allOf(ApplicableType.class), 16),
    VOLATILE(EnumSet.of(ApplicableType.FIELD), 64),
    TRANSIENT(EnumSet.of(ApplicableType.FIELD), 128),
    ENUM(EnumSet.of(ApplicableType.FIELD), 16384),
    ABSTRACT(EnumSet.of(ApplicableType.CLASS, ApplicableType.METHOD), 1024),
    SYNCHRONIZED(EnumSet.of(ApplicableType.METHOD), 32),
    NATIVE(EnumSet.of(ApplicableType.METHOD), 256),
    BRIDGE(EnumSet.of(ApplicableType.METHOD), 64),
    SYNTHETIC(EnumSet.allOf(ApplicableType.class), 4096);

    private final Set<ApplicableType> applicableTo;
    private final int asmAccessFlag;

    private JavaModifier(Set<ApplicableType> applicableTo, int asmAccessFlag) {
        this.applicableTo = Sets.immutableEnumSet(applicableTo);
        this.asmAccessFlag = asmAccessFlag;
    }

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Set<JavaModifier> getModifiersForClass(int asmAccess) {
        boolean opCodeForRecordIsPresent;
        Set<JavaModifier> modifiers = JavaModifier.getModifiersFor(ApplicableType.CLASS, asmAccess);
        boolean bl = opCodeForRecordIsPresent = (asmAccess & 0x10000) != 0;
        if (opCodeForRecordIsPresent) {
            return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(modifiers)).add((Object[])new JavaModifier[]{STATIC, FINAL})).build();
        }
        return modifiers;
    }

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Set<JavaModifier> getModifiersForField(int asmAccess) {
        return JavaModifier.getModifiersFor(ApplicableType.FIELD, asmAccess);
    }

    @Deprecated
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static Set<JavaModifier> getModifiersForMethod(int asmAccess) {
        return JavaModifier.getModifiersFor(ApplicableType.METHOD, asmAccess);
    }

    private static Set<JavaModifier> getModifiersFor(ApplicableType type, int asmAccess) {
        Set result = Arrays.stream(JavaModifier.values()).filter(modifier -> modifier.applicableTo.contains((Object)type)).filter(modifier -> JavaModifier.modifierPresent(modifier, asmAccess)).collect(Collectors.toSet());
        return result.isEmpty() ? Collections.emptySet() : Sets.immutableEnumSet(result);
    }

    private static boolean modifierPresent(JavaModifier modifier, int asmAccess) {
        return (modifier.asmAccessFlag & asmAccess) != 0;
    }

    private static enum ApplicableType {
        CLASS,
        METHOD,
        FIELD;

    }
}

