/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.semantic.visitor;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.sql.legacy.antlr.semantic.scope.Environment;
import org.opensearch.sql.legacy.antlr.semantic.scope.Namespace;
import org.opensearch.sql.legacy.antlr.semantic.scope.SemanticContext;
import org.opensearch.sql.legacy.antlr.semantic.scope.Symbol;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;
import org.opensearch.sql.legacy.antlr.semantic.types.base.OpenSearchDataType;
import org.opensearch.sql.legacy.antlr.semantic.types.base.OpenSearchIndex;
import org.opensearch.sql.legacy.antlr.visitor.EarlyExitAnalysisException;
import org.opensearch.sql.legacy.antlr.visitor.GenericSqlParseTreeVisitor;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.esdomain.mapping.FieldMappings;
import org.opensearch.sql.legacy.esdomain.mapping.IndexMappings;
import org.opensearch.sql.legacy.utils.StringUtils;

public class OpenSearchMappingLoader
implements GenericSqlParseTreeVisitor<Type> {
    private final SemanticContext context;
    private final LocalClusterState clusterState;
    private final int threshold;

    public OpenSearchMappingLoader(SemanticContext context, LocalClusterState clusterState, int threshold) {
        this.context = context;
        this.clusterState = clusterState;
        this.threshold = threshold;
    }

    @Override
    public Type visitIndexName(String indexName) {
        if (this.isNotNested(indexName)) {
            this.defineIndexType(indexName);
            this.loadAllFieldsWithType(indexName);
        }
        return (Type)this.defaultValue();
    }

    @Override
    public void visitAs(String alias, Type type) {
        if (!(type instanceof OpenSearchIndex)) {
            return;
        }
        OpenSearchIndex index = (OpenSearchIndex)type;
        String indexName = type.getName();
        if (index.type() == OpenSearchIndex.IndexType.INDEX) {
            String aliasName = alias.isEmpty() ? indexName : alias;
            this.defineAllFieldNamesByAppendingAliasPrefix(indexName, aliasName);
        } else if (index.type() == OpenSearchIndex.IndexType.NESTED_FIELD && !alias.isEmpty()) {
            this.defineNestedFieldNamesByReplacingWithAlias(indexName, alias);
        }
    }

    private void defineIndexType(String indexName) {
        this.environment().define(new Symbol(Namespace.FIELD_NAME, indexName), new OpenSearchIndex(indexName, OpenSearchIndex.IndexType.INDEX));
    }

    private void loadAllFieldsWithType(String indexName) {
        Set<FieldMappings> mappings = this.getFieldMappings(indexName);
        mappings.forEach(mapping -> mapping.flat(this::defineFieldName));
    }

    private void defineAllFieldNamesByAppendingAliasPrefix(String indexName, String alias) {
        Set<FieldMappings> mappings = this.getFieldMappings(indexName);
        mappings.stream().forEach(mapping -> mapping.flat((fieldName, type) -> this.defineFieldName(alias + "." + fieldName, (String)type)));
    }

    private void defineNestedFieldNamesByReplacingWithAlias(String nestedFieldName, String alias) {
        Map<String, Type> typeByFullName = this.environment().resolveByPrefix(new Symbol(Namespace.FIELD_NAME, nestedFieldName));
        typeByFullName.forEach((fieldName, fieldType) -> this.defineFieldName(fieldName.replace(nestedFieldName, alias), (Type)fieldType));
    }

    private boolean isNotNested(String indexName) {
        return indexName.indexOf(46, 1) == -1;
    }

    private Set<FieldMappings> getFieldMappings(String indexName) {
        IndexMappings indexMappings = this.clusterState.getFieldMappings(new String[]{indexName});
        HashSet<FieldMappings> fieldMappingsSet = new HashSet<FieldMappings>(indexMappings.allMappings());
        for (FieldMappings fieldMappings : fieldMappingsSet) {
            int size = fieldMappings.data().size();
            if (size <= this.threshold) continue;
            throw new EarlyExitAnalysisException(StringUtils.format("Index [%s] has [%d] fields more than threshold [%d]", indexName, size, this.threshold));
        }
        return fieldMappingsSet;
    }

    private void defineFieldName(String fieldName, String type) {
        if ("NESTED".equalsIgnoreCase(type)) {
            this.defineFieldName(fieldName, new OpenSearchIndex(fieldName, OpenSearchIndex.IndexType.NESTED_FIELD));
        } else {
            this.defineFieldName(fieldName, OpenSearchDataType.typeOf(type));
        }
    }

    private void defineFieldName(String fieldName, Type type) {
        Symbol symbol = new Symbol(Namespace.FIELD_NAME, fieldName);
        this.environment().define(symbol, type);
    }

    private Environment environment() {
        return this.context.peek();
    }
}

