﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kendra-ranking/KendraRankingRequest.h>
#include <aws/kendra-ranking/KendraRanking_EXPORTS.h>
#include <aws/kendra-ranking/model/CapacityUnitsConfiguration.h>

#include <utility>

namespace Aws {
namespace KendraRanking {
namespace Model {

/**
 */
class UpdateRescoreExecutionPlanRequest : public KendraRankingRequest {
 public:
  AWS_KENDRARANKING_API UpdateRescoreExecutionPlanRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateRescoreExecutionPlan"; }

  AWS_KENDRARANKING_API Aws::String SerializePayload() const override;

  AWS_KENDRARANKING_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The identifier of the rescore execution plan that you want to update.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  UpdateRescoreExecutionPlanRequest& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A new name for the rescore execution plan.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateRescoreExecutionPlanRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A new description for the rescore execution plan.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  UpdateRescoreExecutionPlanRequest& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>You can set additional capacity units to meet the needs of your rescore
   * execution plan. You are given a single capacity unit by default. If you want to
   * use the default capacity, you don't set additional capacity units. For more
   * information on the default capacity and additional capacity units, see <a
   * href="https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html">Adjusting
   * capacity</a>.</p>
   */
  inline const CapacityUnitsConfiguration& GetCapacityUnits() const { return m_capacityUnits; }
  inline bool CapacityUnitsHasBeenSet() const { return m_capacityUnitsHasBeenSet; }
  template <typename CapacityUnitsT = CapacityUnitsConfiguration>
  void SetCapacityUnits(CapacityUnitsT&& value) {
    m_capacityUnitsHasBeenSet = true;
    m_capacityUnits = std::forward<CapacityUnitsT>(value);
  }
  template <typename CapacityUnitsT = CapacityUnitsConfiguration>
  UpdateRescoreExecutionPlanRequest& WithCapacityUnits(CapacityUnitsT&& value) {
    SetCapacityUnits(std::forward<CapacityUnitsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  CapacityUnitsConfiguration m_capacityUnits;
  bool m_capacityUnitsHasBeenSet = false;
};

}  // namespace Model
}  // namespace KendraRanking
}  // namespace Aws
