﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/proton/Proton_EXPORTS.h>
#include <aws/proton/model/RepositoryProvider.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Proton {
namespace Model {

/**
 * <p>Detail input data for a linked repository branch.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/RepositoryBranchInput">AWS
 * API Reference</a></p>
 */
class RepositoryBranchInput {
 public:
  AWS_PROTON_API RepositoryBranchInput() = default;
  AWS_PROTON_API RepositoryBranchInput(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API RepositoryBranchInput& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The repository branch.</p>
   */
  inline const Aws::String& GetBranch() const { return m_branch; }
  inline bool BranchHasBeenSet() const { return m_branchHasBeenSet; }
  template <typename BranchT = Aws::String>
  void SetBranch(BranchT&& value) {
    m_branchHasBeenSet = true;
    m_branch = std::forward<BranchT>(value);
  }
  template <typename BranchT = Aws::String>
  RepositoryBranchInput& WithBranch(BranchT&& value) {
    SetBranch(std::forward<BranchT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The repository name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  RepositoryBranchInput& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The repository provider.</p>
   */
  inline RepositoryProvider GetProvider() const { return m_provider; }
  inline bool ProviderHasBeenSet() const { return m_providerHasBeenSet; }
  inline void SetProvider(RepositoryProvider value) {
    m_providerHasBeenSet = true;
    m_provider = value;
  }
  inline RepositoryBranchInput& WithProvider(RepositoryProvider value) {
    SetProvider(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_branch;
  bool m_branchHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  RepositoryProvider m_provider{RepositoryProvider::NOT_SET};
  bool m_providerHasBeenSet = false;
};

}  // namespace Model
}  // namespace Proton
}  // namespace Aws
