﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

namespace Aws {
namespace SecurityHub {
namespace Model {
enum class MalwareType {
  NOT_SET,
  ADWARE,
  BLENDED_THREAT,
  BOTNET_AGENT,
  COIN_MINER,
  EXPLOIT_KIT,
  KEYLOGGER,
  MACRO,
  POTENTIALLY_UNWANTED,
  SPYWARE,
  RANSOMWARE,
  REMOTE_ACCESS,
  ROOTKIT,
  TROJAN,
  VIRUS,
  WORM
};

namespace MalwareTypeMapper {
AWS_SECURITYHUB_API MalwareType GetMalwareTypeForName(const Aws::String& name);

AWS_SECURITYHUB_API Aws::String GetNameForMalwareType(MalwareType value);
}  // namespace MalwareTypeMapper
}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
