﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>

namespace Aws {
namespace Lightsail {
namespace Model {
enum class LoadBalancerMetricName {
  NOT_SET,
  ClientTLSNegotiationErrorCount,
  HealthyHostCount,
  UnhealthyHostCount,
  HTTPCode_LB_4XX_Count,
  HTTPCode_LB_5XX_Count,
  HTTPCode_Instance_2XX_Count,
  HTTPCode_Instance_3XX_Count,
  HTTPCode_Instance_4XX_Count,
  HTTPCode_Instance_5XX_Count,
  InstanceResponseTime,
  RejectedConnectionCount,
  RequestCount
};

namespace LoadBalancerMetricNameMapper {
AWS_LIGHTSAIL_API LoadBalancerMetricName GetLoadBalancerMetricNameForName(const Aws::String& name);

AWS_LIGHTSAIL_API Aws::String GetNameForLoadBalancerMetricName(LoadBalancerMetricName value);
}  // namespace LoadBalancerMetricNameMapper
}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
