/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.List;
import java.util.function.Supplier;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.sql.SQLParametersProvider;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;

public abstract class SQLParametersProviderBase
implements SQLParametersProvider {
    @Override
    @Nullable
    public Boolean prepareStatementParameters(@NotNull SQLScriptContext scriptContext, @NotNull SQLQuery sqlStatement, @NotNull List<SQLQueryParameter> parameters, @NotNull Supplier<DBDDataReceiver> dataReceiverSupplier, boolean useDefaults) {
        for (SQLQueryParameter param : parameters) {
            Object defValue;
            String paramName = param.getName();
            Object object = defValue = useDefaults ? scriptContext.getParameterDefaultValue(paramName) : null;
            if (defValue != null || scriptContext.hasVariable(paramName)) {
                this.assignVariable(scriptContext, param, paramName, defValue);
                continue;
            }
            paramName = param.getVarName();
            Object object2 = defValue = useDefaults ? scriptContext.getParameterDefaultValue(paramName) : null;
            if (defValue != null || scriptContext.hasVariable(paramName)) {
                this.assignVariable(scriptContext, param, paramName, defValue);
                continue;
            }
            if (useDefaults) continue;
            param.setVariableSet(false);
        }
        boolean allSet = true;
        for (SQLQueryParameter param : parameters) {
            if (param.isVariableSet()) continue;
            allSet = false;
        }
        if (allSet) {
            return true;
        }
        return this.collectAndAssignVariables(scriptContext, sqlStatement, parameters, dataReceiverSupplier);
    }

    @Nullable
    protected abstract Boolean collectAndAssignVariables(@NotNull SQLScriptContext var1, @NotNull SQLQuery var2, @NotNull List<SQLQueryParameter> var3, @NotNull Supplier<DBDDataReceiver> var4);

    protected void assignVariable(@NotNull SQLScriptContext scriptContext, SQLQueryParameter param, String paramName, Object defValue) {
        Object varValue = defValue != null ? defValue : scriptContext.getVariable(paramName);
        String strValue = varValue == null ? null : varValue.toString();
        param.setValue(strValue);
        param.setVariableSet(true);
    }
}

