/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.text.parser;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDelimiterRule;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPEvalScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.TPTokenScanner;

public class TPRuleBasedScanner
implements TPCharacterScanner,
TPTokenScanner,
TPEvalScanner {
    private static final Log log = Log.getLog(TPRuleBasedScanner.class);
    private static final int UNDEFINED = -1;
    private TPRule[] fRules;
    private TPToken fDefaultReturnToken;
    private IDocument fDocument;
    private char[][] fDelimiters;
    private int fOffset;
    private int fRangeEnd;
    private int fTokenOffset;
    private int fColumn;
    private boolean evalMode;

    public void setRules(TPRule[] rules) {
        if (rules != null) {
            this.fRules = new TPRule[rules.length];
            System.arraycopy(rules, 0, this.fRules, 0, rules.length);
        } else {
            this.fRules = null;
        }
    }

    public void setDefaultReturnToken(TPToken defaultReturnToken) {
        Assert.isNotNull((Object)defaultReturnToken.getData());
        this.fDefaultReturnToken = defaultReturnToken;
    }

    @Override
    public void setRange(IDocument document, int offset, int length) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        int documentLength = document.getLength();
        while (offset + length > documentLength) {
            --length;
        }
        this.checkRange(offset, length, documentLength);
        this.fDocument = document;
        this.fOffset = offset;
        this.fColumn = -1;
        this.fRangeEnd = offset + length;
        String[] delimiters = this.fDocument.getLegalLineDelimiters();
        this.fDelimiters = new char[delimiters.length][];
        for (int i = 0; i < delimiters.length; ++i) {
            this.fDelimiters[i] = delimiters[i].toCharArray();
        }
        if (this.fDefaultReturnToken == null) {
            this.fDefaultReturnToken = TPTokenAbstract.UNDEFINED;
        }
    }

    private void checkRange(int offset, int length, int documentLength) {
        Assert.isLegal((offset > -1 ? 1 : 0) != 0);
        Assert.isLegal((length > -1 ? 1 : 0) != 0);
        Assert.isLegal((offset + length <= documentLength ? 1 : 0) != 0);
    }

    @Override
    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    @Override
    public int getTokenLength() {
        if (this.fOffset < this.fRangeEnd) {
            return this.fOffset - this.getTokenOffset();
        }
        return this.fRangeEnd - this.getTokenOffset();
    }

    public int getTokenEndOffset() {
        return Math.min(this.fOffset, this.fRangeEnd);
    }

    @Override
    public int getColumn() {
        if (this.fColumn == -1) {
            try {
                int line = this.fDocument.getLineOfOffset(this.fOffset);
                int start = this.fDocument.getLineOffset(line);
                this.fColumn = this.fOffset - start;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return this.fColumn;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public char[][] getLegalLineDelimiters() {
        return this.fDelimiters;
    }

    @Override
    public TPToken nextToken() {
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        if (this.fRules != null) {
            for (TPRule fRule : this.fRules) {
                int offset = this.fOffset;
                TPToken token = fRule.evaluate(this);
                if (!token.isUndefined()) {
                    return token;
                }
                if (this.fOffset == offset) continue;
                log.debug((Object)("Text parser rule inconsistency: rule failed and the scanned should have been fallbacked, but the current offset is different after attempt to evaluate " + String.valueOf(fRule)));
                this.fOffset = offset;
            }
        }
        if (this.read() == -1) {
            return TPTokenAbstract.EOF;
        }
        return this.fDefaultReturnToken;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int read() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void unread() {
        --this.fOffset;
        this.fColumn = -1;
    }

    @Override
    public boolean isEvalMode() {
        return this.evalMode;
    }

    public void startEval() {
        this.evalMode = true;
    }

    public void endEval() {
        this.evalMode = false;
        if (this.fRules != null) {
            for (TPRule rule : this.fRules) {
                if (!(rule instanceof SQLDelimiterRule)) continue;
                ((SQLDelimiterRule)rule).changeDelimiter(null);
            }
        }
    }
}

