/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class PrefPageNetworkExpert
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    private Combo prefIpStackCombo;
    private Combo prefIpAddressesCombo;
    private Button debugNetworkConnectionsCheck;

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        composite.setLayoutData((Object)new GridData());
        UIUtils.createInfoLabel((Composite)composite, (String)CoreMessages.pref_page_network_expert_label, (int)0, (int)2, null, (Image)DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_WARNING));
        new Label(composite, 258).setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.prefIpStackCombo = UIUtils.createLabelCombo((Composite)composite, (String)CoreMessages.pref_page_network_expert_preferred_ip_stack_label, (String)CoreMessages.pref_page_network_expert_preferred_ip_stack_tip, (int)12);
        for (ModelPreferences.IPType type : ModelPreferences.IPType.values()) {
            this.prefIpStackCombo.add(type.toString());
        }
        this.prefIpStackCombo.setLayoutData((Object)new GridData());
        this.prefIpStackCombo.select(ModelPreferences.IPType.getPreferredStack().ordinal());
        this.prefIpAddressesCombo = UIUtils.createLabelCombo((Composite)composite, (String)CoreMessages.pref_page_network_expert_preferred_ip_addresses_label, (String)CoreMessages.pref_page_network_expert_preferred_ip_addresses_tip, (int)12);
        for (ModelPreferences.IPType type : ModelPreferences.IPType.values()) {
            this.prefIpAddressesCombo.add(type.toString());
        }
        this.prefIpAddressesCombo.setLayoutData((Object)new GridData());
        this.prefIpAddressesCombo.select(ModelPreferences.IPType.getPreferredAddresses().ordinal());
        this.debugNetworkConnectionsCheck = UIUtils.createCheckbox((Composite)composite, (String)CoreMessages.pref_page_network_expert_debug_net_label, (String)CoreMessages.pref_page_network_expert_debug_net_tip, (boolean)ModelPreferences.getPreferences().getBoolean("connections.debugNetworkConnections"), (int)2);
        UIUtils.createInfoLabel((Composite)composite, (String)CoreMessages.pref_page_ui_general_label_options_take_effect_after_restart, (int)0, (int)2);
        return composite;
    }

    public boolean performOk() {
        DBPPreferenceStore store = ModelPreferences.getPreferences();
        ModelPreferences.IPType preferredIpStack = ModelPreferences.IPType.values()[this.prefIpStackCombo.getSelectionIndex()];
        ModelPreferences.IPType preferredAddresses = ModelPreferences.IPType.values()[this.prefIpAddressesCombo.getSelectionIndex()];
        boolean debugNetwork = this.debugNetworkConnectionsCheck.getSelection();
        if (preferredIpStack != ModelPreferences.IPType.getPreferredStack() || preferredAddresses != ModelPreferences.IPType.getPreferredAddresses() || debugNetwork != ModelPreferences.getPreferences().getBoolean("connections.debugNetworkConnections")) {
            store.setValue("connections.preferredIPType", preferredIpStack.name());
            store.setValue("connections.preferredIPAddresses", preferredAddresses.name());
            store.setValue("connections.debugNetworkConnections", debugNetwork);
            if (UIUtils.confirmAction((Shell)this.getShell(), (String)NLS.bind((String)CoreMessages.pref_page_network_expert_restart_prompt_title, (Object)GeneralUtils.getProductName()), (String)NLS.bind((String)CoreMessages.pref_page_network_expert_restart_prompt_message, (Object)GeneralUtils.getProductName()))) {
                this.restartWorkbenchOnPrefChange();
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.prefIpStackCombo.select(ModelPreferences.IPType.AUTO.ordinal());
        this.prefIpAddressesCombo.select(ModelPreferences.IPType.AUTO.ordinal());
        this.debugNetworkConnectionsCheck.setSelection(false);
        super.performDefaults();
    }
}

