/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.main.application.AuxillaryEditorSplitPane;
import org.freeplane.view.swing.map.outline.BlockPanel;
import org.freeplane.view.swing.map.outline.BreadcrumbLayout;
import org.freeplane.view.swing.map.outline.BreadcrumbMode;
import org.freeplane.view.swing.map.outline.BreadcrumbPanel;
import org.freeplane.view.swing.map.outline.ExpansionControls;
import org.freeplane.view.swing.map.outline.FocusSelectedButtonClickAdapter;
import org.freeplane.view.swing.map.outline.NavigationButtons;
import org.freeplane.view.swing.map.outline.NodeButton;
import org.freeplane.view.swing.map.outline.OutlineActionTarget;
import org.freeplane.view.swing.map.outline.OutlineActions;
import org.freeplane.view.swing.map.outline.OutlineBlockLayout;
import org.freeplane.view.swing.map.outline.OutlineBlockViewCache;
import org.freeplane.view.swing.map.outline.OutlineDisplayMode;
import org.freeplane.view.swing.map.outline.OutlineFocusManager;
import org.freeplane.view.swing.map.outline.OutlineGeometry;
import org.freeplane.view.swing.map.outline.OutlineSelection;
import org.freeplane.view.swing.map.outline.OutlineSelectionBridge;
import org.freeplane.view.swing.map.outline.OutlineSelectionHistory;
import org.freeplane.view.swing.map.outline.OutlineViewport;
import org.freeplane.view.swing.map.outline.RightToLeftLayout;
import org.freeplane.view.swing.map.outline.SelectionSynchronizationTrigger;
import org.freeplane.view.swing.map.outline.TimeDelayedOutlineSelection;
import org.freeplane.view.swing.map.outline.TreeNode;
import org.freeplane.view.swing.map.outline.VisibleBlockRenderer;
import org.freeplane.view.swing.map.outline.VisibleOutlineNodes;

class ScrollableTreePanel
extends JPanel
implements OutlineActionTarget {
    private static final long serialVersionUID = 1L;
    private static final int BLOCK_SIZE = 50;
    private final NavigationButtons navButtons;
    private final BreadcrumbPanel breadcrumbPanel;
    private final ExpansionControls expansionControls;
    private OutlineViewport viewport;
    private final JPanel blockPanel;
    private TreeNode root;
    private final OutlineSelection outlineSelection;
    private final VisibleOutlineNodes visibleNodes;
    private final OutlineGeometry.GeometryListener geometryListener;
    private boolean geometryListenerRegistered;
    private final IFreeplanePropertyListener outlinePropertyListener;
    private boolean outlinePropertyListenerRegistered;
    private final OutlineBlockViewCache blockCache = new OutlineBlockViewCache();
    private OutlineBlockLayout blockLayout;
    private OutlineSelectionBridge selectionBridge;
    private OutlineFocusManager focusManager;
    private final OutlineSelectionHistory selectionHistory = new OutlineSelectionHistory();
    private Supplier<Color> backgroundColorSupplier;
    private VisibleBlockRenderer visibleBlockRenderer;
    private BreadcrumbLayout breadcrumbLayout;
    private OutlineDisplayMode displayMode;
    private final int blockSize;
    private BreadcrumbMode breadcrumbMode;

    ScrollableTreePanel(OutlineDisplayMode displayMode, TreeNode root, BreadcrumbPanel breadcrumbPanel) {
        this(displayMode, root, 50, breadcrumbPanel);
        this.addMouseListener(new FocusSelectedButtonClickAdapter(this.focusManager));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TimeDelayedOutlineSelection.outlineSelector.handleMouseEvent(e);
            }
        });
        this.setOpaque(true);
    }

    private ScrollableTreePanel(OutlineDisplayMode displayMode, TreeNode root, int blockSize, BreadcrumbPanel breadcrumbPanel) {
        super(null);
        this.setDisplayMode(displayMode);
        this.root = root;
        this.blockSize = blockSize;
        this.breadcrumbPanel = breadcrumbPanel;
        this.breadcrumbMode = ResourceController.getResourceController().getEnumProperty("outlineBreadcrumbMode", BreadcrumbMode.DEFAULT);
        this.outlineSelection = new OutlineSelection(root);
        this.visibleNodes = new VisibleOutlineNodes(root);
        this.expansionControls = new ExpansionControls(this, this.outlineSelection);
        OutlineGeometry geometry = OutlineGeometry.getInstance();
        this.navButtons = new NavigationButtons(geometry, displayMode, this.expansionControls);
        this.blockPanel = new JPanel(null);
        this.blockPanel.setOpaque(false);
        this.add(this.blockPanel);
        this.blockLayout = new OutlineBlockLayout(this.blockCache, this.visibleNodes, geometry, blockSize, this);
        this.focusManager = new OutlineFocusManager(this, breadcrumbPanel, this.outlineSelection);
        this.geometryListener = this::handleGeometryChange;
        this.outlinePropertyListener = this::handleOutlinePropertyChange;
        this.setFocusable(true);
        this.setupKeyBindings();
        this.visibleBlockRenderer = new VisibleBlockRenderer(this.blockLayout, this.blockCache, this.blockPanel, this.visibleNodes, this.navButtons, this.focusManager, this::getWidth, this::updatePreferredSize, this::refreshUI, this::updateFirstVisibleNodeId, this::isNodeInBreadcrumbArea);
        this.breadcrumbLayout = new BreadcrumbLayout(breadcrumbPanel, this.visibleNodes, this.navButtons, this.outlineSelection, this::isSelectionDrivenBreadcrumbMode, this::isNodeInBreadcrumbArea, this::setBreadcrumbHeight, this.blockPanel);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        int blockPanelY = this.visibleNodes.getBlockPanelY();
        int width = this.getWidth();
        int height = Math.max(0, this.getHeight() - blockPanelY);
        this.blockPanel.setBounds(0, blockPanelY, width, height);
        this.blockCache.setBlockWidhts(width);
    }

    private int calculateBlockPanelY() {
        if (!this.isSelectionDrivenBreadcrumbMode()) {
            return BreadcrumbPanel.BREADCRUMB_BOTTOM_MARGIN;
        }
        return this.calculateBreadcrumbHeight();
    }

    private int calculateBreadcrumbHeight() {
        return BreadcrumbPanel.BREADCRUMB_BOTTOM_MARGIN + OutlineGeometry.getInstance().rowHeight * this.breadcrumbPanel.getCurrentBreadcrumbNodeCount();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.geometryListenerRegistered) {
            OutlineGeometry.registerListener(this.geometryListener);
            this.geometryListenerRegistered = true;
        }
        if (!this.outlinePropertyListenerRegistered) {
            ResourceController.getResourceController().addPropertyChangeListener(this.outlinePropertyListener);
            this.outlinePropertyListenerRegistered = true;
        }
    }

    @Override
    public void removeNotify() {
        if (this.geometryListenerRegistered) {
            OutlineGeometry.unregisterListener(this.geometryListener);
            this.geometryListenerRegistered = false;
        }
        if (this.outlinePropertyListenerRegistered) {
            ResourceController.getResourceController().removePropertyChangeListener(this.outlinePropertyListener);
            this.outlinePropertyListenerRegistered = false;
        }
        super.removeNotify();
    }

    private void handleGeometryChange(OutlineGeometry geometry) {
        if (geometry == null) {
            return;
        }
        this.blockLayout.updateGeometry(geometry);
        this.navButtons.updateGeometry(geometry);
        TreeNode hoveredNode = this.visibleNodes.getHoveredNode();
        String firstVisibleNodeId = this.visibleNodes.getFirstVisibleNodeId();
        int firstVisibleIndex = this.visibleNodes.findNodeIndexById(firstVisibleNodeId);
        if (firstVisibleIndex < 0) {
            firstVisibleIndex = 0;
        }
        List<TreeNode> breadcrumbNodes = this.breadcrumbPanel.getCurrentBreadcrumbNodes();
        this.blockPanel.removeAll();
        this.blockPanel.setComponentOrientation(geometry.outlineTextOrientation);
        this.blockCache.clear();
        this.blockLayout.resetCachedMaxWidth();
        this.resetBlockCache();
        this.visibleNodes.setHoveredNode(hoveredNode);
        this.breadcrumbPanel.setComponentOrientation(geometry.outlineTextOrientation);
        this.breadcrumbPanel.update(breadcrumbNodes, true);
        int visibleCount = this.visibleNodes.getVisibleNodeCount();
        if (this.viewport != null && visibleCount > 0) {
            int clampedIndex = Math.min(firstVisibleIndex, visibleCount - 1);
            this.updateVisibleBlocks(clampedIndex);
        } else {
            this.revalidate();
            this.repaint();
        }
        AuxillaryEditorSplitPane pane = (AuxillaryEditorSplitPane)SwingUtilities.getAncestorOfClass(AuxillaryEditorSplitPane.class, this);
        if (pane != null) {
            pane.changeAuxComponentSide(OutlineGeometry.getInstance().isRightToLeft() ? "right" : "left");
        }
    }

    private void handleOutlinePropertyChange(String propertyName, String newValue, String oldValue) {
        if ("useColoredOutlineItems".equals(propertyName)) {
            this.refreshColoredOutlineItems();
        } else if ("outlineBreadcrumbMode".equals(propertyName)) {
            this.setBreadcrumbMode(BreadcrumbMode.valueOf(newValue));
        }
    }

    private void refreshColoredOutlineItems() {
        for (BlockPanel panel : this.blockCache.blockPanels()) {
            panel.rebuildNodeButtons();
        }
        this.breadcrumbPanel.updateNodeButtons();
        this.breadcrumbLayout.reattachNavigationButtons();
        this.revalidate();
        this.repaint();
    }

    private void setupKeyBindings() {
        new OutlineActions(() -> this).installOn(this, 1);
    }

    void setBackgroundColorSupplier(Supplier<Color> backgroundColorSupplier) {
        this.backgroundColorSupplier = backgroundColorSupplier;
    }

    @Override
    public Color getBackground() {
        Color suppliedColor;
        if (this.backgroundColorSupplier != null && (suppliedColor = this.backgroundColorSupplier.get()) != null) {
            return suppliedColor;
        }
        return super.getBackground();
    }

    BreadcrumbMode getBreadcrumbMode() {
        return this.breadcrumbMode;
    }

    void setBreadcrumbMode(BreadcrumbMode newMode) {
        BreadcrumbMode resolvedMode = newMode;
        if (this.breadcrumbMode == resolvedMode) {
            return;
        }
        this.breadcrumbMode = resolvedMode;
        this.visibleNodes.setBlockPanelY(this.calculateBlockPanelY());
        if (this.isSelectionDrivenBreadcrumbMode()) {
            this.updateBreadcrumbForSelection();
        } else {
            this.updateBreadcrumbForCurrentFirstVisibleNode();
        }
        this.updateVisibleNodes(this.displayMode == OutlineDisplayMode.MAP_VIEW_SYNC ? ScrollMode.SIBLINGS : ScrollMode.SINGLE_ITEM);
    }

    boolean isSelectionDrivenBreadcrumbMode() {
        return this.breadcrumbMode == BreadcrumbMode.FOLLOW_SELECTED_ITEM;
    }

    void synchronizeSelectionButton(boolean requestFocusInWindow) {
        this.selectionBridge.synchronizeOutlineSelection(SelectionSynchronizationTrigger.OUTLINE, requestFocusInWindow);
        this.focusManager.focusSelectionButtonLater(requestFocusInWindow);
    }

    void setScrollPane(JScrollPane scroll) {
        this.viewport = new OutlineViewport(scroll, this.visibleNodes, this.blockSize);
        if (this.visibleBlockRenderer != null) {
            this.visibleBlockRenderer.setViewport(this.viewport);
        }
        this.resetBlockCache();
    }

    void setBreadcrumbHeight(int height) {
        this.visibleNodes.setBreadcrumbHeight(height);
        this.visibleNodes.setBlockPanelY(this.calculateBlockPanelY());
    }

    void updateVisibleBlocks() {
        if (this.visibleBlockRenderer == null) {
            return;
        }
        this.visibleBlockRenderer.render();
    }

    void updateVisibleBlocks(int startFromNodeIndex) {
        if (this.visibleBlockRenderer == null) {
            return;
        }
        this.visibleBlockRenderer.renderFromIndex(startFromNodeIndex);
    }

    private void resetBlockCache() {
        if (this.visibleBlockRenderer != null) {
            this.visibleBlockRenderer.resetCachedRange();
        }
    }

    boolean isNodeFullyVisibleInViewport(TreeNode node) {
        if (this.viewport == null || node == null) {
            return false;
        }
        int index = this.visibleNodes.findNodeIndexInVisibleList(node);
        if (index < 0) {
            return false;
        }
        int first = this.calculateFirstVisibleNodeIndex();
        int currentBreadcrumbRows = this.getBreadcrumbRowsForIndex(first);
        int contentRows = this.getContentRowsForBreadcrumbRows(currentBreadcrumbRows);
        int last = Math.max(first, first + contentRows - 1);
        return index >= first && index <= last;
    }

    private void updatePreferredSize() {
        this.blockLayout.updateBlockPreferredSize(this.blockPanel);
        Dimension blockPreferredSize = this.blockPanel.getPreferredSize();
        int contentOffset = this.visibleNodes.getBlockPanelY();
        int breadcrumbHeight = this.visibleNodes.getBreadcrumbHeight();
        int preferredHeight = Math.max(blockPreferredSize.height + contentOffset + this.getParent().getHeight() - OutlineGeometry.getInstance().rowHeight, breadcrumbHeight);
        Dimension panelPreferredSize = new Dimension(blockPreferredSize.width, preferredHeight);
        this.setPreferredSize(panelPreferredSize);
    }

    private void refreshUI() {
        this.viewport.refreshViewport();
        this.repaint();
    }

    private void updateFirstVisibleNodeId() {
        if (this.viewport == null) {
            return;
        }
        int index = this.calculateFirstVisibleNodeIndex();
        int count = this.visibleNodes.getVisibleNodeCount();
        if (count == 0) {
            this.visibleNodes.setFirstVisibleNodeId(null);
            return;
        }
        index = Math.max(0, Math.min(index, count - 1));
        this.visibleNodes.setFirstVisibleNodeId(this.visibleNodes.getNodeIdAtVisibleIndex(index));
    }

    void setSelectedNode(TreeNode node, boolean requestFocus) {
        this.setSelectedNode(node, requestFocus, ScrollMode.SINGLE_ITEM);
    }

    private void setSelectedNode(TreeNode node, boolean requestFocus, ScrollMode scrollMode) {
        if (node != this.outlineSelection.getSelectedNode()) {
            TreeNode hoveredNode = this.visibleNodes.getHoveredNode();
            if (hoveredNode != node && hoveredNode != null) {
                this.onContentButtonHovered(node);
            }
            this.selectionHistory.record(node);
            this.outlineSelection.selectNode(node);
            if (this.isSelectionDrivenBreadcrumbMode()) {
                this.updateBreadcrumbForSelection();
            }
            this.repaint();
            if (this.visibleNodes.findNodeIndexInVisibleList(node) < 0) {
                TreeNode preservedHoveredNode = this.visibleNodes.getHoveredNode();
                this.hardResetBlocksPreservingHovered(preservedHoveredNode);
            }
            if (scrollMode == ScrollMode.SINGLE_ITEM) {
                boolean visible = this.isNodeFullyVisibleInViewport(node);
                if (!this.isSelectionDrivenBreadcrumbMode() && this.isNodeInBreadcrumbArea(node)) {
                    visible = true;
                }
                if (!visible) {
                    this.ensureSelectionVisible(scrollMode);
                }
            } else if (scrollMode == ScrollMode.SIBLINGS) {
                this.ensureSelectionVisible(scrollMode);
            }
        } else if (this.isSelectionDrivenBreadcrumbMode()) {
            this.updateBreadcrumbForSelection();
        }
        this.focusSelectionButtonLater(requestFocus);
    }

    void toggleBreadcrumbNodeExpansion(TreeNode node, boolean requestFocus) {
        this.setSelectedNode(node, requestFocus);
        this.toggleExpandSelected();
    }

    OutlineSelection getOutlineSelection() {
        return this.outlineSelection;
    }

    int getRowHeight() {
        return OutlineGeometry.getInstance().rowHeight;
    }

    int calcTextButtonX(int level) {
        return OutlineGeometry.getInstance().calculateNodeButtonX(this.displayMode.showsNavigationButtons(), level);
    }

    int getViewportWidth() {
        return this.viewport != null ? this.viewport.getViewportWidth() : this.getWidth();
    }

    VisibleOutlineNodes getVisibleNodes() {
        return this.visibleNodes;
    }

    TreeNode getRoot() {
        return this.root;
    }

    void hardResetBlocksPreservingHovered(TreeNode preservedHoveredNode) {
        this.blockPanel.removeAll();
        this.blockCache.clear();
        this.visibleNodes.setHoveredNode(preservedHoveredNode);
        this.updateVisibleBlocks();
    }

    boolean isNodeButtonFocused() {
        return this.focusManager.isNodeButtonFocused();
    }

    void selectMapNodeById(String nodeId) {
        if (this.selectionBridge != null) {
            this.selectionBridge.selectMapNodeById(nodeId);
        }
    }

    @Override
    public void selectSelectedInMap() {
        TreeNode selected;
        TreeNode treeNode = selected = this.outlineSelection != null ? this.outlineSelection.getSelectedNode() : null;
        if (selected != null) {
            this.selectMapNodeById(selected.getId());
        }
    }

    void setSelectionBridge(OutlineSelectionBridge bridge) {
        this.selectionBridge = bridge;
        this.breadcrumbPanel.setSelectionBridge(bridge);
        this.breadcrumbLayout.setSelectionBridge(bridge);
    }

    void updateNodeTitle(TreeNode node) {
        for (Component comp : this.breadcrumbPanel.getComponents()) {
            NodeButton btn;
            if (!(comp instanceof NodeButton) || (btn = (NodeButton)comp).getNode() != node) continue;
            btn.updateLabel();
            int level = node.getLevel();
            if (level >= 0) {
                int x = OutlineGeometry.getInstance().calculateNodeButtonX(this.displayMode.showsNavigationButtons(), level);
                int rightEdge = x + btn.getWidth();
                this.blockLayout.recordButtonRightEdge(rightEdge);
                btn.setBounds(x, btn.getY(), btn.getPreferredSize().width, OutlineGeometry.getInstance().rowHeight);
                RightToLeftLayout.applyToSingleComponent(btn);
            }
            this.breadcrumbPanel.revalidate();
            this.breadcrumbPanel.repaint();
            break;
        }
        Iterator<Integer> iterator = this.blockCache.keySet().iterator();
        block1: while (iterator.hasNext()) {
            int blockIndex = (Integer)iterator.next();
            BlockPanel panel = this.blockCache.get(blockIndex);
            if (panel == null) continue;
            for (Component comp : panel.getComponents()) {
                NodeButton btn;
                if (!(comp instanceof NodeButton) || (btn = (NodeButton)comp).getNode() != node) continue;
                btn.updateLabel();
                int level = node.getLevel();
                if (level >= 0) {
                    int x = OutlineGeometry.getInstance().calculateNodeButtonX(this.displayMode.showsNavigationButtons(), level);
                    int rightEdge = x + btn.getWidth();
                    this.blockLayout.recordButtonRightEdge(rightEdge);
                    btn.setBounds(x, btn.getY(), btn.getPreferredSize().width, OutlineGeometry.getInstance().rowHeight);
                    RightToLeftLayout.applyToSingleComponent(btn);
                }
                panel.revalidate();
                panel.repaint();
                continue block1;
            }
        }
        this.updatePreferredSize();
        this.refreshUI();
    }

    void rebuildFromNode(String anchorNodeId) {
        if (this.viewport == null) {
            return;
        }
        Component prevFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean prevInOutline = this.focusManager.isWithinOutline(prevFocus);
        this.updateVisibleNodes();
        int firstFullyVisibleNodeIndex = this.calculateFirstVisibleNodeIndex();
        List<TreeNode> state = this.breadcrumbLayout.calculateState(firstFullyVisibleNodeIndex);
        TreeNode preservedHovered = this.visibleNodes.getHoveredNode();
        this.blockPanel.removeAll();
        this.blockCache.clear();
        this.blockLayout.resetCachedMaxWidth();
        boolean wasHoveredNodeContainedInBreadcrumb = this.visibleNodes.isHoveredNodeContainedInBreadcrumb();
        this.visibleNodes.setHoveredNode(preservedHovered);
        if (state != null) {
            this.breadcrumbLayout.applyState(state);
            this.updateVisibleBlocks(firstFullyVisibleNodeIndex);
            TreeNode hovered = this.visibleNodes.getHoveredNode();
            if (hovered != null && !wasHoveredNodeContainedInBreadcrumb && this.visibleNodes.findNodeIndexInVisibleList(hovered) < 0) {
                this.visibleNodes.setHoveredNode(null);
            }
            this.ensureValidSelectionOrSyncFromMap();
            this.focusManager.restoreFocusIfNeeded(prevInOutline);
            return;
        }
        int anchorIndex = this.visibleNodes.findNodeIndexById(anchorNodeId);
        if (anchorIndex < 0) {
            this.updateVisibleBlocksAndBreadcrumb();
            this.ensureValidSelectionOrSyncFromMap();
            this.focusManager.restoreFocusIfNeeded(prevInOutline);
            return;
        }
        this.blockPanel.removeAll();
        this.blockCache.clear();
        this.blockLayout.resetCachedMaxWidth();
        this.navButtons.hideNavigationButtons();
        this.visibleNodes.setHoveredNode(preservedHovered);
        this.updateVisibleBlocks();
        TreeNode hovered = this.visibleNodes.getHoveredNode();
        if (hovered != null && this.visibleNodes.findNodeIndexInVisibleList(hovered) < 0) {
            this.visibleNodes.setHoveredNode(null);
        }
        this.ensureValidSelectionOrSyncFromMap();
        this.focusManager.restoreFocusIfNeeded(prevInOutline);
    }

    private void ensureValidSelectionOrSyncFromMap() {
        TreeNode selected;
        TreeNode treeNode = selected = this.outlineSelection != null ? this.outlineSelection.getSelectedNode() : null;
        if (selected == null) {
            return;
        }
        if (!this.isNodeAttachedToRoot(selected) && this.selectionBridge != null) {
            this.selectionBridge.synchronizeOutlineSelection(SelectionSynchronizationTrigger.MAP, false);
        }
    }

    private boolean isNodeAttachedToRoot(TreeNode node) {
        for (TreeNode n = node; n != null; n = n.getParent()) {
            if (n != this.root) continue;
            return true;
        }
        return false;
    }

    void onContentButtonHovered(TreeNode node) {
        if (node != null && !node.getChildren().isEmpty() && (this.visibleNodes.isHoveredNodeContainedInBreadcrumb() || node != this.visibleNodes.getHoveredNode())) {
            if (!this.isNodeFullyVisibleInViewport(node)) {
                return;
            }
            this.visibleNodes.setHoveredNode(node, false);
            int nodeIndex = this.visibleNodes.findNodeIndexInVisibleList(node);
            this.navButtons.attachToNode(node, this.blockPanel, nodeIndex, node.getLevel());
            this.repaint();
        }
    }

    void showNavigationButtonsForBreadcrumb(TreeNode node, int rowIndex) {
        this.visibleNodes.setHoveredNode(node, true);
        this.navButtons.attachToNode(node, this.breadcrumbPanel, rowIndex, rowIndex);
    }

    @Override
    public void navigateUp() {
        TreeNode prev;
        int currentIndex;
        TreeNode currentSelected = this.outlineSelection.getSelectedNode();
        if (currentSelected != null && (currentIndex = this.visibleNodes.findNodeIndexInVisibleList(currentSelected)) > 0 && (prev = this.visibleNodes.getNodeAtVisibleIndex(currentIndex - 1)) != null) {
            this.setSelectedNode(prev, true);
        }
    }

    void focusSelectionButtonLater(boolean requestFocus) {
        this.focusManager.focusSelectionButtonLater(requestFocus);
    }

    @Override
    public void navigateDown() {
        int breadcrumbRowsAtTentative;
        int contentRowCountAfterTentative;
        int maxFeasibleFirstIndex;
        TreeNode currentSelected = this.outlineSelection.getSelectedNode();
        if (currentSelected == null || this.viewport == null) {
            return;
        }
        int currentIndex = this.visibleNodes.findNodeIndexInVisibleList(currentSelected);
        int size = this.visibleNodes.getVisibleNodeCount();
        if (currentIndex < 0 || currentIndex >= size - 1) {
            return;
        }
        int nextIndex = currentIndex + 1;
        TreeNode nextNode = this.visibleNodes.getNodeAtVisibleIndex(nextIndex);
        if (nextNode == null) {
            return;
        }
        if (this.isNodeInBreadcrumbArea(nextNode) || this.isNodeFullyVisibleInViewport(nextNode)) {
            this.setSelectedNode(nextNode, true);
            return;
        }
        int currentFirstVisibleIndex = this.calculateFirstVisibleNodeIndex();
        int currentBreadcrumbRowCount = this.getBreadcrumbRowsForIndex(currentFirstVisibleIndex);
        int nextBreadcrumbRowCount = this.getBreadcrumbRowsForIndex(Math.min(currentFirstVisibleIndex + 1, size - 1));
        int breadcrumbRowDelta = nextBreadcrumbRowCount - currentBreadcrumbRowCount;
        int minimalScrollRows = Math.max(0, 1 + breadcrumbRowDelta);
        int tentativeFirstIndex = Math.min(currentFirstVisibleIndex + minimalScrollRows, size - 1);
        int targetFirstIndex = Math.min(tentativeFirstIndex, maxFeasibleFirstIndex = Math.max(0, size - (contentRowCountAfterTentative = this.getContentRowsForBreadcrumbRows(breadcrumbRowsAtTentative = this.getBreadcrumbRowsForIndex(tentativeFirstIndex)))));
        List<TreeNode> plannedBreadcrumbState = this.breadcrumbLayout.calculateState(targetFirstIndex);
        if (plannedBreadcrumbState != null) {
            this.breadcrumbLayout.applyState(plannedBreadcrumbState);
            this.updateVisibleBlocks(targetFirstIndex);
        }
        this.setSelectedNode(nextNode, true);
    }

    private void updateBreadcrumbForSelection() {
        int firstVisibleNodeIndex = this.calculateFirstVisibleNodeIndex();
        int breadcrumbNodeCountBefore = this.breadcrumbPanel.getCurrentBreadcrumbNodeCount();
        this.breadcrumbLayout.updateForSelection();
        int breadcrumbNodeCountAfter = this.breadcrumbPanel.getCurrentBreadcrumbNodeCount();
        if (breadcrumbNodeCountBefore != breadcrumbNodeCountAfter) {
            int newFirstVisibleNodeIndex = Math.max(0, firstVisibleNodeIndex + breadcrumbNodeCountAfter - breadcrumbNodeCountBefore);
            this.viewport.setViewPosition(newFirstVisibleNodeIndex, 0);
        }
        this.revalidate();
    }

    private void updateBreadcrumbForCurrentFirstVisibleNode() {
        int firstVisibleIndex = 0;
        if (this.viewport != null) {
            firstVisibleIndex = this.calculateFirstVisibleNodeIndex();
        }
        this.breadcrumbLayout.updateForFirstVisibleIndex(firstVisibleIndex);
    }

    private int getCurrentBreadcrumbRowCount() {
        int rowHeight = OutlineGeometry.getInstance().rowHeight;
        if (rowHeight <= 0) {
            return 0;
        }
        int height = this.visibleNodes.getBreadcrumbHeight();
        if (height <= 0) {
            return 0;
        }
        return Math.max(0, height / rowHeight);
    }

    private int getBreadcrumbRowsForIndex(int visibleIndex) {
        if (this.isSelectionDrivenBreadcrumbMode()) {
            return this.getCurrentBreadcrumbRowCount();
        }
        return this.getNodeLevelAtVisibleIndex(visibleIndex);
    }

    @Override
    public void navigatePageUp() {
        TreeNode currentSelected = this.outlineSelection.getSelectedNode();
        if (currentSelected != null) {
            TreeNode newFirstNode;
            int breadcrumbRowsAtTentative;
            int contentRowCountAfterTentative;
            int maxFeasibleFirstIndex;
            int currentFirstVisibleIndex;
            int currentIndex = this.visibleNodes.findNodeIndexInVisibleList(currentSelected);
            int pageSize = this.getContentRows();
            int size = this.visibleNodes.getVisibleNodeCount();
            int n = currentFirstVisibleIndex = this.viewport != null ? this.calculateFirstVisibleNodeIndex() : 0;
            if (currentIndex > currentFirstVisibleIndex) {
                TreeNode firstVisibleNode = this.visibleNodes.getNodeAtVisibleIndex(currentFirstVisibleIndex);
                if (firstVisibleNode != null) {
                    this.setSelectedNode(firstVisibleNode, true);
                }
                this.updateVisibleBlocksAndBreadcrumb();
                return;
            }
            int tentativeFirstIndex = Math.max(0, currentFirstVisibleIndex - pageSize + 1);
            int targetFirstIndex = Math.min(tentativeFirstIndex, maxFeasibleFirstIndex = Math.max(0, size - (contentRowCountAfterTentative = this.getContentRowsForBreadcrumbRows(breadcrumbRowsAtTentative = this.getBreadcrumbRowsForIndex(tentativeFirstIndex)))));
            List<TreeNode> plannedBreadcrumbState = this.breadcrumbLayout.calculateState(targetFirstIndex);
            if (plannedBreadcrumbState != null) {
                this.breadcrumbLayout.applyState(plannedBreadcrumbState);
                this.updateVisibleBlocks(targetFirstIndex);
            }
            if ((newFirstNode = this.visibleNodes.getNodeAtVisibleIndex(targetFirstIndex)) != null) {
                this.setSelectedNode(newFirstNode, true);
            }
        }
    }

    @Override
    public void navigatePageDown() {
        TreeNode currentSelected = this.outlineSelection.getSelectedNode();
        if (currentSelected != null) {
            int newLastVisibleIndex;
            TreeNode newLastVisibleNode;
            int breadcrumbRowsAtTentative;
            int contentRowCountAfterTentative;
            int maxFeasibleFirstIndex;
            int currentFirstVisibleIndex;
            int currentIndex = this.visibleNodes.findNodeIndexInVisibleList(currentSelected);
            int pageSize = this.getContentRows();
            int size = this.visibleNodes.getVisibleNodeCount();
            int lastVisibleIndex = Math.min(size - 1, (currentFirstVisibleIndex = this.viewport != null ? this.calculateFirstVisibleNodeIndex() : 0) + pageSize - 1);
            if (currentIndex < lastVisibleIndex) {
                TreeNode lastVisibleNode = this.visibleNodes.getNodeAtVisibleIndex(lastVisibleIndex);
                if (lastVisibleNode != null) {
                    this.setSelectedNode(lastVisibleNode, true);
                }
                this.updateVisibleBlocksAndBreadcrumb();
                return;
            }
            int tentativeFirstIndex = Math.min(size - 1, currentFirstVisibleIndex + pageSize - 1);
            int targetFirstIndex = Math.min(tentativeFirstIndex, maxFeasibleFirstIndex = Math.max(0, size - (contentRowCountAfterTentative = this.getContentRowsForBreadcrumbRows(breadcrumbRowsAtTentative = this.getBreadcrumbRowsForIndex(tentativeFirstIndex)))));
            List<TreeNode> plannedBreadcrumbState = this.breadcrumbLayout.calculateState(targetFirstIndex);
            if (plannedBreadcrumbState != null) {
                this.breadcrumbLayout.applyState(plannedBreadcrumbState);
                this.updateVisibleBlocks(targetFirstIndex);
            }
            if ((newLastVisibleNode = this.visibleNodes.getNodeAtVisibleIndex(newLastVisibleIndex = Math.min(size - 1, targetFirstIndex + contentRowCountAfterTentative - 1))) != null) {
                this.setSelectedNode(newLastVisibleNode, true);
            }
        }
    }

    @Override
    public void toggleExpandSelected() {
        TreeNode node = this.outlineSelection != null ? this.outlineSelection.getSelectedNode() : null;
        this.toggleNodeExpansion(node);
    }

    public void toggleNodeExpansion(TreeNode node) {
        if (node == null || node.childCount() == 0 || node.getLevel() == 0) {
            return;
        }
        if (node.isExpanded()) {
            int minimalLevel = this.getDisplayMode().getMinimalOutlineLevel();
            if (node.getLevel() >= minimalLevel) {
                if (!this.isSelectionDrivenBreadcrumbMode() && this.isNodeInBreadcrumbArea(node)) {
                    this.updateVisibleBlocksAndBreadcrumb(this.visibleNodes.findNodeIndexById(node.getId()));
                }
                this.expansionControls.collapseNode(node);
            }
        } else {
            this.expansionControls.expandNode(node);
        }
    }

    @Override
    public void expandSelectedMore() {
        TreeNode node;
        TreeNode treeNode = node = this.outlineSelection != null ? this.outlineSelection.getSelectedNode() : null;
        if (node == null) {
            return;
        }
        this.expansionControls.expandNodeMore(node);
    }

    @Override
    public void reduceSelectedExpansion() {
        TreeNode node;
        TreeNode treeNode = node = this.outlineSelection != null ? this.outlineSelection.getSelectedNode() : null;
        if (node == null) {
            return;
        }
        this.expansionControls.reduceNodeExpansion(node);
    }

    @Override
    public void collapseOrGoToParent() {
        TreeNode node;
        TreeNode treeNode = node = this.outlineSelection != null ? this.outlineSelection.getSelectedNode() : null;
        if (node == null) {
            return;
        }
        if (node.isExpanded() && (this.isSelectionDrivenBreadcrumbMode() || !this.isNodeInBreadcrumbArea(node))) {
            this.expansionControls.collapseNode(node);
        } else {
            TreeNode parent = node.getParent();
            this.setSelectedNode(parent, true);
        }
    }

    @Override
    public void expandOrGoToChild() {
        TreeNode node;
        TreeNode treeNode = node = this.outlineSelection != null ? this.outlineSelection.getSelectedNode() : null;
        if (node == null || node.getChildren().isEmpty()) {
            return;
        }
        if (!node.isExpanded()) {
            this.expansionControls.expandNode(node);
        } else {
            TreeNode targetChild = this.selectionHistory.preferredChild(node);
            this.setSelectedNode(targetChild, true);
        }
    }

    private int getContentRows() {
        if (this.viewport != null) {
            int breadcrumbHeight = this.visibleNodes.getBreadcrumbHeight();
            int viewportHeight = this.viewport.getViewportHeight() - breadcrumbHeight;
            return Math.max(1, viewportHeight / OutlineGeometry.getInstance().rowHeight - 1);
        }
        return 10;
    }

    private int getContentRowsForBreadcrumbRows(int breadcrumbRowCount) {
        if (this.viewport != null) {
            int viewportHeight = this.viewport.getViewportHeight() - this.breadcrumbPanel.preferredBreadCrumbHeight(breadcrumbRowCount);
            return Math.max(1, viewportHeight / OutlineGeometry.getInstance().rowHeight - 1);
        }
        return 10;
    }

    private int getNodeLevelAtVisibleIndex(int visibleIndex) {
        TreeNode node = this.visibleNodes.getNodeAtVisibleIndex(visibleIndex);
        return node != null ? node.getLevel() : 0;
    }

    void updateVisibleNodes(ScrollMode scrollMode) {
        this.updateVisibleNodes();
        this.blockPanel.removeAll();
        this.blockCache.clear();
        this.ensureSelectionVisible(scrollMode);
    }

    private void updateVisibleNodes() {
        TreeNode node;
        this.visibleNodes.updateVisibleNodes();
        TreeNode selectedNode = this.outlineSelection.getSelectedNode();
        if (selectedNode != null && (node = this.visibleNodes.findNodeById(selectedNode.getId())) != selectedNode) {
            this.outlineSelection.selectNode(node);
        }
    }

    void updateVisibleBlocksAndBreadcrumb() {
        int firstFullyVisibleNodeIndex = this.calculateFirstVisibleNodeIndex();
        this.updateVisibleBlocksAndBreadcrumb(firstFullyVisibleNodeIndex);
    }

    private void updateVisibleBlocksAndBreadcrumb(int firstFullyVisibleNodeIndex) {
        Component prevFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean prevInOutline = this.focusManager.isWithinOutline(prevFocus);
        List<TreeNode> state = this.breadcrumbLayout.calculateState(firstFullyVisibleNodeIndex);
        if (state != null) {
            int oldBreadcrumbHeight = this.visibleNodes.getBreadcrumbHeight();
            this.breadcrumbLayout.applyState(state);
            int newBreadcrumbHeight = this.visibleNodes.getBreadcrumbHeight();
            if (newBreadcrumbHeight != oldBreadcrumbHeight) {
                TreeNode preservedHovered = this.visibleNodes.getHoveredNode();
                this.hardResetBlocksPreservingHovered(preservedHovered);
            }
            this.updateVisibleBlocks(firstFullyVisibleNodeIndex);
        } else {
            this.updateVisibleBlocks();
        }
        this.focusManager.restoreFocusIfNeeded(prevInOutline);
    }

    void ensureSelectionVisible(ScrollMode scrollMode) {
        int maxFeasibleFirst;
        int cr;
        int targetFirst;
        boolean haveButtons;
        if (this.viewport == null) {
            return;
        }
        TreeNode selected = this.outlineSelection != null ? this.outlineSelection.getSelectedNode() : null;
        int selectedIndex = selected != null ? this.visibleNodes.findNodeIndexInVisibleList(selected) : -1;
        int first = this.calculateFirstVisibleNodeIndex();
        int currentBreadcrumbRows = this.getBreadcrumbRowsForIndex(first);
        int contentRows = this.getContentRowsForBreadcrumbRows(currentBreadcrumbRows);
        int last = Math.max(first, first + contentRows - 1);
        boolean bl = haveButtons = this.blockPanel.getComponentCount() > 0 || !this.blockCache.isEmpty();
        if (!haveButtons && contentRows <= 1) {
            this.updateVisibleBlocks();
            return;
        }
        int visibleCount = this.visibleNodes.getVisibleNodeCount();
        if (haveButtons && (selected == null || selectedIndex < 0 || scrollMode == ScrollMode.SINGLE_ITEM && (!this.isSelectionDrivenBreadcrumbMode() && this.isNodeInBreadcrumbArea(selected) || selectedIndex >= first && selectedIndex <= last))) {
            return;
        }
        if (selected == null || selectedIndex < 0) {
            targetFirst = first;
        } else if (scrollMode == ScrollMode.SIBLINGS && selected.getParent() != null) {
            List<TreeNode> siblings = selected.getParent().getChildren();
            TreeNode firstSibling = siblings.get(0);
            int blockStartIndex = this.visibleNodes.findNodeIndexInVisibleList(firstSibling);
            int availableBreadcrumbRows = this.getBreadcrumbRowsForIndex(blockStartIndex);
            int availableContentRows = this.getContentRowsForBreadcrumbRows(availableBreadcrumbRows);
            int selectedChildCount = selected.childCount();
            int requiredVisibleRows = 1 + selectedChildCount;
            int blockEndExclusiveIndex = blockStartIndex + siblings.size() + selectedChildCount;
            int maxStartIndex = blockEndExclusiveIndex - availableContentRows;
            if (maxStartIndex < blockStartIndex) {
                maxStartIndex = blockStartIndex;
            }
            if (availableContentRows <= 0) {
                targetFirst = blockStartIndex;
            } else if (availableContentRows < requiredVisibleRows) {
                targetFirst = Math.max(blockStartIndex, Math.min(selectedIndex, maxStartIndex));
            } else {
                int extraRowCapacity = availableContentRows - requiredVisibleRows;
                int balancedStartIndex = selectedIndex - extraRowCapacity / 2;
                targetFirst = Math.max(blockStartIndex, Math.min(balancedStartIndex, maxStartIndex));
            }
            this.visibleNodes.setBlockPanelY(this.calculateBlockPanelY());
        } else if (!this.isSelectionDrivenBreadcrumbMode() && this.isNodeInBreadcrumbArea(selected)) {
            targetFirst = first;
        } else if (selectedIndex < first) {
            int desiredFirst = Math.max(0, selectedIndex);
            int br = this.getBreadcrumbRowsForIndex(desiredFirst);
            cr = this.getContentRowsForBreadcrumbRows(br);
            maxFeasibleFirst = Math.max(0, visibleCount - cr);
            targetFirst = Math.min(desiredFirst, maxFeasibleFirst);
        } else if (selectedIndex > last) {
            int desiredFirst = Math.max(0, selectedIndex - (contentRows - 1));
            int br = this.getBreadcrumbRowsForIndex(desiredFirst);
            cr = this.getContentRowsForBreadcrumbRows(br);
            maxFeasibleFirst = Math.max(0, visibleCount - cr);
            targetFirst = Math.min(desiredFirst, maxFeasibleFirst);
        } else {
            targetFirst = first;
        }
        List<TreeNode> planned = this.breadcrumbLayout.calculateState(targetFirst);
        if (planned != null) {
            int oldBreadcrumbHeight = this.visibleNodes.getBreadcrumbHeight();
            this.breadcrumbLayout.applyState(planned);
            int newBreadcrumbHeight = this.visibleNodes.getBreadcrumbHeight();
            if (newBreadcrumbHeight != oldBreadcrumbHeight) {
                TreeNode preservedHovered = this.visibleNodes.getHoveredNode();
                this.hardResetBlocksPreservingHovered(preservedHovered);
            }
            this.updateVisibleBlocks(targetFirst);
        } else {
            this.updateVisibleBlocks();
        }
    }

    private int calculateFirstVisibleNodeIndex() {
        int rowHeight;
        int firstVisibleIndex;
        int viewY = this.viewport.getViewY();
        int effectiveViewY = viewY + this.visibleNodes.getBreadcrumbHeight() - this.visibleNodes.getBlockPanelY();
        if (effectiveViewY < 0) {
            effectiveViewY = 0;
        }
        if ((firstVisibleIndex = (effectiveViewY + (rowHeight = OutlineGeometry.getInstance().rowHeight) - 1) / rowHeight) >= 1) {
            return firstVisibleIndex;
        }
        if (this.isSelectionDrivenBreadcrumbMode() || this.visibleNodes.getVisibleNodeCount() < 2) {
            return 0;
        }
        return 1;
    }

    boolean isNodeInBreadcrumbArea(TreeNode node) {
        List<TreeNode> crumbs = this.breadcrumbPanel.getCurrentBreadcrumbNodes();
        return crumbs != null && crumbs.contains(node);
    }

    Collection<BlockPanel> getBlockPanels() {
        return this.blockCache.blockPanels();
    }

    OutlineDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    void performInitialSetup() {
        if (this.isSelectionDrivenBreadcrumbMode()) {
            this.updateBreadcrumbForSelection();
        }
        this.updateVisibleBlocks();
    }

    void synchronizeOutlineSelection(TreeNode target, SelectionSynchronizationTrigger synchronizationTrigger, boolean requestFocus) {
        ScrollMode scrollMode;
        if (this.displayMode == OutlineDisplayMode.MAP_VIEW_SYNC && synchronizationTrigger == SelectionSynchronizationTrigger.MAP) {
            this.adjustExpansionLevels(target);
            scrollMode = ScrollMode.SIBLINGS;
            this.updateVisibleNodes(scrollMode);
        } else {
            target = target.findVisibleAncestorOrSelf();
            scrollMode = ScrollMode.SINGLE_ITEM;
        }
        int index = this.findVisibleIndex(target);
        boolean visible = this.isNodeVisible(target);
        if (!visible) {
            if (index < 0) {
                index = 0;
            }
            this.updateVisibleBlocks(index);
        }
        this.setSelectedNode(target, requestFocus, scrollMode);
    }

    private void adjustExpansionLevels(TreeNode node) {
        TreeNode parent = node.getParent();
        if (parent != null) {
            this.adjustExpansionLevels(parent);
        }
        node.applyExpansionLevel(1);
    }

    private int findVisibleIndex(TreeNode node) {
        for (TreeNode n = node; n != null; n = n.getParent()) {
            int idx = this.visibleNodes.findNodeIndexInVisibleList(n);
            if (idx < 0) continue;
            return idx;
        }
        return 0;
    }

    private boolean isNodeVisible(TreeNode node) {
        return !this.isSelectionDrivenBreadcrumbMode() && this.isNodeInBreadcrumbArea(node) || this.isNodeFullyVisibleInViewport(node);
    }

    void setDisplayMode(OutlineDisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    static enum ScrollMode {
        SINGLE_ITEM,
        SIBLINGS;

    }
}

