/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import org.freeplane.core.resources.ResourceController;

public class AIChatMessageStyleSettings {
    static final String CHAT_FONT_SCALING_PROPERTY = "ai_chat_font_scaling";
    private static final int DEFAULT_CHAT_FONT_SCALING = 100;
    private static final int MIN_CHAT_FONT_SCALING = 25;
    private static final int MAX_CHAT_FONT_SCALING = 400;
    private final int chatFontScaling;

    public AIChatMessageStyleSettings() {
        this(ResourceController.getResourceController());
    }

    AIChatMessageStyleSettings(ResourceController resourceController) {
        this.chatFontScaling = AIChatMessageStyleSettings.parseChatFontScaling(resourceController.getProperty(CHAT_FONT_SCALING_PROPERTY));
    }

    public int getChatFontScaling() {
        return this.chatFontScaling;
    }

    static int parseChatFontScaling(String value) {
        if (value == null || value.isEmpty()) {
            return 100;
        }
        try {
            int parsedValue = Integer.parseInt(value.trim());
            if (parsedValue < 25 || parsedValue > 400) {
                return 100;
            }
            return parsedValue;
        }
        catch (NumberFormatException exception) {
            return 100;
        }
    }
}

