/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.output.TokenUsage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.freeplane.plugin.ai.chat.AIChatModelFactory;
import org.freeplane.plugin.ai.chat.AIChatService;
import org.freeplane.plugin.ai.chat.AIProviderConfiguration;
import org.freeplane.plugin.ai.chat.ChatTokenUsageTracker;
import org.freeplane.plugin.ai.tools.AIToolSet;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummaryHandler;

public class AIChatServiceFactory {
    private AIChatServiceFactory() {
    }

    public static AIChatService createService(AIToolSet toolSet, ChatMemory chatMemory, ChatTokenUsageTracker chatTokenUsageTracker, ToolCallSummaryHandler toolCallSummaryHandler) {
        return AIChatServiceFactory.createService(toolSet, chatMemory, chatTokenUsageTracker, toolCallSummaryHandler, null, null);
    }

    public static AIChatService createService(AIToolSet toolSet, ChatMemory chatMemory, ChatTokenUsageTracker chatTokenUsageTracker, ToolCallSummaryHandler toolCallSummaryHandler, Supplier<Boolean> cancellationSupplier) {
        return AIChatServiceFactory.createService(toolSet, chatMemory, chatTokenUsageTracker, toolCallSummaryHandler, cancellationSupplier, null);
    }

    public static AIChatService createService(AIToolSet toolSet, ChatMemory chatMemory, ChatTokenUsageTracker chatTokenUsageTracker, ToolCallSummaryHandler toolCallSummaryHandler, Supplier<Boolean> cancellationSupplier, Consumer<TokenUsage> tokenUsageConsumer) {
        AIProviderConfiguration configuration = new AIProviderConfiguration();
        ChatModel chatLanguageModel = AIChatModelFactory.createChatLanguageModel(configuration);
        return new AIChatService(chatLanguageModel, toolSet, chatMemory, chatTokenUsageTracker, toolCallSummaryHandler, cancellationSupplier, tokenUsageConsumer);
    }
}

