/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationDependenciesBuildOperationType;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Actions;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;

class ResolveConfigurationResolutionBuildOperationResult
implements ResolveConfigurationDependenciesBuildOperationType.Result,
CustomOperationTraceSerialization {
    private final Supplier<? extends ResolvedComponentResult> rootSource;
    private final Lazy<AttributeContainer> lazyDesugaredAttributes;

    public ResolveConfigurationResolutionBuildOperationResult(Supplier<? extends ResolvedComponentResult> rootSource, ImmutableAttributes requestedAttributes, AttributesFactory attributesFactory) {
        this.rootSource = rootSource;
        this.lazyDesugaredAttributes = Lazy.unsafe().of(() -> ResolveConfigurationResolutionBuildOperationResult.desugarAttributes(attributesFactory, (AttributeContainer)requestedAttributes));
    }

    public ResolvedComponentResult getRootComponent() {
        return this.rootSource.get();
    }

    public String getRepositoryId(ResolvedComponentResult resolvedComponentResult) {
        return ((ResolvedComponentResultInternal)resolvedComponentResult).getRepositoryId();
    }

    public Object getCustomOperationTraceSerializableModel() {
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("resolvedDependenciesCount", Integer.valueOf(this.getRootComponent().getDependencies().size()));
        HashMap components = new HashMap();
        DefaultResolvedComponentResult.eachElement(this.rootSource.get(), (Action<? super ResolvedComponentResult>)((Action)component -> components.put(component.getId().getDisplayName(), Collections.singletonMap("repoId", this.getRepositoryId((ResolvedComponentResult)component)))), (Action<? super DependencyResult>)Actions.doNothing(), new HashSet<ResolvedComponentResult>());
        model.put("components", components);
        ImmutableList.Builder requestedAttributesBuilder = new ImmutableList.Builder();
        AttributeContainer desugared = (AttributeContainer)this.lazyDesugaredAttributes.get();
        for (Attribute att : desugared.keySet()) {
            requestedAttributesBuilder.add((Object)ImmutableMap.of((Object)"name", (Object)att.getName(), (Object)"value", (Object)desugared.getAttribute(att).toString()));
        }
        model.put("requestedAttributes", (Serializable)requestedAttributesBuilder.build());
        return model;
    }

    public AttributeContainer getRequestedAttributes() {
        return (AttributeContainer)this.lazyDesugaredAttributes.get();
    }

    private static ImmutableAttributes desugarAttributes(AttributesFactory attributesFactory, AttributeContainer source) {
        AttributeContainerInternal result = attributesFactory.mutable();
        for (Attribute attribute : source.keySet()) {
            String name = attribute.getName();
            Class type = attribute.getType();
            Object attributeValue = source.getAttribute(attribute);
            if (type.equals(Boolean.class)) {
                result.attribute(attribute, (Object)((Boolean)attributeValue));
                continue;
            }
            if (type.equals(String.class)) {
                result.attribute(attribute, (Object)((String)attributeValue));
                continue;
            }
            if (type.equals(Integer.class)) {
                result.attribute(attribute, (Object)((Integer)attributeValue));
                continue;
            }
            Attribute stringAtt = Attribute.of((String)name, String.class);
            String stringValue = attributeValue instanceof Named ? ((Named)attributeValue).getName() : (attributeValue instanceof Object[] ? Arrays.toString((Object[])attributeValue) : attributeValue.toString());
            result.attribute(stringAtt, (Object)stringValue);
        }
        return result.asImmutable();
    }
}

