import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useState, useMemo } from 'react';
import { useMeasure } from 'react-use';
import AutoSizer from 'react-virtualized-auto-sizer';
import '@grafana/data';
import { useTheme2, useStyles2, Modal } from '@grafana/ui';
import { QueryEditorRaw } from './QueryEditorRaw.js';
import { QueryToolbox } from './QueryToolbox.js';
import '../types.js';

function RawEditor({ db, query, onChange, onRunQuery, onValidate, queryToValidate, range }) {
  const theme = useTheme2();
  const styles = useStyles2(getStyles);
  const [isExpanded, setIsExpanded] = useState(false);
  const [toolboxRef, toolboxMeasure] = useMeasure();
  const [editorRef, editorMeasure] = useMeasure();
  const completionProvider = useMemo(() => db.getSqlCompletionProvider(), [db]);
  const renderQueryEditor = (width, height) => {
    return /* @__PURE__ */ jsx(
      QueryEditorRaw,
      {
        completionProvider,
        query,
        width,
        height: height ? height - toolboxMeasure.height : undefined,
        onChange,
        children: ({ formatQuery }) => {
          return /* @__PURE__ */ jsx("div", { ref: toolboxRef, children: /* @__PURE__ */ jsx(
            QueryToolbox,
            {
              db,
              query: queryToValidate,
              onValidate,
              onFormatCode: formatQuery,
              showTools: true,
              range,
              onExpand: setIsExpanded,
              isExpanded
            }
          ) });
        }
      }
    );
  };
  const renderEditor = (standalone = false) => {
    return standalone ? /* @__PURE__ */ jsx(AutoSizer, { children: ({ width, height }) => {
      return renderQueryEditor(width, height);
    } }) : /* @__PURE__ */ jsx("div", { ref: editorRef, children: renderQueryEditor() });
  };
  const renderPlaceholder = () => {
    return /* @__PURE__ */ jsx(
      "div",
      {
        style: {
          width: editorMeasure.width,
          height: editorMeasure.height,
          background: theme.colors.background.primary,
          display: "flex",
          alignItems: "center",
          justifyContent: "center"
        },
        children: "Editing in expanded code editor"
      }
    );
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    isExpanded ? renderPlaceholder() : renderEditor(),
    isExpanded && /* @__PURE__ */ jsx(
      Modal,
      {
        title: `Query ${query.refId}`,
        closeOnBackdropClick: false,
        closeOnEscape: false,
        className: styles.modal,
        contentClassName: styles.modalContent,
        isOpen: isExpanded,
        onDismiss: () => {
          setIsExpanded(false);
        },
        children: renderEditor(true)
      }
    )
  ] });
}
function getStyles(theme) {
  return {
    modal: css`
      width: 95vw;
      height: 95vh;
    `,
    modalContent: css`
      height: 100%;
      padding-top: 0;
    `
  };
}

export { RawEditor };
//# sourceMappingURL=RawEditor.js.map
