import * as react_jsx_runtime from 'react/jsx-runtime';
import * as react from 'react';
import { ComponentProps, PureComponent, ReactElement, ReactNode, FunctionComponent, HTMLProps } from 'react';
import { Input, Segment as Segment$1, monacoTypes, Monaco, ButtonProps, Field, PopoverContent, Switch, SelectCommonProps, InlineLabel } from '@grafana/ui';
import * as _grafana_data from '@grafana/data';
import { DataSourceInstanceSettings, SelectableValue, DataSourceJsonData, VariableSuggestion, TimeRange, DataFrame, MetricFindValue, ThemeSpacingTokens, ScopedVars, DataFrameView, VariableModel, QueryEditorProps as QueryEditorProps$1, DataSourceSettings, RegistryItem, DataSourceApi, Registry, DataQuery as DataQuery$1, PanelData, DataSourcePluginMeta, PluginMetaInfo, PluginMeta, PluginInclude, PluginType, PluginIncludeType, PluginState, PluginDependencies, PluginSignatureStatus, LoadingState } from '@grafana/data';
import { DataSourceSrv, DataSourceWithBackend, TemplateSrv } from '@grafana/runtime';
import { JsonTree } from '@react-awesome-query-builder/ui';
import { DataQuery } from '@grafana/schema';
import { Grammar } from 'prismjs';

interface QueryEditorRowProps {
    label?: string;
    className?: string;
    noFillEnd?: boolean;
    children?: React.ReactNode;
}
declare const QueryEditorRow: (props: QueryEditorRowProps) => react_jsx_runtime.JSX.Element;

interface DebounceInputProps extends Omit<ComponentProps<typeof Input>, 'ref'> {
    value: string;
    onDebounce: (debouncedInput?: string) => void;
    delay?: number;
}
declare const DebounceInput: (props: DebounceInputProps) => react_jsx_runtime.JSX.Element;

interface SegmentProps<T> extends Omit<ComponentProps<typeof Segment$1<T>>, 'onChange'> {
    value: T;
    onDebounce: (debouncedSegment?: T) => void;
    delay?: number;
}
declare function Segment<T>(props: SegmentProps<T>): react_jsx_runtime.JSX.Element;

interface DatePickerProps {
    isOpen?: boolean;
    onClose: () => void;
    onChange: (value: Date) => void;
    value?: Date;
}
declare const DatePicker: react.NamedExoticComponent<DatePickerProps>;

declare const formatDate: (date: Date) => string;
interface DatePickerWithInputProps extends Omit<ComponentProps<typeof Input>, 'ref' | 'value' | 'onChange'> {
    value?: Date;
    onChange: (value: Date) => void;
}
declare const DatePickerWithInput: (props: DatePickerWithInputProps) => react_jsx_runtime.JSX.Element;

interface Props$s {
    onChange: (ds: DataSourceInstanceSettings) => void;
    current: string | null;
    hideTextValue?: boolean;
    onBlur?: () => void;
    autoFocus?: boolean;
    openMenuOnFocus?: boolean;
    placeholder?: string;
    tracing?: boolean;
    mixed?: boolean;
    dashboard?: boolean;
    metrics?: boolean;
    annotations?: boolean;
    variables?: boolean;
    pluginId?: string;
    noDefault?: boolean;
}
interface State$1 {
    error?: string;
}
declare class DataSourcePicker extends PureComponent<Props$s, State$1> {
    dataSourceSrv: DataSourceSrv;
    static defaultProps: Partial<Props$s>;
    state: State$1;
    constructor(props: Props$s);
    componentDidMount(): void;
    onChange: (item: SelectableValue<string>) => void;
    private getCurrentValue;
    getDataSourceOptions(): Array<SelectableValue<string>>;
    render(): react_jsx_runtime.JSX.Element;
}

type DataLinkConfig = {
    field: string;
    label: string;
    matcherRegex: string;
    url: string;
    datasourceUid?: string;
};

type Props$r = {
    value?: DataLinkConfig[];
    onChange: (value: DataLinkConfig[]) => void;
};
declare const DataLinks: (props: Props$r) => react_jsx_runtime.JSX.Element;

type Props$q = {
    value: DataLinkConfig;
    datasources?: Array<DataSourceInstanceSettings<DataSourceJsonData>>;
    onChange: (value: DataLinkConfig) => void;
    onDelete: () => void;
    suggestions: VariableSuggestion[];
    className?: string;
};
declare const DataLink: (props: Props$q) => react_jsx_runtime.JSX.Element;

declare function applyQueryDefaults(q?: SQLQuery): SQLQuery;
type QueryWithDefaults = ReturnType<typeof applyQueryDefaults>;

declare enum QueryEditorPropertyType {
    String = "string"
}
interface QueryEditorProperty {
    type: QueryEditorPropertyType;
    name?: string;
}
interface QueryEditorPropertyExpression {
    type: QueryEditorExpressionType.Property;
    property: QueryEditorProperty;
}
declare enum QueryEditorExpressionType {
    Property = "property",
    Operator = "operator",
    Or = "or",
    And = "and",
    GroupBy = "groupBy",
    Function = "function",
    FunctionParameter = "functionParameter"
}
interface QueryEditorGroupByExpression {
    type: QueryEditorExpressionType.GroupBy;
    property: QueryEditorProperty;
}
interface QueryEditorFunctionExpression {
    type: QueryEditorExpressionType.Function;
    name?: string;
    parameters?: QueryEditorFunctionParameterExpression[];
}
interface QueryEditorFunctionParameterExpression {
    type: QueryEditorExpressionType.FunctionParameter;
    name?: string;
}

declare class LinkedToken {
    type: string;
    value: string;
    range: monacoTypes.IRange;
    previous: LinkedToken | null;
    next: LinkedToken | null;
    constructor(type: string, value: string, range: monacoTypes.IRange, previous: LinkedToken | null, next: LinkedToken | null);
    isKeyword(): boolean;
    isWhiteSpace(): boolean;
    isParenthesis(): boolean;
    isIdentifier(): boolean;
    isString(): boolean;
    isNumber(): boolean;
    isDoubleQuotedString(): boolean;
    isVariable(): boolean;
    isFunction(): boolean;
    isOperator(): boolean;
    isTemplateVariable(): boolean;
    is(type: TokenType, value?: string | number | boolean): boolean;
    getPreviousNonWhiteSpaceToken(): LinkedToken | null;
    getPreviousOfType(type: TokenType, value?: string): LinkedToken | null;
    getPreviousUntil(type: TokenType, ignoreTypes: TokenType[], value?: string): LinkedToken[] | null;
    getNextUntil(type: TokenType, ignoreTypes: TokenType[], value?: string): LinkedToken[] | null;
    getPreviousKeyword(): LinkedToken | null;
    getNextNonWhiteSpaceToken(): LinkedToken | null;
    getNextOfType(type: TokenType, value?: string): LinkedToken | null;
}

type StatementPositionResolver = (currentToken: LinkedToken | null, previousKeyword: LinkedToken | null, previousNonWhiteSpace: LinkedToken | null, previousIsSlash: Boolean) => Boolean;
type SuggestionsResolver = <T extends PositionContext = PositionContext>(positionContext: T) => Promise<CustomSuggestion[]>;
interface SQLMonarchLanguage extends monacoTypes.languages.IMonarchLanguage {
    keywords?: string[];
    builtinFunctions?: string[];
    logicalOperators?: string[];
    comparisonOperators?: string[];
    /** Used by basic languages in the monaco registry **/
    operators?: string[];
}

/**
 * Provides a context for suggestions resolver
 * @alpha
 */
interface PositionContext {
    position: monacoTypes.IPosition;
    kind: SuggestionKind[];
    statementPosition: StatementPosition[];
    currentToken: LinkedToken | null;
    range: monacoTypes.IRange;
}
type CustomSuggestion = Partial<monacoTypes.languages.CompletionItem> & {
    label: string;
};
interface CustomSuggestionKind {
    id: string;
    suggestionsResolver: SuggestionsResolver;
    applyTo?: Array<StatementPosition | string>;
    overrideDefault?: boolean;
}
interface CustomStatementPlacement {
    id: string;
    name?: string;
    resolve: StatementPositionResolver;
    overrideDefault?: boolean;
}
type StatementPlacementProvider = () => CustomStatementPlacement[];
type SuggestionKindProvider = () => CustomSuggestionKind[];
interface ColumnDefinition {
    name: string;
    type?: string;
    description?: string;
    completion?: string;
}
interface SchemaDefinition {
    name: string;
    completion?: string;
}
interface TableDefinition {
    name: string;
    completion?: string;
}
interface TableIdentifier {
    table?: string;
    schema?: string;
    catalog?: string;
}
interface SQLCompletionItemProvider extends Omit<monacoTypes.languages.CompletionItemProvider, 'provideCompletionItems'> {
    /**
     * Allows dialect specific functions to be added to the completion list.
     * @alpha
     */
    supportedFunctions?: () => Array<{
        id: string;
        name: string;
        description?: string;
    }>;
    /**
     * Allows dialect specific operators to be added to the completion list.
     * @alpha
     */
    supportedOperators?: () => Array<{
        id: string;
        operator: string;
        type: OperatorType;
        description?: string;
    }>;
    supportedMacros?: () => Array<{
        id: string;
        text: string;
        type: MacroType;
        args: string[];
        description?: string;
    }>;
    /**
     * Allows custom suggestion kinds to be defined and correlate them with <Custom>StatementPosition.
     * @alpha
     */
    customSuggestionKinds?: SuggestionKindProvider;
    /**
     * Allows custom statement placement definition.
     * @alpha
     */
    customStatementPlacement?: StatementPlacementProvider;
    /**
     * Allows providing a custom function for resolving schemas.
     * It's up to the consumer to decide whether the schemas are resolved via API calls or preloaded in the query editor(i.e. full db schema is preloaded).
     * @alpha
     */
    schemas?: {
        resolve: () => Promise<SchemaDefinition[]>;
    };
    /**
     * Allows providing a custom function for resolving db tables.
     * It's up to the consumer to decide whether the columns are resolved via API calls or preloaded in the query editor(i.e. full db schema is preloaded).
     * @alpha
     */
    tables?: {
        resolve: (TableIdentifier: TableIdentifier | null) => Promise<TableDefinition[]>;
        parseName?: (token: LinkedToken | null | undefined) => TableIdentifier;
    };
    /**
     * Allows providing a custom function for resolving table.
     * It's up to the consumer to decide whether the columns are resolved via API calls or preloaded in the query editor(i.e. full db schema is preloaded).
     * @alpha
     */
    columns?: {
        resolve: (identifier?: TableIdentifier) => Promise<ColumnDefinition[]>;
    };
    /**
     * TODO: Not sure whether or not we need this. Would like to avoid this kind of flexibility.
     * @alpha
     */
    provideCompletionItems?: (model: monacoTypes.editor.ITextModel, position: monacoTypes.Position, context: monacoTypes.languages.CompletionContext, token: monacoTypes.CancellationToken, positionContext: PositionContext) => monacoTypes.languages.CompletionList;
}
type LanguageCompletionProvider = (m: Monaco, l?: SQLMonarchLanguage) => SQLCompletionItemProvider;
declare enum OperatorType {
    Comparison = 0,
    Logical = 1
}
declare enum MacroType {
    Value = 0,
    Filter = 1,
    Group = 2,
    Column = 3,
    Table = 4
}
declare enum TokenType {
    Parenthesis = "delimiter.parenthesis.sql",
    Whitespace = "white.sql",
    Keyword = "keyword.sql",
    Delimiter = "delimiter.sql",
    Operator = "operator.sql",
    Identifier = "identifier.sql",
    IdentifierQuote = "identifier.quote.sql",
    Type = "type.sql",
    Function = "predefined.sql",
    Number = "number.sql",
    String = "string.sql",
    Variable = "variable.sql"
}
declare enum StatementPosition {
    Unknown = "unknown",
    SelectKeyword = "selectKeyword",
    WithKeyword = "withKeyword",
    AfterSelectKeyword = "afterSelectKeyword",
    AfterSelectArguments = "afterSelectArguments",
    AfterSelectFuncFirstArgument = "afterSelectFuncFirstArgument",
    SelectAlias = "selectAlias",
    AfterFromKeyword = "afterFromKeyword",
    AfterTable = "afterTable",
    SchemaFuncFirstArgument = "schemaFuncFirstArgument",
    SchemaFuncExtraArgument = "schemaFuncExtraArgument",
    FromKeyword = "fromKeyword",
    AfterFrom = "afterFrom",
    WhereKeyword = "whereKeyword",
    WhereComparisonOperator = "whereComparisonOperator",
    WhereValue = "whereValue",
    AfterWhereFunctionArgument = "afterWhereFunctionArgument",
    AfterGroupByFunctionArgument = "afterGroupByFunctionArgument",
    AfterWhereValue = "afterWhereValue",
    AfterGroupByKeywords = "afterGroupByKeywords",
    AfterGroupBy = "afterGroupBy",
    AfterOrderByKeywords = "afterOrderByKeywords",
    AfterOrderByFunction = "afterOrderByFunction",
    AfterOrderByDirection = "afterOrderByDirection",
    AfterIsOperator = "afterIsOperator",
    AfterIsNotOperator = "afterIsNotOperator",
    AfterSchema = "afterSchema"
}
declare enum SuggestionKind {
    Schemas = "schemas",
    Tables = "tables",
    Columns = "columns",
    SelectKeyword = "selectKeyword",
    WithKeyword = "withKeyword",
    FunctionsWithArguments = "functionsWithArguments",
    FromKeyword = "fromKeyword",
    WhereKeyword = "whereKeyword",
    GroupByKeywords = "groupByKeywords",
    OrderByKeywords = "orderByKeywords",
    FunctionsWithoutArguments = "functionsWithoutArguments",
    LimitKeyword = "limitKeyword",
    SortOrderDirectionKeyword = "sortOrderDirectionKeyword",
    ComparisonOperators = "comparisonOperators",
    LogicalOperators = "logicalOperators",
    SelectMacro = "selectMacro",
    TableMacro = "tableMacro",
    FilterMacro = "filterMacro",
    GroupMacro = "groupMacro",
    BoolValues = "boolValues",
    NullValue = "nullValue",
    NotKeyword = "notKeyword",
    TemplateVariables = "templateVariables",
    StarWildCard = "starWildCard"
}
declare enum CompletionItemPriority {
    High = "a",
    MediumHigh = "d",
    Medium = "g",
    MediumLow = "k",
    Low = "q"
}
declare enum CompletionItemKind {
    Method = 0,
    Function = 1,
    Constructor = 2,
    Field = 3,
    Variable = 4,
    Class = 5,
    Struct = 6,
    Interface = 7,
    Module = 8,
    Property = 9,
    Event = 10,
    Operator = 11,
    Unit = 12,
    Value = 13,
    Constant = 14,
    Enum = 15,
    EnumMember = 16,
    Keyword = 17,
    Text = 18,
    Color = 19,
    File = 20,
    Reference = 21,
    Customcolor = 22,
    Folder = 23,
    TypeParameter = 24,
    User = 25,
    Issue = 26,
    Snippet = 27
}
declare enum CompletionItemInsertTextRule {
    KeepWhitespace = 1,
    InsertAsSnippet = 4
}
declare enum SQLEditorMode {
    Builder = "builder",
    Code = "code"
}

interface LanguageDefinition extends monacoTypes.languages.ILanguageExtensionPoint {
    loader?: (module: any) => Promise<{
        language: SQLMonarchLanguage;
        conf: monacoTypes.languages.LanguageConfiguration;
    }>;
    completionProvider?: (m: Monaco, language: SQLMonarchLanguage) => SQLCompletionItemProvider;
    formatter?: (q: string) => string;
}
interface SQLEditorProps {
    query: string;
    /**
     * Use for inspecting the query as it changes. I.e. for validation.
     */
    onChange?: (q: string, processQuery: boolean) => void;
    onBlur?: (text: string) => void;
    language?: LanguageDefinition;
    children?: (props: {
        formatQuery: () => void;
    }) => React.ReactNode;
    width?: number;
    height?: number;
}
declare const SQLEditor: ({ children, onBlur, onChange, query, language, width, height, }: SQLEditorProps) => react_jsx_runtime.JSX.Element;

interface TestQueryModel {
    query: string;
    tokens: Array<Array<Pick<monacoTypes.Token, 'language' | 'offset' | 'type'>>>;
}
interface StatementPositionResolverTestCase {
    query: TestQueryModel;
    position: {
        line: number;
        column: number;
    };
}

declare const singleLineFullQuery: TestQueryModel;

declare const singleLineFullQueryWithAggregation: TestQueryModel;

declare const multiLineFullQuery: TestQueryModel;

declare const multiLineFullQueryWithAggregation: TestQueryModel;

declare const singleLineEmptyQuery: TestQueryModel;

declare const singleLineTwoQueries: TestQueryModel;

declare const singleLineTwoQueriesWithAggregation: TestQueryModel;

declare const singleLineMultipleColumns: TestQueryModel;

declare const multiLineMultipleColumns: TestQueryModel;

declare const testData_multiLineFullQuery: typeof multiLineFullQuery;
declare const testData_multiLineFullQueryWithAggregation: typeof multiLineFullQueryWithAggregation;
declare const testData_multiLineMultipleColumns: typeof multiLineMultipleColumns;
declare const testData_singleLineEmptyQuery: typeof singleLineEmptyQuery;
declare const testData_singleLineFullQuery: typeof singleLineFullQuery;
declare const testData_singleLineFullQueryWithAggregation: typeof singleLineFullQueryWithAggregation;
declare const testData_singleLineMultipleColumns: typeof singleLineMultipleColumns;
declare const testData_singleLineTwoQueries: typeof singleLineTwoQueries;
declare const testData_singleLineTwoQueriesWithAggregation: typeof singleLineTwoQueriesWithAggregation;
declare namespace testData {
  export { testData_multiLineFullQuery as multiLineFullQuery, testData_multiLineFullQueryWithAggregation as multiLineFullQueryWithAggregation, testData_multiLineMultipleColumns as multiLineMultipleColumns, testData_singleLineEmptyQuery as singleLineEmptyQuery, testData_singleLineFullQuery as singleLineFullQuery, testData_singleLineFullQueryWithAggregation as singleLineFullQueryWithAggregation, testData_singleLineMultipleColumns as singleLineMultipleColumns, testData_singleLineTwoQueries as singleLineTwoQueries, testData_singleLineTwoQueriesWithAggregation as singleLineTwoQueriesWithAggregation };
}

declare const SQLEditorTestUtils: {
    testData: typeof testData;
    testStatementPosition: (expected: StatementPosition | string, cases: StatementPositionResolverTestCase[], resolvers: () => CustomStatementPlacement[]) => void;
};

declare const conf: monacoTypes.languages.LanguageConfiguration;
declare const language: SQLMonarchLanguage;

declare function getStandardSQLCompletionProvider(monaco: Monaco, language: SQLMonarchLanguage): SQLCompletionItemProvider;

interface SqlQueryForInterpolation {
    dataset?: string;
    alias?: string;
    format?: QueryFormat;
    rawSql?: string;
    refId: string;
    hide?: boolean;
}
interface SQLConnectionLimits {
    maxOpenConns: number;
    maxIdleConns: number;
    connMaxLifetime: number;
}
interface SQLOptions extends SQLConnectionLimits, DataSourceJsonData {
    tlsAuth: boolean;
    tlsAuthWithCACert: boolean;
    timezone: string;
    tlsSkipVerify: boolean;
    user: string;
    database: string;
    url: string;
    timeInterval: string;
}
declare enum QueryFormat {
    Timeseries = 0,
    Table = 1,
    Logs = 2,
    Trace = 3,
    OptionMulti = 4
}
declare enum EditorMode {
    Builder = "builder",
    Code = "code"
}
interface SQLQuery extends DataQuery {
    alias?: string;
    format?: QueryFormat;
    rawSql?: string;
    dataset?: string;
    catalog?: string;
    table?: string;
    sql?: SQLExpression;
    editorMode?: EditorMode;
    rawQuery?: boolean;
}
interface NameValue {
    name: string;
    value: string;
}
type SQLFilters = NameValue[];
interface SQLExpression {
    columns?: QueryEditorFunctionExpression[];
    whereJsonTree?: JsonTree;
    whereString?: string;
    filters?: SQLFilters;
    groupBy?: QueryEditorGroupByExpression[];
    orderBy?: QueryEditorPropertyExpression;
    orderByDirection?: 'ASC' | 'DESC';
    limit?: number;
    offset?: number;
}
interface TableSchema {
    name?: string;
    schema?: TableFieldSchema[];
}
interface TableFieldSchema {
    name: string;
    description?: string;
    type: string;
    repeated: boolean;
    schema: TableFieldSchema[];
}
interface QueryRowFilter {
    filter: boolean;
    group: boolean;
    order: boolean;
    preview: boolean;
}
declare const QUERY_FORMAT_OPTIONS: {
    label: string;
    value: QueryFormat;
}[];
declare const toOption: (value: string) => SelectableValue<string>;
interface ResourceSelectorProps {
    disabled?: boolean;
    className?: string;
    applyDefault?: boolean;
}
type RAQBFieldTypes = 'text' | 'number' | 'boolean' | 'datetime' | 'date' | 'time';
interface SQLSelectableValue extends SelectableValue {
    type?: string;
    raqbFieldType?: RAQBFieldTypes;
}
interface Aggregate {
    id: string;
    name: string;
    description?: string;
}
interface DB {
    init?: (datasourceId?: string) => Promise<boolean>;
    datasets: (catalog?: string) => Promise<string[]>;
    catalogs?: () => Promise<string[]>;
    tables: (dataset?: string, catalog?: string, schema?: string) => Promise<string[]>;
    fields: (query: SQLQuery, order?: boolean) => Promise<SQLSelectableValue[]>;
    validateQuery: (query: SQLQuery, range?: TimeRange) => Promise<ValidationResults>;
    dsID: () => number;
    dispose?: (dsID?: string) => void;
    lookup: (path?: string) => Promise<Array<{
        name: string;
        completion: string;
    }>>;
    getSqlCompletionProvider: () => LanguageCompletionProvider;
    toRawSql?: (query: SQLQuery) => string;
    functions: () => Promise<Aggregate[]>;
    labels?: Map<'dataset', string>;
    disableDatasets?: boolean;
    disableCatalogs?: boolean;
}
interface QueryEditorProps {
    db: DB;
    query: QueryWithDefaults;
    onChange: (query: SQLQuery) => void;
    range?: TimeRange;
}
interface ValidationResults {
    query: SQLQuery;
    rawSql?: string;
    error: string;
    isError: boolean;
    isValid: boolean;
    statistics?: {
        TotalBytesProcessed: number;
    } | null;
}
interface SqlQueryModel {
    interpolate: () => string;
    quoteLiteral: (v: string) => string;
}
interface ResponseParser {
    transformMetricFindResponse: (frame: DataFrame) => MetricFindValue[];
}
interface MetaDefinition {
    name: string;
    completion?: string;
    kind: CompletionItemKind;
}

interface GroupByRowProps {
    sql: SQLExpression;
    onSqlChange: (sql: SQLExpression) => void;
    columns?: Array<SelectableValue<string>>;
}
declare function GroupByRow({ sql, columns, onSqlChange }: GroupByRowProps): react_jsx_runtime.JSX.Element;

type AccessoryButtonProps = ButtonProps & {};
declare const AccessoryButton: ({ className, ...props }: AccessoryButtonProps) => react_jsx_runtime.JSX.Element;

interface EditorFieldGroupProps {
    children?: React.ReactNode;
}
declare const EditorFieldGroup: ({ children }: EditorFieldGroupProps) => react_jsx_runtime.JSX.Element;

interface EditorHeaderProps {
    children?: React.ReactNode;
}
declare const EditorHeader: ({ children }: EditorHeaderProps) => react_jsx_runtime.JSX.Element;

interface EditorFieldProps extends ComponentProps<typeof Field> {
    label: string;
    children: React.ReactElement;
    width?: number | string;
    optional?: boolean;
    tooltip?: PopoverContent;
    tooltipInteractive?: boolean;
}
declare const EditorField: (props: EditorFieldProps) => react_jsx_runtime.JSX.Element;

interface EditorRowProps {
    children?: React.ReactNode;
}
declare const EditorRow: ({ children }: EditorRowProps) => react_jsx_runtime.JSX.Element;

interface EditorListProps<T> {
    items: Array<Partial<T>>;
    renderItem: (item: Partial<T>, onChangeItem: (item: Partial<T>) => void, onDeleteItem: () => void) => ReactElement;
    onChange: (items: Array<Partial<T>>) => void;
}
declare const EditorList: react.ForwardRefExoticComponent<EditorListProps<unknown> & react.RefAttributes<HTMLButtonElement>>;

interface EditorRowsProps {
    children?: React.ReactNode;
}
declare const EditorRows: ({ children }: EditorRowsProps) => react_jsx_runtime.JSX.Element;

declare const EditorSwitch: (props: ComponentProps<typeof Switch>) => react_jsx_runtime.JSX.Element;

interface FlexItemProps {
    grow?: number;
    shrink?: number;
}
declare const FlexItem: ({ grow, shrink }: FlexItemProps) => react_jsx_runtime.JSX.Element;

type Direction = 'row' | 'row-reverse' | 'column' | 'column-reverse';
type AlignItems = 'stretch' | 'flex-start' | 'flex-end' | 'center' | 'baseline' | 'start' | 'end' | 'self-start' | 'self-end';
interface StackProps {
    children?: React.ReactNode;
    direction?: Direction;
    alignItems?: AlignItems;
    wrap?: boolean;
    gap?: ThemeSpacingTokens;
}
declare const EditorStack: ({ children, wrap: wrapItems, ...props }: StackProps) => react_jsx_runtime.JSX.Element;

interface InlineSelectProps<T> extends SelectCommonProps<T> {
    label?: string;
}
declare function InlineSelect<T>({ label: labelProp, ...props }: InlineSelectProps<T>): react_jsx_runtime.JSX.Element;

type Child = string | undefined | ReactElement<{
    className?: string;
    invalid?: unknown;
}>;
interface InputGroupProps {
    children: Child | Child[];
}
declare const InputGroup: ({ children }: InputGroupProps) => react_jsx_runtime.JSX.Element;

interface SpaceProps {
    v?: number;
    h?: number;
    layout?: 'block' | 'inline';
}
declare const Space: {
    (props: SpaceProps): react_jsx_runtime.JSX.Element;
    defaultProps: {
        v: number;
        h: number;
        layout: string;
    };
};

interface SearchFilterOptions {
    searchFilter?: string;
}
interface VariableWithMultiSupport extends VariableWithOptions {
    multi: boolean;
    includeAll: boolean;
    allValue?: string | null;
}
interface VariableWithOptions extends VariableModel {
    current: VariableOption;
    options: VariableOption[];
    query: string;
}
interface VariableOption {
    selected: boolean;
    text: string | string[];
    value: string | string[];
    isNone?: boolean;
}
declare abstract class SqlDatasource extends DataSourceWithBackend<SQLQuery, SQLOptions> {
    protected readonly templateSrv: TemplateSrv;
    id: number;
    name: string;
    interval: string;
    db: DB;
    dataset?: string;
    annotations: {};
    constructor(instanceSettings: DataSourceInstanceSettings<SQLOptions>, templateSrv?: TemplateSrv);
    abstract getDB(dsID?: number): DB;
    abstract getQueryModel(target?: SQLQuery, templateSrv?: TemplateSrv, scopedVars?: ScopedVars): SqlQueryModel;
    abstract getResponseParser(): ResponseParser;
    interpolateVariable: (value: string | string[] | number, variable: VariableWithMultiSupport) => string | number;
    interpolateVariablesInQueries(queries: SQLQuery[], scopedVars: ScopedVars): SQLQuery[];
    filterQuery(query: SQLQuery): boolean;
    applyTemplateVariables(target: SQLQuery, scopedVars: ScopedVars): SQLQuery;
    clean(value: string): string;
    metricFindQuery(query: string, optionalOptions?: MetricFindQueryOptions): Promise<MetricFindValue[]>;
    runSql<T extends object>(query: string, options?: RunSQLOptions): Promise<DataFrameView<T>>;
    private runMetaQuery;
    testDatasource(): Promise<{
        status: string;
        message: string;
    }>;
    targetContainsTemplate(target: SQLQuery): boolean;
}
interface RunSQLOptions extends MetricFindQueryOptions {
    refId?: string;
}
interface MetricFindQueryOptions extends SearchFilterOptions {
    range?: TimeRange;
}

interface Props$p extends QueryEditorProps$1<SqlDatasource, SQLQuery, SQLOptions> {
}
declare function SqlQueryEditor({ datasource, query, onChange, onRunQuery, range }: Props$p): react_jsx_runtime.JSX.Element | null;

type RunQueryButtonProps = {
    ariaLabel?: string;
    queryInvalid?: boolean;
    invalidQueryTooltip?: PopoverContent;
    disabled?: boolean;
    queryRunning?: boolean;
    onClick: () => void;
    dataTestId?: string;
};
declare const RunQueryButton: ({ ariaLabel, queryRunning, queryInvalid, invalidQueryTooltip, disabled, onClick, dataTestId, }: RunQueryButtonProps) => react_jsx_runtime.JSX.Element;

interface DatasetSelectorProps extends ResourceSelectorProps {
    db: DB;
    dataset?: string;
    catalog?: string;
    value: string | null;
    applyDefault?: boolean;
    disabled?: boolean;
    onChange: (v: SelectableValue) => void;
    inputId?: string;
    enableCatalogs?: boolean;
    'data-testid'?: string;
}
declare const DatasetSelector: ({ db, dataset, catalog, value, onChange, disabled, className, applyDefault, inputId, enableCatalogs, "data-testid": dataTestId, }: DatasetSelectorProps) => react_jsx_runtime.JSX.Element;

interface CatalogSelectorProps {
    db: DB;
    inputId?: string;
    value: string | null;
    onChange: (catalog: string | null) => void;
}
declare const CatalogSelector: ({ db, inputId, value, onChange }: CatalogSelectorProps) => react_jsx_runtime.JSX.Element;

interface TableSelectorProps extends ResourceSelectorProps {
    db: DB;
    dataset?: string;
    catalog?: string;
    value: string | null;
    query: QueryWithDefaults;
    onChange: (v: SelectableValue) => void;
    inputId?: string;
    enableCatalogs?: boolean;
}
declare const TableSelector: ({ db, dataset, catalog, value, className, onChange, inputId, enableCatalogs, }: TableSelectorProps) => react_jsx_runtime.JSX.Element;

type Props$o = Omit<React.ComponentProps<typeof InlineLabel>, 'children' | 'onChange'> & {
    dataSourceConfig: DataSourceSettings<any, any>;
    onChange: (config: DataSourceSettings<any, any>) => void;
    labelWidth: number;
};
declare const SecureSocksProxyToggle: ({ labelWidth, ...props }: Props$o) => any;

type Props$n = {
    dataSourceName: string;
    docsLink: string;
    hasRequiredFields?: boolean;
    className?: string;
};
declare const DataSourceDescription: ({ dataSourceName, docsLink, hasRequiredFields, className }: Props$n) => react_jsx_runtime.JSX.Element;

type Props$m = {
    title: string;
    description?: ReactNode;
    isCollapsible?: boolean;
    isInitiallyOpen?: boolean;
    kind?: 'section' | 'sub-section';
    className?: string;
};

type Props$l = Omit<Props$m, 'kind'>;
declare const ConfigSection: ({ children, ...props }: React.PropsWithChildren<Props$l>) => react_jsx_runtime.JSX.Element;

type Props$k = Omit<Props$m, 'kind'>;
declare const ConfigSubSection: ({ children, ...props }: React.PropsWithChildren<Props$k>) => react_jsx_runtime.JSX.Element;

type Props$j = {
    description: string;
    suffix: string;
    feature: string;
};
declare function ConfigDescriptionLink(props: Props$j): react_jsx_runtime.JSX.Element;

declare enum AuthMethod {
    NoAuth = "NoAuth",
    BasicAuth = "BasicAuth",
    OAuthForward = "OAuthForward",
    CrossSiteCredentials = "CrossSiteCredentials"
}
interface AuthMethodSelectOption {
    label?: string;
    description?: string;
}
type CustomMethodId = `custom-${string}`;
type CustomMethod = {
    id: CustomMethodId;
    label: string;
    description: string;
    component: ReactElement;
};
type Header = {
    name: string;
    configured: boolean;
};
type HeaderWithValue = Header & {
    value: string;
};

type Props$i = {
    enabled: boolean;
    onToggle: (enabled: boolean) => void;
    certificateConfigured: boolean;
    onCertificateChange: (certificate: string) => void;
    onCertificateReset: () => void;
    tooltips?: {
        certificateLabel?: string;
    };
    readOnly: boolean;
};

type Props$h = {
    enabled: boolean;
    onToggle: (enabled: boolean) => void;
    serverName: string;
    clientCertificateConfigured: boolean;
    clientKeyConfigured: boolean;
    onServerNameChange: (serverName: string) => void;
    onClientCertificateChange: (clientCertificate: string) => void;
    onClientKeyChange: (clientKey: string) => void;
    onClientCertificateReset: () => void;
    onClientKeyReset: () => void;
    tooltips?: {
        serverNameLabel?: string;
        certificateLabel?: string;
        keyLabel?: string;
    };
    readOnly: boolean;
};

type Props$g = {
    enabled: boolean;
    onToggle: (enabled: boolean) => void;
    readOnly: boolean;
};

type Props$f = {
    selfSignedCertificate: Omit<Props$i, 'readOnly'>;
    TLSClientAuth: Omit<Props$h, 'readOnly'>;
    skipTLSVerification: Omit<Props$g, 'readOnly'>;
    readOnly: boolean;
};
declare const TLSSettings: ({ selfSignedCertificate, TLSClientAuth, skipTLSVerification, readOnly }: Props$f) => react_jsx_runtime.JSX.Element;

type Props$e = {
    user?: string;
    passwordConfigured: boolean;
    userLabel?: string;
    userTooltip?: PopoverContent;
    userPlaceholder?: string;
    passwordLabel?: string;
    passwordTooltip?: PopoverContent;
    passwordPlaceholder?: string;
    onUserChange: (user: string) => void;
    onPasswordChange: (password: string) => void;
    onPasswordReset: () => void;
    readOnly: boolean;
};

type Props$d = {
    headers: Header[];
    onChange: (headers: HeaderWithValue[]) => void;
    readOnly: boolean;
};

type Props$c = {
    selectedMethod: AuthMethod | CustomMethodId;
    mostCommonMethod?: AuthMethod | CustomMethodId;
    visibleMethods?: Array<AuthMethod | CustomMethodId>;
    defaultOptionsOverrides?: Partial<Record<AuthMethod, AuthMethodSelectOption>>;
    customMethods?: CustomMethod[];
    onAuthMethodSelect: (authType: AuthMethod | CustomMethodId) => void;
    basicAuth?: Omit<Props$e, 'readOnly'>;
    TLS?: Omit<Props$f, 'readOnly'>;
    customHeaders?: Omit<Props$d, 'readOnly'>;
    readOnly?: boolean;
};
declare const Auth: ({ selectedMethod, mostCommonMethod, visibleMethods, defaultOptionsOverrides, customMethods, onAuthMethodSelect, basicAuth, TLS, customHeaders, readOnly, }: Props$c) => react_jsx_runtime.JSX.Element;

type DataSourceExclusiveConfig = {
    readOnly: DataSourceSettings['readOnly'];
    url: DataSourceSettings['url'];
    basicAuth: DataSourceSettings['basicAuth'];
    basicAuthUser: DataSourceSettings['basicAuthUser'];
    withCredentials: DataSourceSettings['withCredentials'];
};
type Config<JSONData extends DataSourceJsonData = any, SecureJSONData = {}> = {
    jsonData: DataSourceSettings<JSONData>['jsonData'];
    secureJsonData?: DataSourceSettings<JSONData, SecureJSONData>['secureJsonData'];
    secureJsonFields: DataSourceSettings['secureJsonFields'];
} & Partial<DataSourceExclusiveConfig>;
type OnChangeHandler<C extends Config = Config> = (config: C) => void;

declare function convertLegacyAuthProps<C extends Config = Config>({ config, onChange, }: {
    config: C;
    onChange: OnChangeHandler<C>;
}): Props$c;

type Props$b<C extends Config = Config> = {
    config: C;
    onChange: OnChangeHandler<C>;
    description?: ReactNode;
    urlPlaceholder?: string;
    urlTooltip?: PopoverContent;
    urlLabel?: string;
    className?: string;
};
declare const ConnectionSettings: <C extends Config = Config>(props: Props$b<C>) => JSX.Element;

type Props$a<C extends Config = Config> = {
    config: C;
    onChange: OnChangeHandler<C>;
    className?: string;
};
declare const AdvancedHttpSettings: <C extends Config = Config>(props: Props$a<C>) => JSX.Element;

interface CustomHeader {
    id: string;
    name: string;
    value: string;
    configured: boolean;
}
type CustomHeaders = CustomHeader[];
interface Props$9 {
    dataSourceConfig: DataSourceSettings<any, any>;
    onChange: (config: DataSourceSettings) => void;
}
interface State {
    headers: CustomHeaders;
}
declare class CustomHeadersSettings extends PureComponent<Props$9, State> {
    state: State;
    constructor(props: Props$9);
    updateSettings: () => void;
    onHeaderAdd: () => void;
    onHeaderChange: (headerIndex: number, value: CustomHeader) => void;
    onHeaderReset: (headerId: string) => void;
    onHeaderRemove: (headerId: string) => void;
    render(): react_jsx_runtime.JSX.Element;
}

interface QueryBuilderLabelFilter {
    label: string;
    op: string;
    value: string;
}
interface QueryBuilderOperation {
    id: string;
    params: QueryBuilderOperationParamValue[];
    disabled?: boolean;
}
interface QueryBuilderOperationDefinition<T = any> extends RegistryItem {
    documentation?: string;
    params: QueryBuilderOperationParamDef[];
    defaultParams: QueryBuilderOperationParamValue[];
    category: string;
    hideFromList?: boolean;
    alternativesKey?: string;
    /** Can be used to control operation placement when adding a new operations, lower are placed first */
    orderRank?: number;
    renderer: QueryBuilderOperationRenderer;
    addOperationHandler: QueryBuilderAddOperationHandler<T>;
    paramChangedHandler?: QueryBuilderOnParamChangedHandler;
    explainHandler?: QueryBuilderExplainOperationHandler;
    changeTypeHandler?: (op: QueryBuilderOperation, newDef: QueryBuilderOperationDefinition<T>) => QueryBuilderOperation;
    toggleable?: boolean;
}
type QueryBuilderAddOperationHandler<T> = (def: QueryBuilderOperationDefinition, query: T, modeller: VisualQueryModeller) => T;
type QueryBuilderExplainOperationHandler = (op: QueryBuilderOperation, def?: QueryBuilderOperationDefinition) => string;
type QueryBuilderOnParamChangedHandler = (index: number, operation: QueryBuilderOperation, operationDef: QueryBuilderOperationDefinition) => QueryBuilderOperation;
type QueryBuilderOperationRenderer = (model: QueryBuilderOperation, def: QueryBuilderOperationDefinition, innerQuery: string) => string;
type QueryBuilderOperationParamValue = string | number | boolean;
interface QueryBuilderOperationParamDef {
    name: string;
    type: 'string' | 'number' | 'boolean';
    options?: string[] | number[] | Array<SelectableValue<string>>;
    hideName?: boolean;
    restParam?: boolean;
    optional?: boolean;
    placeholder?: string;
    description?: string;
    minWidth?: number;
    editor?: FunctionComponent<QueryBuilderOperationParamEditorProps>;
    runQueryOnEnter?: boolean;
}
interface QueryBuilderOperationParamEditorProps {
    value?: QueryBuilderOperationParamValue;
    paramDef: QueryBuilderOperationParamDef;
    /** Parameter index */
    index: number;
    operation: QueryBuilderOperation;
    operationId: string;
    query: any;
    datasource: DataSourceApi;
    timeRange?: TimeRange;
    onChange: (index: number, value: QueryBuilderOperationParamValue) => void;
    onRunQuery: () => void;
    queryModeller: VisualQueryModeller;
}
declare enum QueryEditorMode {
    Code = "code",
    Builder = "builder"
}
type QueryStats = {
    bytes: number;
    message?: string;
};
interface VisualQueryModeller {
    getOperationsForCategory(category: string): QueryBuilderOperationDefinition[];
    getAlternativeOperations(key: string): QueryBuilderOperationDefinition[];
    getCategories(): string[];
    getOperationDefinition(id: string): QueryBuilderOperationDefinition | undefined;
    renderQuery(query: VisualQuery, nested?: boolean): string;
    renderLabels(labels: QueryBuilderLabelFilter[]): string;
    innerQueryPlaceholder: string;
}
interface VisualQueryBinary<T> {
    operator: string;
    vectorMatchesType?: 'on' | 'ignoring';
    vectorMatches?: string;
    query: T;
}
declare const BINARY_OPERATIONS_KEY = "Binary operations";
interface VisualQuery {
    metric?: string;
    labels: QueryBuilderLabelFilter[];
    operations: QueryBuilderOperation[];
    binaryQueries?: Array<VisualQueryBinary<VisualQuery>>;
}

declare abstract class QueryModellerBase implements VisualQueryModeller {
    protected operationsRegistry: Registry<QueryBuilderOperationDefinition>;
    private categories;
    innerQueryPlaceholder: string;
    constructor(operationDefinitions: QueryBuilderOperationDefinition[], innerQueryPlaceholder?: string);
    protected setOperationCategories(categories: string[]): void;
    abstract renderOperations(queryString: string, operations: QueryBuilderOperation[]): string;
    abstract renderBinaryQueries(queryString: string, binaryQueries?: Array<VisualQueryBinary<VisualQuery>>): string;
    abstract renderLabels(labels: QueryBuilderLabelFilter[]): string;
    abstract renderQuery(query: VisualQuery, nested?: boolean): string;
    getOperationsForCategory(category: string): QueryBuilderOperationDefinition<any>[];
    getAlternativeOperations(key: string): QueryBuilderOperationDefinition<any>[];
    getCategories(): string[];
    getOperationDefinition(id: string): QueryBuilderOperationDefinition | undefined;
    hasBinaryOp(query: VisualQuery): boolean;
}

interface Props$8 {
    labelsFilters: QueryBuilderLabelFilter[];
    onChange: (labelFilters: QueryBuilderLabelFilter[]) => void;
    onGetLabelNames: (forLabel: Partial<QueryBuilderLabelFilter>) => Promise<SelectableValue[]>;
    onGetLabelValues: (forLabel: Partial<QueryBuilderLabelFilter>) => Promise<SelectableValue[]>;
    /** If set to true, component will show error message until at least 1 filter is selected */
    labelFilterRequired?: boolean;
    multiValueSeparator?: string;
}
declare function LabelFilters({ labelsFilters, onChange, onGetLabelNames, onGetLabelValues, labelFilterRequired, multiValueSeparator, }: Props$8): react_jsx_runtime.JSX.Element;

interface Props$7 {
    title?: React.ReactNode;
    markdown?: string;
    stepNumber?: number;
}
declare function OperationExplainedBox({ title, stepNumber, markdown, children }: React.PropsWithChildren<Props$7>): react_jsx_runtime.JSX.Element;

interface Props$6<T extends VisualQuery> {
    query: T;
    datasource: DataSourceApi;
    onChange: (query: T) => void;
    onRunQuery: () => void;
    queryModeller: VisualQueryModeller;
    explainMode?: boolean;
    highlightedOp?: QueryBuilderOperation;
    timeRange?: TimeRange;
    isConflictingOperation?: (operation: QueryBuilderOperation, otherOperations: QueryBuilderOperation[]) => boolean;
}
declare function OperationList<T extends VisualQuery>({ query, datasource, queryModeller, onChange, onRunQuery, highlightedOp, timeRange, isConflictingOperation, }: Props$6<T>): react_jsx_runtime.JSX.Element;

interface Props$5<T extends VisualQuery> {
    query: T;
    queryModeller: VisualQueryModeller;
    explainMode?: boolean;
    stepNumber: number;
    language: {
        grammar: Grammar;
        name: string;
    };
    onMouseEnter?: (op: QueryBuilderOperation, index: number) => void;
    onMouseLeave?: (op: QueryBuilderOperation, index: number) => void;
}
declare function OperationListExplained<T extends VisualQuery>({ query, queryModeller, stepNumber, language, onMouseEnter, onMouseLeave, }: Props$5<T>): react_jsx_runtime.JSX.Element;

declare function OperationsEditorRow({ children }: React.PropsWithChildren<{}>): react_jsx_runtime.JSX.Element;

interface Props$4<TVisualQuery extends VisualQuery, TDataQuery extends DataQuery$1> {
    query: TVisualQuery;
    datasource: DataSourceApi<TDataQuery>;
    queryModeller: VisualQueryModeller;
    buildVisualQueryFromString: (queryString: string) => {
        query: TVisualQuery;
    };
    buildDataQueryFromQueryString: (queryString: string) => TDataQuery;
    buildQueryStringFromDataQuery: (dataQuery: TDataQuery) => string;
    onChange: (update: TVisualQuery) => void;
    data?: PanelData;
}
declare const QueryBuilderHints: {
    <TVisualQuery extends VisualQuery, TDataQuery extends DataQuery$1>({ datasource, query: visualQuery, onChange, data, queryModeller, buildVisualQueryFromString, buildDataQueryFromQueryString, buildQueryStringFromDataQuery, }: Props$4<TVisualQuery, TDataQuery>): react_jsx_runtime.JSX.Element;
    displayName: string;
};

interface Props$3 {
    mode: QueryEditorMode;
    onChange: (mode: QueryEditorMode) => void;
}
declare function QueryEditorModeToggle({ mode, onChange }: Props$3): react_jsx_runtime.JSX.Element;

interface Props$2 extends Omit<HTMLProps<HTMLInputElement>, 'value' | 'ref'> {
    value?: boolean;
    label: string;
}
declare function QueryHeaderSwitch({ label, ...inputProps }: Props$2): react_jsx_runtime.JSX.Element;

interface Props$1 {
    title: string;
    collapsedInfo: string[];
    queryStats?: QueryStats | null;
}
declare function QueryOptionGroup({ title, children, collapsedInfo, queryStats }: React.PropsWithChildren<Props$1>): react_jsx_runtime.JSX.Element;

interface Props {
    query: string;
    language: {
        grammar: Grammar;
        name: string;
    };
    className?: string;
}
declare function RawQuery({ query, language, className }: Props): react_jsx_runtime.JSX.Element;

declare class DatasourceMock extends DataSourceWithBackend {
    query: jest.Mock<any, any>;
    filterQuery: any;
    applyTemplateVariables: jest.Mock<any, any>;
    getResource: jest.Mock<any, any>;
    postResource: jest.Mock<any, any>;
    callHealthCheck: jest.Mock<any, any>;
    testDatasource: jest.Mock<any, any>;
    uid: string;
    name: string;
    id: number;
    type: string;
    interval: string;
    importQueries: jest.Mock<any, any>;
    init: jest.Mock<any, any>;
    getQueryHints: jest.Mock<any, any>;
    getQueryDisplayText: jest.Mock<any, any>;
    metricFindQuery: jest.Mock<any, any>;
    getTagKeys: jest.Mock<any, any>;
    getTagValues: jest.Mock<any, any>;
    components: {};
    meta: _grafana_data.DataSourcePluginMeta<{}>;
    targetContainsTemplate: jest.Mock<any, any>;
    modifyQuery: jest.Mock<any, any>;
    getHighlighterExpression: jest.Mock<any, any>;
    languageProvider: jest.Mock<any, any>;
    getVersion: jest.Mock<any, any>;
    interpolateVariablesInQueries: jest.Mock<any, any>;
    annotations: {};
    annotationQuery: jest.Mock<any, any>;
    streamOptionsProvider: jest.Mock<any, any>;
    getRef: jest.Mock<any, any>;
    protected getRequestHeaders: jest.Mock<any, any>;
}
declare const mockDatasource: () => DatasourceMock;
declare const mockDatasourceInstanceSettings: () => DataSourceInstanceSettings;

declare const mockDataQuery: () => DataQuery$1;

declare const mockDataSourcePluginMeta: () => DataSourcePluginMeta;
declare const mockPluginMetaInfo: () => PluginMetaInfo;
declare const mockPluginMeta: () => PluginMeta;
declare const mockPluginInclude: () => PluginInclude;
declare const mockPluginType: () => PluginType;
declare const mockPluginIncludeType: () => PluginIncludeType;
declare const mockPluginState: () => PluginState;
declare const mockPluginDependencies: () => PluginDependencies;
declare const mockPluginSignatureStatus: () => PluginSignatureStatus;

declare const mockQueryEditorProps: () => QueryEditorProps$1<any, any, any>;
declare const mockLoadingState: () => LoadingState;
declare const mockTimeRange: () => TimeRange;

declare const generateBoolean: () => boolean;
declare const undefinedOr: (fn: Function) => any;
declare const generateArrayOf: (fn: Function, numberOf?: number) => any[];
/**
 * Opens a Select or MultiSelect dropdown
 *
 * @param {HTMLElement} container The container wrapping the Select or MultiSelect component
 * @param {string} optionLabel The option text we want to type or search
 */
declare const openSelect: (container: HTMLElement, optionLabel?: string) => void;
/**
 * Selects an option from the Select or MultiSelect component
 *
 * @param {HTMLElement} container The container wrapping the Select or MultiSelect component
 * @param {string} optionLabel The option we want to select
 * @param {boolean} [typeOptionLabel=false] If we should type the optional label after opening - this is useful for AsyncSelect
 */
declare const selectOption: (container: HTMLElement, optionLabel: string, typeOptionLabel?: boolean) => Promise<void>;
declare const generateOptions: () => Array<SelectableValue<string>>;

export { AccessoryButton, AdvancedHttpSettings, type Aggregate, Auth, AuthMethod, type Props$c as AuthProps, BINARY_OPERATIONS_KEY, CatalogSelector, type ColumnDefinition, CompletionItemInsertTextRule, CompletionItemKind, CompletionItemPriority, ConfigDescriptionLink, ConfigSection, ConfigSubSection, ConnectionSettings, CustomHeadersSettings, type DB, DataLink, type DataLinkConfig, DataLinks, DataSourceDescription, DataSourcePicker, DatasetSelector, DatePicker, type DatePickerProps, DatePickerWithInput, type DatePickerWithInputProps, DebounceInput, type DebounceInputProps, EditorField, EditorFieldGroup, EditorHeader, EditorList, EditorMode, EditorRow, EditorRows, EditorStack, EditorSwitch, FlexItem, GroupByRow, InlineSelect, InputGroup, LabelFilters, type LanguageCompletionProvider, type LanguageDefinition, LinkedToken, MacroType, type MetaDefinition, type NameValue, OperationExplainedBox, OperationList, OperationListExplained, OperationsEditorRow, OperatorType, type PositionContext, type Props$s as Props, QUERY_FORMAT_OPTIONS, QueryBuilderHints, type QueryBuilderLabelFilter, type QueryBuilderOperation, type QueryBuilderOperationDefinition, type QueryBuilderOperationParamDef, type QueryBuilderOperationParamEditorProps, type QueryBuilderOperationParamValue, QueryEditorMode, QueryEditorModeToggle, type QueryEditorProps, QueryEditorRow, QueryFormat, QueryHeaderSwitch, QueryModellerBase, QueryOptionGroup, type QueryRowFilter, type QueryStats, type RAQBFieldTypes, RawQuery, type ResourceSelectorProps, type ResponseParser, RunQueryButton, type SQLConnectionLimits, SQLEditor, SQLEditorMode, SQLEditorTestUtils, type SQLExpression, type SQLFilters, type SQLMonarchLanguage, type SQLOptions, type SQLQuery, type SQLSelectableValue, type SchemaDefinition, SecureSocksProxyToggle, Segment, type SegmentProps, Space, SqlDatasource, SqlQueryEditor, type SqlQueryForInterpolation, type SqlQueryModel, type State$1 as State, type StatementPlacementProvider, StatementPosition, SuggestionKind, type SuggestionKindProvider, TLSSettings, type Props$f as TLSSettingsProps, type TableDefinition, type TableFieldSchema, type TableIdentifier, type TableSchema, TableSelector, type TestQueryModel, TokenType, type ValidationResults, type VisualQuery, type VisualQueryBinary, type VisualQueryModeller, convertLegacyAuthProps, formatDate, generateArrayOf, generateBoolean, generateOptions, getStandardSQLCompletionProvider, language as grafanaStandardSQLLanguage, conf as grafanaStandardSQLLanguageConf, mockDataQuery, mockDataSourcePluginMeta, mockDatasource, mockDatasourceInstanceSettings, mockLoadingState, mockPluginDependencies, mockPluginInclude, mockPluginIncludeType, mockPluginMeta, mockPluginMetaInfo, mockPluginSignatureStatus, mockPluginState, mockPluginType, mockQueryEditorProps, mockTimeRange, openSelect, selectOption, toOption, undefinedOr };
