/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.Propagation;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class SchedulingWrapper
implements ScheduledExecutorService {
    private static final Logger LOG = Logger.getInstance(SchedulingWrapper.class);
    private final AtomicBoolean shutdown;
    @VisibleForTesting
    @NotNull
    public final ExecutorService backendExecutorService;
    protected final AppDelayQueue delayQueue;
    private final MyScheduledFutureTask<Void> myLaxativePill;
    private static final AtomicLong sequencer = new AtomicLong();

    public SchedulingWrapper(@NotNull ExecutorService backendExecutorService, @NotNull AppDelayQueue delayQueue) {
        if (backendExecutorService == null) {
            SchedulingWrapper.$$$reportNull$$$0(0);
        }
        if (delayQueue == null) {
            SchedulingWrapper.$$$reportNull$$$0(1);
        }
        this.shutdown = new AtomicBoolean();
        this.myLaxativePill = new MyScheduledFutureTask<Void>(() -> {}, null, 0L){

            @Override
            public boolean executeMeInBackendExecutor() {
                SchedulingWrapper.this.onDelayQueuePurgedOnShutdown();
                this.set(null);
                return true;
            }

            @Override
            public String toString() {
                return "laxative for " + SchedulingWrapper.this;
            }
        };
        this.delayQueue = delayQueue;
        if (backendExecutorService instanceof ScheduledExecutorService) {
            throw new IllegalArgumentException("backendExecutorService: " + backendExecutorService + " is already ScheduledExecutorService");
        }
        this.backendExecutorService = backendExecutorService;
    }

    @NotNull
    public AppDelayQueue getDelayQueue() {
        AppDelayQueue appDelayQueue = this.delayQueue;
        if (appDelayQueue == null) {
            SchedulingWrapper.$$$reportNull$$$0(2);
        }
        return appDelayQueue;
    }

    @Override
    public @Unmodifiable @NotNull List<Runnable> shutdownNow() {
        List<Runnable> canceled = this.doShutdown();
        List backEndCanceled = this.backendExecutorService instanceof BoundedTaskExecutor ? ((BoundedTaskExecutor)this.backendExecutorService).clearAndCancelAll() : Collections.emptyList();
        try {
            this.myLaxativePill.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        List<Runnable> list = ContainerUtil.concat(canceled, backEndCanceled);
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void shutdown() {
        this.doShutdown();
    }

    @NotNull
    List<Runnable> doShutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            List<Runnable> list = Collections.emptyList();
            if (list == null) {
                SchedulingWrapper.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<Runnable> toCancel = this.getMyTasksFromDelayQueue();
        for (MyScheduledFutureTask<?> myScheduledFutureTask : toCancel) {
            myScheduledFutureTask.cancel(false);
        }
        this.delayQueue.removeAll(toCancel);
        this.delayQueue.offer(this.myLaxativePill);
        List<Runnable> list = toCancel;
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(5);
        }
        return list;
    }

    void onDelayQueuePurgedOnShutdown() {
    }

    @NotNull
    private List<MyScheduledFutureTask<?>> getMyTasksFromDelayQueue() {
        ArrayList result = new ArrayList();
        for (MyScheduledFutureTask task : this.delayQueue) {
            if (task.getBackendExecutorService() != this.backendExecutorService) continue;
            result.add(task);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            SchedulingWrapper.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown() && this.backendExecutorService.isTerminated() && this.getMyTasksFromDelayQueue().isEmpty();
    }

    @TestOnly
    public void assertTerminated() {
        assert (this.isShutdown());
        assert (this.backendExecutorService.isTerminated()) : this.backendExecutorService;
        List<MyScheduledFutureTask<?>> tasks = this.getMyTasksFromDelayQueue();
        assert (tasks.isEmpty()) : tasks;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(7);
        }
        if (!this.isShutdown()) {
            throw new IllegalStateException("must await termination after shutdown() or shutdownNow() only");
        }
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        try {
            this.myLaxativePill.get(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (CancellationException | ExecutionException e) {
            // empty catch block
        }
        List<MyScheduledFutureTask<?>> tasks = this.getMyTasksFromDelayQueue();
        for (MyScheduledFutureTask<?> task : tasks) {
            try {
                task.get(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
            }
            catch (CancellationException | ExecutionException exception) {
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        this.delayQueue.removeAll(tasks);
        return this.backendExecutorService.awaitTermination(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    protected void futureDone(@NotNull Future<?> task) {
        if (task == null) {
            SchedulingWrapper.$$$reportNull$$$0(8);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public long triggerTime(long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(9);
        }
        return this.triggerTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    private long triggerTime(long delay) {
        return System.nanoTime() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(delay));
    }

    private long overflowFree(long delay) {
        long headDelay;
        Object head = this.delayQueue.peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable command2, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (command2 == null) {
            SchedulingWrapper.$$$reportNull$$$0(10);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(11);
        }
        ScheduledFuture<Object> scheduledFuture = this.schedule(Executors.callable(command2), delay, (TimeUnit)unit);
        if (scheduledFuture == null) {
            SchedulingWrapper.$$$reportNull$$$0(12);
        }
        return scheduledFuture;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <V> ScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (callable == null) {
            SchedulingWrapper.$$$reportNull$$$0(13);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(14);
        }
        MyScheduledFutureTask<V> myScheduledFutureTask = this.delayedExecute(this.createTask(callable, this.triggerTime(delay, (TimeUnit)unit)));
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(15);
        }
        return myScheduledFutureTask;
    }

    @NotNull
    private <V> MyScheduledFutureTask<V> createTask(@NotNull Callable<V> callable, long ns) {
        if (callable == null) {
            SchedulingWrapper.$$$reportNull$$$0(16);
        }
        if (!AppExecutorUtil.propagateContext()) {
            return new MyScheduledFutureTask<V>(callable, ns);
        }
        MyScheduledFutureTask<V> myScheduledFutureTask = Propagation.capturePropagationContext(this, callable, ns);
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(17);
        }
        return myScheduledFutureTask;
    }

    @NotNull
    public <T> MyScheduledFutureTask<T> delayedExecute(@NotNull MyScheduledFutureTask<T> t) {
        if (t == null) {
            SchedulingWrapper.$$$reportNull$$$0(18);
        }
        this.checkAlreadyShutdown();
        this.delayQueue.offer(t);
        if (t.getDelay(TimeUnit.DAYS) > 31L && !t.isPeriodic()) {
            throw new IllegalArgumentException("Unsupported crazy delay " + t.getDelay(TimeUnit.DAYS) + " days: " + BoundedTaskExecutor.info(t));
        }
        MyScheduledFutureTask<T> myScheduledFutureTask = t;
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(19);
        }
        return myScheduledFutureTask;
    }

    private void checkAlreadyShutdown() {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Already shutdown");
        }
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command2, long initialDelay, long period, @NotNull TimeUnit timeUnit) {
        if (command2 == null) {
            SchedulingWrapper.$$$reportNull$$$0(20);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(21);
        }
        throw new IncorrectOperationException("Not supported because it's bad for hibernation; use scheduleWithFixedDelay() with the same parameters instead.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command2, long initialDelay, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (command2 == null) {
            SchedulingWrapper.$$$reportNull$$$0(22);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(23);
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException("delay must be positive but got: " + delay);
        }
        MyScheduledFutureTask<?> myScheduledFutureTask = this.delayedExecute(this.createTask(command2, this.triggerTime(initialDelay, (TimeUnit)unit), unit.toNanos(-delay)));
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(24);
        }
        return myScheduledFutureTask;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private MyScheduledFutureTask<?> createTask(@NotNull Runnable command2, long ns, long l) {
        void period;
        if (command2 == null) {
            SchedulingWrapper.$$$reportNull$$$0(25);
        }
        if (!AppExecutorUtil.propagateContext()) {
            return new MyScheduledFutureTask<Object>(command2, null, ns, (long)period);
        }
        MyScheduledFutureTask<?> myScheduledFutureTask = Propagation.capturePropagationContext(this, command2, ns, (long)period);
        if (myScheduledFutureTask == null) {
            SchedulingWrapper.$$$reportNull$$$0(26);
        }
        return myScheduledFutureTask;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        if (task == null) {
            SchedulingWrapper.$$$reportNull$$$0(27);
        }
        this.checkAlreadyShutdown();
        Future<T> future = this.backendExecutorService.submit(task);
        if (future == null) {
            SchedulingWrapper.$$$reportNull$$$0(28);
        }
        return future;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result) {
        if (task == null) {
            SchedulingWrapper.$$$reportNull$$$0(29);
        }
        this.checkAlreadyShutdown();
        Future<T> future = this.backendExecutorService.submit(task, result);
        if (future == null) {
            SchedulingWrapper.$$$reportNull$$$0(30);
        }
        return future;
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        if (task == null) {
            SchedulingWrapper.$$$reportNull$$$0(31);
        }
        this.checkAlreadyShutdown();
        Future<?> future = this.backendExecutorService.submit(task);
        if (future == null) {
            SchedulingWrapper.$$$reportNull$$$0(32);
        }
        return future;
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(33);
        }
        this.checkAlreadyShutdown();
        List list = this.backendExecutorService.invokeAll(tasks);
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(34);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(35);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(36);
        }
        this.checkAlreadyShutdown();
        List list = this.backendExecutorService.invokeAll(tasks, timeout, (TimeUnit)unit);
        if (list == null) {
            SchedulingWrapper.$$$reportNull$$$0(37);
        }
        return list;
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(38);
        }
        this.checkAlreadyShutdown();
        Object t = this.backendExecutorService.invokeAny(tasks);
        if (t == null) {
            SchedulingWrapper.$$$reportNull$$$0(39);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        void unit;
        if (tasks == null) {
            SchedulingWrapper.$$$reportNull$$$0(40);
        }
        if (timeUnit == null) {
            SchedulingWrapper.$$$reportNull$$$0(41);
        }
        this.checkAlreadyShutdown();
        return this.backendExecutorService.invokeAny(tasks, timeout, (TimeUnit)unit);
    }

    @Override
    public void execute(@NotNull Runnable command2) {
        if (command2 == null) {
            SchedulingWrapper.$$$reportNull$$$0(42);
        }
        this.checkAlreadyShutdown();
        this.backendExecutorService.execute(command2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutorService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delayQueue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/SchedulingWrapper";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 21: 
            case 23: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 8: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 10: 
            case 20: 
            case 22: 
            case 25: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 33: 
            case 35: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/SchedulingWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelayQueue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doShutdown";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyTasksFromDelayQueue";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "schedule";
                break;
            }
            case 17: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "delayedExecute";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleWithFixedDelay";
                break;
            }
            case 28: 
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 34: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeAll";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 39: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "futureDone";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "triggerTime";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "schedule";
                break;
            }
            case 16: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "delayedExecute";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAtFixedRate";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "scheduleWithFixedDelay";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "invokeAll";
                break;
            }
            case 38: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "invokeAny";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 37: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public class MyScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V>,
    ContextAwareRunnable {
        private final long sequenceNumber;
        private long time;
        private final long period;

        public MyScheduledFutureTask(Runnable r, V result, long ns) {
            if (r == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(0);
            }
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        /*
         * WARNING - void declaration
         */
        MyScheduledFutureTask(Runnable r, V result, long ns, long l) {
            void period;
            if (r == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(1);
            }
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        MyScheduledFutureTask(Callable<V> callable, long ns) {
            if (callable == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(2);
            }
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean canceled = super.cancel(mayInterruptIfRunning);
            SchedulingWrapper.this.delayQueue.remove(this);
            return canceled;
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            if (unit == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(3);
            }
            return unit.convert(this.time - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed other) {
            if (other == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(4);
            }
            if (other == this) {
                return 0;
            }
            if (other instanceof MyScheduledFutureTask) {
                MyScheduledFutureTask x = (MyScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : SchedulingWrapper.this.triggerTime(-p);
        }

        @Override
        public void run() {
            if (!this.isPeriodic()) {
                super.run();
                SchedulingWrapper.this.futureDone(this);
            } else if (this.runAndReset() && !SchedulingWrapper.this.isShutdown()) {
                this.setNextRunTime();
                SchedulingWrapper.this.delayQueue.offer(this);
                if (SchedulingWrapper.this.isShutdown()) {
                    SchedulingWrapper.this.delayQueue.remove(this);
                }
            }
        }

        @Override
        protected void setException(Throwable t) {
            try {
                if (!Logger.shouldRethrow(t)) {
                    LOG.error(t);
                }
            }
            finally {
                super.setException(t);
            }
        }

        @Override
        public String toString() {
            Object info = BoundedTaskExecutor.info(this);
            return "Delay: " + this.getDelay(TimeUnit.MILLISECONDS) + "ms; " + (info == this ? super.toString() : info) + " backendExecutorService: " + SchedulingWrapper.this.backendExecutorService;
        }

        @NotNull
        private ExecutorService getBackendExecutorService() {
            ExecutorService executorService = SchedulingWrapper.this.backendExecutorService;
            if (executorService == null) {
                MyScheduledFutureTask.$$$reportNull$$$0(5);
            }
            return executorService;
        }

        public boolean executeMeInBackendExecutor() {
            if (!this.isDone()) {
                SchedulingWrapper.this.backendExecutorService.execute(this);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBackendExecutorService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDelay";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

