/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sh.highlighter.ShHighlighterColors;
import com.intellij.sh.lexer.ShLexer;
import com.intellij.sh.lexer.ShTokenTypes;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ShSyntaxHighlighter
extends SyntaxHighlighterBase {
    private static final TokenSet stringSet = TokenSet.create((IElementType[])new IElementType[]{ShTokenTypes.OPEN_QUOTE, ShTokenTypes.STRING_CONTENT, ShTokenTypes.CLOSE_QUOTE});
    private static final TokenSet bracesSet = TokenSet.create((IElementType[])new IElementType[]{ShTokenTypes.LEFT_CURLY, ShTokenTypes.RIGHT_CURLY});
    private static final TokenSet backQuoteSet = TokenSet.create((IElementType[])new IElementType[]{ShTokenTypes.OPEN_BACKQUOTE, ShTokenTypes.CLOSE_BACKQUOTE});
    private static final TokenSet numberSet = TokenSet.create((IElementType[])new IElementType[]{ShTokenTypes.NUMBER, ShTokenTypes.OCTAL, ShTokenTypes.HEX, ShTokenTypes.INT});
    private static final TokenSet bracketSet = TokenSet.create((IElementType[])new IElementType[]{ShTokenTypes.LEFT_SQUARE, ShTokenTypes.RIGHT_SQUARE});
    private static final TokenSet parenthesisSet = TokenSet.create((IElementType[])new IElementType[]{ShTokenTypes.LEFT_PAREN, ShTokenTypes.RIGHT_PAREN});
    private static final TokenSet commandSet = TokenSet.create((IElementType[])new IElementType[]{ShTokenTypes.LET, ShTokenTypes.EVAL, ShTokenTypes.TEST});
    private static final TokenSet conditionalOperators = TokenSet.create((IElementType[])new IElementType[]{ShTokenTypes.OR_OR, ShTokenTypes.AND_AND, ShTokenTypes.BANG, ShTokenTypes.EQ, ShTokenTypes.REGEXP, ShTokenTypes.GT, ShTokenTypes.LT});
    private static final TokenSet redirectionSet = TokenSet.create((IElementType[])new IElementType[]{ShTokenTypes.GT, ShTokenTypes.LT, ShTokenTypes.SHIFT_RIGHT, ShTokenTypes.REDIRECT_HERE_STRING, ShTokenTypes.REDIRECT_LESS_GREATER, ShTokenTypes.REDIRECT_GREATER_BAR, ShTokenTypes.REDIRECT_GREATER_AMP, ShTokenTypes.REDIRECT_AMP_GREATER, ShTokenTypes.REDIRECT_LESS_AMP, ShTokenTypes.REDIRECT_AMP_GREATER_GREATER, ShTokenTypes.HEREDOC_MARKER_TAG});
    private static final Map<IElementType, TextAttributesKey> map = new HashMap<IElementType, TextAttributesKey>();

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = ShSyntaxHighlighter.pack((TextAttributesKey)map.get(tokenType));
        if (textAttributesKeyArray == null) {
            ShSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new ShLexer();
    }

    static {
        map.put(ShTokenTypes.VAR, ShHighlighterColors.VARIABLE);
        map.put(ShTokenTypes.COMMENT, ShHighlighterColors.LINE_COMMENT);
        map.put(ShTokenTypes.RAW_STRING, ShHighlighterColors.RAW_STRING);
        map.put(ShTokenTypes.SHEBANG, ShHighlighterColors.SHEBANG_COMMENT);
        map.put(ShTokenTypes.HEREDOC_CONTENT, ShHighlighterColors.HERE_DOC);
        map.put(ShTokenTypes.HEREDOC_MARKER_END, ShHighlighterColors.HERE_DOC_END);
        map.put(ShTokenTypes.HEREDOC_MARKER_START, ShHighlighterColors.HERE_DOC_START);
        map.put(ShTokenTypes.BAD_CHARACTER, HighlighterColors.BAD_CHARACTER);
        ShSyntaxHighlighter.fillMap(map, (TokenSet)commandSet, (TextAttributesKey)ShHighlighterColors.GENERIC_COMMAND);
        ShSyntaxHighlighter.fillMap(map, (TokenSet)stringSet, (TextAttributesKey)ShHighlighterColors.STRING);
        ShSyntaxHighlighter.fillMap(map, (TokenSet)bracesSet, (TextAttributesKey)ShHighlighterColors.BRACE);
        ShSyntaxHighlighter.fillMap(map, (TokenSet)backQuoteSet, (TextAttributesKey)ShHighlighterColors.BACKQUOTE);
        ShSyntaxHighlighter.fillMap(map, (TokenSet)ShTokenTypes.keywords, (TextAttributesKey)ShHighlighterColors.KEYWORD);
        ShSyntaxHighlighter.fillMap(map, (TokenSet)numberSet, (TextAttributesKey)ShHighlighterColors.NUMBER);
        ShSyntaxHighlighter.fillMap(map, (TokenSet)bracketSet, (TextAttributesKey)ShHighlighterColors.BRACKET);
        ShSyntaxHighlighter.fillMap(map, (TokenSet)parenthesisSet, (TextAttributesKey)ShHighlighterColors.PAREN);
        ShSyntaxHighlighter.fillMap(map, (TokenSet)redirectionSet, (TextAttributesKey)ShHighlighterColors.REDIRECTION);
        ShSyntaxHighlighter.fillMap(map, (TokenSet)conditionalOperators, (TextAttributesKey)ShHighlighterColors.CONDITIONAL_OPERATORS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sh/highlighter/ShSyntaxHighlighter", "getTokenHighlights"));
    }
}

