/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.getters.MembersGetter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.GrMainCompletionProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

class GroovyMembersGetter
extends MembersGetter {
    private final PsiClassType myExpectedType;

    GroovyMembersGetter(PsiClassType expectedType, CompletionParameters parameters) {
        super(GrMainCompletionProvider.completeStaticMembers(parameters), parameters.getPosition());
        this.myExpectedType = (PsiClassType)JavaCompletionUtil.originalize((PsiType)expectedType);
    }

    public void processMembers(boolean searchInheritors, Consumer<LookupElement> results) {
        this.processMembers(results, this.myExpectedType.resolve(), PsiTreeUtil.getParentOfType((PsiElement)this.myPlace, GrAnnotation.class) == null, searchInheritors);
    }

    protected LookupElement createFieldElement(@NotNull PsiField field2, @NotNull PsiClass origClass) {
        if (field2 == null) {
            GroovyMembersGetter.$$$reportNull$$$0(0);
        }
        if (origClass == null) {
            GroovyMembersGetter.$$$reportNull$$$0(1);
        }
        if (!this.isSuitableType(field2.getType())) {
            return null;
        }
        return GrMainCompletionProvider.createGlobalMemberElement((PsiMember)field2, field2.getContainingClass(), false);
    }

    protected LookupElement createMethodElement(@NotNull PsiMethod method, @NotNull PsiClass origClass) {
        if (method == null) {
            GroovyMembersGetter.$$$reportNull$$$0(2);
        }
        if (origClass == null) {
            GroovyMembersGetter.$$$reportNull$$$0(3);
        }
        if (method.isConstructor()) {
            return null;
        }
        PsiSubstitutor substitutor = SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor((PsiMethod)method, (PsiType)this.myExpectedType);
        PsiType type = substitutor.substitute(method.getReturnType());
        if (!this.isSuitableType(type)) {
            return null;
        }
        return GrMainCompletionProvider.createGlobalMemberElement((PsiMember)method, method.getContainingClass(), false);
    }

    private boolean isSuitableType(PsiType type) {
        return type != null && TypesUtil.isAssignableByMethodCallConversion((PsiType)this.myExpectedType, type, this.myPlace);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovyMembersGetter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFieldElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createMethodElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

