/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base.visitor;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContext;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaState;
import org.jetbrains.kotlin.idea.formatter.trailingComma.UtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH$R\u0014\u0010\u000e\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/visitor/TrailingCommaVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "()V", "visitKtElement", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitElement", "Lcom/intellij/psi/PsiElement;", "runProcessIfApplicable", "process", "trailingCommaContext", "Lorg/jetbrains/kotlin/idea/formatter/trailingComma/TrailingCommaContext;", "recursively", "", "getRecursively", "()Z", "intellij.kotlin.codeInsight.shared"})
public abstract class TrailingCommaVisitor
extends KtTreeVisitorVoid {
    private final boolean recursively;

    public TrailingCommaVisitor() {
        this.recursively = true;
    }

    public void visitKtElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.visitKtElement(element);
        if (!(element instanceof KtFunctionLiteral) && UtilKt.canAddTrailingComma((PsiElement)((PsiElement)element))) {
            this.runProcessIfApplicable(element);
        }
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ProgressIndicatorProvider.checkCanceled();
        if (this.getRecursively()) {
            super.visitElement(element);
        }
    }

    private final void runProcessIfApplicable(KtElement element) {
        TrailingCommaContext context2 = TrailingCommaContext.Companion.create((PsiElement)element);
        if (context2.getState() != TrailingCommaState.NOT_APPLICABLE) {
            this.process(context2);
        }
    }

    protected abstract void process(@NotNull TrailingCommaContext var1);

    protected boolean getRecursively() {
        return this.recursively;
    }
}

