/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.EditorNotifications;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.AutoConfigurationSettings;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManager;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurationService;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;
import org.jetbrains.kotlin.idea.util.FileUtils;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001c\u001a\u00020\u0015H\u0007J\u0006\u0010\u001d\u001a\u00020\u0015J\b\u0010\u001e\u001a\u00020\u0015H\u0007J\b\u0010\u001f\u001a\u00020\u0015H\u0007J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "syncState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$SyncState;", "kotlin.jvm.PlatformType", "checkingAndPerformingAutoConfig", "", "notificationCooldownEnd", "", "Ljava/lang/Long;", "shouldShowNotConfiguredDialog", "module", "Lcom/intellij/openapi/module/Module;", "refreshEditorNotifications", "", "isSyncDesired", "isSyncing", "isSyncInProgress", "awaitSyncFinished", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sync", "queueSyncIfPossible", "queueSync", "onSyncStarted", "onSyncFinished", "runAutoConfigurationIfPossible", "Companion", "SyncState", "intellij.kotlin.projectConfiguration"})
@SourceDebugExtension(value={"SMAP\nKotlinProjectConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectConfigurationService.kt\norg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n3919#2:248\n4434#2,2:249\n1869#3,2:251\n1869#3,2:253\n*S KotlinDebug\n*F\n+ 1 KotlinProjectConfigurationService.kt\norg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService\n*L\n80#1:248\n80#1:249,2\n84#1:251,2\n194#1:253,2\n*E\n"})
public final class KotlinProjectConfigurationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final AtomicReference<SyncState> syncState;
    private volatile boolean checkingAndPerformingAutoConfig;
    @Nullable
    private volatile Long notificationCooldownEnd;

    public KotlinProjectConfigurationService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.syncState = new AtomicReference<SyncState>(new SyncState(SyncState.Level.Idle, CollectionsKt.emptyList()));
    }

    public final boolean shouldShowNotConfiguredDialog(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!ConfigureKotlinInProjectUtilsKt.findApplicableConfigurator(module).shouldShowNotConfiguredDialog()) {
            return false;
        }
        if (this.isSyncDesired(module)) {
            return false;
        }
        if (this.checkingAndPerformingAutoConfig) {
            return false;
        }
        Long l = this.notificationCooldownEnd;
        if (l == null) {
            return true;
        }
        long cooldownEnd = l;
        return System.currentTimeMillis() >= cooldownEnd;
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshEditorNotifications() {
        void $this$filterTo$iv$iv;
        VirtualFile[] openFiles;
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this.project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        VirtualFile[] $this$filter$iv = openFiles = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!FileUtils.isKotlinFileType((VirtualFile)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List openKotlinFiles = (List)destination$iv$iv;
        if (openKotlinFiles.isEmpty()) {
            return;
        }
        EditorNotifications editorNotifications = EditorNotifications.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)editorNotifications, (String)"getInstance(...)");
        EditorNotifications editorNotifications2 = editorNotifications;
        Iterable $this$forEach$iv = openKotlinFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            editorNotifications2.updateNotifications(it);
        }
    }

    public final boolean isSyncDesired(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        KotlinBuildSystemDependencyManager kotlinBuildSystemDependencyManager = KotlinBuildSystemDependencyManager.Companion.findApplicableConfigurator(module);
        return kotlinBuildSystemDependencyManager != null ? kotlinBuildSystemDependencyManager.isProjectSyncPending() : false;
    }

    public final boolean isSyncing() {
        SyncState $this$isSyncing_u24lambda_u240 = this.syncState.get();
        boolean bl = false;
        return $this$isSyncing_u24lambda_u240.getLevel() == SyncState.Level.SyncQueued || $this$isSyncing_u24lambda_u240.getLevel() == SyncState.Level.SyncInProgress;
    }

    public final boolean isSyncInProgress() {
        return this.syncState.get().getLevel() == SyncState.Level.SyncInProgress;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object awaitSyncFinished(@NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof awaitSyncFinished.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ KotlinProjectConfigurationService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.awaitSyncFinished((Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                job = JobKt.Job$default(null, (int)1, null);
                state = this.syncState.updateAndGet((UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, awaitSyncFinished$lambda$0(kotlinx.coroutines.CompletableJob org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurationService$SyncState ), (Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$SyncState;)Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$SyncState;)((CompletableJob)job));
                if (state.getLevel() == SyncState.Level.Idle) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)job);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)state);
                $continuation.label = 1;
                v0 = job.join((Continuation)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl27
            }
            case 1: {
                state = (SyncState)$continuation.L$1;
                job = (CompletableJob)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                return Boxing.boxBoolean((boolean)true);
            }
        }
        return Boxing.boxBoolean((boolean)false);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object sync(@NotNull Continuation<? super Unit> $completion) {
        this.queueSync();
        Object object = this.awaitSyncFinished($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @ApiStatus.Internal
    public final void queueSyncIfPossible() {
        if (ExternalSystemProjectTrackerSettings.Companion.getInstance(this.project).getAutoReloadType() != ExternalSystemProjectTrackerSettings.AutoReloadType.NONE) {
            this.queueSync();
        }
    }

    public final void queueSync() {
        SideEffectGuard.Companion.checkSideEffectAllowed(SideEffectGuard.EffectType.PROJECT_MODEL);
        SyncState previousState = this.syncState.getAndUpdate(KotlinProjectConfigurationService::queueSync$lambda$0);
        if (previousState.getLevel().compareTo((Enum)SyncState.Level.SyncInProgress) < 0) {
            ExternalSystemProjectTracker.Companion.getInstance(this.project).scheduleProjectRefresh();
        }
    }

    @ApiStatus.Internal
    public final void onSyncStarted() {
        this.syncState.updateAndGet(KotlinProjectConfigurationService::onSyncStarted$lambda$0);
    }

    @ApiStatus.Internal
    public final void onSyncFinished() {
        SyncState previousState = this.syncState.getAndUpdate(KotlinProjectConfigurationService::onSyncFinished$lambda$0);
        if (previousState.getLevel() == SyncState.Level.SyncInProgress) {
            Iterable $this$forEach$iv = previousState.getOnFinishedListeners();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompletableJob job2 = (CompletableJob)element$iv;
                boolean bl = false;
                job2.complete();
            }
        }
        if (previousState.getLevel() == SyncState.Level.SyncQueued) {
            ExternalSystemProjectTracker.Companion.getInstance(this.project).scheduleProjectRefresh();
        }
    }

    public final void runAutoConfigurationIfPossible(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.checkingAndPerformingAutoConfig = true;
        this.refreshEditorNotifications();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(module, this, null){
            int I$0;
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ Module $module;
            final /* synthetic */ KotlinProjectConfigurationService this$0;
            {
                this.$module = $module;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        configured = 0;
                        this.I$0 = configured;
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.module.Module ), ()Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;)((Module)this.$module), (Continuation)((Continuation)this));
                        ** if (v0 != var6_2) goto lbl13
lbl12:
                        // 1 sources

                        return var6_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl20
                    }
                    case 1: {
                        configured = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        if ((KotlinProjectConfigurator)v0 != null) break;
                        var5_8 = Unit.INSTANCE;
                        KotlinProjectConfigurationService.access$setCheckingAndPerformingAutoConfig$p(this.this$0, false);
                        if (configured == 0) {
                            this.this$0.refreshEditorNotifications();
                            this.L$0 = var5_8;
                            this.I$0 = configured;
                            this.label = 2;
                            v1 = ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(this.$module, (Continuation<? super Unit>)((Continuation)this));
                            if (v1 == var6_2) {
                                return var6_2;
                            }
                        }
                        ** GOTO lbl37
                    }
                    case 2: {
                        configured = this.I$0;
                        var5_8 = (Unit)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl37:
                        // 2 sources

                        return var5_8;
                    }
                }
                try {
                    autoConfigurator = v2;
                    v3 = this.$module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getProject(...)");
                    this.L$0 = autoConfigurator;
                    this.I$0 = configured;
                    this.label = 3;
                    v4 = TasksKt.withBackgroundProgress((Project)v3, (String)KotlinProjectConfigurationBundle.message("auto.configure.kotlin.check", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AutoConfigurationSettings>, Object>(autoConfigurator, this.$module, null){
                        int label;
                        final /* synthetic */ KotlinProjectConfigurator $autoConfigurator;
                        final /* synthetic */ Module $module;
                        {
                            this.$autoConfigurator = $autoConfigurator;
                            this.$module = $module;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    v0 = this.$autoConfigurator.calculateAutoConfigSettings(this.$module, (Continuation<? super AutoConfigurationSettings>)((Continuation)this));
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    settings = (AutoConfigurationSettings)v0;
                                    v1 = this.$module.getProject();
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
                                    KotlinJ2KOnboardingFUSCollector.INSTANCE.logCheckAutoConfigStatus(v1, settings != null);
                                    return settings;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super AutoConfigurationSettings> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)((Continuation)this));
                    ** if (v4 != var6_2) goto lbl60
                }
                catch (Throwable var3_12) {
                    KotlinProjectConfigurationService.access$setCheckingAndPerformingAutoConfig$p(this.this$0, false);
                    if (configured == 0) {
                        this.this$0.refreshEditorNotifications();
                        this.L$0 = var3_12;
                        this.L$1 = null;
                        this.I$0 = configured;
                        this.label = 7;
                        v5 = ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(this.$module, (Continuation<? super Unit>)((Continuation)this));
                        if (v5 == var6_2) {
                            return var6_2;
                        }
                    }
                    ** GOTO lbl120
                }
lbl59:
                // 1 sources

                return var6_2;
lbl60:
                // 1 sources

                ** GOTO lbl68
                {
                    case 3: {
                        configured = this.I$0;
                        autoConfigurator = (KotlinProjectConfigurator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl68:
                        // 2 sources

                        if ((autoConfigSettings = (AutoConfigurationSettings)v4) != null) break;
                        var5_9 = Unit.INSTANCE;
                        KotlinProjectConfigurationService.access$setCheckingAndPerformingAutoConfig$p(this.this$0, false);
                        if (configured == 0) {
                            this.this$0.refreshEditorNotifications();
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)autoConfigurator);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)autoConfigSettings);
                            this.L$2 = var5_9;
                            this.I$0 = configured;
                            this.label = 4;
                            v6 = ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(this.$module, (Continuation<? super Unit>)((Continuation)this));
                            if (v6 == var6_2) {
                                return var6_2;
                            }
                        }
                        ** GOTO lbl89
                    }
                    case 4: {
                        configured = this.I$0;
                        var5_9 = (Unit)this.L$2;
                        autoConfigSettings = (AutoConfigurationSettings)this.L$1;
                        autoConfigurator = (KotlinProjectConfigurator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl89:
                        // 2 sources

                        return var5_9;
                    }
                }
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)autoConfigurator);
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)autoConfigSettings);
                this.I$0 = configured;
                this.label = 5;
                v7 = autoConfigurator.runAutoConfig(autoConfigSettings, (Continuation<? super Unit>)((Continuation)this));
                ** if (v7 != var6_2) goto lbl98
lbl97:
                // 1 sources

                return var6_2;
lbl98:
                // 1 sources

                ** GOTO lbl107
                {
                    case 5: {
                        configured = this.I$0;
                        autoConfigSettings = (AutoConfigurationSettings)this.L$1;
                        autoConfigurator = (KotlinProjectConfigurator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl107:
                        // 2 sources

                        configured = 1;
                        KotlinProjectConfigurationService.access$setNotificationCooldownEnd$p(this.this$0, Boxing.boxLong((long)(System.currentTimeMillis() + (long)2000)));
                        KotlinProjectConfigurationService.access$setCheckingAndPerformingAutoConfig$p(this.this$0, false);
                        break;
                    }
                    case 6: {
                        configured = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        break;
                    }
                    case 7: {
                        configured = this.I$0;
                        var3_13 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl120:
                        // 2 sources

                        throw var3_13;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final KotlinProjectConfigurator invokeSuspend$lambda$0(Module $module) {
                Object v0;
                block1: {
                    Iterable $this$firstOrNull$iv = KotlinProjectConfigurator.Companion.getEP_NAME().getExtensionList();
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                        boolean bl = false;
                        if (!(it.canRunAutoConfig() && it.isApplicable($module))) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
        }), (int)2, null);
    }

    private static final SyncState awaitSyncFinished$lambda$0(CompletableJob $job, SyncState state) {
        if (state.getLevel() == SyncState.Level.Idle) {
            return state;
        }
        Intrinsics.checkNotNull((Object)state);
        return SyncState.copy$default(state, null, CollectionsKt.plus((Collection)state.getOnFinishedListeners(), (Object)$job), 1, null);
    }

    private static final SyncState queueSync$lambda$0(SyncState state) {
        Intrinsics.checkNotNull((Object)state);
        return SyncState.copy$default(state, SyncState.Level.SyncQueued, null, 2, null);
    }

    private static final SyncState onSyncStarted$lambda$0(SyncState state) {
        Intrinsics.checkNotNull((Object)state);
        return SyncState.copy$default(state, SyncState.Level.SyncInProgress, null, 2, null);
    }

    private static final SyncState onSyncFinished$lambda$0(SyncState state) {
        return state.getLevel() == SyncState.Level.SyncInProgress ? new SyncState(SyncState.Level.Idle, CollectionsKt.emptyList()) : state;
    }

    public static final /* synthetic */ void access$setNotificationCooldownEnd$p(KotlinProjectConfigurationService $this, Long l) {
        $this.notificationCooldownEnd = l;
    }

    public static final /* synthetic */ void access$setCheckingAndPerformingAutoConfig$p(KotlinProjectConfigurationService $this, boolean bl) {
        $this.checkingAndPerformingAutoConfig = bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.projectConfiguration"})
    @SourceDebugExtension(value={"SMAP\nKotlinProjectConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectConfigurationService.kt\norg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,247:1\n30#2,2:248\n*S KotlinDebug\n*F\n+ 1 KotlinProjectConfigurationService.kt\norg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$Companion\n*L\n26#1:248,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinProjectConfigurationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinProjectConfigurationService> serviceClass$iv = KotlinProjectConfigurationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinProjectConfigurationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$SyncState;", "", "level", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$SyncState$Level;", "onFinishedListeners", "", "Lkotlinx/coroutines/CompletableJob;", "<init>", "(Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$SyncState$Level;Ljava/util/List;)V", "getLevel", "()Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$SyncState$Level;", "getOnFinishedListeners", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Level", "intellij.kotlin.projectConfiguration"})
    private static final class SyncState {
        @NotNull
        private final Level level;
        @NotNull
        private final List<CompletableJob> onFinishedListeners;

        public SyncState(@NotNull Level level, @NotNull List<? extends CompletableJob> onFinishedListeners) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter(onFinishedListeners, (String)"onFinishedListeners");
            this.level = level;
            this.onFinishedListeners = onFinishedListeners;
        }

        @NotNull
        public final Level getLevel() {
            return this.level;
        }

        @NotNull
        public final List<CompletableJob> getOnFinishedListeners() {
            return this.onFinishedListeners;
        }

        @NotNull
        public final Level component1() {
            return this.level;
        }

        @NotNull
        public final List<CompletableJob> component2() {
            return this.onFinishedListeners;
        }

        @NotNull
        public final SyncState copy(@NotNull Level level, @NotNull List<? extends CompletableJob> onFinishedListeners) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter(onFinishedListeners, (String)"onFinishedListeners");
            return new SyncState(level, onFinishedListeners);
        }

        public static /* synthetic */ SyncState copy$default(SyncState syncState, Level level, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                level = syncState.level;
            }
            if ((n & 2) != 0) {
                list2 = syncState.onFinishedListeners;
            }
            return syncState.copy(level, list2);
        }

        @NotNull
        public String toString() {
            return "SyncState(level=" + this.level + ", onFinishedListeners=" + this.onFinishedListeners + ")";
        }

        public int hashCode() {
            int result2 = this.level.hashCode();
            result2 = result2 * 31 + ((Object)this.onFinishedListeners).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SyncState)) {
                return false;
            }
            SyncState syncState = (SyncState)other;
            if (this.level != syncState.level) {
                return false;
            }
            return Intrinsics.areEqual(this.onFinishedListeners, syncState.onFinishedListeners);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurationService$SyncState$Level;", "", "<init>", "(Ljava/lang/String;I)V", "Idle", "SyncQueued", "SyncInProgress", "intellij.kotlin.projectConfiguration"})
        public static final class Level
        extends Enum<Level> {
            public static final /* enum */ Level Idle = new Level();
            public static final /* enum */ Level SyncQueued = new Level();
            public static final /* enum */ Level SyncInProgress = new Level();
            private static final /* synthetic */ Level[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Level[] values() {
                return (Level[])$VALUES.clone();
            }

            public static Level valueOf(String value) {
                return Enum.valueOf(Level.class, value);
            }

            @NotNull
            public static EnumEntries<Level> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = levelArray = new Level[]{Level.Idle, Level.SyncQueued, Level.SyncInProgress};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

