/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.Value;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassifierSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypePointer;
import org.jetbrains.kotlin.idea.debugger.base.util.AnalyseUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinRuntimeTypeEvaluatorBase;
import org.jetbrains.kotlin.idea.testIntegration.framework.KotlinPsiBasedTestFramework;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u0001B)\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ \u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinK2RuntimeTypeEvaluator;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinRuntimeTypeEvaluatorBase;", "Lorg/jetbrains/kotlin/analysis/api/types/KaTypePointer;", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "editor", "Lcom/intellij/openapi/editor/Editor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/debugger/impl/DebuggerContextImpl;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getCastableRuntimeType", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "value", "Lcom/sun/jdi/Value;", "kotlin.jvm-debugger.evaluation"})
@ApiStatus.Internal
public abstract class KotlinK2RuntimeTypeEvaluator
extends KotlinRuntimeTypeEvaluatorBase<KaTypePointer<? extends KaType>> {
    @NotNull
    private final KtExpression expression;

    public KotlinK2RuntimeTypeEvaluator(@Nullable Editor editor, @NotNull KtExpression expression, @NotNull DebuggerContextImpl context2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        super(editor, (PsiElement)expression, context2, indicator);
        this.expression = expression;
    }

    @Override
    @Nullable
    protected KaTypePointer<KaType> getCastableRuntimeType(@NotNull GlobalSearchScope scope, @NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Project project = scope.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Type asmType = JdiValuesKt.asValue(value).getAsmType();
        FqName fqName2 = JvmClassName.byInternalName((String)asmType.getInternalName()).getFqNameForClassNameWithoutDollars();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getFqNameForClassNameWithoutDollars(...)");
        FqName jvmName = fqName2;
        PsiClass psiClass = (PsiClass)ActionsKt.runReadAction(() -> KotlinK2RuntimeTypeEvaluator.getCastableRuntimeType$lambda$0(jvmName, project2, scope));
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        return AnalyseUtilsKt.runDumbAnalyze((KtElement)this.expression, null, arg_0 -> KotlinK2RuntimeTypeEvaluator.getCastableRuntimeType$lambda$1(psiClass2, arg_0));
    }

    private static final PsiClass getCastableRuntimeType$lambda$0(FqName $jvmName, Project $project, GlobalSearchScope $scope) {
        return DebuggerUtils.findClass((String)$jvmName.asString(), (Project)$project, (GlobalSearchScope)$scope, (boolean)true);
    }

    private static final KaTypePointer getCastableRuntimeType$lambda$1(PsiClass $psiClass, KaSession $this$runDumbAnalyze) {
        KaType runtimeType;
        Intrinsics.checkNotNullParameter((Object)$this$runDumbAnalyze, (String)"$this$runDumbAnalyze");
        Object object = KotlinPsiBasedTestFramework.Companion.asKtClassOrObject((PsiElement)$psiClass);
        if (object == null || (object = $this$runDumbAnalyze.getNamedClassSymbol((KtClassOrObject)object)) == null) {
            object = $this$runDumbAnalyze.getNamedClassSymbol($psiClass);
        }
        KaType kaType = runtimeType = object != null ? $this$runDumbAnalyze.getDefaultType((KaClassifierSymbol)object) : null;
        return kaType != null ? kaType.createPointer() : null;
    }
}

