/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.Replacement;
import org.jetbrains.kotlin.idea.k2.codeinsight.inspections.ReplacementCollection;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\u0017\u001a\u00020\u0018\"\b\b\u0000\u0010\u0019*\u00020\t2\u0006\u0010\u001a\u001a\u0002H\u00192\u001d\u0010\u001b\u001a\u0019\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\t0\u001c\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0018J\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\n\u001a\u0015\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000b\u00a2\u0006\u0002\b\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReplacementCollection;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "replacements", "", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/Replacement;", "Lcom/intellij/psi/PsiElement;", "createParameter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lkotlin/ExtensionFunctionType;", "getCreateParameter", "()Lkotlin/jvm/functions/Function1;", "setCreateParameter", "(Lkotlin/jvm/functions/Function1;)V", "elementToRename", "getElementToRename", "()Lcom/intellij/psi/PsiElement;", "setElementToRename", "(Lcom/intellij/psi/PsiElement;)V", "add", "", "T", "element", "replacementFactory", "Lkotlin/Function2;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function2;)V", "apply", "isNotEmpty", "", "intellij.kotlin.codeInsight.inspections"})
@SourceDebugExtension(value={"SMAP\nScopeFunctionConversionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReplacementCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,571:1\n1011#2,2:572\n*S KotlinDebug\n*F\n+ 1 ScopeFunctionConversionInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/ReplacementCollection\n*L\n168#1:572,2\n*E\n"})
public final class ReplacementCollection {
    @NotNull
    private final Project project;
    @NotNull
    private final List<Replacement<? extends PsiElement>> replacements;
    @NotNull
    private Function1<? super KtPsiFactory, ? extends PsiElement> createParameter;
    @Nullable
    private PsiElement elementToRename;

    public ReplacementCollection(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.replacements = new ArrayList();
        this.createParameter = createParameter.1.INSTANCE;
    }

    @NotNull
    public final Function1<KtPsiFactory, PsiElement> getCreateParameter() {
        return this.createParameter;
    }

    public final void setCreateParameter(@NotNull Function1<? super KtPsiFactory, ? extends PsiElement> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.createParameter = function1;
    }

    @Nullable
    public final PsiElement getElementToRename() {
        return this.elementToRename;
    }

    public final void setElementToRename(@Nullable PsiElement psiElement) {
        this.elementToRename = psiElement;
    }

    public final <T extends PsiElement> void add(@NotNull T element, @NotNull Function2<? super KtPsiFactory, ? super T, ? extends PsiElement> replacementFactory) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter(replacementFactory, (String)"replacementFactory");
        this.replacements.add(Replacement.Companion.create(element, replacementFactory));
    }

    public final void apply() {
        KtPsiFactory factory2 = new KtPsiFactory(this.project, false, 2, null);
        this.elementToRename = (PsiElement)this.createParameter.invoke((Object)factory2);
        List<Replacement<? extends PsiElement>> $this$sortBy$iv = this.replacements;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Replacement it = (Replacement)a;
                    boolean bl = false;
                    Comparable comparable = it.getEndOffset();
                    it = (Replacement)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getEndOffset());
                }
            });
        }
        for (Replacement<? extends PsiElement> replacement : this.replacements) {
            replacement.apply(factory2);
        }
    }

    public final boolean isNotEmpty() {
        return !((Collection)this.replacements).isEmpty();
    }
}

