/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.inplace.MyLookupExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactoryWithDelegate;
import org.jetbrains.kotlin.idea.references.KtReferenceKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J#\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0002JF\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u00072\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u000b0 j\b\u0012\u0004\u0012\u00020\u000b`!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "element", "platformClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "possibleClasses", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtReferenceExpression;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/Collection;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "replaceUsagesWithFirstClass", "", "Lcom/intellij/psi/PsiElement;", "usages", "Lorg/jetbrains/kotlin/psi/KtUserType;", "PRIMARY_USAGE", "OTHER_USAGE", "buildAndShowTemplate", "Lcom/intellij/psi/PsiFile;", "replacedElements", "options", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nMapPlatformClassToKotlinFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapPlatformClassToKotlinFix.kt\norg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix\n+ 2 ResolutionUtils.kt\norg/jetbrains/kotlin/idea/caches/resolve/ResolutionUtils\n+ 3 ExtendedResolutionApi.kt\norg/jetbrains/kotlin/idea/caches/resolve/ExtendedResolutionApiKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n154#2:183\n152#3:184\n249#4:185\n249#4:186\n1869#5,2:187\n*S KotlinDebug\n*F\n+ 1 MapPlatformClassToKotlinFix.kt\norg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix\n*L\n56#1:183\n56#1:184\n67#1:185\n71#1:186\n75#1:187,2\n*E\n"})
public final class MapPlatformClassToKotlinFix
extends KotlinQuickFixAction<KtReferenceExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassDescriptor platformClass;
    @NotNull
    private final Collection<ClassDescriptor> possibleClasses;
    @NotNull
    private final String PRIMARY_USAGE;
    @NotNull
    private final String OTHER_USAGE;

    public MapPlatformClassToKotlinFix(@NotNull KtReferenceExpression element, @NotNull ClassDescriptor platformClass, @NotNull Collection<? extends ClassDescriptor> possibleClasses) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)platformClass, (String)"platformClass");
        Intrinsics.checkNotNullParameter(possibleClasses, (String)"possibleClasses");
        super((PsiElement)element);
        this.platformClass = platformClass;
        this.possibleClasses = possibleClasses;
        this.PRIMARY_USAGE = "PrimaryUsage";
        this.OTHER_USAGE = "OtherUsage";
    }

    @NotNull
    public String getText() {
        String string;
        SimpleType simpleType = this.platformClass.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        String platformClassQualifiedName = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType((KotlinType)simpleType);
        ClassDescriptor singleClass = (ClassDescriptor)CollectionsKt.singleOrNull((Iterable)this.possibleClasses);
        if (singleClass != null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = platformClassQualifiedName;
            SimpleType simpleType2 = singleClass.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getDefaultType(...)");
            objectArray[1] = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType((KotlinType)simpleType2);
            string = KotlinBundle.message((String)"change.all.usages.of.0.in.this.file.to.1", (Object[])objectArray);
        } else {
            Object[] objectArray = new Object[]{platformClassQualifiedName};
            string = KotlinBundle.message((String)"change.all.usages.of.0.in.this.file.to.a.kotlin.class", (Object[])objectArray);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"change.to.kotlin.class", (Object[])new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Iterator $this$analyzeWithContent$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtDeclarationContainer $this$analyzeWithContent$iv = (KtDeclarationContainer)file;
        boolean $i$f$analyzeWithContent = false;
        KtDeclarationContainer ktDeclarationContainer = $this$analyzeWithContent$iv;
        ResolutionFacade resolutionFacade$iv$iv = ResolutionUtils.getResolutionFacade((KtElement)$this$analyzeWithContent$iv);
        boolean $i$f$analyzeWithContent2 = false;
        BindingContext bindingContext = ResolutionFacade.analyzeWithAllCompilerChecks$default(resolutionFacade$iv$iv, (KtElement)$this$analyzeWithContent$iv$iv, null, 2, null).getBindingContext();
        ArrayList<KtImportDirective> imports2 = new ArrayList<KtImportDirective>();
        ArrayList<KtUserType> usages2 = new ArrayList<KtUserType>();
        for (Diagnostic diagnostic : bindingContext.getDiagnostics()) {
            boolean bl;
            KtReferenceExpression refExpr;
            if (diagnostic.getFactory() != Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN || MapPlatformClassToKotlinFix.Companion.getImportOrUsageFromDiagnostic(diagnostic) == null || !Intrinsics.areEqual((Object)MapPlatformClassToKotlinFix.Companion.resolveToClass(refExpr, bindingContext), (Object)this.platformClass)) continue;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)refExpr;
            boolean $i$f$getStrictParentOfType = false;
            KtImportDirective ktImportDirective = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtImportDirective.class, (boolean)true);
            if (ktImportDirective != null) {
                bl = imports2.add(ktImportDirective);
                continue;
            }
            PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)refExpr;
            boolean $i$f$getStrictParentOfType2 = false;
            KtUserType ktUserType = (KtUserType)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtUserType.class, (boolean)true);
            if (ktUserType == null) continue;
            bl = usages2.add(ktUserType);
        }
        Iterable $this$forEach$iv = imports2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtImportDirective it = (KtImportDirective)element$iv;
            boolean bl = false;
            it.delete();
        }
        if (usages2.isEmpty()) {
            return;
        }
        List<PsiElement> replacedElements = this.replaceUsagesWithFirstClass(project, (List<? extends KtUserType>)usages2);
        if (this.possibleClasses.size() > 1 && editor != null) {
            LinkedHashSet<String> possibleTypes = new LinkedHashSet<String>();
            for (ClassDescriptor klass : this.possibleClasses) {
                possibleTypes.add(klass.getName().asString());
            }
            this.buildAndShowTemplate(project, editor, (PsiFile)file, (Collection<? extends PsiElement>)replacedElements, possibleTypes);
        }
    }

    private final List<PsiElement> replaceUsagesWithFirstClass(Project project, List<? extends KtUserType> usages2) {
        ClassDescriptor replacementClass = (ClassDescriptor)CollectionsKt.first((Iterable)this.possibleClasses);
        String string = replacementClass.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String replacementClassName = string;
        ArrayList<PsiElement> replacedElements = new ArrayList<PsiElement>();
        for (KtUserType ktUserType : usages2) {
            KtTypeElement replacementTypeElement;
            KtTypeArgumentList typeArguments2 = ktUserType.getTypeArgumentList();
            Object object = typeArguments2;
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            Object typeArgumentsString = object;
            KtTypeReference replacementType = new KtPsiFactory(project, false, 2, null).createType(replacementClassName + (String)typeArgumentsString);
            Intrinsics.checkNotNull((Object)replacementType.getTypeElement());
            PsiElement replacedElement = ktUserType.replace((PsiElement)replacementTypeElement);
            PsiElement replacedExpression = replacedElement.getFirstChild();
            boolean bl = replacedExpression instanceof KtSimpleNameExpression;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            replacedElements.add(replacedExpression);
        }
        return replacedElements;
    }

    private final void buildAndShowTemplate(Project project, Editor editor, PsiFile file, Collection<? extends PsiElement> replacedElements, LinkedHashSet<String> options2) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        PsiElement psiElement = replacedElements.iterator().next();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"next(...)");
        PsiElement primaryReplacedExpression = psiElement;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        int oldOffset = caretModel2.getOffset();
        caretModel2.moveToOffset(file.getNode().getStartOffset());
        TemplateBuilderImpl builder2 = new TemplateBuilderImpl((PsiElement)file);
        MyLookupExpression expression = new MyLookupExpression(primaryReplacedExpression.getText(), options2, null, null, false, KotlinBundle.message((String)"choose.an.appropriate.kotlin.class", (Object[])new Object[0]));
        builder2.replaceElement(primaryReplacedExpression, this.PRIMARY_USAGE, (Expression)expression, true);
        Iterator<? extends PsiElement> iterator2 = replacedElements.iterator();
        while (iterator2.hasNext()) {
            PsiElement replacedExpression;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (replacedExpression == primaryReplacedExpression) continue;
            builder2.replaceElement(replacedExpression, this.OTHER_USAGE, this.PRIMARY_USAGE, false);
        }
        TemplateManager.getInstance((Project)project).startTemplate(editor, builder2.buildInlineTemplate(), (TemplateEditingListener)new TemplateEditingAdapter(caretModel2, oldOffset){
            final /* synthetic */ CaretModel $caretModel;
            final /* synthetic */ int $oldOffset;
            {
                this.$caretModel = $caretModel;
                this.$oldOffset = $oldOffset;
            }

            public void templateFinished(Template template2, boolean brokenOff) {
                Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                this.$caretModel.moveToOffset(this.$oldOffset);
            }
        });
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0014J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactoryWithDelegate;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "Lorg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix$Companion$Data;", "<init>", "()V", "getElementOfInterest", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "extractFixData", "element", "createFix", "Lcom/intellij/codeInsight/intention/IntentionAction;", "originalElement", "data", "resolveToClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "referenceExpression", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getImportOrUsageFromDiagnostic", "Data", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nMapPlatformClassToKotlinFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapPlatformClassToKotlinFix.kt\norg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,182:1\n23#2,2:183\n253#3:185\n253#3:186\n*S KotlinDebug\n*F\n+ 1 MapPlatformClassToKotlinFix.kt\norg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix$Companion\n*L\n169#1:183,2\n173#1:185\n177#1:186\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactoryWithDelegate<KtReferenceExpression, Data> {
        private Companion() {
            super(null, 1, null);
        }

        @Override
        @Nullable
        public KtReferenceExpression getElementOfInterest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            return this.getImportOrUsageFromDiagnostic(diagnostic);
        }

        @Override
        @Nullable
        public Data extractFixData(@NotNull KtReferenceExpression element, @NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            BindingContext context2 = ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL);
            ClassDescriptor classDescriptor = this.resolveToClass(element, context2);
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor platformClass = classDescriptor;
            Object object = ((DiagnosticWithParameters1)Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN.cast((UnboundDiagnostic)diagnostic)).getA();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
            Collection possibleClasses = (Collection)object;
            return new Data(platformClass, possibleClasses);
        }

        @Override
        @NotNull
        protected IntentionAction createFix(@NotNull KtReferenceExpression originalElement, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new MapPlatformClassToKotlinFix(originalElement, data.getPlatformClass(), data.getPossibleClasses());
        }

        private final ClassDescriptor resolveToClass(KtReferenceExpression referenceExpression, BindingContext context2) {
            Object v0;
            block1: {
                Iterable $this$firstIsInstanceOrNull$iv = KtReferenceKt.resolveToDescriptors(ReferenceUtilsKt.getMainReference((KtReferenceExpression)referenceExpression), context2);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof ClassDescriptor)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final KtReferenceExpression getImportOrUsageFromDiagnostic(Diagnostic diagnostic) {
            KtReferenceExpression ktReferenceExpression;
            PsiElement $this$getNonStrictParentOfType$iv = diagnostic.getPsiElement();
            boolean $i$f$getNonStrictParentOfType = false;
            KtImportDirective ktImportDirective = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtImportDirective.class, (boolean)false);
            if (ktImportDirective != null) {
                KtElement ktElement;
                KtExpression ktExpression = ktImportDirective.getImportedReference();
                Object object = ktElement = ktExpression != null ? KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression)) : null;
                ktReferenceExpression = ktElement instanceof KtReferenceExpression ? (KtReferenceExpression)ktElement : null;
            } else {
                PsiElement $this$getNonStrictParentOfType$iv2 = diagnostic.getPsiElement();
                boolean $i$f$getNonStrictParentOfType2 = false;
                KtUserType ktUserType = (KtUserType)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv2, KtUserType.class, (boolean)false);
                if (ktUserType == null) {
                    return null;
                }
                ktReferenceExpression = (KtReferenceExpression)ktUserType.getReferenceExpression();
            }
            return ktReferenceExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MapPlatformClassToKotlinFix$Companion$Data;", "", "platformClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "possibleClasses", "", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/Collection;)V", "getPlatformClass", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getPossibleClasses", "()Ljava/util/Collection;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
        public static final class Data {
            @NotNull
            private final ClassDescriptor platformClass;
            @NotNull
            private final Collection<ClassDescriptor> possibleClasses;

            public Data(@NotNull ClassDescriptor platformClass, @NotNull Collection<? extends ClassDescriptor> possibleClasses) {
                Intrinsics.checkNotNullParameter((Object)platformClass, (String)"platformClass");
                Intrinsics.checkNotNullParameter(possibleClasses, (String)"possibleClasses");
                this.platformClass = platformClass;
                this.possibleClasses = possibleClasses;
            }

            @NotNull
            public final ClassDescriptor getPlatformClass() {
                return this.platformClass;
            }

            @NotNull
            public final Collection<ClassDescriptor> getPossibleClasses() {
                return this.possibleClasses;
            }

            @NotNull
            public final ClassDescriptor component1() {
                return this.platformClass;
            }

            @NotNull
            public final Collection<ClassDescriptor> component2() {
                return this.possibleClasses;
            }

            @NotNull
            public final Data copy(@NotNull ClassDescriptor platformClass, @NotNull Collection<? extends ClassDescriptor> possibleClasses) {
                Intrinsics.checkNotNullParameter((Object)platformClass, (String)"platformClass");
                Intrinsics.checkNotNullParameter(possibleClasses, (String)"possibleClasses");
                return new Data(platformClass, possibleClasses);
            }

            public static /* synthetic */ Data copy$default(Data data, ClassDescriptor classDescriptor, Collection collection, int n, Object object) {
                if ((n & 1) != 0) {
                    classDescriptor = data.platformClass;
                }
                if ((n & 2) != 0) {
                    collection = data.possibleClasses;
                }
                return data.copy(classDescriptor, collection);
            }

            @NotNull
            public String toString() {
                return "Data(platformClass=" + this.platformClass + ", possibleClasses=" + this.possibleClasses + ")";
            }

            public int hashCode() {
                int result2 = this.platformClass.hashCode();
                result2 = result2 * 31 + ((Object)this.possibleClasses).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Data)) {
                    return false;
                }
                Data data = (Data)other;
                if (!Intrinsics.areEqual((Object)this.platformClass, (Object)data.platformClass)) {
                    return false;
                }
                return Intrinsics.areEqual(this.possibleClasses, data.possibleClasses);
            }
        }
    }
}

