/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run.multiplatform;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.MultipleRunLocationsProvider;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.run.multiplatform.KotlinMultiplatformRunLocationsProviderKt;

@InternalIgnoreDependencyViolation
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u001e\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\n2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/run/multiplatform/KotlinMultiplatformRunLocationsProvider;", "Lcom/intellij/execution/actions/MultipleRunLocationsProvider;", "<init>", "()V", "getLocationDisplayName", "", "locationCreatedFrom", "Lcom/intellij/execution/Location;", "originalLocation", "getAlternativeLocations", "", "intellij.kotlin.base.codeInsight"})
@SourceDebugExtension(value={"SMAP\nKotlinMultiplatformRunLocationsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMultiplatformRunLocationsProvider.kt\norg/jetbrains/kotlin/idea/run/multiplatform/KotlinMultiplatformRunLocationsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1563#2:62\n1634#2,3:63\n*S KotlinDebug\n*F\n+ 1 KotlinMultiplatformRunLocationsProvider.kt\norg/jetbrains/kotlin/idea/run/multiplatform/KotlinMultiplatformRunLocationsProvider\n*L\n38#1:62\n38#1:63,3\n*E\n"})
public final class KotlinMultiplatformRunLocationsProvider
extends MultipleRunLocationsProvider {
    @Nullable
    public String getLocationDisplayName(@NotNull Location<?> locationCreatedFrom, @NotNull Location<?> originalLocation) {
        Intrinsics.checkNotNullParameter(locationCreatedFrom, (String)"locationCreatedFrom");
        Intrinsics.checkNotNullParameter(originalLocation, (String)"originalLocation");
        Module module = locationCreatedFrom.getModule();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        String name2 = KotlinMultiplatformRunLocationsProviderKt.access$compactedGradleProjectId(module2);
        return "[" + name2 + "]";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Location<?>> getAlternativeLocations(@NotNull Location<?> originalLocation) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(originalLocation, (String)"originalLocation");
        Module module = originalLocation.getModule();
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module originalModule = module;
        if (KotlinFacetUtils.isNewMultiPlatformModule(originalModule)) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = originalLocation.getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)originalModule.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        KotlinSourceRootType kotlinSourceRootType = KotlinProjectStructureUtils.getKotlinSourceRootType(projectFileIndex2, virtualFile2);
        if (kotlinSourceRootType == null) {
            return CollectionsKt.emptyList();
        }
        KotlinSourceRootType sourceType = kotlinSourceRootType;
        Iterable $this$map$iv = KotlinMultiplatformRunLocationsProviderKt.access$modulesToRunFrom(originalModule, sourceType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module module2 = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PsiLocation(originalLocation.getProject(), (Module)it, originalLocation.getPsiElement()));
        }
        return (List)destination$iv$iv;
    }
}

