/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;

public class Struct {
    private final Schema schema;
    private final Object[] values;

    Struct(Schema schema, Object[] values) {
        this.schema = schema;
        this.values = values;
    }

    public Struct(Schema schema) {
        this.schema = schema;
        this.values = new Object[this.schema.numFields()];
    }

    public Schema schema() {
        return this.schema;
    }

    private Object getFieldOrDefault(BoundField field) {
        Object value = this.values[field.index];
        if (value != null) {
            return value;
        }
        if (field.def.hasDefaultValue) {
            return field.def.defaultValue;
        }
        if (field.def.type.isNullable()) {
            return null;
        }
        throw new SchemaException("Missing value for field '" + field.def.name + "' which has no default value.");
    }

    public Object get(BoundField field) {
        this.validateField(field);
        return this.getFieldOrDefault(field);
    }

    public Object get(String name) {
        BoundField field = this.schema.get(name);
        if (field == null) {
            throw new SchemaException("No such field: " + name);
        }
        return this.getFieldOrDefault(field);
    }

    public boolean hasField(String name) {
        return this.schema.get(name) != null;
    }

    public Short getShort(String name) {
        return (Short)this.get(name);
    }

    public Integer getInt(String name) {
        return (Integer)this.get(name);
    }

    public Long getLong(String name) {
        return (Long)this.get(name);
    }

    public Object[] getArray(String name) {
        return (Object[])this.get(name);
    }

    public String getString(String name) {
        return (String)this.get(name);
    }

    public ByteBuffer getBytes(String name) {
        Object result = this.get(name);
        if (result instanceof byte[]) {
            return ByteBuffer.wrap((byte[])result);
        }
        return (ByteBuffer)result;
    }

    public Struct set(BoundField field, Object value) {
        this.validateField(field);
        this.values[field.index] = value;
        return this;
    }

    public Struct set(String name, Object value) {
        BoundField field = this.schema.get(name);
        if (field == null) {
            throw new SchemaException("Unknown field: " + name);
        }
        this.values[field.index] = value;
        return this;
    }

    public Struct instance(BoundField field) {
        this.validateField(field);
        if (field.def.type instanceof Schema) {
            return new Struct((Schema)field.def.type);
        }
        if (field.def.type.isArray()) {
            return new Struct((Schema)field.def.type.arrayElementType().get());
        }
        throw new SchemaException("Field '" + field.def.name + "' is not a container type, it is of type " + String.valueOf(field.def.type));
    }

    public Struct instance(String field) {
        return this.instance(this.schema.get(field));
    }

    public Struct instance(Field field) {
        return this.instance(this.schema.get(field.name));
    }

    public void clear() {
        Arrays.fill(this.values, null);
    }

    public int sizeOf() {
        return this.schema.sizeOf(this);
    }

    public void writeTo(ByteBuffer buffer) {
        this.schema.write(buffer, this);
    }

    private void validateField(BoundField field) {
        Objects.requireNonNull(field, "`field` must be non-null");
        if (this.schema != field.schema) {
            throw new SchemaException("Attempt to access field '" + field.def.name + "' from a different schema instance.");
        }
        if (field.index > this.values.length) {
            throw new SchemaException("Invalid field index: " + field.index);
        }
    }

    public void validate() {
        this.schema.validate(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < this.values.length; ++i) {
            BoundField f = this.schema.get(i);
            b.append(f.def.name);
            b.append('=');
            if (f.def.type.isArray() && this.values[i] != null) {
                Object[] arrayValue = (Object[])this.values[i];
                b.append('[');
                for (int j = 0; j < arrayValue.length; ++j) {
                    b.append(arrayValue[j]);
                    if (j >= arrayValue.length - 1) continue;
                    b.append(',');
                }
                b.append(']');
            } else {
                b.append(this.values[i]);
            }
            if (i >= this.values.length - 1) continue;
            b.append(',');
        }
        b.append('}');
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (int i = 0; i < this.values.length; ++i) {
            BoundField f = this.schema.get(i);
            if (f.def.type.isArray()) {
                Object[] arrayObject;
                if (this.get(f) == null) continue;
                for (Object arrayItem : arrayObject = (Object[])this.get(f)) {
                    result = 31 * result + arrayItem.hashCode();
                }
                continue;
            }
            Object field = this.get(f);
            if (field == null) continue;
            result = 31 * result + field.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Struct other = (Struct)obj;
        if (this.schema != other.schema) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            boolean result;
            BoundField f = this.schema.get(i);
            if (f.def.type.isArray()) {
                result = Arrays.equals((Object[])this.get(f), (Object[])other.get(f));
            } else {
                Object thisField = this.get(f);
                Object otherField = other.get(f);
                result = Objects.equals(thisField, otherField);
            }
            if (result) continue;
            return false;
        }
        return true;
    }
}

