/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.image.ClientQuotaImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.node.ClientQuotaImageNode;
import org.apache.kafka.image.node.MetadataNode;

public class ClientQuotasImageNode
implements MetadataNode {
    public static final String NAME = "clientQuotas";
    private final ClientQuotasImage image;

    public ClientQuotasImageNode(ClientQuotasImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> childNames = new ArrayList<String>();
        for (ClientQuotaEntity entity : this.image.entities().keySet()) {
            childNames.add(ClientQuotasImageNode.clientQuotaEntityToString(entity));
        }
        return childNames;
    }

    static String clientQuotaEntityToString(ClientQuotaEntity entity) {
        if (entity.entries().isEmpty()) {
            throw new RuntimeException("Invalid empty entity");
        }
        String clientId = null;
        String ip = null;
        String user = null;
        block10: for (Map.Entry entry : entity.entries().entrySet()) {
            switch ((String)entry.getKey()) {
                case "client-id": {
                    clientId = (String)entry.getValue();
                    continue block10;
                }
                case "ip": {
                    ip = (String)entry.getValue();
                    continue block10;
                }
                case "user": {
                    user = (String)entry.getValue();
                    continue block10;
                }
            }
            throw new RuntimeException("Invalid entity type " + (String)entry.getKey());
        }
        StringBuilder bld = new StringBuilder();
        String prefix = "";
        if (clientId != null) {
            bld.append(prefix).append("clientId(").append(ClientQuotasImageNode.escape(clientId)).append(")");
            prefix = "_";
        }
        if (ip != null) {
            bld.append(prefix).append("ip(").append(ClientQuotasImageNode.escape(ip)).append(")");
            prefix = "_";
        }
        if (user != null) {
            bld.append(prefix).append("user(").append(ClientQuotasImageNode.escape(user)).append(")");
        }
        return bld.toString();
    }

    static String escape(String input) {
        return input.replace("\\", "\\\\").replace("(", "\\(").replace(")", "\\)");
    }

    @Override
    public MetadataNode child(String name) {
        ClientQuotaEntity entity = ClientQuotasImageNode.decodeEntity(name);
        if (entity == null) {
            return null;
        }
        ClientQuotaImage clientQuotaImage = this.image.entities().get(entity);
        if (clientQuotaImage == null) {
            return null;
        }
        return new ClientQuotaImageNode(clientQuotaImage);
    }

    static ClientQuotaEntity decodeEntity(String input) {
        HashMap<String, String> entries = new HashMap<String, String>();
        String type = null;
        StringBuilder value = new StringBuilder();
        boolean escaping = false;
        int i = 0;
        while (true) {
            if (i >= input.length()) {
                return null;
            }
            if (type == null) {
                if (input.substring(i).startsWith("clientId(")) {
                    type = "client-id";
                    i += "clientId(".length();
                    continue;
                }
                if (input.substring(i).startsWith("ip(")) {
                    type = "ip";
                    i += "ip(".length();
                    continue;
                }
                if (input.substring(i).startsWith("user(")) {
                    type = "user";
                    i += "user(".length();
                    continue;
                }
                return null;
            }
            char c = input.charAt(i++);
            if (escaping) {
                value.append(c);
                escaping = false;
            } else {
                switch (c) {
                    case ')': {
                        entries.put(type, value.toString());
                        type = null;
                        value = new StringBuilder();
                        break;
                    }
                    case '\\': {
                        escaping = true;
                        break;
                    }
                    default: {
                        value.append(c);
                    }
                }
            }
            if (type != null) continue;
            if (i >= input.length()) {
                return new ClientQuotaEntity(entries);
            }
            if (input.charAt(i++) != '_') break;
        }
        return null;
    }
}

