/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.partition;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.partition.CommittedPartitionState;
import org.apache.kafka.server.partition.PendingPartitionChange;

public record PendingExpandIsr(int newInSyncReplicaId, LeaderAndIsr sentLeaderAndIsr, CommittedPartitionState lastCommittedState) implements PendingPartitionChange
{
    @Override
    public Set<Integer> isr() {
        return this.lastCommittedState.isr();
    }

    @Override
    public Set<Integer> maximalIsr() {
        HashSet<Integer> newIsr = new HashSet<Integer>(this.lastCommittedState.isr());
        newIsr.add(this.newInSyncReplicaId);
        return Collections.unmodifiableSet(newIsr);
    }

    @Override
    public LeaderRecoveryState leaderRecoveryState() {
        return LeaderRecoveryState.RECOVERED;
    }

    @Override
    public boolean isInflight() {
        return true;
    }

    @Override
    public String toString() {
        return "PendingExpandIsr(newInSyncReplicaId=" + this.newInSyncReplicaId + ", sentLeaderAndIsr=" + String.valueOf(this.sentLeaderAndIsr) + ", leaderRecoveryState=" + String.valueOf(this.leaderRecoveryState()) + ", lastCommittedState=" + String.valueOf(this.lastCommittedState) + ")";
    }
}

