/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Ids;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.EventType;

@Scope(value=Scopes.NONE)
public class KeyValueFilterConverterAsCacheEventFilterConverter<K, V, C>
implements CacheEventFilterConverter<K, V, C> {
    private final KeyValueFilterConverter<K, V, C> keyValueFilterConverter;
    private final MediaType format;

    public KeyValueFilterConverterAsCacheEventFilterConverter(KeyValueFilterConverter<K, V, C> keyValueFilterConverter) {
        this(keyValueFilterConverter, MediaType.APPLICATION_OBJECT);
    }

    public KeyValueFilterConverterAsCacheEventFilterConverter(KeyValueFilterConverter<K, V, C> keyValueFilterConverter, MediaType format) {
        this.keyValueFilterConverter = keyValueFilterConverter;
        this.format = format == MediaType.APPLICATION_UNKNOWN ? null : format;
    }

    @Override
    public C filterAndConvert(K key, V oldValue, Metadata oldMetadata, V newValue, Metadata newMetadata, EventType eventType) {
        return this.keyValueFilterConverter.convert(key, newValue, newMetadata);
    }

    @Override
    public C convert(K key, V oldValue, Metadata oldMetadata, V newValue, Metadata newMetadata, EventType eventType) {
        return this.keyValueFilterConverter.convert(key, newValue, newMetadata);
    }

    @Override
    public boolean accept(K key, V oldValue, Metadata oldMetadata, V newValue, Metadata newMetadata, EventType eventType) {
        return this.keyValueFilterConverter.accept(key, newValue, newMetadata);
    }

    @Override
    public MediaType format() {
        return this.format;
    }

    @Override
    public boolean includeOldValue() {
        return false;
    }

    @Inject
    protected void injectDependencies(ComponentRegistry cr) {
        cr.wireDependencies(this.keyValueFilterConverter);
    }

    public static class Externalizer
    implements AdvancedExternalizer<KeyValueFilterConverterAsCacheEventFilterConverter> {
        public void writeObject(ObjectOutput output, KeyValueFilterConverterAsCacheEventFilterConverter object) throws IOException {
            output.writeObject(object.keyValueFilterConverter);
            output.writeObject(object.format);
        }

        public KeyValueFilterConverterAsCacheEventFilterConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new KeyValueFilterConverterAsCacheEventFilterConverter((KeyValueFilterConverter)input.readObject(), (MediaType)input.readObject());
        }

        public Set<Class<? extends KeyValueFilterConverterAsCacheEventFilterConverter>> getTypeClasses() {
            return Collections.singleton(KeyValueFilterConverterAsCacheEventFilterConverter.class);
        }

        public Integer getId() {
            return Ids.KEY_VALUE_FILTER_CONVERTER_AS_CACHE_EVENT_FILTER_CONVERTER;
        }
    }
}

