/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.CompilerFlags;
import io.quarkus.deployment.dev.filesystem.QuarkusFileManager;
import io.quarkus.deployment.dev.filesystem.ReloadableFileManager;
import io.quarkus.deployment.dev.filesystem.StaticFileManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.jboss.logging.Logger;

public class JavaCompilationProvider
implements CompilationProvider {
    private static final Logger LOG = Logger.getLogger(JavaCompilationProvider.class);
    private static final Set<String> COMPILER_OPTIONS = Set.of("-g", "-parameters");
    private static final Set<String> IGNORE_NAMESPACES = Set.of("org.osgi", "Annotation processing is enabled because");
    private static final String PROVIDER_KEY = "java";
    private JavaCompiler compiler;
    private List<String> compilerFlags;
    private QuarkusFileManager fileManager;

    @Override
    public String getProviderKey() {
        return PROVIDER_KEY;
    }

    @Override
    public Set<String> handledExtensions() {
        return Set.of(".java");
    }

    @Override
    public void compile(Set<File> filesToCompile, CompilationProvider.Context context) {
        JavaCompiler compiler;
        if (this.compiler == null) {
            this.compiler = ToolProvider.getSystemJavaCompiler();
            this.compilerFlags = new CompilerFlags(COMPILER_OPTIONS, context.getCompilerOptions(PROVIDER_KEY), context.getReleaseJavaVersion(), context.getSourceJavaVersion(), context.getTargetJvmVersion(), context.getAnnotationProcessors()).toList();
        }
        if ((compiler = this.compiler) == null) {
            throw new RuntimeException("No system java compiler provided");
        }
        QuarkusFileManager.Context sourcesContext = new QuarkusFileManager.Context(context.getClasspath(), context.getReloadableClasspath(), context.getOutputDirectory(), context.getGeneratedSourcesDirectory(), context.getAnnotationProcessorPaths(), context.getSourceEncoding(), context.ignoreModuleInfo());
        if (this.fileManager == null) {
            Supplier<StandardJavaFileManager> supplier = () -> {
                Charset charset = context.getSourceEncoding();
                return compiler.getStandardFileManager(null, null, charset);
            };
            this.fileManager = context.getReloadableClasspath().isEmpty() ? new StaticFileManager(supplier, sourcesContext) : new ReloadableFileManager(supplier, sourcesContext);
        } else {
            this.fileManager.reset(sourcesContext);
        }
        DiagnosticCollector<JavaFileObject> diagnosticsCollector = new DiagnosticCollector<JavaFileObject>();
        Iterable<? extends JavaFileObject> sources = this.fileManager.getJavaSources(filesToCompile);
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.fileManager, diagnosticsCollector, this.compilerFlags, null, sources);
        boolean compilationTaskSucceed = task.call();
        if (LOG.isEnabled(Logger.Level.ERROR) || LOG.isEnabled(Logger.Level.WARN)) {
            this.collectDiagnostics(diagnosticsCollector, (level, diagnostic) -> LOG.logf(level, "%s, line %d in %s", (Object)diagnostic.getMessage(null), (Object)diagnostic.getLineNumber(), (Object)(diagnostic.getSource() == null ? "[unknown source]" : ((JavaFileObject)diagnostic.getSource()).getName())));
        }
        if (!compilationTaskSucceed) {
            String errorMessage = this.extractCompilationErrorMessage(diagnosticsCollector);
            throw new RuntimeException(errorMessage);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileManager != null) {
            this.fileManager.close();
            this.fileManager = null;
        }
    }

    private void collectDiagnostics(DiagnosticCollector<JavaFileObject> diagnosticsCollector, BiConsumer<Logger.Level, Diagnostic<? extends JavaFileObject>> callback) {
        for (Diagnostic<JavaFileObject> diagnostic : diagnosticsCollector.getDiagnostics()) {
            Logger.Level level;
            Logger.Level level2 = level = diagnostic.getKind() == Diagnostic.Kind.ERROR ? Logger.Level.ERROR : Logger.Level.WARN;
            if (level.equals((Object)Logger.Level.WARN)) {
                if (IGNORE_NAMESPACES.stream().anyMatch(diagnostic.getMessage(null)::contains)) continue;
            }
            callback.accept(level, diagnostic);
        }
    }

    private String extractCompilationErrorMessage(DiagnosticCollector<JavaFileObject> diagnosticsCollector) {
        StringBuilder builder = new StringBuilder();
        diagnosticsCollector.getDiagnostics().forEach(diagnostic -> builder.append("\n").append(diagnostic));
        return String.format("\u001b[91mCompilation Failed:%s\u001b[0m", builder);
    }
}

