/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiIfEmpty;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiOnCompletionCall;
import io.smallrye.mutiny.operators.multi.MultiOnCompletionInvoke;
import io.smallrye.mutiny.operators.multi.MultiSwitchOnCompletion;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class MultiOnCompletion<T> {
    private final Multi<T> upstream;

    public MultiOnCompletion(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public Multi<T> invoke(Runnable action) {
        Runnable runnable = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return Infrastructure.onMultiCreation(new MultiOnCompletionInvoke<T>(this.upstream, runnable));
    }

    @CheckReturnValue
    public Multi<T> call(Supplier<Uni<?>> supplier) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onMultiCreation(new MultiOnCompletionCall<T>(this.upstream, actual));
    }

    @CheckReturnValue
    public Multi<T> failWith(Throwable failure) {
        ParameterValidation.nonNull(failure, "failure");
        return this.failWith(() -> failure);
    }

    @CheckReturnValue
    public Multi<T> failWith(Supplier<Throwable> supplier) {
        Supplier<Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.switchToEmitter(MultiIfEmpty.createMultiFromFailureSupplier(actual));
    }

    @CheckReturnValue
    public Multi<T> fail() {
        return this.failWith(NoSuchElementException::new);
    }

    @CheckReturnValue
    public Multi<T> switchToEmitter(Consumer<MultiEmitter<? super T>> consumer) {
        Consumer actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return this.switchTo(() -> Multi.createFrom().emitter(actual));
    }

    @CheckReturnValue
    public Multi<T> switchTo(Flow.Publisher<? extends T> other) {
        return this.switchTo(() -> other);
    }

    @CheckReturnValue
    public Multi<T> switchTo(Supplier<Flow.Publisher<? extends T>> supplier) {
        Supplier<Flow.Publisher<? extends T>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return Infrastructure.onMultiCreation(new MultiSwitchOnCompletion<T>(this.upstream, actual));
    }

    @SafeVarargs
    @CheckReturnValue
    public final Multi<T> continueWith(T ... items) {
        ParameterValidation.nonNull(items, "items");
        ParameterValidation.doesNotContainNull(items, "items");
        return this.continueWith(() -> Arrays.asList(items));
    }

    @CheckReturnValue
    public Multi<T> continueWith(Iterable<T> items) {
        ParameterValidation.nonNull(items, "items");
        ParameterValidation.doesNotContainNull(items, "items");
        return this.continueWith(() -> items);
    }

    @CheckReturnValue
    public Multi<T> continueWith(Supplier<? extends Iterable<? extends T>> supplier) {
        Supplier actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.switchTo(() -> MultiIfEmpty.createMultiFromIterableSupplier(actual));
    }

    @CheckReturnValue
    public MultiIfEmpty<T> ifEmpty() {
        return new MultiIfEmpty<T>(this.upstream);
    }
}

