/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi.page;

import io.quarkus.devui.spi.page.AbstractPageBuildItem;
import io.quarkus.devui.spi.page.Card;
import io.quarkus.devui.spi.page.LibraryLink;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class CardPageBuildItem
extends AbstractPageBuildItem {
    private Optional<Card> optionalCard = Optional.empty();
    private List<LibraryLink> libraryVersions;
    private String darkLogo;
    private String lightLogo;

    public void setCustomCard(String cardComponent) {
        if (cardComponent != null) {
            this.optionalCard = Optional.of(new Card(cardComponent));
        }
    }

    public Optional<Card> getOptionalCard() {
        return this.optionalCard;
    }

    public void addLibraryVersion(String groupId, String artifactId, String name, String url) {
        try {
            this.addLibraryVersion(groupId, artifactId, name, URI.create(url).toURL());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void addLibraryVersion(String groupId, String artifactId, String name, URL url) {
        if (this.libraryVersions == null) {
            this.libraryVersions = new ArrayList<LibraryLink>();
        }
        this.libraryVersions.add(new LibraryLink(groupId, artifactId, name, url));
    }

    public List<LibraryLink> getLibraryVersions() {
        return this.libraryVersions == null ? Collections.emptyList() : this.libraryVersions;
    }

    public boolean hasLibraryVersions() {
        return this.libraryVersions != null && !this.libraryVersions.isEmpty();
    }

    public void setLogo(String darkLogo, String lightLogo) {
        this.darkLogo = darkLogo;
        this.lightLogo = lightLogo;
    }

    public boolean hasLogo() {
        return this.darkLogo != null && this.lightLogo != null;
    }

    public String getDarkLogo() {
        return this.darkLogo;
    }

    public String getLightLogo() {
        return this.lightLogo;
    }
}

