/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.keybinding;

import java.util.List;
import java.util.Optional;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.VCIssuerException;
import org.keycloak.protocol.oid4vc.issuance.keybinding.AbstractProofValidator;
import org.keycloak.protocol.oid4vc.issuance.keybinding.AttestationKeyResolver;
import org.keycloak.protocol.oid4vc.issuance.keybinding.AttestationValidatorUtil;
import org.keycloak.protocol.oid4vc.model.KeyAttestationJwtBody;
import org.keycloak.protocol.oid4vc.model.Proofs;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;

public class AttestationProofValidator
extends AbstractProofValidator {
    private final AttestationKeyResolver keyResolver;

    public AttestationProofValidator(KeycloakSession session, AttestationKeyResolver keyResolver) {
        super(session);
        this.keyResolver = keyResolver;
    }

    @Override
    public String getProofType() {
        return "attestation";
    }

    @Override
    public List<JWK> validateProof(VCIssuanceContext vcIssuanceContext) throws VCIssuerException {
        try {
            String jwt = this.extractAttestationProof(vcIssuanceContext);
            KeyAttestationJwtBody attestationBody = AttestationValidatorUtil.validateAttestationJwt(jwt, this.keycloakSession, vcIssuanceContext, this.keyResolver);
            if (attestationBody.getAttestedKeys() == null || attestationBody.getAttestedKeys().isEmpty()) {
                throw new VCIssuerException("No valid attested keys found in attestation proof");
            }
            return attestationBody.getAttestedKeys();
        }
        catch (VCIssuerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VCIssuerException("Failed to validate attestation proof: " + e.getMessage(), e);
        }
    }

    private String extractAttestationProof(VCIssuanceContext vcIssuanceContext) throws VCIssuerException {
        SupportedCredentialConfiguration config = Optional.ofNullable(vcIssuanceContext.getCredentialConfig()).orElseThrow(() -> new VCIssuerException("Credential configuration is missing"));
        if (config.getProofTypesSupported() == null || config.getProofTypesSupported().getSupportedProofTypes().get("attestation") == null) {
            throw new VCIssuerException("Attestation proof type not supported");
        }
        Proofs proofs = vcIssuanceContext.getCredentialRequest().getProofs();
        if (proofs == null || proofs.getAttestation() == null || proofs.getAttestation().isEmpty()) {
            throw new VCIssuerException("Expected a proof of type attestation: jwt");
        }
        if (proofs.getAttestation().size() > 1) {
            throw new VCIssuerException("Multiple attestation proofs found; only one is allowed");
        }
        return proofs.getAttestation().get(0);
    }
}

