/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayConcatElementFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class GaussDBArrayConcatElementFunction
extends ArrayConcatElementFunction {
    public GaussDBArrayConcatElementFunction(boolean prepend) {
        super("", "||", "", prepend);
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String elementCastType;
        Expression arrayArgument;
        Expression elementArgument;
        Expression firstArgument = (Expression)sqlAstArguments.get(0);
        Expression secondArgument = (Expression)sqlAstArguments.get(1);
        if (this.prepend) {
            elementArgument = firstArgument;
            arrayArgument = secondArgument;
        } else {
            arrayArgument = firstArgument;
            elementArgument = secondArgument;
        }
        if (GaussDBArrayConcatElementFunction.needsElementCasting(elementArgument)) {
            JdbcMappingContainer arrayType = arrayArgument.getExpressionType();
            Size size = arrayType instanceof SqlTypedMapping ? ((SqlTypedMapping)arrayType).toSize() : null;
            elementCastType = DdlTypeHelper.getCastTypeName((BasicType)((BasicPluralType)returnType).getElementType(), (Size)size, (TypeConfiguration)walker.getSessionFactory().getTypeConfiguration());
        } else {
            elementCastType = null;
        }
        sqlAppender.append((CharSequence)"case when ");
        walker.render((SqlAstNode)arrayArgument, SqlAstNodeRenderingMode.DEFAULT);
        sqlAppender.append((CharSequence)" is not null then ");
        if (this.prepend && elementCastType != null) {
            sqlAppender.append((CharSequence)"cast(");
            walker.render((SqlAstNode)firstArgument, SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.append((CharSequence)" as ");
            sqlAppender.append((CharSequence)elementCastType);
            sqlAppender.append(')');
        } else {
            walker.render((SqlAstNode)firstArgument, SqlAstNodeRenderingMode.DEFAULT);
        }
        sqlAppender.append((CharSequence)"||");
        if (!this.prepend && elementCastType != null) {
            sqlAppender.append((CharSequence)"cast(");
            walker.render((SqlAstNode)secondArgument, SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.append((CharSequence)" as ");
            sqlAppender.append((CharSequence)elementCastType);
            sqlAppender.append(')');
        } else {
            walker.render((SqlAstNode)secondArgument, SqlAstNodeRenderingMode.DEFAULT);
        }
        sqlAppender.append((CharSequence)" end");
    }

    private static boolean needsElementCasting(Expression elementExpression) {
        return elementExpression instanceof Literal && (elementExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString() || ((Literal)elementExpression).getLiteralValue() == null);
    }
}

