/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated C++-Header file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

#ifndef __LIB3MF_CPPHEADER_DYNAMIC_CPP
#define __LIB3MF_CPPHEADER_DYNAMIC_CPP

#include "lib3mf_types.hpp"
#include "lib3mf_dynamic.h"


#ifdef _WIN32
#include <windows.h>
#else // _WIN32
#include <dlfcn.h>
#endif // _WIN32
#include <array>
#include <string>
#include <memory>
#include <vector>
#include <exception>

namespace Lib3MF {

/*************************************************************************************************************************
 Forward Declaration of all classes
**************************************************************************************************************************/
class CWrapper;
class CBase;
class CWriter;
class CReader;
class CPackagePart;
class CResource;
class CResourceIterator;
class CSliceStackIterator;
class CObjectIterator;
class CMeshObjectIterator;
class CComponentsObjectIterator;
class CTexture2DIterator;
class CBaseMaterialGroupIterator;
class CColorGroupIterator;
class CTexture2DGroupIterator;
class CCompositeMaterialsIterator;
class CMultiPropertyGroupIterator;
class CImage3DIterator;
class CFunctionIterator;
class CLevelSetIterator;
class CMetaData;
class CMetaDataGroup;
class CTriangleSet;
class CObject;
class CMeshObject;
class CLevelSet;
class CBeamLattice;
class CFunctionReference;
class CVolumeDataColor;
class CMaterialMapping;
class CVolumeDataComposite;
class CVolumeDataProperty;
class CVolumeData;
class CComponent;
class CComponentsObject;
class CBeamSet;
class CBaseMaterialGroup;
class CColorGroup;
class CTexture2DGroup;
class CCompositeMaterials;
class CMultiPropertyGroup;
class CImage3D;
class CImageStack;
class CAttachment;
class CTexture2D;
class CImplicitPort;
class CIterator;
class CImplicitPortIterator;
class CImplicitNode;
class COneInputNode;
class CSinNode;
class CCosNode;
class CTanNode;
class CArcSinNode;
class CArcCosNode;
class CArcTanNode;
class CSinhNode;
class CCoshNode;
class CTanhNode;
class CRoundNode;
class CCeilNode;
class CFloorNode;
class CSignNode;
class CFractNode;
class CAbsNode;
class CExpNode;
class CLogNode;
class CLog2Node;
class CLog10Node;
class CLengthNode;
class CTransposeNode;
class CInverseNode;
class CSqrtNode;
class CResourceIdNode;
class CTwoInputNode;
class CAdditionNode;
class CSubtractionNode;
class CMultiplicationNode;
class CDivisionNode;
class CDotNode;
class CCrossNode;
class CArcTan2Node;
class CMatVecMultiplicationNode;
class CMinNode;
class CMaxNode;
class CFmodNode;
class CModNode;
class CPowNode;
class CSelectNode;
class CClampNode;
class CComposeVectorNode;
class CVectorFromScalarNode;
class CDecomposeVectorNode;
class CComposeMatrixNode;
class CMatrixFromRowsNode;
class CMatrixFromColumnsNode;
class CConstantNode;
class CConstVecNode;
class CConstMatNode;
class CMeshNode;
class CUnsignedMeshNode;
class CBeamLatticeNode;
class CFunctionGradientNode;
class CNormalizeDistanceNode;
class CFunctionCallNode;
class CNodeIterator;
class CFunction;
class CImplicitFunction;
class CFunctionFromImage3D;
class CBuildItem;
class CBuildItemIterator;
class CSlice;
class CSliceStack;
class CConsumer;
class CAccessRight;
class CContentEncryptionParams;
class CResourceData;
class CResourceDataGroup;
class CKeyStore;
class CModel;

/*************************************************************************************************************************
 Declaration of deprecated class types
**************************************************************************************************************************/
typedef CWrapper CLib3MFWrapper;
typedef CBase CLib3MFBase;
typedef CWriter CLib3MFWriter;
typedef CReader CLib3MFReader;
typedef CPackagePart CLib3MFPackagePart;
typedef CResource CLib3MFResource;
typedef CResourceIterator CLib3MFResourceIterator;
typedef CSliceStackIterator CLib3MFSliceStackIterator;
typedef CObjectIterator CLib3MFObjectIterator;
typedef CMeshObjectIterator CLib3MFMeshObjectIterator;
typedef CComponentsObjectIterator CLib3MFComponentsObjectIterator;
typedef CTexture2DIterator CLib3MFTexture2DIterator;
typedef CBaseMaterialGroupIterator CLib3MFBaseMaterialGroupIterator;
typedef CColorGroupIterator CLib3MFColorGroupIterator;
typedef CTexture2DGroupIterator CLib3MFTexture2DGroupIterator;
typedef CCompositeMaterialsIterator CLib3MFCompositeMaterialsIterator;
typedef CMultiPropertyGroupIterator CLib3MFMultiPropertyGroupIterator;
typedef CImage3DIterator CLib3MFImage3DIterator;
typedef CFunctionIterator CLib3MFFunctionIterator;
typedef CLevelSetIterator CLib3MFLevelSetIterator;
typedef CMetaData CLib3MFMetaData;
typedef CMetaDataGroup CLib3MFMetaDataGroup;
typedef CTriangleSet CLib3MFTriangleSet;
typedef CObject CLib3MFObject;
typedef CMeshObject CLib3MFMeshObject;
typedef CLevelSet CLib3MFLevelSet;
typedef CBeamLattice CLib3MFBeamLattice;
typedef CFunctionReference CLib3MFFunctionReference;
typedef CVolumeDataColor CLib3MFVolumeDataColor;
typedef CMaterialMapping CLib3MFMaterialMapping;
typedef CVolumeDataComposite CLib3MFVolumeDataComposite;
typedef CVolumeDataProperty CLib3MFVolumeDataProperty;
typedef CVolumeData CLib3MFVolumeData;
typedef CComponent CLib3MFComponent;
typedef CComponentsObject CLib3MFComponentsObject;
typedef CBeamSet CLib3MFBeamSet;
typedef CBaseMaterialGroup CLib3MFBaseMaterialGroup;
typedef CColorGroup CLib3MFColorGroup;
typedef CTexture2DGroup CLib3MFTexture2DGroup;
typedef CCompositeMaterials CLib3MFCompositeMaterials;
typedef CMultiPropertyGroup CLib3MFMultiPropertyGroup;
typedef CImage3D CLib3MFImage3D;
typedef CImageStack CLib3MFImageStack;
typedef CAttachment CLib3MFAttachment;
typedef CTexture2D CLib3MFTexture2D;
typedef CImplicitPort CLib3MFImplicitPort;
typedef CIterator CLib3MFIterator;
typedef CImplicitPortIterator CLib3MFImplicitPortIterator;
typedef CImplicitNode CLib3MFImplicitNode;
typedef COneInputNode CLib3MFOneInputNode;
typedef CSinNode CLib3MFSinNode;
typedef CCosNode CLib3MFCosNode;
typedef CTanNode CLib3MFTanNode;
typedef CArcSinNode CLib3MFArcSinNode;
typedef CArcCosNode CLib3MFArcCosNode;
typedef CArcTanNode CLib3MFArcTanNode;
typedef CSinhNode CLib3MFSinhNode;
typedef CCoshNode CLib3MFCoshNode;
typedef CTanhNode CLib3MFTanhNode;
typedef CRoundNode CLib3MFRoundNode;
typedef CCeilNode CLib3MFCeilNode;
typedef CFloorNode CLib3MFFloorNode;
typedef CSignNode CLib3MFSignNode;
typedef CFractNode CLib3MFFractNode;
typedef CAbsNode CLib3MFAbsNode;
typedef CExpNode CLib3MFExpNode;
typedef CLogNode CLib3MFLogNode;
typedef CLog2Node CLib3MFLog2Node;
typedef CLog10Node CLib3MFLog10Node;
typedef CLengthNode CLib3MFLengthNode;
typedef CTransposeNode CLib3MFTransposeNode;
typedef CInverseNode CLib3MFInverseNode;
typedef CSqrtNode CLib3MFSqrtNode;
typedef CResourceIdNode CLib3MFResourceIdNode;
typedef CTwoInputNode CLib3MFTwoInputNode;
typedef CAdditionNode CLib3MFAdditionNode;
typedef CSubtractionNode CLib3MFSubtractionNode;
typedef CMultiplicationNode CLib3MFMultiplicationNode;
typedef CDivisionNode CLib3MFDivisionNode;
typedef CDotNode CLib3MFDotNode;
typedef CCrossNode CLib3MFCrossNode;
typedef CArcTan2Node CLib3MFArcTan2Node;
typedef CMatVecMultiplicationNode CLib3MFMatVecMultiplicationNode;
typedef CMinNode CLib3MFMinNode;
typedef CMaxNode CLib3MFMaxNode;
typedef CFmodNode CLib3MFFmodNode;
typedef CModNode CLib3MFModNode;
typedef CPowNode CLib3MFPowNode;
typedef CSelectNode CLib3MFSelectNode;
typedef CClampNode CLib3MFClampNode;
typedef CComposeVectorNode CLib3MFComposeVectorNode;
typedef CVectorFromScalarNode CLib3MFVectorFromScalarNode;
typedef CDecomposeVectorNode CLib3MFDecomposeVectorNode;
typedef CComposeMatrixNode CLib3MFComposeMatrixNode;
typedef CMatrixFromRowsNode CLib3MFMatrixFromRowsNode;
typedef CMatrixFromColumnsNode CLib3MFMatrixFromColumnsNode;
typedef CConstantNode CLib3MFConstantNode;
typedef CConstVecNode CLib3MFConstVecNode;
typedef CConstMatNode CLib3MFConstMatNode;
typedef CMeshNode CLib3MFMeshNode;
typedef CUnsignedMeshNode CLib3MFUnsignedMeshNode;
typedef CBeamLatticeNode CLib3MFBeamLatticeNode;
typedef CFunctionGradientNode CLib3MFFunctionGradientNode;
typedef CNormalizeDistanceNode CLib3MFNormalizeDistanceNode;
typedef CFunctionCallNode CLib3MFFunctionCallNode;
typedef CNodeIterator CLib3MFNodeIterator;
typedef CFunction CLib3MFFunction;
typedef CImplicitFunction CLib3MFImplicitFunction;
typedef CFunctionFromImage3D CLib3MFFunctionFromImage3D;
typedef CBuildItem CLib3MFBuildItem;
typedef CBuildItemIterator CLib3MFBuildItemIterator;
typedef CSlice CLib3MFSlice;
typedef CSliceStack CLib3MFSliceStack;
typedef CConsumer CLib3MFConsumer;
typedef CAccessRight CLib3MFAccessRight;
typedef CContentEncryptionParams CLib3MFContentEncryptionParams;
typedef CResourceData CLib3MFResourceData;
typedef CResourceDataGroup CLib3MFResourceDataGroup;
typedef CKeyStore CLib3MFKeyStore;
typedef CModel CLib3MFModel;

/*************************************************************************************************************************
 Declaration of shared pointer types
**************************************************************************************************************************/
typedef std::shared_ptr<CWrapper> PWrapper;
typedef std::shared_ptr<CBase> PBase;
typedef std::shared_ptr<CWriter> PWriter;
typedef std::shared_ptr<CReader> PReader;
typedef std::shared_ptr<CPackagePart> PPackagePart;
typedef std::shared_ptr<CResource> PResource;
typedef std::shared_ptr<CResourceIterator> PResourceIterator;
typedef std::shared_ptr<CSliceStackIterator> PSliceStackIterator;
typedef std::shared_ptr<CObjectIterator> PObjectIterator;
typedef std::shared_ptr<CMeshObjectIterator> PMeshObjectIterator;
typedef std::shared_ptr<CComponentsObjectIterator> PComponentsObjectIterator;
typedef std::shared_ptr<CTexture2DIterator> PTexture2DIterator;
typedef std::shared_ptr<CBaseMaterialGroupIterator> PBaseMaterialGroupIterator;
typedef std::shared_ptr<CColorGroupIterator> PColorGroupIterator;
typedef std::shared_ptr<CTexture2DGroupIterator> PTexture2DGroupIterator;
typedef std::shared_ptr<CCompositeMaterialsIterator> PCompositeMaterialsIterator;
typedef std::shared_ptr<CMultiPropertyGroupIterator> PMultiPropertyGroupIterator;
typedef std::shared_ptr<CImage3DIterator> PImage3DIterator;
typedef std::shared_ptr<CFunctionIterator> PFunctionIterator;
typedef std::shared_ptr<CLevelSetIterator> PLevelSetIterator;
typedef std::shared_ptr<CMetaData> PMetaData;
typedef std::shared_ptr<CMetaDataGroup> PMetaDataGroup;
typedef std::shared_ptr<CTriangleSet> PTriangleSet;
typedef std::shared_ptr<CObject> PObject;
typedef std::shared_ptr<CMeshObject> PMeshObject;
typedef std::shared_ptr<CLevelSet> PLevelSet;
typedef std::shared_ptr<CBeamLattice> PBeamLattice;
typedef std::shared_ptr<CFunctionReference> PFunctionReference;
typedef std::shared_ptr<CVolumeDataColor> PVolumeDataColor;
typedef std::shared_ptr<CMaterialMapping> PMaterialMapping;
typedef std::shared_ptr<CVolumeDataComposite> PVolumeDataComposite;
typedef std::shared_ptr<CVolumeDataProperty> PVolumeDataProperty;
typedef std::shared_ptr<CVolumeData> PVolumeData;
typedef std::shared_ptr<CComponent> PComponent;
typedef std::shared_ptr<CComponentsObject> PComponentsObject;
typedef std::shared_ptr<CBeamSet> PBeamSet;
typedef std::shared_ptr<CBaseMaterialGroup> PBaseMaterialGroup;
typedef std::shared_ptr<CColorGroup> PColorGroup;
typedef std::shared_ptr<CTexture2DGroup> PTexture2DGroup;
typedef std::shared_ptr<CCompositeMaterials> PCompositeMaterials;
typedef std::shared_ptr<CMultiPropertyGroup> PMultiPropertyGroup;
typedef std::shared_ptr<CImage3D> PImage3D;
typedef std::shared_ptr<CImageStack> PImageStack;
typedef std::shared_ptr<CAttachment> PAttachment;
typedef std::shared_ptr<CTexture2D> PTexture2D;
typedef std::shared_ptr<CImplicitPort> PImplicitPort;
typedef std::shared_ptr<CIterator> PIterator;
typedef std::shared_ptr<CImplicitPortIterator> PImplicitPortIterator;
typedef std::shared_ptr<CImplicitNode> PImplicitNode;
typedef std::shared_ptr<COneInputNode> POneInputNode;
typedef std::shared_ptr<CSinNode> PSinNode;
typedef std::shared_ptr<CCosNode> PCosNode;
typedef std::shared_ptr<CTanNode> PTanNode;
typedef std::shared_ptr<CArcSinNode> PArcSinNode;
typedef std::shared_ptr<CArcCosNode> PArcCosNode;
typedef std::shared_ptr<CArcTanNode> PArcTanNode;
typedef std::shared_ptr<CSinhNode> PSinhNode;
typedef std::shared_ptr<CCoshNode> PCoshNode;
typedef std::shared_ptr<CTanhNode> PTanhNode;
typedef std::shared_ptr<CRoundNode> PRoundNode;
typedef std::shared_ptr<CCeilNode> PCeilNode;
typedef std::shared_ptr<CFloorNode> PFloorNode;
typedef std::shared_ptr<CSignNode> PSignNode;
typedef std::shared_ptr<CFractNode> PFractNode;
typedef std::shared_ptr<CAbsNode> PAbsNode;
typedef std::shared_ptr<CExpNode> PExpNode;
typedef std::shared_ptr<CLogNode> PLogNode;
typedef std::shared_ptr<CLog2Node> PLog2Node;
typedef std::shared_ptr<CLog10Node> PLog10Node;
typedef std::shared_ptr<CLengthNode> PLengthNode;
typedef std::shared_ptr<CTransposeNode> PTransposeNode;
typedef std::shared_ptr<CInverseNode> PInverseNode;
typedef std::shared_ptr<CSqrtNode> PSqrtNode;
typedef std::shared_ptr<CResourceIdNode> PResourceIdNode;
typedef std::shared_ptr<CTwoInputNode> PTwoInputNode;
typedef std::shared_ptr<CAdditionNode> PAdditionNode;
typedef std::shared_ptr<CSubtractionNode> PSubtractionNode;
typedef std::shared_ptr<CMultiplicationNode> PMultiplicationNode;
typedef std::shared_ptr<CDivisionNode> PDivisionNode;
typedef std::shared_ptr<CDotNode> PDotNode;
typedef std::shared_ptr<CCrossNode> PCrossNode;
typedef std::shared_ptr<CArcTan2Node> PArcTan2Node;
typedef std::shared_ptr<CMatVecMultiplicationNode> PMatVecMultiplicationNode;
typedef std::shared_ptr<CMinNode> PMinNode;
typedef std::shared_ptr<CMaxNode> PMaxNode;
typedef std::shared_ptr<CFmodNode> PFmodNode;
typedef std::shared_ptr<CModNode> PModNode;
typedef std::shared_ptr<CPowNode> PPowNode;
typedef std::shared_ptr<CSelectNode> PSelectNode;
typedef std::shared_ptr<CClampNode> PClampNode;
typedef std::shared_ptr<CComposeVectorNode> PComposeVectorNode;
typedef std::shared_ptr<CVectorFromScalarNode> PVectorFromScalarNode;
typedef std::shared_ptr<CDecomposeVectorNode> PDecomposeVectorNode;
typedef std::shared_ptr<CComposeMatrixNode> PComposeMatrixNode;
typedef std::shared_ptr<CMatrixFromRowsNode> PMatrixFromRowsNode;
typedef std::shared_ptr<CMatrixFromColumnsNode> PMatrixFromColumnsNode;
typedef std::shared_ptr<CConstantNode> PConstantNode;
typedef std::shared_ptr<CConstVecNode> PConstVecNode;
typedef std::shared_ptr<CConstMatNode> PConstMatNode;
typedef std::shared_ptr<CMeshNode> PMeshNode;
typedef std::shared_ptr<CUnsignedMeshNode> PUnsignedMeshNode;
typedef std::shared_ptr<CBeamLatticeNode> PBeamLatticeNode;
typedef std::shared_ptr<CFunctionGradientNode> PFunctionGradientNode;
typedef std::shared_ptr<CNormalizeDistanceNode> PNormalizeDistanceNode;
typedef std::shared_ptr<CFunctionCallNode> PFunctionCallNode;
typedef std::shared_ptr<CNodeIterator> PNodeIterator;
typedef std::shared_ptr<CFunction> PFunction;
typedef std::shared_ptr<CImplicitFunction> PImplicitFunction;
typedef std::shared_ptr<CFunctionFromImage3D> PFunctionFromImage3D;
typedef std::shared_ptr<CBuildItem> PBuildItem;
typedef std::shared_ptr<CBuildItemIterator> PBuildItemIterator;
typedef std::shared_ptr<CSlice> PSlice;
typedef std::shared_ptr<CSliceStack> PSliceStack;
typedef std::shared_ptr<CConsumer> PConsumer;
typedef std::shared_ptr<CAccessRight> PAccessRight;
typedef std::shared_ptr<CContentEncryptionParams> PContentEncryptionParams;
typedef std::shared_ptr<CResourceData> PResourceData;
typedef std::shared_ptr<CResourceDataGroup> PResourceDataGroup;
typedef std::shared_ptr<CKeyStore> PKeyStore;
typedef std::shared_ptr<CModel> PModel;

/*************************************************************************************************************************
 Declaration of deprecated shared pointer types
**************************************************************************************************************************/
typedef PWrapper PLib3MFWrapper;
typedef PBase PLib3MFBase;
typedef PWriter PLib3MFWriter;
typedef PReader PLib3MFReader;
typedef PPackagePart PLib3MFPackagePart;
typedef PResource PLib3MFResource;
typedef PResourceIterator PLib3MFResourceIterator;
typedef PSliceStackIterator PLib3MFSliceStackIterator;
typedef PObjectIterator PLib3MFObjectIterator;
typedef PMeshObjectIterator PLib3MFMeshObjectIterator;
typedef PComponentsObjectIterator PLib3MFComponentsObjectIterator;
typedef PTexture2DIterator PLib3MFTexture2DIterator;
typedef PBaseMaterialGroupIterator PLib3MFBaseMaterialGroupIterator;
typedef PColorGroupIterator PLib3MFColorGroupIterator;
typedef PTexture2DGroupIterator PLib3MFTexture2DGroupIterator;
typedef PCompositeMaterialsIterator PLib3MFCompositeMaterialsIterator;
typedef PMultiPropertyGroupIterator PLib3MFMultiPropertyGroupIterator;
typedef PImage3DIterator PLib3MFImage3DIterator;
typedef PFunctionIterator PLib3MFFunctionIterator;
typedef PLevelSetIterator PLib3MFLevelSetIterator;
typedef PMetaData PLib3MFMetaData;
typedef PMetaDataGroup PLib3MFMetaDataGroup;
typedef PTriangleSet PLib3MFTriangleSet;
typedef PObject PLib3MFObject;
typedef PMeshObject PLib3MFMeshObject;
typedef PLevelSet PLib3MFLevelSet;
typedef PBeamLattice PLib3MFBeamLattice;
typedef PFunctionReference PLib3MFFunctionReference;
typedef PVolumeDataColor PLib3MFVolumeDataColor;
typedef PMaterialMapping PLib3MFMaterialMapping;
typedef PVolumeDataComposite PLib3MFVolumeDataComposite;
typedef PVolumeDataProperty PLib3MFVolumeDataProperty;
typedef PVolumeData PLib3MFVolumeData;
typedef PComponent PLib3MFComponent;
typedef PComponentsObject PLib3MFComponentsObject;
typedef PBeamSet PLib3MFBeamSet;
typedef PBaseMaterialGroup PLib3MFBaseMaterialGroup;
typedef PColorGroup PLib3MFColorGroup;
typedef PTexture2DGroup PLib3MFTexture2DGroup;
typedef PCompositeMaterials PLib3MFCompositeMaterials;
typedef PMultiPropertyGroup PLib3MFMultiPropertyGroup;
typedef PImage3D PLib3MFImage3D;
typedef PImageStack PLib3MFImageStack;
typedef PAttachment PLib3MFAttachment;
typedef PTexture2D PLib3MFTexture2D;
typedef PImplicitPort PLib3MFImplicitPort;
typedef PIterator PLib3MFIterator;
typedef PImplicitPortIterator PLib3MFImplicitPortIterator;
typedef PImplicitNode PLib3MFImplicitNode;
typedef POneInputNode PLib3MFOneInputNode;
typedef PSinNode PLib3MFSinNode;
typedef PCosNode PLib3MFCosNode;
typedef PTanNode PLib3MFTanNode;
typedef PArcSinNode PLib3MFArcSinNode;
typedef PArcCosNode PLib3MFArcCosNode;
typedef PArcTanNode PLib3MFArcTanNode;
typedef PSinhNode PLib3MFSinhNode;
typedef PCoshNode PLib3MFCoshNode;
typedef PTanhNode PLib3MFTanhNode;
typedef PRoundNode PLib3MFRoundNode;
typedef PCeilNode PLib3MFCeilNode;
typedef PFloorNode PLib3MFFloorNode;
typedef PSignNode PLib3MFSignNode;
typedef PFractNode PLib3MFFractNode;
typedef PAbsNode PLib3MFAbsNode;
typedef PExpNode PLib3MFExpNode;
typedef PLogNode PLib3MFLogNode;
typedef PLog2Node PLib3MFLog2Node;
typedef PLog10Node PLib3MFLog10Node;
typedef PLengthNode PLib3MFLengthNode;
typedef PTransposeNode PLib3MFTransposeNode;
typedef PInverseNode PLib3MFInverseNode;
typedef PSqrtNode PLib3MFSqrtNode;
typedef PResourceIdNode PLib3MFResourceIdNode;
typedef PTwoInputNode PLib3MFTwoInputNode;
typedef PAdditionNode PLib3MFAdditionNode;
typedef PSubtractionNode PLib3MFSubtractionNode;
typedef PMultiplicationNode PLib3MFMultiplicationNode;
typedef PDivisionNode PLib3MFDivisionNode;
typedef PDotNode PLib3MFDotNode;
typedef PCrossNode PLib3MFCrossNode;
typedef PArcTan2Node PLib3MFArcTan2Node;
typedef PMatVecMultiplicationNode PLib3MFMatVecMultiplicationNode;
typedef PMinNode PLib3MFMinNode;
typedef PMaxNode PLib3MFMaxNode;
typedef PFmodNode PLib3MFFmodNode;
typedef PModNode PLib3MFModNode;
typedef PPowNode PLib3MFPowNode;
typedef PSelectNode PLib3MFSelectNode;
typedef PClampNode PLib3MFClampNode;
typedef PComposeVectorNode PLib3MFComposeVectorNode;
typedef PVectorFromScalarNode PLib3MFVectorFromScalarNode;
typedef PDecomposeVectorNode PLib3MFDecomposeVectorNode;
typedef PComposeMatrixNode PLib3MFComposeMatrixNode;
typedef PMatrixFromRowsNode PLib3MFMatrixFromRowsNode;
typedef PMatrixFromColumnsNode PLib3MFMatrixFromColumnsNode;
typedef PConstantNode PLib3MFConstantNode;
typedef PConstVecNode PLib3MFConstVecNode;
typedef PConstMatNode PLib3MFConstMatNode;
typedef PMeshNode PLib3MFMeshNode;
typedef PUnsignedMeshNode PLib3MFUnsignedMeshNode;
typedef PBeamLatticeNode PLib3MFBeamLatticeNode;
typedef PFunctionGradientNode PLib3MFFunctionGradientNode;
typedef PNormalizeDistanceNode PLib3MFNormalizeDistanceNode;
typedef PFunctionCallNode PLib3MFFunctionCallNode;
typedef PNodeIterator PLib3MFNodeIterator;
typedef PFunction PLib3MFFunction;
typedef PImplicitFunction PLib3MFImplicitFunction;
typedef PFunctionFromImage3D PLib3MFFunctionFromImage3D;
typedef PBuildItem PLib3MFBuildItem;
typedef PBuildItemIterator PLib3MFBuildItemIterator;
typedef PSlice PLib3MFSlice;
typedef PSliceStack PLib3MFSliceStack;
typedef PConsumer PLib3MFConsumer;
typedef PAccessRight PLib3MFAccessRight;
typedef PContentEncryptionParams PLib3MFContentEncryptionParams;
typedef PResourceData PLib3MFResourceData;
typedef PResourceDataGroup PLib3MFResourceDataGroup;
typedef PKeyStore PLib3MFKeyStore;
typedef PModel PLib3MFModel;


/*************************************************************************************************************************
 classParam Definition
**************************************************************************************************************************/

template<class T> class classParam {
private:
	std::shared_ptr<T> m_sharedPtr;
	const T* m_ptr;

public:
	classParam(const T* ptr)
		: m_ptr(ptr)
	{
	}

	classParam(std::shared_ptr <T> sharedPtr)
		: m_sharedPtr(sharedPtr), m_ptr(sharedPtr.get())
	{
	}

	Lib3MFHandle GetHandle()
	{
		if (m_ptr != nullptr)
			return m_ptr->handle();
		return (Lib3MFHandle)nullptr;
	}
};


/*************************************************************************************************************************
 Class ELib3MFException 
**************************************************************************************************************************/
class ELib3MFException : public std::exception {
protected:
	/**
	* Error code for the Exception.
	*/
	Lib3MFResult m_errorCode;
	/**
	* Error message for the Exception.
	*/
	std::string m_errorMessage;
	std::string m_originalErrorMessage;

public:
	/**
	* Exception Constructor.
	*/
	ELib3MFException(Lib3MFResult errorCode, const std::string & sErrorMessage)
		: m_errorCode(errorCode), m_originalErrorMessage(sErrorMessage)
	{
		m_errorMessage = buildErrorMessage();
	}

	/**
	* Returns error code
	*/
	Lib3MFResult getErrorCode() const noexcept
	{
		return m_errorCode;
	}

	/**
	* Returns error message
	*/
	const char* what() const noexcept
	{
		return m_errorMessage.c_str();
	}

	const char* getErrorMessage() const noexcept
	{
		return m_originalErrorMessage.c_str();
	}

	const char* getErrorName() const noexcept
	{
		switch(getErrorCode()) {
			case LIB3MF_SUCCESS: return "SUCCESS";
			case LIB3MF_ERROR_NOTIMPLEMENTED: return "NOTIMPLEMENTED";
			case LIB3MF_ERROR_INVALIDPARAM: return "INVALIDPARAM";
			case LIB3MF_ERROR_INVALIDCAST: return "INVALIDCAST";
			case LIB3MF_ERROR_BUFFERTOOSMALL: return "BUFFERTOOSMALL";
			case LIB3MF_ERROR_GENERICEXCEPTION: return "GENERICEXCEPTION";
			case LIB3MF_ERROR_COULDNOTLOADLIBRARY: return "COULDNOTLOADLIBRARY";
			case LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT: return "COULDNOTFINDLIBRARYEXPORT";
			case LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION: return "INCOMPATIBLEBINARYVERSION";
			case LIB3MF_ERROR_CALCULATIONABORTED: return "CALCULATIONABORTED";
			case LIB3MF_ERROR_SHOULDNOTBECALLED: return "SHOULDNOTBECALLED";
			case LIB3MF_ERROR_READERCLASSUNKNOWN: return "READERCLASSUNKNOWN";
			case LIB3MF_ERROR_WRITERCLASSUNKNOWN: return "WRITERCLASSUNKNOWN";
			case LIB3MF_ERROR_ITERATORINVALIDINDEX: return "ITERATORINVALIDINDEX";
			case LIB3MF_ERROR_INVALIDMODELRESOURCE: return "INVALIDMODELRESOURCE";
			case LIB3MF_ERROR_RESOURCENOTFOUND: return "RESOURCENOTFOUND";
			case LIB3MF_ERROR_INVALIDMODEL: return "INVALIDMODEL";
			case LIB3MF_ERROR_INVALIDOBJECT: return "INVALIDOBJECT";
			case LIB3MF_ERROR_INVALIDMESHOBJECT: return "INVALIDMESHOBJECT";
			case LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT: return "INVALIDCOMPONENTSOBJECT";
			case LIB3MF_ERROR_INVALIDCOMPONENT: return "INVALIDCOMPONENT";
			case LIB3MF_ERROR_INVALIDBUILDITEM: return "INVALIDBUILDITEM";
			case LIB3MF_ERROR_INVALIDBASEMATERIALGROUP: return "INVALIDBASEMATERIALGROUP";
			case LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE: return "INVALIDSLICESTACKRESOURCE";
			case LIB3MF_ERROR_INVALIDTEXTURERESOURCE: return "INVALIDTEXTURERESOURCE";
			case LIB3MF_ERROR_INVALIDCOLORGROUP: return "INVALIDCOLORGROUP";
			case LIB3MF_ERROR_INVALIDTEXTURE2DGROUP: return "INVALIDTEXTURE2DGROUP";
			case LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS: return "INVALIDCOMPOSITEMATERIALS";
			case LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP: return "INVALIDMULTIPROPERTYGROUP";
			case LIB3MF_ERROR_INVALIDRESOURCEINDEX: return "INVALIDRESOURCEINDEX";
			case LIB3MF_ERROR_ATTACHMENTNOTFOUND: return "ATTACHMENTNOTFOUND";
			case LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE: return "FORBIDDENCYCLICREFERENCE";
			case LIB3MF_ERROR_INVALIDATTACHMENTSTREAM: return "INVALIDATTACHMENTSTREAM";
			case LIB3MF_ERROR_INVALIDPROPERTYCOUNT: return "INVALIDPROPERTYCOUNT";
			case LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER: return "UNKOWNPROGRESSIDENTIFIER";
			case LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT: return "ELEMENTCOUNTEXCEEDSLIMIT";
			case LIB3MF_ERROR_INVALIDRESOURCE: return "INVALIDRESOURCE";
			case LIB3MF_ERROR_INVALIDLEVELSET: return "INVALIDLEVELSET";
			case LIB3MF_ERROR_COULDNOTFINDTRIANGLESET: return "COULDNOTFINDTRIANGLESET";
			case LIB3MF_ERROR_INVALIDTRIANGLESETINDEX: return "INVALIDTRIANGLESETINDEX";
			case LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE: return "BEAMLATTICE_INVALID_OBJECTTYPE";
			case LIB3MF_ERROR_INVALIDKEYSTORE: return "INVALIDKEYSTORE";
			case LIB3MF_ERROR_INVALIDKEYSTORECONSUMER: return "INVALIDKEYSTORECONSUMER";
			case LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND: return "KEYSTORECONSUMERNOTFOUND";
			case LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND: return "KEYSTORERESOURCEDATANOTFOUND";
			case LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED: return "SECURECONTEXTNOTREGISTERED";
			case LIB3MF_ERROR_INVALIDKEYSIZE: return "INVALIDKEYSIZE";
			case LIB3MF_ERROR_INCOMPATIBLEPORTTYPES: return "INCOMPATIBLEPORTTYPES";
			case LIB3MF_ERROR_GRAPHISCYCLIC: return "GRAPHISCYCLIC";
			case LIB3MF_ERROR_INPUTNOTSET: return "INPUTNOTSET";
			case LIB3MF_ERROR_INVALIDNODECONFIGURATION: return "INVALIDNODECONFIGURATION";
		}
		return "UNKNOWN";
	}

	const char* getErrorDescription() const noexcept
	{
		switch(getErrorCode()) {
			case LIB3MF_SUCCESS: return "success";
			case LIB3MF_ERROR_NOTIMPLEMENTED: return "functionality not implemented";
			case LIB3MF_ERROR_INVALIDPARAM: return "an invalid parameter was passed";
			case LIB3MF_ERROR_INVALIDCAST: return "a type cast failed";
			case LIB3MF_ERROR_BUFFERTOOSMALL: return "a provided buffer is too small";
			case LIB3MF_ERROR_GENERICEXCEPTION: return "a generic exception occurred";
			case LIB3MF_ERROR_COULDNOTLOADLIBRARY: return "the library could not be loaded";
			case LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT: return "a required exported symbol could not be found in the library";
			case LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION: return "the version of the binary interface does not match the bindings interface";
			case LIB3MF_ERROR_CALCULATIONABORTED: return "a calculation has been aborted";
			case LIB3MF_ERROR_SHOULDNOTBECALLED: return "functionality should not be called";
			case LIB3MF_ERROR_READERCLASSUNKNOWN: return "the queried reader class is unknown";
			case LIB3MF_ERROR_WRITERCLASSUNKNOWN: return "the queried writer class is unknown";
			case LIB3MF_ERROR_ITERATORINVALIDINDEX: return "the current index of an iterator is invalid";
			case LIB3MF_ERROR_INVALIDMODELRESOURCE: return "no Model Resource has been given";
			case LIB3MF_ERROR_RESOURCENOTFOUND: return "Resource not found";
			case LIB3MF_ERROR_INVALIDMODEL: return "A model is invalid";
			case LIB3MF_ERROR_INVALIDOBJECT: return "An object is invalid";
			case LIB3MF_ERROR_INVALIDMESHOBJECT: return "A mesh object is invalid";
			case LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT: return "A components object is invalid";
			case LIB3MF_ERROR_INVALIDCOMPONENT: return "A component is invalid";
			case LIB3MF_ERROR_INVALIDBUILDITEM: return "A build item is invalid";
			case LIB3MF_ERROR_INVALIDBASEMATERIALGROUP: return "A basematerialgroup is invalid";
			case LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE: return "A slicestack resource is invalid";
			case LIB3MF_ERROR_INVALIDTEXTURERESOURCE: return "A texture resource is invalid";
			case LIB3MF_ERROR_INVALIDCOLORGROUP: return "A color group resource is invalid";
			case LIB3MF_ERROR_INVALIDTEXTURE2DGROUP: return "A texture2d group resource is invalid";
			case LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS: return "A composite materials resource is invalid";
			case LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP: return "A MultiPropertyGroup resource is invalid";
			case LIB3MF_ERROR_INVALIDRESOURCEINDEX: return "A resource index is invalid";
			case LIB3MF_ERROR_ATTACHMENTNOTFOUND: return "Attachment not found";
			case LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE: return "A component references one of its ancestors";
			case LIB3MF_ERROR_INVALIDATTACHMENTSTREAM: return "An attachment stream is invalid";
			case LIB3MF_ERROR_INVALIDPROPERTYCOUNT: return "Invalid property count.";
			case LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER: return "A progress identifier is unknown";
			case LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT: return "An element buffer exceeds its spec limit";
			case LIB3MF_ERROR_INVALIDRESOURCE: return "A resource is invalid";
			case LIB3MF_ERROR_INVALIDLEVELSET: return "A level set is invalid";
			case LIB3MF_ERROR_COULDNOTFINDTRIANGLESET: return "Could not find triangle set";
			case LIB3MF_ERROR_INVALIDTRIANGLESETINDEX: return "Invalid triangle set index";
			case LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE: return "This object type is not valid for beamlattices";
			case LIB3MF_ERROR_INVALIDKEYSTORE: return "The keystore object is invalid";
			case LIB3MF_ERROR_INVALIDKEYSTORECONSUMER: return "The consumer keystore object is invalid";
			case LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND: return "A consumer has not been found";
			case LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND: return "A resource data has not been found";
			case LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED: return "A Key or Conentent encryption callback has not been registered";
			case LIB3MF_ERROR_INVALIDKEYSIZE: return "The key size is invalid";
			case LIB3MF_ERROR_INCOMPATIBLEPORTTYPES: return "Link could not be added, the port types are incompatible";
			case LIB3MF_ERROR_GRAPHISCYCLIC: return "The functin graph is cyclic. Only dircected graphs are valid and can be topological sorted.";
			case LIB3MF_ERROR_INPUTNOTSET: return "The input of a node is not set.";
			case LIB3MF_ERROR_INVALIDNODECONFIGURATION: return "The selected node configuration is not supported";
		}
		return "unknown error";
	}

private:

	std::string buildErrorMessage() const noexcept
	{
		std::string msg = m_originalErrorMessage;
		if (msg.empty()) {
			msg = getErrorDescription();
		}
		return std::string("Error: ") + getErrorName() + ": " + msg;
	}
};

/*************************************************************************************************************************
 Class CInputVector
**************************************************************************************************************************/
template <typename T>
class CInputVector {
private:
	
	const T* m_data;
	size_t m_size;
	
public:
	
	CInputVector(const std::vector<T>& vec)
		: m_data( vec.data() ), m_size( vec.size() )
	{
	}
	
	CInputVector(const T* in_data, size_t in_size)
		: m_data( in_data ), m_size(in_size )
	{
	}
	
	const T* data() const
	{
		return m_data;
	}
	
	size_t size() const
	{
		return m_size;
	}
	
};

// declare deprecated class name
template<typename T>
using CLib3MFInputVector = CInputVector<T>;

/*************************************************************************************************************************
 Class CWrapper 
**************************************************************************************************************************/
class CWrapper {
public:
	
	explicit CWrapper(void* pSymbolLookupMethod)
	{
		CheckError(nullptr, initWrapperTable(&m_WrapperTable));
		CheckError(nullptr, loadWrapperTableFromSymbolLookupMethod(&m_WrapperTable, pSymbolLookupMethod));
		
		CheckError(nullptr, checkBinaryVersion());
	}
	
	explicit CWrapper(const std::string &sFileName)
	{
		CheckError(nullptr, initWrapperTable(&m_WrapperTable));
		CheckError(nullptr, loadWrapperTable(&m_WrapperTable, sFileName.c_str()));
		
		CheckError(nullptr, checkBinaryVersion());
	}
	
	static PWrapper loadLibrary(const std::string &sFileName)
	{
		return std::make_shared<CWrapper>(sFileName);
	}
	
	static PWrapper loadLibraryFromSymbolLookupMethod(void* pSymbolLookupMethod)
	{
		return std::make_shared<CWrapper>(pSymbolLookupMethod);
	}
	
	~CWrapper()
	{
		releaseWrapperTable(&m_WrapperTable);
	}
	
	inline void CheckError(CBase * pBaseClass, Lib3MFResult nResult);

	inline void GetLibraryVersion(Lib3MF_uint32 & nMajor, Lib3MF_uint32 & nMinor, Lib3MF_uint32 & nMicro);
	inline bool GetPrereleaseInformation(std::string & sPrereleaseInfo);
	inline bool GetBuildInformation(std::string & sBuildInformation);
	inline void GetSpecificationVersion(const std::string & sSpecificationURL, bool & bIsSupported, Lib3MF_uint32 & nMajor, Lib3MF_uint32 & nMinor, Lib3MF_uint32 & nMicro);
	inline PModel CreateModel();
	inline void Release(classParam<CBase> pInstance);
	inline void Acquire(classParam<CBase> pInstance);
	inline void SetJournal(const std::string & sJournalPath);
	inline bool GetLastError(classParam<CBase> pInstance, std::string & sLastErrorString);
	inline Lib3MF_pvoid GetSymbolLookupMethod();
	inline void RetrieveProgressMessage(const eProgressIdentifier eTheProgressIdentifier, std::string & sProgressMessage);
	inline sColor RGBAToColor(const Lib3MF_uint8 nRed, const Lib3MF_uint8 nGreen, const Lib3MF_uint8 nBlue, const Lib3MF_uint8 nAlpha);
	inline sColor FloatRGBAToColor(const Lib3MF_single fRed, const Lib3MF_single fGreen, const Lib3MF_single fBlue, const Lib3MF_single fAlpha);
	inline void ColorToRGBA(const sColor & TheColor, Lib3MF_uint8 & nRed, Lib3MF_uint8 & nGreen, Lib3MF_uint8 & nBlue, Lib3MF_uint8 & nAlpha);
	inline void ColorToFloatRGBA(const sColor & TheColor, Lib3MF_single & fRed, Lib3MF_single & fGreen, Lib3MF_single & fBlue, Lib3MF_single & fAlpha);
	inline sTransform GetIdentityTransform();
	inline sTransform GetUniformScaleTransform(const Lib3MF_single fFactor);
	inline sTransform GetScaleTransform(const Lib3MF_single fFactorX, const Lib3MF_single fFactorY, const Lib3MF_single fFactorZ);
	inline sTransform GetTranslationTransform(const Lib3MF_single fVectorX, const Lib3MF_single fVectorY, const Lib3MF_single fVectorZ);

	inline CBase* polymorphicFactory(Lib3MFHandle);

private:
	sLib3MFDynamicWrapperTable m_WrapperTable;
	
	Lib3MFResult checkBinaryVersion()
	{
		Lib3MF_uint32 nMajor, nMinor, nMicro;
		GetLibraryVersion(nMajor, nMinor, nMicro);
		if ( (nMajor != LIB3MF_VERSION_MAJOR) || (nMinor < LIB3MF_VERSION_MINOR) ) {
			return LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION;
		}
		return LIB3MF_SUCCESS;
	}
	Lib3MFResult initWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable);
	Lib3MFResult releaseWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable);
	Lib3MFResult loadWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable, const char * pLibraryFileName);
	Lib3MFResult loadWrapperTableFromSymbolLookupMethod(sLib3MFDynamicWrapperTable * pWrapperTable, void* pSymbolLookupMethod);

	friend class CBase;
	friend class CWriter;
	friend class CReader;
	friend class CPackagePart;
	friend class CResource;
	friend class CResourceIterator;
	friend class CSliceStackIterator;
	friend class CObjectIterator;
	friend class CMeshObjectIterator;
	friend class CComponentsObjectIterator;
	friend class CTexture2DIterator;
	friend class CBaseMaterialGroupIterator;
	friend class CColorGroupIterator;
	friend class CTexture2DGroupIterator;
	friend class CCompositeMaterialsIterator;
	friend class CMultiPropertyGroupIterator;
	friend class CImage3DIterator;
	friend class CFunctionIterator;
	friend class CLevelSetIterator;
	friend class CMetaData;
	friend class CMetaDataGroup;
	friend class CTriangleSet;
	friend class CObject;
	friend class CMeshObject;
	friend class CLevelSet;
	friend class CBeamLattice;
	friend class CFunctionReference;
	friend class CVolumeDataColor;
	friend class CMaterialMapping;
	friend class CVolumeDataComposite;
	friend class CVolumeDataProperty;
	friend class CVolumeData;
	friend class CComponent;
	friend class CComponentsObject;
	friend class CBeamSet;
	friend class CBaseMaterialGroup;
	friend class CColorGroup;
	friend class CTexture2DGroup;
	friend class CCompositeMaterials;
	friend class CMultiPropertyGroup;
	friend class CImage3D;
	friend class CImageStack;
	friend class CAttachment;
	friend class CTexture2D;
	friend class CImplicitPort;
	friend class CIterator;
	friend class CImplicitPortIterator;
	friend class CImplicitNode;
	friend class COneInputNode;
	friend class CSinNode;
	friend class CCosNode;
	friend class CTanNode;
	friend class CArcSinNode;
	friend class CArcCosNode;
	friend class CArcTanNode;
	friend class CSinhNode;
	friend class CCoshNode;
	friend class CTanhNode;
	friend class CRoundNode;
	friend class CCeilNode;
	friend class CFloorNode;
	friend class CSignNode;
	friend class CFractNode;
	friend class CAbsNode;
	friend class CExpNode;
	friend class CLogNode;
	friend class CLog2Node;
	friend class CLog10Node;
	friend class CLengthNode;
	friend class CTransposeNode;
	friend class CInverseNode;
	friend class CSqrtNode;
	friend class CResourceIdNode;
	friend class CTwoInputNode;
	friend class CAdditionNode;
	friend class CSubtractionNode;
	friend class CMultiplicationNode;
	friend class CDivisionNode;
	friend class CDotNode;
	friend class CCrossNode;
	friend class CArcTan2Node;
	friend class CMatVecMultiplicationNode;
	friend class CMinNode;
	friend class CMaxNode;
	friend class CFmodNode;
	friend class CModNode;
	friend class CPowNode;
	friend class CSelectNode;
	friend class CClampNode;
	friend class CComposeVectorNode;
	friend class CVectorFromScalarNode;
	friend class CDecomposeVectorNode;
	friend class CComposeMatrixNode;
	friend class CMatrixFromRowsNode;
	friend class CMatrixFromColumnsNode;
	friend class CConstantNode;
	friend class CConstVecNode;
	friend class CConstMatNode;
	friend class CMeshNode;
	friend class CUnsignedMeshNode;
	friend class CBeamLatticeNode;
	friend class CFunctionGradientNode;
	friend class CNormalizeDistanceNode;
	friend class CFunctionCallNode;
	friend class CNodeIterator;
	friend class CFunction;
	friend class CImplicitFunction;
	friend class CFunctionFromImage3D;
	friend class CBuildItem;
	friend class CBuildItemIterator;
	friend class CSlice;
	friend class CSliceStack;
	friend class CConsumer;
	friend class CAccessRight;
	friend class CContentEncryptionParams;
	friend class CResourceData;
	friend class CResourceDataGroup;
	friend class CKeyStore;
	friend class CModel;

};

	
/*************************************************************************************************************************
 Class CBase 
**************************************************************************************************************************/
class CBase {
public:
	
protected:
	/* Wrapper Object that created the class. */
	CWrapper * m_pWrapper;
	/* Handle to Instance in library*/
	Lib3MFHandle m_pHandle;

	/* Checks for an Error code and raises Exceptions */
	void CheckError(Lib3MFResult nResult)
	{
		if (m_pWrapper != nullptr)
			m_pWrapper->CheckError(this, nResult);
	}
public:
	/**
	* CBase::CBase - Constructor for Base class.
	*/
	CBase(CWrapper * pWrapper, Lib3MFHandle pHandle)
		: m_pWrapper(pWrapper), m_pHandle(pHandle)
	{
	}

	/**
	* CBase::~CBase - Destructor for Base class.
	*/
	virtual ~CBase()
	{
		if (m_pWrapper != nullptr)
			m_pWrapper->Release(this);
		m_pWrapper = nullptr;
	}

	/**
	* CBase::handle - Returns handle to instance.
	*/
	Lib3MFHandle handle() const
	{
		return m_pHandle;
	}

	/**
	* CBase::wrapper - Returns wrapper instance.
	*/
	CWrapper * wrapper() const
	{
		return m_pWrapper;
	}

	friend class CWrapper;
	inline Lib3MF_uint64 ClassTypeId();
	
protected:
};
	
/*************************************************************************************************************************
 Class CWriter 
**************************************************************************************************************************/
class CWriter : public CBase {
public:
	
	/**
	* CWriter::CWriter - Constructor for Writer class.
	*/
	CWriter(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline void WriteToFile(const std::string & sFilename);
	inline Lib3MF_uint64 GetStreamSize();
	inline void WriteToBuffer(std::vector<Lib3MF_uint8> & BufferBuffer);
	inline void WriteToCallback(const WriteCallback pTheWriteCallback, const SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData);
	inline void SetProgressCallback(const ProgressCallback pProgressCallback, const Lib3MF_pvoid pUserData);
	inline Lib3MF_uint32 GetDecimalPrecision();
	inline void SetDecimalPrecision(const Lib3MF_uint32 nDecimalPrecision);
	inline void SetStrictModeActive(const bool bStrictModeActive);
	inline bool GetStrictModeActive();
	inline std::string GetWarning(const Lib3MF_uint32 nIndex, Lib3MF_uint32 & nErrorCode);
	inline Lib3MF_uint32 GetWarningCount();
	inline void AddKeyWrappingCallback(const std::string & sConsumerID, const KeyWrappingCallback pTheCallback, const Lib3MF_pvoid pUserData);
	inline void SetContentEncryptionCallback(const ContentEncryptionCallback pTheCallback, const Lib3MF_pvoid pUserData);
};
	
/*************************************************************************************************************************
 Class CReader 
**************************************************************************************************************************/
class CReader : public CBase {
public:
	
	/**
	* CReader::CReader - Constructor for Reader class.
	*/
	CReader(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline void ReadFromFile(const std::string & sFilename);
	inline void ReadFromBuffer(const CInputVector<Lib3MF_uint8> & BufferBuffer);
	inline void ReadFromCallback(const ReadCallback pTheReadCallback, const Lib3MF_uint64 nStreamSize, const SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData);
	inline void SetProgressCallback(const ProgressCallback pProgressCallback, const Lib3MF_pvoid pUserData);
	inline void AddRelationToRead(const std::string & sRelationShipType);
	inline void RemoveRelationToRead(const std::string & sRelationShipType);
	inline void SetStrictModeActive(const bool bStrictModeActive);
	inline bool GetStrictModeActive();
	inline std::string GetWarning(const Lib3MF_uint32 nIndex, Lib3MF_uint32 & nErrorCode);
	inline Lib3MF_uint32 GetWarningCount();
	inline void AddKeyWrappingCallback(const std::string & sConsumerID, const KeyWrappingCallback pTheCallback, const Lib3MF_pvoid pUserData);
	inline void SetContentEncryptionCallback(const ContentEncryptionCallback pTheCallback, const Lib3MF_pvoid pUserData);
};
	
/*************************************************************************************************************************
 Class CPackagePart 
**************************************************************************************************************************/
class CPackagePart : public CBase {
public:
	
	/**
	* CPackagePart::CPackagePart - Constructor for PackagePart class.
	*/
	CPackagePart(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline std::string GetPath();
	inline void SetPath(const std::string & sPath);
};
	
/*************************************************************************************************************************
 Class CResource 
**************************************************************************************************************************/
class CResource : public CBase {
public:
	
	/**
	* CResource::CResource - Constructor for Resource class.
	*/
	CResource(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_uint32 GetResourceID();
	inline Lib3MF_uint32 GetUniqueResourceID();
	inline PPackagePart PackagePart();
	inline void SetPackagePart(classParam<CPackagePart> pPackagePart);
	inline Lib3MF_uint32 GetModelResourceID();
};
	
/*************************************************************************************************************************
 Class CResourceIterator 
**************************************************************************************************************************/
class CResourceIterator : public CBase {
public:
	
	/**
	* CResourceIterator::CResourceIterator - Constructor for ResourceIterator class.
	*/
	CResourceIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline bool MoveNext();
	inline bool MovePrevious();
	inline PResource GetCurrent();
	inline PResourceIterator Clone();
	inline Lib3MF_uint64 Count();
};
	
/*************************************************************************************************************************
 Class CSliceStackIterator 
**************************************************************************************************************************/
class CSliceStackIterator : public CResourceIterator {
public:
	
	/**
	* CSliceStackIterator::CSliceStackIterator - Constructor for SliceStackIterator class.
	*/
	CSliceStackIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PSliceStack GetCurrentSliceStack();
};
	
/*************************************************************************************************************************
 Class CObjectIterator 
**************************************************************************************************************************/
class CObjectIterator : public CResourceIterator {
public:
	
	/**
	* CObjectIterator::CObjectIterator - Constructor for ObjectIterator class.
	*/
	CObjectIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PObject GetCurrentObject();
};
	
/*************************************************************************************************************************
 Class CMeshObjectIterator 
**************************************************************************************************************************/
class CMeshObjectIterator : public CResourceIterator {
public:
	
	/**
	* CMeshObjectIterator::CMeshObjectIterator - Constructor for MeshObjectIterator class.
	*/
	CMeshObjectIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PMeshObject GetCurrentMeshObject();
};
	
/*************************************************************************************************************************
 Class CComponentsObjectIterator 
**************************************************************************************************************************/
class CComponentsObjectIterator : public CResourceIterator {
public:
	
	/**
	* CComponentsObjectIterator::CComponentsObjectIterator - Constructor for ComponentsObjectIterator class.
	*/
	CComponentsObjectIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PComponentsObject GetCurrentComponentsObject();
};
	
/*************************************************************************************************************************
 Class CTexture2DIterator 
**************************************************************************************************************************/
class CTexture2DIterator : public CResourceIterator {
public:
	
	/**
	* CTexture2DIterator::CTexture2DIterator - Constructor for Texture2DIterator class.
	*/
	CTexture2DIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PTexture2D GetCurrentTexture2D();
};
	
/*************************************************************************************************************************
 Class CBaseMaterialGroupIterator 
**************************************************************************************************************************/
class CBaseMaterialGroupIterator : public CResourceIterator {
public:
	
	/**
	* CBaseMaterialGroupIterator::CBaseMaterialGroupIterator - Constructor for BaseMaterialGroupIterator class.
	*/
	CBaseMaterialGroupIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PBaseMaterialGroup GetCurrentBaseMaterialGroup();
};
	
/*************************************************************************************************************************
 Class CColorGroupIterator 
**************************************************************************************************************************/
class CColorGroupIterator : public CResourceIterator {
public:
	
	/**
	* CColorGroupIterator::CColorGroupIterator - Constructor for ColorGroupIterator class.
	*/
	CColorGroupIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PColorGroup GetCurrentColorGroup();
};
	
/*************************************************************************************************************************
 Class CTexture2DGroupIterator 
**************************************************************************************************************************/
class CTexture2DGroupIterator : public CResourceIterator {
public:
	
	/**
	* CTexture2DGroupIterator::CTexture2DGroupIterator - Constructor for Texture2DGroupIterator class.
	*/
	CTexture2DGroupIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PTexture2DGroup GetCurrentTexture2DGroup();
};
	
/*************************************************************************************************************************
 Class CCompositeMaterialsIterator 
**************************************************************************************************************************/
class CCompositeMaterialsIterator : public CResourceIterator {
public:
	
	/**
	* CCompositeMaterialsIterator::CCompositeMaterialsIterator - Constructor for CompositeMaterialsIterator class.
	*/
	CCompositeMaterialsIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PCompositeMaterials GetCurrentCompositeMaterials();
};
	
/*************************************************************************************************************************
 Class CMultiPropertyGroupIterator 
**************************************************************************************************************************/
class CMultiPropertyGroupIterator : public CResourceIterator {
public:
	
	/**
	* CMultiPropertyGroupIterator::CMultiPropertyGroupIterator - Constructor for MultiPropertyGroupIterator class.
	*/
	CMultiPropertyGroupIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PMultiPropertyGroup GetCurrentMultiPropertyGroup();
};
	
/*************************************************************************************************************************
 Class CImage3DIterator 
**************************************************************************************************************************/
class CImage3DIterator : public CResourceIterator {
public:
	
	/**
	* CImage3DIterator::CImage3DIterator - Constructor for Image3DIterator class.
	*/
	CImage3DIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PImage3D GetCurrentImage3D();
};
	
/*************************************************************************************************************************
 Class CFunctionIterator 
**************************************************************************************************************************/
class CFunctionIterator : public CResourceIterator {
public:
	
	/**
	* CFunctionIterator::CFunctionIterator - Constructor for FunctionIterator class.
	*/
	CFunctionIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PFunction GetCurrentFunction();
};
	
/*************************************************************************************************************************
 Class CLevelSetIterator 
**************************************************************************************************************************/
class CLevelSetIterator : public CResourceIterator {
public:
	
	/**
	* CLevelSetIterator::CLevelSetIterator - Constructor for LevelSetIterator class.
	*/
	CLevelSetIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResourceIterator(pWrapper, pHandle)
	{
	}
	
	inline PLevelSet GetCurrentLevelSet();
};
	
/*************************************************************************************************************************
 Class CMetaData 
**************************************************************************************************************************/
class CMetaData : public CBase {
public:
	
	/**
	* CMetaData::CMetaData - Constructor for MetaData class.
	*/
	CMetaData(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline std::string GetNameSpace();
	inline void SetNameSpace(const std::string & sNameSpace);
	inline std::string GetName();
	inline void SetName(const std::string & sName);
	inline std::string GetKey();
	inline bool GetMustPreserve();
	inline void SetMustPreserve(const bool bMustPreserve);
	inline std::string GetType();
	inline void SetType(const std::string & sType);
	inline std::string GetValue();
	inline void SetValue(const std::string & sValue);
};
	
/*************************************************************************************************************************
 Class CMetaDataGroup 
**************************************************************************************************************************/
class CMetaDataGroup : public CBase {
public:
	
	/**
	* CMetaDataGroup::CMetaDataGroup - Constructor for MetaDataGroup class.
	*/
	CMetaDataGroup(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_uint32 GetMetaDataCount();
	inline PMetaData GetMetaData(const Lib3MF_uint32 nIndex);
	inline PMetaData GetMetaDataByKey(const std::string & sNameSpace, const std::string & sName);
	inline void RemoveMetaDataByIndex(const Lib3MF_uint32 nIndex);
	inline void RemoveMetaData(classParam<CMetaData> pTheMetaData);
	inline PMetaData AddMetaData(const std::string & sNameSpace, const std::string & sName, const std::string & sValue, const std::string & sType, const bool bMustPreserve);
};
	
/*************************************************************************************************************************
 Class CTriangleSet 
**************************************************************************************************************************/
class CTriangleSet : public CBase {
public:
	
	/**
	* CTriangleSet::CTriangleSet - Constructor for TriangleSet class.
	*/
	CTriangleSet(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline void SetName(const std::string & sName);
	inline std::string GetName();
	inline void SetIdentifier(const std::string & sIdentifier);
	inline std::string GetIdentifier();
	inline void AddTriangle(const Lib3MF_uint32 nTriangleIndex);
	inline void RemoveTriangle(const Lib3MF_uint32 nTriangleIndex);
	inline void Clear();
	inline void SetTriangleList(const CInputVector<Lib3MF_uint32> & TriangleIndicesBuffer);
	inline void GetTriangleList(std::vector<Lib3MF_uint32> & TriangleIndicesBuffer);
	inline void AddTriangleList(const CInputVector<Lib3MF_uint32> & TriangleIndicesBuffer);
	inline void Merge(classParam<CTriangleSet> pOtherTriangleSet, const bool bDeleteOther);
	inline void DeleteSet();
	inline PTriangleSet Duplicate(const std::string & sIdentifier);
};
	
/*************************************************************************************************************************
 Class CObject 
**************************************************************************************************************************/
class CObject : public CResource {
public:
	
	/**
	* CObject::CObject - Constructor for Object class.
	*/
	CObject(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResource(pWrapper, pHandle)
	{
	}
	
	inline eObjectType GetType();
	inline void SetType(const eObjectType eObjectType);
	inline std::string GetName();
	inline void SetName(const std::string & sName);
	inline std::string GetPartNumber();
	inline void SetPartNumber(const std::string & sPartNumber);
	inline bool IsMeshObject();
	inline bool IsComponentsObject();
	inline bool IsLevelSetObject();
	inline bool IsValid();
	inline void SetAttachmentAsThumbnail(classParam<CAttachment> pAttachment);
	inline PAttachment GetThumbnailAttachment();
	inline void ClearThumbnailAttachment();
	inline sBox GetOutbox();
	inline std::string GetUUID(bool & bHasUUID);
	inline void SetUUID(const std::string & sUUID);
	inline PMetaDataGroup GetMetaDataGroup();
	inline void SetSlicesMeshResolution(const eSlicesMeshResolution eMeshResolution);
	inline eSlicesMeshResolution GetSlicesMeshResolution();
	inline bool HasSlices(const bool bRecursive);
	inline void ClearSliceStack();
	inline PSliceStack GetSliceStack();
	inline void AssignSliceStack(classParam<CSliceStack> pSliceStackInstance);
};
	
/*************************************************************************************************************************
 Class CMeshObject 
**************************************************************************************************************************/
class CMeshObject : public CObject {
public:
	
	/**
	* CMeshObject::CMeshObject - Constructor for MeshObject class.
	*/
	CMeshObject(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CObject(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_uint32 GetVertexCount();
	inline Lib3MF_uint32 GetTriangleCount();
	inline sPosition GetVertex(const Lib3MF_uint32 nIndex);
	inline void SetVertex(const Lib3MF_uint32 nIndex, const sPosition & Coordinates);
	inline Lib3MF_uint32 AddVertex(const sPosition & Coordinates);
	inline void GetVertices(std::vector<sPosition> & VerticesBuffer);
	inline sTriangle GetTriangle(const Lib3MF_uint32 nIndex);
	inline void SetTriangle(const Lib3MF_uint32 nIndex, const sTriangle & Indices);
	inline Lib3MF_uint32 AddTriangle(const sTriangle & Indices);
	inline void GetTriangleIndices(std::vector<sTriangle> & IndicesBuffer);
	inline void SetObjectLevelProperty(const Lib3MF_uint32 nUniqueResourceID, const Lib3MF_uint32 nPropertyID);
	inline bool GetObjectLevelProperty(Lib3MF_uint32 & nUniqueResourceID, Lib3MF_uint32 & nPropertyID);
	inline void SetTriangleProperties(const Lib3MF_uint32 nIndex, const sTriangleProperties & Properties);
	inline void GetTriangleProperties(const Lib3MF_uint32 nIndex, sTriangleProperties & Property);
	inline void SetAllTriangleProperties(const CInputVector<sTriangleProperties> & PropertiesArrayBuffer);
	inline void GetAllTriangleProperties(std::vector<sTriangleProperties> & PropertiesArrayBuffer);
	inline void ClearAllProperties();
	inline void SetGeometry(const CInputVector<sPosition> & VerticesBuffer, const CInputVector<sTriangle> & IndicesBuffer);
	inline bool IsManifoldAndOriented();
	inline PBeamLattice BeamLattice();
	inline PVolumeData GetVolumeData();
	inline void SetVolumeData(classParam<CVolumeData> pTheVolumeData);
	inline PTriangleSet AddTriangleSet(const std::string & sIdentifier, const std::string & sName);
	inline bool HasTriangleSet(const std::string & sIdentifier);
	inline PTriangleSet FindTriangleSet(const std::string & sIdentifier);
	inline Lib3MF_uint32 GetTriangleSetCount();
	inline PTriangleSet GetTriangleSet(const Lib3MF_uint32 nIndex);
};
	
/*************************************************************************************************************************
 Class CLevelSet 
**************************************************************************************************************************/
class CLevelSet : public CObject {
public:
	
	/**
	* CLevelSet::CLevelSet - Constructor for LevelSet class.
	*/
	CLevelSet(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CObject(pWrapper, pHandle)
	{
	}
	
	inline PFunction GetFunction();
	inline void SetFunction(classParam<CFunction> pTheFunction);
	inline sTransform GetTransform();
	inline void SetTransform(const sTransform & Transform);
	inline std::string GetChannelName();
	inline void SetChannelName(const std::string & sChannelName);
	inline void SetMinFeatureSize(const Lib3MF_double dMinFeatureSize);
	inline Lib3MF_double GetMinFeatureSize();
	inline void SetFallBackValue(const Lib3MF_double dFallBackValue);
	inline Lib3MF_double GetFallBackValue();
	inline void SetMeshBBoxOnly(const bool bMeshBBoxOnly);
	inline bool GetMeshBBoxOnly();
	inline void SetMesh(classParam<CMeshObject> pTheMesh);
	inline PMeshObject GetMesh();
	inline PVolumeData GetVolumeData();
	inline void SetVolumeData(classParam<CVolumeData> pTheVolumeData);
};
	
/*************************************************************************************************************************
 Class CBeamLattice 
**************************************************************************************************************************/
class CBeamLattice : public CBase {
public:
	
	/**
	* CBeamLattice::CBeamLattice - Constructor for BeamLattice class.
	*/
	CBeamLattice(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_double GetMinLength();
	inline void SetMinLength(const Lib3MF_double dMinLength);
	inline void GetClipping(eBeamLatticeClipMode & eClipMode, Lib3MF_uint32 & nUniqueResourceID);
	inline void SetClipping(const eBeamLatticeClipMode eClipMode, const Lib3MF_uint32 nUniqueResourceID);
	inline bool GetRepresentation(Lib3MF_uint32 & nUniqueResourceID);
	inline void SetRepresentation(const Lib3MF_uint32 nUniqueResourceID);
	inline void GetBallOptions(eBeamLatticeBallMode & eBallMode, Lib3MF_double & dBallRadius);
	inline void SetBallOptions(const eBeamLatticeBallMode eBallMode, const Lib3MF_double dBallRadius);
	inline Lib3MF_uint32 GetBeamCount();
	inline sBeam GetBeam(const Lib3MF_uint32 nIndex);
	inline Lib3MF_uint32 AddBeam(const sBeam & BeamInfo);
	inline void SetBeam(const Lib3MF_uint32 nIndex, const sBeam & BeamInfo);
	inline void SetBeams(const CInputVector<sBeam> & BeamInfoBuffer);
	inline void GetBeams(std::vector<sBeam> & BeamInfoBuffer);
	inline Lib3MF_uint32 GetBallCount();
	inline sBall GetBall(const Lib3MF_uint32 nIndex);
	inline Lib3MF_uint32 AddBall(const sBall & BallInfo);
	inline void SetBall(const Lib3MF_uint32 nIndex, const sBall & BallInfo);
	inline void SetBalls(const CInputVector<sBall> & BallInfoBuffer);
	inline void GetBalls(std::vector<sBall> & BallInfoBuffer);
	inline Lib3MF_uint32 GetBeamSetCount();
	inline PBeamSet AddBeamSet();
	inline PBeamSet GetBeamSet(const Lib3MF_uint32 nIndex);
};
	
/*************************************************************************************************************************
 Class CFunctionReference 
**************************************************************************************************************************/
class CFunctionReference : public CBase {
public:
	
	/**
	* CFunctionReference::CFunctionReference - Constructor for FunctionReference class.
	*/
	CFunctionReference(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_uint32 GetFunctionResourceID();
	inline void SetFunctionResourceID(const Lib3MF_uint32 nUniqueResourceID);
	inline sTransform GetTransform();
	inline void SetTransform(const sTransform & Transform);
	inline std::string GetChannelName();
	inline void SetChannelName(const std::string & sChannelName);
	inline void SetMinFeatureSize(const Lib3MF_double dMinFeatureSize);
	inline Lib3MF_double GetMinFeatureSize();
	inline void SetFallBackValue(const Lib3MF_double dFallBackValue);
	inline Lib3MF_double GetFallBackValue();
};
	
/*************************************************************************************************************************
 Class CVolumeDataColor 
**************************************************************************************************************************/
class CVolumeDataColor : public CFunctionReference {
public:
	
	/**
	* CVolumeDataColor::CVolumeDataColor - Constructor for VolumeDataColor class.
	*/
	CVolumeDataColor(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CFunctionReference(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CMaterialMapping 
**************************************************************************************************************************/
class CMaterialMapping : public CFunctionReference {
public:
	
	/**
	* CMaterialMapping::CMaterialMapping - Constructor for MaterialMapping class.
	*/
	CMaterialMapping(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CFunctionReference(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CVolumeDataComposite 
**************************************************************************************************************************/
class CVolumeDataComposite : public CBase {
public:
	
	/**
	* CVolumeDataComposite::CVolumeDataComposite - Constructor for VolumeDataComposite class.
	*/
	CVolumeDataComposite(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline PBaseMaterialGroup GetBaseMaterialGroup();
	inline void SetBaseMaterialGroup(classParam<CBaseMaterialGroup> pBaseMaterialGroupInstance);
	inline Lib3MF_uint32 GetMaterialMappingCount();
	inline PMaterialMapping GetMaterialMapping(const Lib3MF_uint32 nIndex);
	inline PMaterialMapping AddMaterialMapping(const sTransform & Transform);
	inline void RemoveMaterialMapping(const Lib3MF_uint32 nIndex);
};
	
/*************************************************************************************************************************
 Class CVolumeDataProperty 
**************************************************************************************************************************/
class CVolumeDataProperty : public CFunctionReference {
public:
	
	/**
	* CVolumeDataProperty::CVolumeDataProperty - Constructor for VolumeDataProperty class.
	*/
	CVolumeDataProperty(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CFunctionReference(pWrapper, pHandle)
	{
	}
	
	inline std::string GetName();
	inline void SetIsRequired(const bool bIsRequired);
	inline bool IsRequired();
};
	
/*************************************************************************************************************************
 Class CVolumeData 
**************************************************************************************************************************/
class CVolumeData : public CResource {
public:
	
	/**
	* CVolumeData::CVolumeData - Constructor for VolumeData class.
	*/
	CVolumeData(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResource(pWrapper, pHandle)
	{
	}
	
	inline PVolumeDataComposite GetComposite();
	inline PVolumeDataComposite CreateNewComposite();
	inline void RemoveComposite();
	inline PVolumeDataColor GetColor();
	inline PVolumeDataColor CreateNewColor(classParam<CFunction> pTheFunction);
	inline void RemoveColor();
	inline Lib3MF_uint32 GetPropertyCount();
	inline PVolumeDataProperty GetProperty(const Lib3MF_uint32 nIndex);
	inline PVolumeDataProperty AddPropertyFromFunction(const std::string & sName, classParam<CFunction> pTheFunction);
	inline void RemoveProperty(const Lib3MF_uint32 nIndex);
};
	
/*************************************************************************************************************************
 Class CComponent 
**************************************************************************************************************************/
class CComponent : public CBase {
public:
	
	/**
	* CComponent::CComponent - Constructor for Component class.
	*/
	CComponent(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline PObject GetObjectResource();
	inline Lib3MF_uint32 GetObjectResourceID();
	inline std::string GetUUID(bool & bHasUUID);
	inline void SetUUID(const std::string & sUUID);
	inline bool HasTransform();
	inline sTransform GetTransform();
	inline void SetTransform(const sTransform & Transform);
};
	
/*************************************************************************************************************************
 Class CComponentsObject 
**************************************************************************************************************************/
class CComponentsObject : public CObject {
public:
	
	/**
	* CComponentsObject::CComponentsObject - Constructor for ComponentsObject class.
	*/
	CComponentsObject(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CObject(pWrapper, pHandle)
	{
	}
	
	inline PComponent AddComponent(classParam<CObject> pObjectResource, const sTransform & Transform);
	inline PComponent GetComponent(const Lib3MF_uint32 nIndex);
	inline Lib3MF_uint32 GetComponentCount();
};
	
/*************************************************************************************************************************
 Class CBeamSet 
**************************************************************************************************************************/
class CBeamSet : public CBase {
public:
	
	/**
	* CBeamSet::CBeamSet - Constructor for BeamSet class.
	*/
	CBeamSet(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline void SetName(const std::string & sName);
	inline std::string GetName();
	inline void SetIdentifier(const std::string & sIdentifier);
	inline std::string GetIdentifier();
	inline Lib3MF_uint32 GetReferenceCount();
	inline void SetReferences(const CInputVector<Lib3MF_uint32> & ReferencesBuffer);
	inline void GetReferences(std::vector<Lib3MF_uint32> & ReferencesBuffer);
	inline Lib3MF_uint32 GetBallReferenceCount();
	inline void SetBallReferences(const CInputVector<Lib3MF_uint32> & BallReferencesBuffer);
	inline void GetBallReferences(std::vector<Lib3MF_uint32> & BallReferencesBuffer);
};
	
/*************************************************************************************************************************
 Class CBaseMaterialGroup 
**************************************************************************************************************************/
class CBaseMaterialGroup : public CResource {
public:
	
	/**
	* CBaseMaterialGroup::CBaseMaterialGroup - Constructor for BaseMaterialGroup class.
	*/
	CBaseMaterialGroup(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResource(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_uint32 GetCount();
	inline void GetAllPropertyIDs(std::vector<Lib3MF_uint32> & PropertyIDsBuffer);
	inline Lib3MF_uint32 AddMaterial(const std::string & sName, const sColor & DisplayColor);
	inline void RemoveMaterial(const Lib3MF_uint32 nPropertyID);
	inline std::string GetName(const Lib3MF_uint32 nPropertyID);
	inline void SetName(const Lib3MF_uint32 nPropertyID, const std::string & sName);
	inline void SetDisplayColor(const Lib3MF_uint32 nPropertyID, const sColor & TheColor);
	inline sColor GetDisplayColor(const Lib3MF_uint32 nPropertyID);
};
	
/*************************************************************************************************************************
 Class CColorGroup 
**************************************************************************************************************************/
class CColorGroup : public CResource {
public:
	
	/**
	* CColorGroup::CColorGroup - Constructor for ColorGroup class.
	*/
	CColorGroup(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResource(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_uint32 GetCount();
	inline void GetAllPropertyIDs(std::vector<Lib3MF_uint32> & PropertyIDsBuffer);
	inline Lib3MF_uint32 AddColor(const sColor & TheColor);
	inline void RemoveColor(const Lib3MF_uint32 nPropertyID);
	inline void SetColor(const Lib3MF_uint32 nPropertyID, const sColor & TheColor);
	inline sColor GetColor(const Lib3MF_uint32 nPropertyID);
};
	
/*************************************************************************************************************************
 Class CTexture2DGroup 
**************************************************************************************************************************/
class CTexture2DGroup : public CResource {
public:
	
	/**
	* CTexture2DGroup::CTexture2DGroup - Constructor for Texture2DGroup class.
	*/
	CTexture2DGroup(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResource(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_uint32 GetCount();
	inline void GetAllPropertyIDs(std::vector<Lib3MF_uint32> & PropertyIDsBuffer);
	inline Lib3MF_uint32 AddTex2Coord(const sTex2Coord & UVCoordinate);
	inline sTex2Coord GetTex2Coord(const Lib3MF_uint32 nPropertyID);
	inline void RemoveTex2Coord(const Lib3MF_uint32 nPropertyID);
	inline PTexture2D GetTexture2D();
};
	
/*************************************************************************************************************************
 Class CCompositeMaterials 
**************************************************************************************************************************/
class CCompositeMaterials : public CResource {
public:
	
	/**
	* CCompositeMaterials::CCompositeMaterials - Constructor for CompositeMaterials class.
	*/
	CCompositeMaterials(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResource(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_uint32 GetCount();
	inline void GetAllPropertyIDs(std::vector<Lib3MF_uint32> & PropertyIDsBuffer);
	inline PBaseMaterialGroup GetBaseMaterialGroup();
	inline Lib3MF_uint32 AddComposite(const CInputVector<sCompositeConstituent> & CompositeBuffer);
	inline void RemoveComposite(const Lib3MF_uint32 nPropertyID);
	inline void GetComposite(const Lib3MF_uint32 nPropertyID, std::vector<sCompositeConstituent> & CompositeBuffer);
};
	
/*************************************************************************************************************************
 Class CMultiPropertyGroup 
**************************************************************************************************************************/
class CMultiPropertyGroup : public CResource {
public:
	
	/**
	* CMultiPropertyGroup::CMultiPropertyGroup - Constructor for MultiPropertyGroup class.
	*/
	CMultiPropertyGroup(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResource(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_uint32 GetCount();
	inline void GetAllPropertyIDs(std::vector<Lib3MF_uint32> & PropertyIDsBuffer);
	inline Lib3MF_uint32 AddMultiProperty(const CInputVector<Lib3MF_uint32> & PropertyIDsBuffer);
	inline void SetMultiProperty(const Lib3MF_uint32 nPropertyID, const CInputVector<Lib3MF_uint32> & PropertyIDsBuffer);
	inline void GetMultiProperty(const Lib3MF_uint32 nPropertyID, std::vector<Lib3MF_uint32> & PropertyIDsBuffer);
	inline void RemoveMultiProperty(const Lib3MF_uint32 nPropertyID);
	inline Lib3MF_uint32 GetLayerCount();
	inline Lib3MF_uint32 AddLayer(const sMultiPropertyLayer & TheLayer);
	inline sMultiPropertyLayer GetLayer(const Lib3MF_uint32 nLayerIndex);
	inline void RemoveLayer(const Lib3MF_uint32 nLayerIndex);
};
	
/*************************************************************************************************************************
 Class CImage3D 
**************************************************************************************************************************/
class CImage3D : public CResource {
public:
	
	/**
	* CImage3D::CImage3D - Constructor for Image3D class.
	*/
	CImage3D(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResource(pWrapper, pHandle)
	{
	}
	
	inline std::string GetName();
	inline void SetName(const std::string & sName);
	inline bool IsImageStack();
};
	
/*************************************************************************************************************************
 Class CImageStack 
**************************************************************************************************************************/
class CImageStack : public CImage3D {
public:
	
	/**
	* CImageStack::CImageStack - Constructor for ImageStack class.
	*/
	CImageStack(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImage3D(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_uint32 GetRowCount();
	inline void SetRowCount(const Lib3MF_uint32 nRowCount);
	inline Lib3MF_uint32 GetColumnCount();
	inline void SetColumnCount(const Lib3MF_uint32 nColumnCount);
	inline Lib3MF_uint32 GetSheetCount();
	inline PAttachment GetSheet(const Lib3MF_uint32 nIndex);
	inline void SetSheet(const Lib3MF_uint32 nIndex, classParam<CAttachment> pSheet);
	inline PAttachment CreateEmptySheet(const Lib3MF_uint32 nIndex, const std::string & sPath);
	inline PAttachment CreateSheetFromBuffer(const Lib3MF_uint32 nIndex, const std::string & sPath, const CInputVector<Lib3MF_uint8> & DataBuffer);
	inline PAttachment CreateSheetFromFile(const Lib3MF_uint32 nIndex, const std::string & sPath, const std::string & sFileName);
};
	
/*************************************************************************************************************************
 Class CAttachment 
**************************************************************************************************************************/
class CAttachment : public CBase {
public:
	
	/**
	* CAttachment::CAttachment - Constructor for Attachment class.
	*/
	CAttachment(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline std::string GetPath();
	inline void SetPath(const std::string & sPath);
	inline PPackagePart PackagePart();
	inline std::string GetRelationShipType();
	inline void SetRelationShipType(const std::string & sPath);
	inline void WriteToFile(const std::string & sFileName);
	inline void ReadFromFile(const std::string & sFileName);
	inline void ReadFromCallback(const ReadCallback pTheReadCallback, const Lib3MF_uint64 nStreamSize, const SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData);
	inline Lib3MF_uint64 GetStreamSize();
	inline void WriteToBuffer(std::vector<Lib3MF_uint8> & BufferBuffer);
	inline void ReadFromBuffer(const CInputVector<Lib3MF_uint8> & BufferBuffer);
};
	
/*************************************************************************************************************************
 Class CTexture2D 
**************************************************************************************************************************/
class CTexture2D : public CResource {
public:
	
	/**
	* CTexture2D::CTexture2D - Constructor for Texture2D class.
	*/
	CTexture2D(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResource(pWrapper, pHandle)
	{
	}
	
	inline PAttachment GetAttachment();
	inline void SetAttachment(classParam<CAttachment> pAttachment);
	inline eTextureType GetContentType();
	inline void SetContentType(const eTextureType eContentType);
	inline void GetTileStyleUV(eTextureTileStyle & eTileStyleU, eTextureTileStyle & eTileStyleV);
	inline void SetTileStyleUV(const eTextureTileStyle eTileStyleU, const eTextureTileStyle eTileStyleV);
	inline eTextureFilter GetFilter();
	inline void SetFilter(const eTextureFilter eFilter);
};
	
/*************************************************************************************************************************
 Class CImplicitPort 
**************************************************************************************************************************/
class CImplicitPort : public CBase {
public:
	
	/**
	* CImplicitPort::CImplicitPort - Constructor for ImplicitPort class.
	*/
	CImplicitPort(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline std::string GetIdentifier();
	inline void SetIdentifier(const std::string & sIdentifier);
	inline std::string GetDisplayName();
	inline void SetDisplayName(const std::string & sDisplayName);
	inline void SetType(const eImplicitPortType eImplicitPortType);
	inline eImplicitPortType GetType();
	inline std::string GetReference();
	inline void SetReference(const std::string & sReference);
};
	
/*************************************************************************************************************************
 Class CIterator 
**************************************************************************************************************************/
class CIterator : public CBase {
public:
	
	/**
	* CIterator::CIterator - Constructor for Iterator class.
	*/
	CIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline bool MoveNext();
	inline bool MovePrevious();
	inline Lib3MF_uint64 Count();
};
	
/*************************************************************************************************************************
 Class CImplicitPortIterator 
**************************************************************************************************************************/
class CImplicitPortIterator : public CIterator {
public:
	
	/**
	* CImplicitPortIterator::CImplicitPortIterator - Constructor for ImplicitPortIterator class.
	*/
	CImplicitPortIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CIterator(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetCurrent();
};
	
/*************************************************************************************************************************
 Class CImplicitNode 
**************************************************************************************************************************/
class CImplicitNode : public CBase {
public:
	
	/**
	* CImplicitNode::CImplicitNode - Constructor for ImplicitNode class.
	*/
	CImplicitNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline std::string GetIdentifier();
	inline void SetIdentifier(const std::string & sIdentifier);
	inline std::string GetDisplayName();
	inline void SetDisplayName(const std::string & sDisplayName);
	inline std::string GetTag();
	inline void SetTag(const std::string & sTag);
	inline eImplicitNodeType GetNodeType();
	inline PImplicitPort AddInput(const std::string & sIdentifier, const std::string & sDisplayName);
	inline PImplicitPortIterator GetInputs();
	inline PImplicitPort AddOutput(const std::string & sIdentifier, const std::string & sDisplayName);
	inline PImplicitPortIterator GetOutputs();
	inline PImplicitPort FindInput(const std::string & sIdentifier);
	inline PImplicitPort FindOutput(const std::string & sIdentifier);
	inline bool AreTypesValid();
};
	
/*************************************************************************************************************************
 Class COneInputNode 
**************************************************************************************************************************/
class COneInputNode : public CImplicitNode {
public:
	
	/**
	* COneInputNode::COneInputNode - Constructor for OneInputNode class.
	*/
	COneInputNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputA();
	inline PImplicitPort GetOutputResult();
};
	
/*************************************************************************************************************************
 Class CSinNode 
**************************************************************************************************************************/
class CSinNode : public COneInputNode {
public:
	
	/**
	* CSinNode::CSinNode - Constructor for SinNode class.
	*/
	CSinNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CCosNode 
**************************************************************************************************************************/
class CCosNode : public COneInputNode {
public:
	
	/**
	* CCosNode::CCosNode - Constructor for CosNode class.
	*/
	CCosNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CTanNode 
**************************************************************************************************************************/
class CTanNode : public COneInputNode {
public:
	
	/**
	* CTanNode::CTanNode - Constructor for TanNode class.
	*/
	CTanNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CArcSinNode 
**************************************************************************************************************************/
class CArcSinNode : public COneInputNode {
public:
	
	/**
	* CArcSinNode::CArcSinNode - Constructor for ArcSinNode class.
	*/
	CArcSinNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CArcCosNode 
**************************************************************************************************************************/
class CArcCosNode : public COneInputNode {
public:
	
	/**
	* CArcCosNode::CArcCosNode - Constructor for ArcCosNode class.
	*/
	CArcCosNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CArcTanNode 
**************************************************************************************************************************/
class CArcTanNode : public COneInputNode {
public:
	
	/**
	* CArcTanNode::CArcTanNode - Constructor for ArcTanNode class.
	*/
	CArcTanNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CSinhNode 
**************************************************************************************************************************/
class CSinhNode : public COneInputNode {
public:
	
	/**
	* CSinhNode::CSinhNode - Constructor for SinhNode class.
	*/
	CSinhNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CCoshNode 
**************************************************************************************************************************/
class CCoshNode : public COneInputNode {
public:
	
	/**
	* CCoshNode::CCoshNode - Constructor for CoshNode class.
	*/
	CCoshNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CTanhNode 
**************************************************************************************************************************/
class CTanhNode : public COneInputNode {
public:
	
	/**
	* CTanhNode::CTanhNode - Constructor for TanhNode class.
	*/
	CTanhNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CRoundNode 
**************************************************************************************************************************/
class CRoundNode : public COneInputNode {
public:
	
	/**
	* CRoundNode::CRoundNode - Constructor for RoundNode class.
	*/
	CRoundNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CCeilNode 
**************************************************************************************************************************/
class CCeilNode : public COneInputNode {
public:
	
	/**
	* CCeilNode::CCeilNode - Constructor for CeilNode class.
	*/
	CCeilNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CFloorNode 
**************************************************************************************************************************/
class CFloorNode : public COneInputNode {
public:
	
	/**
	* CFloorNode::CFloorNode - Constructor for FloorNode class.
	*/
	CFloorNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CSignNode 
**************************************************************************************************************************/
class CSignNode : public COneInputNode {
public:
	
	/**
	* CSignNode::CSignNode - Constructor for SignNode class.
	*/
	CSignNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CFractNode 
**************************************************************************************************************************/
class CFractNode : public COneInputNode {
public:
	
	/**
	* CFractNode::CFractNode - Constructor for FractNode class.
	*/
	CFractNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CAbsNode 
**************************************************************************************************************************/
class CAbsNode : public COneInputNode {
public:
	
	/**
	* CAbsNode::CAbsNode - Constructor for AbsNode class.
	*/
	CAbsNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CExpNode 
**************************************************************************************************************************/
class CExpNode : public COneInputNode {
public:
	
	/**
	* CExpNode::CExpNode - Constructor for ExpNode class.
	*/
	CExpNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CLogNode 
**************************************************************************************************************************/
class CLogNode : public COneInputNode {
public:
	
	/**
	* CLogNode::CLogNode - Constructor for LogNode class.
	*/
	CLogNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CLog2Node 
**************************************************************************************************************************/
class CLog2Node : public COneInputNode {
public:
	
	/**
	* CLog2Node::CLog2Node - Constructor for Log2Node class.
	*/
	CLog2Node(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CLog10Node 
**************************************************************************************************************************/
class CLog10Node : public COneInputNode {
public:
	
	/**
	* CLog10Node::CLog10Node - Constructor for Log10Node class.
	*/
	CLog10Node(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CLengthNode 
**************************************************************************************************************************/
class CLengthNode : public COneInputNode {
public:
	
	/**
	* CLengthNode::CLengthNode - Constructor for LengthNode class.
	*/
	CLengthNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CTransposeNode 
**************************************************************************************************************************/
class CTransposeNode : public COneInputNode {
public:
	
	/**
	* CTransposeNode::CTransposeNode - Constructor for TransposeNode class.
	*/
	CTransposeNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CInverseNode 
**************************************************************************************************************************/
class CInverseNode : public COneInputNode {
public:
	
	/**
	* CInverseNode::CInverseNode - Constructor for InverseNode class.
	*/
	CInverseNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CSqrtNode 
**************************************************************************************************************************/
class CSqrtNode : public COneInputNode {
public:
	
	/**
	* CSqrtNode::CSqrtNode - Constructor for SqrtNode class.
	*/
	CSqrtNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CResourceIdNode 
**************************************************************************************************************************/
class CResourceIdNode : public CImplicitNode {
public:
	
	/**
	* CResourceIdNode::CResourceIdNode - Constructor for ResourceIdNode class.
	*/
	CResourceIdNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline void SetResource(classParam<CResource> pResource);
	inline PResource GetResource();
	inline PImplicitPort GetOutputValue();
};
	
/*************************************************************************************************************************
 Class CTwoInputNode 
**************************************************************************************************************************/
class CTwoInputNode : public COneInputNode {
public:
	
	/**
	* CTwoInputNode::CTwoInputNode - Constructor for TwoInputNode class.
	*/
	CTwoInputNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputB();
};
	
/*************************************************************************************************************************
 Class CAdditionNode 
**************************************************************************************************************************/
class CAdditionNode : public CTwoInputNode {
public:
	
	/**
	* CAdditionNode::CAdditionNode - Constructor for AdditionNode class.
	*/
	CAdditionNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CSubtractionNode 
**************************************************************************************************************************/
class CSubtractionNode : public CTwoInputNode {
public:
	
	/**
	* CSubtractionNode::CSubtractionNode - Constructor for SubtractionNode class.
	*/
	CSubtractionNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CMultiplicationNode 
**************************************************************************************************************************/
class CMultiplicationNode : public CTwoInputNode {
public:
	
	/**
	* CMultiplicationNode::CMultiplicationNode - Constructor for MultiplicationNode class.
	*/
	CMultiplicationNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CDivisionNode 
**************************************************************************************************************************/
class CDivisionNode : public CTwoInputNode {
public:
	
	/**
	* CDivisionNode::CDivisionNode - Constructor for DivisionNode class.
	*/
	CDivisionNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CDotNode 
**************************************************************************************************************************/
class CDotNode : public CTwoInputNode {
public:
	
	/**
	* CDotNode::CDotNode - Constructor for DotNode class.
	*/
	CDotNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CCrossNode 
**************************************************************************************************************************/
class CCrossNode : public CTwoInputNode {
public:
	
	/**
	* CCrossNode::CCrossNode - Constructor for CrossNode class.
	*/
	CCrossNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CArcTan2Node 
**************************************************************************************************************************/
class CArcTan2Node : public CTwoInputNode {
public:
	
	/**
	* CArcTan2Node::CArcTan2Node - Constructor for ArcTan2Node class.
	*/
	CArcTan2Node(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CMatVecMultiplicationNode 
**************************************************************************************************************************/
class CMatVecMultiplicationNode : public CTwoInputNode {
public:
	
	/**
	* CMatVecMultiplicationNode::CMatVecMultiplicationNode - Constructor for MatVecMultiplicationNode class.
	*/
	CMatVecMultiplicationNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CMinNode 
**************************************************************************************************************************/
class CMinNode : public CTwoInputNode {
public:
	
	/**
	* CMinNode::CMinNode - Constructor for MinNode class.
	*/
	CMinNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CMaxNode 
**************************************************************************************************************************/
class CMaxNode : public CTwoInputNode {
public:
	
	/**
	* CMaxNode::CMaxNode - Constructor for MaxNode class.
	*/
	CMaxNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CFmodNode 
**************************************************************************************************************************/
class CFmodNode : public CTwoInputNode {
public:
	
	/**
	* CFmodNode::CFmodNode - Constructor for FmodNode class.
	*/
	CFmodNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CModNode 
**************************************************************************************************************************/
class CModNode : public CTwoInputNode {
public:
	
	/**
	* CModNode::CModNode - Constructor for ModNode class.
	*/
	CModNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CPowNode 
**************************************************************************************************************************/
class CPowNode : public CTwoInputNode {
public:
	
	/**
	* CPowNode::CPowNode - Constructor for PowNode class.
	*/
	CPowNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CTwoInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CSelectNode 
**************************************************************************************************************************/
class CSelectNode : public COneInputNode {
public:
	
	/**
	* CSelectNode::CSelectNode - Constructor for SelectNode class.
	*/
	CSelectNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputB();
	inline PImplicitPort GetInputC();
	inline PImplicitPort GetInputD();
};
	
/*************************************************************************************************************************
 Class CClampNode 
**************************************************************************************************************************/
class CClampNode : public COneInputNode {
public:
	
	/**
	* CClampNode::CClampNode - Constructor for ClampNode class.
	*/
	CClampNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputMin();
	inline PImplicitPort GetInputMax();
};
	
/*************************************************************************************************************************
 Class CComposeVectorNode 
**************************************************************************************************************************/
class CComposeVectorNode : public CImplicitNode {
public:
	
	/**
	* CComposeVectorNode::CComposeVectorNode - Constructor for ComposeVectorNode class.
	*/
	CComposeVectorNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputX();
	inline PImplicitPort GetInputY();
	inline PImplicitPort GetInputZ();
	inline PImplicitPort GetOutputResult();
};
	
/*************************************************************************************************************************
 Class CVectorFromScalarNode 
**************************************************************************************************************************/
class CVectorFromScalarNode : public COneInputNode {
public:
	
	/**
	* CVectorFromScalarNode::CVectorFromScalarNode - Constructor for VectorFromScalarNode class.
	*/
	CVectorFromScalarNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: COneInputNode(pWrapper, pHandle)
	{
	}
	
};
	
/*************************************************************************************************************************
 Class CDecomposeVectorNode 
**************************************************************************************************************************/
class CDecomposeVectorNode : public CImplicitNode {
public:
	
	/**
	* CDecomposeVectorNode::CDecomposeVectorNode - Constructor for DecomposeVectorNode class.
	*/
	CDecomposeVectorNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputA();
	inline PImplicitPort GetOutputX();
	inline PImplicitPort GetOutputY();
	inline PImplicitPort GetOutputZ();
};
	
/*************************************************************************************************************************
 Class CComposeMatrixNode 
**************************************************************************************************************************/
class CComposeMatrixNode : public CImplicitNode {
public:
	
	/**
	* CComposeMatrixNode::CComposeMatrixNode - Constructor for ComposeMatrixNode class.
	*/
	CComposeMatrixNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputM00();
	inline PImplicitPort GetInputM01();
	inline PImplicitPort GetInputM02();
	inline PImplicitPort GetInputM03();
	inline PImplicitPort GetInputM10();
	inline PImplicitPort GetInputM11();
	inline PImplicitPort GetInputM12();
	inline PImplicitPort GetInputM13();
	inline PImplicitPort GetInputM20();
	inline PImplicitPort GetInputM21();
	inline PImplicitPort GetInputM22();
	inline PImplicitPort GetInputM23();
	inline PImplicitPort GetInputM30();
	inline PImplicitPort GetInputM31();
	inline PImplicitPort GetInputM32();
	inline PImplicitPort GetInputM33();
	inline PImplicitPort GetOutputResult();
};
	
/*************************************************************************************************************************
 Class CMatrixFromRowsNode 
**************************************************************************************************************************/
class CMatrixFromRowsNode : public CImplicitNode {
public:
	
	/**
	* CMatrixFromRowsNode::CMatrixFromRowsNode - Constructor for MatrixFromRowsNode class.
	*/
	CMatrixFromRowsNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputA();
	inline PImplicitPort GetInputB();
	inline PImplicitPort GetInputC();
	inline PImplicitPort GetInputD();
	inline PImplicitPort GetOutputResult();
};
	
/*************************************************************************************************************************
 Class CMatrixFromColumnsNode 
**************************************************************************************************************************/
class CMatrixFromColumnsNode : public CImplicitNode {
public:
	
	/**
	* CMatrixFromColumnsNode::CMatrixFromColumnsNode - Constructor for MatrixFromColumnsNode class.
	*/
	CMatrixFromColumnsNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputA();
	inline PImplicitPort GetInputB();
	inline PImplicitPort GetInputC();
	inline PImplicitPort GetInputD();
	inline PImplicitPort GetOutputResult();
};
	
/*************************************************************************************************************************
 Class CConstantNode 
**************************************************************************************************************************/
class CConstantNode : public CImplicitNode {
public:
	
	/**
	* CConstantNode::CConstantNode - Constructor for ConstantNode class.
	*/
	CConstantNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline void SetConstant(const Lib3MF_double dValue);
	inline Lib3MF_double GetConstant();
	inline PImplicitPort GetOutputValue();
};
	
/*************************************************************************************************************************
 Class CConstVecNode 
**************************************************************************************************************************/
class CConstVecNode : public CImplicitNode {
public:
	
	/**
	* CConstVecNode::CConstVecNode - Constructor for ConstVecNode class.
	*/
	CConstVecNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline void SetVector(const sVector & Value);
	inline sVector GetVector();
	inline PImplicitPort GetOutputVector();
};
	
/*************************************************************************************************************************
 Class CConstMatNode 
**************************************************************************************************************************/
class CConstMatNode : public CImplicitNode {
public:
	
	/**
	* CConstMatNode::CConstMatNode - Constructor for ConstMatNode class.
	*/
	CConstMatNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline void SetMatrix(const sMatrix4x4 & Value);
	inline sMatrix4x4 GetMatrix();
	inline PImplicitPort GetOutputMatrix();
};
	
/*************************************************************************************************************************
 Class CMeshNode 
**************************************************************************************************************************/
class CMeshNode : public CImplicitNode {
public:
	
	/**
	* CMeshNode::CMeshNode - Constructor for MeshNode class.
	*/
	CMeshNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputMesh();
	inline PImplicitPort GetInputPos();
	inline PImplicitPort GetOutputDistance();
};
	
/*************************************************************************************************************************
 Class CUnsignedMeshNode 
**************************************************************************************************************************/
class CUnsignedMeshNode : public CImplicitNode {
public:
	
	/**
	* CUnsignedMeshNode::CUnsignedMeshNode - Constructor for UnsignedMeshNode class.
	*/
	CUnsignedMeshNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputMesh();
	inline PImplicitPort GetInputPos();
	inline PImplicitPort GetOutputDistance();
};
	
/*************************************************************************************************************************
 Class CBeamLatticeNode 
**************************************************************************************************************************/
class CBeamLatticeNode : public CImplicitNode {
public:
	
	/**
	* CBeamLatticeNode::CBeamLatticeNode - Constructor for BeamLatticeNode class.
	*/
	CBeamLatticeNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputBeamLattice();
	inline PImplicitPort GetInputPos();
	inline PImplicitPort GetOutputDistance();
	inline void SetAccurateRange(const Lib3MF_double dAccurateRange);
	inline Lib3MF_double GetAccurateRange();
};
	
/*************************************************************************************************************************
 Class CFunctionGradientNode 
**************************************************************************************************************************/
class CFunctionGradientNode : public CImplicitNode {
public:
	
	/**
	* CFunctionGradientNode::CFunctionGradientNode - Constructor for FunctionGradientNode class.
	*/
	CFunctionGradientNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputFunctionID();
	inline PImplicitPort GetInputPos();
	inline PImplicitPort GetInputStep();
	inline void SetScalarOutputName(const std::string & sScalarOutputName);
	inline std::string GetScalarOutputName();
	inline void SetVectorInputName(const std::string & sVectorInputName);
	inline std::string GetVectorInputName();
	inline PImplicitPort GetOutputNormalizedGradient();
	inline PImplicitPort GetOutputGradient();
	inline PImplicitPort GetOutputMagnitude();
};
	
/*************************************************************************************************************************
 Class CNormalizeDistanceNode 
**************************************************************************************************************************/
class CNormalizeDistanceNode : public CImplicitNode {
public:
	
	/**
	* CNormalizeDistanceNode::CNormalizeDistanceNode - Constructor for NormalizeDistanceNode class.
	*/
	CNormalizeDistanceNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputFunctionID();
	inline PImplicitPort GetInputPos();
	inline PImplicitPort GetInputStep();
	inline void SetScalarOutputName(const std::string & sScalarOutputName);
	inline std::string GetScalarOutputName();
	inline void SetVectorInputName(const std::string & sVectorInputName);
	inline std::string GetVectorInputName();
	inline PImplicitPort GetOutputResult();
};
	
/*************************************************************************************************************************
 Class CFunctionCallNode 
**************************************************************************************************************************/
class CFunctionCallNode : public CImplicitNode {
public:
	
	/**
	* CFunctionCallNode::CFunctionCallNode - Constructor for FunctionCallNode class.
	*/
	CFunctionCallNode(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CImplicitNode(pWrapper, pHandle)
	{
	}
	
	inline PImplicitPort GetInputFunctionID();
};
	
/*************************************************************************************************************************
 Class CNodeIterator 
**************************************************************************************************************************/
class CNodeIterator : public CIterator {
public:
	
	/**
	* CNodeIterator::CNodeIterator - Constructor for NodeIterator class.
	*/
	CNodeIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CIterator(pWrapper, pHandle)
	{
	}
	
	inline PImplicitNode GetCurrent();
};
	
/*************************************************************************************************************************
 Class CFunction 
**************************************************************************************************************************/
class CFunction : public CResource {
public:
	
	/**
	* CFunction::CFunction - Constructor for Function class.
	*/
	CFunction(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResource(pWrapper, pHandle)
	{
	}
	
	inline std::string GetDisplayName();
	inline void SetDisplayName(const std::string & sDisplayName);
	inline PImplicitPort AddInput(const std::string & sIdentifier, const std::string & sDisplayName, const eImplicitPortType eType);
	inline PImplicitPortIterator GetInputs();
	inline void RemoveInput(classParam<CImplicitPort> pInput);
	inline PImplicitPort AddOutput(const std::string & sIdentifier, const std::string & sDisplayName, const eImplicitPortType eType);
	inline PImplicitPortIterator GetOutputs();
	inline void RemoveOutput(classParam<CImplicitPort> pOutput);
	inline PImplicitPort FindInput(const std::string & sIdentifier);
	inline PImplicitPort FindOutput(const std::string & sIdentifier);
};
	
/*************************************************************************************************************************
 Class CImplicitFunction 
**************************************************************************************************************************/
class CImplicitFunction : public CFunction {
public:
	
	/**
	* CImplicitFunction::CImplicitFunction - Constructor for ImplicitFunction class.
	*/
	CImplicitFunction(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CFunction(pWrapper, pHandle)
	{
	}
	
	inline std::string GetIdentifier();
	inline void SetIdentifier(const std::string & sIdentifier);
	inline PImplicitNode AddNode(const eImplicitNodeType eNodeType, const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PSinNode AddSinNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PCosNode AddCosNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PTanNode AddTanNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PArcSinNode AddArcSinNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PArcCosNode AddArcCosNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PArcTan2Node AddArcTan2Node(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PSinhNode AddSinhNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PCoshNode AddCoshNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PTanhNode AddTanhNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PRoundNode AddRoundNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PCeilNode AddCeilNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PFloorNode AddFloorNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PSignNode AddSignNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PFractNode AddFractNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PAbsNode AddAbsNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PExpNode AddExpNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PLogNode AddLogNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PLog2Node AddLog2Node(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PLog10Node AddLog10Node(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PLengthNode AddLengthNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PTransposeNode AddTransposeNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PInverseNode AddInverseNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PSqrtNode AddSqrtNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PResourceIdNode AddResourceIdNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PAdditionNode AddAdditionNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PSubtractionNode AddSubtractionNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PMultiplicationNode AddMultiplicationNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PDivisionNode AddDivisionNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PDotNode AddDotNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PCrossNode AddCrossNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PMatVecMultiplicationNode AddMatVecMultiplicationNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PMinNode AddMinNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PMaxNode AddMaxNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PFmodNode AddFmodNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PPowNode AddPowNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PSelectNode AddSelectNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PClampNode AddClampNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag);
	inline PComposeVectorNode AddComposeVectorNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PVectorFromScalarNode AddVectorFromScalarNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PDecomposeVectorNode AddDecomposeVectorNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PComposeMatrixNode AddComposeMatrixNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PMatrixFromRowsNode AddMatrixFromRowsNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PMatrixFromColumnsNode AddMatrixFromColumnsNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PConstantNode AddConstantNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PConstVecNode AddConstVecNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PConstMatNode AddConstMatNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PMeshNode AddMeshNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PUnsignedMeshNode AddUnsignedMeshNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PBeamLatticeNode AddBeamLatticeNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PFunctionGradientNode AddFunctionGradientNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PNormalizeDistanceNode AddNormalizeDistanceNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PFunctionCallNode AddFunctionCallNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag);
	inline PNodeIterator GetNodes();
	inline void RemoveNode(classParam<CImplicitNode> pNode);
	inline void AddLink(classParam<CImplicitPort> pSource, classParam<CImplicitPort> pTarget);
	inline void AddLinkByNames(const std::string & sSource, const std::string & sTarget);
	inline void Clear();
	inline void SortNodesTopologically();
};
	
/*************************************************************************************************************************
 Class CFunctionFromImage3D 
**************************************************************************************************************************/
class CFunctionFromImage3D : public CFunction {
public:
	
	/**
	* CFunctionFromImage3D::CFunctionFromImage3D - Constructor for FunctionFromImage3D class.
	*/
	CFunctionFromImage3D(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CFunction(pWrapper, pHandle)
	{
	}
	
	inline PImage3D GetImage3D();
	inline void SetImage3D(classParam<CImage3D> pImage3D);
	inline void SetFilter(const eTextureFilter eFilter);
	inline eTextureFilter GetFilter();
	inline void SetTileStyles(const eTextureTileStyle eTileStyleU, const eTextureTileStyle eTileStyleV, const eTextureTileStyle eTileStyleW);
	inline void GetTileStyles(eTextureTileStyle & eTileStyleU, eTextureTileStyle & eTileStyleV, eTextureTileStyle & eTileStyleW);
	inline Lib3MF_double GetOffset();
	inline void SetOffset(const Lib3MF_double dOffset);
	inline Lib3MF_double GetScale();
	inline void SetScale(const Lib3MF_double dScale);
};
	
/*************************************************************************************************************************
 Class CBuildItem 
**************************************************************************************************************************/
class CBuildItem : public CBase {
public:
	
	/**
	* CBuildItem::CBuildItem - Constructor for BuildItem class.
	*/
	CBuildItem(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline PObject GetObjectResource();
	inline std::string GetUUID(bool & bHasUUID);
	inline void SetUUID(const std::string & sUUID);
	inline Lib3MF_uint32 GetObjectResourceID();
	inline bool HasObjectTransform();
	inline sTransform GetObjectTransform();
	inline void SetObjectTransform(const sTransform & Transform);
	inline std::string GetPartNumber();
	inline void SetPartNumber(const std::string & sSetPartnumber);
	inline PMetaDataGroup GetMetaDataGroup();
	inline sBox GetOutbox();
};
	
/*************************************************************************************************************************
 Class CBuildItemIterator 
**************************************************************************************************************************/
class CBuildItemIterator : public CBase {
public:
	
	/**
	* CBuildItemIterator::CBuildItemIterator - Constructor for BuildItemIterator class.
	*/
	CBuildItemIterator(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline bool MoveNext();
	inline bool MovePrevious();
	inline PBuildItem GetCurrent();
	inline PBuildItemIterator Clone();
	inline Lib3MF_uint64 Count();
};
	
/*************************************************************************************************************************
 Class CSlice 
**************************************************************************************************************************/
class CSlice : public CBase {
public:
	
	/**
	* CSlice::CSlice - Constructor for Slice class.
	*/
	CSlice(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline void SetVertices(const CInputVector<sPosition2D> & VerticesBuffer);
	inline void GetVertices(std::vector<sPosition2D> & VerticesBuffer);
	inline Lib3MF_uint64 GetVertexCount();
	inline Lib3MF_uint64 AddPolygon(const CInputVector<Lib3MF_uint32> & IndicesBuffer);
	inline Lib3MF_uint64 GetPolygonCount();
	inline void SetPolygonIndices(const Lib3MF_uint64 nIndex, const CInputVector<Lib3MF_uint32> & IndicesBuffer);
	inline void GetPolygonIndices(const Lib3MF_uint64 nIndex, std::vector<Lib3MF_uint32> & IndicesBuffer);
	inline Lib3MF_uint64 GetPolygonIndexCount(const Lib3MF_uint64 nIndex);
	inline Lib3MF_double GetZTop();
};
	
/*************************************************************************************************************************
 Class CSliceStack 
**************************************************************************************************************************/
class CSliceStack : public CResource {
public:
	
	/**
	* CSliceStack::CSliceStack - Constructor for SliceStack class.
	*/
	CSliceStack(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CResource(pWrapper, pHandle)
	{
	}
	
	inline Lib3MF_double GetBottomZ();
	inline Lib3MF_uint64 GetSliceCount();
	inline PSlice GetSlice(const Lib3MF_uint64 nSliceIndex);
	inline PSlice AddSlice(const Lib3MF_double dZTop);
	inline Lib3MF_uint64 GetSliceRefCount();
	inline void AddSliceStackReference(classParam<CSliceStack> pTheSliceStack);
	inline PSliceStack GetSliceStackReference(const Lib3MF_uint64 nSliceRefIndex);
	inline void CollapseSliceReferences();
	inline void SetOwnPath(const std::string & sPath);
	inline std::string GetOwnPath();
};
	
/*************************************************************************************************************************
 Class CConsumer 
**************************************************************************************************************************/
class CConsumer : public CBase {
public:
	
	/**
	* CConsumer::CConsumer - Constructor for Consumer class.
	*/
	CConsumer(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline std::string GetConsumerID();
	inline std::string GetKeyID();
	inline std::string GetKeyValue();
};
	
/*************************************************************************************************************************
 Class CAccessRight 
**************************************************************************************************************************/
class CAccessRight : public CBase {
public:
	
	/**
	* CAccessRight::CAccessRight - Constructor for AccessRight class.
	*/
	CAccessRight(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline PConsumer GetConsumer();
	inline eWrappingAlgorithm GetWrappingAlgorithm();
	inline eMgfAlgorithm GetMgfAlgorithm();
	inline eDigestMethod GetDigestMethod();
};
	
/*************************************************************************************************************************
 Class CContentEncryptionParams 
**************************************************************************************************************************/
class CContentEncryptionParams : public CBase {
public:
	
	/**
	* CContentEncryptionParams::CContentEncryptionParams - Constructor for ContentEncryptionParams class.
	*/
	CContentEncryptionParams(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline eEncryptionAlgorithm GetEncryptionAlgorithm();
	inline void GetKey(std::vector<Lib3MF_uint8> & ByteDataBuffer);
	inline void GetInitializationVector(std::vector<Lib3MF_uint8> & ByteDataBuffer);
	inline void GetAuthenticationTag(std::vector<Lib3MF_uint8> & ByteDataBuffer);
	inline void SetAuthenticationTag(const CInputVector<Lib3MF_uint8> & ByteDataBuffer);
	inline void GetAdditionalAuthenticationData(std::vector<Lib3MF_uint8> & ByteDataBuffer);
	inline Lib3MF_uint64 GetDescriptor();
	inline std::string GetKeyUUID();
};
	
/*************************************************************************************************************************
 Class CResourceData 
**************************************************************************************************************************/
class CResourceData : public CBase {
public:
	
	/**
	* CResourceData::CResourceData - Constructor for ResourceData class.
	*/
	CResourceData(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline PPackagePart GetPath();
	inline eEncryptionAlgorithm GetEncryptionAlgorithm();
	inline eCompression GetCompression();
	inline void GetAdditionalAuthenticationData(std::vector<Lib3MF_uint8> & ByteDataBuffer);
};
	
/*************************************************************************************************************************
 Class CResourceDataGroup 
**************************************************************************************************************************/
class CResourceDataGroup : public CBase {
public:
	
	/**
	* CResourceDataGroup::CResourceDataGroup - Constructor for ResourceDataGroup class.
	*/
	CResourceDataGroup(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline std::string GetKeyUUID();
	inline PAccessRight AddAccessRight(classParam<CConsumer> pConsumer, const eWrappingAlgorithm eWrappingAlgorithm, const eMgfAlgorithm eMgfAlgorithm, const eDigestMethod eDigestMethod);
	inline PAccessRight FindAccessRightByConsumer(classParam<CConsumer> pConsumer);
	inline void RemoveAccessRight(classParam<CConsumer> pConsumer);
};
	
/*************************************************************************************************************************
 Class CKeyStore 
**************************************************************************************************************************/
class CKeyStore : public CBase {
public:
	
	/**
	* CKeyStore::CKeyStore - Constructor for KeyStore class.
	*/
	CKeyStore(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline PConsumer AddConsumer(const std::string & sConsumerID, const std::string & sKeyID, const std::string & sKeyValue);
	inline Lib3MF_uint64 GetConsumerCount();
	inline PConsumer GetConsumer(const Lib3MF_uint64 nConsumerIndex);
	inline void RemoveConsumer(classParam<CConsumer> pConsumer);
	inline PConsumer FindConsumer(const std::string & sConsumerID);
	inline Lib3MF_uint64 GetResourceDataGroupCount();
	inline PResourceDataGroup AddResourceDataGroup();
	inline PResourceDataGroup GetResourceDataGroup(const Lib3MF_uint64 nResourceDataIndex);
	inline void RemoveResourceDataGroup(classParam<CResourceDataGroup> pResourceDataGroup);
	inline PResourceDataGroup FindResourceDataGroup(classParam<CPackagePart> pPartPath);
	inline PResourceData AddResourceData(classParam<CResourceDataGroup> pResourceDataGroup, classParam<CPackagePart> pPartPath, const eEncryptionAlgorithm eAlgorithm, const eCompression eCompression, const CInputVector<Lib3MF_uint8> & AdditionalAuthenticationDataBuffer);
	inline void RemoveResourceData(classParam<CResourceData> pResourceData);
	inline PResourceData FindResourceData(classParam<CPackagePart> pResourcePath);
	inline Lib3MF_uint64 GetResourceDataCount();
	inline PResourceData GetResourceData(const Lib3MF_uint64 nResourceDataIndex);
	inline std::string GetUUID(bool & bHasUUID);
	inline void SetUUID(const std::string & sUUID);
};
	
/*************************************************************************************************************************
 Class CModel 
**************************************************************************************************************************/
class CModel : public CBase {
public:
	
	/**
	* CModel::CModel - Constructor for Model class.
	*/
	CModel(CWrapper* pWrapper, Lib3MFHandle pHandle)
		: CBase(pWrapper, pHandle)
	{
	}
	
	inline PPackagePart RootModelPart();
	inline PPackagePart FindOrCreatePackagePart(const std::string & sAbsolutePath);
	inline void SetUnit(const eModelUnit eUnit);
	inline eModelUnit GetUnit();
	inline std::string GetLanguage();
	inline void SetLanguage(const std::string & sLanguage);
	inline PWriter QueryWriter(const std::string & sWriterClass);
	inline PReader QueryReader(const std::string & sReaderClass);
	inline PResource GetResourceByID(const Lib3MF_uint32 nUniqueResourceID);
	inline PTexture2D GetTexture2DByID(const Lib3MF_uint32 nUniqueResourceID);
	inline ePropertyType GetPropertyTypeByID(const Lib3MF_uint32 nUniqueResourceID);
	inline PBaseMaterialGroup GetBaseMaterialGroupByID(const Lib3MF_uint32 nUniqueResourceID);
	inline PTexture2DGroup GetTexture2DGroupByID(const Lib3MF_uint32 nUniqueResourceID);
	inline PCompositeMaterials GetCompositeMaterialsByID(const Lib3MF_uint32 nUniqueResourceID);
	inline PMultiPropertyGroup GetMultiPropertyGroupByID(const Lib3MF_uint32 nUniqueResourceID);
	inline PMeshObject GetMeshObjectByID(const Lib3MF_uint32 nUniqueResourceID);
	inline PComponentsObject GetComponentsObjectByID(const Lib3MF_uint32 nUniqueResourceID);
	inline PColorGroup GetColorGroupByID(const Lib3MF_uint32 nUniqueResourceID);
	inline PSliceStack GetSliceStackByID(const Lib3MF_uint32 nUniqueResourceID);
	inline PLevelSet GetLevelSetByID(const Lib3MF_uint32 nUniqueResourceID);
	inline std::string GetBuildUUID(bool & bHasUUID);
	inline void SetBuildUUID(const std::string & sUUID);
	inline PBuildItemIterator GetBuildItems();
	inline sBox GetOutbox();
	inline PResourceIterator GetResources();
	inline PObjectIterator GetObjects();
	inline PMeshObjectIterator GetMeshObjects();
	inline PComponentsObjectIterator GetComponentsObjects();
	inline PTexture2DIterator GetTexture2Ds();
	inline PBaseMaterialGroupIterator GetBaseMaterialGroups();
	inline PColorGroupIterator GetColorGroups();
	inline PTexture2DGroupIterator GetTexture2DGroups();
	inline PCompositeMaterialsIterator GetCompositeMaterials();
	inline PMultiPropertyGroupIterator GetMultiPropertyGroups();
	inline PSliceStackIterator GetSliceStacks();
	inline PImage3DIterator GetImage3Ds();
	inline PModel MergeToModel();
	inline void MergeFromModel(classParam<CModel> pModelInstance);
	inline PMeshObject AddMeshObject();
	inline PComponentsObject AddComponentsObject();
	inline PSliceStack AddSliceStack(const Lib3MF_double dZBottom);
	inline PTexture2D AddTexture2DFromAttachment(classParam<CAttachment> pTextureAttachment);
	inline PBaseMaterialGroup AddBaseMaterialGroup();
	inline PColorGroup AddColorGroup();
	inline PTexture2DGroup AddTexture2DGroup(classParam<CTexture2D> pTexture2DInstance);
	inline PCompositeMaterials AddCompositeMaterials(classParam<CBaseMaterialGroup> pBaseMaterialGroupInstance);
	inline PMultiPropertyGroup AddMultiPropertyGroup();
	inline PImageStack AddImageStack(const Lib3MF_uint32 nColumnCount, const Lib3MF_uint32 nRowCount, const Lib3MF_uint32 nSheetCount);
	inline PImageStack GetImageStackByID(const Lib3MF_uint32 nUniqueResourceID);
	inline PBuildItem AddBuildItem(classParam<CObject> pObject, const sTransform & Transform);
	inline void RemoveBuildItem(classParam<CBuildItem> pBuildItemInstance);
	inline PMetaDataGroup GetMetaDataGroup();
	inline PAttachment AddAttachment(const std::string & sURI, const std::string & sRelationShipType);
	inline void RemoveAttachment(classParam<CAttachment> pAttachmentInstance);
	inline PAttachment GetAttachment(const Lib3MF_uint32 nIndex);
	inline PAttachment FindAttachment(const std::string & sURI);
	inline Lib3MF_uint32 GetAttachmentCount();
	inline bool HasPackageThumbnailAttachment();
	inline PAttachment CreatePackageThumbnailAttachment();
	inline PAttachment GetPackageThumbnailAttachment();
	inline void RemovePackageThumbnailAttachment();
	inline void AddCustomContentType(const std::string & sExtension, const std::string & sContentType);
	inline void RemoveCustomContentType(const std::string & sExtension);
	inline void SetRandomNumberCallback(const RandomNumberCallback pTheCallback, const Lib3MF_pvoid pUserData);
	inline PKeyStore GetKeyStore();
	inline PFunctionIterator GetFunctions();
	inline PImplicitFunction AddImplicitFunction();
	inline PFunctionFromImage3D AddFunctionFromImage3D(classParam<CImage3D> pImage3DInstance);
	inline PVolumeData AddVolumeData();
	inline PLevelSet AddLevelSet();
	inline PLevelSetIterator GetLevelSets();
	inline void RemoveResource(classParam<CResource> pResource);
};

/*************************************************************************************************************************
 RTTI: Polymorphic Factory implementation
**************************************************************************************************************************/

/**
* IMPORTANT: PolymorphicFactory method should not be used by application directly.
*            It's designed to be used on Lib3MFHandle object only once.
*            If it's used on any existing object as a form of dynamic cast then
*            CWrapper::AcquireInstance(CBase object) must be called after instantiating new object.
*            This is important to keep reference count matching between application and library sides.
*/
inline CBase* CWrapper::polymorphicFactory(Lib3MFHandle pHandle)
{
	Lib3MF_uint64 resultClassTypeId = 0;
	CheckError(nullptr, m_WrapperTable.m_Base_ClassTypeId(pHandle, &resultClassTypeId));
	switch(resultClassTypeId) {
		case 0x856632D0BAF1D8B7UL: return new CBase(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Base"
		case 0xE76F642F363FD7E9UL: return new CWriter(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Writer"
		case 0x2D86831DA59FBE72UL: return new CReader(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Reader"
		case 0x0E55A826D377483EUL: return new CPackagePart(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::PackagePart"
		case 0xDFE3889D1B269CBBUL: return new CResource(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Resource"
		case 0x460F3515E2621DBEUL: return new CResourceIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceIterator"
		case 0x69684DB99FA813F6UL: return new CSliceStackIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStackIterator"
		case 0xDE92510BD2112288UL: return new CObjectIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ObjectIterator"
		case 0xF4196034E2B9FDE6UL: return new CMeshObjectIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObjectIterator"
		case 0x564DE4217ED7614AUL: return new CComponentsObjectIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObjectIterator"
		case 0x4BD32B4870FFC03BUL: return new CTexture2DIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DIterator"
		case 0x65E6EDD9362C79CBUL: return new CBaseMaterialGroupIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroupIterator"
		case 0x10274A1757C729C0UL: return new CColorGroupIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroupIterator"
		case 0x30D55F4DB88FE0CAUL: return new CTexture2DGroupIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroupIterator"
		case 0xA99CC6C3F70FB6F9UL: return new CCompositeMaterialsIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterialsIterator"
		case 0xC2BDF5D8CBBDB1F0UL: return new CMultiPropertyGroupIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroupIterator"
		case 0xC4B8EC00A82BF336UL: return new CImage3DIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Image3DIterator"
		case 0x40E9035363ACE65EUL: return new CFunctionIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionIterator"
		case 0xA0C005C035D5371DUL: return new CLevelSetIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::LevelSetIterator"
		case 0xD17716D063DE2C22UL: return new CMetaData(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MetaData"
		case 0x0C3B85369E9B25D3UL: return new CMetaDataGroup(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MetaDataGroup"
		case 0x5950BB3EE8A82090UL: return new CTriangleSet(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::TriangleSet"
		case 0x2DA2136F577A779CUL: return new CObject(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Object"
		case 0x3B3A6DC6EC610497UL: return new CMeshObject(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObject"
		case 0xE8A7D9C192EFD0E2UL: return new CLevelSet(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::LevelSet"
		case 0x63B3B461B30B4BA5UL: return new CBeamLattice(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::BeamLattice"
		case 0x4DF17E76926221C2UL: return new CFunctionReference(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionReference"
		case 0xD85B5B6143E787E3UL: return new CVolumeDataColor(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataColor"
		case 0x241FE6B4817C3FE4UL: return new CMaterialMapping(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MaterialMapping"
		case 0x46F1DAC40581B304UL: return new CVolumeDataComposite(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataComposite"
		case 0xFC368AA44ACE42DAUL: return new CVolumeDataProperty(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeDataProperty"
		case 0x9200586FB91587A7UL: return new CVolumeData(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::VolumeData"
		case 0x4ECDB6A6F69F2BEBUL: return new CComponent(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Component"
		case 0x6522CF04EB283FEDUL: return new CComponentsObject(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObject"
		case 0x30CCDBE90E00B55BUL: return new CBeamSet(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::BeamSet"
		case 0xB27D4656E16609FAUL: return new CBaseMaterialGroup(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroup"
		case 0xD085FB2E49CDB5B1UL: return new CColorGroup(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroup"
		case 0xBC1208397E37055DUL: return new CTexture2DGroup(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroup"
		case 0xCE16224D688B86F2UL: return new CCompositeMaterials(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterials"
		case 0xB989E02E43158FE6UL: return new CMultiPropertyGroup(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroup"
		case 0xBD938FF2D2663D61UL: return new CImage3D(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Image3D"
		case 0x13A2561F0CFB712AUL: return new CImageStack(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ImageStack"
		case 0x8CE7A1191A63A35DUL: return new CAttachment(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Attachment"
		case 0xE0441CF976B36319UL: return new CTexture2D(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2D"
		case 0xD5C49B04AF1963CDUL: return new CImplicitPort(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitPort"
		case 0x52F06268CD098EFEUL: return new CIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Iterator"
		case 0xC62268F2D7C7012CUL: return new CImplicitPortIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitPortIterator"
		case 0xE72592A7725AB29BUL: return new CImplicitNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitNode"
		case 0xB19B9FDA94B0A5E7UL: return new COneInputNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::OneInputNode"
		case 0xD5AEA50A56306722UL: return new CSinNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::SinNode"
		case 0x59BC328F6FB5C5FFUL: return new CCosNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::CosNode"
		case 0x2614CC572AF350B7UL: return new CTanNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::TanNode"
		case 0xE554C8A7E72AAF4DUL: return new CArcSinNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcSinNode"
		case 0x943AF6AE0EFD2B8AUL: return new CArcCosNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcCosNode"
		case 0xE47D547615816BADUL: return new CArcTanNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcTanNode"
		case 0x3C7756A456F2D089UL: return new CSinhNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::SinhNode"
		case 0x4A993F91E1DE256DUL: return new CCoshNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::CoshNode"
		case 0xCF077B19B0B78E9DUL: return new CTanhNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::TanhNode"
		case 0xD9F5A53C657765AEUL: return new CRoundNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::RoundNode"
		case 0x627E211653E11D93UL: return new CCeilNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::CeilNode"
		case 0x392A0F4C041D249CUL: return new CFloorNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::FloorNode"
		case 0x8A45165E6C9646D7UL: return new CSignNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::SignNode"
		case 0x53E62FD67F4D9A65UL: return new CFractNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::FractNode"
		case 0x6B641C7060040BE3UL: return new CAbsNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::AbsNode"
		case 0x3390243A8E2410F3UL: return new CExpNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ExpNode"
		case 0x0070021D73AA89FDUL: return new CLogNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::LogNode"
		case 0xE8C0ABF7C5DC7068UL: return new CLog2Node(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Log2Node"
		case 0x87740AD53454E0DFUL: return new CLog10Node(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Log10Node"
		case 0xD85889E2739A74B1UL: return new CLengthNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::LengthNode"
		case 0xA808B7599C158CE6UL: return new CTransposeNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::TransposeNode"
		case 0xE8601F66A23A0540UL: return new CInverseNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::InverseNode"
		case 0x9F831944A3DE31DAUL: return new CSqrtNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::SqrtNode"
		case 0xCA86A77C71CD3FAEUL: return new CResourceIdNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceIdNode"
		case 0x7DE3951BA4C1064CUL: return new CTwoInputNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::TwoInputNode"
		case 0x57A2236998DF5248UL: return new CAdditionNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::AdditionNode"
		case 0x6079B12FFF345D02UL: return new CSubtractionNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::SubtractionNode"
		case 0xA3C27CF54C2AA76CUL: return new CMultiplicationNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MultiplicationNode"
		case 0xB896B6413C08CF39UL: return new CDivisionNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::DivisionNode"
		case 0xFE60932A66375FADUL: return new CDotNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::DotNode"
		case 0x106182D38CA5CFE3UL: return new CCrossNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::CrossNode"
		case 0xB6153EF5DE7E5E11UL: return new CArcTan2Node(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ArcTan2Node"
		case 0x7570C43B9721D0C0UL: return new CMatVecMultiplicationNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MatVecMultiplicationNode"
		case 0x846AFDE9A091E997UL: return new CMinNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MinNode"
		case 0x073F910381BF250DUL: return new CMaxNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MaxNode"
		case 0x1EF703D298223F2AUL: return new CFmodNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::FmodNode"
		case 0xEA57335849379F22UL: return new CModNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ModNode"
		case 0x7700AA17CA1AC0F8UL: return new CPowNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::PowNode"
		case 0x1127ED71E05A9BD4UL: return new CSelectNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::SelectNode"
		case 0x77AF68C971B1485FUL: return new CClampNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ClampNode"
		case 0x49C24B8840C01F7EUL: return new CComposeVectorNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ComposeVectorNode"
		case 0x2E417B93351375E2UL: return new CVectorFromScalarNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::VectorFromScalarNode"
		case 0xCC4F8D561CCE35D4UL: return new CDecomposeVectorNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::DecomposeVectorNode"
		case 0x9EF9EB54A53AA40DUL: return new CComposeMatrixNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ComposeMatrixNode"
		case 0xD6DFD0A7EB64AC33UL: return new CMatrixFromRowsNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MatrixFromRowsNode"
		case 0x0DCBEAFCF83F3AACUL: return new CMatrixFromColumnsNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MatrixFromColumnsNode"
		case 0x3F8E5D082F966B1BUL: return new CConstantNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ConstantNode"
		case 0x9C9363B3F708D556UL: return new CConstVecNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ConstVecNode"
		case 0xF85C90EDCE6F90A4UL: return new CConstMatNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ConstMatNode"
		case 0x53601FD432E3DEF4UL: return new CMeshNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::MeshNode"
		case 0x29985A628251A9CDUL: return new CUnsignedMeshNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::UnsignedMeshNode"
		case 0x0F3A4EE98F7FEC0CUL: return new CBeamLatticeNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::BeamLatticeNode"
		case 0x0437E27AEF740121UL: return new CFunctionGradientNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionGradientNode"
		case 0x817D2E566E73AA8FUL: return new CNormalizeDistanceNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::NormalizeDistanceNode"
		case 0x0765C17C952F24E3UL: return new CFunctionCallNode(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionCallNode"
		case 0xFC006BC888CAB4D0UL: return new CNodeIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::NodeIterator"
		case 0x9EFB2757CA1A5231UL: return new CFunction(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Function"
		case 0x6CE54469EEA83BC1UL: return new CImplicitFunction(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ImplicitFunction"
		case 0x9BD7D3C2026B8CE8UL: return new CFunctionFromImage3D(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::FunctionFromImage3D"
		case 0x68FB2D5FFC4BA12AUL: return new CBuildItem(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItem"
		case 0xA7D21BD364910860UL: return new CBuildItemIterator(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItemIterator"
		case 0x2198BCF4D8DF9C40UL: return new CSlice(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Slice"
		case 0x6594B031B6096238UL: return new CSliceStack(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStack"
		case 0xD9E46D5E6D8118EEUL: return new CConsumer(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Consumer"
		case 0x385C42FC5609498AUL: return new CAccessRight(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::AccessRight"
		case 0x7FB36B91D4CE4671UL: return new CContentEncryptionParams(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ContentEncryptionParams"
		case 0x1A47A5E258E22EF9UL: return new CResourceData(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceData"
		case 0xD59067227E428AA4UL: return new CResourceDataGroup(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceDataGroup"
		case 0x1CC9E0CC082253C6UL: return new CKeyStore(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::KeyStore"
		case 0x5A8164ECEDB03F09UL: return new CModel(this, pHandle); break; // First 64 bits of SHA1 of a string: "Lib3MF::Model"
	}
	return new CBase(this, pHandle);
}
	
	/**
	* CWrapper::GetLibraryVersion - retrieves the binary version of this library.
	* @param[out] nMajor - returns the major version of this library
	* @param[out] nMinor - returns the minor version of this library
	* @param[out] nMicro - returns the micro version of this library
	*/
	inline void CWrapper::GetLibraryVersion(Lib3MF_uint32 & nMajor, Lib3MF_uint32 & nMinor, Lib3MF_uint32 & nMicro)
	{
		CheckError(nullptr,m_WrapperTable.m_GetLibraryVersion(&nMajor, &nMinor, &nMicro));
	}
	
	/**
	* CWrapper::GetPrereleaseInformation - retrieves prerelease information of this library.
	* @return Does the library provide prerelease version?
	* @param[out] sPrereleaseInfo - retrieves prerelease information of this library.
	*/
	inline bool CWrapper::GetPrereleaseInformation(std::string & sPrereleaseInfo)
	{
		bool resultHasPrereleaseInfo = 0;
		Lib3MF_uint32 bytesNeededPrereleaseInfo = 0;
		Lib3MF_uint32 bytesWrittenPrereleaseInfo = 0;
		CheckError(nullptr,m_WrapperTable.m_GetPrereleaseInformation(&resultHasPrereleaseInfo, 0, &bytesNeededPrereleaseInfo, nullptr));
		std::vector<char> bufferPrereleaseInfo(bytesNeededPrereleaseInfo);
		CheckError(nullptr,m_WrapperTable.m_GetPrereleaseInformation(&resultHasPrereleaseInfo, bytesNeededPrereleaseInfo, &bytesWrittenPrereleaseInfo, &bufferPrereleaseInfo[0]));
		sPrereleaseInfo = std::string(&bufferPrereleaseInfo[0]);
		
		return resultHasPrereleaseInfo;
	}
	
	/**
	* CWrapper::GetBuildInformation - retrieves build information of this library.
	* @return Does the library provide build version?
	* @param[out] sBuildInformation - retrieves build information of this library.
	*/
	inline bool CWrapper::GetBuildInformation(std::string & sBuildInformation)
	{
		bool resultHasBuildInfo = 0;
		Lib3MF_uint32 bytesNeededBuildInformation = 0;
		Lib3MF_uint32 bytesWrittenBuildInformation = 0;
		CheckError(nullptr,m_WrapperTable.m_GetBuildInformation(&resultHasBuildInfo, 0, &bytesNeededBuildInformation, nullptr));
		std::vector<char> bufferBuildInformation(bytesNeededBuildInformation);
		CheckError(nullptr,m_WrapperTable.m_GetBuildInformation(&resultHasBuildInfo, bytesNeededBuildInformation, &bytesWrittenBuildInformation, &bufferBuildInformation[0]));
		sBuildInformation = std::string(&bufferBuildInformation[0]);
		
		return resultHasBuildInfo;
	}
	
	/**
	* CWrapper::GetSpecificationVersion - retrieves whether a specification is supported, and if so, which version.
	* @param[in] sSpecificationURL - URL of extension to check
	* @param[out] bIsSupported - returns whether this specification is supported
	* @param[out] nMajor - returns the major version of the extension (if IsSupported)
	* @param[out] nMinor - returns the minor version of the extension (if IsSupported)
	* @param[out] nMicro - returns the micro version of the extension (if IsSupported)
	*/
	inline void CWrapper::GetSpecificationVersion(const std::string & sSpecificationURL, bool & bIsSupported, Lib3MF_uint32 & nMajor, Lib3MF_uint32 & nMinor, Lib3MF_uint32 & nMicro)
	{
		CheckError(nullptr,m_WrapperTable.m_GetSpecificationVersion(sSpecificationURL.c_str(), &bIsSupported, &nMajor, &nMinor, &nMicro));
	}
	
	/**
	* CWrapper::CreateModel - creates an empty model instance.
	* @return returns an empty model instance
	*/
	inline PModel CWrapper::CreateModel()
	{
		Lib3MFHandle hModel = (Lib3MFHandle)nullptr;
		CheckError(nullptr,m_WrapperTable.m_CreateModel(&hModel));
		
		if (!hModel) {
			CheckError(nullptr,LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CModel>(dynamic_cast<CModel*>(this->polymorphicFactory(hModel)));
	}
	
	/**
	* CWrapper::Release - releases shared ownership of an object instance
	* @param[in] pInstance - the object instance to release
	*/
	inline void CWrapper::Release(classParam<CBase> pInstance)
	{
		Lib3MFHandle hInstance = pInstance.GetHandle();
		CheckError(nullptr,m_WrapperTable.m_Release(hInstance));
	}
	
	/**
	* CWrapper::Acquire - acquires shared ownership of an object instance
	* @param[in] pInstance - the object instance to acquire
	*/
	inline void CWrapper::Acquire(classParam<CBase> pInstance)
	{
		Lib3MFHandle hInstance = pInstance.GetHandle();
		CheckError(nullptr,m_WrapperTable.m_Acquire(hInstance));
	}
	
	/**
	* CWrapper::SetJournal - Sets the journal file path
	* @param[in] sJournalPath - File name of the journal file
	*/
	inline void CWrapper::SetJournal(const std::string & sJournalPath)
	{
		CheckError(nullptr,m_WrapperTable.m_SetJournal(sJournalPath.c_str()));
	}
	
	/**
	* CWrapper::GetLastError - Retrieves the last error string of an instance
	* @param[in] pInstance - Object where the error occured.
	* @param[out] sLastErrorString - Last Error String
	* @return Returns if the instance has a last error.
	*/
	inline bool CWrapper::GetLastError(classParam<CBase> pInstance, std::string & sLastErrorString)
	{
		Lib3MFHandle hInstance = pInstance.GetHandle();
		Lib3MF_uint32 bytesNeededLastErrorString = 0;
		Lib3MF_uint32 bytesWrittenLastErrorString = 0;
		bool resultHasLastError = 0;
		CheckError(nullptr,m_WrapperTable.m_GetLastError(hInstance, 0, &bytesNeededLastErrorString, nullptr, &resultHasLastError));
		std::vector<char> bufferLastErrorString(bytesNeededLastErrorString);
		CheckError(nullptr,m_WrapperTable.m_GetLastError(hInstance, bytesNeededLastErrorString, &bytesWrittenLastErrorString, &bufferLastErrorString[0], &resultHasLastError));
		sLastErrorString = std::string(&bufferLastErrorString[0]);
		
		return resultHasLastError;
	}
	
	/**
	* CWrapper::GetSymbolLookupMethod - Returns the address of the SymbolLookupMethod
	* @return Address of the SymbolAddressMethod
	*/
	inline Lib3MF_pvoid CWrapper::GetSymbolLookupMethod()
	{
		Lib3MF_pvoid resultSymbolLookupMethod = 0;
		CheckError(nullptr,m_WrapperTable.m_GetSymbolLookupMethod(&resultSymbolLookupMethod));
		
		return resultSymbolLookupMethod;
	}
	
	/**
	* CWrapper::RetrieveProgressMessage - Return an English text for a progress identifier.|Note: this is the only function you can call from your callback function.
	* @param[in] eTheProgressIdentifier - the progress identifier that is passed to the callback function
	* @param[out] sProgressMessage - English text for the progress identifier
	*/
	inline void CWrapper::RetrieveProgressMessage(const eProgressIdentifier eTheProgressIdentifier, std::string & sProgressMessage)
	{
		Lib3MF_uint32 bytesNeededProgressMessage = 0;
		Lib3MF_uint32 bytesWrittenProgressMessage = 0;
		CheckError(nullptr,m_WrapperTable.m_RetrieveProgressMessage(eTheProgressIdentifier, 0, &bytesNeededProgressMessage, nullptr));
		std::vector<char> bufferProgressMessage(bytesNeededProgressMessage);
		CheckError(nullptr,m_WrapperTable.m_RetrieveProgressMessage(eTheProgressIdentifier, bytesNeededProgressMessage, &bytesWrittenProgressMessage, &bufferProgressMessage[0]));
		sProgressMessage = std::string(&bufferProgressMessage[0]);
	}
	
	/**
	* CWrapper::RGBAToColor - Creates a Color from uint8 RGBA values
	* @param[in] nRed - Red value of color (0-255)
	* @param[in] nGreen - Green value of color (0-255)
	* @param[in] nBlue - Blue value of color (0-255)
	* @param[in] nAlpha - Alpha value of color (0-255)
	* @return Assembled color
	*/
	inline sColor CWrapper::RGBAToColor(const Lib3MF_uint8 nRed, const Lib3MF_uint8 nGreen, const Lib3MF_uint8 nBlue, const Lib3MF_uint8 nAlpha)
	{
		sColor resultTheColor;
		CheckError(nullptr,m_WrapperTable.m_RGBAToColor(nRed, nGreen, nBlue, nAlpha, &resultTheColor));
		
		return resultTheColor;
	}
	
	/**
	* CWrapper::FloatRGBAToColor - Creates a Color from uint8 RGBA values
	* @param[in] fRed - Red value of color (0-1)
	* @param[in] fGreen - Green value of color (0-1)
	* @param[in] fBlue - Blue value of color (0-1)
	* @param[in] fAlpha - Alpha value of color (0-1)
	* @return Assembled color
	*/
	inline sColor CWrapper::FloatRGBAToColor(const Lib3MF_single fRed, const Lib3MF_single fGreen, const Lib3MF_single fBlue, const Lib3MF_single fAlpha)
	{
		sColor resultTheColor;
		CheckError(nullptr,m_WrapperTable.m_FloatRGBAToColor(fRed, fGreen, fBlue, fAlpha, &resultTheColor));
		
		return resultTheColor;
	}
	
	/**
	* CWrapper::ColorToRGBA - Calculates uint8-RGBA-values from a Color
	* @param[in] TheColor - Color to handle
	* @param[out] nRed - Red value of color (0-255)
	* @param[out] nGreen - Green value of color (0-255)
	* @param[out] nBlue - Blue value of color (0-255)
	* @param[out] nAlpha - Alpha value of color (0-255)
	*/
	inline void CWrapper::ColorToRGBA(const sColor & TheColor, Lib3MF_uint8 & nRed, Lib3MF_uint8 & nGreen, Lib3MF_uint8 & nBlue, Lib3MF_uint8 & nAlpha)
	{
		CheckError(nullptr,m_WrapperTable.m_ColorToRGBA(&TheColor, &nRed, &nGreen, &nBlue, &nAlpha));
	}
	
	/**
	* CWrapper::ColorToFloatRGBA - Calculates float-RGBA-values from a Color
	* @param[in] TheColor - Color to handle
	* @param[out] fRed - Red value of color (0-1)
	* @param[out] fGreen - Green value of color (0-1)
	* @param[out] fBlue - Blue value of color (0-1)
	* @param[out] fAlpha - Alpha value of color (0-1)
	*/
	inline void CWrapper::ColorToFloatRGBA(const sColor & TheColor, Lib3MF_single & fRed, Lib3MF_single & fGreen, Lib3MF_single & fBlue, Lib3MF_single & fAlpha)
	{
		CheckError(nullptr,m_WrapperTable.m_ColorToFloatRGBA(&TheColor, &fRed, &fGreen, &fBlue, &fAlpha));
	}
	
	/**
	* CWrapper::GetIdentityTransform - Creates an identity transform
	* @return Transformation matrix.
	*/
	inline sTransform CWrapper::GetIdentityTransform()
	{
		sTransform resultTransform;
		CheckError(nullptr,m_WrapperTable.m_GetIdentityTransform(&resultTransform));
		
		return resultTransform;
	}
	
	/**
	* CWrapper::GetUniformScaleTransform - Creates a uniform scale transform
	* @param[in] fFactor - Factor in X, Y and Z
	* @return Transformation matrix.
	*/
	inline sTransform CWrapper::GetUniformScaleTransform(const Lib3MF_single fFactor)
	{
		sTransform resultTransform;
		CheckError(nullptr,m_WrapperTable.m_GetUniformScaleTransform(fFactor, &resultTransform));
		
		return resultTransform;
	}
	
	/**
	* CWrapper::GetScaleTransform - Creates a scale transform
	* @param[in] fFactorX - Factor in X
	* @param[in] fFactorY - Factor in Y
	* @param[in] fFactorZ - Factor in Z
	* @return Transformation matrix.
	*/
	inline sTransform CWrapper::GetScaleTransform(const Lib3MF_single fFactorX, const Lib3MF_single fFactorY, const Lib3MF_single fFactorZ)
	{
		sTransform resultTransform;
		CheckError(nullptr,m_WrapperTable.m_GetScaleTransform(fFactorX, fFactorY, fFactorZ, &resultTransform));
		
		return resultTransform;
	}
	
	/**
	* CWrapper::GetTranslationTransform - Creates an translation transform
	* @param[in] fVectorX - Translation in X
	* @param[in] fVectorY - Translation in Y
	* @param[in] fVectorZ - Translation in Z
	* @return Transformation matrix.
	*/
	inline sTransform CWrapper::GetTranslationTransform(const Lib3MF_single fVectorX, const Lib3MF_single fVectorY, const Lib3MF_single fVectorZ)
	{
		sTransform resultTransform;
		CheckError(nullptr,m_WrapperTable.m_GetTranslationTransform(fVectorX, fVectorY, fVectorZ, &resultTransform));
		
		return resultTransform;
	}

	inline void CWrapper::CheckError(CBase * pBaseClass, Lib3MFResult nResult)
	{
		if (nResult != 0) {
			std::string sErrorMessage;
			if (pBaseClass != nullptr) {
				GetLastError(pBaseClass, sErrorMessage);
			}
			throw ELib3MFException(nResult, sErrorMessage);
		}
	}
	

	inline Lib3MFResult CWrapper::initWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable)
	{
		if (pWrapperTable == nullptr)
			return LIB3MF_ERROR_INVALIDPARAM;
		
		pWrapperTable->m_LibraryHandle = nullptr;
		pWrapperTable->m_Base_ClassTypeId = nullptr;
		pWrapperTable->m_Writer_WriteToFile = nullptr;
		pWrapperTable->m_Writer_GetStreamSize = nullptr;
		pWrapperTable->m_Writer_WriteToBuffer = nullptr;
		pWrapperTable->m_Writer_WriteToCallback = nullptr;
		pWrapperTable->m_Writer_SetProgressCallback = nullptr;
		pWrapperTable->m_Writer_GetDecimalPrecision = nullptr;
		pWrapperTable->m_Writer_SetDecimalPrecision = nullptr;
		pWrapperTable->m_Writer_SetStrictModeActive = nullptr;
		pWrapperTable->m_Writer_GetStrictModeActive = nullptr;
		pWrapperTable->m_Writer_GetWarning = nullptr;
		pWrapperTable->m_Writer_GetWarningCount = nullptr;
		pWrapperTable->m_Writer_AddKeyWrappingCallback = nullptr;
		pWrapperTable->m_Writer_SetContentEncryptionCallback = nullptr;
		pWrapperTable->m_Reader_ReadFromFile = nullptr;
		pWrapperTable->m_Reader_ReadFromBuffer = nullptr;
		pWrapperTable->m_Reader_ReadFromCallback = nullptr;
		pWrapperTable->m_Reader_SetProgressCallback = nullptr;
		pWrapperTable->m_Reader_AddRelationToRead = nullptr;
		pWrapperTable->m_Reader_RemoveRelationToRead = nullptr;
		pWrapperTable->m_Reader_SetStrictModeActive = nullptr;
		pWrapperTable->m_Reader_GetStrictModeActive = nullptr;
		pWrapperTable->m_Reader_GetWarning = nullptr;
		pWrapperTable->m_Reader_GetWarningCount = nullptr;
		pWrapperTable->m_Reader_AddKeyWrappingCallback = nullptr;
		pWrapperTable->m_Reader_SetContentEncryptionCallback = nullptr;
		pWrapperTable->m_PackagePart_GetPath = nullptr;
		pWrapperTable->m_PackagePart_SetPath = nullptr;
		pWrapperTable->m_Resource_GetResourceID = nullptr;
		pWrapperTable->m_Resource_GetUniqueResourceID = nullptr;
		pWrapperTable->m_Resource_PackagePart = nullptr;
		pWrapperTable->m_Resource_SetPackagePart = nullptr;
		pWrapperTable->m_Resource_GetModelResourceID = nullptr;
		pWrapperTable->m_ResourceIterator_MoveNext = nullptr;
		pWrapperTable->m_ResourceIterator_MovePrevious = nullptr;
		pWrapperTable->m_ResourceIterator_GetCurrent = nullptr;
		pWrapperTable->m_ResourceIterator_Clone = nullptr;
		pWrapperTable->m_ResourceIterator_Count = nullptr;
		pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack = nullptr;
		pWrapperTable->m_ObjectIterator_GetCurrentObject = nullptr;
		pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject = nullptr;
		pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject = nullptr;
		pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D = nullptr;
		pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup = nullptr;
		pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup = nullptr;
		pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup = nullptr;
		pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials = nullptr;
		pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup = nullptr;
		pWrapperTable->m_Image3DIterator_GetCurrentImage3D = nullptr;
		pWrapperTable->m_FunctionIterator_GetCurrentFunction = nullptr;
		pWrapperTable->m_LevelSetIterator_GetCurrentLevelSet = nullptr;
		pWrapperTable->m_MetaData_GetNameSpace = nullptr;
		pWrapperTable->m_MetaData_SetNameSpace = nullptr;
		pWrapperTable->m_MetaData_GetName = nullptr;
		pWrapperTable->m_MetaData_SetName = nullptr;
		pWrapperTable->m_MetaData_GetKey = nullptr;
		pWrapperTable->m_MetaData_GetMustPreserve = nullptr;
		pWrapperTable->m_MetaData_SetMustPreserve = nullptr;
		pWrapperTable->m_MetaData_GetType = nullptr;
		pWrapperTable->m_MetaData_SetType = nullptr;
		pWrapperTable->m_MetaData_GetValue = nullptr;
		pWrapperTable->m_MetaData_SetValue = nullptr;
		pWrapperTable->m_MetaDataGroup_GetMetaDataCount = nullptr;
		pWrapperTable->m_MetaDataGroup_GetMetaData = nullptr;
		pWrapperTable->m_MetaDataGroup_GetMetaDataByKey = nullptr;
		pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex = nullptr;
		pWrapperTable->m_MetaDataGroup_RemoveMetaData = nullptr;
		pWrapperTable->m_MetaDataGroup_AddMetaData = nullptr;
		pWrapperTable->m_TriangleSet_SetName = nullptr;
		pWrapperTable->m_TriangleSet_GetName = nullptr;
		pWrapperTable->m_TriangleSet_SetIdentifier = nullptr;
		pWrapperTable->m_TriangleSet_GetIdentifier = nullptr;
		pWrapperTable->m_TriangleSet_AddTriangle = nullptr;
		pWrapperTable->m_TriangleSet_RemoveTriangle = nullptr;
		pWrapperTable->m_TriangleSet_Clear = nullptr;
		pWrapperTable->m_TriangleSet_SetTriangleList = nullptr;
		pWrapperTable->m_TriangleSet_GetTriangleList = nullptr;
		pWrapperTable->m_TriangleSet_AddTriangleList = nullptr;
		pWrapperTable->m_TriangleSet_Merge = nullptr;
		pWrapperTable->m_TriangleSet_DeleteSet = nullptr;
		pWrapperTable->m_TriangleSet_Duplicate = nullptr;
		pWrapperTable->m_Object_GetType = nullptr;
		pWrapperTable->m_Object_SetType = nullptr;
		pWrapperTable->m_Object_GetName = nullptr;
		pWrapperTable->m_Object_SetName = nullptr;
		pWrapperTable->m_Object_GetPartNumber = nullptr;
		pWrapperTable->m_Object_SetPartNumber = nullptr;
		pWrapperTable->m_Object_IsMeshObject = nullptr;
		pWrapperTable->m_Object_IsComponentsObject = nullptr;
		pWrapperTable->m_Object_IsLevelSetObject = nullptr;
		pWrapperTable->m_Object_IsValid = nullptr;
		pWrapperTable->m_Object_SetAttachmentAsThumbnail = nullptr;
		pWrapperTable->m_Object_GetThumbnailAttachment = nullptr;
		pWrapperTable->m_Object_ClearThumbnailAttachment = nullptr;
		pWrapperTable->m_Object_GetOutbox = nullptr;
		pWrapperTable->m_Object_GetUUID = nullptr;
		pWrapperTable->m_Object_SetUUID = nullptr;
		pWrapperTable->m_Object_GetMetaDataGroup = nullptr;
		pWrapperTable->m_Object_SetSlicesMeshResolution = nullptr;
		pWrapperTable->m_Object_GetSlicesMeshResolution = nullptr;
		pWrapperTable->m_Object_HasSlices = nullptr;
		pWrapperTable->m_Object_ClearSliceStack = nullptr;
		pWrapperTable->m_Object_GetSliceStack = nullptr;
		pWrapperTable->m_Object_AssignSliceStack = nullptr;
		pWrapperTable->m_MeshObject_GetVertexCount = nullptr;
		pWrapperTable->m_MeshObject_GetTriangleCount = nullptr;
		pWrapperTable->m_MeshObject_GetVertex = nullptr;
		pWrapperTable->m_MeshObject_SetVertex = nullptr;
		pWrapperTable->m_MeshObject_AddVertex = nullptr;
		pWrapperTable->m_MeshObject_GetVertices = nullptr;
		pWrapperTable->m_MeshObject_GetTriangle = nullptr;
		pWrapperTable->m_MeshObject_SetTriangle = nullptr;
		pWrapperTable->m_MeshObject_AddTriangle = nullptr;
		pWrapperTable->m_MeshObject_GetTriangleIndices = nullptr;
		pWrapperTable->m_MeshObject_SetObjectLevelProperty = nullptr;
		pWrapperTable->m_MeshObject_GetObjectLevelProperty = nullptr;
		pWrapperTable->m_MeshObject_SetTriangleProperties = nullptr;
		pWrapperTable->m_MeshObject_GetTriangleProperties = nullptr;
		pWrapperTable->m_MeshObject_SetAllTriangleProperties = nullptr;
		pWrapperTable->m_MeshObject_GetAllTriangleProperties = nullptr;
		pWrapperTable->m_MeshObject_ClearAllProperties = nullptr;
		pWrapperTable->m_MeshObject_SetGeometry = nullptr;
		pWrapperTable->m_MeshObject_IsManifoldAndOriented = nullptr;
		pWrapperTable->m_MeshObject_BeamLattice = nullptr;
		pWrapperTable->m_MeshObject_GetVolumeData = nullptr;
		pWrapperTable->m_MeshObject_SetVolumeData = nullptr;
		pWrapperTable->m_MeshObject_AddTriangleSet = nullptr;
		pWrapperTable->m_MeshObject_HasTriangleSet = nullptr;
		pWrapperTable->m_MeshObject_FindTriangleSet = nullptr;
		pWrapperTable->m_MeshObject_GetTriangleSetCount = nullptr;
		pWrapperTable->m_MeshObject_GetTriangleSet = nullptr;
		pWrapperTable->m_LevelSet_GetFunction = nullptr;
		pWrapperTable->m_LevelSet_SetFunction = nullptr;
		pWrapperTable->m_LevelSet_GetTransform = nullptr;
		pWrapperTable->m_LevelSet_SetTransform = nullptr;
		pWrapperTable->m_LevelSet_GetChannelName = nullptr;
		pWrapperTable->m_LevelSet_SetChannelName = nullptr;
		pWrapperTable->m_LevelSet_SetMinFeatureSize = nullptr;
		pWrapperTable->m_LevelSet_GetMinFeatureSize = nullptr;
		pWrapperTable->m_LevelSet_SetFallBackValue = nullptr;
		pWrapperTable->m_LevelSet_GetFallBackValue = nullptr;
		pWrapperTable->m_LevelSet_SetMeshBBoxOnly = nullptr;
		pWrapperTable->m_LevelSet_GetMeshBBoxOnly = nullptr;
		pWrapperTable->m_LevelSet_SetMesh = nullptr;
		pWrapperTable->m_LevelSet_GetMesh = nullptr;
		pWrapperTable->m_LevelSet_GetVolumeData = nullptr;
		pWrapperTable->m_LevelSet_SetVolumeData = nullptr;
		pWrapperTable->m_BeamLattice_GetMinLength = nullptr;
		pWrapperTable->m_BeamLattice_SetMinLength = nullptr;
		pWrapperTable->m_BeamLattice_GetClipping = nullptr;
		pWrapperTable->m_BeamLattice_SetClipping = nullptr;
		pWrapperTable->m_BeamLattice_GetRepresentation = nullptr;
		pWrapperTable->m_BeamLattice_SetRepresentation = nullptr;
		pWrapperTable->m_BeamLattice_GetBallOptions = nullptr;
		pWrapperTable->m_BeamLattice_SetBallOptions = nullptr;
		pWrapperTable->m_BeamLattice_GetBeamCount = nullptr;
		pWrapperTable->m_BeamLattice_GetBeam = nullptr;
		pWrapperTable->m_BeamLattice_AddBeam = nullptr;
		pWrapperTable->m_BeamLattice_SetBeam = nullptr;
		pWrapperTable->m_BeamLattice_SetBeams = nullptr;
		pWrapperTable->m_BeamLattice_GetBeams = nullptr;
		pWrapperTable->m_BeamLattice_GetBallCount = nullptr;
		pWrapperTable->m_BeamLattice_GetBall = nullptr;
		pWrapperTable->m_BeamLattice_AddBall = nullptr;
		pWrapperTable->m_BeamLattice_SetBall = nullptr;
		pWrapperTable->m_BeamLattice_SetBalls = nullptr;
		pWrapperTable->m_BeamLattice_GetBalls = nullptr;
		pWrapperTable->m_BeamLattice_GetBeamSetCount = nullptr;
		pWrapperTable->m_BeamLattice_AddBeamSet = nullptr;
		pWrapperTable->m_BeamLattice_GetBeamSet = nullptr;
		pWrapperTable->m_FunctionReference_GetFunctionResourceID = nullptr;
		pWrapperTable->m_FunctionReference_SetFunctionResourceID = nullptr;
		pWrapperTable->m_FunctionReference_GetTransform = nullptr;
		pWrapperTable->m_FunctionReference_SetTransform = nullptr;
		pWrapperTable->m_FunctionReference_GetChannelName = nullptr;
		pWrapperTable->m_FunctionReference_SetChannelName = nullptr;
		pWrapperTable->m_FunctionReference_SetMinFeatureSize = nullptr;
		pWrapperTable->m_FunctionReference_GetMinFeatureSize = nullptr;
		pWrapperTable->m_FunctionReference_SetFallBackValue = nullptr;
		pWrapperTable->m_FunctionReference_GetFallBackValue = nullptr;
		pWrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup = nullptr;
		pWrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup = nullptr;
		pWrapperTable->m_VolumeDataComposite_GetMaterialMappingCount = nullptr;
		pWrapperTable->m_VolumeDataComposite_GetMaterialMapping = nullptr;
		pWrapperTable->m_VolumeDataComposite_AddMaterialMapping = nullptr;
		pWrapperTable->m_VolumeDataComposite_RemoveMaterialMapping = nullptr;
		pWrapperTable->m_VolumeDataProperty_GetName = nullptr;
		pWrapperTable->m_VolumeDataProperty_SetIsRequired = nullptr;
		pWrapperTable->m_VolumeDataProperty_IsRequired = nullptr;
		pWrapperTable->m_VolumeData_GetComposite = nullptr;
		pWrapperTable->m_VolumeData_CreateNewComposite = nullptr;
		pWrapperTable->m_VolumeData_RemoveComposite = nullptr;
		pWrapperTable->m_VolumeData_GetColor = nullptr;
		pWrapperTable->m_VolumeData_CreateNewColor = nullptr;
		pWrapperTable->m_VolumeData_RemoveColor = nullptr;
		pWrapperTable->m_VolumeData_GetPropertyCount = nullptr;
		pWrapperTable->m_VolumeData_GetProperty = nullptr;
		pWrapperTable->m_VolumeData_AddPropertyFromFunction = nullptr;
		pWrapperTable->m_VolumeData_RemoveProperty = nullptr;
		pWrapperTable->m_Component_GetObjectResource = nullptr;
		pWrapperTable->m_Component_GetObjectResourceID = nullptr;
		pWrapperTable->m_Component_GetUUID = nullptr;
		pWrapperTable->m_Component_SetUUID = nullptr;
		pWrapperTable->m_Component_HasTransform = nullptr;
		pWrapperTable->m_Component_GetTransform = nullptr;
		pWrapperTable->m_Component_SetTransform = nullptr;
		pWrapperTable->m_ComponentsObject_AddComponent = nullptr;
		pWrapperTable->m_ComponentsObject_GetComponent = nullptr;
		pWrapperTable->m_ComponentsObject_GetComponentCount = nullptr;
		pWrapperTable->m_BeamSet_SetName = nullptr;
		pWrapperTable->m_BeamSet_GetName = nullptr;
		pWrapperTable->m_BeamSet_SetIdentifier = nullptr;
		pWrapperTable->m_BeamSet_GetIdentifier = nullptr;
		pWrapperTable->m_BeamSet_GetReferenceCount = nullptr;
		pWrapperTable->m_BeamSet_SetReferences = nullptr;
		pWrapperTable->m_BeamSet_GetReferences = nullptr;
		pWrapperTable->m_BeamSet_GetBallReferenceCount = nullptr;
		pWrapperTable->m_BeamSet_SetBallReferences = nullptr;
		pWrapperTable->m_BeamSet_GetBallReferences = nullptr;
		pWrapperTable->m_BaseMaterialGroup_GetCount = nullptr;
		pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs = nullptr;
		pWrapperTable->m_BaseMaterialGroup_AddMaterial = nullptr;
		pWrapperTable->m_BaseMaterialGroup_RemoveMaterial = nullptr;
		pWrapperTable->m_BaseMaterialGroup_GetName = nullptr;
		pWrapperTable->m_BaseMaterialGroup_SetName = nullptr;
		pWrapperTable->m_BaseMaterialGroup_SetDisplayColor = nullptr;
		pWrapperTable->m_BaseMaterialGroup_GetDisplayColor = nullptr;
		pWrapperTable->m_ColorGroup_GetCount = nullptr;
		pWrapperTable->m_ColorGroup_GetAllPropertyIDs = nullptr;
		pWrapperTable->m_ColorGroup_AddColor = nullptr;
		pWrapperTable->m_ColorGroup_RemoveColor = nullptr;
		pWrapperTable->m_ColorGroup_SetColor = nullptr;
		pWrapperTable->m_ColorGroup_GetColor = nullptr;
		pWrapperTable->m_Texture2DGroup_GetCount = nullptr;
		pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs = nullptr;
		pWrapperTable->m_Texture2DGroup_AddTex2Coord = nullptr;
		pWrapperTable->m_Texture2DGroup_GetTex2Coord = nullptr;
		pWrapperTable->m_Texture2DGroup_RemoveTex2Coord = nullptr;
		pWrapperTable->m_Texture2DGroup_GetTexture2D = nullptr;
		pWrapperTable->m_CompositeMaterials_GetCount = nullptr;
		pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs = nullptr;
		pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup = nullptr;
		pWrapperTable->m_CompositeMaterials_AddComposite = nullptr;
		pWrapperTable->m_CompositeMaterials_RemoveComposite = nullptr;
		pWrapperTable->m_CompositeMaterials_GetComposite = nullptr;
		pWrapperTable->m_MultiPropertyGroup_GetCount = nullptr;
		pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs = nullptr;
		pWrapperTable->m_MultiPropertyGroup_AddMultiProperty = nullptr;
		pWrapperTable->m_MultiPropertyGroup_SetMultiProperty = nullptr;
		pWrapperTable->m_MultiPropertyGroup_GetMultiProperty = nullptr;
		pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty = nullptr;
		pWrapperTable->m_MultiPropertyGroup_GetLayerCount = nullptr;
		pWrapperTable->m_MultiPropertyGroup_AddLayer = nullptr;
		pWrapperTable->m_MultiPropertyGroup_GetLayer = nullptr;
		pWrapperTable->m_MultiPropertyGroup_RemoveLayer = nullptr;
		pWrapperTable->m_Image3D_GetName = nullptr;
		pWrapperTable->m_Image3D_SetName = nullptr;
		pWrapperTable->m_Image3D_IsImageStack = nullptr;
		pWrapperTable->m_ImageStack_GetRowCount = nullptr;
		pWrapperTable->m_ImageStack_SetRowCount = nullptr;
		pWrapperTable->m_ImageStack_GetColumnCount = nullptr;
		pWrapperTable->m_ImageStack_SetColumnCount = nullptr;
		pWrapperTable->m_ImageStack_GetSheetCount = nullptr;
		pWrapperTable->m_ImageStack_GetSheet = nullptr;
		pWrapperTable->m_ImageStack_SetSheet = nullptr;
		pWrapperTable->m_ImageStack_CreateEmptySheet = nullptr;
		pWrapperTable->m_ImageStack_CreateSheetFromBuffer = nullptr;
		pWrapperTable->m_ImageStack_CreateSheetFromFile = nullptr;
		pWrapperTable->m_Attachment_GetPath = nullptr;
		pWrapperTable->m_Attachment_SetPath = nullptr;
		pWrapperTable->m_Attachment_PackagePart = nullptr;
		pWrapperTable->m_Attachment_GetRelationShipType = nullptr;
		pWrapperTable->m_Attachment_SetRelationShipType = nullptr;
		pWrapperTable->m_Attachment_WriteToFile = nullptr;
		pWrapperTable->m_Attachment_ReadFromFile = nullptr;
		pWrapperTable->m_Attachment_ReadFromCallback = nullptr;
		pWrapperTable->m_Attachment_GetStreamSize = nullptr;
		pWrapperTable->m_Attachment_WriteToBuffer = nullptr;
		pWrapperTable->m_Attachment_ReadFromBuffer = nullptr;
		pWrapperTable->m_Texture2D_GetAttachment = nullptr;
		pWrapperTable->m_Texture2D_SetAttachment = nullptr;
		pWrapperTable->m_Texture2D_GetContentType = nullptr;
		pWrapperTable->m_Texture2D_SetContentType = nullptr;
		pWrapperTable->m_Texture2D_GetTileStyleUV = nullptr;
		pWrapperTable->m_Texture2D_SetTileStyleUV = nullptr;
		pWrapperTable->m_Texture2D_GetFilter = nullptr;
		pWrapperTable->m_Texture2D_SetFilter = nullptr;
		pWrapperTable->m_ImplicitPort_GetIdentifier = nullptr;
		pWrapperTable->m_ImplicitPort_SetIdentifier = nullptr;
		pWrapperTable->m_ImplicitPort_GetDisplayName = nullptr;
		pWrapperTable->m_ImplicitPort_SetDisplayName = nullptr;
		pWrapperTable->m_ImplicitPort_SetType = nullptr;
		pWrapperTable->m_ImplicitPort_GetType = nullptr;
		pWrapperTable->m_ImplicitPort_GetReference = nullptr;
		pWrapperTable->m_ImplicitPort_SetReference = nullptr;
		pWrapperTable->m_Iterator_MoveNext = nullptr;
		pWrapperTable->m_Iterator_MovePrevious = nullptr;
		pWrapperTable->m_Iterator_Count = nullptr;
		pWrapperTable->m_ImplicitPortIterator_GetCurrent = nullptr;
		pWrapperTable->m_ImplicitNode_GetIdentifier = nullptr;
		pWrapperTable->m_ImplicitNode_SetIdentifier = nullptr;
		pWrapperTable->m_ImplicitNode_GetDisplayName = nullptr;
		pWrapperTable->m_ImplicitNode_SetDisplayName = nullptr;
		pWrapperTable->m_ImplicitNode_GetTag = nullptr;
		pWrapperTable->m_ImplicitNode_SetTag = nullptr;
		pWrapperTable->m_ImplicitNode_GetNodeType = nullptr;
		pWrapperTable->m_ImplicitNode_AddInput = nullptr;
		pWrapperTable->m_ImplicitNode_GetInputs = nullptr;
		pWrapperTable->m_ImplicitNode_AddOutput = nullptr;
		pWrapperTable->m_ImplicitNode_GetOutputs = nullptr;
		pWrapperTable->m_ImplicitNode_FindInput = nullptr;
		pWrapperTable->m_ImplicitNode_FindOutput = nullptr;
		pWrapperTable->m_ImplicitNode_AreTypesValid = nullptr;
		pWrapperTable->m_OneInputNode_GetInputA = nullptr;
		pWrapperTable->m_OneInputNode_GetOutputResult = nullptr;
		pWrapperTable->m_ResourceIdNode_SetResource = nullptr;
		pWrapperTable->m_ResourceIdNode_GetResource = nullptr;
		pWrapperTable->m_ResourceIdNode_GetOutputValue = nullptr;
		pWrapperTable->m_TwoInputNode_GetInputB = nullptr;
		pWrapperTable->m_SelectNode_GetInputB = nullptr;
		pWrapperTable->m_SelectNode_GetInputC = nullptr;
		pWrapperTable->m_SelectNode_GetInputD = nullptr;
		pWrapperTable->m_ClampNode_GetInputMin = nullptr;
		pWrapperTable->m_ClampNode_GetInputMax = nullptr;
		pWrapperTable->m_ComposeVectorNode_GetInputX = nullptr;
		pWrapperTable->m_ComposeVectorNode_GetInputY = nullptr;
		pWrapperTable->m_ComposeVectorNode_GetInputZ = nullptr;
		pWrapperTable->m_ComposeVectorNode_GetOutputResult = nullptr;
		pWrapperTable->m_DecomposeVectorNode_GetInputA = nullptr;
		pWrapperTable->m_DecomposeVectorNode_GetOutputX = nullptr;
		pWrapperTable->m_DecomposeVectorNode_GetOutputY = nullptr;
		pWrapperTable->m_DecomposeVectorNode_GetOutputZ = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM00 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM01 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM02 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM03 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM10 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM11 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM12 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM13 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM20 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM21 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM22 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM23 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM30 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM31 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM32 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetInputM33 = nullptr;
		pWrapperTable->m_ComposeMatrixNode_GetOutputResult = nullptr;
		pWrapperTable->m_MatrixFromRowsNode_GetInputA = nullptr;
		pWrapperTable->m_MatrixFromRowsNode_GetInputB = nullptr;
		pWrapperTable->m_MatrixFromRowsNode_GetInputC = nullptr;
		pWrapperTable->m_MatrixFromRowsNode_GetInputD = nullptr;
		pWrapperTable->m_MatrixFromRowsNode_GetOutputResult = nullptr;
		pWrapperTable->m_MatrixFromColumnsNode_GetInputA = nullptr;
		pWrapperTable->m_MatrixFromColumnsNode_GetInputB = nullptr;
		pWrapperTable->m_MatrixFromColumnsNode_GetInputC = nullptr;
		pWrapperTable->m_MatrixFromColumnsNode_GetInputD = nullptr;
		pWrapperTable->m_MatrixFromColumnsNode_GetOutputResult = nullptr;
		pWrapperTable->m_ConstantNode_SetConstant = nullptr;
		pWrapperTable->m_ConstantNode_GetConstant = nullptr;
		pWrapperTable->m_ConstantNode_GetOutputValue = nullptr;
		pWrapperTable->m_ConstVecNode_SetVector = nullptr;
		pWrapperTable->m_ConstVecNode_GetVector = nullptr;
		pWrapperTable->m_ConstVecNode_GetOutputVector = nullptr;
		pWrapperTable->m_ConstMatNode_SetMatrix = nullptr;
		pWrapperTable->m_ConstMatNode_GetMatrix = nullptr;
		pWrapperTable->m_ConstMatNode_GetOutputMatrix = nullptr;
		pWrapperTable->m_MeshNode_GetInputMesh = nullptr;
		pWrapperTable->m_MeshNode_GetInputPos = nullptr;
		pWrapperTable->m_MeshNode_GetOutputDistance = nullptr;
		pWrapperTable->m_UnsignedMeshNode_GetInputMesh = nullptr;
		pWrapperTable->m_UnsignedMeshNode_GetInputPos = nullptr;
		pWrapperTable->m_UnsignedMeshNode_GetOutputDistance = nullptr;
		pWrapperTable->m_BeamLatticeNode_GetInputBeamLattice = nullptr;
		pWrapperTable->m_BeamLatticeNode_GetInputPos = nullptr;
		pWrapperTable->m_BeamLatticeNode_GetOutputDistance = nullptr;
		pWrapperTable->m_BeamLatticeNode_SetAccurateRange = nullptr;
		pWrapperTable->m_BeamLatticeNode_GetAccurateRange = nullptr;
		pWrapperTable->m_FunctionGradientNode_GetInputFunctionID = nullptr;
		pWrapperTable->m_FunctionGradientNode_GetInputPos = nullptr;
		pWrapperTable->m_FunctionGradientNode_GetInputStep = nullptr;
		pWrapperTable->m_FunctionGradientNode_SetScalarOutputName = nullptr;
		pWrapperTable->m_FunctionGradientNode_GetScalarOutputName = nullptr;
		pWrapperTable->m_FunctionGradientNode_SetVectorInputName = nullptr;
		pWrapperTable->m_FunctionGradientNode_GetVectorInputName = nullptr;
		pWrapperTable->m_FunctionGradientNode_GetOutputNormalizedGradient = nullptr;
		pWrapperTable->m_FunctionGradientNode_GetOutputGradient = nullptr;
		pWrapperTable->m_FunctionGradientNode_GetOutputMagnitude = nullptr;
		pWrapperTable->m_NormalizeDistanceNode_GetInputFunctionID = nullptr;
		pWrapperTable->m_NormalizeDistanceNode_GetInputPos = nullptr;
		pWrapperTable->m_NormalizeDistanceNode_GetInputStep = nullptr;
		pWrapperTable->m_NormalizeDistanceNode_SetScalarOutputName = nullptr;
		pWrapperTable->m_NormalizeDistanceNode_GetScalarOutputName = nullptr;
		pWrapperTable->m_NormalizeDistanceNode_SetVectorInputName = nullptr;
		pWrapperTable->m_NormalizeDistanceNode_GetVectorInputName = nullptr;
		pWrapperTable->m_NormalizeDistanceNode_GetOutputResult = nullptr;
		pWrapperTable->m_FunctionCallNode_GetInputFunctionID = nullptr;
		pWrapperTable->m_NodeIterator_GetCurrent = nullptr;
		pWrapperTable->m_Function_GetDisplayName = nullptr;
		pWrapperTable->m_Function_SetDisplayName = nullptr;
		pWrapperTable->m_Function_AddInput = nullptr;
		pWrapperTable->m_Function_GetInputs = nullptr;
		pWrapperTable->m_Function_RemoveInput = nullptr;
		pWrapperTable->m_Function_AddOutput = nullptr;
		pWrapperTable->m_Function_GetOutputs = nullptr;
		pWrapperTable->m_Function_RemoveOutput = nullptr;
		pWrapperTable->m_Function_FindInput = nullptr;
		pWrapperTable->m_Function_FindOutput = nullptr;
		pWrapperTable->m_ImplicitFunction_GetIdentifier = nullptr;
		pWrapperTable->m_ImplicitFunction_SetIdentifier = nullptr;
		pWrapperTable->m_ImplicitFunction_AddNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddSinNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddCosNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddTanNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddArcSinNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddArcCosNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddArcTan2Node = nullptr;
		pWrapperTable->m_ImplicitFunction_AddSinhNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddCoshNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddTanhNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddRoundNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddCeilNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddFloorNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddSignNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddFractNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddAbsNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddExpNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddLogNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddLog2Node = nullptr;
		pWrapperTable->m_ImplicitFunction_AddLog10Node = nullptr;
		pWrapperTable->m_ImplicitFunction_AddLengthNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddTransposeNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddInverseNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddSqrtNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddResourceIdNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddAdditionNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddSubtractionNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddMultiplicationNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddDivisionNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddDotNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddCrossNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddMinNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddMaxNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddFmodNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddPowNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddSelectNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddClampNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddComposeVectorNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddVectorFromScalarNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddDecomposeVectorNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddComposeMatrixNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddConstantNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddConstVecNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddConstMatNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddMeshNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddUnsignedMeshNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddBeamLatticeNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddFunctionGradientNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddNormalizeDistanceNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddFunctionCallNode = nullptr;
		pWrapperTable->m_ImplicitFunction_GetNodes = nullptr;
		pWrapperTable->m_ImplicitFunction_RemoveNode = nullptr;
		pWrapperTable->m_ImplicitFunction_AddLink = nullptr;
		pWrapperTable->m_ImplicitFunction_AddLinkByNames = nullptr;
		pWrapperTable->m_ImplicitFunction_Clear = nullptr;
		pWrapperTable->m_ImplicitFunction_SortNodesTopologically = nullptr;
		pWrapperTable->m_FunctionFromImage3D_GetImage3D = nullptr;
		pWrapperTable->m_FunctionFromImage3D_SetImage3D = nullptr;
		pWrapperTable->m_FunctionFromImage3D_SetFilter = nullptr;
		pWrapperTable->m_FunctionFromImage3D_GetFilter = nullptr;
		pWrapperTable->m_FunctionFromImage3D_SetTileStyles = nullptr;
		pWrapperTable->m_FunctionFromImage3D_GetTileStyles = nullptr;
		pWrapperTable->m_FunctionFromImage3D_GetOffset = nullptr;
		pWrapperTable->m_FunctionFromImage3D_SetOffset = nullptr;
		pWrapperTable->m_FunctionFromImage3D_GetScale = nullptr;
		pWrapperTable->m_FunctionFromImage3D_SetScale = nullptr;
		pWrapperTable->m_BuildItem_GetObjectResource = nullptr;
		pWrapperTable->m_BuildItem_GetUUID = nullptr;
		pWrapperTable->m_BuildItem_SetUUID = nullptr;
		pWrapperTable->m_BuildItem_GetObjectResourceID = nullptr;
		pWrapperTable->m_BuildItem_HasObjectTransform = nullptr;
		pWrapperTable->m_BuildItem_GetObjectTransform = nullptr;
		pWrapperTable->m_BuildItem_SetObjectTransform = nullptr;
		pWrapperTable->m_BuildItem_GetPartNumber = nullptr;
		pWrapperTable->m_BuildItem_SetPartNumber = nullptr;
		pWrapperTable->m_BuildItem_GetMetaDataGroup = nullptr;
		pWrapperTable->m_BuildItem_GetOutbox = nullptr;
		pWrapperTable->m_BuildItemIterator_MoveNext = nullptr;
		pWrapperTable->m_BuildItemIterator_MovePrevious = nullptr;
		pWrapperTable->m_BuildItemIterator_GetCurrent = nullptr;
		pWrapperTable->m_BuildItemIterator_Clone = nullptr;
		pWrapperTable->m_BuildItemIterator_Count = nullptr;
		pWrapperTable->m_Slice_SetVertices = nullptr;
		pWrapperTable->m_Slice_GetVertices = nullptr;
		pWrapperTable->m_Slice_GetVertexCount = nullptr;
		pWrapperTable->m_Slice_AddPolygon = nullptr;
		pWrapperTable->m_Slice_GetPolygonCount = nullptr;
		pWrapperTable->m_Slice_SetPolygonIndices = nullptr;
		pWrapperTable->m_Slice_GetPolygonIndices = nullptr;
		pWrapperTable->m_Slice_GetPolygonIndexCount = nullptr;
		pWrapperTable->m_Slice_GetZTop = nullptr;
		pWrapperTable->m_SliceStack_GetBottomZ = nullptr;
		pWrapperTable->m_SliceStack_GetSliceCount = nullptr;
		pWrapperTable->m_SliceStack_GetSlice = nullptr;
		pWrapperTable->m_SliceStack_AddSlice = nullptr;
		pWrapperTable->m_SliceStack_GetSliceRefCount = nullptr;
		pWrapperTable->m_SliceStack_AddSliceStackReference = nullptr;
		pWrapperTable->m_SliceStack_GetSliceStackReference = nullptr;
		pWrapperTable->m_SliceStack_CollapseSliceReferences = nullptr;
		pWrapperTable->m_SliceStack_SetOwnPath = nullptr;
		pWrapperTable->m_SliceStack_GetOwnPath = nullptr;
		pWrapperTable->m_Consumer_GetConsumerID = nullptr;
		pWrapperTable->m_Consumer_GetKeyID = nullptr;
		pWrapperTable->m_Consumer_GetKeyValue = nullptr;
		pWrapperTable->m_AccessRight_GetConsumer = nullptr;
		pWrapperTable->m_AccessRight_GetWrappingAlgorithm = nullptr;
		pWrapperTable->m_AccessRight_GetMgfAlgorithm = nullptr;
		pWrapperTable->m_AccessRight_GetDigestMethod = nullptr;
		pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm = nullptr;
		pWrapperTable->m_ContentEncryptionParams_GetKey = nullptr;
		pWrapperTable->m_ContentEncryptionParams_GetInitializationVector = nullptr;
		pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag = nullptr;
		pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag = nullptr;
		pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData = nullptr;
		pWrapperTable->m_ContentEncryptionParams_GetDescriptor = nullptr;
		pWrapperTable->m_ContentEncryptionParams_GetKeyUUID = nullptr;
		pWrapperTable->m_ResourceData_GetPath = nullptr;
		pWrapperTable->m_ResourceData_GetEncryptionAlgorithm = nullptr;
		pWrapperTable->m_ResourceData_GetCompression = nullptr;
		pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData = nullptr;
		pWrapperTable->m_ResourceDataGroup_GetKeyUUID = nullptr;
		pWrapperTable->m_ResourceDataGroup_AddAccessRight = nullptr;
		pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer = nullptr;
		pWrapperTable->m_ResourceDataGroup_RemoveAccessRight = nullptr;
		pWrapperTable->m_KeyStore_AddConsumer = nullptr;
		pWrapperTable->m_KeyStore_GetConsumerCount = nullptr;
		pWrapperTable->m_KeyStore_GetConsumer = nullptr;
		pWrapperTable->m_KeyStore_RemoveConsumer = nullptr;
		pWrapperTable->m_KeyStore_FindConsumer = nullptr;
		pWrapperTable->m_KeyStore_GetResourceDataGroupCount = nullptr;
		pWrapperTable->m_KeyStore_AddResourceDataGroup = nullptr;
		pWrapperTable->m_KeyStore_GetResourceDataGroup = nullptr;
		pWrapperTable->m_KeyStore_RemoveResourceDataGroup = nullptr;
		pWrapperTable->m_KeyStore_FindResourceDataGroup = nullptr;
		pWrapperTable->m_KeyStore_AddResourceData = nullptr;
		pWrapperTable->m_KeyStore_RemoveResourceData = nullptr;
		pWrapperTable->m_KeyStore_FindResourceData = nullptr;
		pWrapperTable->m_KeyStore_GetResourceDataCount = nullptr;
		pWrapperTable->m_KeyStore_GetResourceData = nullptr;
		pWrapperTable->m_KeyStore_GetUUID = nullptr;
		pWrapperTable->m_KeyStore_SetUUID = nullptr;
		pWrapperTable->m_Model_RootModelPart = nullptr;
		pWrapperTable->m_Model_FindOrCreatePackagePart = nullptr;
		pWrapperTable->m_Model_SetUnit = nullptr;
		pWrapperTable->m_Model_GetUnit = nullptr;
		pWrapperTable->m_Model_GetLanguage = nullptr;
		pWrapperTable->m_Model_SetLanguage = nullptr;
		pWrapperTable->m_Model_QueryWriter = nullptr;
		pWrapperTable->m_Model_QueryReader = nullptr;
		pWrapperTable->m_Model_GetResourceByID = nullptr;
		pWrapperTable->m_Model_GetTexture2DByID = nullptr;
		pWrapperTable->m_Model_GetPropertyTypeByID = nullptr;
		pWrapperTable->m_Model_GetBaseMaterialGroupByID = nullptr;
		pWrapperTable->m_Model_GetTexture2DGroupByID = nullptr;
		pWrapperTable->m_Model_GetCompositeMaterialsByID = nullptr;
		pWrapperTable->m_Model_GetMultiPropertyGroupByID = nullptr;
		pWrapperTable->m_Model_GetMeshObjectByID = nullptr;
		pWrapperTable->m_Model_GetComponentsObjectByID = nullptr;
		pWrapperTable->m_Model_GetColorGroupByID = nullptr;
		pWrapperTable->m_Model_GetSliceStackByID = nullptr;
		pWrapperTable->m_Model_GetLevelSetByID = nullptr;
		pWrapperTable->m_Model_GetBuildUUID = nullptr;
		pWrapperTable->m_Model_SetBuildUUID = nullptr;
		pWrapperTable->m_Model_GetBuildItems = nullptr;
		pWrapperTable->m_Model_GetOutbox = nullptr;
		pWrapperTable->m_Model_GetResources = nullptr;
		pWrapperTable->m_Model_GetObjects = nullptr;
		pWrapperTable->m_Model_GetMeshObjects = nullptr;
		pWrapperTable->m_Model_GetComponentsObjects = nullptr;
		pWrapperTable->m_Model_GetTexture2Ds = nullptr;
		pWrapperTable->m_Model_GetBaseMaterialGroups = nullptr;
		pWrapperTable->m_Model_GetColorGroups = nullptr;
		pWrapperTable->m_Model_GetTexture2DGroups = nullptr;
		pWrapperTable->m_Model_GetCompositeMaterials = nullptr;
		pWrapperTable->m_Model_GetMultiPropertyGroups = nullptr;
		pWrapperTable->m_Model_GetSliceStacks = nullptr;
		pWrapperTable->m_Model_GetImage3Ds = nullptr;
		pWrapperTable->m_Model_MergeToModel = nullptr;
		pWrapperTable->m_Model_MergeFromModel = nullptr;
		pWrapperTable->m_Model_AddMeshObject = nullptr;
		pWrapperTable->m_Model_AddComponentsObject = nullptr;
		pWrapperTable->m_Model_AddSliceStack = nullptr;
		pWrapperTable->m_Model_AddTexture2DFromAttachment = nullptr;
		pWrapperTable->m_Model_AddBaseMaterialGroup = nullptr;
		pWrapperTable->m_Model_AddColorGroup = nullptr;
		pWrapperTable->m_Model_AddTexture2DGroup = nullptr;
		pWrapperTable->m_Model_AddCompositeMaterials = nullptr;
		pWrapperTable->m_Model_AddMultiPropertyGroup = nullptr;
		pWrapperTable->m_Model_AddImageStack = nullptr;
		pWrapperTable->m_Model_GetImageStackByID = nullptr;
		pWrapperTable->m_Model_AddBuildItem = nullptr;
		pWrapperTable->m_Model_RemoveBuildItem = nullptr;
		pWrapperTable->m_Model_GetMetaDataGroup = nullptr;
		pWrapperTable->m_Model_AddAttachment = nullptr;
		pWrapperTable->m_Model_RemoveAttachment = nullptr;
		pWrapperTable->m_Model_GetAttachment = nullptr;
		pWrapperTable->m_Model_FindAttachment = nullptr;
		pWrapperTable->m_Model_GetAttachmentCount = nullptr;
		pWrapperTable->m_Model_HasPackageThumbnailAttachment = nullptr;
		pWrapperTable->m_Model_CreatePackageThumbnailAttachment = nullptr;
		pWrapperTable->m_Model_GetPackageThumbnailAttachment = nullptr;
		pWrapperTable->m_Model_RemovePackageThumbnailAttachment = nullptr;
		pWrapperTable->m_Model_AddCustomContentType = nullptr;
		pWrapperTable->m_Model_RemoveCustomContentType = nullptr;
		pWrapperTable->m_Model_SetRandomNumberCallback = nullptr;
		pWrapperTable->m_Model_GetKeyStore = nullptr;
		pWrapperTable->m_Model_GetFunctions = nullptr;
		pWrapperTable->m_Model_AddImplicitFunction = nullptr;
		pWrapperTable->m_Model_AddFunctionFromImage3D = nullptr;
		pWrapperTable->m_Model_AddVolumeData = nullptr;
		pWrapperTable->m_Model_AddLevelSet = nullptr;
		pWrapperTable->m_Model_GetLevelSets = nullptr;
		pWrapperTable->m_Model_RemoveResource = nullptr;
		pWrapperTable->m_GetLibraryVersion = nullptr;
		pWrapperTable->m_GetPrereleaseInformation = nullptr;
		pWrapperTable->m_GetBuildInformation = nullptr;
		pWrapperTable->m_GetSpecificationVersion = nullptr;
		pWrapperTable->m_CreateModel = nullptr;
		pWrapperTable->m_Release = nullptr;
		pWrapperTable->m_Acquire = nullptr;
		pWrapperTable->m_SetJournal = nullptr;
		pWrapperTable->m_GetLastError = nullptr;
		pWrapperTable->m_GetSymbolLookupMethod = nullptr;
		pWrapperTable->m_RetrieveProgressMessage = nullptr;
		pWrapperTable->m_RGBAToColor = nullptr;
		pWrapperTable->m_FloatRGBAToColor = nullptr;
		pWrapperTable->m_ColorToRGBA = nullptr;
		pWrapperTable->m_ColorToFloatRGBA = nullptr;
		pWrapperTable->m_GetIdentityTransform = nullptr;
		pWrapperTable->m_GetUniformScaleTransform = nullptr;
		pWrapperTable->m_GetScaleTransform = nullptr;
		pWrapperTable->m_GetTranslationTransform = nullptr;
		
		return LIB3MF_SUCCESS;
	}
	
	inline Lib3MFResult CWrapper::releaseWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable)
	{
		if (pWrapperTable == nullptr)
			return LIB3MF_ERROR_INVALIDPARAM;
		
		if (pWrapperTable->m_LibraryHandle != nullptr) {
		#ifdef _WIN32
			HMODULE hModule = (HMODULE) pWrapperTable->m_LibraryHandle;
			FreeLibrary(hModule);
		#else // _WIN32
			dlclose(pWrapperTable->m_LibraryHandle);
		#endif // _WIN32
			return initWrapperTable(pWrapperTable);
		}
		
		return LIB3MF_SUCCESS;
	}
	
	inline Lib3MFResult CWrapper::loadWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable, const char * pLibraryFileName)
	{
		if (pWrapperTable == nullptr)
			return LIB3MF_ERROR_INVALIDPARAM;
		if (pLibraryFileName == nullptr)
			return LIB3MF_ERROR_INVALIDPARAM;
		
		#ifdef _WIN32
		// Convert filename to UTF16-string
		int nLength = 0;
		while ((pLibraryFileName[nLength] != 0) && (nLength < MAX_PATH))
			nLength++;
		int nBufferSize = nLength * 2 + 2;
		std::vector<wchar_t> wsLibraryFileName(nBufferSize);
		int nResult = MultiByteToWideChar(CP_UTF8, 0, pLibraryFileName, nLength, &wsLibraryFileName[0], nBufferSize);
		if (nResult == 0)
			return LIB3MF_ERROR_COULDNOTLOADLIBRARY;
		
		HMODULE hLibrary = LoadLibraryW(wsLibraryFileName.data());
		if (hLibrary == 0) 
			return LIB3MF_ERROR_COULDNOTLOADLIBRARY;
		#else // _WIN32
		void* hLibrary = dlopen(pLibraryFileName, RTLD_LAZY);
		if (hLibrary == 0) 
			return LIB3MF_ERROR_COULDNOTLOADLIBRARY;
		dlerror();
		#endif // _WIN32
		
		#ifdef _WIN32
		pWrapperTable->m_Base_ClassTypeId = (PLib3MFBase_ClassTypeIdPtr) GetProcAddress(hLibrary, "lib3mf_base_classtypeid");
		#else // _WIN32
		pWrapperTable->m_Base_ClassTypeId = (PLib3MFBase_ClassTypeIdPtr) dlsym(hLibrary, "lib3mf_base_classtypeid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Base_ClassTypeId == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_WriteToFile = (PLib3MFWriter_WriteToFilePtr) GetProcAddress(hLibrary, "lib3mf_writer_writetofile");
		#else // _WIN32
		pWrapperTable->m_Writer_WriteToFile = (PLib3MFWriter_WriteToFilePtr) dlsym(hLibrary, "lib3mf_writer_writetofile");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_WriteToFile == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_GetStreamSize = (PLib3MFWriter_GetStreamSizePtr) GetProcAddress(hLibrary, "lib3mf_writer_getstreamsize");
		#else // _WIN32
		pWrapperTable->m_Writer_GetStreamSize = (PLib3MFWriter_GetStreamSizePtr) dlsym(hLibrary, "lib3mf_writer_getstreamsize");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_GetStreamSize == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_WriteToBuffer = (PLib3MFWriter_WriteToBufferPtr) GetProcAddress(hLibrary, "lib3mf_writer_writetobuffer");
		#else // _WIN32
		pWrapperTable->m_Writer_WriteToBuffer = (PLib3MFWriter_WriteToBufferPtr) dlsym(hLibrary, "lib3mf_writer_writetobuffer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_WriteToBuffer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_WriteToCallback = (PLib3MFWriter_WriteToCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_writetocallback");
		#else // _WIN32
		pWrapperTable->m_Writer_WriteToCallback = (PLib3MFWriter_WriteToCallbackPtr) dlsym(hLibrary, "lib3mf_writer_writetocallback");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_WriteToCallback == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_SetProgressCallback = (PLib3MFWriter_SetProgressCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_setprogresscallback");
		#else // _WIN32
		pWrapperTable->m_Writer_SetProgressCallback = (PLib3MFWriter_SetProgressCallbackPtr) dlsym(hLibrary, "lib3mf_writer_setprogresscallback");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_SetProgressCallback == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_GetDecimalPrecision = (PLib3MFWriter_GetDecimalPrecisionPtr) GetProcAddress(hLibrary, "lib3mf_writer_getdecimalprecision");
		#else // _WIN32
		pWrapperTable->m_Writer_GetDecimalPrecision = (PLib3MFWriter_GetDecimalPrecisionPtr) dlsym(hLibrary, "lib3mf_writer_getdecimalprecision");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_GetDecimalPrecision == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_SetDecimalPrecision = (PLib3MFWriter_SetDecimalPrecisionPtr) GetProcAddress(hLibrary, "lib3mf_writer_setdecimalprecision");
		#else // _WIN32
		pWrapperTable->m_Writer_SetDecimalPrecision = (PLib3MFWriter_SetDecimalPrecisionPtr) dlsym(hLibrary, "lib3mf_writer_setdecimalprecision");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_SetDecimalPrecision == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_SetStrictModeActive = (PLib3MFWriter_SetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_writer_setstrictmodeactive");
		#else // _WIN32
		pWrapperTable->m_Writer_SetStrictModeActive = (PLib3MFWriter_SetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_writer_setstrictmodeactive");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_SetStrictModeActive == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_GetStrictModeActive = (PLib3MFWriter_GetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_writer_getstrictmodeactive");
		#else // _WIN32
		pWrapperTable->m_Writer_GetStrictModeActive = (PLib3MFWriter_GetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_writer_getstrictmodeactive");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_GetStrictModeActive == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_GetWarning = (PLib3MFWriter_GetWarningPtr) GetProcAddress(hLibrary, "lib3mf_writer_getwarning");
		#else // _WIN32
		pWrapperTable->m_Writer_GetWarning = (PLib3MFWriter_GetWarningPtr) dlsym(hLibrary, "lib3mf_writer_getwarning");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_GetWarning == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_GetWarningCount = (PLib3MFWriter_GetWarningCountPtr) GetProcAddress(hLibrary, "lib3mf_writer_getwarningcount");
		#else // _WIN32
		pWrapperTable->m_Writer_GetWarningCount = (PLib3MFWriter_GetWarningCountPtr) dlsym(hLibrary, "lib3mf_writer_getwarningcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_GetWarningCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_AddKeyWrappingCallback = (PLib3MFWriter_AddKeyWrappingCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_addkeywrappingcallback");
		#else // _WIN32
		pWrapperTable->m_Writer_AddKeyWrappingCallback = (PLib3MFWriter_AddKeyWrappingCallbackPtr) dlsym(hLibrary, "lib3mf_writer_addkeywrappingcallback");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_AddKeyWrappingCallback == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Writer_SetContentEncryptionCallback = (PLib3MFWriter_SetContentEncryptionCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_setcontentencryptioncallback");
		#else // _WIN32
		pWrapperTable->m_Writer_SetContentEncryptionCallback = (PLib3MFWriter_SetContentEncryptionCallbackPtr) dlsym(hLibrary, "lib3mf_writer_setcontentencryptioncallback");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Writer_SetContentEncryptionCallback == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_ReadFromFile = (PLib3MFReader_ReadFromFilePtr) GetProcAddress(hLibrary, "lib3mf_reader_readfromfile");
		#else // _WIN32
		pWrapperTable->m_Reader_ReadFromFile = (PLib3MFReader_ReadFromFilePtr) dlsym(hLibrary, "lib3mf_reader_readfromfile");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_ReadFromFile == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_ReadFromBuffer = (PLib3MFReader_ReadFromBufferPtr) GetProcAddress(hLibrary, "lib3mf_reader_readfrombuffer");
		#else // _WIN32
		pWrapperTable->m_Reader_ReadFromBuffer = (PLib3MFReader_ReadFromBufferPtr) dlsym(hLibrary, "lib3mf_reader_readfrombuffer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_ReadFromBuffer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_ReadFromCallback = (PLib3MFReader_ReadFromCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_readfromcallback");
		#else // _WIN32
		pWrapperTable->m_Reader_ReadFromCallback = (PLib3MFReader_ReadFromCallbackPtr) dlsym(hLibrary, "lib3mf_reader_readfromcallback");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_ReadFromCallback == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_SetProgressCallback = (PLib3MFReader_SetProgressCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_setprogresscallback");
		#else // _WIN32
		pWrapperTable->m_Reader_SetProgressCallback = (PLib3MFReader_SetProgressCallbackPtr) dlsym(hLibrary, "lib3mf_reader_setprogresscallback");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_SetProgressCallback == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_AddRelationToRead = (PLib3MFReader_AddRelationToReadPtr) GetProcAddress(hLibrary, "lib3mf_reader_addrelationtoread");
		#else // _WIN32
		pWrapperTable->m_Reader_AddRelationToRead = (PLib3MFReader_AddRelationToReadPtr) dlsym(hLibrary, "lib3mf_reader_addrelationtoread");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_AddRelationToRead == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_RemoveRelationToRead = (PLib3MFReader_RemoveRelationToReadPtr) GetProcAddress(hLibrary, "lib3mf_reader_removerelationtoread");
		#else // _WIN32
		pWrapperTable->m_Reader_RemoveRelationToRead = (PLib3MFReader_RemoveRelationToReadPtr) dlsym(hLibrary, "lib3mf_reader_removerelationtoread");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_RemoveRelationToRead == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_SetStrictModeActive = (PLib3MFReader_SetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_reader_setstrictmodeactive");
		#else // _WIN32
		pWrapperTable->m_Reader_SetStrictModeActive = (PLib3MFReader_SetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_reader_setstrictmodeactive");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_SetStrictModeActive == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_GetStrictModeActive = (PLib3MFReader_GetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_reader_getstrictmodeactive");
		#else // _WIN32
		pWrapperTable->m_Reader_GetStrictModeActive = (PLib3MFReader_GetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_reader_getstrictmodeactive");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_GetStrictModeActive == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_GetWarning = (PLib3MFReader_GetWarningPtr) GetProcAddress(hLibrary, "lib3mf_reader_getwarning");
		#else // _WIN32
		pWrapperTable->m_Reader_GetWarning = (PLib3MFReader_GetWarningPtr) dlsym(hLibrary, "lib3mf_reader_getwarning");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_GetWarning == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_GetWarningCount = (PLib3MFReader_GetWarningCountPtr) GetProcAddress(hLibrary, "lib3mf_reader_getwarningcount");
		#else // _WIN32
		pWrapperTable->m_Reader_GetWarningCount = (PLib3MFReader_GetWarningCountPtr) dlsym(hLibrary, "lib3mf_reader_getwarningcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_GetWarningCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_AddKeyWrappingCallback = (PLib3MFReader_AddKeyWrappingCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_addkeywrappingcallback");
		#else // _WIN32
		pWrapperTable->m_Reader_AddKeyWrappingCallback = (PLib3MFReader_AddKeyWrappingCallbackPtr) dlsym(hLibrary, "lib3mf_reader_addkeywrappingcallback");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_AddKeyWrappingCallback == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Reader_SetContentEncryptionCallback = (PLib3MFReader_SetContentEncryptionCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_setcontentencryptioncallback");
		#else // _WIN32
		pWrapperTable->m_Reader_SetContentEncryptionCallback = (PLib3MFReader_SetContentEncryptionCallbackPtr) dlsym(hLibrary, "lib3mf_reader_setcontentencryptioncallback");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Reader_SetContentEncryptionCallback == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_PackagePart_GetPath = (PLib3MFPackagePart_GetPathPtr) GetProcAddress(hLibrary, "lib3mf_packagepart_getpath");
		#else // _WIN32
		pWrapperTable->m_PackagePart_GetPath = (PLib3MFPackagePart_GetPathPtr) dlsym(hLibrary, "lib3mf_packagepart_getpath");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_PackagePart_GetPath == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_PackagePart_SetPath = (PLib3MFPackagePart_SetPathPtr) GetProcAddress(hLibrary, "lib3mf_packagepart_setpath");
		#else // _WIN32
		pWrapperTable->m_PackagePart_SetPath = (PLib3MFPackagePart_SetPathPtr) dlsym(hLibrary, "lib3mf_packagepart_setpath");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_PackagePart_SetPath == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Resource_GetResourceID = (PLib3MFResource_GetResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_resource_getresourceid");
		#else // _WIN32
		pWrapperTable->m_Resource_GetResourceID = (PLib3MFResource_GetResourceIDPtr) dlsym(hLibrary, "lib3mf_resource_getresourceid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Resource_GetResourceID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Resource_GetUniqueResourceID = (PLib3MFResource_GetUniqueResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_resource_getuniqueresourceid");
		#else // _WIN32
		pWrapperTable->m_Resource_GetUniqueResourceID = (PLib3MFResource_GetUniqueResourceIDPtr) dlsym(hLibrary, "lib3mf_resource_getuniqueresourceid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Resource_GetUniqueResourceID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Resource_PackagePart = (PLib3MFResource_PackagePartPtr) GetProcAddress(hLibrary, "lib3mf_resource_packagepart");
		#else // _WIN32
		pWrapperTable->m_Resource_PackagePart = (PLib3MFResource_PackagePartPtr) dlsym(hLibrary, "lib3mf_resource_packagepart");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Resource_PackagePart == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Resource_SetPackagePart = (PLib3MFResource_SetPackagePartPtr) GetProcAddress(hLibrary, "lib3mf_resource_setpackagepart");
		#else // _WIN32
		pWrapperTable->m_Resource_SetPackagePart = (PLib3MFResource_SetPackagePartPtr) dlsym(hLibrary, "lib3mf_resource_setpackagepart");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Resource_SetPackagePart == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Resource_GetModelResourceID = (PLib3MFResource_GetModelResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_resource_getmodelresourceid");
		#else // _WIN32
		pWrapperTable->m_Resource_GetModelResourceID = (PLib3MFResource_GetModelResourceIDPtr) dlsym(hLibrary, "lib3mf_resource_getmodelresourceid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Resource_GetModelResourceID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceIterator_MoveNext = (PLib3MFResourceIterator_MoveNextPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_movenext");
		#else // _WIN32
		pWrapperTable->m_ResourceIterator_MoveNext = (PLib3MFResourceIterator_MoveNextPtr) dlsym(hLibrary, "lib3mf_resourceiterator_movenext");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceIterator_MoveNext == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceIterator_MovePrevious = (PLib3MFResourceIterator_MovePreviousPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_moveprevious");
		#else // _WIN32
		pWrapperTable->m_ResourceIterator_MovePrevious = (PLib3MFResourceIterator_MovePreviousPtr) dlsym(hLibrary, "lib3mf_resourceiterator_moveprevious");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceIterator_MovePrevious == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceIterator_GetCurrent = (PLib3MFResourceIterator_GetCurrentPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_getcurrent");
		#else // _WIN32
		pWrapperTable->m_ResourceIterator_GetCurrent = (PLib3MFResourceIterator_GetCurrentPtr) dlsym(hLibrary, "lib3mf_resourceiterator_getcurrent");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceIterator_GetCurrent == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceIterator_Clone = (PLib3MFResourceIterator_ClonePtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_clone");
		#else // _WIN32
		pWrapperTable->m_ResourceIterator_Clone = (PLib3MFResourceIterator_ClonePtr) dlsym(hLibrary, "lib3mf_resourceiterator_clone");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceIterator_Clone == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceIterator_Count = (PLib3MFResourceIterator_CountPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_count");
		#else // _WIN32
		pWrapperTable->m_ResourceIterator_Count = (PLib3MFResourceIterator_CountPtr) dlsym(hLibrary, "lib3mf_resourceiterator_count");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceIterator_Count == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack = (PLib3MFSliceStackIterator_GetCurrentSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_slicestackiterator_getcurrentslicestack");
		#else // _WIN32
		pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack = (PLib3MFSliceStackIterator_GetCurrentSliceStackPtr) dlsym(hLibrary, "lib3mf_slicestackiterator_getcurrentslicestack");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ObjectIterator_GetCurrentObject = (PLib3MFObjectIterator_GetCurrentObjectPtr) GetProcAddress(hLibrary, "lib3mf_objectiterator_getcurrentobject");
		#else // _WIN32
		pWrapperTable->m_ObjectIterator_GetCurrentObject = (PLib3MFObjectIterator_GetCurrentObjectPtr) dlsym(hLibrary, "lib3mf_objectiterator_getcurrentobject");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ObjectIterator_GetCurrentObject == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject = (PLib3MFMeshObjectIterator_GetCurrentMeshObjectPtr) GetProcAddress(hLibrary, "lib3mf_meshobjectiterator_getcurrentmeshobject");
		#else // _WIN32
		pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject = (PLib3MFMeshObjectIterator_GetCurrentMeshObjectPtr) dlsym(hLibrary, "lib3mf_meshobjectiterator_getcurrentmeshobject");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject = (PLib3MFComponentsObjectIterator_GetCurrentComponentsObjectPtr) GetProcAddress(hLibrary, "lib3mf_componentsobjectiterator_getcurrentcomponentsobject");
		#else // _WIN32
		pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject = (PLib3MFComponentsObjectIterator_GetCurrentComponentsObjectPtr) dlsym(hLibrary, "lib3mf_componentsobjectiterator_getcurrentcomponentsobject");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D = (PLib3MFTexture2DIterator_GetCurrentTexture2DPtr) GetProcAddress(hLibrary, "lib3mf_texture2diterator_getcurrenttexture2d");
		#else // _WIN32
		pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D = (PLib3MFTexture2DIterator_GetCurrentTexture2DPtr) dlsym(hLibrary, "lib3mf_texture2diterator_getcurrenttexture2d");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup = (PLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup");
		#else // _WIN32
		pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup = (PLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup = (PLib3MFColorGroupIterator_GetCurrentColorGroupPtr) GetProcAddress(hLibrary, "lib3mf_colorgroupiterator_getcurrentcolorgroup");
		#else // _WIN32
		pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup = (PLib3MFColorGroupIterator_GetCurrentColorGroupPtr) dlsym(hLibrary, "lib3mf_colorgroupiterator_getcurrentcolorgroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup = (PLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup");
		#else // _WIN32
		pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup = (PLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupPtr) dlsym(hLibrary, "lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials = (PLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsPtr) GetProcAddress(hLibrary, "lib3mf_compositematerialsiterator_getcurrentcompositematerials");
		#else // _WIN32
		pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials = (PLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsPtr) dlsym(hLibrary, "lib3mf_compositematerialsiterator_getcurrentcompositematerials");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup = (PLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup");
		#else // _WIN32
		pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup = (PLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupPtr) dlsym(hLibrary, "lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Image3DIterator_GetCurrentImage3D = (PLib3MFImage3DIterator_GetCurrentImage3DPtr) GetProcAddress(hLibrary, "lib3mf_image3diterator_getcurrentimage3d");
		#else // _WIN32
		pWrapperTable->m_Image3DIterator_GetCurrentImage3D = (PLib3MFImage3DIterator_GetCurrentImage3DPtr) dlsym(hLibrary, "lib3mf_image3diterator_getcurrentimage3d");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Image3DIterator_GetCurrentImage3D == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionIterator_GetCurrentFunction = (PLib3MFFunctionIterator_GetCurrentFunctionPtr) GetProcAddress(hLibrary, "lib3mf_functioniterator_getcurrentfunction");
		#else // _WIN32
		pWrapperTable->m_FunctionIterator_GetCurrentFunction = (PLib3MFFunctionIterator_GetCurrentFunctionPtr) dlsym(hLibrary, "lib3mf_functioniterator_getcurrentfunction");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionIterator_GetCurrentFunction == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSetIterator_GetCurrentLevelSet = (PLib3MFLevelSetIterator_GetCurrentLevelSetPtr) GetProcAddress(hLibrary, "lib3mf_levelsetiterator_getcurrentlevelset");
		#else // _WIN32
		pWrapperTable->m_LevelSetIterator_GetCurrentLevelSet = (PLib3MFLevelSetIterator_GetCurrentLevelSetPtr) dlsym(hLibrary, "lib3mf_levelsetiterator_getcurrentlevelset");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSetIterator_GetCurrentLevelSet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaData_GetNameSpace = (PLib3MFMetaData_GetNameSpacePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getnamespace");
		#else // _WIN32
		pWrapperTable->m_MetaData_GetNameSpace = (PLib3MFMetaData_GetNameSpacePtr) dlsym(hLibrary, "lib3mf_metadata_getnamespace");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaData_GetNameSpace == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaData_SetNameSpace = (PLib3MFMetaData_SetNameSpacePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setnamespace");
		#else // _WIN32
		pWrapperTable->m_MetaData_SetNameSpace = (PLib3MFMetaData_SetNameSpacePtr) dlsym(hLibrary, "lib3mf_metadata_setnamespace");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaData_SetNameSpace == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaData_GetName = (PLib3MFMetaData_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getname");
		#else // _WIN32
		pWrapperTable->m_MetaData_GetName = (PLib3MFMetaData_GetNamePtr) dlsym(hLibrary, "lib3mf_metadata_getname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaData_GetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaData_SetName = (PLib3MFMetaData_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setname");
		#else // _WIN32
		pWrapperTable->m_MetaData_SetName = (PLib3MFMetaData_SetNamePtr) dlsym(hLibrary, "lib3mf_metadata_setname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaData_SetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaData_GetKey = (PLib3MFMetaData_GetKeyPtr) GetProcAddress(hLibrary, "lib3mf_metadata_getkey");
		#else // _WIN32
		pWrapperTable->m_MetaData_GetKey = (PLib3MFMetaData_GetKeyPtr) dlsym(hLibrary, "lib3mf_metadata_getkey");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaData_GetKey == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaData_GetMustPreserve = (PLib3MFMetaData_GetMustPreservePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getmustpreserve");
		#else // _WIN32
		pWrapperTable->m_MetaData_GetMustPreserve = (PLib3MFMetaData_GetMustPreservePtr) dlsym(hLibrary, "lib3mf_metadata_getmustpreserve");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaData_GetMustPreserve == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaData_SetMustPreserve = (PLib3MFMetaData_SetMustPreservePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setmustpreserve");
		#else // _WIN32
		pWrapperTable->m_MetaData_SetMustPreserve = (PLib3MFMetaData_SetMustPreservePtr) dlsym(hLibrary, "lib3mf_metadata_setmustpreserve");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaData_SetMustPreserve == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaData_GetType = (PLib3MFMetaData_GetTypePtr) GetProcAddress(hLibrary, "lib3mf_metadata_gettype");
		#else // _WIN32
		pWrapperTable->m_MetaData_GetType = (PLib3MFMetaData_GetTypePtr) dlsym(hLibrary, "lib3mf_metadata_gettype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaData_GetType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaData_SetType = (PLib3MFMetaData_SetTypePtr) GetProcAddress(hLibrary, "lib3mf_metadata_settype");
		#else // _WIN32
		pWrapperTable->m_MetaData_SetType = (PLib3MFMetaData_SetTypePtr) dlsym(hLibrary, "lib3mf_metadata_settype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaData_SetType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaData_GetValue = (PLib3MFMetaData_GetValuePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getvalue");
		#else // _WIN32
		pWrapperTable->m_MetaData_GetValue = (PLib3MFMetaData_GetValuePtr) dlsym(hLibrary, "lib3mf_metadata_getvalue");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaData_GetValue == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaData_SetValue = (PLib3MFMetaData_SetValuePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setvalue");
		#else // _WIN32
		pWrapperTable->m_MetaData_SetValue = (PLib3MFMetaData_SetValuePtr) dlsym(hLibrary, "lib3mf_metadata_setvalue");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaData_SetValue == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaDataGroup_GetMetaDataCount = (PLib3MFMetaDataGroup_GetMetaDataCountPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_getmetadatacount");
		#else // _WIN32
		pWrapperTable->m_MetaDataGroup_GetMetaDataCount = (PLib3MFMetaDataGroup_GetMetaDataCountPtr) dlsym(hLibrary, "lib3mf_metadatagroup_getmetadatacount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaDataGroup_GetMetaDataCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaDataGroup_GetMetaData = (PLib3MFMetaDataGroup_GetMetaDataPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_getmetadata");
		#else // _WIN32
		pWrapperTable->m_MetaDataGroup_GetMetaData = (PLib3MFMetaDataGroup_GetMetaDataPtr) dlsym(hLibrary, "lib3mf_metadatagroup_getmetadata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaDataGroup_GetMetaData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaDataGroup_GetMetaDataByKey = (PLib3MFMetaDataGroup_GetMetaDataByKeyPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_getmetadatabykey");
		#else // _WIN32
		pWrapperTable->m_MetaDataGroup_GetMetaDataByKey = (PLib3MFMetaDataGroup_GetMetaDataByKeyPtr) dlsym(hLibrary, "lib3mf_metadatagroup_getmetadatabykey");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaDataGroup_GetMetaDataByKey == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex = (PLib3MFMetaDataGroup_RemoveMetaDataByIndexPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_removemetadatabyindex");
		#else // _WIN32
		pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex = (PLib3MFMetaDataGroup_RemoveMetaDataByIndexPtr) dlsym(hLibrary, "lib3mf_metadatagroup_removemetadatabyindex");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaDataGroup_RemoveMetaData = (PLib3MFMetaDataGroup_RemoveMetaDataPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_removemetadata");
		#else // _WIN32
		pWrapperTable->m_MetaDataGroup_RemoveMetaData = (PLib3MFMetaDataGroup_RemoveMetaDataPtr) dlsym(hLibrary, "lib3mf_metadatagroup_removemetadata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaDataGroup_RemoveMetaData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MetaDataGroup_AddMetaData = (PLib3MFMetaDataGroup_AddMetaDataPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_addmetadata");
		#else // _WIN32
		pWrapperTable->m_MetaDataGroup_AddMetaData = (PLib3MFMetaDataGroup_AddMetaDataPtr) dlsym(hLibrary, "lib3mf_metadatagroup_addmetadata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MetaDataGroup_AddMetaData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_SetName = (PLib3MFTriangleSet_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_setname");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_SetName = (PLib3MFTriangleSet_SetNamePtr) dlsym(hLibrary, "lib3mf_triangleset_setname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_SetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_GetName = (PLib3MFTriangleSet_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_getname");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_GetName = (PLib3MFTriangleSet_GetNamePtr) dlsym(hLibrary, "lib3mf_triangleset_getname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_GetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_SetIdentifier = (PLib3MFTriangleSet_SetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_setidentifier");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_SetIdentifier = (PLib3MFTriangleSet_SetIdentifierPtr) dlsym(hLibrary, "lib3mf_triangleset_setidentifier");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_SetIdentifier == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_GetIdentifier = (PLib3MFTriangleSet_GetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_getidentifier");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_GetIdentifier = (PLib3MFTriangleSet_GetIdentifierPtr) dlsym(hLibrary, "lib3mf_triangleset_getidentifier");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_GetIdentifier == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_AddTriangle = (PLib3MFTriangleSet_AddTrianglePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_addtriangle");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_AddTriangle = (PLib3MFTriangleSet_AddTrianglePtr) dlsym(hLibrary, "lib3mf_triangleset_addtriangle");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_AddTriangle == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_RemoveTriangle = (PLib3MFTriangleSet_RemoveTrianglePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_removetriangle");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_RemoveTriangle = (PLib3MFTriangleSet_RemoveTrianglePtr) dlsym(hLibrary, "lib3mf_triangleset_removetriangle");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_RemoveTriangle == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_Clear = (PLib3MFTriangleSet_ClearPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_clear");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_Clear = (PLib3MFTriangleSet_ClearPtr) dlsym(hLibrary, "lib3mf_triangleset_clear");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_Clear == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_SetTriangleList = (PLib3MFTriangleSet_SetTriangleListPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_settrianglelist");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_SetTriangleList = (PLib3MFTriangleSet_SetTriangleListPtr) dlsym(hLibrary, "lib3mf_triangleset_settrianglelist");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_SetTriangleList == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_GetTriangleList = (PLib3MFTriangleSet_GetTriangleListPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_gettrianglelist");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_GetTriangleList = (PLib3MFTriangleSet_GetTriangleListPtr) dlsym(hLibrary, "lib3mf_triangleset_gettrianglelist");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_GetTriangleList == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_AddTriangleList = (PLib3MFTriangleSet_AddTriangleListPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_addtrianglelist");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_AddTriangleList = (PLib3MFTriangleSet_AddTriangleListPtr) dlsym(hLibrary, "lib3mf_triangleset_addtrianglelist");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_AddTriangleList == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_Merge = (PLib3MFTriangleSet_MergePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_merge");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_Merge = (PLib3MFTriangleSet_MergePtr) dlsym(hLibrary, "lib3mf_triangleset_merge");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_Merge == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_DeleteSet = (PLib3MFTriangleSet_DeleteSetPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_deleteset");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_DeleteSet = (PLib3MFTriangleSet_DeleteSetPtr) dlsym(hLibrary, "lib3mf_triangleset_deleteset");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_DeleteSet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TriangleSet_Duplicate = (PLib3MFTriangleSet_DuplicatePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_duplicate");
		#else // _WIN32
		pWrapperTable->m_TriangleSet_Duplicate = (PLib3MFTriangleSet_DuplicatePtr) dlsym(hLibrary, "lib3mf_triangleset_duplicate");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TriangleSet_Duplicate == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_GetType = (PLib3MFObject_GetTypePtr) GetProcAddress(hLibrary, "lib3mf_object_gettype");
		#else // _WIN32
		pWrapperTable->m_Object_GetType = (PLib3MFObject_GetTypePtr) dlsym(hLibrary, "lib3mf_object_gettype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_GetType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_SetType = (PLib3MFObject_SetTypePtr) GetProcAddress(hLibrary, "lib3mf_object_settype");
		#else // _WIN32
		pWrapperTable->m_Object_SetType = (PLib3MFObject_SetTypePtr) dlsym(hLibrary, "lib3mf_object_settype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_SetType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_GetName = (PLib3MFObject_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_object_getname");
		#else // _WIN32
		pWrapperTable->m_Object_GetName = (PLib3MFObject_GetNamePtr) dlsym(hLibrary, "lib3mf_object_getname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_GetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_SetName = (PLib3MFObject_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_object_setname");
		#else // _WIN32
		pWrapperTable->m_Object_SetName = (PLib3MFObject_SetNamePtr) dlsym(hLibrary, "lib3mf_object_setname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_SetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_GetPartNumber = (PLib3MFObject_GetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_object_getpartnumber");
		#else // _WIN32
		pWrapperTable->m_Object_GetPartNumber = (PLib3MFObject_GetPartNumberPtr) dlsym(hLibrary, "lib3mf_object_getpartnumber");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_GetPartNumber == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_SetPartNumber = (PLib3MFObject_SetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_object_setpartnumber");
		#else // _WIN32
		pWrapperTable->m_Object_SetPartNumber = (PLib3MFObject_SetPartNumberPtr) dlsym(hLibrary, "lib3mf_object_setpartnumber");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_SetPartNumber == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_IsMeshObject = (PLib3MFObject_IsMeshObjectPtr) GetProcAddress(hLibrary, "lib3mf_object_ismeshobject");
		#else // _WIN32
		pWrapperTable->m_Object_IsMeshObject = (PLib3MFObject_IsMeshObjectPtr) dlsym(hLibrary, "lib3mf_object_ismeshobject");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_IsMeshObject == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_IsComponentsObject = (PLib3MFObject_IsComponentsObjectPtr) GetProcAddress(hLibrary, "lib3mf_object_iscomponentsobject");
		#else // _WIN32
		pWrapperTable->m_Object_IsComponentsObject = (PLib3MFObject_IsComponentsObjectPtr) dlsym(hLibrary, "lib3mf_object_iscomponentsobject");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_IsComponentsObject == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_IsLevelSetObject = (PLib3MFObject_IsLevelSetObjectPtr) GetProcAddress(hLibrary, "lib3mf_object_islevelsetobject");
		#else // _WIN32
		pWrapperTable->m_Object_IsLevelSetObject = (PLib3MFObject_IsLevelSetObjectPtr) dlsym(hLibrary, "lib3mf_object_islevelsetobject");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_IsLevelSetObject == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_IsValid = (PLib3MFObject_IsValidPtr) GetProcAddress(hLibrary, "lib3mf_object_isvalid");
		#else // _WIN32
		pWrapperTable->m_Object_IsValid = (PLib3MFObject_IsValidPtr) dlsym(hLibrary, "lib3mf_object_isvalid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_IsValid == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_SetAttachmentAsThumbnail = (PLib3MFObject_SetAttachmentAsThumbnailPtr) GetProcAddress(hLibrary, "lib3mf_object_setattachmentasthumbnail");
		#else // _WIN32
		pWrapperTable->m_Object_SetAttachmentAsThumbnail = (PLib3MFObject_SetAttachmentAsThumbnailPtr) dlsym(hLibrary, "lib3mf_object_setattachmentasthumbnail");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_SetAttachmentAsThumbnail == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_GetThumbnailAttachment = (PLib3MFObject_GetThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_object_getthumbnailattachment");
		#else // _WIN32
		pWrapperTable->m_Object_GetThumbnailAttachment = (PLib3MFObject_GetThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_object_getthumbnailattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_GetThumbnailAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_ClearThumbnailAttachment = (PLib3MFObject_ClearThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_object_clearthumbnailattachment");
		#else // _WIN32
		pWrapperTable->m_Object_ClearThumbnailAttachment = (PLib3MFObject_ClearThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_object_clearthumbnailattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_ClearThumbnailAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_GetOutbox = (PLib3MFObject_GetOutboxPtr) GetProcAddress(hLibrary, "lib3mf_object_getoutbox");
		#else // _WIN32
		pWrapperTable->m_Object_GetOutbox = (PLib3MFObject_GetOutboxPtr) dlsym(hLibrary, "lib3mf_object_getoutbox");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_GetOutbox == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_GetUUID = (PLib3MFObject_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_object_getuuid");
		#else // _WIN32
		pWrapperTable->m_Object_GetUUID = (PLib3MFObject_GetUUIDPtr) dlsym(hLibrary, "lib3mf_object_getuuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_GetUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_SetUUID = (PLib3MFObject_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_object_setuuid");
		#else // _WIN32
		pWrapperTable->m_Object_SetUUID = (PLib3MFObject_SetUUIDPtr) dlsym(hLibrary, "lib3mf_object_setuuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_SetUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_GetMetaDataGroup = (PLib3MFObject_GetMetaDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_object_getmetadatagroup");
		#else // _WIN32
		pWrapperTable->m_Object_GetMetaDataGroup = (PLib3MFObject_GetMetaDataGroupPtr) dlsym(hLibrary, "lib3mf_object_getmetadatagroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_GetMetaDataGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_SetSlicesMeshResolution = (PLib3MFObject_SetSlicesMeshResolutionPtr) GetProcAddress(hLibrary, "lib3mf_object_setslicesmeshresolution");
		#else // _WIN32
		pWrapperTable->m_Object_SetSlicesMeshResolution = (PLib3MFObject_SetSlicesMeshResolutionPtr) dlsym(hLibrary, "lib3mf_object_setslicesmeshresolution");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_SetSlicesMeshResolution == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_GetSlicesMeshResolution = (PLib3MFObject_GetSlicesMeshResolutionPtr) GetProcAddress(hLibrary, "lib3mf_object_getslicesmeshresolution");
		#else // _WIN32
		pWrapperTable->m_Object_GetSlicesMeshResolution = (PLib3MFObject_GetSlicesMeshResolutionPtr) dlsym(hLibrary, "lib3mf_object_getslicesmeshresolution");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_GetSlicesMeshResolution == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_HasSlices = (PLib3MFObject_HasSlicesPtr) GetProcAddress(hLibrary, "lib3mf_object_hasslices");
		#else // _WIN32
		pWrapperTable->m_Object_HasSlices = (PLib3MFObject_HasSlicesPtr) dlsym(hLibrary, "lib3mf_object_hasslices");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_HasSlices == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_ClearSliceStack = (PLib3MFObject_ClearSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_object_clearslicestack");
		#else // _WIN32
		pWrapperTable->m_Object_ClearSliceStack = (PLib3MFObject_ClearSliceStackPtr) dlsym(hLibrary, "lib3mf_object_clearslicestack");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_ClearSliceStack == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_GetSliceStack = (PLib3MFObject_GetSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_object_getslicestack");
		#else // _WIN32
		pWrapperTable->m_Object_GetSliceStack = (PLib3MFObject_GetSliceStackPtr) dlsym(hLibrary, "lib3mf_object_getslicestack");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_GetSliceStack == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Object_AssignSliceStack = (PLib3MFObject_AssignSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_object_assignslicestack");
		#else // _WIN32
		pWrapperTable->m_Object_AssignSliceStack = (PLib3MFObject_AssignSliceStackPtr) dlsym(hLibrary, "lib3mf_object_assignslicestack");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Object_AssignSliceStack == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetVertexCount = (PLib3MFMeshObject_GetVertexCountPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getvertexcount");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetVertexCount = (PLib3MFMeshObject_GetVertexCountPtr) dlsym(hLibrary, "lib3mf_meshobject_getvertexcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetVertexCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetTriangleCount = (PLib3MFMeshObject_GetTriangleCountPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettrianglecount");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetTriangleCount = (PLib3MFMeshObject_GetTriangleCountPtr) dlsym(hLibrary, "lib3mf_meshobject_gettrianglecount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetTriangleCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetVertex = (PLib3MFMeshObject_GetVertexPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getvertex");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetVertex = (PLib3MFMeshObject_GetVertexPtr) dlsym(hLibrary, "lib3mf_meshobject_getvertex");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetVertex == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_SetVertex = (PLib3MFMeshObject_SetVertexPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setvertex");
		#else // _WIN32
		pWrapperTable->m_MeshObject_SetVertex = (PLib3MFMeshObject_SetVertexPtr) dlsym(hLibrary, "lib3mf_meshobject_setvertex");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_SetVertex == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_AddVertex = (PLib3MFMeshObject_AddVertexPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_addvertex");
		#else // _WIN32
		pWrapperTable->m_MeshObject_AddVertex = (PLib3MFMeshObject_AddVertexPtr) dlsym(hLibrary, "lib3mf_meshobject_addvertex");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_AddVertex == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetVertices = (PLib3MFMeshObject_GetVerticesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getvertices");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetVertices = (PLib3MFMeshObject_GetVerticesPtr) dlsym(hLibrary, "lib3mf_meshobject_getvertices");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetVertices == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetTriangle = (PLib3MFMeshObject_GetTrianglePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettriangle");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetTriangle = (PLib3MFMeshObject_GetTrianglePtr) dlsym(hLibrary, "lib3mf_meshobject_gettriangle");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetTriangle == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_SetTriangle = (PLib3MFMeshObject_SetTrianglePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_settriangle");
		#else // _WIN32
		pWrapperTable->m_MeshObject_SetTriangle = (PLib3MFMeshObject_SetTrianglePtr) dlsym(hLibrary, "lib3mf_meshobject_settriangle");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_SetTriangle == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_AddTriangle = (PLib3MFMeshObject_AddTrianglePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_addtriangle");
		#else // _WIN32
		pWrapperTable->m_MeshObject_AddTriangle = (PLib3MFMeshObject_AddTrianglePtr) dlsym(hLibrary, "lib3mf_meshobject_addtriangle");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_AddTriangle == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetTriangleIndices = (PLib3MFMeshObject_GetTriangleIndicesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettriangleindices");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetTriangleIndices = (PLib3MFMeshObject_GetTriangleIndicesPtr) dlsym(hLibrary, "lib3mf_meshobject_gettriangleindices");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetTriangleIndices == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_SetObjectLevelProperty = (PLib3MFMeshObject_SetObjectLevelPropertyPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setobjectlevelproperty");
		#else // _WIN32
		pWrapperTable->m_MeshObject_SetObjectLevelProperty = (PLib3MFMeshObject_SetObjectLevelPropertyPtr) dlsym(hLibrary, "lib3mf_meshobject_setobjectlevelproperty");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_SetObjectLevelProperty == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetObjectLevelProperty = (PLib3MFMeshObject_GetObjectLevelPropertyPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getobjectlevelproperty");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetObjectLevelProperty = (PLib3MFMeshObject_GetObjectLevelPropertyPtr) dlsym(hLibrary, "lib3mf_meshobject_getobjectlevelproperty");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetObjectLevelProperty == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_SetTriangleProperties = (PLib3MFMeshObject_SetTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_settriangleproperties");
		#else // _WIN32
		pWrapperTable->m_MeshObject_SetTriangleProperties = (PLib3MFMeshObject_SetTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_settriangleproperties");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_SetTriangleProperties == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetTriangleProperties = (PLib3MFMeshObject_GetTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettriangleproperties");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetTriangleProperties = (PLib3MFMeshObject_GetTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_gettriangleproperties");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetTriangleProperties == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_SetAllTriangleProperties = (PLib3MFMeshObject_SetAllTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setalltriangleproperties");
		#else // _WIN32
		pWrapperTable->m_MeshObject_SetAllTriangleProperties = (PLib3MFMeshObject_SetAllTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_setalltriangleproperties");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_SetAllTriangleProperties == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetAllTriangleProperties = (PLib3MFMeshObject_GetAllTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getalltriangleproperties");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetAllTriangleProperties = (PLib3MFMeshObject_GetAllTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_getalltriangleproperties");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetAllTriangleProperties == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_ClearAllProperties = (PLib3MFMeshObject_ClearAllPropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_clearallproperties");
		#else // _WIN32
		pWrapperTable->m_MeshObject_ClearAllProperties = (PLib3MFMeshObject_ClearAllPropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_clearallproperties");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_ClearAllProperties == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_SetGeometry = (PLib3MFMeshObject_SetGeometryPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setgeometry");
		#else // _WIN32
		pWrapperTable->m_MeshObject_SetGeometry = (PLib3MFMeshObject_SetGeometryPtr) dlsym(hLibrary, "lib3mf_meshobject_setgeometry");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_SetGeometry == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_IsManifoldAndOriented = (PLib3MFMeshObject_IsManifoldAndOrientedPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_ismanifoldandoriented");
		#else // _WIN32
		pWrapperTable->m_MeshObject_IsManifoldAndOriented = (PLib3MFMeshObject_IsManifoldAndOrientedPtr) dlsym(hLibrary, "lib3mf_meshobject_ismanifoldandoriented");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_IsManifoldAndOriented == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_BeamLattice = (PLib3MFMeshObject_BeamLatticePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_beamlattice");
		#else // _WIN32
		pWrapperTable->m_MeshObject_BeamLattice = (PLib3MFMeshObject_BeamLatticePtr) dlsym(hLibrary, "lib3mf_meshobject_beamlattice");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_BeamLattice == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetVolumeData = (PLib3MFMeshObject_GetVolumeDataPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getvolumedata");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetVolumeData = (PLib3MFMeshObject_GetVolumeDataPtr) dlsym(hLibrary, "lib3mf_meshobject_getvolumedata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetVolumeData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_SetVolumeData = (PLib3MFMeshObject_SetVolumeDataPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setvolumedata");
		#else // _WIN32
		pWrapperTable->m_MeshObject_SetVolumeData = (PLib3MFMeshObject_SetVolumeDataPtr) dlsym(hLibrary, "lib3mf_meshobject_setvolumedata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_SetVolumeData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_AddTriangleSet = (PLib3MFMeshObject_AddTriangleSetPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_addtriangleset");
		#else // _WIN32
		pWrapperTable->m_MeshObject_AddTriangleSet = (PLib3MFMeshObject_AddTriangleSetPtr) dlsym(hLibrary, "lib3mf_meshobject_addtriangleset");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_AddTriangleSet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_HasTriangleSet = (PLib3MFMeshObject_HasTriangleSetPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_hastriangleset");
		#else // _WIN32
		pWrapperTable->m_MeshObject_HasTriangleSet = (PLib3MFMeshObject_HasTriangleSetPtr) dlsym(hLibrary, "lib3mf_meshobject_hastriangleset");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_HasTriangleSet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_FindTriangleSet = (PLib3MFMeshObject_FindTriangleSetPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_findtriangleset");
		#else // _WIN32
		pWrapperTable->m_MeshObject_FindTriangleSet = (PLib3MFMeshObject_FindTriangleSetPtr) dlsym(hLibrary, "lib3mf_meshobject_findtriangleset");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_FindTriangleSet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetTriangleSetCount = (PLib3MFMeshObject_GetTriangleSetCountPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettrianglesetcount");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetTriangleSetCount = (PLib3MFMeshObject_GetTriangleSetCountPtr) dlsym(hLibrary, "lib3mf_meshobject_gettrianglesetcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetTriangleSetCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshObject_GetTriangleSet = (PLib3MFMeshObject_GetTriangleSetPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettriangleset");
		#else // _WIN32
		pWrapperTable->m_MeshObject_GetTriangleSet = (PLib3MFMeshObject_GetTriangleSetPtr) dlsym(hLibrary, "lib3mf_meshobject_gettriangleset");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshObject_GetTriangleSet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_GetFunction = (PLib3MFLevelSet_GetFunctionPtr) GetProcAddress(hLibrary, "lib3mf_levelset_getfunction");
		#else // _WIN32
		pWrapperTable->m_LevelSet_GetFunction = (PLib3MFLevelSet_GetFunctionPtr) dlsym(hLibrary, "lib3mf_levelset_getfunction");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_GetFunction == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_SetFunction = (PLib3MFLevelSet_SetFunctionPtr) GetProcAddress(hLibrary, "lib3mf_levelset_setfunction");
		#else // _WIN32
		pWrapperTable->m_LevelSet_SetFunction = (PLib3MFLevelSet_SetFunctionPtr) dlsym(hLibrary, "lib3mf_levelset_setfunction");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_SetFunction == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_GetTransform = (PLib3MFLevelSet_GetTransformPtr) GetProcAddress(hLibrary, "lib3mf_levelset_gettransform");
		#else // _WIN32
		pWrapperTable->m_LevelSet_GetTransform = (PLib3MFLevelSet_GetTransformPtr) dlsym(hLibrary, "lib3mf_levelset_gettransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_GetTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_SetTransform = (PLib3MFLevelSet_SetTransformPtr) GetProcAddress(hLibrary, "lib3mf_levelset_settransform");
		#else // _WIN32
		pWrapperTable->m_LevelSet_SetTransform = (PLib3MFLevelSet_SetTransformPtr) dlsym(hLibrary, "lib3mf_levelset_settransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_SetTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_GetChannelName = (PLib3MFLevelSet_GetChannelNamePtr) GetProcAddress(hLibrary, "lib3mf_levelset_getchannelname");
		#else // _WIN32
		pWrapperTable->m_LevelSet_GetChannelName = (PLib3MFLevelSet_GetChannelNamePtr) dlsym(hLibrary, "lib3mf_levelset_getchannelname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_GetChannelName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_SetChannelName = (PLib3MFLevelSet_SetChannelNamePtr) GetProcAddress(hLibrary, "lib3mf_levelset_setchannelname");
		#else // _WIN32
		pWrapperTable->m_LevelSet_SetChannelName = (PLib3MFLevelSet_SetChannelNamePtr) dlsym(hLibrary, "lib3mf_levelset_setchannelname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_SetChannelName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_SetMinFeatureSize = (PLib3MFLevelSet_SetMinFeatureSizePtr) GetProcAddress(hLibrary, "lib3mf_levelset_setminfeaturesize");
		#else // _WIN32
		pWrapperTable->m_LevelSet_SetMinFeatureSize = (PLib3MFLevelSet_SetMinFeatureSizePtr) dlsym(hLibrary, "lib3mf_levelset_setminfeaturesize");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_SetMinFeatureSize == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_GetMinFeatureSize = (PLib3MFLevelSet_GetMinFeatureSizePtr) GetProcAddress(hLibrary, "lib3mf_levelset_getminfeaturesize");
		#else // _WIN32
		pWrapperTable->m_LevelSet_GetMinFeatureSize = (PLib3MFLevelSet_GetMinFeatureSizePtr) dlsym(hLibrary, "lib3mf_levelset_getminfeaturesize");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_GetMinFeatureSize == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_SetFallBackValue = (PLib3MFLevelSet_SetFallBackValuePtr) GetProcAddress(hLibrary, "lib3mf_levelset_setfallbackvalue");
		#else // _WIN32
		pWrapperTable->m_LevelSet_SetFallBackValue = (PLib3MFLevelSet_SetFallBackValuePtr) dlsym(hLibrary, "lib3mf_levelset_setfallbackvalue");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_SetFallBackValue == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_GetFallBackValue = (PLib3MFLevelSet_GetFallBackValuePtr) GetProcAddress(hLibrary, "lib3mf_levelset_getfallbackvalue");
		#else // _WIN32
		pWrapperTable->m_LevelSet_GetFallBackValue = (PLib3MFLevelSet_GetFallBackValuePtr) dlsym(hLibrary, "lib3mf_levelset_getfallbackvalue");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_GetFallBackValue == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_SetMeshBBoxOnly = (PLib3MFLevelSet_SetMeshBBoxOnlyPtr) GetProcAddress(hLibrary, "lib3mf_levelset_setmeshbboxonly");
		#else // _WIN32
		pWrapperTable->m_LevelSet_SetMeshBBoxOnly = (PLib3MFLevelSet_SetMeshBBoxOnlyPtr) dlsym(hLibrary, "lib3mf_levelset_setmeshbboxonly");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_SetMeshBBoxOnly == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_GetMeshBBoxOnly = (PLib3MFLevelSet_GetMeshBBoxOnlyPtr) GetProcAddress(hLibrary, "lib3mf_levelset_getmeshbboxonly");
		#else // _WIN32
		pWrapperTable->m_LevelSet_GetMeshBBoxOnly = (PLib3MFLevelSet_GetMeshBBoxOnlyPtr) dlsym(hLibrary, "lib3mf_levelset_getmeshbboxonly");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_GetMeshBBoxOnly == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_SetMesh = (PLib3MFLevelSet_SetMeshPtr) GetProcAddress(hLibrary, "lib3mf_levelset_setmesh");
		#else // _WIN32
		pWrapperTable->m_LevelSet_SetMesh = (PLib3MFLevelSet_SetMeshPtr) dlsym(hLibrary, "lib3mf_levelset_setmesh");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_SetMesh == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_GetMesh = (PLib3MFLevelSet_GetMeshPtr) GetProcAddress(hLibrary, "lib3mf_levelset_getmesh");
		#else // _WIN32
		pWrapperTable->m_LevelSet_GetMesh = (PLib3MFLevelSet_GetMeshPtr) dlsym(hLibrary, "lib3mf_levelset_getmesh");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_GetMesh == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_GetVolumeData = (PLib3MFLevelSet_GetVolumeDataPtr) GetProcAddress(hLibrary, "lib3mf_levelset_getvolumedata");
		#else // _WIN32
		pWrapperTable->m_LevelSet_GetVolumeData = (PLib3MFLevelSet_GetVolumeDataPtr) dlsym(hLibrary, "lib3mf_levelset_getvolumedata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_GetVolumeData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_LevelSet_SetVolumeData = (PLib3MFLevelSet_SetVolumeDataPtr) GetProcAddress(hLibrary, "lib3mf_levelset_setvolumedata");
		#else // _WIN32
		pWrapperTable->m_LevelSet_SetVolumeData = (PLib3MFLevelSet_SetVolumeDataPtr) dlsym(hLibrary, "lib3mf_levelset_setvolumedata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_LevelSet_SetVolumeData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetMinLength = (PLib3MFBeamLattice_GetMinLengthPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getminlength");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetMinLength = (PLib3MFBeamLattice_GetMinLengthPtr) dlsym(hLibrary, "lib3mf_beamlattice_getminlength");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetMinLength == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_SetMinLength = (PLib3MFBeamLattice_SetMinLengthPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setminlength");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_SetMinLength = (PLib3MFBeamLattice_SetMinLengthPtr) dlsym(hLibrary, "lib3mf_beamlattice_setminlength");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_SetMinLength == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetClipping = (PLib3MFBeamLattice_GetClippingPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getclipping");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetClipping = (PLib3MFBeamLattice_GetClippingPtr) dlsym(hLibrary, "lib3mf_beamlattice_getclipping");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetClipping == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_SetClipping = (PLib3MFBeamLattice_SetClippingPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setclipping");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_SetClipping = (PLib3MFBeamLattice_SetClippingPtr) dlsym(hLibrary, "lib3mf_beamlattice_setclipping");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_SetClipping == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetRepresentation = (PLib3MFBeamLattice_GetRepresentationPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getrepresentation");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetRepresentation = (PLib3MFBeamLattice_GetRepresentationPtr) dlsym(hLibrary, "lib3mf_beamlattice_getrepresentation");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetRepresentation == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_SetRepresentation = (PLib3MFBeamLattice_SetRepresentationPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setrepresentation");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_SetRepresentation = (PLib3MFBeamLattice_SetRepresentationPtr) dlsym(hLibrary, "lib3mf_beamlattice_setrepresentation");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_SetRepresentation == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetBallOptions = (PLib3MFBeamLattice_GetBallOptionsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getballoptions");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetBallOptions = (PLib3MFBeamLattice_GetBallOptionsPtr) dlsym(hLibrary, "lib3mf_beamlattice_getballoptions");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetBallOptions == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_SetBallOptions = (PLib3MFBeamLattice_SetBallOptionsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setballoptions");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_SetBallOptions = (PLib3MFBeamLattice_SetBallOptionsPtr) dlsym(hLibrary, "lib3mf_beamlattice_setballoptions");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_SetBallOptions == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetBeamCount = (PLib3MFBeamLattice_GetBeamCountPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeamcount");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetBeamCount = (PLib3MFBeamLattice_GetBeamCountPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeamcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetBeamCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetBeam = (PLib3MFBeamLattice_GetBeamPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeam");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetBeam = (PLib3MFBeamLattice_GetBeamPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeam");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetBeam == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_AddBeam = (PLib3MFBeamLattice_AddBeamPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_addbeam");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_AddBeam = (PLib3MFBeamLattice_AddBeamPtr) dlsym(hLibrary, "lib3mf_beamlattice_addbeam");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_AddBeam == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_SetBeam = (PLib3MFBeamLattice_SetBeamPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setbeam");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_SetBeam = (PLib3MFBeamLattice_SetBeamPtr) dlsym(hLibrary, "lib3mf_beamlattice_setbeam");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_SetBeam == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_SetBeams = (PLib3MFBeamLattice_SetBeamsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setbeams");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_SetBeams = (PLib3MFBeamLattice_SetBeamsPtr) dlsym(hLibrary, "lib3mf_beamlattice_setbeams");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_SetBeams == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetBeams = (PLib3MFBeamLattice_GetBeamsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeams");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetBeams = (PLib3MFBeamLattice_GetBeamsPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeams");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetBeams == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetBallCount = (PLib3MFBeamLattice_GetBallCountPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getballcount");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetBallCount = (PLib3MFBeamLattice_GetBallCountPtr) dlsym(hLibrary, "lib3mf_beamlattice_getballcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetBallCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetBall = (PLib3MFBeamLattice_GetBallPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getball");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetBall = (PLib3MFBeamLattice_GetBallPtr) dlsym(hLibrary, "lib3mf_beamlattice_getball");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetBall == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_AddBall = (PLib3MFBeamLattice_AddBallPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_addball");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_AddBall = (PLib3MFBeamLattice_AddBallPtr) dlsym(hLibrary, "lib3mf_beamlattice_addball");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_AddBall == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_SetBall = (PLib3MFBeamLattice_SetBallPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setball");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_SetBall = (PLib3MFBeamLattice_SetBallPtr) dlsym(hLibrary, "lib3mf_beamlattice_setball");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_SetBall == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_SetBalls = (PLib3MFBeamLattice_SetBallsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setballs");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_SetBalls = (PLib3MFBeamLattice_SetBallsPtr) dlsym(hLibrary, "lib3mf_beamlattice_setballs");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_SetBalls == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetBalls = (PLib3MFBeamLattice_GetBallsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getballs");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetBalls = (PLib3MFBeamLattice_GetBallsPtr) dlsym(hLibrary, "lib3mf_beamlattice_getballs");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetBalls == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetBeamSetCount = (PLib3MFBeamLattice_GetBeamSetCountPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeamsetcount");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetBeamSetCount = (PLib3MFBeamLattice_GetBeamSetCountPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeamsetcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetBeamSetCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_AddBeamSet = (PLib3MFBeamLattice_AddBeamSetPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_addbeamset");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_AddBeamSet = (PLib3MFBeamLattice_AddBeamSetPtr) dlsym(hLibrary, "lib3mf_beamlattice_addbeamset");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_AddBeamSet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLattice_GetBeamSet = (PLib3MFBeamLattice_GetBeamSetPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeamset");
		#else // _WIN32
		pWrapperTable->m_BeamLattice_GetBeamSet = (PLib3MFBeamLattice_GetBeamSetPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeamset");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLattice_GetBeamSet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionReference_GetFunctionResourceID = (PLib3MFFunctionReference_GetFunctionResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_functionreference_getfunctionresourceid");
		#else // _WIN32
		pWrapperTable->m_FunctionReference_GetFunctionResourceID = (PLib3MFFunctionReference_GetFunctionResourceIDPtr) dlsym(hLibrary, "lib3mf_functionreference_getfunctionresourceid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionReference_GetFunctionResourceID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionReference_SetFunctionResourceID = (PLib3MFFunctionReference_SetFunctionResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_functionreference_setfunctionresourceid");
		#else // _WIN32
		pWrapperTable->m_FunctionReference_SetFunctionResourceID = (PLib3MFFunctionReference_SetFunctionResourceIDPtr) dlsym(hLibrary, "lib3mf_functionreference_setfunctionresourceid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionReference_SetFunctionResourceID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionReference_GetTransform = (PLib3MFFunctionReference_GetTransformPtr) GetProcAddress(hLibrary, "lib3mf_functionreference_gettransform");
		#else // _WIN32
		pWrapperTable->m_FunctionReference_GetTransform = (PLib3MFFunctionReference_GetTransformPtr) dlsym(hLibrary, "lib3mf_functionreference_gettransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionReference_GetTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionReference_SetTransform = (PLib3MFFunctionReference_SetTransformPtr) GetProcAddress(hLibrary, "lib3mf_functionreference_settransform");
		#else // _WIN32
		pWrapperTable->m_FunctionReference_SetTransform = (PLib3MFFunctionReference_SetTransformPtr) dlsym(hLibrary, "lib3mf_functionreference_settransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionReference_SetTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionReference_GetChannelName = (PLib3MFFunctionReference_GetChannelNamePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_getchannelname");
		#else // _WIN32
		pWrapperTable->m_FunctionReference_GetChannelName = (PLib3MFFunctionReference_GetChannelNamePtr) dlsym(hLibrary, "lib3mf_functionreference_getchannelname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionReference_GetChannelName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionReference_SetChannelName = (PLib3MFFunctionReference_SetChannelNamePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_setchannelname");
		#else // _WIN32
		pWrapperTable->m_FunctionReference_SetChannelName = (PLib3MFFunctionReference_SetChannelNamePtr) dlsym(hLibrary, "lib3mf_functionreference_setchannelname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionReference_SetChannelName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionReference_SetMinFeatureSize = (PLib3MFFunctionReference_SetMinFeatureSizePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_setminfeaturesize");
		#else // _WIN32
		pWrapperTable->m_FunctionReference_SetMinFeatureSize = (PLib3MFFunctionReference_SetMinFeatureSizePtr) dlsym(hLibrary, "lib3mf_functionreference_setminfeaturesize");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionReference_SetMinFeatureSize == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionReference_GetMinFeatureSize = (PLib3MFFunctionReference_GetMinFeatureSizePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_getminfeaturesize");
		#else // _WIN32
		pWrapperTable->m_FunctionReference_GetMinFeatureSize = (PLib3MFFunctionReference_GetMinFeatureSizePtr) dlsym(hLibrary, "lib3mf_functionreference_getminfeaturesize");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionReference_GetMinFeatureSize == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionReference_SetFallBackValue = (PLib3MFFunctionReference_SetFallBackValuePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_setfallbackvalue");
		#else // _WIN32
		pWrapperTable->m_FunctionReference_SetFallBackValue = (PLib3MFFunctionReference_SetFallBackValuePtr) dlsym(hLibrary, "lib3mf_functionreference_setfallbackvalue");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionReference_SetFallBackValue == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionReference_GetFallBackValue = (PLib3MFFunctionReference_GetFallBackValuePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_getfallbackvalue");
		#else // _WIN32
		pWrapperTable->m_FunctionReference_GetFallBackValue = (PLib3MFFunctionReference_GetFallBackValuePtr) dlsym(hLibrary, "lib3mf_functionreference_getfallbackvalue");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionReference_GetFallBackValue == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup = (PLib3MFVolumeDataComposite_GetBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_getbasematerialgroup");
		#else // _WIN32
		pWrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup = (PLib3MFVolumeDataComposite_GetBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_getbasematerialgroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup = (PLib3MFVolumeDataComposite_SetBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_setbasematerialgroup");
		#else // _WIN32
		pWrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup = (PLib3MFVolumeDataComposite_SetBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_setbasematerialgroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeDataComposite_GetMaterialMappingCount = (PLib3MFVolumeDataComposite_GetMaterialMappingCountPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_getmaterialmappingcount");
		#else // _WIN32
		pWrapperTable->m_VolumeDataComposite_GetMaterialMappingCount = (PLib3MFVolumeDataComposite_GetMaterialMappingCountPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_getmaterialmappingcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeDataComposite_GetMaterialMappingCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeDataComposite_GetMaterialMapping = (PLib3MFVolumeDataComposite_GetMaterialMappingPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_getmaterialmapping");
		#else // _WIN32
		pWrapperTable->m_VolumeDataComposite_GetMaterialMapping = (PLib3MFVolumeDataComposite_GetMaterialMappingPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_getmaterialmapping");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeDataComposite_GetMaterialMapping == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeDataComposite_AddMaterialMapping = (PLib3MFVolumeDataComposite_AddMaterialMappingPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_addmaterialmapping");
		#else // _WIN32
		pWrapperTable->m_VolumeDataComposite_AddMaterialMapping = (PLib3MFVolumeDataComposite_AddMaterialMappingPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_addmaterialmapping");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeDataComposite_AddMaterialMapping == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeDataComposite_RemoveMaterialMapping = (PLib3MFVolumeDataComposite_RemoveMaterialMappingPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_removematerialmapping");
		#else // _WIN32
		pWrapperTable->m_VolumeDataComposite_RemoveMaterialMapping = (PLib3MFVolumeDataComposite_RemoveMaterialMappingPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_removematerialmapping");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeDataComposite_RemoveMaterialMapping == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeDataProperty_GetName = (PLib3MFVolumeDataProperty_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_volumedataproperty_getname");
		#else // _WIN32
		pWrapperTable->m_VolumeDataProperty_GetName = (PLib3MFVolumeDataProperty_GetNamePtr) dlsym(hLibrary, "lib3mf_volumedataproperty_getname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeDataProperty_GetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeDataProperty_SetIsRequired = (PLib3MFVolumeDataProperty_SetIsRequiredPtr) GetProcAddress(hLibrary, "lib3mf_volumedataproperty_setisrequired");
		#else // _WIN32
		pWrapperTable->m_VolumeDataProperty_SetIsRequired = (PLib3MFVolumeDataProperty_SetIsRequiredPtr) dlsym(hLibrary, "lib3mf_volumedataproperty_setisrequired");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeDataProperty_SetIsRequired == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeDataProperty_IsRequired = (PLib3MFVolumeDataProperty_IsRequiredPtr) GetProcAddress(hLibrary, "lib3mf_volumedataproperty_isrequired");
		#else // _WIN32
		pWrapperTable->m_VolumeDataProperty_IsRequired = (PLib3MFVolumeDataProperty_IsRequiredPtr) dlsym(hLibrary, "lib3mf_volumedataproperty_isrequired");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeDataProperty_IsRequired == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeData_GetComposite = (PLib3MFVolumeData_GetCompositePtr) GetProcAddress(hLibrary, "lib3mf_volumedata_getcomposite");
		#else // _WIN32
		pWrapperTable->m_VolumeData_GetComposite = (PLib3MFVolumeData_GetCompositePtr) dlsym(hLibrary, "lib3mf_volumedata_getcomposite");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeData_GetComposite == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeData_CreateNewComposite = (PLib3MFVolumeData_CreateNewCompositePtr) GetProcAddress(hLibrary, "lib3mf_volumedata_createnewcomposite");
		#else // _WIN32
		pWrapperTable->m_VolumeData_CreateNewComposite = (PLib3MFVolumeData_CreateNewCompositePtr) dlsym(hLibrary, "lib3mf_volumedata_createnewcomposite");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeData_CreateNewComposite == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeData_RemoveComposite = (PLib3MFVolumeData_RemoveCompositePtr) GetProcAddress(hLibrary, "lib3mf_volumedata_removecomposite");
		#else // _WIN32
		pWrapperTable->m_VolumeData_RemoveComposite = (PLib3MFVolumeData_RemoveCompositePtr) dlsym(hLibrary, "lib3mf_volumedata_removecomposite");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeData_RemoveComposite == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeData_GetColor = (PLib3MFVolumeData_GetColorPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_getcolor");
		#else // _WIN32
		pWrapperTable->m_VolumeData_GetColor = (PLib3MFVolumeData_GetColorPtr) dlsym(hLibrary, "lib3mf_volumedata_getcolor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeData_GetColor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeData_CreateNewColor = (PLib3MFVolumeData_CreateNewColorPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_createnewcolor");
		#else // _WIN32
		pWrapperTable->m_VolumeData_CreateNewColor = (PLib3MFVolumeData_CreateNewColorPtr) dlsym(hLibrary, "lib3mf_volumedata_createnewcolor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeData_CreateNewColor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeData_RemoveColor = (PLib3MFVolumeData_RemoveColorPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_removecolor");
		#else // _WIN32
		pWrapperTable->m_VolumeData_RemoveColor = (PLib3MFVolumeData_RemoveColorPtr) dlsym(hLibrary, "lib3mf_volumedata_removecolor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeData_RemoveColor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeData_GetPropertyCount = (PLib3MFVolumeData_GetPropertyCountPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_getpropertycount");
		#else // _WIN32
		pWrapperTable->m_VolumeData_GetPropertyCount = (PLib3MFVolumeData_GetPropertyCountPtr) dlsym(hLibrary, "lib3mf_volumedata_getpropertycount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeData_GetPropertyCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeData_GetProperty = (PLib3MFVolumeData_GetPropertyPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_getproperty");
		#else // _WIN32
		pWrapperTable->m_VolumeData_GetProperty = (PLib3MFVolumeData_GetPropertyPtr) dlsym(hLibrary, "lib3mf_volumedata_getproperty");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeData_GetProperty == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeData_AddPropertyFromFunction = (PLib3MFVolumeData_AddPropertyFromFunctionPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_addpropertyfromfunction");
		#else // _WIN32
		pWrapperTable->m_VolumeData_AddPropertyFromFunction = (PLib3MFVolumeData_AddPropertyFromFunctionPtr) dlsym(hLibrary, "lib3mf_volumedata_addpropertyfromfunction");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeData_AddPropertyFromFunction == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_VolumeData_RemoveProperty = (PLib3MFVolumeData_RemovePropertyPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_removeproperty");
		#else // _WIN32
		pWrapperTable->m_VolumeData_RemoveProperty = (PLib3MFVolumeData_RemovePropertyPtr) dlsym(hLibrary, "lib3mf_volumedata_removeproperty");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_VolumeData_RemoveProperty == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Component_GetObjectResource = (PLib3MFComponent_GetObjectResourcePtr) GetProcAddress(hLibrary, "lib3mf_component_getobjectresource");
		#else // _WIN32
		pWrapperTable->m_Component_GetObjectResource = (PLib3MFComponent_GetObjectResourcePtr) dlsym(hLibrary, "lib3mf_component_getobjectresource");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Component_GetObjectResource == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Component_GetObjectResourceID = (PLib3MFComponent_GetObjectResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_component_getobjectresourceid");
		#else // _WIN32
		pWrapperTable->m_Component_GetObjectResourceID = (PLib3MFComponent_GetObjectResourceIDPtr) dlsym(hLibrary, "lib3mf_component_getobjectresourceid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Component_GetObjectResourceID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Component_GetUUID = (PLib3MFComponent_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_component_getuuid");
		#else // _WIN32
		pWrapperTable->m_Component_GetUUID = (PLib3MFComponent_GetUUIDPtr) dlsym(hLibrary, "lib3mf_component_getuuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Component_GetUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Component_SetUUID = (PLib3MFComponent_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_component_setuuid");
		#else // _WIN32
		pWrapperTable->m_Component_SetUUID = (PLib3MFComponent_SetUUIDPtr) dlsym(hLibrary, "lib3mf_component_setuuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Component_SetUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Component_HasTransform = (PLib3MFComponent_HasTransformPtr) GetProcAddress(hLibrary, "lib3mf_component_hastransform");
		#else // _WIN32
		pWrapperTable->m_Component_HasTransform = (PLib3MFComponent_HasTransformPtr) dlsym(hLibrary, "lib3mf_component_hastransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Component_HasTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Component_GetTransform = (PLib3MFComponent_GetTransformPtr) GetProcAddress(hLibrary, "lib3mf_component_gettransform");
		#else // _WIN32
		pWrapperTable->m_Component_GetTransform = (PLib3MFComponent_GetTransformPtr) dlsym(hLibrary, "lib3mf_component_gettransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Component_GetTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Component_SetTransform = (PLib3MFComponent_SetTransformPtr) GetProcAddress(hLibrary, "lib3mf_component_settransform");
		#else // _WIN32
		pWrapperTable->m_Component_SetTransform = (PLib3MFComponent_SetTransformPtr) dlsym(hLibrary, "lib3mf_component_settransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Component_SetTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComponentsObject_AddComponent = (PLib3MFComponentsObject_AddComponentPtr) GetProcAddress(hLibrary, "lib3mf_componentsobject_addcomponent");
		#else // _WIN32
		pWrapperTable->m_ComponentsObject_AddComponent = (PLib3MFComponentsObject_AddComponentPtr) dlsym(hLibrary, "lib3mf_componentsobject_addcomponent");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComponentsObject_AddComponent == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComponentsObject_GetComponent = (PLib3MFComponentsObject_GetComponentPtr) GetProcAddress(hLibrary, "lib3mf_componentsobject_getcomponent");
		#else // _WIN32
		pWrapperTable->m_ComponentsObject_GetComponent = (PLib3MFComponentsObject_GetComponentPtr) dlsym(hLibrary, "lib3mf_componentsobject_getcomponent");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComponentsObject_GetComponent == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComponentsObject_GetComponentCount = (PLib3MFComponentsObject_GetComponentCountPtr) GetProcAddress(hLibrary, "lib3mf_componentsobject_getcomponentcount");
		#else // _WIN32
		pWrapperTable->m_ComponentsObject_GetComponentCount = (PLib3MFComponentsObject_GetComponentCountPtr) dlsym(hLibrary, "lib3mf_componentsobject_getcomponentcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComponentsObject_GetComponentCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamSet_SetName = (PLib3MFBeamSet_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_beamset_setname");
		#else // _WIN32
		pWrapperTable->m_BeamSet_SetName = (PLib3MFBeamSet_SetNamePtr) dlsym(hLibrary, "lib3mf_beamset_setname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamSet_SetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamSet_GetName = (PLib3MFBeamSet_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_beamset_getname");
		#else // _WIN32
		pWrapperTable->m_BeamSet_GetName = (PLib3MFBeamSet_GetNamePtr) dlsym(hLibrary, "lib3mf_beamset_getname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamSet_GetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamSet_SetIdentifier = (PLib3MFBeamSet_SetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_beamset_setidentifier");
		#else // _WIN32
		pWrapperTable->m_BeamSet_SetIdentifier = (PLib3MFBeamSet_SetIdentifierPtr) dlsym(hLibrary, "lib3mf_beamset_setidentifier");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamSet_SetIdentifier == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamSet_GetIdentifier = (PLib3MFBeamSet_GetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getidentifier");
		#else // _WIN32
		pWrapperTable->m_BeamSet_GetIdentifier = (PLib3MFBeamSet_GetIdentifierPtr) dlsym(hLibrary, "lib3mf_beamset_getidentifier");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamSet_GetIdentifier == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamSet_GetReferenceCount = (PLib3MFBeamSet_GetReferenceCountPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getreferencecount");
		#else // _WIN32
		pWrapperTable->m_BeamSet_GetReferenceCount = (PLib3MFBeamSet_GetReferenceCountPtr) dlsym(hLibrary, "lib3mf_beamset_getreferencecount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamSet_GetReferenceCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamSet_SetReferences = (PLib3MFBeamSet_SetReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_setreferences");
		#else // _WIN32
		pWrapperTable->m_BeamSet_SetReferences = (PLib3MFBeamSet_SetReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_setreferences");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamSet_SetReferences == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamSet_GetReferences = (PLib3MFBeamSet_GetReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getreferences");
		#else // _WIN32
		pWrapperTable->m_BeamSet_GetReferences = (PLib3MFBeamSet_GetReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_getreferences");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamSet_GetReferences == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamSet_GetBallReferenceCount = (PLib3MFBeamSet_GetBallReferenceCountPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getballreferencecount");
		#else // _WIN32
		pWrapperTable->m_BeamSet_GetBallReferenceCount = (PLib3MFBeamSet_GetBallReferenceCountPtr) dlsym(hLibrary, "lib3mf_beamset_getballreferencecount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamSet_GetBallReferenceCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamSet_SetBallReferences = (PLib3MFBeamSet_SetBallReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_setballreferences");
		#else // _WIN32
		pWrapperTable->m_BeamSet_SetBallReferences = (PLib3MFBeamSet_SetBallReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_setballreferences");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamSet_SetBallReferences == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamSet_GetBallReferences = (PLib3MFBeamSet_GetBallReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getballreferences");
		#else // _WIN32
		pWrapperTable->m_BeamSet_GetBallReferences = (PLib3MFBeamSet_GetBallReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_getballreferences");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamSet_GetBallReferences == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BaseMaterialGroup_GetCount = (PLib3MFBaseMaterialGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getcount");
		#else // _WIN32
		pWrapperTable->m_BaseMaterialGroup_GetCount = (PLib3MFBaseMaterialGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BaseMaterialGroup_GetCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs = (PLib3MFBaseMaterialGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getallpropertyids");
		#else // _WIN32
		pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs = (PLib3MFBaseMaterialGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getallpropertyids");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BaseMaterialGroup_AddMaterial = (PLib3MFBaseMaterialGroup_AddMaterialPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_addmaterial");
		#else // _WIN32
		pWrapperTable->m_BaseMaterialGroup_AddMaterial = (PLib3MFBaseMaterialGroup_AddMaterialPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_addmaterial");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BaseMaterialGroup_AddMaterial == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BaseMaterialGroup_RemoveMaterial = (PLib3MFBaseMaterialGroup_RemoveMaterialPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_removematerial");
		#else // _WIN32
		pWrapperTable->m_BaseMaterialGroup_RemoveMaterial = (PLib3MFBaseMaterialGroup_RemoveMaterialPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_removematerial");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BaseMaterialGroup_RemoveMaterial == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BaseMaterialGroup_GetName = (PLib3MFBaseMaterialGroup_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getname");
		#else // _WIN32
		pWrapperTable->m_BaseMaterialGroup_GetName = (PLib3MFBaseMaterialGroup_GetNamePtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BaseMaterialGroup_GetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BaseMaterialGroup_SetName = (PLib3MFBaseMaterialGroup_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_setname");
		#else // _WIN32
		pWrapperTable->m_BaseMaterialGroup_SetName = (PLib3MFBaseMaterialGroup_SetNamePtr) dlsym(hLibrary, "lib3mf_basematerialgroup_setname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BaseMaterialGroup_SetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BaseMaterialGroup_SetDisplayColor = (PLib3MFBaseMaterialGroup_SetDisplayColorPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_setdisplaycolor");
		#else // _WIN32
		pWrapperTable->m_BaseMaterialGroup_SetDisplayColor = (PLib3MFBaseMaterialGroup_SetDisplayColorPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_setdisplaycolor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BaseMaterialGroup_SetDisplayColor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BaseMaterialGroup_GetDisplayColor = (PLib3MFBaseMaterialGroup_GetDisplayColorPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getdisplaycolor");
		#else // _WIN32
		pWrapperTable->m_BaseMaterialGroup_GetDisplayColor = (PLib3MFBaseMaterialGroup_GetDisplayColorPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getdisplaycolor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BaseMaterialGroup_GetDisplayColor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ColorGroup_GetCount = (PLib3MFColorGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_getcount");
		#else // _WIN32
		pWrapperTable->m_ColorGroup_GetCount = (PLib3MFColorGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_colorgroup_getcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ColorGroup_GetCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ColorGroup_GetAllPropertyIDs = (PLib3MFColorGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_getallpropertyids");
		#else // _WIN32
		pWrapperTable->m_ColorGroup_GetAllPropertyIDs = (PLib3MFColorGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_colorgroup_getallpropertyids");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ColorGroup_GetAllPropertyIDs == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ColorGroup_AddColor = (PLib3MFColorGroup_AddColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_addcolor");
		#else // _WIN32
		pWrapperTable->m_ColorGroup_AddColor = (PLib3MFColorGroup_AddColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_addcolor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ColorGroup_AddColor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ColorGroup_RemoveColor = (PLib3MFColorGroup_RemoveColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_removecolor");
		#else // _WIN32
		pWrapperTable->m_ColorGroup_RemoveColor = (PLib3MFColorGroup_RemoveColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_removecolor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ColorGroup_RemoveColor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ColorGroup_SetColor = (PLib3MFColorGroup_SetColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_setcolor");
		#else // _WIN32
		pWrapperTable->m_ColorGroup_SetColor = (PLib3MFColorGroup_SetColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_setcolor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ColorGroup_SetColor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ColorGroup_GetColor = (PLib3MFColorGroup_GetColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_getcolor");
		#else // _WIN32
		pWrapperTable->m_ColorGroup_GetColor = (PLib3MFColorGroup_GetColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_getcolor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ColorGroup_GetColor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2DGroup_GetCount = (PLib3MFTexture2DGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_getcount");
		#else // _WIN32
		pWrapperTable->m_Texture2DGroup_GetCount = (PLib3MFTexture2DGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_getcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2DGroup_GetCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs = (PLib3MFTexture2DGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_getallpropertyids");
		#else // _WIN32
		pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs = (PLib3MFTexture2DGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_getallpropertyids");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2DGroup_AddTex2Coord = (PLib3MFTexture2DGroup_AddTex2CoordPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_addtex2coord");
		#else // _WIN32
		pWrapperTable->m_Texture2DGroup_AddTex2Coord = (PLib3MFTexture2DGroup_AddTex2CoordPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_addtex2coord");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2DGroup_AddTex2Coord == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2DGroup_GetTex2Coord = (PLib3MFTexture2DGroup_GetTex2CoordPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_gettex2coord");
		#else // _WIN32
		pWrapperTable->m_Texture2DGroup_GetTex2Coord = (PLib3MFTexture2DGroup_GetTex2CoordPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_gettex2coord");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2DGroup_GetTex2Coord == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2DGroup_RemoveTex2Coord = (PLib3MFTexture2DGroup_RemoveTex2CoordPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_removetex2coord");
		#else // _WIN32
		pWrapperTable->m_Texture2DGroup_RemoveTex2Coord = (PLib3MFTexture2DGroup_RemoveTex2CoordPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_removetex2coord");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2DGroup_RemoveTex2Coord == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2DGroup_GetTexture2D = (PLib3MFTexture2DGroup_GetTexture2DPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_gettexture2d");
		#else // _WIN32
		pWrapperTable->m_Texture2DGroup_GetTexture2D = (PLib3MFTexture2DGroup_GetTexture2DPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_gettexture2d");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2DGroup_GetTexture2D == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_CompositeMaterials_GetCount = (PLib3MFCompositeMaterials_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getcount");
		#else // _WIN32
		pWrapperTable->m_CompositeMaterials_GetCount = (PLib3MFCompositeMaterials_GetCountPtr) dlsym(hLibrary, "lib3mf_compositematerials_getcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_CompositeMaterials_GetCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs = (PLib3MFCompositeMaterials_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getallpropertyids");
		#else // _WIN32
		pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs = (PLib3MFCompositeMaterials_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_compositematerials_getallpropertyids");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup = (PLib3MFCompositeMaterials_GetBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getbasematerialgroup");
		#else // _WIN32
		pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup = (PLib3MFCompositeMaterials_GetBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_compositematerials_getbasematerialgroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_CompositeMaterials_AddComposite = (PLib3MFCompositeMaterials_AddCompositePtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_addcomposite");
		#else // _WIN32
		pWrapperTable->m_CompositeMaterials_AddComposite = (PLib3MFCompositeMaterials_AddCompositePtr) dlsym(hLibrary, "lib3mf_compositematerials_addcomposite");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_CompositeMaterials_AddComposite == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_CompositeMaterials_RemoveComposite = (PLib3MFCompositeMaterials_RemoveCompositePtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_removecomposite");
		#else // _WIN32
		pWrapperTable->m_CompositeMaterials_RemoveComposite = (PLib3MFCompositeMaterials_RemoveCompositePtr) dlsym(hLibrary, "lib3mf_compositematerials_removecomposite");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_CompositeMaterials_RemoveComposite == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_CompositeMaterials_GetComposite = (PLib3MFCompositeMaterials_GetCompositePtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getcomposite");
		#else // _WIN32
		pWrapperTable->m_CompositeMaterials_GetComposite = (PLib3MFCompositeMaterials_GetCompositePtr) dlsym(hLibrary, "lib3mf_compositematerials_getcomposite");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_CompositeMaterials_GetComposite == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MultiPropertyGroup_GetCount = (PLib3MFMultiPropertyGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getcount");
		#else // _WIN32
		pWrapperTable->m_MultiPropertyGroup_GetCount = (PLib3MFMultiPropertyGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MultiPropertyGroup_GetCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs = (PLib3MFMultiPropertyGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getallpropertyids");
		#else // _WIN32
		pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs = (PLib3MFMultiPropertyGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getallpropertyids");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MultiPropertyGroup_AddMultiProperty = (PLib3MFMultiPropertyGroup_AddMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_addmultiproperty");
		#else // _WIN32
		pWrapperTable->m_MultiPropertyGroup_AddMultiProperty = (PLib3MFMultiPropertyGroup_AddMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_addmultiproperty");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MultiPropertyGroup_AddMultiProperty == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MultiPropertyGroup_SetMultiProperty = (PLib3MFMultiPropertyGroup_SetMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_setmultiproperty");
		#else // _WIN32
		pWrapperTable->m_MultiPropertyGroup_SetMultiProperty = (PLib3MFMultiPropertyGroup_SetMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_setmultiproperty");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MultiPropertyGroup_SetMultiProperty == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MultiPropertyGroup_GetMultiProperty = (PLib3MFMultiPropertyGroup_GetMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getmultiproperty");
		#else // _WIN32
		pWrapperTable->m_MultiPropertyGroup_GetMultiProperty = (PLib3MFMultiPropertyGroup_GetMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getmultiproperty");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MultiPropertyGroup_GetMultiProperty == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty = (PLib3MFMultiPropertyGroup_RemoveMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_removemultiproperty");
		#else // _WIN32
		pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty = (PLib3MFMultiPropertyGroup_RemoveMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_removemultiproperty");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MultiPropertyGroup_GetLayerCount = (PLib3MFMultiPropertyGroup_GetLayerCountPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getlayercount");
		#else // _WIN32
		pWrapperTable->m_MultiPropertyGroup_GetLayerCount = (PLib3MFMultiPropertyGroup_GetLayerCountPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getlayercount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MultiPropertyGroup_GetLayerCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MultiPropertyGroup_AddLayer = (PLib3MFMultiPropertyGroup_AddLayerPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_addlayer");
		#else // _WIN32
		pWrapperTable->m_MultiPropertyGroup_AddLayer = (PLib3MFMultiPropertyGroup_AddLayerPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_addlayer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MultiPropertyGroup_AddLayer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MultiPropertyGroup_GetLayer = (PLib3MFMultiPropertyGroup_GetLayerPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getlayer");
		#else // _WIN32
		pWrapperTable->m_MultiPropertyGroup_GetLayer = (PLib3MFMultiPropertyGroup_GetLayerPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getlayer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MultiPropertyGroup_GetLayer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MultiPropertyGroup_RemoveLayer = (PLib3MFMultiPropertyGroup_RemoveLayerPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_removelayer");
		#else // _WIN32
		pWrapperTable->m_MultiPropertyGroup_RemoveLayer = (PLib3MFMultiPropertyGroup_RemoveLayerPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_removelayer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MultiPropertyGroup_RemoveLayer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Image3D_GetName = (PLib3MFImage3D_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_image3d_getname");
		#else // _WIN32
		pWrapperTable->m_Image3D_GetName = (PLib3MFImage3D_GetNamePtr) dlsym(hLibrary, "lib3mf_image3d_getname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Image3D_GetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Image3D_SetName = (PLib3MFImage3D_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_image3d_setname");
		#else // _WIN32
		pWrapperTable->m_Image3D_SetName = (PLib3MFImage3D_SetNamePtr) dlsym(hLibrary, "lib3mf_image3d_setname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Image3D_SetName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Image3D_IsImageStack = (PLib3MFImage3D_IsImageStackPtr) GetProcAddress(hLibrary, "lib3mf_image3d_isimagestack");
		#else // _WIN32
		pWrapperTable->m_Image3D_IsImageStack = (PLib3MFImage3D_IsImageStackPtr) dlsym(hLibrary, "lib3mf_image3d_isimagestack");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Image3D_IsImageStack == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImageStack_GetRowCount = (PLib3MFImageStack_GetRowCountPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_getrowcount");
		#else // _WIN32
		pWrapperTable->m_ImageStack_GetRowCount = (PLib3MFImageStack_GetRowCountPtr) dlsym(hLibrary, "lib3mf_imagestack_getrowcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImageStack_GetRowCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImageStack_SetRowCount = (PLib3MFImageStack_SetRowCountPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_setrowcount");
		#else // _WIN32
		pWrapperTable->m_ImageStack_SetRowCount = (PLib3MFImageStack_SetRowCountPtr) dlsym(hLibrary, "lib3mf_imagestack_setrowcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImageStack_SetRowCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImageStack_GetColumnCount = (PLib3MFImageStack_GetColumnCountPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_getcolumncount");
		#else // _WIN32
		pWrapperTable->m_ImageStack_GetColumnCount = (PLib3MFImageStack_GetColumnCountPtr) dlsym(hLibrary, "lib3mf_imagestack_getcolumncount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImageStack_GetColumnCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImageStack_SetColumnCount = (PLib3MFImageStack_SetColumnCountPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_setcolumncount");
		#else // _WIN32
		pWrapperTable->m_ImageStack_SetColumnCount = (PLib3MFImageStack_SetColumnCountPtr) dlsym(hLibrary, "lib3mf_imagestack_setcolumncount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImageStack_SetColumnCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImageStack_GetSheetCount = (PLib3MFImageStack_GetSheetCountPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_getsheetcount");
		#else // _WIN32
		pWrapperTable->m_ImageStack_GetSheetCount = (PLib3MFImageStack_GetSheetCountPtr) dlsym(hLibrary, "lib3mf_imagestack_getsheetcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImageStack_GetSheetCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImageStack_GetSheet = (PLib3MFImageStack_GetSheetPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_getsheet");
		#else // _WIN32
		pWrapperTable->m_ImageStack_GetSheet = (PLib3MFImageStack_GetSheetPtr) dlsym(hLibrary, "lib3mf_imagestack_getsheet");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImageStack_GetSheet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImageStack_SetSheet = (PLib3MFImageStack_SetSheetPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_setsheet");
		#else // _WIN32
		pWrapperTable->m_ImageStack_SetSheet = (PLib3MFImageStack_SetSheetPtr) dlsym(hLibrary, "lib3mf_imagestack_setsheet");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImageStack_SetSheet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImageStack_CreateEmptySheet = (PLib3MFImageStack_CreateEmptySheetPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_createemptysheet");
		#else // _WIN32
		pWrapperTable->m_ImageStack_CreateEmptySheet = (PLib3MFImageStack_CreateEmptySheetPtr) dlsym(hLibrary, "lib3mf_imagestack_createemptysheet");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImageStack_CreateEmptySheet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImageStack_CreateSheetFromBuffer = (PLib3MFImageStack_CreateSheetFromBufferPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_createsheetfrombuffer");
		#else // _WIN32
		pWrapperTable->m_ImageStack_CreateSheetFromBuffer = (PLib3MFImageStack_CreateSheetFromBufferPtr) dlsym(hLibrary, "lib3mf_imagestack_createsheetfrombuffer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImageStack_CreateSheetFromBuffer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImageStack_CreateSheetFromFile = (PLib3MFImageStack_CreateSheetFromFilePtr) GetProcAddress(hLibrary, "lib3mf_imagestack_createsheetfromfile");
		#else // _WIN32
		pWrapperTable->m_ImageStack_CreateSheetFromFile = (PLib3MFImageStack_CreateSheetFromFilePtr) dlsym(hLibrary, "lib3mf_imagestack_createsheetfromfile");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImageStack_CreateSheetFromFile == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Attachment_GetPath = (PLib3MFAttachment_GetPathPtr) GetProcAddress(hLibrary, "lib3mf_attachment_getpath");
		#else // _WIN32
		pWrapperTable->m_Attachment_GetPath = (PLib3MFAttachment_GetPathPtr) dlsym(hLibrary, "lib3mf_attachment_getpath");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Attachment_GetPath == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Attachment_SetPath = (PLib3MFAttachment_SetPathPtr) GetProcAddress(hLibrary, "lib3mf_attachment_setpath");
		#else // _WIN32
		pWrapperTable->m_Attachment_SetPath = (PLib3MFAttachment_SetPathPtr) dlsym(hLibrary, "lib3mf_attachment_setpath");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Attachment_SetPath == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Attachment_PackagePart = (PLib3MFAttachment_PackagePartPtr) GetProcAddress(hLibrary, "lib3mf_attachment_packagepart");
		#else // _WIN32
		pWrapperTable->m_Attachment_PackagePart = (PLib3MFAttachment_PackagePartPtr) dlsym(hLibrary, "lib3mf_attachment_packagepart");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Attachment_PackagePart == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Attachment_GetRelationShipType = (PLib3MFAttachment_GetRelationShipTypePtr) GetProcAddress(hLibrary, "lib3mf_attachment_getrelationshiptype");
		#else // _WIN32
		pWrapperTable->m_Attachment_GetRelationShipType = (PLib3MFAttachment_GetRelationShipTypePtr) dlsym(hLibrary, "lib3mf_attachment_getrelationshiptype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Attachment_GetRelationShipType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Attachment_SetRelationShipType = (PLib3MFAttachment_SetRelationShipTypePtr) GetProcAddress(hLibrary, "lib3mf_attachment_setrelationshiptype");
		#else // _WIN32
		pWrapperTable->m_Attachment_SetRelationShipType = (PLib3MFAttachment_SetRelationShipTypePtr) dlsym(hLibrary, "lib3mf_attachment_setrelationshiptype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Attachment_SetRelationShipType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Attachment_WriteToFile = (PLib3MFAttachment_WriteToFilePtr) GetProcAddress(hLibrary, "lib3mf_attachment_writetofile");
		#else // _WIN32
		pWrapperTable->m_Attachment_WriteToFile = (PLib3MFAttachment_WriteToFilePtr) dlsym(hLibrary, "lib3mf_attachment_writetofile");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Attachment_WriteToFile == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Attachment_ReadFromFile = (PLib3MFAttachment_ReadFromFilePtr) GetProcAddress(hLibrary, "lib3mf_attachment_readfromfile");
		#else // _WIN32
		pWrapperTable->m_Attachment_ReadFromFile = (PLib3MFAttachment_ReadFromFilePtr) dlsym(hLibrary, "lib3mf_attachment_readfromfile");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Attachment_ReadFromFile == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Attachment_ReadFromCallback = (PLib3MFAttachment_ReadFromCallbackPtr) GetProcAddress(hLibrary, "lib3mf_attachment_readfromcallback");
		#else // _WIN32
		pWrapperTable->m_Attachment_ReadFromCallback = (PLib3MFAttachment_ReadFromCallbackPtr) dlsym(hLibrary, "lib3mf_attachment_readfromcallback");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Attachment_ReadFromCallback == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Attachment_GetStreamSize = (PLib3MFAttachment_GetStreamSizePtr) GetProcAddress(hLibrary, "lib3mf_attachment_getstreamsize");
		#else // _WIN32
		pWrapperTable->m_Attachment_GetStreamSize = (PLib3MFAttachment_GetStreamSizePtr) dlsym(hLibrary, "lib3mf_attachment_getstreamsize");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Attachment_GetStreamSize == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Attachment_WriteToBuffer = (PLib3MFAttachment_WriteToBufferPtr) GetProcAddress(hLibrary, "lib3mf_attachment_writetobuffer");
		#else // _WIN32
		pWrapperTable->m_Attachment_WriteToBuffer = (PLib3MFAttachment_WriteToBufferPtr) dlsym(hLibrary, "lib3mf_attachment_writetobuffer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Attachment_WriteToBuffer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Attachment_ReadFromBuffer = (PLib3MFAttachment_ReadFromBufferPtr) GetProcAddress(hLibrary, "lib3mf_attachment_readfrombuffer");
		#else // _WIN32
		pWrapperTable->m_Attachment_ReadFromBuffer = (PLib3MFAttachment_ReadFromBufferPtr) dlsym(hLibrary, "lib3mf_attachment_readfrombuffer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Attachment_ReadFromBuffer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2D_GetAttachment = (PLib3MFTexture2D_GetAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_getattachment");
		#else // _WIN32
		pWrapperTable->m_Texture2D_GetAttachment = (PLib3MFTexture2D_GetAttachmentPtr) dlsym(hLibrary, "lib3mf_texture2d_getattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2D_GetAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2D_SetAttachment = (PLib3MFTexture2D_SetAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_setattachment");
		#else // _WIN32
		pWrapperTable->m_Texture2D_SetAttachment = (PLib3MFTexture2D_SetAttachmentPtr) dlsym(hLibrary, "lib3mf_texture2d_setattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2D_SetAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2D_GetContentType = (PLib3MFTexture2D_GetContentTypePtr) GetProcAddress(hLibrary, "lib3mf_texture2d_getcontenttype");
		#else // _WIN32
		pWrapperTable->m_Texture2D_GetContentType = (PLib3MFTexture2D_GetContentTypePtr) dlsym(hLibrary, "lib3mf_texture2d_getcontenttype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2D_GetContentType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2D_SetContentType = (PLib3MFTexture2D_SetContentTypePtr) GetProcAddress(hLibrary, "lib3mf_texture2d_setcontenttype");
		#else // _WIN32
		pWrapperTable->m_Texture2D_SetContentType = (PLib3MFTexture2D_SetContentTypePtr) dlsym(hLibrary, "lib3mf_texture2d_setcontenttype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2D_SetContentType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2D_GetTileStyleUV = (PLib3MFTexture2D_GetTileStyleUVPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_gettilestyleuv");
		#else // _WIN32
		pWrapperTable->m_Texture2D_GetTileStyleUV = (PLib3MFTexture2D_GetTileStyleUVPtr) dlsym(hLibrary, "lib3mf_texture2d_gettilestyleuv");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2D_GetTileStyleUV == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2D_SetTileStyleUV = (PLib3MFTexture2D_SetTileStyleUVPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_settilestyleuv");
		#else // _WIN32
		pWrapperTable->m_Texture2D_SetTileStyleUV = (PLib3MFTexture2D_SetTileStyleUVPtr) dlsym(hLibrary, "lib3mf_texture2d_settilestyleuv");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2D_SetTileStyleUV == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2D_GetFilter = (PLib3MFTexture2D_GetFilterPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_getfilter");
		#else // _WIN32
		pWrapperTable->m_Texture2D_GetFilter = (PLib3MFTexture2D_GetFilterPtr) dlsym(hLibrary, "lib3mf_texture2d_getfilter");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2D_GetFilter == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Texture2D_SetFilter = (PLib3MFTexture2D_SetFilterPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_setfilter");
		#else // _WIN32
		pWrapperTable->m_Texture2D_SetFilter = (PLib3MFTexture2D_SetFilterPtr) dlsym(hLibrary, "lib3mf_texture2d_setfilter");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Texture2D_SetFilter == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitPort_GetIdentifier = (PLib3MFImplicitPort_GetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitport_getidentifier");
		#else // _WIN32
		pWrapperTable->m_ImplicitPort_GetIdentifier = (PLib3MFImplicitPort_GetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitport_getidentifier");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitPort_GetIdentifier == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitPort_SetIdentifier = (PLib3MFImplicitPort_SetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitport_setidentifier");
		#else // _WIN32
		pWrapperTable->m_ImplicitPort_SetIdentifier = (PLib3MFImplicitPort_SetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitport_setidentifier");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitPort_SetIdentifier == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitPort_GetDisplayName = (PLib3MFImplicitPort_GetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_getdisplayname");
		#else // _WIN32
		pWrapperTable->m_ImplicitPort_GetDisplayName = (PLib3MFImplicitPort_GetDisplayNamePtr) dlsym(hLibrary, "lib3mf_implicitport_getdisplayname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitPort_GetDisplayName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitPort_SetDisplayName = (PLib3MFImplicitPort_SetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_setdisplayname");
		#else // _WIN32
		pWrapperTable->m_ImplicitPort_SetDisplayName = (PLib3MFImplicitPort_SetDisplayNamePtr) dlsym(hLibrary, "lib3mf_implicitport_setdisplayname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitPort_SetDisplayName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitPort_SetType = (PLib3MFImplicitPort_SetTypePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_settype");
		#else // _WIN32
		pWrapperTable->m_ImplicitPort_SetType = (PLib3MFImplicitPort_SetTypePtr) dlsym(hLibrary, "lib3mf_implicitport_settype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitPort_SetType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitPort_GetType = (PLib3MFImplicitPort_GetTypePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_gettype");
		#else // _WIN32
		pWrapperTable->m_ImplicitPort_GetType = (PLib3MFImplicitPort_GetTypePtr) dlsym(hLibrary, "lib3mf_implicitport_gettype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitPort_GetType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitPort_GetReference = (PLib3MFImplicitPort_GetReferencePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_getreference");
		#else // _WIN32
		pWrapperTable->m_ImplicitPort_GetReference = (PLib3MFImplicitPort_GetReferencePtr) dlsym(hLibrary, "lib3mf_implicitport_getreference");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitPort_GetReference == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitPort_SetReference = (PLib3MFImplicitPort_SetReferencePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_setreference");
		#else // _WIN32
		pWrapperTable->m_ImplicitPort_SetReference = (PLib3MFImplicitPort_SetReferencePtr) dlsym(hLibrary, "lib3mf_implicitport_setreference");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitPort_SetReference == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Iterator_MoveNext = (PLib3MFIterator_MoveNextPtr) GetProcAddress(hLibrary, "lib3mf_iterator_movenext");
		#else // _WIN32
		pWrapperTable->m_Iterator_MoveNext = (PLib3MFIterator_MoveNextPtr) dlsym(hLibrary, "lib3mf_iterator_movenext");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Iterator_MoveNext == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Iterator_MovePrevious = (PLib3MFIterator_MovePreviousPtr) GetProcAddress(hLibrary, "lib3mf_iterator_moveprevious");
		#else // _WIN32
		pWrapperTable->m_Iterator_MovePrevious = (PLib3MFIterator_MovePreviousPtr) dlsym(hLibrary, "lib3mf_iterator_moveprevious");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Iterator_MovePrevious == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Iterator_Count = (PLib3MFIterator_CountPtr) GetProcAddress(hLibrary, "lib3mf_iterator_count");
		#else // _WIN32
		pWrapperTable->m_Iterator_Count = (PLib3MFIterator_CountPtr) dlsym(hLibrary, "lib3mf_iterator_count");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Iterator_Count == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitPortIterator_GetCurrent = (PLib3MFImplicitPortIterator_GetCurrentPtr) GetProcAddress(hLibrary, "lib3mf_implicitportiterator_getcurrent");
		#else // _WIN32
		pWrapperTable->m_ImplicitPortIterator_GetCurrent = (PLib3MFImplicitPortIterator_GetCurrentPtr) dlsym(hLibrary, "lib3mf_implicitportiterator_getcurrent");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitPortIterator_GetCurrent == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_GetIdentifier = (PLib3MFImplicitNode_GetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_getidentifier");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_GetIdentifier = (PLib3MFImplicitNode_GetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitnode_getidentifier");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_GetIdentifier == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_SetIdentifier = (PLib3MFImplicitNode_SetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_setidentifier");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_SetIdentifier = (PLib3MFImplicitNode_SetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitnode_setidentifier");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_SetIdentifier == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_GetDisplayName = (PLib3MFImplicitNode_GetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_getdisplayname");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_GetDisplayName = (PLib3MFImplicitNode_GetDisplayNamePtr) dlsym(hLibrary, "lib3mf_implicitnode_getdisplayname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_GetDisplayName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_SetDisplayName = (PLib3MFImplicitNode_SetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_setdisplayname");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_SetDisplayName = (PLib3MFImplicitNode_SetDisplayNamePtr) dlsym(hLibrary, "lib3mf_implicitnode_setdisplayname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_SetDisplayName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_GetTag = (PLib3MFImplicitNode_GetTagPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_gettag");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_GetTag = (PLib3MFImplicitNode_GetTagPtr) dlsym(hLibrary, "lib3mf_implicitnode_gettag");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_GetTag == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_SetTag = (PLib3MFImplicitNode_SetTagPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_settag");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_SetTag = (PLib3MFImplicitNode_SetTagPtr) dlsym(hLibrary, "lib3mf_implicitnode_settag");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_SetTag == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_GetNodeType = (PLib3MFImplicitNode_GetNodeTypePtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_getnodetype");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_GetNodeType = (PLib3MFImplicitNode_GetNodeTypePtr) dlsym(hLibrary, "lib3mf_implicitnode_getnodetype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_GetNodeType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_AddInput = (PLib3MFImplicitNode_AddInputPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_addinput");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_AddInput = (PLib3MFImplicitNode_AddInputPtr) dlsym(hLibrary, "lib3mf_implicitnode_addinput");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_AddInput == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_GetInputs = (PLib3MFImplicitNode_GetInputsPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_getinputs");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_GetInputs = (PLib3MFImplicitNode_GetInputsPtr) dlsym(hLibrary, "lib3mf_implicitnode_getinputs");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_GetInputs == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_AddOutput = (PLib3MFImplicitNode_AddOutputPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_addoutput");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_AddOutput = (PLib3MFImplicitNode_AddOutputPtr) dlsym(hLibrary, "lib3mf_implicitnode_addoutput");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_AddOutput == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_GetOutputs = (PLib3MFImplicitNode_GetOutputsPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_getoutputs");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_GetOutputs = (PLib3MFImplicitNode_GetOutputsPtr) dlsym(hLibrary, "lib3mf_implicitnode_getoutputs");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_GetOutputs == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_FindInput = (PLib3MFImplicitNode_FindInputPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_findinput");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_FindInput = (PLib3MFImplicitNode_FindInputPtr) dlsym(hLibrary, "lib3mf_implicitnode_findinput");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_FindInput == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_FindOutput = (PLib3MFImplicitNode_FindOutputPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_findoutput");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_FindOutput = (PLib3MFImplicitNode_FindOutputPtr) dlsym(hLibrary, "lib3mf_implicitnode_findoutput");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_FindOutput == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitNode_AreTypesValid = (PLib3MFImplicitNode_AreTypesValidPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_aretypesvalid");
		#else // _WIN32
		pWrapperTable->m_ImplicitNode_AreTypesValid = (PLib3MFImplicitNode_AreTypesValidPtr) dlsym(hLibrary, "lib3mf_implicitnode_aretypesvalid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitNode_AreTypesValid == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_OneInputNode_GetInputA = (PLib3MFOneInputNode_GetInputAPtr) GetProcAddress(hLibrary, "lib3mf_oneinputnode_getinputa");
		#else // _WIN32
		pWrapperTable->m_OneInputNode_GetInputA = (PLib3MFOneInputNode_GetInputAPtr) dlsym(hLibrary, "lib3mf_oneinputnode_getinputa");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_OneInputNode_GetInputA == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_OneInputNode_GetOutputResult = (PLib3MFOneInputNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_oneinputnode_getoutputresult");
		#else // _WIN32
		pWrapperTable->m_OneInputNode_GetOutputResult = (PLib3MFOneInputNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_oneinputnode_getoutputresult");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_OneInputNode_GetOutputResult == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceIdNode_SetResource = (PLib3MFResourceIdNode_SetResourcePtr) GetProcAddress(hLibrary, "lib3mf_resourceidnode_setresource");
		#else // _WIN32
		pWrapperTable->m_ResourceIdNode_SetResource = (PLib3MFResourceIdNode_SetResourcePtr) dlsym(hLibrary, "lib3mf_resourceidnode_setresource");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceIdNode_SetResource == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceIdNode_GetResource = (PLib3MFResourceIdNode_GetResourcePtr) GetProcAddress(hLibrary, "lib3mf_resourceidnode_getresource");
		#else // _WIN32
		pWrapperTable->m_ResourceIdNode_GetResource = (PLib3MFResourceIdNode_GetResourcePtr) dlsym(hLibrary, "lib3mf_resourceidnode_getresource");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceIdNode_GetResource == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceIdNode_GetOutputValue = (PLib3MFResourceIdNode_GetOutputValuePtr) GetProcAddress(hLibrary, "lib3mf_resourceidnode_getoutputvalue");
		#else // _WIN32
		pWrapperTable->m_ResourceIdNode_GetOutputValue = (PLib3MFResourceIdNode_GetOutputValuePtr) dlsym(hLibrary, "lib3mf_resourceidnode_getoutputvalue");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceIdNode_GetOutputValue == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_TwoInputNode_GetInputB = (PLib3MFTwoInputNode_GetInputBPtr) GetProcAddress(hLibrary, "lib3mf_twoinputnode_getinputb");
		#else // _WIN32
		pWrapperTable->m_TwoInputNode_GetInputB = (PLib3MFTwoInputNode_GetInputBPtr) dlsym(hLibrary, "lib3mf_twoinputnode_getinputb");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_TwoInputNode_GetInputB == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SelectNode_GetInputB = (PLib3MFSelectNode_GetInputBPtr) GetProcAddress(hLibrary, "lib3mf_selectnode_getinputb");
		#else // _WIN32
		pWrapperTable->m_SelectNode_GetInputB = (PLib3MFSelectNode_GetInputBPtr) dlsym(hLibrary, "lib3mf_selectnode_getinputb");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SelectNode_GetInputB == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SelectNode_GetInputC = (PLib3MFSelectNode_GetInputCPtr) GetProcAddress(hLibrary, "lib3mf_selectnode_getinputc");
		#else // _WIN32
		pWrapperTable->m_SelectNode_GetInputC = (PLib3MFSelectNode_GetInputCPtr) dlsym(hLibrary, "lib3mf_selectnode_getinputc");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SelectNode_GetInputC == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SelectNode_GetInputD = (PLib3MFSelectNode_GetInputDPtr) GetProcAddress(hLibrary, "lib3mf_selectnode_getinputd");
		#else // _WIN32
		pWrapperTable->m_SelectNode_GetInputD = (PLib3MFSelectNode_GetInputDPtr) dlsym(hLibrary, "lib3mf_selectnode_getinputd");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SelectNode_GetInputD == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ClampNode_GetInputMin = (PLib3MFClampNode_GetInputMinPtr) GetProcAddress(hLibrary, "lib3mf_clampnode_getinputmin");
		#else // _WIN32
		pWrapperTable->m_ClampNode_GetInputMin = (PLib3MFClampNode_GetInputMinPtr) dlsym(hLibrary, "lib3mf_clampnode_getinputmin");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ClampNode_GetInputMin == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ClampNode_GetInputMax = (PLib3MFClampNode_GetInputMaxPtr) GetProcAddress(hLibrary, "lib3mf_clampnode_getinputmax");
		#else // _WIN32
		pWrapperTable->m_ClampNode_GetInputMax = (PLib3MFClampNode_GetInputMaxPtr) dlsym(hLibrary, "lib3mf_clampnode_getinputmax");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ClampNode_GetInputMax == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeVectorNode_GetInputX = (PLib3MFComposeVectorNode_GetInputXPtr) GetProcAddress(hLibrary, "lib3mf_composevectornode_getinputx");
		#else // _WIN32
		pWrapperTable->m_ComposeVectorNode_GetInputX = (PLib3MFComposeVectorNode_GetInputXPtr) dlsym(hLibrary, "lib3mf_composevectornode_getinputx");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeVectorNode_GetInputX == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeVectorNode_GetInputY = (PLib3MFComposeVectorNode_GetInputYPtr) GetProcAddress(hLibrary, "lib3mf_composevectornode_getinputy");
		#else // _WIN32
		pWrapperTable->m_ComposeVectorNode_GetInputY = (PLib3MFComposeVectorNode_GetInputYPtr) dlsym(hLibrary, "lib3mf_composevectornode_getinputy");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeVectorNode_GetInputY == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeVectorNode_GetInputZ = (PLib3MFComposeVectorNode_GetInputZPtr) GetProcAddress(hLibrary, "lib3mf_composevectornode_getinputz");
		#else // _WIN32
		pWrapperTable->m_ComposeVectorNode_GetInputZ = (PLib3MFComposeVectorNode_GetInputZPtr) dlsym(hLibrary, "lib3mf_composevectornode_getinputz");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeVectorNode_GetInputZ == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeVectorNode_GetOutputResult = (PLib3MFComposeVectorNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_composevectornode_getoutputresult");
		#else // _WIN32
		pWrapperTable->m_ComposeVectorNode_GetOutputResult = (PLib3MFComposeVectorNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_composevectornode_getoutputresult");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeVectorNode_GetOutputResult == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_DecomposeVectorNode_GetInputA = (PLib3MFDecomposeVectorNode_GetInputAPtr) GetProcAddress(hLibrary, "lib3mf_decomposevectornode_getinputa");
		#else // _WIN32
		pWrapperTable->m_DecomposeVectorNode_GetInputA = (PLib3MFDecomposeVectorNode_GetInputAPtr) dlsym(hLibrary, "lib3mf_decomposevectornode_getinputa");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_DecomposeVectorNode_GetInputA == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_DecomposeVectorNode_GetOutputX = (PLib3MFDecomposeVectorNode_GetOutputXPtr) GetProcAddress(hLibrary, "lib3mf_decomposevectornode_getoutputx");
		#else // _WIN32
		pWrapperTable->m_DecomposeVectorNode_GetOutputX = (PLib3MFDecomposeVectorNode_GetOutputXPtr) dlsym(hLibrary, "lib3mf_decomposevectornode_getoutputx");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_DecomposeVectorNode_GetOutputX == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_DecomposeVectorNode_GetOutputY = (PLib3MFDecomposeVectorNode_GetOutputYPtr) GetProcAddress(hLibrary, "lib3mf_decomposevectornode_getoutputy");
		#else // _WIN32
		pWrapperTable->m_DecomposeVectorNode_GetOutputY = (PLib3MFDecomposeVectorNode_GetOutputYPtr) dlsym(hLibrary, "lib3mf_decomposevectornode_getoutputy");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_DecomposeVectorNode_GetOutputY == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_DecomposeVectorNode_GetOutputZ = (PLib3MFDecomposeVectorNode_GetOutputZPtr) GetProcAddress(hLibrary, "lib3mf_decomposevectornode_getoutputz");
		#else // _WIN32
		pWrapperTable->m_DecomposeVectorNode_GetOutputZ = (PLib3MFDecomposeVectorNode_GetOutputZPtr) dlsym(hLibrary, "lib3mf_decomposevectornode_getoutputz");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_DecomposeVectorNode_GetOutputZ == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM00 = (PLib3MFComposeMatrixNode_GetInputM00Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm00");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM00 = (PLib3MFComposeMatrixNode_GetInputM00Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm00");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM00 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM01 = (PLib3MFComposeMatrixNode_GetInputM01Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm01");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM01 = (PLib3MFComposeMatrixNode_GetInputM01Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm01");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM01 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM02 = (PLib3MFComposeMatrixNode_GetInputM02Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm02");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM02 = (PLib3MFComposeMatrixNode_GetInputM02Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm02");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM02 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM03 = (PLib3MFComposeMatrixNode_GetInputM03Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm03");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM03 = (PLib3MFComposeMatrixNode_GetInputM03Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm03");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM03 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM10 = (PLib3MFComposeMatrixNode_GetInputM10Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm10");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM10 = (PLib3MFComposeMatrixNode_GetInputM10Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm10");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM10 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM11 = (PLib3MFComposeMatrixNode_GetInputM11Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm11");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM11 = (PLib3MFComposeMatrixNode_GetInputM11Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm11");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM11 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM12 = (PLib3MFComposeMatrixNode_GetInputM12Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm12");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM12 = (PLib3MFComposeMatrixNode_GetInputM12Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm12");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM12 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM13 = (PLib3MFComposeMatrixNode_GetInputM13Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm13");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM13 = (PLib3MFComposeMatrixNode_GetInputM13Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm13");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM13 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM20 = (PLib3MFComposeMatrixNode_GetInputM20Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm20");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM20 = (PLib3MFComposeMatrixNode_GetInputM20Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm20");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM20 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM21 = (PLib3MFComposeMatrixNode_GetInputM21Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm21");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM21 = (PLib3MFComposeMatrixNode_GetInputM21Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm21");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM21 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM22 = (PLib3MFComposeMatrixNode_GetInputM22Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm22");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM22 = (PLib3MFComposeMatrixNode_GetInputM22Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm22");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM22 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM23 = (PLib3MFComposeMatrixNode_GetInputM23Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm23");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM23 = (PLib3MFComposeMatrixNode_GetInputM23Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm23");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM23 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM30 = (PLib3MFComposeMatrixNode_GetInputM30Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm30");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM30 = (PLib3MFComposeMatrixNode_GetInputM30Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm30");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM30 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM31 = (PLib3MFComposeMatrixNode_GetInputM31Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm31");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM31 = (PLib3MFComposeMatrixNode_GetInputM31Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm31");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM31 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM32 = (PLib3MFComposeMatrixNode_GetInputM32Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm32");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM32 = (PLib3MFComposeMatrixNode_GetInputM32Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm32");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM32 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM33 = (PLib3MFComposeMatrixNode_GetInputM33Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm33");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetInputM33 = (PLib3MFComposeMatrixNode_GetInputM33Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm33");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetInputM33 == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetOutputResult = (PLib3MFComposeMatrixNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getoutputresult");
		#else // _WIN32
		pWrapperTable->m_ComposeMatrixNode_GetOutputResult = (PLib3MFComposeMatrixNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_composematrixnode_getoutputresult");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ComposeMatrixNode_GetOutputResult == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MatrixFromRowsNode_GetInputA = (PLib3MFMatrixFromRowsNode_GetInputAPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromrowsnode_getinputa");
		#else // _WIN32
		pWrapperTable->m_MatrixFromRowsNode_GetInputA = (PLib3MFMatrixFromRowsNode_GetInputAPtr) dlsym(hLibrary, "lib3mf_matrixfromrowsnode_getinputa");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MatrixFromRowsNode_GetInputA == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MatrixFromRowsNode_GetInputB = (PLib3MFMatrixFromRowsNode_GetInputBPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromrowsnode_getinputb");
		#else // _WIN32
		pWrapperTable->m_MatrixFromRowsNode_GetInputB = (PLib3MFMatrixFromRowsNode_GetInputBPtr) dlsym(hLibrary, "lib3mf_matrixfromrowsnode_getinputb");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MatrixFromRowsNode_GetInputB == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MatrixFromRowsNode_GetInputC = (PLib3MFMatrixFromRowsNode_GetInputCPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromrowsnode_getinputc");
		#else // _WIN32
		pWrapperTable->m_MatrixFromRowsNode_GetInputC = (PLib3MFMatrixFromRowsNode_GetInputCPtr) dlsym(hLibrary, "lib3mf_matrixfromrowsnode_getinputc");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MatrixFromRowsNode_GetInputC == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MatrixFromRowsNode_GetInputD = (PLib3MFMatrixFromRowsNode_GetInputDPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromrowsnode_getinputd");
		#else // _WIN32
		pWrapperTable->m_MatrixFromRowsNode_GetInputD = (PLib3MFMatrixFromRowsNode_GetInputDPtr) dlsym(hLibrary, "lib3mf_matrixfromrowsnode_getinputd");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MatrixFromRowsNode_GetInputD == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MatrixFromRowsNode_GetOutputResult = (PLib3MFMatrixFromRowsNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromrowsnode_getoutputresult");
		#else // _WIN32
		pWrapperTable->m_MatrixFromRowsNode_GetOutputResult = (PLib3MFMatrixFromRowsNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_matrixfromrowsnode_getoutputresult");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MatrixFromRowsNode_GetOutputResult == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MatrixFromColumnsNode_GetInputA = (PLib3MFMatrixFromColumnsNode_GetInputAPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputa");
		#else // _WIN32
		pWrapperTable->m_MatrixFromColumnsNode_GetInputA = (PLib3MFMatrixFromColumnsNode_GetInputAPtr) dlsym(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputa");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MatrixFromColumnsNode_GetInputA == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MatrixFromColumnsNode_GetInputB = (PLib3MFMatrixFromColumnsNode_GetInputBPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputb");
		#else // _WIN32
		pWrapperTable->m_MatrixFromColumnsNode_GetInputB = (PLib3MFMatrixFromColumnsNode_GetInputBPtr) dlsym(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputb");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MatrixFromColumnsNode_GetInputB == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MatrixFromColumnsNode_GetInputC = (PLib3MFMatrixFromColumnsNode_GetInputCPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputc");
		#else // _WIN32
		pWrapperTable->m_MatrixFromColumnsNode_GetInputC = (PLib3MFMatrixFromColumnsNode_GetInputCPtr) dlsym(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputc");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MatrixFromColumnsNode_GetInputC == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MatrixFromColumnsNode_GetInputD = (PLib3MFMatrixFromColumnsNode_GetInputDPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputd");
		#else // _WIN32
		pWrapperTable->m_MatrixFromColumnsNode_GetInputD = (PLib3MFMatrixFromColumnsNode_GetInputDPtr) dlsym(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputd");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MatrixFromColumnsNode_GetInputD == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MatrixFromColumnsNode_GetOutputResult = (PLib3MFMatrixFromColumnsNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromcolumnsnode_getoutputresult");
		#else // _WIN32
		pWrapperTable->m_MatrixFromColumnsNode_GetOutputResult = (PLib3MFMatrixFromColumnsNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_matrixfromcolumnsnode_getoutputresult");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MatrixFromColumnsNode_GetOutputResult == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ConstantNode_SetConstant = (PLib3MFConstantNode_SetConstantPtr) GetProcAddress(hLibrary, "lib3mf_constantnode_setconstant");
		#else // _WIN32
		pWrapperTable->m_ConstantNode_SetConstant = (PLib3MFConstantNode_SetConstantPtr) dlsym(hLibrary, "lib3mf_constantnode_setconstant");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ConstantNode_SetConstant == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ConstantNode_GetConstant = (PLib3MFConstantNode_GetConstantPtr) GetProcAddress(hLibrary, "lib3mf_constantnode_getconstant");
		#else // _WIN32
		pWrapperTable->m_ConstantNode_GetConstant = (PLib3MFConstantNode_GetConstantPtr) dlsym(hLibrary, "lib3mf_constantnode_getconstant");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ConstantNode_GetConstant == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ConstantNode_GetOutputValue = (PLib3MFConstantNode_GetOutputValuePtr) GetProcAddress(hLibrary, "lib3mf_constantnode_getoutputvalue");
		#else // _WIN32
		pWrapperTable->m_ConstantNode_GetOutputValue = (PLib3MFConstantNode_GetOutputValuePtr) dlsym(hLibrary, "lib3mf_constantnode_getoutputvalue");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ConstantNode_GetOutputValue == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ConstVecNode_SetVector = (PLib3MFConstVecNode_SetVectorPtr) GetProcAddress(hLibrary, "lib3mf_constvecnode_setvector");
		#else // _WIN32
		pWrapperTable->m_ConstVecNode_SetVector = (PLib3MFConstVecNode_SetVectorPtr) dlsym(hLibrary, "lib3mf_constvecnode_setvector");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ConstVecNode_SetVector == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ConstVecNode_GetVector = (PLib3MFConstVecNode_GetVectorPtr) GetProcAddress(hLibrary, "lib3mf_constvecnode_getvector");
		#else // _WIN32
		pWrapperTable->m_ConstVecNode_GetVector = (PLib3MFConstVecNode_GetVectorPtr) dlsym(hLibrary, "lib3mf_constvecnode_getvector");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ConstVecNode_GetVector == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ConstVecNode_GetOutputVector = (PLib3MFConstVecNode_GetOutputVectorPtr) GetProcAddress(hLibrary, "lib3mf_constvecnode_getoutputvector");
		#else // _WIN32
		pWrapperTable->m_ConstVecNode_GetOutputVector = (PLib3MFConstVecNode_GetOutputVectorPtr) dlsym(hLibrary, "lib3mf_constvecnode_getoutputvector");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ConstVecNode_GetOutputVector == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ConstMatNode_SetMatrix = (PLib3MFConstMatNode_SetMatrixPtr) GetProcAddress(hLibrary, "lib3mf_constmatnode_setmatrix");
		#else // _WIN32
		pWrapperTable->m_ConstMatNode_SetMatrix = (PLib3MFConstMatNode_SetMatrixPtr) dlsym(hLibrary, "lib3mf_constmatnode_setmatrix");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ConstMatNode_SetMatrix == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ConstMatNode_GetMatrix = (PLib3MFConstMatNode_GetMatrixPtr) GetProcAddress(hLibrary, "lib3mf_constmatnode_getmatrix");
		#else // _WIN32
		pWrapperTable->m_ConstMatNode_GetMatrix = (PLib3MFConstMatNode_GetMatrixPtr) dlsym(hLibrary, "lib3mf_constmatnode_getmatrix");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ConstMatNode_GetMatrix == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ConstMatNode_GetOutputMatrix = (PLib3MFConstMatNode_GetOutputMatrixPtr) GetProcAddress(hLibrary, "lib3mf_constmatnode_getoutputmatrix");
		#else // _WIN32
		pWrapperTable->m_ConstMatNode_GetOutputMatrix = (PLib3MFConstMatNode_GetOutputMatrixPtr) dlsym(hLibrary, "lib3mf_constmatnode_getoutputmatrix");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ConstMatNode_GetOutputMatrix == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshNode_GetInputMesh = (PLib3MFMeshNode_GetInputMeshPtr) GetProcAddress(hLibrary, "lib3mf_meshnode_getinputmesh");
		#else // _WIN32
		pWrapperTable->m_MeshNode_GetInputMesh = (PLib3MFMeshNode_GetInputMeshPtr) dlsym(hLibrary, "lib3mf_meshnode_getinputmesh");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshNode_GetInputMesh == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshNode_GetInputPos = (PLib3MFMeshNode_GetInputPosPtr) GetProcAddress(hLibrary, "lib3mf_meshnode_getinputpos");
		#else // _WIN32
		pWrapperTable->m_MeshNode_GetInputPos = (PLib3MFMeshNode_GetInputPosPtr) dlsym(hLibrary, "lib3mf_meshnode_getinputpos");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshNode_GetInputPos == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_MeshNode_GetOutputDistance = (PLib3MFMeshNode_GetOutputDistancePtr) GetProcAddress(hLibrary, "lib3mf_meshnode_getoutputdistance");
		#else // _WIN32
		pWrapperTable->m_MeshNode_GetOutputDistance = (PLib3MFMeshNode_GetOutputDistancePtr) dlsym(hLibrary, "lib3mf_meshnode_getoutputdistance");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_MeshNode_GetOutputDistance == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_UnsignedMeshNode_GetInputMesh = (PLib3MFUnsignedMeshNode_GetInputMeshPtr) GetProcAddress(hLibrary, "lib3mf_unsignedmeshnode_getinputmesh");
		#else // _WIN32
		pWrapperTable->m_UnsignedMeshNode_GetInputMesh = (PLib3MFUnsignedMeshNode_GetInputMeshPtr) dlsym(hLibrary, "lib3mf_unsignedmeshnode_getinputmesh");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_UnsignedMeshNode_GetInputMesh == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_UnsignedMeshNode_GetInputPos = (PLib3MFUnsignedMeshNode_GetInputPosPtr) GetProcAddress(hLibrary, "lib3mf_unsignedmeshnode_getinputpos");
		#else // _WIN32
		pWrapperTable->m_UnsignedMeshNode_GetInputPos = (PLib3MFUnsignedMeshNode_GetInputPosPtr) dlsym(hLibrary, "lib3mf_unsignedmeshnode_getinputpos");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_UnsignedMeshNode_GetInputPos == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_UnsignedMeshNode_GetOutputDistance = (PLib3MFUnsignedMeshNode_GetOutputDistancePtr) GetProcAddress(hLibrary, "lib3mf_unsignedmeshnode_getoutputdistance");
		#else // _WIN32
		pWrapperTable->m_UnsignedMeshNode_GetOutputDistance = (PLib3MFUnsignedMeshNode_GetOutputDistancePtr) dlsym(hLibrary, "lib3mf_unsignedmeshnode_getoutputdistance");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_UnsignedMeshNode_GetOutputDistance == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLatticeNode_GetInputBeamLattice = (PLib3MFBeamLatticeNode_GetInputBeamLatticePtr) GetProcAddress(hLibrary, "lib3mf_beamlatticenode_getinputbeamlattice");
		#else // _WIN32
		pWrapperTable->m_BeamLatticeNode_GetInputBeamLattice = (PLib3MFBeamLatticeNode_GetInputBeamLatticePtr) dlsym(hLibrary, "lib3mf_beamlatticenode_getinputbeamlattice");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLatticeNode_GetInputBeamLattice == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLatticeNode_GetInputPos = (PLib3MFBeamLatticeNode_GetInputPosPtr) GetProcAddress(hLibrary, "lib3mf_beamlatticenode_getinputpos");
		#else // _WIN32
		pWrapperTable->m_BeamLatticeNode_GetInputPos = (PLib3MFBeamLatticeNode_GetInputPosPtr) dlsym(hLibrary, "lib3mf_beamlatticenode_getinputpos");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLatticeNode_GetInputPos == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLatticeNode_GetOutputDistance = (PLib3MFBeamLatticeNode_GetOutputDistancePtr) GetProcAddress(hLibrary, "lib3mf_beamlatticenode_getoutputdistance");
		#else // _WIN32
		pWrapperTable->m_BeamLatticeNode_GetOutputDistance = (PLib3MFBeamLatticeNode_GetOutputDistancePtr) dlsym(hLibrary, "lib3mf_beamlatticenode_getoutputdistance");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLatticeNode_GetOutputDistance == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLatticeNode_SetAccurateRange = (PLib3MFBeamLatticeNode_SetAccurateRangePtr) GetProcAddress(hLibrary, "lib3mf_beamlatticenode_setaccuraterange");
		#else // _WIN32
		pWrapperTable->m_BeamLatticeNode_SetAccurateRange = (PLib3MFBeamLatticeNode_SetAccurateRangePtr) dlsym(hLibrary, "lib3mf_beamlatticenode_setaccuraterange");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLatticeNode_SetAccurateRange == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BeamLatticeNode_GetAccurateRange = (PLib3MFBeamLatticeNode_GetAccurateRangePtr) GetProcAddress(hLibrary, "lib3mf_beamlatticenode_getaccuraterange");
		#else // _WIN32
		pWrapperTable->m_BeamLatticeNode_GetAccurateRange = (PLib3MFBeamLatticeNode_GetAccurateRangePtr) dlsym(hLibrary, "lib3mf_beamlatticenode_getaccuraterange");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BeamLatticeNode_GetAccurateRange == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionGradientNode_GetInputFunctionID = (PLib3MFFunctionGradientNode_GetInputFunctionIDPtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getinputfunctionid");
		#else // _WIN32
		pWrapperTable->m_FunctionGradientNode_GetInputFunctionID = (PLib3MFFunctionGradientNode_GetInputFunctionIDPtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getinputfunctionid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionGradientNode_GetInputFunctionID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionGradientNode_GetInputPos = (PLib3MFFunctionGradientNode_GetInputPosPtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getinputpos");
		#else // _WIN32
		pWrapperTable->m_FunctionGradientNode_GetInputPos = (PLib3MFFunctionGradientNode_GetInputPosPtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getinputpos");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionGradientNode_GetInputPos == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionGradientNode_GetInputStep = (PLib3MFFunctionGradientNode_GetInputStepPtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getinputstep");
		#else // _WIN32
		pWrapperTable->m_FunctionGradientNode_GetInputStep = (PLib3MFFunctionGradientNode_GetInputStepPtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getinputstep");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionGradientNode_GetInputStep == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionGradientNode_SetScalarOutputName = (PLib3MFFunctionGradientNode_SetScalarOutputNamePtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_setscalaroutputname");
		#else // _WIN32
		pWrapperTable->m_FunctionGradientNode_SetScalarOutputName = (PLib3MFFunctionGradientNode_SetScalarOutputNamePtr) dlsym(hLibrary, "lib3mf_functiongradientnode_setscalaroutputname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionGradientNode_SetScalarOutputName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionGradientNode_GetScalarOutputName = (PLib3MFFunctionGradientNode_GetScalarOutputNamePtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getscalaroutputname");
		#else // _WIN32
		pWrapperTable->m_FunctionGradientNode_GetScalarOutputName = (PLib3MFFunctionGradientNode_GetScalarOutputNamePtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getscalaroutputname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionGradientNode_GetScalarOutputName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionGradientNode_SetVectorInputName = (PLib3MFFunctionGradientNode_SetVectorInputNamePtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_setvectorinputname");
		#else // _WIN32
		pWrapperTable->m_FunctionGradientNode_SetVectorInputName = (PLib3MFFunctionGradientNode_SetVectorInputNamePtr) dlsym(hLibrary, "lib3mf_functiongradientnode_setvectorinputname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionGradientNode_SetVectorInputName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionGradientNode_GetVectorInputName = (PLib3MFFunctionGradientNode_GetVectorInputNamePtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getvectorinputname");
		#else // _WIN32
		pWrapperTable->m_FunctionGradientNode_GetVectorInputName = (PLib3MFFunctionGradientNode_GetVectorInputNamePtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getvectorinputname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionGradientNode_GetVectorInputName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionGradientNode_GetOutputNormalizedGradient = (PLib3MFFunctionGradientNode_GetOutputNormalizedGradientPtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getoutputnormalizedgradient");
		#else // _WIN32
		pWrapperTable->m_FunctionGradientNode_GetOutputNormalizedGradient = (PLib3MFFunctionGradientNode_GetOutputNormalizedGradientPtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getoutputnormalizedgradient");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionGradientNode_GetOutputNormalizedGradient == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionGradientNode_GetOutputGradient = (PLib3MFFunctionGradientNode_GetOutputGradientPtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getoutputgradient");
		#else // _WIN32
		pWrapperTable->m_FunctionGradientNode_GetOutputGradient = (PLib3MFFunctionGradientNode_GetOutputGradientPtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getoutputgradient");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionGradientNode_GetOutputGradient == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionGradientNode_GetOutputMagnitude = (PLib3MFFunctionGradientNode_GetOutputMagnitudePtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getoutputmagnitude");
		#else // _WIN32
		pWrapperTable->m_FunctionGradientNode_GetOutputMagnitude = (PLib3MFFunctionGradientNode_GetOutputMagnitudePtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getoutputmagnitude");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionGradientNode_GetOutputMagnitude == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetInputFunctionID = (PLib3MFNormalizeDistanceNode_GetInputFunctionIDPtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getinputfunctionid");
		#else // _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetInputFunctionID = (PLib3MFNormalizeDistanceNode_GetInputFunctionIDPtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getinputfunctionid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_NormalizeDistanceNode_GetInputFunctionID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetInputPos = (PLib3MFNormalizeDistanceNode_GetInputPosPtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getinputpos");
		#else // _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetInputPos = (PLib3MFNormalizeDistanceNode_GetInputPosPtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getinputpos");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_NormalizeDistanceNode_GetInputPos == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetInputStep = (PLib3MFNormalizeDistanceNode_GetInputStepPtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getinputstep");
		#else // _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetInputStep = (PLib3MFNormalizeDistanceNode_GetInputStepPtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getinputstep");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_NormalizeDistanceNode_GetInputStep == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_NormalizeDistanceNode_SetScalarOutputName = (PLib3MFNormalizeDistanceNode_SetScalarOutputNamePtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_setscalaroutputname");
		#else // _WIN32
		pWrapperTable->m_NormalizeDistanceNode_SetScalarOutputName = (PLib3MFNormalizeDistanceNode_SetScalarOutputNamePtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_setscalaroutputname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_NormalizeDistanceNode_SetScalarOutputName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetScalarOutputName = (PLib3MFNormalizeDistanceNode_GetScalarOutputNamePtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getscalaroutputname");
		#else // _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetScalarOutputName = (PLib3MFNormalizeDistanceNode_GetScalarOutputNamePtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getscalaroutputname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_NormalizeDistanceNode_GetScalarOutputName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_NormalizeDistanceNode_SetVectorInputName = (PLib3MFNormalizeDistanceNode_SetVectorInputNamePtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_setvectorinputname");
		#else // _WIN32
		pWrapperTable->m_NormalizeDistanceNode_SetVectorInputName = (PLib3MFNormalizeDistanceNode_SetVectorInputNamePtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_setvectorinputname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_NormalizeDistanceNode_SetVectorInputName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetVectorInputName = (PLib3MFNormalizeDistanceNode_GetVectorInputNamePtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getvectorinputname");
		#else // _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetVectorInputName = (PLib3MFNormalizeDistanceNode_GetVectorInputNamePtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getvectorinputname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_NormalizeDistanceNode_GetVectorInputName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetOutputResult = (PLib3MFNormalizeDistanceNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getoutputresult");
		#else // _WIN32
		pWrapperTable->m_NormalizeDistanceNode_GetOutputResult = (PLib3MFNormalizeDistanceNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getoutputresult");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_NormalizeDistanceNode_GetOutputResult == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionCallNode_GetInputFunctionID = (PLib3MFFunctionCallNode_GetInputFunctionIDPtr) GetProcAddress(hLibrary, "lib3mf_functioncallnode_getinputfunctionid");
		#else // _WIN32
		pWrapperTable->m_FunctionCallNode_GetInputFunctionID = (PLib3MFFunctionCallNode_GetInputFunctionIDPtr) dlsym(hLibrary, "lib3mf_functioncallnode_getinputfunctionid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionCallNode_GetInputFunctionID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_NodeIterator_GetCurrent = (PLib3MFNodeIterator_GetCurrentPtr) GetProcAddress(hLibrary, "lib3mf_nodeiterator_getcurrent");
		#else // _WIN32
		pWrapperTable->m_NodeIterator_GetCurrent = (PLib3MFNodeIterator_GetCurrentPtr) dlsym(hLibrary, "lib3mf_nodeiterator_getcurrent");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_NodeIterator_GetCurrent == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Function_GetDisplayName = (PLib3MFFunction_GetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_function_getdisplayname");
		#else // _WIN32
		pWrapperTable->m_Function_GetDisplayName = (PLib3MFFunction_GetDisplayNamePtr) dlsym(hLibrary, "lib3mf_function_getdisplayname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Function_GetDisplayName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Function_SetDisplayName = (PLib3MFFunction_SetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_function_setdisplayname");
		#else // _WIN32
		pWrapperTable->m_Function_SetDisplayName = (PLib3MFFunction_SetDisplayNamePtr) dlsym(hLibrary, "lib3mf_function_setdisplayname");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Function_SetDisplayName == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Function_AddInput = (PLib3MFFunction_AddInputPtr) GetProcAddress(hLibrary, "lib3mf_function_addinput");
		#else // _WIN32
		pWrapperTable->m_Function_AddInput = (PLib3MFFunction_AddInputPtr) dlsym(hLibrary, "lib3mf_function_addinput");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Function_AddInput == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Function_GetInputs = (PLib3MFFunction_GetInputsPtr) GetProcAddress(hLibrary, "lib3mf_function_getinputs");
		#else // _WIN32
		pWrapperTable->m_Function_GetInputs = (PLib3MFFunction_GetInputsPtr) dlsym(hLibrary, "lib3mf_function_getinputs");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Function_GetInputs == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Function_RemoveInput = (PLib3MFFunction_RemoveInputPtr) GetProcAddress(hLibrary, "lib3mf_function_removeinput");
		#else // _WIN32
		pWrapperTable->m_Function_RemoveInput = (PLib3MFFunction_RemoveInputPtr) dlsym(hLibrary, "lib3mf_function_removeinput");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Function_RemoveInput == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Function_AddOutput = (PLib3MFFunction_AddOutputPtr) GetProcAddress(hLibrary, "lib3mf_function_addoutput");
		#else // _WIN32
		pWrapperTable->m_Function_AddOutput = (PLib3MFFunction_AddOutputPtr) dlsym(hLibrary, "lib3mf_function_addoutput");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Function_AddOutput == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Function_GetOutputs = (PLib3MFFunction_GetOutputsPtr) GetProcAddress(hLibrary, "lib3mf_function_getoutputs");
		#else // _WIN32
		pWrapperTable->m_Function_GetOutputs = (PLib3MFFunction_GetOutputsPtr) dlsym(hLibrary, "lib3mf_function_getoutputs");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Function_GetOutputs == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Function_RemoveOutput = (PLib3MFFunction_RemoveOutputPtr) GetProcAddress(hLibrary, "lib3mf_function_removeoutput");
		#else // _WIN32
		pWrapperTable->m_Function_RemoveOutput = (PLib3MFFunction_RemoveOutputPtr) dlsym(hLibrary, "lib3mf_function_removeoutput");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Function_RemoveOutput == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Function_FindInput = (PLib3MFFunction_FindInputPtr) GetProcAddress(hLibrary, "lib3mf_function_findinput");
		#else // _WIN32
		pWrapperTable->m_Function_FindInput = (PLib3MFFunction_FindInputPtr) dlsym(hLibrary, "lib3mf_function_findinput");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Function_FindInput == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Function_FindOutput = (PLib3MFFunction_FindOutputPtr) GetProcAddress(hLibrary, "lib3mf_function_findoutput");
		#else // _WIN32
		pWrapperTable->m_Function_FindOutput = (PLib3MFFunction_FindOutputPtr) dlsym(hLibrary, "lib3mf_function_findoutput");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Function_FindOutput == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_GetIdentifier = (PLib3MFImplicitFunction_GetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_getidentifier");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_GetIdentifier = (PLib3MFImplicitFunction_GetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitfunction_getidentifier");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_GetIdentifier == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_SetIdentifier = (PLib3MFImplicitFunction_SetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_setidentifier");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_SetIdentifier = (PLib3MFImplicitFunction_SetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitfunction_setidentifier");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_SetIdentifier == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddNode = (PLib3MFImplicitFunction_AddNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddNode = (PLib3MFImplicitFunction_AddNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddSinNode = (PLib3MFImplicitFunction_AddSinNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addsinnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddSinNode = (PLib3MFImplicitFunction_AddSinNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addsinnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddSinNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddCosNode = (PLib3MFImplicitFunction_AddCosNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addcosnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddCosNode = (PLib3MFImplicitFunction_AddCosNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addcosnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddCosNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddTanNode = (PLib3MFImplicitFunction_AddTanNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addtannode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddTanNode = (PLib3MFImplicitFunction_AddTanNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addtannode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddTanNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddArcSinNode = (PLib3MFImplicitFunction_AddArcSinNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addarcsinnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddArcSinNode = (PLib3MFImplicitFunction_AddArcSinNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addarcsinnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddArcSinNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddArcCosNode = (PLib3MFImplicitFunction_AddArcCosNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addarccosnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddArcCosNode = (PLib3MFImplicitFunction_AddArcCosNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addarccosnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddArcCosNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddArcTan2Node = (PLib3MFImplicitFunction_AddArcTan2NodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addarctan2node");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddArcTan2Node = (PLib3MFImplicitFunction_AddArcTan2NodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addarctan2node");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddArcTan2Node == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddSinhNode = (PLib3MFImplicitFunction_AddSinhNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addsinhnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddSinhNode = (PLib3MFImplicitFunction_AddSinhNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addsinhnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddSinhNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddCoshNode = (PLib3MFImplicitFunction_AddCoshNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addcoshnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddCoshNode = (PLib3MFImplicitFunction_AddCoshNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addcoshnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddCoshNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddTanhNode = (PLib3MFImplicitFunction_AddTanhNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addtanhnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddTanhNode = (PLib3MFImplicitFunction_AddTanhNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addtanhnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddTanhNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddRoundNode = (PLib3MFImplicitFunction_AddRoundNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addroundnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddRoundNode = (PLib3MFImplicitFunction_AddRoundNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addroundnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddRoundNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddCeilNode = (PLib3MFImplicitFunction_AddCeilNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addceilnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddCeilNode = (PLib3MFImplicitFunction_AddCeilNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addceilnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddCeilNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddFloorNode = (PLib3MFImplicitFunction_AddFloorNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addfloornode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddFloorNode = (PLib3MFImplicitFunction_AddFloorNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addfloornode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddFloorNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddSignNode = (PLib3MFImplicitFunction_AddSignNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addsignnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddSignNode = (PLib3MFImplicitFunction_AddSignNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addsignnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddSignNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddFractNode = (PLib3MFImplicitFunction_AddFractNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addfractnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddFractNode = (PLib3MFImplicitFunction_AddFractNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addfractnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddFractNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddAbsNode = (PLib3MFImplicitFunction_AddAbsNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addabsnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddAbsNode = (PLib3MFImplicitFunction_AddAbsNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addabsnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddAbsNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddExpNode = (PLib3MFImplicitFunction_AddExpNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addexpnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddExpNode = (PLib3MFImplicitFunction_AddExpNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addexpnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddExpNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddLogNode = (PLib3MFImplicitFunction_AddLogNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlognode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddLogNode = (PLib3MFImplicitFunction_AddLogNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlognode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddLogNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddLog2Node = (PLib3MFImplicitFunction_AddLog2NodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlog2node");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddLog2Node = (PLib3MFImplicitFunction_AddLog2NodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlog2node");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddLog2Node == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddLog10Node = (PLib3MFImplicitFunction_AddLog10NodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlog10node");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddLog10Node = (PLib3MFImplicitFunction_AddLog10NodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlog10node");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddLog10Node == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddLengthNode = (PLib3MFImplicitFunction_AddLengthNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlengthnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddLengthNode = (PLib3MFImplicitFunction_AddLengthNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlengthnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddLengthNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddTransposeNode = (PLib3MFImplicitFunction_AddTransposeNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addtransposenode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddTransposeNode = (PLib3MFImplicitFunction_AddTransposeNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addtransposenode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddTransposeNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddInverseNode = (PLib3MFImplicitFunction_AddInverseNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addinversenode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddInverseNode = (PLib3MFImplicitFunction_AddInverseNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addinversenode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddInverseNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddSqrtNode = (PLib3MFImplicitFunction_AddSqrtNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addsqrtnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddSqrtNode = (PLib3MFImplicitFunction_AddSqrtNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addsqrtnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddSqrtNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddResourceIdNode = (PLib3MFImplicitFunction_AddResourceIdNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addresourceidnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddResourceIdNode = (PLib3MFImplicitFunction_AddResourceIdNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addresourceidnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddResourceIdNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddAdditionNode = (PLib3MFImplicitFunction_AddAdditionNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addadditionnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddAdditionNode = (PLib3MFImplicitFunction_AddAdditionNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addadditionnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddAdditionNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddSubtractionNode = (PLib3MFImplicitFunction_AddSubtractionNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addsubtractionnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddSubtractionNode = (PLib3MFImplicitFunction_AddSubtractionNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addsubtractionnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddSubtractionNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddMultiplicationNode = (PLib3MFImplicitFunction_AddMultiplicationNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmultiplicationnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddMultiplicationNode = (PLib3MFImplicitFunction_AddMultiplicationNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmultiplicationnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddMultiplicationNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddDivisionNode = (PLib3MFImplicitFunction_AddDivisionNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_adddivisionnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddDivisionNode = (PLib3MFImplicitFunction_AddDivisionNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_adddivisionnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddDivisionNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddDotNode = (PLib3MFImplicitFunction_AddDotNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_adddotnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddDotNode = (PLib3MFImplicitFunction_AddDotNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_adddotnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddDotNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddCrossNode = (PLib3MFImplicitFunction_AddCrossNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addcrossnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddCrossNode = (PLib3MFImplicitFunction_AddCrossNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addcrossnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddCrossNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode = (PLib3MFImplicitFunction_AddMatVecMultiplicationNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmatvecmultiplicationnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode = (PLib3MFImplicitFunction_AddMatVecMultiplicationNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmatvecmultiplicationnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddMinNode = (PLib3MFImplicitFunction_AddMinNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addminnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddMinNode = (PLib3MFImplicitFunction_AddMinNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addminnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddMinNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddMaxNode = (PLib3MFImplicitFunction_AddMaxNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmaxnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddMaxNode = (PLib3MFImplicitFunction_AddMaxNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmaxnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddMaxNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddFmodNode = (PLib3MFImplicitFunction_AddFmodNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addfmodnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddFmodNode = (PLib3MFImplicitFunction_AddFmodNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addfmodnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddFmodNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddPowNode = (PLib3MFImplicitFunction_AddPowNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addpownode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddPowNode = (PLib3MFImplicitFunction_AddPowNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addpownode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddPowNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddSelectNode = (PLib3MFImplicitFunction_AddSelectNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addselectnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddSelectNode = (PLib3MFImplicitFunction_AddSelectNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addselectnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddSelectNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddClampNode = (PLib3MFImplicitFunction_AddClampNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addclampnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddClampNode = (PLib3MFImplicitFunction_AddClampNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addclampnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddClampNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddComposeVectorNode = (PLib3MFImplicitFunction_AddComposeVectorNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addcomposevectornode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddComposeVectorNode = (PLib3MFImplicitFunction_AddComposeVectorNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addcomposevectornode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddComposeVectorNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddVectorFromScalarNode = (PLib3MFImplicitFunction_AddVectorFromScalarNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addvectorfromscalarnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddVectorFromScalarNode = (PLib3MFImplicitFunction_AddVectorFromScalarNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addvectorfromscalarnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddVectorFromScalarNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddDecomposeVectorNode = (PLib3MFImplicitFunction_AddDecomposeVectorNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_adddecomposevectornode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddDecomposeVectorNode = (PLib3MFImplicitFunction_AddDecomposeVectorNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_adddecomposevectornode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddDecomposeVectorNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddComposeMatrixNode = (PLib3MFImplicitFunction_AddComposeMatrixNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addcomposematrixnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddComposeMatrixNode = (PLib3MFImplicitFunction_AddComposeMatrixNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addcomposematrixnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddComposeMatrixNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode = (PLib3MFImplicitFunction_AddMatrixFromRowsNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmatrixfromrowsnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode = (PLib3MFImplicitFunction_AddMatrixFromRowsNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmatrixfromrowsnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode = (PLib3MFImplicitFunction_AddMatrixFromColumnsNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmatrixfromcolumnsnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode = (PLib3MFImplicitFunction_AddMatrixFromColumnsNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmatrixfromcolumnsnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddConstantNode = (PLib3MFImplicitFunction_AddConstantNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addconstantnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddConstantNode = (PLib3MFImplicitFunction_AddConstantNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addconstantnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddConstantNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddConstVecNode = (PLib3MFImplicitFunction_AddConstVecNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addconstvecnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddConstVecNode = (PLib3MFImplicitFunction_AddConstVecNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addconstvecnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddConstVecNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddConstMatNode = (PLib3MFImplicitFunction_AddConstMatNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addconstmatnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddConstMatNode = (PLib3MFImplicitFunction_AddConstMatNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addconstmatnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddConstMatNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddMeshNode = (PLib3MFImplicitFunction_AddMeshNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmeshnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddMeshNode = (PLib3MFImplicitFunction_AddMeshNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmeshnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddMeshNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddUnsignedMeshNode = (PLib3MFImplicitFunction_AddUnsignedMeshNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addunsignedmeshnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddUnsignedMeshNode = (PLib3MFImplicitFunction_AddUnsignedMeshNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addunsignedmeshnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddUnsignedMeshNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddBeamLatticeNode = (PLib3MFImplicitFunction_AddBeamLatticeNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addbeamlatticenode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddBeamLatticeNode = (PLib3MFImplicitFunction_AddBeamLatticeNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addbeamlatticenode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddBeamLatticeNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddFunctionGradientNode = (PLib3MFImplicitFunction_AddFunctionGradientNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addfunctiongradientnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddFunctionGradientNode = (PLib3MFImplicitFunction_AddFunctionGradientNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addfunctiongradientnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddFunctionGradientNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddNormalizeDistanceNode = (PLib3MFImplicitFunction_AddNormalizeDistanceNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addnormalizedistancenode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddNormalizeDistanceNode = (PLib3MFImplicitFunction_AddNormalizeDistanceNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addnormalizedistancenode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddNormalizeDistanceNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddFunctionCallNode = (PLib3MFImplicitFunction_AddFunctionCallNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addfunctioncallnode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddFunctionCallNode = (PLib3MFImplicitFunction_AddFunctionCallNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addfunctioncallnode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddFunctionCallNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_GetNodes = (PLib3MFImplicitFunction_GetNodesPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_getnodes");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_GetNodes = (PLib3MFImplicitFunction_GetNodesPtr) dlsym(hLibrary, "lib3mf_implicitfunction_getnodes");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_GetNodes == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_RemoveNode = (PLib3MFImplicitFunction_RemoveNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_removenode");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_RemoveNode = (PLib3MFImplicitFunction_RemoveNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_removenode");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_RemoveNode == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddLink = (PLib3MFImplicitFunction_AddLinkPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlink");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddLink = (PLib3MFImplicitFunction_AddLinkPtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlink");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddLink == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_AddLinkByNames = (PLib3MFImplicitFunction_AddLinkByNamesPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlinkbynames");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_AddLinkByNames = (PLib3MFImplicitFunction_AddLinkByNamesPtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlinkbynames");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_AddLinkByNames == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_Clear = (PLib3MFImplicitFunction_ClearPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_clear");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_Clear = (PLib3MFImplicitFunction_ClearPtr) dlsym(hLibrary, "lib3mf_implicitfunction_clear");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_Clear == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ImplicitFunction_SortNodesTopologically = (PLib3MFImplicitFunction_SortNodesTopologicallyPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_sortnodestopologically");
		#else // _WIN32
		pWrapperTable->m_ImplicitFunction_SortNodesTopologically = (PLib3MFImplicitFunction_SortNodesTopologicallyPtr) dlsym(hLibrary, "lib3mf_implicitfunction_sortnodestopologically");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ImplicitFunction_SortNodesTopologically == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionFromImage3D_GetImage3D = (PLib3MFFunctionFromImage3D_GetImage3DPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_getimage3d");
		#else // _WIN32
		pWrapperTable->m_FunctionFromImage3D_GetImage3D = (PLib3MFFunctionFromImage3D_GetImage3DPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_getimage3d");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionFromImage3D_GetImage3D == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionFromImage3D_SetImage3D = (PLib3MFFunctionFromImage3D_SetImage3DPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_setimage3d");
		#else // _WIN32
		pWrapperTable->m_FunctionFromImage3D_SetImage3D = (PLib3MFFunctionFromImage3D_SetImage3DPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_setimage3d");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionFromImage3D_SetImage3D == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionFromImage3D_SetFilter = (PLib3MFFunctionFromImage3D_SetFilterPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_setfilter");
		#else // _WIN32
		pWrapperTable->m_FunctionFromImage3D_SetFilter = (PLib3MFFunctionFromImage3D_SetFilterPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_setfilter");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionFromImage3D_SetFilter == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionFromImage3D_GetFilter = (PLib3MFFunctionFromImage3D_GetFilterPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_getfilter");
		#else // _WIN32
		pWrapperTable->m_FunctionFromImage3D_GetFilter = (PLib3MFFunctionFromImage3D_GetFilterPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_getfilter");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionFromImage3D_GetFilter == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionFromImage3D_SetTileStyles = (PLib3MFFunctionFromImage3D_SetTileStylesPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_settilestyles");
		#else // _WIN32
		pWrapperTable->m_FunctionFromImage3D_SetTileStyles = (PLib3MFFunctionFromImage3D_SetTileStylesPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_settilestyles");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionFromImage3D_SetTileStyles == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionFromImage3D_GetTileStyles = (PLib3MFFunctionFromImage3D_GetTileStylesPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_gettilestyles");
		#else // _WIN32
		pWrapperTable->m_FunctionFromImage3D_GetTileStyles = (PLib3MFFunctionFromImage3D_GetTileStylesPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_gettilestyles");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionFromImage3D_GetTileStyles == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionFromImage3D_GetOffset = (PLib3MFFunctionFromImage3D_GetOffsetPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_getoffset");
		#else // _WIN32
		pWrapperTable->m_FunctionFromImage3D_GetOffset = (PLib3MFFunctionFromImage3D_GetOffsetPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_getoffset");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionFromImage3D_GetOffset == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionFromImage3D_SetOffset = (PLib3MFFunctionFromImage3D_SetOffsetPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_setoffset");
		#else // _WIN32
		pWrapperTable->m_FunctionFromImage3D_SetOffset = (PLib3MFFunctionFromImage3D_SetOffsetPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_setoffset");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionFromImage3D_SetOffset == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionFromImage3D_GetScale = (PLib3MFFunctionFromImage3D_GetScalePtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_getscale");
		#else // _WIN32
		pWrapperTable->m_FunctionFromImage3D_GetScale = (PLib3MFFunctionFromImage3D_GetScalePtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_getscale");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionFromImage3D_GetScale == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FunctionFromImage3D_SetScale = (PLib3MFFunctionFromImage3D_SetScalePtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_setscale");
		#else // _WIN32
		pWrapperTable->m_FunctionFromImage3D_SetScale = (PLib3MFFunctionFromImage3D_SetScalePtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_setscale");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FunctionFromImage3D_SetScale == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItem_GetObjectResource = (PLib3MFBuildItem_GetObjectResourcePtr) GetProcAddress(hLibrary, "lib3mf_builditem_getobjectresource");
		#else // _WIN32
		pWrapperTable->m_BuildItem_GetObjectResource = (PLib3MFBuildItem_GetObjectResourcePtr) dlsym(hLibrary, "lib3mf_builditem_getobjectresource");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItem_GetObjectResource == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItem_GetUUID = (PLib3MFBuildItem_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getuuid");
		#else // _WIN32
		pWrapperTable->m_BuildItem_GetUUID = (PLib3MFBuildItem_GetUUIDPtr) dlsym(hLibrary, "lib3mf_builditem_getuuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItem_GetUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItem_SetUUID = (PLib3MFBuildItem_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_builditem_setuuid");
		#else // _WIN32
		pWrapperTable->m_BuildItem_SetUUID = (PLib3MFBuildItem_SetUUIDPtr) dlsym(hLibrary, "lib3mf_builditem_setuuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItem_SetUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItem_GetObjectResourceID = (PLib3MFBuildItem_GetObjectResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getobjectresourceid");
		#else // _WIN32
		pWrapperTable->m_BuildItem_GetObjectResourceID = (PLib3MFBuildItem_GetObjectResourceIDPtr) dlsym(hLibrary, "lib3mf_builditem_getobjectresourceid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItem_GetObjectResourceID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItem_HasObjectTransform = (PLib3MFBuildItem_HasObjectTransformPtr) GetProcAddress(hLibrary, "lib3mf_builditem_hasobjecttransform");
		#else // _WIN32
		pWrapperTable->m_BuildItem_HasObjectTransform = (PLib3MFBuildItem_HasObjectTransformPtr) dlsym(hLibrary, "lib3mf_builditem_hasobjecttransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItem_HasObjectTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItem_GetObjectTransform = (PLib3MFBuildItem_GetObjectTransformPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getobjecttransform");
		#else // _WIN32
		pWrapperTable->m_BuildItem_GetObjectTransform = (PLib3MFBuildItem_GetObjectTransformPtr) dlsym(hLibrary, "lib3mf_builditem_getobjecttransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItem_GetObjectTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItem_SetObjectTransform = (PLib3MFBuildItem_SetObjectTransformPtr) GetProcAddress(hLibrary, "lib3mf_builditem_setobjecttransform");
		#else // _WIN32
		pWrapperTable->m_BuildItem_SetObjectTransform = (PLib3MFBuildItem_SetObjectTransformPtr) dlsym(hLibrary, "lib3mf_builditem_setobjecttransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItem_SetObjectTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItem_GetPartNumber = (PLib3MFBuildItem_GetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getpartnumber");
		#else // _WIN32
		pWrapperTable->m_BuildItem_GetPartNumber = (PLib3MFBuildItem_GetPartNumberPtr) dlsym(hLibrary, "lib3mf_builditem_getpartnumber");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItem_GetPartNumber == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItem_SetPartNumber = (PLib3MFBuildItem_SetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_builditem_setpartnumber");
		#else // _WIN32
		pWrapperTable->m_BuildItem_SetPartNumber = (PLib3MFBuildItem_SetPartNumberPtr) dlsym(hLibrary, "lib3mf_builditem_setpartnumber");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItem_SetPartNumber == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItem_GetMetaDataGroup = (PLib3MFBuildItem_GetMetaDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getmetadatagroup");
		#else // _WIN32
		pWrapperTable->m_BuildItem_GetMetaDataGroup = (PLib3MFBuildItem_GetMetaDataGroupPtr) dlsym(hLibrary, "lib3mf_builditem_getmetadatagroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItem_GetMetaDataGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItem_GetOutbox = (PLib3MFBuildItem_GetOutboxPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getoutbox");
		#else // _WIN32
		pWrapperTable->m_BuildItem_GetOutbox = (PLib3MFBuildItem_GetOutboxPtr) dlsym(hLibrary, "lib3mf_builditem_getoutbox");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItem_GetOutbox == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItemIterator_MoveNext = (PLib3MFBuildItemIterator_MoveNextPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_movenext");
		#else // _WIN32
		pWrapperTable->m_BuildItemIterator_MoveNext = (PLib3MFBuildItemIterator_MoveNextPtr) dlsym(hLibrary, "lib3mf_builditemiterator_movenext");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItemIterator_MoveNext == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItemIterator_MovePrevious = (PLib3MFBuildItemIterator_MovePreviousPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_moveprevious");
		#else // _WIN32
		pWrapperTable->m_BuildItemIterator_MovePrevious = (PLib3MFBuildItemIterator_MovePreviousPtr) dlsym(hLibrary, "lib3mf_builditemiterator_moveprevious");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItemIterator_MovePrevious == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItemIterator_GetCurrent = (PLib3MFBuildItemIterator_GetCurrentPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_getcurrent");
		#else // _WIN32
		pWrapperTable->m_BuildItemIterator_GetCurrent = (PLib3MFBuildItemIterator_GetCurrentPtr) dlsym(hLibrary, "lib3mf_builditemiterator_getcurrent");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItemIterator_GetCurrent == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItemIterator_Clone = (PLib3MFBuildItemIterator_ClonePtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_clone");
		#else // _WIN32
		pWrapperTable->m_BuildItemIterator_Clone = (PLib3MFBuildItemIterator_ClonePtr) dlsym(hLibrary, "lib3mf_builditemiterator_clone");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItemIterator_Clone == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_BuildItemIterator_Count = (PLib3MFBuildItemIterator_CountPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_count");
		#else // _WIN32
		pWrapperTable->m_BuildItemIterator_Count = (PLib3MFBuildItemIterator_CountPtr) dlsym(hLibrary, "lib3mf_builditemiterator_count");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_BuildItemIterator_Count == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Slice_SetVertices = (PLib3MFSlice_SetVerticesPtr) GetProcAddress(hLibrary, "lib3mf_slice_setvertices");
		#else // _WIN32
		pWrapperTable->m_Slice_SetVertices = (PLib3MFSlice_SetVerticesPtr) dlsym(hLibrary, "lib3mf_slice_setvertices");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Slice_SetVertices == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Slice_GetVertices = (PLib3MFSlice_GetVerticesPtr) GetProcAddress(hLibrary, "lib3mf_slice_getvertices");
		#else // _WIN32
		pWrapperTable->m_Slice_GetVertices = (PLib3MFSlice_GetVerticesPtr) dlsym(hLibrary, "lib3mf_slice_getvertices");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Slice_GetVertices == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Slice_GetVertexCount = (PLib3MFSlice_GetVertexCountPtr) GetProcAddress(hLibrary, "lib3mf_slice_getvertexcount");
		#else // _WIN32
		pWrapperTable->m_Slice_GetVertexCount = (PLib3MFSlice_GetVertexCountPtr) dlsym(hLibrary, "lib3mf_slice_getvertexcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Slice_GetVertexCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Slice_AddPolygon = (PLib3MFSlice_AddPolygonPtr) GetProcAddress(hLibrary, "lib3mf_slice_addpolygon");
		#else // _WIN32
		pWrapperTable->m_Slice_AddPolygon = (PLib3MFSlice_AddPolygonPtr) dlsym(hLibrary, "lib3mf_slice_addpolygon");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Slice_AddPolygon == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Slice_GetPolygonCount = (PLib3MFSlice_GetPolygonCountPtr) GetProcAddress(hLibrary, "lib3mf_slice_getpolygoncount");
		#else // _WIN32
		pWrapperTable->m_Slice_GetPolygonCount = (PLib3MFSlice_GetPolygonCountPtr) dlsym(hLibrary, "lib3mf_slice_getpolygoncount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Slice_GetPolygonCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Slice_SetPolygonIndices = (PLib3MFSlice_SetPolygonIndicesPtr) GetProcAddress(hLibrary, "lib3mf_slice_setpolygonindices");
		#else // _WIN32
		pWrapperTable->m_Slice_SetPolygonIndices = (PLib3MFSlice_SetPolygonIndicesPtr) dlsym(hLibrary, "lib3mf_slice_setpolygonindices");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Slice_SetPolygonIndices == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Slice_GetPolygonIndices = (PLib3MFSlice_GetPolygonIndicesPtr) GetProcAddress(hLibrary, "lib3mf_slice_getpolygonindices");
		#else // _WIN32
		pWrapperTable->m_Slice_GetPolygonIndices = (PLib3MFSlice_GetPolygonIndicesPtr) dlsym(hLibrary, "lib3mf_slice_getpolygonindices");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Slice_GetPolygonIndices == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Slice_GetPolygonIndexCount = (PLib3MFSlice_GetPolygonIndexCountPtr) GetProcAddress(hLibrary, "lib3mf_slice_getpolygonindexcount");
		#else // _WIN32
		pWrapperTable->m_Slice_GetPolygonIndexCount = (PLib3MFSlice_GetPolygonIndexCountPtr) dlsym(hLibrary, "lib3mf_slice_getpolygonindexcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Slice_GetPolygonIndexCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Slice_GetZTop = (PLib3MFSlice_GetZTopPtr) GetProcAddress(hLibrary, "lib3mf_slice_getztop");
		#else // _WIN32
		pWrapperTable->m_Slice_GetZTop = (PLib3MFSlice_GetZTopPtr) dlsym(hLibrary, "lib3mf_slice_getztop");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Slice_GetZTop == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SliceStack_GetBottomZ = (PLib3MFSliceStack_GetBottomZPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getbottomz");
		#else // _WIN32
		pWrapperTable->m_SliceStack_GetBottomZ = (PLib3MFSliceStack_GetBottomZPtr) dlsym(hLibrary, "lib3mf_slicestack_getbottomz");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SliceStack_GetBottomZ == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SliceStack_GetSliceCount = (PLib3MFSliceStack_GetSliceCountPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslicecount");
		#else // _WIN32
		pWrapperTable->m_SliceStack_GetSliceCount = (PLib3MFSliceStack_GetSliceCountPtr) dlsym(hLibrary, "lib3mf_slicestack_getslicecount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SliceStack_GetSliceCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SliceStack_GetSlice = (PLib3MFSliceStack_GetSlicePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslice");
		#else // _WIN32
		pWrapperTable->m_SliceStack_GetSlice = (PLib3MFSliceStack_GetSlicePtr) dlsym(hLibrary, "lib3mf_slicestack_getslice");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SliceStack_GetSlice == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SliceStack_AddSlice = (PLib3MFSliceStack_AddSlicePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_addslice");
		#else // _WIN32
		pWrapperTable->m_SliceStack_AddSlice = (PLib3MFSliceStack_AddSlicePtr) dlsym(hLibrary, "lib3mf_slicestack_addslice");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SliceStack_AddSlice == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SliceStack_GetSliceRefCount = (PLib3MFSliceStack_GetSliceRefCountPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslicerefcount");
		#else // _WIN32
		pWrapperTable->m_SliceStack_GetSliceRefCount = (PLib3MFSliceStack_GetSliceRefCountPtr) dlsym(hLibrary, "lib3mf_slicestack_getslicerefcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SliceStack_GetSliceRefCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SliceStack_AddSliceStackReference = (PLib3MFSliceStack_AddSliceStackReferencePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_addslicestackreference");
		#else // _WIN32
		pWrapperTable->m_SliceStack_AddSliceStackReference = (PLib3MFSliceStack_AddSliceStackReferencePtr) dlsym(hLibrary, "lib3mf_slicestack_addslicestackreference");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SliceStack_AddSliceStackReference == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SliceStack_GetSliceStackReference = (PLib3MFSliceStack_GetSliceStackReferencePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslicestackreference");
		#else // _WIN32
		pWrapperTable->m_SliceStack_GetSliceStackReference = (PLib3MFSliceStack_GetSliceStackReferencePtr) dlsym(hLibrary, "lib3mf_slicestack_getslicestackreference");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SliceStack_GetSliceStackReference == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SliceStack_CollapseSliceReferences = (PLib3MFSliceStack_CollapseSliceReferencesPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_collapseslicereferences");
		#else // _WIN32
		pWrapperTable->m_SliceStack_CollapseSliceReferences = (PLib3MFSliceStack_CollapseSliceReferencesPtr) dlsym(hLibrary, "lib3mf_slicestack_collapseslicereferences");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SliceStack_CollapseSliceReferences == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SliceStack_SetOwnPath = (PLib3MFSliceStack_SetOwnPathPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_setownpath");
		#else // _WIN32
		pWrapperTable->m_SliceStack_SetOwnPath = (PLib3MFSliceStack_SetOwnPathPtr) dlsym(hLibrary, "lib3mf_slicestack_setownpath");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SliceStack_SetOwnPath == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SliceStack_GetOwnPath = (PLib3MFSliceStack_GetOwnPathPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getownpath");
		#else // _WIN32
		pWrapperTable->m_SliceStack_GetOwnPath = (PLib3MFSliceStack_GetOwnPathPtr) dlsym(hLibrary, "lib3mf_slicestack_getownpath");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SliceStack_GetOwnPath == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Consumer_GetConsumerID = (PLib3MFConsumer_GetConsumerIDPtr) GetProcAddress(hLibrary, "lib3mf_consumer_getconsumerid");
		#else // _WIN32
		pWrapperTable->m_Consumer_GetConsumerID = (PLib3MFConsumer_GetConsumerIDPtr) dlsym(hLibrary, "lib3mf_consumer_getconsumerid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Consumer_GetConsumerID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Consumer_GetKeyID = (PLib3MFConsumer_GetKeyIDPtr) GetProcAddress(hLibrary, "lib3mf_consumer_getkeyid");
		#else // _WIN32
		pWrapperTable->m_Consumer_GetKeyID = (PLib3MFConsumer_GetKeyIDPtr) dlsym(hLibrary, "lib3mf_consumer_getkeyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Consumer_GetKeyID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Consumer_GetKeyValue = (PLib3MFConsumer_GetKeyValuePtr) GetProcAddress(hLibrary, "lib3mf_consumer_getkeyvalue");
		#else // _WIN32
		pWrapperTable->m_Consumer_GetKeyValue = (PLib3MFConsumer_GetKeyValuePtr) dlsym(hLibrary, "lib3mf_consumer_getkeyvalue");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Consumer_GetKeyValue == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_AccessRight_GetConsumer = (PLib3MFAccessRight_GetConsumerPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getconsumer");
		#else // _WIN32
		pWrapperTable->m_AccessRight_GetConsumer = (PLib3MFAccessRight_GetConsumerPtr) dlsym(hLibrary, "lib3mf_accessright_getconsumer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_AccessRight_GetConsumer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_AccessRight_GetWrappingAlgorithm = (PLib3MFAccessRight_GetWrappingAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getwrappingalgorithm");
		#else // _WIN32
		pWrapperTable->m_AccessRight_GetWrappingAlgorithm = (PLib3MFAccessRight_GetWrappingAlgorithmPtr) dlsym(hLibrary, "lib3mf_accessright_getwrappingalgorithm");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_AccessRight_GetWrappingAlgorithm == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_AccessRight_GetMgfAlgorithm = (PLib3MFAccessRight_GetMgfAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getmgfalgorithm");
		#else // _WIN32
		pWrapperTable->m_AccessRight_GetMgfAlgorithm = (PLib3MFAccessRight_GetMgfAlgorithmPtr) dlsym(hLibrary, "lib3mf_accessright_getmgfalgorithm");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_AccessRight_GetMgfAlgorithm == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_AccessRight_GetDigestMethod = (PLib3MFAccessRight_GetDigestMethodPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getdigestmethod");
		#else // _WIN32
		pWrapperTable->m_AccessRight_GetDigestMethod = (PLib3MFAccessRight_GetDigestMethodPtr) dlsym(hLibrary, "lib3mf_accessright_getdigestmethod");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_AccessRight_GetDigestMethod == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm = (PLib3MFContentEncryptionParams_GetEncryptionAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getencryptionalgorithm");
		#else // _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm = (PLib3MFContentEncryptionParams_GetEncryptionAlgorithmPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getencryptionalgorithm");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetKey = (PLib3MFContentEncryptionParams_GetKeyPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getkey");
		#else // _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetKey = (PLib3MFContentEncryptionParams_GetKeyPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getkey");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ContentEncryptionParams_GetKey == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetInitializationVector = (PLib3MFContentEncryptionParams_GetInitializationVectorPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getinitializationvector");
		#else // _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetInitializationVector = (PLib3MFContentEncryptionParams_GetInitializationVectorPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getinitializationvector");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ContentEncryptionParams_GetInitializationVector == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag = (PLib3MFContentEncryptionParams_GetAuthenticationTagPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getauthenticationtag");
		#else // _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag = (PLib3MFContentEncryptionParams_GetAuthenticationTagPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getauthenticationtag");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag = (PLib3MFContentEncryptionParams_SetAuthenticationTagPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_setauthenticationtag");
		#else // _WIN32
		pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag = (PLib3MFContentEncryptionParams_SetAuthenticationTagPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_setauthenticationtag");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData = (PLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getadditionalauthenticationdata");
		#else // _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData = (PLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getadditionalauthenticationdata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetDescriptor = (PLib3MFContentEncryptionParams_GetDescriptorPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getdescriptor");
		#else // _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetDescriptor = (PLib3MFContentEncryptionParams_GetDescriptorPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getdescriptor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ContentEncryptionParams_GetDescriptor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetKeyUUID = (PLib3MFContentEncryptionParams_GetKeyUUIDPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getkeyuuid");
		#else // _WIN32
		pWrapperTable->m_ContentEncryptionParams_GetKeyUUID = (PLib3MFContentEncryptionParams_GetKeyUUIDPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getkeyuuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ContentEncryptionParams_GetKeyUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceData_GetPath = (PLib3MFResourceData_GetPathPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getpath");
		#else // _WIN32
		pWrapperTable->m_ResourceData_GetPath = (PLib3MFResourceData_GetPathPtr) dlsym(hLibrary, "lib3mf_resourcedata_getpath");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceData_GetPath == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceData_GetEncryptionAlgorithm = (PLib3MFResourceData_GetEncryptionAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getencryptionalgorithm");
		#else // _WIN32
		pWrapperTable->m_ResourceData_GetEncryptionAlgorithm = (PLib3MFResourceData_GetEncryptionAlgorithmPtr) dlsym(hLibrary, "lib3mf_resourcedata_getencryptionalgorithm");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceData_GetEncryptionAlgorithm == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceData_GetCompression = (PLib3MFResourceData_GetCompressionPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getcompression");
		#else // _WIN32
		pWrapperTable->m_ResourceData_GetCompression = (PLib3MFResourceData_GetCompressionPtr) dlsym(hLibrary, "lib3mf_resourcedata_getcompression");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceData_GetCompression == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData = (PLib3MFResourceData_GetAdditionalAuthenticationDataPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getadditionalauthenticationdata");
		#else // _WIN32
		pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData = (PLib3MFResourceData_GetAdditionalAuthenticationDataPtr) dlsym(hLibrary, "lib3mf_resourcedata_getadditionalauthenticationdata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceDataGroup_GetKeyUUID = (PLib3MFResourceDataGroup_GetKeyUUIDPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_getkeyuuid");
		#else // _WIN32
		pWrapperTable->m_ResourceDataGroup_GetKeyUUID = (PLib3MFResourceDataGroup_GetKeyUUIDPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_getkeyuuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceDataGroup_GetKeyUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceDataGroup_AddAccessRight = (PLib3MFResourceDataGroup_AddAccessRightPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_addaccessright");
		#else // _WIN32
		pWrapperTable->m_ResourceDataGroup_AddAccessRight = (PLib3MFResourceDataGroup_AddAccessRightPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_addaccessright");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceDataGroup_AddAccessRight == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer = (PLib3MFResourceDataGroup_FindAccessRightByConsumerPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_findaccessrightbyconsumer");
		#else // _WIN32
		pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer = (PLib3MFResourceDataGroup_FindAccessRightByConsumerPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_findaccessrightbyconsumer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ResourceDataGroup_RemoveAccessRight = (PLib3MFResourceDataGroup_RemoveAccessRightPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_removeaccessright");
		#else // _WIN32
		pWrapperTable->m_ResourceDataGroup_RemoveAccessRight = (PLib3MFResourceDataGroup_RemoveAccessRightPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_removeaccessright");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ResourceDataGroup_RemoveAccessRight == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_AddConsumer = (PLib3MFKeyStore_AddConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_addconsumer");
		#else // _WIN32
		pWrapperTable->m_KeyStore_AddConsumer = (PLib3MFKeyStore_AddConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_addconsumer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_AddConsumer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_GetConsumerCount = (PLib3MFKeyStore_GetConsumerCountPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getconsumercount");
		#else // _WIN32
		pWrapperTable->m_KeyStore_GetConsumerCount = (PLib3MFKeyStore_GetConsumerCountPtr) dlsym(hLibrary, "lib3mf_keystore_getconsumercount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_GetConsumerCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_GetConsumer = (PLib3MFKeyStore_GetConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getconsumer");
		#else // _WIN32
		pWrapperTable->m_KeyStore_GetConsumer = (PLib3MFKeyStore_GetConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_getconsumer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_GetConsumer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_RemoveConsumer = (PLib3MFKeyStore_RemoveConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_removeconsumer");
		#else // _WIN32
		pWrapperTable->m_KeyStore_RemoveConsumer = (PLib3MFKeyStore_RemoveConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_removeconsumer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_RemoveConsumer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_FindConsumer = (PLib3MFKeyStore_FindConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_findconsumer");
		#else // _WIN32
		pWrapperTable->m_KeyStore_FindConsumer = (PLib3MFKeyStore_FindConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_findconsumer");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_FindConsumer == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_GetResourceDataGroupCount = (PLib3MFKeyStore_GetResourceDataGroupCountPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedatagroupcount");
		#else // _WIN32
		pWrapperTable->m_KeyStore_GetResourceDataGroupCount = (PLib3MFKeyStore_GetResourceDataGroupCountPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedatagroupcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_GetResourceDataGroupCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_AddResourceDataGroup = (PLib3MFKeyStore_AddResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_addresourcedatagroup");
		#else // _WIN32
		pWrapperTable->m_KeyStore_AddResourceDataGroup = (PLib3MFKeyStore_AddResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_addresourcedatagroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_AddResourceDataGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_GetResourceDataGroup = (PLib3MFKeyStore_GetResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedatagroup");
		#else // _WIN32
		pWrapperTable->m_KeyStore_GetResourceDataGroup = (PLib3MFKeyStore_GetResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedatagroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_GetResourceDataGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_RemoveResourceDataGroup = (PLib3MFKeyStore_RemoveResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_removeresourcedatagroup");
		#else // _WIN32
		pWrapperTable->m_KeyStore_RemoveResourceDataGroup = (PLib3MFKeyStore_RemoveResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_removeresourcedatagroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_RemoveResourceDataGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_FindResourceDataGroup = (PLib3MFKeyStore_FindResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_findresourcedatagroup");
		#else // _WIN32
		pWrapperTable->m_KeyStore_FindResourceDataGroup = (PLib3MFKeyStore_FindResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_findresourcedatagroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_FindResourceDataGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_AddResourceData = (PLib3MFKeyStore_AddResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_addresourcedata");
		#else // _WIN32
		pWrapperTable->m_KeyStore_AddResourceData = (PLib3MFKeyStore_AddResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_addresourcedata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_AddResourceData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_RemoveResourceData = (PLib3MFKeyStore_RemoveResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_removeresourcedata");
		#else // _WIN32
		pWrapperTable->m_KeyStore_RemoveResourceData = (PLib3MFKeyStore_RemoveResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_removeresourcedata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_RemoveResourceData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_FindResourceData = (PLib3MFKeyStore_FindResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_findresourcedata");
		#else // _WIN32
		pWrapperTable->m_KeyStore_FindResourceData = (PLib3MFKeyStore_FindResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_findresourcedata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_FindResourceData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_GetResourceDataCount = (PLib3MFKeyStore_GetResourceDataCountPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedatacount");
		#else // _WIN32
		pWrapperTable->m_KeyStore_GetResourceDataCount = (PLib3MFKeyStore_GetResourceDataCountPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedatacount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_GetResourceDataCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_GetResourceData = (PLib3MFKeyStore_GetResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedata");
		#else // _WIN32
		pWrapperTable->m_KeyStore_GetResourceData = (PLib3MFKeyStore_GetResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_GetResourceData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_GetUUID = (PLib3MFKeyStore_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getuuid");
		#else // _WIN32
		pWrapperTable->m_KeyStore_GetUUID = (PLib3MFKeyStore_GetUUIDPtr) dlsym(hLibrary, "lib3mf_keystore_getuuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_GetUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_KeyStore_SetUUID = (PLib3MFKeyStore_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_keystore_setuuid");
		#else // _WIN32
		pWrapperTable->m_KeyStore_SetUUID = (PLib3MFKeyStore_SetUUIDPtr) dlsym(hLibrary, "lib3mf_keystore_setuuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_KeyStore_SetUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_RootModelPart = (PLib3MFModel_RootModelPartPtr) GetProcAddress(hLibrary, "lib3mf_model_rootmodelpart");
		#else // _WIN32
		pWrapperTable->m_Model_RootModelPart = (PLib3MFModel_RootModelPartPtr) dlsym(hLibrary, "lib3mf_model_rootmodelpart");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_RootModelPart == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_FindOrCreatePackagePart = (PLib3MFModel_FindOrCreatePackagePartPtr) GetProcAddress(hLibrary, "lib3mf_model_findorcreatepackagepart");
		#else // _WIN32
		pWrapperTable->m_Model_FindOrCreatePackagePart = (PLib3MFModel_FindOrCreatePackagePartPtr) dlsym(hLibrary, "lib3mf_model_findorcreatepackagepart");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_FindOrCreatePackagePart == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_SetUnit = (PLib3MFModel_SetUnitPtr) GetProcAddress(hLibrary, "lib3mf_model_setunit");
		#else // _WIN32
		pWrapperTable->m_Model_SetUnit = (PLib3MFModel_SetUnitPtr) dlsym(hLibrary, "lib3mf_model_setunit");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_SetUnit == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetUnit = (PLib3MFModel_GetUnitPtr) GetProcAddress(hLibrary, "lib3mf_model_getunit");
		#else // _WIN32
		pWrapperTable->m_Model_GetUnit = (PLib3MFModel_GetUnitPtr) dlsym(hLibrary, "lib3mf_model_getunit");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetUnit == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetLanguage = (PLib3MFModel_GetLanguagePtr) GetProcAddress(hLibrary, "lib3mf_model_getlanguage");
		#else // _WIN32
		pWrapperTable->m_Model_GetLanguage = (PLib3MFModel_GetLanguagePtr) dlsym(hLibrary, "lib3mf_model_getlanguage");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetLanguage == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_SetLanguage = (PLib3MFModel_SetLanguagePtr) GetProcAddress(hLibrary, "lib3mf_model_setlanguage");
		#else // _WIN32
		pWrapperTable->m_Model_SetLanguage = (PLib3MFModel_SetLanguagePtr) dlsym(hLibrary, "lib3mf_model_setlanguage");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_SetLanguage == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_QueryWriter = (PLib3MFModel_QueryWriterPtr) GetProcAddress(hLibrary, "lib3mf_model_querywriter");
		#else // _WIN32
		pWrapperTable->m_Model_QueryWriter = (PLib3MFModel_QueryWriterPtr) dlsym(hLibrary, "lib3mf_model_querywriter");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_QueryWriter == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_QueryReader = (PLib3MFModel_QueryReaderPtr) GetProcAddress(hLibrary, "lib3mf_model_queryreader");
		#else // _WIN32
		pWrapperTable->m_Model_QueryReader = (PLib3MFModel_QueryReaderPtr) dlsym(hLibrary, "lib3mf_model_queryreader");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_QueryReader == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetResourceByID = (PLib3MFModel_GetResourceByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getresourcebyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetResourceByID = (PLib3MFModel_GetResourceByIDPtr) dlsym(hLibrary, "lib3mf_model_getresourcebyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetResourceByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetTexture2DByID = (PLib3MFModel_GetTexture2DByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2dbyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetTexture2DByID = (PLib3MFModel_GetTexture2DByIDPtr) dlsym(hLibrary, "lib3mf_model_gettexture2dbyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetTexture2DByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetPropertyTypeByID = (PLib3MFModel_GetPropertyTypeByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getpropertytypebyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetPropertyTypeByID = (PLib3MFModel_GetPropertyTypeByIDPtr) dlsym(hLibrary, "lib3mf_model_getpropertytypebyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetPropertyTypeByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetBaseMaterialGroupByID = (PLib3MFModel_GetBaseMaterialGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getbasematerialgroupbyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetBaseMaterialGroupByID = (PLib3MFModel_GetBaseMaterialGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_getbasematerialgroupbyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetBaseMaterialGroupByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetTexture2DGroupByID = (PLib3MFModel_GetTexture2DGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2dgroupbyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetTexture2DGroupByID = (PLib3MFModel_GetTexture2DGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_gettexture2dgroupbyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetTexture2DGroupByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetCompositeMaterialsByID = (PLib3MFModel_GetCompositeMaterialsByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getcompositematerialsbyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetCompositeMaterialsByID = (PLib3MFModel_GetCompositeMaterialsByIDPtr) dlsym(hLibrary, "lib3mf_model_getcompositematerialsbyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetCompositeMaterialsByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetMultiPropertyGroupByID = (PLib3MFModel_GetMultiPropertyGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getmultipropertygroupbyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetMultiPropertyGroupByID = (PLib3MFModel_GetMultiPropertyGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_getmultipropertygroupbyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetMultiPropertyGroupByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetMeshObjectByID = (PLib3MFModel_GetMeshObjectByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getmeshobjectbyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetMeshObjectByID = (PLib3MFModel_GetMeshObjectByIDPtr) dlsym(hLibrary, "lib3mf_model_getmeshobjectbyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetMeshObjectByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetComponentsObjectByID = (PLib3MFModel_GetComponentsObjectByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getcomponentsobjectbyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetComponentsObjectByID = (PLib3MFModel_GetComponentsObjectByIDPtr) dlsym(hLibrary, "lib3mf_model_getcomponentsobjectbyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetComponentsObjectByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetColorGroupByID = (PLib3MFModel_GetColorGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getcolorgroupbyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetColorGroupByID = (PLib3MFModel_GetColorGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_getcolorgroupbyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetColorGroupByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetSliceStackByID = (PLib3MFModel_GetSliceStackByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getslicestackbyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetSliceStackByID = (PLib3MFModel_GetSliceStackByIDPtr) dlsym(hLibrary, "lib3mf_model_getslicestackbyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetSliceStackByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetLevelSetByID = (PLib3MFModel_GetLevelSetByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getlevelsetbyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetLevelSetByID = (PLib3MFModel_GetLevelSetByIDPtr) dlsym(hLibrary, "lib3mf_model_getlevelsetbyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetLevelSetByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetBuildUUID = (PLib3MFModel_GetBuildUUIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getbuilduuid");
		#else // _WIN32
		pWrapperTable->m_Model_GetBuildUUID = (PLib3MFModel_GetBuildUUIDPtr) dlsym(hLibrary, "lib3mf_model_getbuilduuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetBuildUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_SetBuildUUID = (PLib3MFModel_SetBuildUUIDPtr) GetProcAddress(hLibrary, "lib3mf_model_setbuilduuid");
		#else // _WIN32
		pWrapperTable->m_Model_SetBuildUUID = (PLib3MFModel_SetBuildUUIDPtr) dlsym(hLibrary, "lib3mf_model_setbuilduuid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_SetBuildUUID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetBuildItems = (PLib3MFModel_GetBuildItemsPtr) GetProcAddress(hLibrary, "lib3mf_model_getbuilditems");
		#else // _WIN32
		pWrapperTable->m_Model_GetBuildItems = (PLib3MFModel_GetBuildItemsPtr) dlsym(hLibrary, "lib3mf_model_getbuilditems");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetBuildItems == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetOutbox = (PLib3MFModel_GetOutboxPtr) GetProcAddress(hLibrary, "lib3mf_model_getoutbox");
		#else // _WIN32
		pWrapperTable->m_Model_GetOutbox = (PLib3MFModel_GetOutboxPtr) dlsym(hLibrary, "lib3mf_model_getoutbox");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetOutbox == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetResources = (PLib3MFModel_GetResourcesPtr) GetProcAddress(hLibrary, "lib3mf_model_getresources");
		#else // _WIN32
		pWrapperTable->m_Model_GetResources = (PLib3MFModel_GetResourcesPtr) dlsym(hLibrary, "lib3mf_model_getresources");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetResources == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetObjects = (PLib3MFModel_GetObjectsPtr) GetProcAddress(hLibrary, "lib3mf_model_getobjects");
		#else // _WIN32
		pWrapperTable->m_Model_GetObjects = (PLib3MFModel_GetObjectsPtr) dlsym(hLibrary, "lib3mf_model_getobjects");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetObjects == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetMeshObjects = (PLib3MFModel_GetMeshObjectsPtr) GetProcAddress(hLibrary, "lib3mf_model_getmeshobjects");
		#else // _WIN32
		pWrapperTable->m_Model_GetMeshObjects = (PLib3MFModel_GetMeshObjectsPtr) dlsym(hLibrary, "lib3mf_model_getmeshobjects");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetMeshObjects == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetComponentsObjects = (PLib3MFModel_GetComponentsObjectsPtr) GetProcAddress(hLibrary, "lib3mf_model_getcomponentsobjects");
		#else // _WIN32
		pWrapperTable->m_Model_GetComponentsObjects = (PLib3MFModel_GetComponentsObjectsPtr) dlsym(hLibrary, "lib3mf_model_getcomponentsobjects");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetComponentsObjects == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetTexture2Ds = (PLib3MFModel_GetTexture2DsPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2ds");
		#else // _WIN32
		pWrapperTable->m_Model_GetTexture2Ds = (PLib3MFModel_GetTexture2DsPtr) dlsym(hLibrary, "lib3mf_model_gettexture2ds");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetTexture2Ds == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetBaseMaterialGroups = (PLib3MFModel_GetBaseMaterialGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_getbasematerialgroups");
		#else // _WIN32
		pWrapperTable->m_Model_GetBaseMaterialGroups = (PLib3MFModel_GetBaseMaterialGroupsPtr) dlsym(hLibrary, "lib3mf_model_getbasematerialgroups");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetBaseMaterialGroups == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetColorGroups = (PLib3MFModel_GetColorGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_getcolorgroups");
		#else // _WIN32
		pWrapperTable->m_Model_GetColorGroups = (PLib3MFModel_GetColorGroupsPtr) dlsym(hLibrary, "lib3mf_model_getcolorgroups");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetColorGroups == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetTexture2DGroups = (PLib3MFModel_GetTexture2DGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2dgroups");
		#else // _WIN32
		pWrapperTable->m_Model_GetTexture2DGroups = (PLib3MFModel_GetTexture2DGroupsPtr) dlsym(hLibrary, "lib3mf_model_gettexture2dgroups");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetTexture2DGroups == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetCompositeMaterials = (PLib3MFModel_GetCompositeMaterialsPtr) GetProcAddress(hLibrary, "lib3mf_model_getcompositematerials");
		#else // _WIN32
		pWrapperTable->m_Model_GetCompositeMaterials = (PLib3MFModel_GetCompositeMaterialsPtr) dlsym(hLibrary, "lib3mf_model_getcompositematerials");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetCompositeMaterials == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetMultiPropertyGroups = (PLib3MFModel_GetMultiPropertyGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_getmultipropertygroups");
		#else // _WIN32
		pWrapperTable->m_Model_GetMultiPropertyGroups = (PLib3MFModel_GetMultiPropertyGroupsPtr) dlsym(hLibrary, "lib3mf_model_getmultipropertygroups");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetMultiPropertyGroups == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetSliceStacks = (PLib3MFModel_GetSliceStacksPtr) GetProcAddress(hLibrary, "lib3mf_model_getslicestacks");
		#else // _WIN32
		pWrapperTable->m_Model_GetSliceStacks = (PLib3MFModel_GetSliceStacksPtr) dlsym(hLibrary, "lib3mf_model_getslicestacks");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetSliceStacks == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetImage3Ds = (PLib3MFModel_GetImage3DsPtr) GetProcAddress(hLibrary, "lib3mf_model_getimage3ds");
		#else // _WIN32
		pWrapperTable->m_Model_GetImage3Ds = (PLib3MFModel_GetImage3DsPtr) dlsym(hLibrary, "lib3mf_model_getimage3ds");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetImage3Ds == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_MergeToModel = (PLib3MFModel_MergeToModelPtr) GetProcAddress(hLibrary, "lib3mf_model_mergetomodel");
		#else // _WIN32
		pWrapperTable->m_Model_MergeToModel = (PLib3MFModel_MergeToModelPtr) dlsym(hLibrary, "lib3mf_model_mergetomodel");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_MergeToModel == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_MergeFromModel = (PLib3MFModel_MergeFromModelPtr) GetProcAddress(hLibrary, "lib3mf_model_mergefrommodel");
		#else // _WIN32
		pWrapperTable->m_Model_MergeFromModel = (PLib3MFModel_MergeFromModelPtr) dlsym(hLibrary, "lib3mf_model_mergefrommodel");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_MergeFromModel == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddMeshObject = (PLib3MFModel_AddMeshObjectPtr) GetProcAddress(hLibrary, "lib3mf_model_addmeshobject");
		#else // _WIN32
		pWrapperTable->m_Model_AddMeshObject = (PLib3MFModel_AddMeshObjectPtr) dlsym(hLibrary, "lib3mf_model_addmeshobject");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddMeshObject == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddComponentsObject = (PLib3MFModel_AddComponentsObjectPtr) GetProcAddress(hLibrary, "lib3mf_model_addcomponentsobject");
		#else // _WIN32
		pWrapperTable->m_Model_AddComponentsObject = (PLib3MFModel_AddComponentsObjectPtr) dlsym(hLibrary, "lib3mf_model_addcomponentsobject");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddComponentsObject == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddSliceStack = (PLib3MFModel_AddSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_model_addslicestack");
		#else // _WIN32
		pWrapperTable->m_Model_AddSliceStack = (PLib3MFModel_AddSliceStackPtr) dlsym(hLibrary, "lib3mf_model_addslicestack");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddSliceStack == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddTexture2DFromAttachment = (PLib3MFModel_AddTexture2DFromAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_addtexture2dfromattachment");
		#else // _WIN32
		pWrapperTable->m_Model_AddTexture2DFromAttachment = (PLib3MFModel_AddTexture2DFromAttachmentPtr) dlsym(hLibrary, "lib3mf_model_addtexture2dfromattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddTexture2DFromAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddBaseMaterialGroup = (PLib3MFModel_AddBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addbasematerialgroup");
		#else // _WIN32
		pWrapperTable->m_Model_AddBaseMaterialGroup = (PLib3MFModel_AddBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_model_addbasematerialgroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddBaseMaterialGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddColorGroup = (PLib3MFModel_AddColorGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addcolorgroup");
		#else // _WIN32
		pWrapperTable->m_Model_AddColorGroup = (PLib3MFModel_AddColorGroupPtr) dlsym(hLibrary, "lib3mf_model_addcolorgroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddColorGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddTexture2DGroup = (PLib3MFModel_AddTexture2DGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addtexture2dgroup");
		#else // _WIN32
		pWrapperTable->m_Model_AddTexture2DGroup = (PLib3MFModel_AddTexture2DGroupPtr) dlsym(hLibrary, "lib3mf_model_addtexture2dgroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddTexture2DGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddCompositeMaterials = (PLib3MFModel_AddCompositeMaterialsPtr) GetProcAddress(hLibrary, "lib3mf_model_addcompositematerials");
		#else // _WIN32
		pWrapperTable->m_Model_AddCompositeMaterials = (PLib3MFModel_AddCompositeMaterialsPtr) dlsym(hLibrary, "lib3mf_model_addcompositematerials");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddCompositeMaterials == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddMultiPropertyGroup = (PLib3MFModel_AddMultiPropertyGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addmultipropertygroup");
		#else // _WIN32
		pWrapperTable->m_Model_AddMultiPropertyGroup = (PLib3MFModel_AddMultiPropertyGroupPtr) dlsym(hLibrary, "lib3mf_model_addmultipropertygroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddMultiPropertyGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddImageStack = (PLib3MFModel_AddImageStackPtr) GetProcAddress(hLibrary, "lib3mf_model_addimagestack");
		#else // _WIN32
		pWrapperTable->m_Model_AddImageStack = (PLib3MFModel_AddImageStackPtr) dlsym(hLibrary, "lib3mf_model_addimagestack");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddImageStack == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetImageStackByID = (PLib3MFModel_GetImageStackByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getimagestackbyid");
		#else // _WIN32
		pWrapperTable->m_Model_GetImageStackByID = (PLib3MFModel_GetImageStackByIDPtr) dlsym(hLibrary, "lib3mf_model_getimagestackbyid");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetImageStackByID == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddBuildItem = (PLib3MFModel_AddBuildItemPtr) GetProcAddress(hLibrary, "lib3mf_model_addbuilditem");
		#else // _WIN32
		pWrapperTable->m_Model_AddBuildItem = (PLib3MFModel_AddBuildItemPtr) dlsym(hLibrary, "lib3mf_model_addbuilditem");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddBuildItem == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_RemoveBuildItem = (PLib3MFModel_RemoveBuildItemPtr) GetProcAddress(hLibrary, "lib3mf_model_removebuilditem");
		#else // _WIN32
		pWrapperTable->m_Model_RemoveBuildItem = (PLib3MFModel_RemoveBuildItemPtr) dlsym(hLibrary, "lib3mf_model_removebuilditem");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_RemoveBuildItem == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetMetaDataGroup = (PLib3MFModel_GetMetaDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_getmetadatagroup");
		#else // _WIN32
		pWrapperTable->m_Model_GetMetaDataGroup = (PLib3MFModel_GetMetaDataGroupPtr) dlsym(hLibrary, "lib3mf_model_getmetadatagroup");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetMetaDataGroup == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddAttachment = (PLib3MFModel_AddAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_addattachment");
		#else // _WIN32
		pWrapperTable->m_Model_AddAttachment = (PLib3MFModel_AddAttachmentPtr) dlsym(hLibrary, "lib3mf_model_addattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_RemoveAttachment = (PLib3MFModel_RemoveAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_removeattachment");
		#else // _WIN32
		pWrapperTable->m_Model_RemoveAttachment = (PLib3MFModel_RemoveAttachmentPtr) dlsym(hLibrary, "lib3mf_model_removeattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_RemoveAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetAttachment = (PLib3MFModel_GetAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_getattachment");
		#else // _WIN32
		pWrapperTable->m_Model_GetAttachment = (PLib3MFModel_GetAttachmentPtr) dlsym(hLibrary, "lib3mf_model_getattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_FindAttachment = (PLib3MFModel_FindAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_findattachment");
		#else // _WIN32
		pWrapperTable->m_Model_FindAttachment = (PLib3MFModel_FindAttachmentPtr) dlsym(hLibrary, "lib3mf_model_findattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_FindAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetAttachmentCount = (PLib3MFModel_GetAttachmentCountPtr) GetProcAddress(hLibrary, "lib3mf_model_getattachmentcount");
		#else // _WIN32
		pWrapperTable->m_Model_GetAttachmentCount = (PLib3MFModel_GetAttachmentCountPtr) dlsym(hLibrary, "lib3mf_model_getattachmentcount");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetAttachmentCount == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_HasPackageThumbnailAttachment = (PLib3MFModel_HasPackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_haspackagethumbnailattachment");
		#else // _WIN32
		pWrapperTable->m_Model_HasPackageThumbnailAttachment = (PLib3MFModel_HasPackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_haspackagethumbnailattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_HasPackageThumbnailAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_CreatePackageThumbnailAttachment = (PLib3MFModel_CreatePackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_createpackagethumbnailattachment");
		#else // _WIN32
		pWrapperTable->m_Model_CreatePackageThumbnailAttachment = (PLib3MFModel_CreatePackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_createpackagethumbnailattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_CreatePackageThumbnailAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetPackageThumbnailAttachment = (PLib3MFModel_GetPackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_getpackagethumbnailattachment");
		#else // _WIN32
		pWrapperTable->m_Model_GetPackageThumbnailAttachment = (PLib3MFModel_GetPackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_getpackagethumbnailattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetPackageThumbnailAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_RemovePackageThumbnailAttachment = (PLib3MFModel_RemovePackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_removepackagethumbnailattachment");
		#else // _WIN32
		pWrapperTable->m_Model_RemovePackageThumbnailAttachment = (PLib3MFModel_RemovePackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_removepackagethumbnailattachment");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_RemovePackageThumbnailAttachment == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddCustomContentType = (PLib3MFModel_AddCustomContentTypePtr) GetProcAddress(hLibrary, "lib3mf_model_addcustomcontenttype");
		#else // _WIN32
		pWrapperTable->m_Model_AddCustomContentType = (PLib3MFModel_AddCustomContentTypePtr) dlsym(hLibrary, "lib3mf_model_addcustomcontenttype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddCustomContentType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_RemoveCustomContentType = (PLib3MFModel_RemoveCustomContentTypePtr) GetProcAddress(hLibrary, "lib3mf_model_removecustomcontenttype");
		#else // _WIN32
		pWrapperTable->m_Model_RemoveCustomContentType = (PLib3MFModel_RemoveCustomContentTypePtr) dlsym(hLibrary, "lib3mf_model_removecustomcontenttype");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_RemoveCustomContentType == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_SetRandomNumberCallback = (PLib3MFModel_SetRandomNumberCallbackPtr) GetProcAddress(hLibrary, "lib3mf_model_setrandomnumbercallback");
		#else // _WIN32
		pWrapperTable->m_Model_SetRandomNumberCallback = (PLib3MFModel_SetRandomNumberCallbackPtr) dlsym(hLibrary, "lib3mf_model_setrandomnumbercallback");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_SetRandomNumberCallback == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetKeyStore = (PLib3MFModel_GetKeyStorePtr) GetProcAddress(hLibrary, "lib3mf_model_getkeystore");
		#else // _WIN32
		pWrapperTable->m_Model_GetKeyStore = (PLib3MFModel_GetKeyStorePtr) dlsym(hLibrary, "lib3mf_model_getkeystore");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetKeyStore == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetFunctions = (PLib3MFModel_GetFunctionsPtr) GetProcAddress(hLibrary, "lib3mf_model_getfunctions");
		#else // _WIN32
		pWrapperTable->m_Model_GetFunctions = (PLib3MFModel_GetFunctionsPtr) dlsym(hLibrary, "lib3mf_model_getfunctions");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetFunctions == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddImplicitFunction = (PLib3MFModel_AddImplicitFunctionPtr) GetProcAddress(hLibrary, "lib3mf_model_addimplicitfunction");
		#else // _WIN32
		pWrapperTable->m_Model_AddImplicitFunction = (PLib3MFModel_AddImplicitFunctionPtr) dlsym(hLibrary, "lib3mf_model_addimplicitfunction");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddImplicitFunction == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddFunctionFromImage3D = (PLib3MFModel_AddFunctionFromImage3DPtr) GetProcAddress(hLibrary, "lib3mf_model_addfunctionfromimage3d");
		#else // _WIN32
		pWrapperTable->m_Model_AddFunctionFromImage3D = (PLib3MFModel_AddFunctionFromImage3DPtr) dlsym(hLibrary, "lib3mf_model_addfunctionfromimage3d");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddFunctionFromImage3D == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddVolumeData = (PLib3MFModel_AddVolumeDataPtr) GetProcAddress(hLibrary, "lib3mf_model_addvolumedata");
		#else // _WIN32
		pWrapperTable->m_Model_AddVolumeData = (PLib3MFModel_AddVolumeDataPtr) dlsym(hLibrary, "lib3mf_model_addvolumedata");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddVolumeData == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_AddLevelSet = (PLib3MFModel_AddLevelSetPtr) GetProcAddress(hLibrary, "lib3mf_model_addlevelset");
		#else // _WIN32
		pWrapperTable->m_Model_AddLevelSet = (PLib3MFModel_AddLevelSetPtr) dlsym(hLibrary, "lib3mf_model_addlevelset");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_AddLevelSet == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_GetLevelSets = (PLib3MFModel_GetLevelSetsPtr) GetProcAddress(hLibrary, "lib3mf_model_getlevelsets");
		#else // _WIN32
		pWrapperTable->m_Model_GetLevelSets = (PLib3MFModel_GetLevelSetsPtr) dlsym(hLibrary, "lib3mf_model_getlevelsets");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_GetLevelSets == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Model_RemoveResource = (PLib3MFModel_RemoveResourcePtr) GetProcAddress(hLibrary, "lib3mf_model_removeresource");
		#else // _WIN32
		pWrapperTable->m_Model_RemoveResource = (PLib3MFModel_RemoveResourcePtr) dlsym(hLibrary, "lib3mf_model_removeresource");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Model_RemoveResource == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_GetLibraryVersion = (PLib3MFGetLibraryVersionPtr) GetProcAddress(hLibrary, "lib3mf_getlibraryversion");
		#else // _WIN32
		pWrapperTable->m_GetLibraryVersion = (PLib3MFGetLibraryVersionPtr) dlsym(hLibrary, "lib3mf_getlibraryversion");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_GetLibraryVersion == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_GetPrereleaseInformation = (PLib3MFGetPrereleaseInformationPtr) GetProcAddress(hLibrary, "lib3mf_getprereleaseinformation");
		#else // _WIN32
		pWrapperTable->m_GetPrereleaseInformation = (PLib3MFGetPrereleaseInformationPtr) dlsym(hLibrary, "lib3mf_getprereleaseinformation");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_GetPrereleaseInformation == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_GetBuildInformation = (PLib3MFGetBuildInformationPtr) GetProcAddress(hLibrary, "lib3mf_getbuildinformation");
		#else // _WIN32
		pWrapperTable->m_GetBuildInformation = (PLib3MFGetBuildInformationPtr) dlsym(hLibrary, "lib3mf_getbuildinformation");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_GetBuildInformation == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_GetSpecificationVersion = (PLib3MFGetSpecificationVersionPtr) GetProcAddress(hLibrary, "lib3mf_getspecificationversion");
		#else // _WIN32
		pWrapperTable->m_GetSpecificationVersion = (PLib3MFGetSpecificationVersionPtr) dlsym(hLibrary, "lib3mf_getspecificationversion");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_GetSpecificationVersion == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_CreateModel = (PLib3MFCreateModelPtr) GetProcAddress(hLibrary, "lib3mf_createmodel");
		#else // _WIN32
		pWrapperTable->m_CreateModel = (PLib3MFCreateModelPtr) dlsym(hLibrary, "lib3mf_createmodel");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_CreateModel == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Release = (PLib3MFReleasePtr) GetProcAddress(hLibrary, "lib3mf_release");
		#else // _WIN32
		pWrapperTable->m_Release = (PLib3MFReleasePtr) dlsym(hLibrary, "lib3mf_release");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Release == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_Acquire = (PLib3MFAcquirePtr) GetProcAddress(hLibrary, "lib3mf_acquire");
		#else // _WIN32
		pWrapperTable->m_Acquire = (PLib3MFAcquirePtr) dlsym(hLibrary, "lib3mf_acquire");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_Acquire == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_SetJournal = (PLib3MFSetJournalPtr) GetProcAddress(hLibrary, "lib3mf_setjournal");
		#else // _WIN32
		pWrapperTable->m_SetJournal = (PLib3MFSetJournalPtr) dlsym(hLibrary, "lib3mf_setjournal");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_SetJournal == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_GetLastError = (PLib3MFGetLastErrorPtr) GetProcAddress(hLibrary, "lib3mf_getlasterror");
		#else // _WIN32
		pWrapperTable->m_GetLastError = (PLib3MFGetLastErrorPtr) dlsym(hLibrary, "lib3mf_getlasterror");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_GetLastError == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_GetSymbolLookupMethod = (PLib3MFGetSymbolLookupMethodPtr) GetProcAddress(hLibrary, "lib3mf_getsymbollookupmethod");
		#else // _WIN32
		pWrapperTable->m_GetSymbolLookupMethod = (PLib3MFGetSymbolLookupMethodPtr) dlsym(hLibrary, "lib3mf_getsymbollookupmethod");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_GetSymbolLookupMethod == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_RetrieveProgressMessage = (PLib3MFRetrieveProgressMessagePtr) GetProcAddress(hLibrary, "lib3mf_retrieveprogressmessage");
		#else // _WIN32
		pWrapperTable->m_RetrieveProgressMessage = (PLib3MFRetrieveProgressMessagePtr) dlsym(hLibrary, "lib3mf_retrieveprogressmessage");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_RetrieveProgressMessage == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_RGBAToColor = (PLib3MFRGBAToColorPtr) GetProcAddress(hLibrary, "lib3mf_rgbatocolor");
		#else // _WIN32
		pWrapperTable->m_RGBAToColor = (PLib3MFRGBAToColorPtr) dlsym(hLibrary, "lib3mf_rgbatocolor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_RGBAToColor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_FloatRGBAToColor = (PLib3MFFloatRGBAToColorPtr) GetProcAddress(hLibrary, "lib3mf_floatrgbatocolor");
		#else // _WIN32
		pWrapperTable->m_FloatRGBAToColor = (PLib3MFFloatRGBAToColorPtr) dlsym(hLibrary, "lib3mf_floatrgbatocolor");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_FloatRGBAToColor == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ColorToRGBA = (PLib3MFColorToRGBAPtr) GetProcAddress(hLibrary, "lib3mf_colortorgba");
		#else // _WIN32
		pWrapperTable->m_ColorToRGBA = (PLib3MFColorToRGBAPtr) dlsym(hLibrary, "lib3mf_colortorgba");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ColorToRGBA == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_ColorToFloatRGBA = (PLib3MFColorToFloatRGBAPtr) GetProcAddress(hLibrary, "lib3mf_colortofloatrgba");
		#else // _WIN32
		pWrapperTable->m_ColorToFloatRGBA = (PLib3MFColorToFloatRGBAPtr) dlsym(hLibrary, "lib3mf_colortofloatrgba");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_ColorToFloatRGBA == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_GetIdentityTransform = (PLib3MFGetIdentityTransformPtr) GetProcAddress(hLibrary, "lib3mf_getidentitytransform");
		#else // _WIN32
		pWrapperTable->m_GetIdentityTransform = (PLib3MFGetIdentityTransformPtr) dlsym(hLibrary, "lib3mf_getidentitytransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_GetIdentityTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_GetUniformScaleTransform = (PLib3MFGetUniformScaleTransformPtr) GetProcAddress(hLibrary, "lib3mf_getuniformscaletransform");
		#else // _WIN32
		pWrapperTable->m_GetUniformScaleTransform = (PLib3MFGetUniformScaleTransformPtr) dlsym(hLibrary, "lib3mf_getuniformscaletransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_GetUniformScaleTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_GetScaleTransform = (PLib3MFGetScaleTransformPtr) GetProcAddress(hLibrary, "lib3mf_getscaletransform");
		#else // _WIN32
		pWrapperTable->m_GetScaleTransform = (PLib3MFGetScaleTransformPtr) dlsym(hLibrary, "lib3mf_getscaletransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_GetScaleTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		#ifdef _WIN32
		pWrapperTable->m_GetTranslationTransform = (PLib3MFGetTranslationTransformPtr) GetProcAddress(hLibrary, "lib3mf_gettranslationtransform");
		#else // _WIN32
		pWrapperTable->m_GetTranslationTransform = (PLib3MFGetTranslationTransformPtr) dlsym(hLibrary, "lib3mf_gettranslationtransform");
		dlerror();
		#endif // _WIN32
		if (pWrapperTable->m_GetTranslationTransform == nullptr)
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		pWrapperTable->m_LibraryHandle = hLibrary;
		return LIB3MF_SUCCESS;
	}
	
	inline Lib3MFResult CWrapper::loadWrapperTableFromSymbolLookupMethod(sLib3MFDynamicWrapperTable * pWrapperTable, void* pSymbolLookupMethod)
	{
		if (pWrapperTable == nullptr)
			return LIB3MF_ERROR_INVALIDPARAM;
		if (pSymbolLookupMethod == nullptr)
			return LIB3MF_ERROR_INVALIDPARAM;
		
		typedef Lib3MFResult(*SymbolLookupType)(const char*, void**);
		
		SymbolLookupType pLookup = (SymbolLookupType)pSymbolLookupMethod;
		
		Lib3MFResult eLookupError = LIB3MF_SUCCESS;
		eLookupError = (*pLookup)("lib3mf_base_classtypeid", (void**)&(pWrapperTable->m_Base_ClassTypeId));
		if ( (eLookupError != 0) || (pWrapperTable->m_Base_ClassTypeId == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_writetofile", (void**)&(pWrapperTable->m_Writer_WriteToFile));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_WriteToFile == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_getstreamsize", (void**)&(pWrapperTable->m_Writer_GetStreamSize));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_GetStreamSize == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_writetobuffer", (void**)&(pWrapperTable->m_Writer_WriteToBuffer));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_WriteToBuffer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_writetocallback", (void**)&(pWrapperTable->m_Writer_WriteToCallback));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_WriteToCallback == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_setprogresscallback", (void**)&(pWrapperTable->m_Writer_SetProgressCallback));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_SetProgressCallback == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_getdecimalprecision", (void**)&(pWrapperTable->m_Writer_GetDecimalPrecision));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_GetDecimalPrecision == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_setdecimalprecision", (void**)&(pWrapperTable->m_Writer_SetDecimalPrecision));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_SetDecimalPrecision == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_setstrictmodeactive", (void**)&(pWrapperTable->m_Writer_SetStrictModeActive));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_SetStrictModeActive == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_getstrictmodeactive", (void**)&(pWrapperTable->m_Writer_GetStrictModeActive));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_GetStrictModeActive == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_getwarning", (void**)&(pWrapperTable->m_Writer_GetWarning));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_GetWarning == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_getwarningcount", (void**)&(pWrapperTable->m_Writer_GetWarningCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_GetWarningCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_addkeywrappingcallback", (void**)&(pWrapperTable->m_Writer_AddKeyWrappingCallback));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_AddKeyWrappingCallback == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_writer_setcontentencryptioncallback", (void**)&(pWrapperTable->m_Writer_SetContentEncryptionCallback));
		if ( (eLookupError != 0) || (pWrapperTable->m_Writer_SetContentEncryptionCallback == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_readfromfile", (void**)&(pWrapperTable->m_Reader_ReadFromFile));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_ReadFromFile == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_readfrombuffer", (void**)&(pWrapperTable->m_Reader_ReadFromBuffer));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_ReadFromBuffer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_readfromcallback", (void**)&(pWrapperTable->m_Reader_ReadFromCallback));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_ReadFromCallback == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_setprogresscallback", (void**)&(pWrapperTable->m_Reader_SetProgressCallback));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_SetProgressCallback == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_addrelationtoread", (void**)&(pWrapperTable->m_Reader_AddRelationToRead));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_AddRelationToRead == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_removerelationtoread", (void**)&(pWrapperTable->m_Reader_RemoveRelationToRead));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_RemoveRelationToRead == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_setstrictmodeactive", (void**)&(pWrapperTable->m_Reader_SetStrictModeActive));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_SetStrictModeActive == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_getstrictmodeactive", (void**)&(pWrapperTable->m_Reader_GetStrictModeActive));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_GetStrictModeActive == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_getwarning", (void**)&(pWrapperTable->m_Reader_GetWarning));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_GetWarning == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_getwarningcount", (void**)&(pWrapperTable->m_Reader_GetWarningCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_GetWarningCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_addkeywrappingcallback", (void**)&(pWrapperTable->m_Reader_AddKeyWrappingCallback));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_AddKeyWrappingCallback == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_reader_setcontentencryptioncallback", (void**)&(pWrapperTable->m_Reader_SetContentEncryptionCallback));
		if ( (eLookupError != 0) || (pWrapperTable->m_Reader_SetContentEncryptionCallback == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_packagepart_getpath", (void**)&(pWrapperTable->m_PackagePart_GetPath));
		if ( (eLookupError != 0) || (pWrapperTable->m_PackagePart_GetPath == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_packagepart_setpath", (void**)&(pWrapperTable->m_PackagePart_SetPath));
		if ( (eLookupError != 0) || (pWrapperTable->m_PackagePart_SetPath == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resource_getresourceid", (void**)&(pWrapperTable->m_Resource_GetResourceID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Resource_GetResourceID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resource_getuniqueresourceid", (void**)&(pWrapperTable->m_Resource_GetUniqueResourceID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Resource_GetUniqueResourceID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resource_packagepart", (void**)&(pWrapperTable->m_Resource_PackagePart));
		if ( (eLookupError != 0) || (pWrapperTable->m_Resource_PackagePart == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resource_setpackagepart", (void**)&(pWrapperTable->m_Resource_SetPackagePart));
		if ( (eLookupError != 0) || (pWrapperTable->m_Resource_SetPackagePart == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resource_getmodelresourceid", (void**)&(pWrapperTable->m_Resource_GetModelResourceID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Resource_GetModelResourceID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourceiterator_movenext", (void**)&(pWrapperTable->m_ResourceIterator_MoveNext));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceIterator_MoveNext == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourceiterator_moveprevious", (void**)&(pWrapperTable->m_ResourceIterator_MovePrevious));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceIterator_MovePrevious == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourceiterator_getcurrent", (void**)&(pWrapperTable->m_ResourceIterator_GetCurrent));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceIterator_GetCurrent == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourceiterator_clone", (void**)&(pWrapperTable->m_ResourceIterator_Clone));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceIterator_Clone == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourceiterator_count", (void**)&(pWrapperTable->m_ResourceIterator_Count));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceIterator_Count == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slicestackiterator_getcurrentslicestack", (void**)&(pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack));
		if ( (eLookupError != 0) || (pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_objectiterator_getcurrentobject", (void**)&(pWrapperTable->m_ObjectIterator_GetCurrentObject));
		if ( (eLookupError != 0) || (pWrapperTable->m_ObjectIterator_GetCurrentObject == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobjectiterator_getcurrentmeshobject", (void**)&(pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_componentsobjectiterator_getcurrentcomponentsobject", (void**)&(pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2diterator_getcurrenttexture2d", (void**)&(pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup", (void**)&(pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_colorgroupiterator_getcurrentcolorgroup", (void**)&(pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup", (void**)&(pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_compositematerialsiterator_getcurrentcompositematerials", (void**)&(pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials));
		if ( (eLookupError != 0) || (pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup", (void**)&(pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_image3diterator_getcurrentimage3d", (void**)&(pWrapperTable->m_Image3DIterator_GetCurrentImage3D));
		if ( (eLookupError != 0) || (pWrapperTable->m_Image3DIterator_GetCurrentImage3D == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functioniterator_getcurrentfunction", (void**)&(pWrapperTable->m_FunctionIterator_GetCurrentFunction));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionIterator_GetCurrentFunction == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelsetiterator_getcurrentlevelset", (void**)&(pWrapperTable->m_LevelSetIterator_GetCurrentLevelSet));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSetIterator_GetCurrentLevelSet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadata_getnamespace", (void**)&(pWrapperTable->m_MetaData_GetNameSpace));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaData_GetNameSpace == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadata_setnamespace", (void**)&(pWrapperTable->m_MetaData_SetNameSpace));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaData_SetNameSpace == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadata_getname", (void**)&(pWrapperTable->m_MetaData_GetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaData_GetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadata_setname", (void**)&(pWrapperTable->m_MetaData_SetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaData_SetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadata_getkey", (void**)&(pWrapperTable->m_MetaData_GetKey));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaData_GetKey == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadata_getmustpreserve", (void**)&(pWrapperTable->m_MetaData_GetMustPreserve));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaData_GetMustPreserve == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadata_setmustpreserve", (void**)&(pWrapperTable->m_MetaData_SetMustPreserve));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaData_SetMustPreserve == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadata_gettype", (void**)&(pWrapperTable->m_MetaData_GetType));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaData_GetType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadata_settype", (void**)&(pWrapperTable->m_MetaData_SetType));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaData_SetType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadata_getvalue", (void**)&(pWrapperTable->m_MetaData_GetValue));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaData_GetValue == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadata_setvalue", (void**)&(pWrapperTable->m_MetaData_SetValue));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaData_SetValue == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadatagroup_getmetadatacount", (void**)&(pWrapperTable->m_MetaDataGroup_GetMetaDataCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaDataGroup_GetMetaDataCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadatagroup_getmetadata", (void**)&(pWrapperTable->m_MetaDataGroup_GetMetaData));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaDataGroup_GetMetaData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadatagroup_getmetadatabykey", (void**)&(pWrapperTable->m_MetaDataGroup_GetMetaDataByKey));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaDataGroup_GetMetaDataByKey == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadatagroup_removemetadatabyindex", (void**)&(pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadatagroup_removemetadata", (void**)&(pWrapperTable->m_MetaDataGroup_RemoveMetaData));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaDataGroup_RemoveMetaData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_metadatagroup_addmetadata", (void**)&(pWrapperTable->m_MetaDataGroup_AddMetaData));
		if ( (eLookupError != 0) || (pWrapperTable->m_MetaDataGroup_AddMetaData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_setname", (void**)&(pWrapperTable->m_TriangleSet_SetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_SetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_getname", (void**)&(pWrapperTable->m_TriangleSet_GetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_GetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_setidentifier", (void**)&(pWrapperTable->m_TriangleSet_SetIdentifier));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_SetIdentifier == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_getidentifier", (void**)&(pWrapperTable->m_TriangleSet_GetIdentifier));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_GetIdentifier == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_addtriangle", (void**)&(pWrapperTable->m_TriangleSet_AddTriangle));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_AddTriangle == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_removetriangle", (void**)&(pWrapperTable->m_TriangleSet_RemoveTriangle));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_RemoveTriangle == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_clear", (void**)&(pWrapperTable->m_TriangleSet_Clear));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_Clear == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_settrianglelist", (void**)&(pWrapperTable->m_TriangleSet_SetTriangleList));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_SetTriangleList == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_gettrianglelist", (void**)&(pWrapperTable->m_TriangleSet_GetTriangleList));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_GetTriangleList == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_addtrianglelist", (void**)&(pWrapperTable->m_TriangleSet_AddTriangleList));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_AddTriangleList == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_merge", (void**)&(pWrapperTable->m_TriangleSet_Merge));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_Merge == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_deleteset", (void**)&(pWrapperTable->m_TriangleSet_DeleteSet));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_DeleteSet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_triangleset_duplicate", (void**)&(pWrapperTable->m_TriangleSet_Duplicate));
		if ( (eLookupError != 0) || (pWrapperTable->m_TriangleSet_Duplicate == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_gettype", (void**)&(pWrapperTable->m_Object_GetType));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_GetType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_settype", (void**)&(pWrapperTable->m_Object_SetType));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_SetType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_getname", (void**)&(pWrapperTable->m_Object_GetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_GetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_setname", (void**)&(pWrapperTable->m_Object_SetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_SetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_getpartnumber", (void**)&(pWrapperTable->m_Object_GetPartNumber));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_GetPartNumber == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_setpartnumber", (void**)&(pWrapperTable->m_Object_SetPartNumber));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_SetPartNumber == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_ismeshobject", (void**)&(pWrapperTable->m_Object_IsMeshObject));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_IsMeshObject == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_iscomponentsobject", (void**)&(pWrapperTable->m_Object_IsComponentsObject));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_IsComponentsObject == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_islevelsetobject", (void**)&(pWrapperTable->m_Object_IsLevelSetObject));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_IsLevelSetObject == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_isvalid", (void**)&(pWrapperTable->m_Object_IsValid));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_IsValid == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_setattachmentasthumbnail", (void**)&(pWrapperTable->m_Object_SetAttachmentAsThumbnail));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_SetAttachmentAsThumbnail == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_getthumbnailattachment", (void**)&(pWrapperTable->m_Object_GetThumbnailAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_GetThumbnailAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_clearthumbnailattachment", (void**)&(pWrapperTable->m_Object_ClearThumbnailAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_ClearThumbnailAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_getoutbox", (void**)&(pWrapperTable->m_Object_GetOutbox));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_GetOutbox == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_getuuid", (void**)&(pWrapperTable->m_Object_GetUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_GetUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_setuuid", (void**)&(pWrapperTable->m_Object_SetUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_SetUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_getmetadatagroup", (void**)&(pWrapperTable->m_Object_GetMetaDataGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_GetMetaDataGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_setslicesmeshresolution", (void**)&(pWrapperTable->m_Object_SetSlicesMeshResolution));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_SetSlicesMeshResolution == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_getslicesmeshresolution", (void**)&(pWrapperTable->m_Object_GetSlicesMeshResolution));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_GetSlicesMeshResolution == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_hasslices", (void**)&(pWrapperTable->m_Object_HasSlices));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_HasSlices == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_clearslicestack", (void**)&(pWrapperTable->m_Object_ClearSliceStack));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_ClearSliceStack == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_getslicestack", (void**)&(pWrapperTable->m_Object_GetSliceStack));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_GetSliceStack == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_object_assignslicestack", (void**)&(pWrapperTable->m_Object_AssignSliceStack));
		if ( (eLookupError != 0) || (pWrapperTable->m_Object_AssignSliceStack == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_getvertexcount", (void**)&(pWrapperTable->m_MeshObject_GetVertexCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetVertexCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_gettrianglecount", (void**)&(pWrapperTable->m_MeshObject_GetTriangleCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetTriangleCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_getvertex", (void**)&(pWrapperTable->m_MeshObject_GetVertex));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetVertex == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_setvertex", (void**)&(pWrapperTable->m_MeshObject_SetVertex));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_SetVertex == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_addvertex", (void**)&(pWrapperTable->m_MeshObject_AddVertex));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_AddVertex == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_getvertices", (void**)&(pWrapperTable->m_MeshObject_GetVertices));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetVertices == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_gettriangle", (void**)&(pWrapperTable->m_MeshObject_GetTriangle));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetTriangle == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_settriangle", (void**)&(pWrapperTable->m_MeshObject_SetTriangle));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_SetTriangle == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_addtriangle", (void**)&(pWrapperTable->m_MeshObject_AddTriangle));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_AddTriangle == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_gettriangleindices", (void**)&(pWrapperTable->m_MeshObject_GetTriangleIndices));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetTriangleIndices == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_setobjectlevelproperty", (void**)&(pWrapperTable->m_MeshObject_SetObjectLevelProperty));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_SetObjectLevelProperty == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_getobjectlevelproperty", (void**)&(pWrapperTable->m_MeshObject_GetObjectLevelProperty));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetObjectLevelProperty == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_settriangleproperties", (void**)&(pWrapperTable->m_MeshObject_SetTriangleProperties));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_SetTriangleProperties == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_gettriangleproperties", (void**)&(pWrapperTable->m_MeshObject_GetTriangleProperties));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetTriangleProperties == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_setalltriangleproperties", (void**)&(pWrapperTable->m_MeshObject_SetAllTriangleProperties));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_SetAllTriangleProperties == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_getalltriangleproperties", (void**)&(pWrapperTable->m_MeshObject_GetAllTriangleProperties));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetAllTriangleProperties == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_clearallproperties", (void**)&(pWrapperTable->m_MeshObject_ClearAllProperties));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_ClearAllProperties == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_setgeometry", (void**)&(pWrapperTable->m_MeshObject_SetGeometry));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_SetGeometry == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_ismanifoldandoriented", (void**)&(pWrapperTable->m_MeshObject_IsManifoldAndOriented));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_IsManifoldAndOriented == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_beamlattice", (void**)&(pWrapperTable->m_MeshObject_BeamLattice));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_BeamLattice == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_getvolumedata", (void**)&(pWrapperTable->m_MeshObject_GetVolumeData));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetVolumeData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_setvolumedata", (void**)&(pWrapperTable->m_MeshObject_SetVolumeData));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_SetVolumeData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_addtriangleset", (void**)&(pWrapperTable->m_MeshObject_AddTriangleSet));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_AddTriangleSet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_hastriangleset", (void**)&(pWrapperTable->m_MeshObject_HasTriangleSet));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_HasTriangleSet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_findtriangleset", (void**)&(pWrapperTable->m_MeshObject_FindTriangleSet));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_FindTriangleSet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_gettrianglesetcount", (void**)&(pWrapperTable->m_MeshObject_GetTriangleSetCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetTriangleSetCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshobject_gettriangleset", (void**)&(pWrapperTable->m_MeshObject_GetTriangleSet));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshObject_GetTriangleSet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_getfunction", (void**)&(pWrapperTable->m_LevelSet_GetFunction));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_GetFunction == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_setfunction", (void**)&(pWrapperTable->m_LevelSet_SetFunction));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_SetFunction == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_gettransform", (void**)&(pWrapperTable->m_LevelSet_GetTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_GetTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_settransform", (void**)&(pWrapperTable->m_LevelSet_SetTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_SetTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_getchannelname", (void**)&(pWrapperTable->m_LevelSet_GetChannelName));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_GetChannelName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_setchannelname", (void**)&(pWrapperTable->m_LevelSet_SetChannelName));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_SetChannelName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_setminfeaturesize", (void**)&(pWrapperTable->m_LevelSet_SetMinFeatureSize));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_SetMinFeatureSize == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_getminfeaturesize", (void**)&(pWrapperTable->m_LevelSet_GetMinFeatureSize));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_GetMinFeatureSize == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_setfallbackvalue", (void**)&(pWrapperTable->m_LevelSet_SetFallBackValue));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_SetFallBackValue == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_getfallbackvalue", (void**)&(pWrapperTable->m_LevelSet_GetFallBackValue));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_GetFallBackValue == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_setmeshbboxonly", (void**)&(pWrapperTable->m_LevelSet_SetMeshBBoxOnly));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_SetMeshBBoxOnly == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_getmeshbboxonly", (void**)&(pWrapperTable->m_LevelSet_GetMeshBBoxOnly));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_GetMeshBBoxOnly == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_setmesh", (void**)&(pWrapperTable->m_LevelSet_SetMesh));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_SetMesh == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_getmesh", (void**)&(pWrapperTable->m_LevelSet_GetMesh));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_GetMesh == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_getvolumedata", (void**)&(pWrapperTable->m_LevelSet_GetVolumeData));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_GetVolumeData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_levelset_setvolumedata", (void**)&(pWrapperTable->m_LevelSet_SetVolumeData));
		if ( (eLookupError != 0) || (pWrapperTable->m_LevelSet_SetVolumeData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getminlength", (void**)&(pWrapperTable->m_BeamLattice_GetMinLength));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetMinLength == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_setminlength", (void**)&(pWrapperTable->m_BeamLattice_SetMinLength));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_SetMinLength == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getclipping", (void**)&(pWrapperTable->m_BeamLattice_GetClipping));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetClipping == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_setclipping", (void**)&(pWrapperTable->m_BeamLattice_SetClipping));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_SetClipping == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getrepresentation", (void**)&(pWrapperTable->m_BeamLattice_GetRepresentation));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetRepresentation == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_setrepresentation", (void**)&(pWrapperTable->m_BeamLattice_SetRepresentation));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_SetRepresentation == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getballoptions", (void**)&(pWrapperTable->m_BeamLattice_GetBallOptions));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetBallOptions == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_setballoptions", (void**)&(pWrapperTable->m_BeamLattice_SetBallOptions));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_SetBallOptions == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getbeamcount", (void**)&(pWrapperTable->m_BeamLattice_GetBeamCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetBeamCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getbeam", (void**)&(pWrapperTable->m_BeamLattice_GetBeam));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetBeam == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_addbeam", (void**)&(pWrapperTable->m_BeamLattice_AddBeam));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_AddBeam == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_setbeam", (void**)&(pWrapperTable->m_BeamLattice_SetBeam));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_SetBeam == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_setbeams", (void**)&(pWrapperTable->m_BeamLattice_SetBeams));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_SetBeams == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getbeams", (void**)&(pWrapperTable->m_BeamLattice_GetBeams));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetBeams == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getballcount", (void**)&(pWrapperTable->m_BeamLattice_GetBallCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetBallCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getball", (void**)&(pWrapperTable->m_BeamLattice_GetBall));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetBall == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_addball", (void**)&(pWrapperTable->m_BeamLattice_AddBall));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_AddBall == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_setball", (void**)&(pWrapperTable->m_BeamLattice_SetBall));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_SetBall == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_setballs", (void**)&(pWrapperTable->m_BeamLattice_SetBalls));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_SetBalls == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getballs", (void**)&(pWrapperTable->m_BeamLattice_GetBalls));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetBalls == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getbeamsetcount", (void**)&(pWrapperTable->m_BeamLattice_GetBeamSetCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetBeamSetCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_addbeamset", (void**)&(pWrapperTable->m_BeamLattice_AddBeamSet));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_AddBeamSet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlattice_getbeamset", (void**)&(pWrapperTable->m_BeamLattice_GetBeamSet));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLattice_GetBeamSet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionreference_getfunctionresourceid", (void**)&(pWrapperTable->m_FunctionReference_GetFunctionResourceID));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionReference_GetFunctionResourceID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionreference_setfunctionresourceid", (void**)&(pWrapperTable->m_FunctionReference_SetFunctionResourceID));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionReference_SetFunctionResourceID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionreference_gettransform", (void**)&(pWrapperTable->m_FunctionReference_GetTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionReference_GetTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionreference_settransform", (void**)&(pWrapperTable->m_FunctionReference_SetTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionReference_SetTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionreference_getchannelname", (void**)&(pWrapperTable->m_FunctionReference_GetChannelName));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionReference_GetChannelName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionreference_setchannelname", (void**)&(pWrapperTable->m_FunctionReference_SetChannelName));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionReference_SetChannelName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionreference_setminfeaturesize", (void**)&(pWrapperTable->m_FunctionReference_SetMinFeatureSize));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionReference_SetMinFeatureSize == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionreference_getminfeaturesize", (void**)&(pWrapperTable->m_FunctionReference_GetMinFeatureSize));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionReference_GetMinFeatureSize == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionreference_setfallbackvalue", (void**)&(pWrapperTable->m_FunctionReference_SetFallBackValue));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionReference_SetFallBackValue == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionreference_getfallbackvalue", (void**)&(pWrapperTable->m_FunctionReference_GetFallBackValue));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionReference_GetFallBackValue == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedatacomposite_getbasematerialgroup", (void**)&(pWrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedatacomposite_setbasematerialgroup", (void**)&(pWrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedatacomposite_getmaterialmappingcount", (void**)&(pWrapperTable->m_VolumeDataComposite_GetMaterialMappingCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeDataComposite_GetMaterialMappingCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedatacomposite_getmaterialmapping", (void**)&(pWrapperTable->m_VolumeDataComposite_GetMaterialMapping));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeDataComposite_GetMaterialMapping == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedatacomposite_addmaterialmapping", (void**)&(pWrapperTable->m_VolumeDataComposite_AddMaterialMapping));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeDataComposite_AddMaterialMapping == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedatacomposite_removematerialmapping", (void**)&(pWrapperTable->m_VolumeDataComposite_RemoveMaterialMapping));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeDataComposite_RemoveMaterialMapping == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedataproperty_getname", (void**)&(pWrapperTable->m_VolumeDataProperty_GetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeDataProperty_GetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedataproperty_setisrequired", (void**)&(pWrapperTable->m_VolumeDataProperty_SetIsRequired));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeDataProperty_SetIsRequired == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedataproperty_isrequired", (void**)&(pWrapperTable->m_VolumeDataProperty_IsRequired));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeDataProperty_IsRequired == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedata_getcomposite", (void**)&(pWrapperTable->m_VolumeData_GetComposite));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeData_GetComposite == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedata_createnewcomposite", (void**)&(pWrapperTable->m_VolumeData_CreateNewComposite));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeData_CreateNewComposite == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedata_removecomposite", (void**)&(pWrapperTable->m_VolumeData_RemoveComposite));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeData_RemoveComposite == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedata_getcolor", (void**)&(pWrapperTable->m_VolumeData_GetColor));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeData_GetColor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedata_createnewcolor", (void**)&(pWrapperTable->m_VolumeData_CreateNewColor));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeData_CreateNewColor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedata_removecolor", (void**)&(pWrapperTable->m_VolumeData_RemoveColor));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeData_RemoveColor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedata_getpropertycount", (void**)&(pWrapperTable->m_VolumeData_GetPropertyCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeData_GetPropertyCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedata_getproperty", (void**)&(pWrapperTable->m_VolumeData_GetProperty));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeData_GetProperty == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedata_addpropertyfromfunction", (void**)&(pWrapperTable->m_VolumeData_AddPropertyFromFunction));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeData_AddPropertyFromFunction == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_volumedata_removeproperty", (void**)&(pWrapperTable->m_VolumeData_RemoveProperty));
		if ( (eLookupError != 0) || (pWrapperTable->m_VolumeData_RemoveProperty == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_component_getobjectresource", (void**)&(pWrapperTable->m_Component_GetObjectResource));
		if ( (eLookupError != 0) || (pWrapperTable->m_Component_GetObjectResource == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_component_getobjectresourceid", (void**)&(pWrapperTable->m_Component_GetObjectResourceID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Component_GetObjectResourceID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_component_getuuid", (void**)&(pWrapperTable->m_Component_GetUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Component_GetUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_component_setuuid", (void**)&(pWrapperTable->m_Component_SetUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Component_SetUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_component_hastransform", (void**)&(pWrapperTable->m_Component_HasTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_Component_HasTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_component_gettransform", (void**)&(pWrapperTable->m_Component_GetTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_Component_GetTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_component_settransform", (void**)&(pWrapperTable->m_Component_SetTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_Component_SetTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_componentsobject_addcomponent", (void**)&(pWrapperTable->m_ComponentsObject_AddComponent));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComponentsObject_AddComponent == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_componentsobject_getcomponent", (void**)&(pWrapperTable->m_ComponentsObject_GetComponent));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComponentsObject_GetComponent == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_componentsobject_getcomponentcount", (void**)&(pWrapperTable->m_ComponentsObject_GetComponentCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComponentsObject_GetComponentCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamset_setname", (void**)&(pWrapperTable->m_BeamSet_SetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamSet_SetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamset_getname", (void**)&(pWrapperTable->m_BeamSet_GetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamSet_GetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamset_setidentifier", (void**)&(pWrapperTable->m_BeamSet_SetIdentifier));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamSet_SetIdentifier == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamset_getidentifier", (void**)&(pWrapperTable->m_BeamSet_GetIdentifier));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamSet_GetIdentifier == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamset_getreferencecount", (void**)&(pWrapperTable->m_BeamSet_GetReferenceCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamSet_GetReferenceCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamset_setreferences", (void**)&(pWrapperTable->m_BeamSet_SetReferences));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamSet_SetReferences == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamset_getreferences", (void**)&(pWrapperTable->m_BeamSet_GetReferences));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamSet_GetReferences == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamset_getballreferencecount", (void**)&(pWrapperTable->m_BeamSet_GetBallReferenceCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamSet_GetBallReferenceCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamset_setballreferences", (void**)&(pWrapperTable->m_BeamSet_SetBallReferences));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamSet_SetBallReferences == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamset_getballreferences", (void**)&(pWrapperTable->m_BeamSet_GetBallReferences));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamSet_GetBallReferences == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_basematerialgroup_getcount", (void**)&(pWrapperTable->m_BaseMaterialGroup_GetCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_BaseMaterialGroup_GetCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_basematerialgroup_getallpropertyids", (void**)&(pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs));
		if ( (eLookupError != 0) || (pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_basematerialgroup_addmaterial", (void**)&(pWrapperTable->m_BaseMaterialGroup_AddMaterial));
		if ( (eLookupError != 0) || (pWrapperTable->m_BaseMaterialGroup_AddMaterial == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_basematerialgroup_removematerial", (void**)&(pWrapperTable->m_BaseMaterialGroup_RemoveMaterial));
		if ( (eLookupError != 0) || (pWrapperTable->m_BaseMaterialGroup_RemoveMaterial == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_basematerialgroup_getname", (void**)&(pWrapperTable->m_BaseMaterialGroup_GetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_BaseMaterialGroup_GetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_basematerialgroup_setname", (void**)&(pWrapperTable->m_BaseMaterialGroup_SetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_BaseMaterialGroup_SetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_basematerialgroup_setdisplaycolor", (void**)&(pWrapperTable->m_BaseMaterialGroup_SetDisplayColor));
		if ( (eLookupError != 0) || (pWrapperTable->m_BaseMaterialGroup_SetDisplayColor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_basematerialgroup_getdisplaycolor", (void**)&(pWrapperTable->m_BaseMaterialGroup_GetDisplayColor));
		if ( (eLookupError != 0) || (pWrapperTable->m_BaseMaterialGroup_GetDisplayColor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_colorgroup_getcount", (void**)&(pWrapperTable->m_ColorGroup_GetCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_ColorGroup_GetCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_colorgroup_getallpropertyids", (void**)&(pWrapperTable->m_ColorGroup_GetAllPropertyIDs));
		if ( (eLookupError != 0) || (pWrapperTable->m_ColorGroup_GetAllPropertyIDs == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_colorgroup_addcolor", (void**)&(pWrapperTable->m_ColorGroup_AddColor));
		if ( (eLookupError != 0) || (pWrapperTable->m_ColorGroup_AddColor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_colorgroup_removecolor", (void**)&(pWrapperTable->m_ColorGroup_RemoveColor));
		if ( (eLookupError != 0) || (pWrapperTable->m_ColorGroup_RemoveColor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_colorgroup_setcolor", (void**)&(pWrapperTable->m_ColorGroup_SetColor));
		if ( (eLookupError != 0) || (pWrapperTable->m_ColorGroup_SetColor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_colorgroup_getcolor", (void**)&(pWrapperTable->m_ColorGroup_GetColor));
		if ( (eLookupError != 0) || (pWrapperTable->m_ColorGroup_GetColor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2dgroup_getcount", (void**)&(pWrapperTable->m_Texture2DGroup_GetCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2DGroup_GetCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2dgroup_getallpropertyids", (void**)&(pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2dgroup_addtex2coord", (void**)&(pWrapperTable->m_Texture2DGroup_AddTex2Coord));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2DGroup_AddTex2Coord == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2dgroup_gettex2coord", (void**)&(pWrapperTable->m_Texture2DGroup_GetTex2Coord));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2DGroup_GetTex2Coord == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2dgroup_removetex2coord", (void**)&(pWrapperTable->m_Texture2DGroup_RemoveTex2Coord));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2DGroup_RemoveTex2Coord == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2dgroup_gettexture2d", (void**)&(pWrapperTable->m_Texture2DGroup_GetTexture2D));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2DGroup_GetTexture2D == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_compositematerials_getcount", (void**)&(pWrapperTable->m_CompositeMaterials_GetCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_CompositeMaterials_GetCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_compositematerials_getallpropertyids", (void**)&(pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs));
		if ( (eLookupError != 0) || (pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_compositematerials_getbasematerialgroup", (void**)&(pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_compositematerials_addcomposite", (void**)&(pWrapperTable->m_CompositeMaterials_AddComposite));
		if ( (eLookupError != 0) || (pWrapperTable->m_CompositeMaterials_AddComposite == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_compositematerials_removecomposite", (void**)&(pWrapperTable->m_CompositeMaterials_RemoveComposite));
		if ( (eLookupError != 0) || (pWrapperTable->m_CompositeMaterials_RemoveComposite == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_compositematerials_getcomposite", (void**)&(pWrapperTable->m_CompositeMaterials_GetComposite));
		if ( (eLookupError != 0) || (pWrapperTable->m_CompositeMaterials_GetComposite == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_multipropertygroup_getcount", (void**)&(pWrapperTable->m_MultiPropertyGroup_GetCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_MultiPropertyGroup_GetCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_multipropertygroup_getallpropertyids", (void**)&(pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs));
		if ( (eLookupError != 0) || (pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_multipropertygroup_addmultiproperty", (void**)&(pWrapperTable->m_MultiPropertyGroup_AddMultiProperty));
		if ( (eLookupError != 0) || (pWrapperTable->m_MultiPropertyGroup_AddMultiProperty == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_multipropertygroup_setmultiproperty", (void**)&(pWrapperTable->m_MultiPropertyGroup_SetMultiProperty));
		if ( (eLookupError != 0) || (pWrapperTable->m_MultiPropertyGroup_SetMultiProperty == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_multipropertygroup_getmultiproperty", (void**)&(pWrapperTable->m_MultiPropertyGroup_GetMultiProperty));
		if ( (eLookupError != 0) || (pWrapperTable->m_MultiPropertyGroup_GetMultiProperty == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_multipropertygroup_removemultiproperty", (void**)&(pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty));
		if ( (eLookupError != 0) || (pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_multipropertygroup_getlayercount", (void**)&(pWrapperTable->m_MultiPropertyGroup_GetLayerCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_MultiPropertyGroup_GetLayerCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_multipropertygroup_addlayer", (void**)&(pWrapperTable->m_MultiPropertyGroup_AddLayer));
		if ( (eLookupError != 0) || (pWrapperTable->m_MultiPropertyGroup_AddLayer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_multipropertygroup_getlayer", (void**)&(pWrapperTable->m_MultiPropertyGroup_GetLayer));
		if ( (eLookupError != 0) || (pWrapperTable->m_MultiPropertyGroup_GetLayer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_multipropertygroup_removelayer", (void**)&(pWrapperTable->m_MultiPropertyGroup_RemoveLayer));
		if ( (eLookupError != 0) || (pWrapperTable->m_MultiPropertyGroup_RemoveLayer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_image3d_getname", (void**)&(pWrapperTable->m_Image3D_GetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_Image3D_GetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_image3d_setname", (void**)&(pWrapperTable->m_Image3D_SetName));
		if ( (eLookupError != 0) || (pWrapperTable->m_Image3D_SetName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_image3d_isimagestack", (void**)&(pWrapperTable->m_Image3D_IsImageStack));
		if ( (eLookupError != 0) || (pWrapperTable->m_Image3D_IsImageStack == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_imagestack_getrowcount", (void**)&(pWrapperTable->m_ImageStack_GetRowCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImageStack_GetRowCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_imagestack_setrowcount", (void**)&(pWrapperTable->m_ImageStack_SetRowCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImageStack_SetRowCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_imagestack_getcolumncount", (void**)&(pWrapperTable->m_ImageStack_GetColumnCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImageStack_GetColumnCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_imagestack_setcolumncount", (void**)&(pWrapperTable->m_ImageStack_SetColumnCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImageStack_SetColumnCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_imagestack_getsheetcount", (void**)&(pWrapperTable->m_ImageStack_GetSheetCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImageStack_GetSheetCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_imagestack_getsheet", (void**)&(pWrapperTable->m_ImageStack_GetSheet));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImageStack_GetSheet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_imagestack_setsheet", (void**)&(pWrapperTable->m_ImageStack_SetSheet));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImageStack_SetSheet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_imagestack_createemptysheet", (void**)&(pWrapperTable->m_ImageStack_CreateEmptySheet));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImageStack_CreateEmptySheet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_imagestack_createsheetfrombuffer", (void**)&(pWrapperTable->m_ImageStack_CreateSheetFromBuffer));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImageStack_CreateSheetFromBuffer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_imagestack_createsheetfromfile", (void**)&(pWrapperTable->m_ImageStack_CreateSheetFromFile));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImageStack_CreateSheetFromFile == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_attachment_getpath", (void**)&(pWrapperTable->m_Attachment_GetPath));
		if ( (eLookupError != 0) || (pWrapperTable->m_Attachment_GetPath == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_attachment_setpath", (void**)&(pWrapperTable->m_Attachment_SetPath));
		if ( (eLookupError != 0) || (pWrapperTable->m_Attachment_SetPath == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_attachment_packagepart", (void**)&(pWrapperTable->m_Attachment_PackagePart));
		if ( (eLookupError != 0) || (pWrapperTable->m_Attachment_PackagePart == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_attachment_getrelationshiptype", (void**)&(pWrapperTable->m_Attachment_GetRelationShipType));
		if ( (eLookupError != 0) || (pWrapperTable->m_Attachment_GetRelationShipType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_attachment_setrelationshiptype", (void**)&(pWrapperTable->m_Attachment_SetRelationShipType));
		if ( (eLookupError != 0) || (pWrapperTable->m_Attachment_SetRelationShipType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_attachment_writetofile", (void**)&(pWrapperTable->m_Attachment_WriteToFile));
		if ( (eLookupError != 0) || (pWrapperTable->m_Attachment_WriteToFile == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_attachment_readfromfile", (void**)&(pWrapperTable->m_Attachment_ReadFromFile));
		if ( (eLookupError != 0) || (pWrapperTable->m_Attachment_ReadFromFile == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_attachment_readfromcallback", (void**)&(pWrapperTable->m_Attachment_ReadFromCallback));
		if ( (eLookupError != 0) || (pWrapperTable->m_Attachment_ReadFromCallback == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_attachment_getstreamsize", (void**)&(pWrapperTable->m_Attachment_GetStreamSize));
		if ( (eLookupError != 0) || (pWrapperTable->m_Attachment_GetStreamSize == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_attachment_writetobuffer", (void**)&(pWrapperTable->m_Attachment_WriteToBuffer));
		if ( (eLookupError != 0) || (pWrapperTable->m_Attachment_WriteToBuffer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_attachment_readfrombuffer", (void**)&(pWrapperTable->m_Attachment_ReadFromBuffer));
		if ( (eLookupError != 0) || (pWrapperTable->m_Attachment_ReadFromBuffer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2d_getattachment", (void**)&(pWrapperTable->m_Texture2D_GetAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2D_GetAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2d_setattachment", (void**)&(pWrapperTable->m_Texture2D_SetAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2D_SetAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2d_getcontenttype", (void**)&(pWrapperTable->m_Texture2D_GetContentType));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2D_GetContentType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2d_setcontenttype", (void**)&(pWrapperTable->m_Texture2D_SetContentType));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2D_SetContentType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2d_gettilestyleuv", (void**)&(pWrapperTable->m_Texture2D_GetTileStyleUV));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2D_GetTileStyleUV == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2d_settilestyleuv", (void**)&(pWrapperTable->m_Texture2D_SetTileStyleUV));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2D_SetTileStyleUV == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2d_getfilter", (void**)&(pWrapperTable->m_Texture2D_GetFilter));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2D_GetFilter == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_texture2d_setfilter", (void**)&(pWrapperTable->m_Texture2D_SetFilter));
		if ( (eLookupError != 0) || (pWrapperTable->m_Texture2D_SetFilter == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitport_getidentifier", (void**)&(pWrapperTable->m_ImplicitPort_GetIdentifier));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitPort_GetIdentifier == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitport_setidentifier", (void**)&(pWrapperTable->m_ImplicitPort_SetIdentifier));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitPort_SetIdentifier == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitport_getdisplayname", (void**)&(pWrapperTable->m_ImplicitPort_GetDisplayName));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitPort_GetDisplayName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitport_setdisplayname", (void**)&(pWrapperTable->m_ImplicitPort_SetDisplayName));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitPort_SetDisplayName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitport_settype", (void**)&(pWrapperTable->m_ImplicitPort_SetType));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitPort_SetType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitport_gettype", (void**)&(pWrapperTable->m_ImplicitPort_GetType));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitPort_GetType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitport_getreference", (void**)&(pWrapperTable->m_ImplicitPort_GetReference));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitPort_GetReference == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitport_setreference", (void**)&(pWrapperTable->m_ImplicitPort_SetReference));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitPort_SetReference == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_iterator_movenext", (void**)&(pWrapperTable->m_Iterator_MoveNext));
		if ( (eLookupError != 0) || (pWrapperTable->m_Iterator_MoveNext == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_iterator_moveprevious", (void**)&(pWrapperTable->m_Iterator_MovePrevious));
		if ( (eLookupError != 0) || (pWrapperTable->m_Iterator_MovePrevious == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_iterator_count", (void**)&(pWrapperTable->m_Iterator_Count));
		if ( (eLookupError != 0) || (pWrapperTable->m_Iterator_Count == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitportiterator_getcurrent", (void**)&(pWrapperTable->m_ImplicitPortIterator_GetCurrent));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitPortIterator_GetCurrent == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_getidentifier", (void**)&(pWrapperTable->m_ImplicitNode_GetIdentifier));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_GetIdentifier == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_setidentifier", (void**)&(pWrapperTable->m_ImplicitNode_SetIdentifier));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_SetIdentifier == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_getdisplayname", (void**)&(pWrapperTable->m_ImplicitNode_GetDisplayName));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_GetDisplayName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_setdisplayname", (void**)&(pWrapperTable->m_ImplicitNode_SetDisplayName));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_SetDisplayName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_gettag", (void**)&(pWrapperTable->m_ImplicitNode_GetTag));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_GetTag == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_settag", (void**)&(pWrapperTable->m_ImplicitNode_SetTag));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_SetTag == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_getnodetype", (void**)&(pWrapperTable->m_ImplicitNode_GetNodeType));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_GetNodeType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_addinput", (void**)&(pWrapperTable->m_ImplicitNode_AddInput));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_AddInput == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_getinputs", (void**)&(pWrapperTable->m_ImplicitNode_GetInputs));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_GetInputs == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_addoutput", (void**)&(pWrapperTable->m_ImplicitNode_AddOutput));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_AddOutput == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_getoutputs", (void**)&(pWrapperTable->m_ImplicitNode_GetOutputs));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_GetOutputs == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_findinput", (void**)&(pWrapperTable->m_ImplicitNode_FindInput));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_FindInput == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_findoutput", (void**)&(pWrapperTable->m_ImplicitNode_FindOutput));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_FindOutput == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitnode_aretypesvalid", (void**)&(pWrapperTable->m_ImplicitNode_AreTypesValid));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitNode_AreTypesValid == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_oneinputnode_getinputa", (void**)&(pWrapperTable->m_OneInputNode_GetInputA));
		if ( (eLookupError != 0) || (pWrapperTable->m_OneInputNode_GetInputA == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_oneinputnode_getoutputresult", (void**)&(pWrapperTable->m_OneInputNode_GetOutputResult));
		if ( (eLookupError != 0) || (pWrapperTable->m_OneInputNode_GetOutputResult == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourceidnode_setresource", (void**)&(pWrapperTable->m_ResourceIdNode_SetResource));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceIdNode_SetResource == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourceidnode_getresource", (void**)&(pWrapperTable->m_ResourceIdNode_GetResource));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceIdNode_GetResource == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourceidnode_getoutputvalue", (void**)&(pWrapperTable->m_ResourceIdNode_GetOutputValue));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceIdNode_GetOutputValue == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_twoinputnode_getinputb", (void**)&(pWrapperTable->m_TwoInputNode_GetInputB));
		if ( (eLookupError != 0) || (pWrapperTable->m_TwoInputNode_GetInputB == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_selectnode_getinputb", (void**)&(pWrapperTable->m_SelectNode_GetInputB));
		if ( (eLookupError != 0) || (pWrapperTable->m_SelectNode_GetInputB == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_selectnode_getinputc", (void**)&(pWrapperTable->m_SelectNode_GetInputC));
		if ( (eLookupError != 0) || (pWrapperTable->m_SelectNode_GetInputC == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_selectnode_getinputd", (void**)&(pWrapperTable->m_SelectNode_GetInputD));
		if ( (eLookupError != 0) || (pWrapperTable->m_SelectNode_GetInputD == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_clampnode_getinputmin", (void**)&(pWrapperTable->m_ClampNode_GetInputMin));
		if ( (eLookupError != 0) || (pWrapperTable->m_ClampNode_GetInputMin == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_clampnode_getinputmax", (void**)&(pWrapperTable->m_ClampNode_GetInputMax));
		if ( (eLookupError != 0) || (pWrapperTable->m_ClampNode_GetInputMax == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composevectornode_getinputx", (void**)&(pWrapperTable->m_ComposeVectorNode_GetInputX));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeVectorNode_GetInputX == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composevectornode_getinputy", (void**)&(pWrapperTable->m_ComposeVectorNode_GetInputY));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeVectorNode_GetInputY == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composevectornode_getinputz", (void**)&(pWrapperTable->m_ComposeVectorNode_GetInputZ));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeVectorNode_GetInputZ == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composevectornode_getoutputresult", (void**)&(pWrapperTable->m_ComposeVectorNode_GetOutputResult));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeVectorNode_GetOutputResult == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_decomposevectornode_getinputa", (void**)&(pWrapperTable->m_DecomposeVectorNode_GetInputA));
		if ( (eLookupError != 0) || (pWrapperTable->m_DecomposeVectorNode_GetInputA == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_decomposevectornode_getoutputx", (void**)&(pWrapperTable->m_DecomposeVectorNode_GetOutputX));
		if ( (eLookupError != 0) || (pWrapperTable->m_DecomposeVectorNode_GetOutputX == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_decomposevectornode_getoutputy", (void**)&(pWrapperTable->m_DecomposeVectorNode_GetOutputY));
		if ( (eLookupError != 0) || (pWrapperTable->m_DecomposeVectorNode_GetOutputY == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_decomposevectornode_getoutputz", (void**)&(pWrapperTable->m_DecomposeVectorNode_GetOutputZ));
		if ( (eLookupError != 0) || (pWrapperTable->m_DecomposeVectorNode_GetOutputZ == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm00", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM00));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM00 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm01", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM01));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM01 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm02", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM02));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM02 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm03", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM03));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM03 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm10", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM10));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM10 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm11", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM11));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM11 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm12", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM12));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM12 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm13", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM13));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM13 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm20", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM20));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM20 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm21", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM21));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM21 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm22", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM22));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM22 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm23", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM23));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM23 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm30", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM30));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM30 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm31", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM31));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM31 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm32", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM32));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM32 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getinputm33", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetInputM33));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetInputM33 == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_composematrixnode_getoutputresult", (void**)&(pWrapperTable->m_ComposeMatrixNode_GetOutputResult));
		if ( (eLookupError != 0) || (pWrapperTable->m_ComposeMatrixNode_GetOutputResult == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_matrixfromrowsnode_getinputa", (void**)&(pWrapperTable->m_MatrixFromRowsNode_GetInputA));
		if ( (eLookupError != 0) || (pWrapperTable->m_MatrixFromRowsNode_GetInputA == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_matrixfromrowsnode_getinputb", (void**)&(pWrapperTable->m_MatrixFromRowsNode_GetInputB));
		if ( (eLookupError != 0) || (pWrapperTable->m_MatrixFromRowsNode_GetInputB == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_matrixfromrowsnode_getinputc", (void**)&(pWrapperTable->m_MatrixFromRowsNode_GetInputC));
		if ( (eLookupError != 0) || (pWrapperTable->m_MatrixFromRowsNode_GetInputC == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_matrixfromrowsnode_getinputd", (void**)&(pWrapperTable->m_MatrixFromRowsNode_GetInputD));
		if ( (eLookupError != 0) || (pWrapperTable->m_MatrixFromRowsNode_GetInputD == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_matrixfromrowsnode_getoutputresult", (void**)&(pWrapperTable->m_MatrixFromRowsNode_GetOutputResult));
		if ( (eLookupError != 0) || (pWrapperTable->m_MatrixFromRowsNode_GetOutputResult == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_matrixfromcolumnsnode_getinputa", (void**)&(pWrapperTable->m_MatrixFromColumnsNode_GetInputA));
		if ( (eLookupError != 0) || (pWrapperTable->m_MatrixFromColumnsNode_GetInputA == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_matrixfromcolumnsnode_getinputb", (void**)&(pWrapperTable->m_MatrixFromColumnsNode_GetInputB));
		if ( (eLookupError != 0) || (pWrapperTable->m_MatrixFromColumnsNode_GetInputB == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_matrixfromcolumnsnode_getinputc", (void**)&(pWrapperTable->m_MatrixFromColumnsNode_GetInputC));
		if ( (eLookupError != 0) || (pWrapperTable->m_MatrixFromColumnsNode_GetInputC == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_matrixfromcolumnsnode_getinputd", (void**)&(pWrapperTable->m_MatrixFromColumnsNode_GetInputD));
		if ( (eLookupError != 0) || (pWrapperTable->m_MatrixFromColumnsNode_GetInputD == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_matrixfromcolumnsnode_getoutputresult", (void**)&(pWrapperTable->m_MatrixFromColumnsNode_GetOutputResult));
		if ( (eLookupError != 0) || (pWrapperTable->m_MatrixFromColumnsNode_GetOutputResult == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_constantnode_setconstant", (void**)&(pWrapperTable->m_ConstantNode_SetConstant));
		if ( (eLookupError != 0) || (pWrapperTable->m_ConstantNode_SetConstant == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_constantnode_getconstant", (void**)&(pWrapperTable->m_ConstantNode_GetConstant));
		if ( (eLookupError != 0) || (pWrapperTable->m_ConstantNode_GetConstant == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_constantnode_getoutputvalue", (void**)&(pWrapperTable->m_ConstantNode_GetOutputValue));
		if ( (eLookupError != 0) || (pWrapperTable->m_ConstantNode_GetOutputValue == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_constvecnode_setvector", (void**)&(pWrapperTable->m_ConstVecNode_SetVector));
		if ( (eLookupError != 0) || (pWrapperTable->m_ConstVecNode_SetVector == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_constvecnode_getvector", (void**)&(pWrapperTable->m_ConstVecNode_GetVector));
		if ( (eLookupError != 0) || (pWrapperTable->m_ConstVecNode_GetVector == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_constvecnode_getoutputvector", (void**)&(pWrapperTable->m_ConstVecNode_GetOutputVector));
		if ( (eLookupError != 0) || (pWrapperTable->m_ConstVecNode_GetOutputVector == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_constmatnode_setmatrix", (void**)&(pWrapperTable->m_ConstMatNode_SetMatrix));
		if ( (eLookupError != 0) || (pWrapperTable->m_ConstMatNode_SetMatrix == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_constmatnode_getmatrix", (void**)&(pWrapperTable->m_ConstMatNode_GetMatrix));
		if ( (eLookupError != 0) || (pWrapperTable->m_ConstMatNode_GetMatrix == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_constmatnode_getoutputmatrix", (void**)&(pWrapperTable->m_ConstMatNode_GetOutputMatrix));
		if ( (eLookupError != 0) || (pWrapperTable->m_ConstMatNode_GetOutputMatrix == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshnode_getinputmesh", (void**)&(pWrapperTable->m_MeshNode_GetInputMesh));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshNode_GetInputMesh == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshnode_getinputpos", (void**)&(pWrapperTable->m_MeshNode_GetInputPos));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshNode_GetInputPos == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_meshnode_getoutputdistance", (void**)&(pWrapperTable->m_MeshNode_GetOutputDistance));
		if ( (eLookupError != 0) || (pWrapperTable->m_MeshNode_GetOutputDistance == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_unsignedmeshnode_getinputmesh", (void**)&(pWrapperTable->m_UnsignedMeshNode_GetInputMesh));
		if ( (eLookupError != 0) || (pWrapperTable->m_UnsignedMeshNode_GetInputMesh == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_unsignedmeshnode_getinputpos", (void**)&(pWrapperTable->m_UnsignedMeshNode_GetInputPos));
		if ( (eLookupError != 0) || (pWrapperTable->m_UnsignedMeshNode_GetInputPos == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_unsignedmeshnode_getoutputdistance", (void**)&(pWrapperTable->m_UnsignedMeshNode_GetOutputDistance));
		if ( (eLookupError != 0) || (pWrapperTable->m_UnsignedMeshNode_GetOutputDistance == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlatticenode_getinputbeamlattice", (void**)&(pWrapperTable->m_BeamLatticeNode_GetInputBeamLattice));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLatticeNode_GetInputBeamLattice == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlatticenode_getinputpos", (void**)&(pWrapperTable->m_BeamLatticeNode_GetInputPos));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLatticeNode_GetInputPos == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlatticenode_getoutputdistance", (void**)&(pWrapperTable->m_BeamLatticeNode_GetOutputDistance));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLatticeNode_GetOutputDistance == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlatticenode_setaccuraterange", (void**)&(pWrapperTable->m_BeamLatticeNode_SetAccurateRange));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLatticeNode_SetAccurateRange == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_beamlatticenode_getaccuraterange", (void**)&(pWrapperTable->m_BeamLatticeNode_GetAccurateRange));
		if ( (eLookupError != 0) || (pWrapperTable->m_BeamLatticeNode_GetAccurateRange == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functiongradientnode_getinputfunctionid", (void**)&(pWrapperTable->m_FunctionGradientNode_GetInputFunctionID));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionGradientNode_GetInputFunctionID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functiongradientnode_getinputpos", (void**)&(pWrapperTable->m_FunctionGradientNode_GetInputPos));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionGradientNode_GetInputPos == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functiongradientnode_getinputstep", (void**)&(pWrapperTable->m_FunctionGradientNode_GetInputStep));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionGradientNode_GetInputStep == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functiongradientnode_setscalaroutputname", (void**)&(pWrapperTable->m_FunctionGradientNode_SetScalarOutputName));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionGradientNode_SetScalarOutputName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functiongradientnode_getscalaroutputname", (void**)&(pWrapperTable->m_FunctionGradientNode_GetScalarOutputName));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionGradientNode_GetScalarOutputName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functiongradientnode_setvectorinputname", (void**)&(pWrapperTable->m_FunctionGradientNode_SetVectorInputName));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionGradientNode_SetVectorInputName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functiongradientnode_getvectorinputname", (void**)&(pWrapperTable->m_FunctionGradientNode_GetVectorInputName));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionGradientNode_GetVectorInputName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functiongradientnode_getoutputnormalizedgradient", (void**)&(pWrapperTable->m_FunctionGradientNode_GetOutputNormalizedGradient));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionGradientNode_GetOutputNormalizedGradient == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functiongradientnode_getoutputgradient", (void**)&(pWrapperTable->m_FunctionGradientNode_GetOutputGradient));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionGradientNode_GetOutputGradient == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functiongradientnode_getoutputmagnitude", (void**)&(pWrapperTable->m_FunctionGradientNode_GetOutputMagnitude));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionGradientNode_GetOutputMagnitude == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_normalizedistancenode_getinputfunctionid", (void**)&(pWrapperTable->m_NormalizeDistanceNode_GetInputFunctionID));
		if ( (eLookupError != 0) || (pWrapperTable->m_NormalizeDistanceNode_GetInputFunctionID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_normalizedistancenode_getinputpos", (void**)&(pWrapperTable->m_NormalizeDistanceNode_GetInputPos));
		if ( (eLookupError != 0) || (pWrapperTable->m_NormalizeDistanceNode_GetInputPos == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_normalizedistancenode_getinputstep", (void**)&(pWrapperTable->m_NormalizeDistanceNode_GetInputStep));
		if ( (eLookupError != 0) || (pWrapperTable->m_NormalizeDistanceNode_GetInputStep == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_normalizedistancenode_setscalaroutputname", (void**)&(pWrapperTable->m_NormalizeDistanceNode_SetScalarOutputName));
		if ( (eLookupError != 0) || (pWrapperTable->m_NormalizeDistanceNode_SetScalarOutputName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_normalizedistancenode_getscalaroutputname", (void**)&(pWrapperTable->m_NormalizeDistanceNode_GetScalarOutputName));
		if ( (eLookupError != 0) || (pWrapperTable->m_NormalizeDistanceNode_GetScalarOutputName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_normalizedistancenode_setvectorinputname", (void**)&(pWrapperTable->m_NormalizeDistanceNode_SetVectorInputName));
		if ( (eLookupError != 0) || (pWrapperTable->m_NormalizeDistanceNode_SetVectorInputName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_normalizedistancenode_getvectorinputname", (void**)&(pWrapperTable->m_NormalizeDistanceNode_GetVectorInputName));
		if ( (eLookupError != 0) || (pWrapperTable->m_NormalizeDistanceNode_GetVectorInputName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_normalizedistancenode_getoutputresult", (void**)&(pWrapperTable->m_NormalizeDistanceNode_GetOutputResult));
		if ( (eLookupError != 0) || (pWrapperTable->m_NormalizeDistanceNode_GetOutputResult == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functioncallnode_getinputfunctionid", (void**)&(pWrapperTable->m_FunctionCallNode_GetInputFunctionID));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionCallNode_GetInputFunctionID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_nodeiterator_getcurrent", (void**)&(pWrapperTable->m_NodeIterator_GetCurrent));
		if ( (eLookupError != 0) || (pWrapperTable->m_NodeIterator_GetCurrent == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_function_getdisplayname", (void**)&(pWrapperTable->m_Function_GetDisplayName));
		if ( (eLookupError != 0) || (pWrapperTable->m_Function_GetDisplayName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_function_setdisplayname", (void**)&(pWrapperTable->m_Function_SetDisplayName));
		if ( (eLookupError != 0) || (pWrapperTable->m_Function_SetDisplayName == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_function_addinput", (void**)&(pWrapperTable->m_Function_AddInput));
		if ( (eLookupError != 0) || (pWrapperTable->m_Function_AddInput == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_function_getinputs", (void**)&(pWrapperTable->m_Function_GetInputs));
		if ( (eLookupError != 0) || (pWrapperTable->m_Function_GetInputs == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_function_removeinput", (void**)&(pWrapperTable->m_Function_RemoveInput));
		if ( (eLookupError != 0) || (pWrapperTable->m_Function_RemoveInput == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_function_addoutput", (void**)&(pWrapperTable->m_Function_AddOutput));
		if ( (eLookupError != 0) || (pWrapperTable->m_Function_AddOutput == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_function_getoutputs", (void**)&(pWrapperTable->m_Function_GetOutputs));
		if ( (eLookupError != 0) || (pWrapperTable->m_Function_GetOutputs == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_function_removeoutput", (void**)&(pWrapperTable->m_Function_RemoveOutput));
		if ( (eLookupError != 0) || (pWrapperTable->m_Function_RemoveOutput == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_function_findinput", (void**)&(pWrapperTable->m_Function_FindInput));
		if ( (eLookupError != 0) || (pWrapperTable->m_Function_FindInput == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_function_findoutput", (void**)&(pWrapperTable->m_Function_FindOutput));
		if ( (eLookupError != 0) || (pWrapperTable->m_Function_FindOutput == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_getidentifier", (void**)&(pWrapperTable->m_ImplicitFunction_GetIdentifier));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_GetIdentifier == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_setidentifier", (void**)&(pWrapperTable->m_ImplicitFunction_SetIdentifier));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_SetIdentifier == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addsinnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddSinNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddSinNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addcosnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddCosNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddCosNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addtannode", (void**)&(pWrapperTable->m_ImplicitFunction_AddTanNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddTanNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addarcsinnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddArcSinNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddArcSinNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addarccosnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddArcCosNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddArcCosNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addarctan2node", (void**)&(pWrapperTable->m_ImplicitFunction_AddArcTan2Node));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddArcTan2Node == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addsinhnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddSinhNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddSinhNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addcoshnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddCoshNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddCoshNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addtanhnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddTanhNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddTanhNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addroundnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddRoundNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddRoundNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addceilnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddCeilNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddCeilNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addfloornode", (void**)&(pWrapperTable->m_ImplicitFunction_AddFloorNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddFloorNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addsignnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddSignNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddSignNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addfractnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddFractNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddFractNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addabsnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddAbsNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddAbsNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addexpnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddExpNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddExpNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addlognode", (void**)&(pWrapperTable->m_ImplicitFunction_AddLogNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddLogNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addlog2node", (void**)&(pWrapperTable->m_ImplicitFunction_AddLog2Node));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddLog2Node == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addlog10node", (void**)&(pWrapperTable->m_ImplicitFunction_AddLog10Node));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddLog10Node == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addlengthnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddLengthNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddLengthNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addtransposenode", (void**)&(pWrapperTable->m_ImplicitFunction_AddTransposeNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddTransposeNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addinversenode", (void**)&(pWrapperTable->m_ImplicitFunction_AddInverseNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddInverseNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addsqrtnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddSqrtNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddSqrtNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addresourceidnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddResourceIdNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddResourceIdNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addadditionnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddAdditionNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddAdditionNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addsubtractionnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddSubtractionNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddSubtractionNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addmultiplicationnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddMultiplicationNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddMultiplicationNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_adddivisionnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddDivisionNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddDivisionNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_adddotnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddDotNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddDotNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addcrossnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddCrossNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddCrossNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addmatvecmultiplicationnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addminnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddMinNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddMinNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addmaxnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddMaxNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddMaxNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addfmodnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddFmodNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddFmodNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addpownode", (void**)&(pWrapperTable->m_ImplicitFunction_AddPowNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddPowNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addselectnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddSelectNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddSelectNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addclampnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddClampNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddClampNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addcomposevectornode", (void**)&(pWrapperTable->m_ImplicitFunction_AddComposeVectorNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddComposeVectorNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addvectorfromscalarnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddVectorFromScalarNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddVectorFromScalarNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_adddecomposevectornode", (void**)&(pWrapperTable->m_ImplicitFunction_AddDecomposeVectorNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddDecomposeVectorNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addcomposematrixnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddComposeMatrixNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddComposeMatrixNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addmatrixfromrowsnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addmatrixfromcolumnsnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addconstantnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddConstantNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddConstantNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addconstvecnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddConstVecNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddConstVecNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addconstmatnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddConstMatNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddConstMatNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addmeshnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddMeshNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddMeshNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addunsignedmeshnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddUnsignedMeshNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddUnsignedMeshNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addbeamlatticenode", (void**)&(pWrapperTable->m_ImplicitFunction_AddBeamLatticeNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddBeamLatticeNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addfunctiongradientnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddFunctionGradientNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddFunctionGradientNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addnormalizedistancenode", (void**)&(pWrapperTable->m_ImplicitFunction_AddNormalizeDistanceNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddNormalizeDistanceNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addfunctioncallnode", (void**)&(pWrapperTable->m_ImplicitFunction_AddFunctionCallNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddFunctionCallNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_getnodes", (void**)&(pWrapperTable->m_ImplicitFunction_GetNodes));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_GetNodes == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_removenode", (void**)&(pWrapperTable->m_ImplicitFunction_RemoveNode));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_RemoveNode == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addlink", (void**)&(pWrapperTable->m_ImplicitFunction_AddLink));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddLink == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_addlinkbynames", (void**)&(pWrapperTable->m_ImplicitFunction_AddLinkByNames));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_AddLinkByNames == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_clear", (void**)&(pWrapperTable->m_ImplicitFunction_Clear));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_Clear == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_implicitfunction_sortnodestopologically", (void**)&(pWrapperTable->m_ImplicitFunction_SortNodesTopologically));
		if ( (eLookupError != 0) || (pWrapperTable->m_ImplicitFunction_SortNodesTopologically == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionfromimage3d_getimage3d", (void**)&(pWrapperTable->m_FunctionFromImage3D_GetImage3D));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionFromImage3D_GetImage3D == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionfromimage3d_setimage3d", (void**)&(pWrapperTable->m_FunctionFromImage3D_SetImage3D));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionFromImage3D_SetImage3D == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionfromimage3d_setfilter", (void**)&(pWrapperTable->m_FunctionFromImage3D_SetFilter));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionFromImage3D_SetFilter == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionfromimage3d_getfilter", (void**)&(pWrapperTable->m_FunctionFromImage3D_GetFilter));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionFromImage3D_GetFilter == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionfromimage3d_settilestyles", (void**)&(pWrapperTable->m_FunctionFromImage3D_SetTileStyles));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionFromImage3D_SetTileStyles == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionfromimage3d_gettilestyles", (void**)&(pWrapperTable->m_FunctionFromImage3D_GetTileStyles));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionFromImage3D_GetTileStyles == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionfromimage3d_getoffset", (void**)&(pWrapperTable->m_FunctionFromImage3D_GetOffset));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionFromImage3D_GetOffset == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionfromimage3d_setoffset", (void**)&(pWrapperTable->m_FunctionFromImage3D_SetOffset));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionFromImage3D_SetOffset == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionfromimage3d_getscale", (void**)&(pWrapperTable->m_FunctionFromImage3D_GetScale));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionFromImage3D_GetScale == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_functionfromimage3d_setscale", (void**)&(pWrapperTable->m_FunctionFromImage3D_SetScale));
		if ( (eLookupError != 0) || (pWrapperTable->m_FunctionFromImage3D_SetScale == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditem_getobjectresource", (void**)&(pWrapperTable->m_BuildItem_GetObjectResource));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItem_GetObjectResource == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditem_getuuid", (void**)&(pWrapperTable->m_BuildItem_GetUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItem_GetUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditem_setuuid", (void**)&(pWrapperTable->m_BuildItem_SetUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItem_SetUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditem_getobjectresourceid", (void**)&(pWrapperTable->m_BuildItem_GetObjectResourceID));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItem_GetObjectResourceID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditem_hasobjecttransform", (void**)&(pWrapperTable->m_BuildItem_HasObjectTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItem_HasObjectTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditem_getobjecttransform", (void**)&(pWrapperTable->m_BuildItem_GetObjectTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItem_GetObjectTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditem_setobjecttransform", (void**)&(pWrapperTable->m_BuildItem_SetObjectTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItem_SetObjectTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditem_getpartnumber", (void**)&(pWrapperTable->m_BuildItem_GetPartNumber));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItem_GetPartNumber == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditem_setpartnumber", (void**)&(pWrapperTable->m_BuildItem_SetPartNumber));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItem_SetPartNumber == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditem_getmetadatagroup", (void**)&(pWrapperTable->m_BuildItem_GetMetaDataGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItem_GetMetaDataGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditem_getoutbox", (void**)&(pWrapperTable->m_BuildItem_GetOutbox));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItem_GetOutbox == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditemiterator_movenext", (void**)&(pWrapperTable->m_BuildItemIterator_MoveNext));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItemIterator_MoveNext == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditemiterator_moveprevious", (void**)&(pWrapperTable->m_BuildItemIterator_MovePrevious));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItemIterator_MovePrevious == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditemiterator_getcurrent", (void**)&(pWrapperTable->m_BuildItemIterator_GetCurrent));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItemIterator_GetCurrent == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditemiterator_clone", (void**)&(pWrapperTable->m_BuildItemIterator_Clone));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItemIterator_Clone == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_builditemiterator_count", (void**)&(pWrapperTable->m_BuildItemIterator_Count));
		if ( (eLookupError != 0) || (pWrapperTable->m_BuildItemIterator_Count == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slice_setvertices", (void**)&(pWrapperTable->m_Slice_SetVertices));
		if ( (eLookupError != 0) || (pWrapperTable->m_Slice_SetVertices == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slice_getvertices", (void**)&(pWrapperTable->m_Slice_GetVertices));
		if ( (eLookupError != 0) || (pWrapperTable->m_Slice_GetVertices == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slice_getvertexcount", (void**)&(pWrapperTable->m_Slice_GetVertexCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_Slice_GetVertexCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slice_addpolygon", (void**)&(pWrapperTable->m_Slice_AddPolygon));
		if ( (eLookupError != 0) || (pWrapperTable->m_Slice_AddPolygon == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slice_getpolygoncount", (void**)&(pWrapperTable->m_Slice_GetPolygonCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_Slice_GetPolygonCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slice_setpolygonindices", (void**)&(pWrapperTable->m_Slice_SetPolygonIndices));
		if ( (eLookupError != 0) || (pWrapperTable->m_Slice_SetPolygonIndices == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slice_getpolygonindices", (void**)&(pWrapperTable->m_Slice_GetPolygonIndices));
		if ( (eLookupError != 0) || (pWrapperTable->m_Slice_GetPolygonIndices == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slice_getpolygonindexcount", (void**)&(pWrapperTable->m_Slice_GetPolygonIndexCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_Slice_GetPolygonIndexCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slice_getztop", (void**)&(pWrapperTable->m_Slice_GetZTop));
		if ( (eLookupError != 0) || (pWrapperTable->m_Slice_GetZTop == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slicestack_getbottomz", (void**)&(pWrapperTable->m_SliceStack_GetBottomZ));
		if ( (eLookupError != 0) || (pWrapperTable->m_SliceStack_GetBottomZ == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slicestack_getslicecount", (void**)&(pWrapperTable->m_SliceStack_GetSliceCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_SliceStack_GetSliceCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slicestack_getslice", (void**)&(pWrapperTable->m_SliceStack_GetSlice));
		if ( (eLookupError != 0) || (pWrapperTable->m_SliceStack_GetSlice == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slicestack_addslice", (void**)&(pWrapperTable->m_SliceStack_AddSlice));
		if ( (eLookupError != 0) || (pWrapperTable->m_SliceStack_AddSlice == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slicestack_getslicerefcount", (void**)&(pWrapperTable->m_SliceStack_GetSliceRefCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_SliceStack_GetSliceRefCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slicestack_addslicestackreference", (void**)&(pWrapperTable->m_SliceStack_AddSliceStackReference));
		if ( (eLookupError != 0) || (pWrapperTable->m_SliceStack_AddSliceStackReference == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slicestack_getslicestackreference", (void**)&(pWrapperTable->m_SliceStack_GetSliceStackReference));
		if ( (eLookupError != 0) || (pWrapperTable->m_SliceStack_GetSliceStackReference == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slicestack_collapseslicereferences", (void**)&(pWrapperTable->m_SliceStack_CollapseSliceReferences));
		if ( (eLookupError != 0) || (pWrapperTable->m_SliceStack_CollapseSliceReferences == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slicestack_setownpath", (void**)&(pWrapperTable->m_SliceStack_SetOwnPath));
		if ( (eLookupError != 0) || (pWrapperTable->m_SliceStack_SetOwnPath == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_slicestack_getownpath", (void**)&(pWrapperTable->m_SliceStack_GetOwnPath));
		if ( (eLookupError != 0) || (pWrapperTable->m_SliceStack_GetOwnPath == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_consumer_getconsumerid", (void**)&(pWrapperTable->m_Consumer_GetConsumerID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Consumer_GetConsumerID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_consumer_getkeyid", (void**)&(pWrapperTable->m_Consumer_GetKeyID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Consumer_GetKeyID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_consumer_getkeyvalue", (void**)&(pWrapperTable->m_Consumer_GetKeyValue));
		if ( (eLookupError != 0) || (pWrapperTable->m_Consumer_GetKeyValue == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_accessright_getconsumer", (void**)&(pWrapperTable->m_AccessRight_GetConsumer));
		if ( (eLookupError != 0) || (pWrapperTable->m_AccessRight_GetConsumer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_accessright_getwrappingalgorithm", (void**)&(pWrapperTable->m_AccessRight_GetWrappingAlgorithm));
		if ( (eLookupError != 0) || (pWrapperTable->m_AccessRight_GetWrappingAlgorithm == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_accessright_getmgfalgorithm", (void**)&(pWrapperTable->m_AccessRight_GetMgfAlgorithm));
		if ( (eLookupError != 0) || (pWrapperTable->m_AccessRight_GetMgfAlgorithm == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_accessright_getdigestmethod", (void**)&(pWrapperTable->m_AccessRight_GetDigestMethod));
		if ( (eLookupError != 0) || (pWrapperTable->m_AccessRight_GetDigestMethod == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_contentencryptionparams_getencryptionalgorithm", (void**)&(pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm));
		if ( (eLookupError != 0) || (pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_contentencryptionparams_getkey", (void**)&(pWrapperTable->m_ContentEncryptionParams_GetKey));
		if ( (eLookupError != 0) || (pWrapperTable->m_ContentEncryptionParams_GetKey == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_contentencryptionparams_getinitializationvector", (void**)&(pWrapperTable->m_ContentEncryptionParams_GetInitializationVector));
		if ( (eLookupError != 0) || (pWrapperTable->m_ContentEncryptionParams_GetInitializationVector == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_contentencryptionparams_getauthenticationtag", (void**)&(pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag));
		if ( (eLookupError != 0) || (pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_contentencryptionparams_setauthenticationtag", (void**)&(pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag));
		if ( (eLookupError != 0) || (pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_contentencryptionparams_getadditionalauthenticationdata", (void**)&(pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData));
		if ( (eLookupError != 0) || (pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_contentencryptionparams_getdescriptor", (void**)&(pWrapperTable->m_ContentEncryptionParams_GetDescriptor));
		if ( (eLookupError != 0) || (pWrapperTable->m_ContentEncryptionParams_GetDescriptor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_contentencryptionparams_getkeyuuid", (void**)&(pWrapperTable->m_ContentEncryptionParams_GetKeyUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_ContentEncryptionParams_GetKeyUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourcedata_getpath", (void**)&(pWrapperTable->m_ResourceData_GetPath));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceData_GetPath == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourcedata_getencryptionalgorithm", (void**)&(pWrapperTable->m_ResourceData_GetEncryptionAlgorithm));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceData_GetEncryptionAlgorithm == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourcedata_getcompression", (void**)&(pWrapperTable->m_ResourceData_GetCompression));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceData_GetCompression == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourcedata_getadditionalauthenticationdata", (void**)&(pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourcedatagroup_getkeyuuid", (void**)&(pWrapperTable->m_ResourceDataGroup_GetKeyUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceDataGroup_GetKeyUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourcedatagroup_addaccessright", (void**)&(pWrapperTable->m_ResourceDataGroup_AddAccessRight));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceDataGroup_AddAccessRight == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourcedatagroup_findaccessrightbyconsumer", (void**)&(pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_resourcedatagroup_removeaccessright", (void**)&(pWrapperTable->m_ResourceDataGroup_RemoveAccessRight));
		if ( (eLookupError != 0) || (pWrapperTable->m_ResourceDataGroup_RemoveAccessRight == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_addconsumer", (void**)&(pWrapperTable->m_KeyStore_AddConsumer));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_AddConsumer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_getconsumercount", (void**)&(pWrapperTable->m_KeyStore_GetConsumerCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_GetConsumerCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_getconsumer", (void**)&(pWrapperTable->m_KeyStore_GetConsumer));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_GetConsumer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_removeconsumer", (void**)&(pWrapperTable->m_KeyStore_RemoveConsumer));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_RemoveConsumer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_findconsumer", (void**)&(pWrapperTable->m_KeyStore_FindConsumer));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_FindConsumer == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_getresourcedatagroupcount", (void**)&(pWrapperTable->m_KeyStore_GetResourceDataGroupCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_GetResourceDataGroupCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_addresourcedatagroup", (void**)&(pWrapperTable->m_KeyStore_AddResourceDataGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_AddResourceDataGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_getresourcedatagroup", (void**)&(pWrapperTable->m_KeyStore_GetResourceDataGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_GetResourceDataGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_removeresourcedatagroup", (void**)&(pWrapperTable->m_KeyStore_RemoveResourceDataGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_RemoveResourceDataGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_findresourcedatagroup", (void**)&(pWrapperTable->m_KeyStore_FindResourceDataGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_FindResourceDataGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_addresourcedata", (void**)&(pWrapperTable->m_KeyStore_AddResourceData));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_AddResourceData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_removeresourcedata", (void**)&(pWrapperTable->m_KeyStore_RemoveResourceData));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_RemoveResourceData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_findresourcedata", (void**)&(pWrapperTable->m_KeyStore_FindResourceData));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_FindResourceData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_getresourcedatacount", (void**)&(pWrapperTable->m_KeyStore_GetResourceDataCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_GetResourceDataCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_getresourcedata", (void**)&(pWrapperTable->m_KeyStore_GetResourceData));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_GetResourceData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_getuuid", (void**)&(pWrapperTable->m_KeyStore_GetUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_GetUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_keystore_setuuid", (void**)&(pWrapperTable->m_KeyStore_SetUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_KeyStore_SetUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_rootmodelpart", (void**)&(pWrapperTable->m_Model_RootModelPart));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_RootModelPart == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_findorcreatepackagepart", (void**)&(pWrapperTable->m_Model_FindOrCreatePackagePart));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_FindOrCreatePackagePart == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_setunit", (void**)&(pWrapperTable->m_Model_SetUnit));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_SetUnit == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getunit", (void**)&(pWrapperTable->m_Model_GetUnit));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetUnit == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getlanguage", (void**)&(pWrapperTable->m_Model_GetLanguage));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetLanguage == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_setlanguage", (void**)&(pWrapperTable->m_Model_SetLanguage));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_SetLanguage == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_querywriter", (void**)&(pWrapperTable->m_Model_QueryWriter));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_QueryWriter == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_queryreader", (void**)&(pWrapperTable->m_Model_QueryReader));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_QueryReader == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getresourcebyid", (void**)&(pWrapperTable->m_Model_GetResourceByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetResourceByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_gettexture2dbyid", (void**)&(pWrapperTable->m_Model_GetTexture2DByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetTexture2DByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getpropertytypebyid", (void**)&(pWrapperTable->m_Model_GetPropertyTypeByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetPropertyTypeByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getbasematerialgroupbyid", (void**)&(pWrapperTable->m_Model_GetBaseMaterialGroupByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetBaseMaterialGroupByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_gettexture2dgroupbyid", (void**)&(pWrapperTable->m_Model_GetTexture2DGroupByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetTexture2DGroupByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getcompositematerialsbyid", (void**)&(pWrapperTable->m_Model_GetCompositeMaterialsByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetCompositeMaterialsByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getmultipropertygroupbyid", (void**)&(pWrapperTable->m_Model_GetMultiPropertyGroupByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetMultiPropertyGroupByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getmeshobjectbyid", (void**)&(pWrapperTable->m_Model_GetMeshObjectByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetMeshObjectByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getcomponentsobjectbyid", (void**)&(pWrapperTable->m_Model_GetComponentsObjectByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetComponentsObjectByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getcolorgroupbyid", (void**)&(pWrapperTable->m_Model_GetColorGroupByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetColorGroupByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getslicestackbyid", (void**)&(pWrapperTable->m_Model_GetSliceStackByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetSliceStackByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getlevelsetbyid", (void**)&(pWrapperTable->m_Model_GetLevelSetByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetLevelSetByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getbuilduuid", (void**)&(pWrapperTable->m_Model_GetBuildUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetBuildUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_setbuilduuid", (void**)&(pWrapperTable->m_Model_SetBuildUUID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_SetBuildUUID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getbuilditems", (void**)&(pWrapperTable->m_Model_GetBuildItems));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetBuildItems == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getoutbox", (void**)&(pWrapperTable->m_Model_GetOutbox));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetOutbox == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getresources", (void**)&(pWrapperTable->m_Model_GetResources));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetResources == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getobjects", (void**)&(pWrapperTable->m_Model_GetObjects));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetObjects == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getmeshobjects", (void**)&(pWrapperTable->m_Model_GetMeshObjects));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetMeshObjects == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getcomponentsobjects", (void**)&(pWrapperTable->m_Model_GetComponentsObjects));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetComponentsObjects == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_gettexture2ds", (void**)&(pWrapperTable->m_Model_GetTexture2Ds));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetTexture2Ds == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getbasematerialgroups", (void**)&(pWrapperTable->m_Model_GetBaseMaterialGroups));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetBaseMaterialGroups == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getcolorgroups", (void**)&(pWrapperTable->m_Model_GetColorGroups));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetColorGroups == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_gettexture2dgroups", (void**)&(pWrapperTable->m_Model_GetTexture2DGroups));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetTexture2DGroups == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getcompositematerials", (void**)&(pWrapperTable->m_Model_GetCompositeMaterials));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetCompositeMaterials == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getmultipropertygroups", (void**)&(pWrapperTable->m_Model_GetMultiPropertyGroups));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetMultiPropertyGroups == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getslicestacks", (void**)&(pWrapperTable->m_Model_GetSliceStacks));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetSliceStacks == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getimage3ds", (void**)&(pWrapperTable->m_Model_GetImage3Ds));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetImage3Ds == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_mergetomodel", (void**)&(pWrapperTable->m_Model_MergeToModel));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_MergeToModel == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_mergefrommodel", (void**)&(pWrapperTable->m_Model_MergeFromModel));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_MergeFromModel == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addmeshobject", (void**)&(pWrapperTable->m_Model_AddMeshObject));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddMeshObject == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addcomponentsobject", (void**)&(pWrapperTable->m_Model_AddComponentsObject));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddComponentsObject == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addslicestack", (void**)&(pWrapperTable->m_Model_AddSliceStack));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddSliceStack == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addtexture2dfromattachment", (void**)&(pWrapperTable->m_Model_AddTexture2DFromAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddTexture2DFromAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addbasematerialgroup", (void**)&(pWrapperTable->m_Model_AddBaseMaterialGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddBaseMaterialGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addcolorgroup", (void**)&(pWrapperTable->m_Model_AddColorGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddColorGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addtexture2dgroup", (void**)&(pWrapperTable->m_Model_AddTexture2DGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddTexture2DGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addcompositematerials", (void**)&(pWrapperTable->m_Model_AddCompositeMaterials));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddCompositeMaterials == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addmultipropertygroup", (void**)&(pWrapperTable->m_Model_AddMultiPropertyGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddMultiPropertyGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addimagestack", (void**)&(pWrapperTable->m_Model_AddImageStack));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddImageStack == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getimagestackbyid", (void**)&(pWrapperTable->m_Model_GetImageStackByID));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetImageStackByID == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addbuilditem", (void**)&(pWrapperTable->m_Model_AddBuildItem));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddBuildItem == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_removebuilditem", (void**)&(pWrapperTable->m_Model_RemoveBuildItem));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_RemoveBuildItem == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getmetadatagroup", (void**)&(pWrapperTable->m_Model_GetMetaDataGroup));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetMetaDataGroup == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addattachment", (void**)&(pWrapperTable->m_Model_AddAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_removeattachment", (void**)&(pWrapperTable->m_Model_RemoveAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_RemoveAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getattachment", (void**)&(pWrapperTable->m_Model_GetAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_findattachment", (void**)&(pWrapperTable->m_Model_FindAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_FindAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getattachmentcount", (void**)&(pWrapperTable->m_Model_GetAttachmentCount));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetAttachmentCount == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_haspackagethumbnailattachment", (void**)&(pWrapperTable->m_Model_HasPackageThumbnailAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_HasPackageThumbnailAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_createpackagethumbnailattachment", (void**)&(pWrapperTable->m_Model_CreatePackageThumbnailAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_CreatePackageThumbnailAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getpackagethumbnailattachment", (void**)&(pWrapperTable->m_Model_GetPackageThumbnailAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetPackageThumbnailAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_removepackagethumbnailattachment", (void**)&(pWrapperTable->m_Model_RemovePackageThumbnailAttachment));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_RemovePackageThumbnailAttachment == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addcustomcontenttype", (void**)&(pWrapperTable->m_Model_AddCustomContentType));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddCustomContentType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_removecustomcontenttype", (void**)&(pWrapperTable->m_Model_RemoveCustomContentType));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_RemoveCustomContentType == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_setrandomnumbercallback", (void**)&(pWrapperTable->m_Model_SetRandomNumberCallback));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_SetRandomNumberCallback == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getkeystore", (void**)&(pWrapperTable->m_Model_GetKeyStore));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetKeyStore == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getfunctions", (void**)&(pWrapperTable->m_Model_GetFunctions));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetFunctions == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addimplicitfunction", (void**)&(pWrapperTable->m_Model_AddImplicitFunction));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddImplicitFunction == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addfunctionfromimage3d", (void**)&(pWrapperTable->m_Model_AddFunctionFromImage3D));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddFunctionFromImage3D == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addvolumedata", (void**)&(pWrapperTable->m_Model_AddVolumeData));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddVolumeData == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_addlevelset", (void**)&(pWrapperTable->m_Model_AddLevelSet));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_AddLevelSet == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_getlevelsets", (void**)&(pWrapperTable->m_Model_GetLevelSets));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_GetLevelSets == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_model_removeresource", (void**)&(pWrapperTable->m_Model_RemoveResource));
		if ( (eLookupError != 0) || (pWrapperTable->m_Model_RemoveResource == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_getlibraryversion", (void**)&(pWrapperTable->m_GetLibraryVersion));
		if ( (eLookupError != 0) || (pWrapperTable->m_GetLibraryVersion == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_getprereleaseinformation", (void**)&(pWrapperTable->m_GetPrereleaseInformation));
		if ( (eLookupError != 0) || (pWrapperTable->m_GetPrereleaseInformation == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_getbuildinformation", (void**)&(pWrapperTable->m_GetBuildInformation));
		if ( (eLookupError != 0) || (pWrapperTable->m_GetBuildInformation == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_getspecificationversion", (void**)&(pWrapperTable->m_GetSpecificationVersion));
		if ( (eLookupError != 0) || (pWrapperTable->m_GetSpecificationVersion == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_createmodel", (void**)&(pWrapperTable->m_CreateModel));
		if ( (eLookupError != 0) || (pWrapperTable->m_CreateModel == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_release", (void**)&(pWrapperTable->m_Release));
		if ( (eLookupError != 0) || (pWrapperTable->m_Release == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_acquire", (void**)&(pWrapperTable->m_Acquire));
		if ( (eLookupError != 0) || (pWrapperTable->m_Acquire == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_setjournal", (void**)&(pWrapperTable->m_SetJournal));
		if ( (eLookupError != 0) || (pWrapperTable->m_SetJournal == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_getlasterror", (void**)&(pWrapperTable->m_GetLastError));
		if ( (eLookupError != 0) || (pWrapperTable->m_GetLastError == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_getsymbollookupmethod", (void**)&(pWrapperTable->m_GetSymbolLookupMethod));
		if ( (eLookupError != 0) || (pWrapperTable->m_GetSymbolLookupMethod == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_retrieveprogressmessage", (void**)&(pWrapperTable->m_RetrieveProgressMessage));
		if ( (eLookupError != 0) || (pWrapperTable->m_RetrieveProgressMessage == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_rgbatocolor", (void**)&(pWrapperTable->m_RGBAToColor));
		if ( (eLookupError != 0) || (pWrapperTable->m_RGBAToColor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_floatrgbatocolor", (void**)&(pWrapperTable->m_FloatRGBAToColor));
		if ( (eLookupError != 0) || (pWrapperTable->m_FloatRGBAToColor == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_colortorgba", (void**)&(pWrapperTable->m_ColorToRGBA));
		if ( (eLookupError != 0) || (pWrapperTable->m_ColorToRGBA == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_colortofloatrgba", (void**)&(pWrapperTable->m_ColorToFloatRGBA));
		if ( (eLookupError != 0) || (pWrapperTable->m_ColorToFloatRGBA == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_getidentitytransform", (void**)&(pWrapperTable->m_GetIdentityTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_GetIdentityTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_getuniformscaletransform", (void**)&(pWrapperTable->m_GetUniformScaleTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_GetUniformScaleTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_getscaletransform", (void**)&(pWrapperTable->m_GetScaleTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_GetScaleTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		eLookupError = (*pLookup)("lib3mf_gettranslationtransform", (void**)&(pWrapperTable->m_GetTranslationTransform));
		if ( (eLookupError != 0) || (pWrapperTable->m_GetTranslationTransform == nullptr) )
			return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
		
		return LIB3MF_SUCCESS;
	}
	
	
	/**
	 * Method definitions for class CBase
	 */
	
	/**
	* CBase::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 CBase::ClassTypeId()
	{
		Lib3MF_uint64 resultClassTypeId = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Base_ClassTypeId(m_pHandle, &resultClassTypeId));
		
		return resultClassTypeId;
	}
	
	/**
	 * Method definitions for class CWriter
	 */
	
	/**
	* CWriter::WriteToFile - Writes out the model as file. The file type is specified by the Model Writer class.
	* @param[in] sFilename - Filename to write into
	*/
	void CWriter::WriteToFile(const std::string & sFilename)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_WriteToFile(m_pHandle, sFilename.c_str()));
	}
	
	/**
	* CWriter::GetStreamSize - Retrieves the size of the full 3MF file stream.
	* @return the stream size
	*/
	Lib3MF_uint64 CWriter::GetStreamSize()
	{
		Lib3MF_uint64 resultStreamSize = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_GetStreamSize(m_pHandle, &resultStreamSize));
		
		return resultStreamSize;
	}
	
	/**
	* CWriter::WriteToBuffer - Writes out the 3MF file into a memory buffer
	* @param[out] BufferBuffer - buffer to write into
	*/
	void CWriter::WriteToBuffer(std::vector<Lib3MF_uint8> & BufferBuffer)
	{
		Lib3MF_uint64 elementsNeededBuffer = 0;
		Lib3MF_uint64 elementsWrittenBuffer = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_WriteToBuffer(m_pHandle, 0, &elementsNeededBuffer, nullptr));
		BufferBuffer.resize((size_t) elementsNeededBuffer);
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_WriteToBuffer(m_pHandle, elementsNeededBuffer, &elementsWrittenBuffer, BufferBuffer.data()));
	}
	
	/**
	* CWriter::WriteToCallback - Writes out the model and passes the data to a provided callback function. The file type is specified by the Model Writer class.
	* @param[in] pTheWriteCallback - Callback to call for writing a data chunk
	* @param[in] pTheSeekCallback - Callback to call for seeking in the stream
	* @param[in] pUserData - Userdata that is passed to the callback function
	*/
	void CWriter::WriteToCallback(const WriteCallback pTheWriteCallback, const SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_WriteToCallback(m_pHandle, pTheWriteCallback, pTheSeekCallback, pUserData));
	}
	
	/**
	* CWriter::SetProgressCallback - Set the progress callback for calls to this writer
	* @param[in] pProgressCallback - pointer to the callback function.
	* @param[in] pUserData - pointer to arbitrary user data that is passed without modification to the callback.
	*/
	void CWriter::SetProgressCallback(const ProgressCallback pProgressCallback, const Lib3MF_pvoid pUserData)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_SetProgressCallback(m_pHandle, pProgressCallback, pUserData));
	}
	
	/**
	* CWriter::GetDecimalPrecision - Returns the number of digits after the decimal point to be written in each vertex coordinate-value.
	* @return The number of digits to be written in each vertex coordinate-value after the decimal point.
	*/
	Lib3MF_uint32 CWriter::GetDecimalPrecision()
	{
		Lib3MF_uint32 resultDecimalPrecision = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_GetDecimalPrecision(m_pHandle, &resultDecimalPrecision));
		
		return resultDecimalPrecision;
	}
	
	/**
	* CWriter::SetDecimalPrecision - Sets the number of digits after the decimal point to be written in each vertex coordinate-value.
	* @param[in] nDecimalPrecision - The number of digits to be written in each vertex coordinate-value after the decimal point.
	*/
	void CWriter::SetDecimalPrecision(const Lib3MF_uint32 nDecimalPrecision)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_SetDecimalPrecision(m_pHandle, nDecimalPrecision));
	}
	
	/**
	* CWriter::SetStrictModeActive - Activates (deactivates) the strict mode of the reader.
	* @param[in] bStrictModeActive - flag whether strict mode is active or not.
	*/
	void CWriter::SetStrictModeActive(const bool bStrictModeActive)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_SetStrictModeActive(m_pHandle, bStrictModeActive));
	}
	
	/**
	* CWriter::GetStrictModeActive - Queries whether the strict mode of the reader is active or not
	* @return returns flag whether strict mode is active or not.
	*/
	bool CWriter::GetStrictModeActive()
	{
		bool resultStrictModeActive = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_GetStrictModeActive(m_pHandle, &resultStrictModeActive));
		
		return resultStrictModeActive;
	}
	
	/**
	* CWriter::GetWarning - Returns Warning and Error Information of the read process
	* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
	* @param[out] nErrorCode - filled with the error code of the warning
	* @return the message of the warning
	*/
	std::string CWriter::GetWarning(const Lib3MF_uint32 nIndex, Lib3MF_uint32 & nErrorCode)
	{
		Lib3MF_uint32 bytesNeededWarning = 0;
		Lib3MF_uint32 bytesWrittenWarning = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_GetWarning(m_pHandle, nIndex, &nErrorCode, 0, &bytesNeededWarning, nullptr));
		std::vector<char> bufferWarning(bytesNeededWarning);
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_GetWarning(m_pHandle, nIndex, &nErrorCode, bytesNeededWarning, &bytesWrittenWarning, &bufferWarning[0]));
		
		return std::string(&bufferWarning[0]);
	}
	
	/**
	* CWriter::GetWarningCount - Returns Warning and Error Count of the read process
	* @return filled with the count of the occurred warnings.
	*/
	Lib3MF_uint32 CWriter::GetWarningCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_GetWarningCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CWriter::AddKeyWrappingCallback - Registers a callback to deal with data key encryption/decryption from keystore
	* @param[in] sConsumerID - The ConsumerID to register for
	* @param[in] pTheCallback - The callback to be callede for wrapping and encryption key
	* @param[in] pUserData - Userdata that is passed to the callback function
	*/
	void CWriter::AddKeyWrappingCallback(const std::string & sConsumerID, const KeyWrappingCallback pTheCallback, const Lib3MF_pvoid pUserData)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_AddKeyWrappingCallback(m_pHandle, sConsumerID.c_str(), pTheCallback, pUserData));
	}
	
	/**
	* CWriter::SetContentEncryptionCallback - Registers a callback to deal with encryption of content
	* @param[in] pTheCallback - The callback used to encrypt content
	* @param[in] pUserData - Userdata that is passed to the callback function
	*/
	void CWriter::SetContentEncryptionCallback(const ContentEncryptionCallback pTheCallback, const Lib3MF_pvoid pUserData)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Writer_SetContentEncryptionCallback(m_pHandle, pTheCallback, pUserData));
	}
	
	/**
	 * Method definitions for class CReader
	 */
	
	/**
	* CReader::ReadFromFile - Reads a model from a file. The file type is specified by the Model Reader class
	* @param[in] sFilename - Filename to read from
	*/
	void CReader::ReadFromFile(const std::string & sFilename)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_ReadFromFile(m_pHandle, sFilename.c_str()));
	}
	
	/**
	* CReader::ReadFromBuffer - Reads a model from a memory buffer.
	* @param[in] BufferBuffer - Buffer to read from
	*/
	void CReader::ReadFromBuffer(const CInputVector<Lib3MF_uint8> & BufferBuffer)
	{
		Lib3MF_uint64 nBufferSize = BufferBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_ReadFromBuffer(m_pHandle, nBufferSize, BufferBuffer.data()));
	}
	
	/**
	* CReader::ReadFromCallback - Reads a model and from the data provided by a callback function
	* @param[in] pTheReadCallback - Callback to call for reading a data chunk
	* @param[in] nStreamSize - number of bytes the callback returns
	* @param[in] pTheSeekCallback - Callback to call for seeking in the stream.
	* @param[in] pUserData - Userdata that is passed to the callback function
	*/
	void CReader::ReadFromCallback(const ReadCallback pTheReadCallback, const Lib3MF_uint64 nStreamSize, const SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_ReadFromCallback(m_pHandle, pTheReadCallback, nStreamSize, pTheSeekCallback, pUserData));
	}
	
	/**
	* CReader::SetProgressCallback - Set the progress callback for calls to this writer
	* @param[in] pProgressCallback - pointer to the callback function.
	* @param[in] pUserData - pointer to arbitrary user data that is passed without modification to the callback.
	*/
	void CReader::SetProgressCallback(const ProgressCallback pProgressCallback, const Lib3MF_pvoid pUserData)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_SetProgressCallback(m_pHandle, pProgressCallback, pUserData));
	}
	
	/**
	* CReader::AddRelationToRead - Adds a relationship type which shall be read as attachment in memory while loading
	* @param[in] sRelationShipType - String of the relationship type
	*/
	void CReader::AddRelationToRead(const std::string & sRelationShipType)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_AddRelationToRead(m_pHandle, sRelationShipType.c_str()));
	}
	
	/**
	* CReader::RemoveRelationToRead - Removes a relationship type which shall be read as attachment in memory while loading
	* @param[in] sRelationShipType - String of the relationship type
	*/
	void CReader::RemoveRelationToRead(const std::string & sRelationShipType)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_RemoveRelationToRead(m_pHandle, sRelationShipType.c_str()));
	}
	
	/**
	* CReader::SetStrictModeActive - Activates (deactivates) the strict mode of the reader.
	* @param[in] bStrictModeActive - flag whether strict mode is active or not.
	*/
	void CReader::SetStrictModeActive(const bool bStrictModeActive)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_SetStrictModeActive(m_pHandle, bStrictModeActive));
	}
	
	/**
	* CReader::GetStrictModeActive - Queries whether the strict mode of the reader is active or not
	* @return returns flag whether strict mode is active or not.
	*/
	bool CReader::GetStrictModeActive()
	{
		bool resultStrictModeActive = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_GetStrictModeActive(m_pHandle, &resultStrictModeActive));
		
		return resultStrictModeActive;
	}
	
	/**
	* CReader::GetWarning - Returns Warning and Error Information of the read process
	* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
	* @param[out] nErrorCode - filled with the error code of the warning
	* @return the message of the warning
	*/
	std::string CReader::GetWarning(const Lib3MF_uint32 nIndex, Lib3MF_uint32 & nErrorCode)
	{
		Lib3MF_uint32 bytesNeededWarning = 0;
		Lib3MF_uint32 bytesWrittenWarning = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_GetWarning(m_pHandle, nIndex, &nErrorCode, 0, &bytesNeededWarning, nullptr));
		std::vector<char> bufferWarning(bytesNeededWarning);
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_GetWarning(m_pHandle, nIndex, &nErrorCode, bytesNeededWarning, &bytesWrittenWarning, &bufferWarning[0]));
		
		return std::string(&bufferWarning[0]);
	}
	
	/**
	* CReader::GetWarningCount - Returns Warning and Error Count of the read process
	* @return filled with the count of the occurred warnings.
	*/
	Lib3MF_uint32 CReader::GetWarningCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_GetWarningCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CReader::AddKeyWrappingCallback - Registers a callback to deal with key wrapping mechanism from keystore
	* @param[in] sConsumerID - The ConsumerID to register for
	* @param[in] pTheCallback - The callback used to decrypt data key
	* @param[in] pUserData - Userdata that is passed to the callback function
	*/
	void CReader::AddKeyWrappingCallback(const std::string & sConsumerID, const KeyWrappingCallback pTheCallback, const Lib3MF_pvoid pUserData)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_AddKeyWrappingCallback(m_pHandle, sConsumerID.c_str(), pTheCallback, pUserData));
	}
	
	/**
	* CReader::SetContentEncryptionCallback - Registers a callback to deal with encryption of content
	* @param[in] pTheCallback - The callback used to encrypt content
	* @param[in] pUserData - Userdata that is passed to the callback function
	*/
	void CReader::SetContentEncryptionCallback(const ContentEncryptionCallback pTheCallback, const Lib3MF_pvoid pUserData)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Reader_SetContentEncryptionCallback(m_pHandle, pTheCallback, pUserData));
	}
	
	/**
	 * Method definitions for class CPackagePart
	 */
	
	/**
	* CPackagePart::GetPath - Returns the absolute path of this PackagePart.
	* @return Returns the absolute path of this PackagePart
	*/
	std::string CPackagePart::GetPath()
	{
		Lib3MF_uint32 bytesNeededPath = 0;
		Lib3MF_uint32 bytesWrittenPath = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_PackagePart_GetPath(m_pHandle, 0, &bytesNeededPath, nullptr));
		std::vector<char> bufferPath(bytesNeededPath);
		CheckError(m_pWrapper->m_WrapperTable.m_PackagePart_GetPath(m_pHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]));
		
		return std::string(&bufferPath[0]);
	}
	
	/**
	* CPackagePart::SetPath - Sets the absolute path of this PackagePart.
	* @param[in] sPath - Sets the absolute path of this PackagePart.
	*/
	void CPackagePart::SetPath(const std::string & sPath)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_PackagePart_SetPath(m_pHandle, sPath.c_str()));
	}
	
	/**
	 * Method definitions for class CResource
	 */
	
	/**
	* CResource::GetResourceID - Retrieves the unique id of this resource within a package. This function will be removed in a later release in favor of GetUniqueResourceID
	* @return Retrieves the unique id of this resource within a package.
	*/
	Lib3MF_uint32 CResource::GetResourceID()
	{
		Lib3MF_uint32 resultUniqueResourceID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Resource_GetResourceID(m_pHandle, &resultUniqueResourceID));
		
		return resultUniqueResourceID;
	}
	
	/**
	* CResource::GetUniqueResourceID - Retrieves the unique id of this resource within a package.
	* @return Retrieves the unique id of this resource within a package.
	*/
	Lib3MF_uint32 CResource::GetUniqueResourceID()
	{
		Lib3MF_uint32 resultUniqueResourceID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Resource_GetUniqueResourceID(m_pHandle, &resultUniqueResourceID));
		
		return resultUniqueResourceID;
	}
	
	/**
	* CResource::PackagePart - Returns the PackagePart within which this resource resides
	* @return the PackagePart within which this resource resides.
	*/
	PPackagePart CResource::PackagePart()
	{
		Lib3MFHandle hPackagePart = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Resource_PackagePart(m_pHandle, &hPackagePart));
		
		if (!hPackagePart) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CPackagePart>(dynamic_cast<CPackagePart*>(m_pWrapper->polymorphicFactory(hPackagePart)));
	}
	
	/**
	* CResource::SetPackagePart - Sets the new PackagePart within which this resource resides
	* @param[in] pPackagePart - the new PackagePart within which this resource resides.
	*/
	void CResource::SetPackagePart(classParam<CPackagePart> pPackagePart)
	{
		Lib3MFHandle hPackagePart = pPackagePart.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_Resource_SetPackagePart(m_pHandle, hPackagePart));
	}
	
	/**
	* CResource::GetModelResourceID - Retrieves the id of this resource within a model.
	* @return Retrieves the id of this resource within a model.
	*/
	Lib3MF_uint32 CResource::GetModelResourceID()
	{
		Lib3MF_uint32 resultModelResourceId = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Resource_GetModelResourceID(m_pHandle, &resultModelResourceId));
		
		return resultModelResourceId;
	}
	
	/**
	 * Method definitions for class CResourceIterator
	 */
	
	/**
	* CResourceIterator::MoveNext - Iterates to the next resource in the list.
	* @return Iterates to the next resource in the list.
	*/
	bool CResourceIterator::MoveNext()
	{
		bool resultHasNext = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceIterator_MoveNext(m_pHandle, &resultHasNext));
		
		return resultHasNext;
	}
	
	/**
	* CResourceIterator::MovePrevious - Iterates to the previous resource in the list.
	* @return Iterates to the previous resource in the list.
	*/
	bool CResourceIterator::MovePrevious()
	{
		bool resultHasPrevious = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceIterator_MovePrevious(m_pHandle, &resultHasPrevious));
		
		return resultHasPrevious;
	}
	
	/**
	* CResourceIterator::GetCurrent - Returns the resource the iterator points at.
	* @return returns the resource instance.
	*/
	PResource CResourceIterator::GetCurrent()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceIterator_GetCurrent(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CResource>(dynamic_cast<CResource*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	* CResourceIterator::Clone - Creates a new resource iterator with the same resource list.
	* @return returns the cloned Iterator instance
	*/
	PResourceIterator CResourceIterator::Clone()
	{
		Lib3MFHandle hOutResourceIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceIterator_Clone(m_pHandle, &hOutResourceIterator));
		
		if (!hOutResourceIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CResourceIterator>(dynamic_cast<CResourceIterator*>(m_pWrapper->polymorphicFactory(hOutResourceIterator)));
	}
	
	/**
	* CResourceIterator::Count - Returns the number of resoucres the iterator captures.
	* @return returns the number of resoucres the iterator captures.
	*/
	Lib3MF_uint64 CResourceIterator::Count()
	{
		Lib3MF_uint64 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceIterator_Count(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	 * Method definitions for class CSliceStackIterator
	 */
	
	/**
	* CSliceStackIterator::GetCurrentSliceStack - Returns the SliceStack the iterator points at.
	* @return returns the SliceStack instance.
	*/
	PSliceStack CSliceStackIterator::GetCurrentSliceStack()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStackIterator_GetCurrentSliceStack(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSliceStack>(dynamic_cast<CSliceStack*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CObjectIterator
	 */
	
	/**
	* CObjectIterator::GetCurrentObject - Returns the Object the iterator points at.
	* @return returns the Object instance.
	*/
	PObject CObjectIterator::GetCurrentObject()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ObjectIterator_GetCurrentObject(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CObject>(dynamic_cast<CObject*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CMeshObjectIterator
	 */
	
	/**
	* CMeshObjectIterator::GetCurrentMeshObject - Returns the MeshObject the iterator points at.
	* @return returns the MeshObject instance.
	*/
	PMeshObject CMeshObjectIterator::GetCurrentMeshObject()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObjectIterator_GetCurrentMeshObject(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMeshObject>(dynamic_cast<CMeshObject*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CComponentsObjectIterator
	 */
	
	/**
	* CComponentsObjectIterator::GetCurrentComponentsObject - Returns the ComponentsObject the iterator points at.
	* @return returns the ComponentsObject instance.
	*/
	PComponentsObject CComponentsObjectIterator::GetCurrentComponentsObject()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComponentsObjectIterator_GetCurrentComponentsObject(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CComponentsObject>(dynamic_cast<CComponentsObject*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CTexture2DIterator
	 */
	
	/**
	* CTexture2DIterator::GetCurrentTexture2D - Returns the Texture2D the iterator points at.
	* @return returns the Texture2D instance.
	*/
	PTexture2D CTexture2DIterator::GetCurrentTexture2D()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2DIterator_GetCurrentTexture2D(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTexture2D>(dynamic_cast<CTexture2D*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CBaseMaterialGroupIterator
	 */
	
	/**
	* CBaseMaterialGroupIterator::GetCurrentBaseMaterialGroup - Returns the MaterialGroup the iterator points at.
	* @return returns the BaseMaterialGroup instance.
	*/
	PBaseMaterialGroup CBaseMaterialGroupIterator::GetCurrentBaseMaterialGroup()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBaseMaterialGroup>(dynamic_cast<CBaseMaterialGroup*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CColorGroupIterator
	 */
	
	/**
	* CColorGroupIterator::GetCurrentColorGroup - Returns the ColorGroup the iterator points at.
	* @return returns the ColorGroup instance.
	*/
	PColorGroup CColorGroupIterator::GetCurrentColorGroup()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ColorGroupIterator_GetCurrentColorGroup(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CColorGroup>(dynamic_cast<CColorGroup*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CTexture2DGroupIterator
	 */
	
	/**
	* CTexture2DGroupIterator::GetCurrentTexture2DGroup - Returns the Texture2DGroup the iterator points at.
	* @return returns the Texture2DGroup instance.
	*/
	PTexture2DGroup CTexture2DGroupIterator::GetCurrentTexture2DGroup()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2DGroupIterator_GetCurrentTexture2DGroup(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTexture2DGroup>(dynamic_cast<CTexture2DGroup*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CCompositeMaterialsIterator
	 */
	
	/**
	* CCompositeMaterialsIterator::GetCurrentCompositeMaterials - Returns the CompositeMaterials the iterator points at.
	* @return returns the CompositeMaterials instance.
	*/
	PCompositeMaterials CCompositeMaterialsIterator::GetCurrentCompositeMaterials()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_CompositeMaterialsIterator_GetCurrentCompositeMaterials(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CCompositeMaterials>(dynamic_cast<CCompositeMaterials*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CMultiPropertyGroupIterator
	 */
	
	/**
	* CMultiPropertyGroupIterator::GetCurrentMultiPropertyGroup - Returns the MultiPropertyGroup the iterator points at.
	* @return returns the MultiPropertyGroup instance.
	*/
	PMultiPropertyGroup CMultiPropertyGroupIterator::GetCurrentMultiPropertyGroup()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMultiPropertyGroup>(dynamic_cast<CMultiPropertyGroup*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CImage3DIterator
	 */
	
	/**
	* CImage3DIterator::GetCurrentImage3D - Returns the Image3D the iterator points at.
	* @return returns the Image3D instance.
	*/
	PImage3D CImage3DIterator::GetCurrentImage3D()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Image3DIterator_GetCurrentImage3D(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImage3D>(dynamic_cast<CImage3D*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CFunctionIterator
	 */
	
	/**
	* CFunctionIterator::GetCurrentFunction - Returns the Function the iterator points at.
	* @return returns the Function instance.
	*/
	PFunction CFunctionIterator::GetCurrentFunction()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionIterator_GetCurrentFunction(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CFunction>(dynamic_cast<CFunction*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CLevelSetIterator
	 */
	
	/**
	* CLevelSetIterator::GetCurrentLevelSet - Returns the LevelSet the iterator points at.
	* @return returns the MeshObject instance.
	*/
	PLevelSet CLevelSetIterator::GetCurrentLevelSet()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSetIterator_GetCurrentLevelSet(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CLevelSet>(dynamic_cast<CLevelSet*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	 * Method definitions for class CMetaData
	 */
	
	/**
	* CMetaData::GetNameSpace - returns the namespace URL of the metadata
	* @return the namespace URL of the metadata
	*/
	std::string CMetaData::GetNameSpace()
	{
		Lib3MF_uint32 bytesNeededNameSpace = 0;
		Lib3MF_uint32 bytesWrittenNameSpace = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_GetNameSpace(m_pHandle, 0, &bytesNeededNameSpace, nullptr));
		std::vector<char> bufferNameSpace(bytesNeededNameSpace);
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_GetNameSpace(m_pHandle, bytesNeededNameSpace, &bytesWrittenNameSpace, &bufferNameSpace[0]));
		
		return std::string(&bufferNameSpace[0]);
	}
	
	/**
	* CMetaData::SetNameSpace - sets a new namespace URL of the metadata
	* @param[in] sNameSpace - the new namespace URL of the metadata
	*/
	void CMetaData::SetNameSpace(const std::string & sNameSpace)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_SetNameSpace(m_pHandle, sNameSpace.c_str()));
	}
	
	/**
	* CMetaData::GetName - returns the name of a metadata
	* @return the name of the metadata
	*/
	std::string CMetaData::GetName()
	{
		Lib3MF_uint32 bytesNeededName = 0;
		Lib3MF_uint32 bytesWrittenName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_GetName(m_pHandle, 0, &bytesNeededName, nullptr));
		std::vector<char> bufferName(bytesNeededName);
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_GetName(m_pHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]));
		
		return std::string(&bufferName[0]);
	}
	
	/**
	* CMetaData::SetName - sets a new name of a metadata
	* @param[in] sName - the new name of the metadata
	*/
	void CMetaData::SetName(const std::string & sName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_SetName(m_pHandle, sName.c_str()));
	}
	
	/**
	* CMetaData::GetKey - returns the (namespace+name) of a metadata
	* @return the key (namespace+name) of the metadata
	*/
	std::string CMetaData::GetKey()
	{
		Lib3MF_uint32 bytesNeededKey = 0;
		Lib3MF_uint32 bytesWrittenKey = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_GetKey(m_pHandle, 0, &bytesNeededKey, nullptr));
		std::vector<char> bufferKey(bytesNeededKey);
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_GetKey(m_pHandle, bytesNeededKey, &bytesWrittenKey, &bufferKey[0]));
		
		return std::string(&bufferKey[0]);
	}
	
	/**
	* CMetaData::GetMustPreserve - returns, whether a metadata must be preserved
	* @return returns, whether a metadata must be preserved
	*/
	bool CMetaData::GetMustPreserve()
	{
		bool resultMustPreserve = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_GetMustPreserve(m_pHandle, &resultMustPreserve));
		
		return resultMustPreserve;
	}
	
	/**
	* CMetaData::SetMustPreserve - sets whether a metadata must be preserved
	* @param[in] bMustPreserve - a new value whether a metadata must be preserved
	*/
	void CMetaData::SetMustPreserve(const bool bMustPreserve)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_SetMustPreserve(m_pHandle, bMustPreserve));
	}
	
	/**
	* CMetaData::GetType - returns the type of a metadata
	* @return the type of the metadata
	*/
	std::string CMetaData::GetType()
	{
		Lib3MF_uint32 bytesNeededType = 0;
		Lib3MF_uint32 bytesWrittenType = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_GetType(m_pHandle, 0, &bytesNeededType, nullptr));
		std::vector<char> bufferType(bytesNeededType);
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_GetType(m_pHandle, bytesNeededType, &bytesWrittenType, &bufferType[0]));
		
		return std::string(&bufferType[0]);
	}
	
	/**
	* CMetaData::SetType - sets a new type of a metadata. This must be a simple XML type
	* @param[in] sType - a new type of the metadata
	*/
	void CMetaData::SetType(const std::string & sType)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_SetType(m_pHandle, sType.c_str()));
	}
	
	/**
	* CMetaData::GetValue - returns the value of the metadata
	* @return the value of the metadata
	*/
	std::string CMetaData::GetValue()
	{
		Lib3MF_uint32 bytesNeededValue = 0;
		Lib3MF_uint32 bytesWrittenValue = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_GetValue(m_pHandle, 0, &bytesNeededValue, nullptr));
		std::vector<char> bufferValue(bytesNeededValue);
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_GetValue(m_pHandle, bytesNeededValue, &bytesWrittenValue, &bufferValue[0]));
		
		return std::string(&bufferValue[0]);
	}
	
	/**
	* CMetaData::SetValue - sets a new value of the metadata
	* @param[in] sValue - a new value of the metadata
	*/
	void CMetaData::SetValue(const std::string & sValue)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MetaData_SetValue(m_pHandle, sValue.c_str()));
	}
	
	/**
	 * Method definitions for class CMetaDataGroup
	 */
	
	/**
	* CMetaDataGroup::GetMetaDataCount - returns the number of metadata in this metadatagroup
	* @return returns the number metadata
	*/
	Lib3MF_uint32 CMetaDataGroup::GetMetaDataCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MetaDataGroup_GetMetaDataCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CMetaDataGroup::GetMetaData - returns a metadata value within this metadatagroup
	* @param[in] nIndex - Index of the Metadata.
	* @return an instance of the metadata
	*/
	PMetaData CMetaDataGroup::GetMetaData(const Lib3MF_uint32 nIndex)
	{
		Lib3MFHandle hMetaData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MetaDataGroup_GetMetaData(m_pHandle, nIndex, &hMetaData));
		
		if (!hMetaData) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMetaData>(dynamic_cast<CMetaData*>(m_pWrapper->polymorphicFactory(hMetaData)));
	}
	
	/**
	* CMetaDataGroup::GetMetaDataByKey - returns a metadata value within this metadatagroup
	* @param[in] sNameSpace - the namespace of the metadata
	* @param[in] sName - the name of the Metadata
	* @return an instance of the metadata
	*/
	PMetaData CMetaDataGroup::GetMetaDataByKey(const std::string & sNameSpace, const std::string & sName)
	{
		Lib3MFHandle hMetaData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MetaDataGroup_GetMetaDataByKey(m_pHandle, sNameSpace.c_str(), sName.c_str(), &hMetaData));
		
		if (!hMetaData) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMetaData>(dynamic_cast<CMetaData*>(m_pWrapper->polymorphicFactory(hMetaData)));
	}
	
	/**
	* CMetaDataGroup::RemoveMetaDataByIndex - removes metadata by index from the model.
	* @param[in] nIndex -  Index of the metadata to remove
	*/
	void CMetaDataGroup::RemoveMetaDataByIndex(const Lib3MF_uint32 nIndex)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MetaDataGroup_RemoveMetaDataByIndex(m_pHandle, nIndex));
	}
	
	/**
	* CMetaDataGroup::RemoveMetaData - removes metadata from the model.
	* @param[in] pTheMetaData - The metadata to remove
	*/
	void CMetaDataGroup::RemoveMetaData(classParam<CMetaData> pTheMetaData)
	{
		Lib3MFHandle hTheMetaData = pTheMetaData.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_MetaDataGroup_RemoveMetaData(m_pHandle, hTheMetaData));
	}
	
	/**
	* CMetaDataGroup::AddMetaData - adds a new metadata to this metadatagroup
	* @param[in] sNameSpace - the namespace of the metadata
	* @param[in] sName - the name of the metadata
	* @param[in] sValue - the value of the metadata
	* @param[in] sType - the type of the metadata
	* @param[in] bMustPreserve - should the metadata be preserved
	* @return a new instance of the metadata
	*/
	PMetaData CMetaDataGroup::AddMetaData(const std::string & sNameSpace, const std::string & sName, const std::string & sValue, const std::string & sType, const bool bMustPreserve)
	{
		Lib3MFHandle hMetaData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MetaDataGroup_AddMetaData(m_pHandle, sNameSpace.c_str(), sName.c_str(), sValue.c_str(), sType.c_str(), bMustPreserve, &hMetaData));
		
		if (!hMetaData) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMetaData>(dynamic_cast<CMetaData*>(m_pWrapper->polymorphicFactory(hMetaData)));
	}
	
	/**
	 * Method definitions for class CTriangleSet
	 */
	
	/**
	* CTriangleSet::SetName - sets the name of the triangle set
	* @param[in] sName - the new name
	*/
	void CTriangleSet::SetName(const std::string & sName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_SetName(m_pHandle, sName.c_str()));
	}
	
	/**
	* CTriangleSet::GetName - returns the name of the triangle set
	* @return returns the name
	*/
	std::string CTriangleSet::GetName()
	{
		Lib3MF_uint32 bytesNeededName = 0;
		Lib3MF_uint32 bytesWrittenName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_GetName(m_pHandle, 0, &bytesNeededName, nullptr));
		std::vector<char> bufferName(bytesNeededName);
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_GetName(m_pHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]));
		
		return std::string(&bufferName[0]);
	}
	
	/**
	* CTriangleSet::SetIdentifier - sets the identifier of the triangle set.
	* @param[in] sIdentifier - the new identifier. MUST be unique within the mesh. MUST NOT be an empty string
	*/
	void CTriangleSet::SetIdentifier(const std::string & sIdentifier)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_SetIdentifier(m_pHandle, sIdentifier.c_str()));
	}
	
	/**
	* CTriangleSet::GetIdentifier - returns the identifier of the triangle set
	* @return returns the identifier
	*/
	std::string CTriangleSet::GetIdentifier()
	{
		Lib3MF_uint32 bytesNeededIdentifier = 0;
		Lib3MF_uint32 bytesWrittenIdentifier = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_GetIdentifier(m_pHandle, 0, &bytesNeededIdentifier, nullptr));
		std::vector<char> bufferIdentifier(bytesNeededIdentifier);
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_GetIdentifier(m_pHandle, bytesNeededIdentifier, &bytesWrittenIdentifier, &bufferIdentifier[0]));
		
		return std::string(&bufferIdentifier[0]);
	}
	
	/**
	* CTriangleSet::AddTriangle - adds a triangle to the set. Does nothing if triangle is already in the set.
	* @param[in] nTriangleIndex - Triangle index to add. MUST be between 0 and TriangleCount - 1.
	*/
	void CTriangleSet::AddTriangle(const Lib3MF_uint32 nTriangleIndex)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_AddTriangle(m_pHandle, nTriangleIndex));
	}
	
	/**
	* CTriangleSet::RemoveTriangle - removes a triangle from the set
	* @param[in] nTriangleIndex - Triangle index to remove. MUST be between 0 and TriangleCount - 1.
	*/
	void CTriangleSet::RemoveTriangle(const Lib3MF_uint32 nTriangleIndex)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_RemoveTriangle(m_pHandle, nTriangleIndex));
	}
	
	/**
	* CTriangleSet::Clear - clears all triangles from the list
	*/
	void CTriangleSet::Clear()
	{
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_Clear(m_pHandle));
	}
	
	/**
	* CTriangleSet::SetTriangleList - Sets all triangles in the list, while clearing old values. Duplicates will be merged.
	* @param[in] TriangleIndicesBuffer - Triangle indices to add. Every element MUST be between 0 and TriangleCount - 1.
	*/
	void CTriangleSet::SetTriangleList(const CInputVector<Lib3MF_uint32> & TriangleIndicesBuffer)
	{
		Lib3MF_uint64 nTriangleIndicesSize = TriangleIndicesBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_SetTriangleList(m_pHandle, nTriangleIndicesSize, TriangleIndicesBuffer.data()));
	}
	
	/**
	* CTriangleSet::GetTriangleList - Retrieves all the triangles in the TriangleSet
	* @param[out] TriangleIndicesBuffer - retrieves the indices of the triangles in this TriangleSet
	*/
	void CTriangleSet::GetTriangleList(std::vector<Lib3MF_uint32> & TriangleIndicesBuffer)
	{
		Lib3MF_uint64 elementsNeededTriangleIndices = 0;
		Lib3MF_uint64 elementsWrittenTriangleIndices = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_GetTriangleList(m_pHandle, 0, &elementsNeededTriangleIndices, nullptr));
		TriangleIndicesBuffer.resize((size_t) elementsNeededTriangleIndices);
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_GetTriangleList(m_pHandle, elementsNeededTriangleIndices, &elementsWrittenTriangleIndices, TriangleIndicesBuffer.data()));
	}
	
	/**
	* CTriangleSet::AddTriangleList - Adds multiple triangles in the list. Duplicates will be merged.
	* @param[in] TriangleIndicesBuffer - Triangle indices to add. Every element MUST be between 0 and TriangleCount - 1.
	*/
	void CTriangleSet::AddTriangleList(const CInputVector<Lib3MF_uint32> & TriangleIndicesBuffer)
	{
		Lib3MF_uint64 nTriangleIndicesSize = TriangleIndicesBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_AddTriangleList(m_pHandle, nTriangleIndicesSize, TriangleIndicesBuffer.data()));
	}
	
	/**
	* CTriangleSet::Merge - Merges another Triangle set.
	* @param[in] pOtherTriangleSet - Other triangle set to merge.
	* @param[in] bDeleteOther - Flag if other triangle set is getting removed.
	*/
	void CTriangleSet::Merge(classParam<CTriangleSet> pOtherTriangleSet, const bool bDeleteOther)
	{
		Lib3MFHandle hOtherTriangleSet = pOtherTriangleSet.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_Merge(m_pHandle, hOtherTriangleSet, bDeleteOther));
	}
	
	/**
	* CTriangleSet::DeleteSet - Deletes the whole set from the mesh.
	*/
	void CTriangleSet::DeleteSet()
	{
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_DeleteSet(m_pHandle));
	}
	
	/**
	* CTriangleSet::Duplicate - Duplicates the set in the mesh.
	* @param[in] sIdentifier - the new identifier. MUST be unique within the mesh. MUST NOT be an empty string
	* @return Copy of the triangle set.
	*/
	PTriangleSet CTriangleSet::Duplicate(const std::string & sIdentifier)
	{
		Lib3MFHandle hNewSet = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_TriangleSet_Duplicate(m_pHandle, sIdentifier.c_str(), &hNewSet));
		
		if (!hNewSet) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTriangleSet>(dynamic_cast<CTriangleSet*>(m_pWrapper->polymorphicFactory(hNewSet)));
	}
	
	/**
	 * Method definitions for class CObject
	 */
	
	/**
	* CObject::GetType - Retrieves an object's type
	* @return returns object type enum.
	*/
	eObjectType CObject::GetType()
	{
		eObjectType resultObjectType = (eObjectType) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetType(m_pHandle, &resultObjectType));
		
		return resultObjectType;
	}
	
	/**
	* CObject::SetType - Sets an object's type
	* @param[in] eObjectType - object type enum.
	*/
	void CObject::SetType(const eObjectType eObjectType)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Object_SetType(m_pHandle, eObjectType));
	}
	
	/**
	* CObject::GetName - Retrieves an object's name
	* @return returns object name.
	*/
	std::string CObject::GetName()
	{
		Lib3MF_uint32 bytesNeededName = 0;
		Lib3MF_uint32 bytesWrittenName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetName(m_pHandle, 0, &bytesNeededName, nullptr));
		std::vector<char> bufferName(bytesNeededName);
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetName(m_pHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]));
		
		return std::string(&bufferName[0]);
	}
	
	/**
	* CObject::SetName - Sets an object's name string
	* @param[in] sName - new object name.
	*/
	void CObject::SetName(const std::string & sName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Object_SetName(m_pHandle, sName.c_str()));
	}
	
	/**
	* CObject::GetPartNumber - Retrieves an object's part number
	* @return returns object part number.
	*/
	std::string CObject::GetPartNumber()
	{
		Lib3MF_uint32 bytesNeededPartNumber = 0;
		Lib3MF_uint32 bytesWrittenPartNumber = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetPartNumber(m_pHandle, 0, &bytesNeededPartNumber, nullptr));
		std::vector<char> bufferPartNumber(bytesNeededPartNumber);
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetPartNumber(m_pHandle, bytesNeededPartNumber, &bytesWrittenPartNumber, &bufferPartNumber[0]));
		
		return std::string(&bufferPartNumber[0]);
	}
	
	/**
	* CObject::SetPartNumber - Sets an objects partnumber string
	* @param[in] sPartNumber - new object part number.
	*/
	void CObject::SetPartNumber(const std::string & sPartNumber)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Object_SetPartNumber(m_pHandle, sPartNumber.c_str()));
	}
	
	/**
	* CObject::IsMeshObject - Retrieves, if an object is a mesh object
	* @return returns, whether the object is a mesh object
	*/
	bool CObject::IsMeshObject()
	{
		bool resultIsMeshObject = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_IsMeshObject(m_pHandle, &resultIsMeshObject));
		
		return resultIsMeshObject;
	}
	
	/**
	* CObject::IsComponentsObject - Retrieves, if an object is a components object
	* @return returns, whether the object is a components object
	*/
	bool CObject::IsComponentsObject()
	{
		bool resultIsComponentsObject = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_IsComponentsObject(m_pHandle, &resultIsComponentsObject));
		
		return resultIsComponentsObject;
	}
	
	/**
	* CObject::IsLevelSetObject - Retrieves, if an object is a level set object
	* @return returns, whether the object is a level set object
	*/
	bool CObject::IsLevelSetObject()
	{
		bool resultIsLevelSetObject = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_IsLevelSetObject(m_pHandle, &resultIsLevelSetObject));
		
		return resultIsLevelSetObject;
	}
	
	/**
	* CObject::IsValid - Retrieves, if the object is valid according to the core spec. For mesh objects, we distinguish between the type attribute of the object:In case of object type other, this always means false.In case of object type model or solidsupport, this means, if the mesh suffices all requirements of the core spec chapter 4.1.In case of object type support or surface, this always means true.A component objects is valid if and only if it contains at least one component and all child components are valid objects.
	* @return returns whether the object is a valid object description
	*/
	bool CObject::IsValid()
	{
		bool resultIsValid = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_IsValid(m_pHandle, &resultIsValid));
		
		return resultIsValid;
	}
	
	/**
	* CObject::SetAttachmentAsThumbnail - Use an existing attachment as thumbnail for this object
	* @param[in] pAttachment - Instance of a new or the existing thumbnailattachment object.
	*/
	void CObject::SetAttachmentAsThumbnail(classParam<CAttachment> pAttachment)
	{
		Lib3MFHandle hAttachment = pAttachment.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_Object_SetAttachmentAsThumbnail(m_pHandle, hAttachment));
	}
	
	/**
	* CObject::GetThumbnailAttachment - Get the attachment containing the object thumbnail.
	* @return Instance of the thumbnailattachment object or NULL.
	*/
	PAttachment CObject::GetThumbnailAttachment()
	{
		Lib3MFHandle hAttachment = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetThumbnailAttachment(m_pHandle, &hAttachment));
		
		if (hAttachment) {
			return std::shared_ptr<CAttachment>(dynamic_cast<CAttachment*>(m_pWrapper->polymorphicFactory(hAttachment)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CObject::ClearThumbnailAttachment - Clears the attachment. The attachment instance is not removed from the package.
	*/
	void CObject::ClearThumbnailAttachment()
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Object_ClearThumbnailAttachment(m_pHandle));
	}
	
	/**
	* CObject::GetOutbox - Returns the outbox of a build item
	* @return Outbox of this build item
	*/
	sBox CObject::GetOutbox()
	{
		sBox resultOutbox;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetOutbox(m_pHandle, &resultOutbox));
		
		return resultOutbox;
	}
	
	/**
	* CObject::GetUUID - Retrieves an object's uuid string (see production extension specification)
	* @param[out] bHasUUID - flag whether the build item has a UUID
	* @return returns object uuid.
	*/
	std::string CObject::GetUUID(bool & bHasUUID)
	{
		Lib3MF_uint32 bytesNeededUUID = 0;
		Lib3MF_uint32 bytesWrittenUUID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetUUID(m_pHandle, &bHasUUID, 0, &bytesNeededUUID, nullptr));
		std::vector<char> bufferUUID(bytesNeededUUID);
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetUUID(m_pHandle, &bHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]));
		
		return std::string(&bufferUUID[0]);
	}
	
	/**
	* CObject::SetUUID - Sets a build object's uuid string (see production extension specification)
	* @param[in] sUUID - new object uuid string.
	*/
	void CObject::SetUUID(const std::string & sUUID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Object_SetUUID(m_pHandle, sUUID.c_str()));
	}
	
	/**
	* CObject::GetMetaDataGroup - Returns the metadatagroup of this object
	* @return returns an Instance of the metadatagroup of this object
	*/
	PMetaDataGroup CObject::GetMetaDataGroup()
	{
		Lib3MFHandle hMetaDataGroup = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetMetaDataGroup(m_pHandle, &hMetaDataGroup));
		
		if (!hMetaDataGroup) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMetaDataGroup>(dynamic_cast<CMetaDataGroup*>(m_pWrapper->polymorphicFactory(hMetaDataGroup)));
	}
	
	/**
	* CObject::SetSlicesMeshResolution - set the meshresolution of the mesh object
	* @param[in] eMeshResolution - meshresolution of this object
	*/
	void CObject::SetSlicesMeshResolution(const eSlicesMeshResolution eMeshResolution)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Object_SetSlicesMeshResolution(m_pHandle, eMeshResolution));
	}
	
	/**
	* CObject::GetSlicesMeshResolution - get the meshresolution of the mesh object
	* @return meshresolution of this object
	*/
	eSlicesMeshResolution CObject::GetSlicesMeshResolution()
	{
		eSlicesMeshResolution resultMeshResolution = (eSlicesMeshResolution) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetSlicesMeshResolution(m_pHandle, &resultMeshResolution));
		
		return resultMeshResolution;
	}
	
	/**
	* CObject::HasSlices - returns whether the Object has a slice stack. If Recursive is true, also checks whether any references object has a slice stack
	* @param[in] bRecursive - check also all referenced objects?
	* @return does the object have a slice stack?
	*/
	bool CObject::HasSlices(const bool bRecursive)
	{
		bool resultHasSlices = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_HasSlices(m_pHandle, bRecursive, &resultHasSlices));
		
		return resultHasSlices;
	}
	
	/**
	* CObject::ClearSliceStack - unlinks the attached slicestack from this object. If no slice stack is attached, do noting.
	*/
	void CObject::ClearSliceStack()
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Object_ClearSliceStack(m_pHandle));
	}
	
	/**
	* CObject::GetSliceStack - get the Slicestack attached to the object
	* @return returns the slicestack instance
	*/
	PSliceStack CObject::GetSliceStack()
	{
		Lib3MFHandle hSliceStackInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Object_GetSliceStack(m_pHandle, &hSliceStackInstance));
		
		if (!hSliceStackInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSliceStack>(dynamic_cast<CSliceStack*>(m_pWrapper->polymorphicFactory(hSliceStackInstance)));
	}
	
	/**
	* CObject::AssignSliceStack - assigns a slicestack to the object
	* @param[in] pSliceStackInstance - the new slice stack of this Object
	*/
	void CObject::AssignSliceStack(classParam<CSliceStack> pSliceStackInstance)
	{
		Lib3MFHandle hSliceStackInstance = pSliceStackInstance.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_Object_AssignSliceStack(m_pHandle, hSliceStackInstance));
	}
	
	/**
	 * Method definitions for class CMeshObject
	 */
	
	/**
	* CMeshObject::GetVertexCount - Returns the vertex count of a mesh object.
	* @return filled with the vertex count.
	*/
	Lib3MF_uint32 CMeshObject::GetVertexCount()
	{
		Lib3MF_uint32 resultVertexCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetVertexCount(m_pHandle, &resultVertexCount));
		
		return resultVertexCount;
	}
	
	/**
	* CMeshObject::GetTriangleCount - Returns the triangle count of a mesh object.
	* @return filled with the triangle count.
	*/
	Lib3MF_uint32 CMeshObject::GetTriangleCount()
	{
		Lib3MF_uint32 resultVertexCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetTriangleCount(m_pHandle, &resultVertexCount));
		
		return resultVertexCount;
	}
	
	/**
	* CMeshObject::GetVertex - Returns the vertex count of a mesh object.
	* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
	* @return filled with the vertex coordinates.
	*/
	sPosition CMeshObject::GetVertex(const Lib3MF_uint32 nIndex)
	{
		sPosition resultCoordinates;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetVertex(m_pHandle, nIndex, &resultCoordinates));
		
		return resultCoordinates;
	}
	
	/**
	* CMeshObject::SetVertex - Sets the coordinates of a single vertex of a mesh object
	* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
	* @param[in] Coordinates - contains the vertex coordinates.
	*/
	void CMeshObject::SetVertex(const Lib3MF_uint32 nIndex, const sPosition & Coordinates)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_SetVertex(m_pHandle, nIndex, &Coordinates));
	}
	
	/**
	* CMeshObject::AddVertex - Adds a single vertex to a mesh object
	* @param[in] Coordinates - contains the vertex coordinates.
	* @return Index of the new vertex
	*/
	Lib3MF_uint32 CMeshObject::AddVertex(const sPosition & Coordinates)
	{
		Lib3MF_uint32 resultNewIndex = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_AddVertex(m_pHandle, &Coordinates, &resultNewIndex));
		
		return resultNewIndex;
	}
	
	/**
	* CMeshObject::GetVertices - Obtains all vertex positions of a mesh object
	* @param[out] VerticesBuffer - contains the vertex coordinates.
	*/
	void CMeshObject::GetVertices(std::vector<sPosition> & VerticesBuffer)
	{
		Lib3MF_uint64 elementsNeededVertices = 0;
		Lib3MF_uint64 elementsWrittenVertices = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetVertices(m_pHandle, 0, &elementsNeededVertices, nullptr));
		VerticesBuffer.resize((size_t) elementsNeededVertices);
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetVertices(m_pHandle, elementsNeededVertices, &elementsWrittenVertices, VerticesBuffer.data()));
	}
	
	/**
	* CMeshObject::GetTriangle - Returns indices of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @return filled with the triangle indices.
	*/
	sTriangle CMeshObject::GetTriangle(const Lib3MF_uint32 nIndex)
	{
		sTriangle resultIndices;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetTriangle(m_pHandle, nIndex, &resultIndices));
		
		return resultIndices;
	}
	
	/**
	* CMeshObject::SetTriangle - Sets the indices of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[in] Indices - contains the triangle indices.
	*/
	void CMeshObject::SetTriangle(const Lib3MF_uint32 nIndex, const sTriangle & Indices)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_SetTriangle(m_pHandle, nIndex, &Indices));
	}
	
	/**
	* CMeshObject::AddTriangle - Adds a single triangle to a mesh object
	* @param[in] Indices - contains the triangle indices.
	* @return Index of the new triangle
	*/
	Lib3MF_uint32 CMeshObject::AddTriangle(const sTriangle & Indices)
	{
		Lib3MF_uint32 resultNewIndex = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_AddTriangle(m_pHandle, &Indices, &resultNewIndex));
		
		return resultNewIndex;
	}
	
	/**
	* CMeshObject::GetTriangleIndices - Get all triangles of a mesh object
	* @param[out] IndicesBuffer - contains the triangle indices.
	*/
	void CMeshObject::GetTriangleIndices(std::vector<sTriangle> & IndicesBuffer)
	{
		Lib3MF_uint64 elementsNeededIndices = 0;
		Lib3MF_uint64 elementsWrittenIndices = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetTriangleIndices(m_pHandle, 0, &elementsNeededIndices, nullptr));
		IndicesBuffer.resize((size_t) elementsNeededIndices);
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetTriangleIndices(m_pHandle, elementsNeededIndices, &elementsWrittenIndices, IndicesBuffer.data()));
	}
	
	/**
	* CMeshObject::SetObjectLevelProperty - Sets the property at the object-level of the mesh object.
	* @param[in] nUniqueResourceID - the object-level Property UniqueResourceID.
	* @param[in] nPropertyID - the object-level PropertyID.
	*/
	void CMeshObject::SetObjectLevelProperty(const Lib3MF_uint32 nUniqueResourceID, const Lib3MF_uint32 nPropertyID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_SetObjectLevelProperty(m_pHandle, nUniqueResourceID, nPropertyID));
	}
	
	/**
	* CMeshObject::GetObjectLevelProperty - Gets the property at the object-level of the mesh object.
	* @param[out] nUniqueResourceID - the object-level Property UniqueResourceID.
	* @param[out] nPropertyID - the object-level PropertyID.
	* @return Has an object-level property been specified?
	*/
	bool CMeshObject::GetObjectLevelProperty(Lib3MF_uint32 & nUniqueResourceID, Lib3MF_uint32 & nPropertyID)
	{
		bool resultHasObjectLevelProperty = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetObjectLevelProperty(m_pHandle, &nUniqueResourceID, &nPropertyID, &resultHasObjectLevelProperty));
		
		return resultHasObjectLevelProperty;
	}
	
	/**
	* CMeshObject::SetTriangleProperties - Sets the properties of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[in] Properties - contains the triangle properties.
	*/
	void CMeshObject::SetTriangleProperties(const Lib3MF_uint32 nIndex, const sTriangleProperties & Properties)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_SetTriangleProperties(m_pHandle, nIndex, &Properties));
	}
	
	/**
	* CMeshObject::GetTriangleProperties - Gets the properties of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[out] Property - returns the triangle properties.
	*/
	void CMeshObject::GetTriangleProperties(const Lib3MF_uint32 nIndex, sTriangleProperties & Property)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetTriangleProperties(m_pHandle, nIndex, &Property));
	}
	
	/**
	* CMeshObject::SetAllTriangleProperties - Sets the properties of all triangles of a mesh object. Sets the object level property to the first entry of the passed triangle properties, if not yet specified.
	* @param[in] PropertiesArrayBuffer - contains the triangle properties array. Must have trianglecount elements.
	*/
	void CMeshObject::SetAllTriangleProperties(const CInputVector<sTriangleProperties> & PropertiesArrayBuffer)
	{
		Lib3MF_uint64 nPropertiesArraySize = PropertiesArrayBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_SetAllTriangleProperties(m_pHandle, nPropertiesArraySize, PropertiesArrayBuffer.data()));
	}
	
	/**
	* CMeshObject::GetAllTriangleProperties - Gets the properties of all triangles of a mesh object.
	* @param[out] PropertiesArrayBuffer - returns the triangle properties array. Must have trianglecount elements.
	*/
	void CMeshObject::GetAllTriangleProperties(std::vector<sTriangleProperties> & PropertiesArrayBuffer)
	{
		Lib3MF_uint64 elementsNeededPropertiesArray = 0;
		Lib3MF_uint64 elementsWrittenPropertiesArray = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetAllTriangleProperties(m_pHandle, 0, &elementsNeededPropertiesArray, nullptr));
		PropertiesArrayBuffer.resize((size_t) elementsNeededPropertiesArray);
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetAllTriangleProperties(m_pHandle, elementsNeededPropertiesArray, &elementsWrittenPropertiesArray, PropertiesArrayBuffer.data()));
	}
	
	/**
	* CMeshObject::ClearAllProperties - Clears all properties of this mesh object (triangle and object-level).
	*/
	void CMeshObject::ClearAllProperties()
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_ClearAllProperties(m_pHandle));
	}
	
	/**
	* CMeshObject::SetGeometry - Set all triangles of a mesh object
	* @param[in] VerticesBuffer - contains the positions.
	* @param[in] IndicesBuffer - contains the triangle indices.
	*/
	void CMeshObject::SetGeometry(const CInputVector<sPosition> & VerticesBuffer, const CInputVector<sTriangle> & IndicesBuffer)
	{
		Lib3MF_uint64 nVerticesSize = VerticesBuffer.size();
		Lib3MF_uint64 nIndicesSize = IndicesBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_SetGeometry(m_pHandle, nVerticesSize, VerticesBuffer.data(), nIndicesSize, IndicesBuffer.data()));
	}
	
	/**
	* CMeshObject::IsManifoldAndOriented - Retrieves, if an object describes a topologically oriented and manifold mesh, according to the core spec.
	* @return returns, if the object is oriented and manifold.
	*/
	bool CMeshObject::IsManifoldAndOriented()
	{
		bool resultIsManifoldAndOriented = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_IsManifoldAndOriented(m_pHandle, &resultIsManifoldAndOriented));
		
		return resultIsManifoldAndOriented;
	}
	
	/**
	* CMeshObject::BeamLattice - Retrieves the BeamLattice within this MeshObject.
	* @return the BeamLattice within this MeshObject
	*/
	PBeamLattice CMeshObject::BeamLattice()
	{
		Lib3MFHandle hTheBeamLattice = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_BeamLattice(m_pHandle, &hTheBeamLattice));
		
		if (!hTheBeamLattice) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBeamLattice>(dynamic_cast<CBeamLattice*>(m_pWrapper->polymorphicFactory(hTheBeamLattice)));
	}
	
	/**
	* CMeshObject::GetVolumeData - Retrieves the VolumeData of this MeshObject.
	* @return the VolumeData of this MeshObject
	*/
	PVolumeData CMeshObject::GetVolumeData()
	{
		Lib3MFHandle hTheVolumeData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetVolumeData(m_pHandle, &hTheVolumeData));
		
		if (hTheVolumeData) {
			return std::shared_ptr<CVolumeData>(dynamic_cast<CVolumeData*>(m_pWrapper->polymorphicFactory(hTheVolumeData)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CMeshObject::SetVolumeData - Sets the VolumeData of this MeshObject.
	* @param[in] pTheVolumeData - the VolumeData of this MeshObject
	*/
	void CMeshObject::SetVolumeData(classParam<CVolumeData> pTheVolumeData)
	{
		Lib3MFHandle hTheVolumeData = pTheVolumeData.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_SetVolumeData(m_pHandle, hTheVolumeData));
	}
	
	/**
	* CMeshObject::AddTriangleSet - Adds a new triangle set.
	* @param[in] sIdentifier - the new identifier. MUST be unique within the mesh. MUST NOT be an empty string
	* @param[in] sName - the human readable name. MUST NOT be an empty string
	* @return the new Triangle Set Instance.
	*/
	PTriangleSet CMeshObject::AddTriangleSet(const std::string & sIdentifier, const std::string & sName)
	{
		Lib3MFHandle hTheTriangleSet = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_AddTriangleSet(m_pHandle, sIdentifier.c_str(), sName.c_str(), &hTheTriangleSet));
		
		if (!hTheTriangleSet) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTriangleSet>(dynamic_cast<CTriangleSet*>(m_pWrapper->polymorphicFactory(hTheTriangleSet)));
	}
	
	/**
	* CMeshObject::HasTriangleSet - Checks if a triangle set exists.
	* @param[in] sIdentifier - the identifier to be found.
	* @return flag if the triangles set exists.
	*/
	bool CMeshObject::HasTriangleSet(const std::string & sIdentifier)
	{
		bool resultTriangleSetExists = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_HasTriangleSet(m_pHandle, sIdentifier.c_str(), &resultTriangleSetExists));
		
		return resultTriangleSetExists;
	}
	
	/**
	* CMeshObject::FindTriangleSet - Finds a new triangle set by identifier. Fails if not existing.
	* @param[in] sIdentifier - the identifier to be found.
	* @return the triangle Set Instance.
	*/
	PTriangleSet CMeshObject::FindTriangleSet(const std::string & sIdentifier)
	{
		Lib3MFHandle hTheTriangleSet = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_FindTriangleSet(m_pHandle, sIdentifier.c_str(), &hTheTriangleSet));
		
		if (!hTheTriangleSet) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTriangleSet>(dynamic_cast<CTriangleSet*>(m_pWrapper->polymorphicFactory(hTheTriangleSet)));
	}
	
	/**
	* CMeshObject::GetTriangleSetCount - Returns number of triangle sets.
	* @return the number of triangle sets of this mesh.
	*/
	Lib3MF_uint32 CMeshObject::GetTriangleSetCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetTriangleSetCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CMeshObject::GetTriangleSet - Returns a specific triangle set by index.
	* @param[in] nIndex - the index of the triangle set.
	* @return the triangle Set Instance.
	*/
	PTriangleSet CMeshObject::GetTriangleSet(const Lib3MF_uint32 nIndex)
	{
		Lib3MFHandle hTheTriangleSet = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshObject_GetTriangleSet(m_pHandle, nIndex, &hTheTriangleSet));
		
		if (!hTheTriangleSet) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTriangleSet>(dynamic_cast<CTriangleSet*>(m_pWrapper->polymorphicFactory(hTheTriangleSet)));
	}
	
	/**
	 * Method definitions for class CLevelSet
	 */
	
	/**
	* CLevelSet::GetFunction - Returns the function that is used as boundary shape.
	* @return the function to use as boundary shape
	*/
	PFunction CLevelSet::GetFunction()
	{
		Lib3MFHandle hTheFunction = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_GetFunction(m_pHandle, &hTheFunction));
		
		if (hTheFunction) {
			return std::shared_ptr<CFunction>(dynamic_cast<CFunction*>(m_pWrapper->polymorphicFactory(hTheFunction)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CLevelSet::SetFunction - Sets the function to use as boundary shape.
	* @param[in] pTheFunction - the function to use as boundary shape
	*/
	void CLevelSet::SetFunction(classParam<CFunction> pTheFunction)
	{
		Lib3MFHandle hTheFunction = pTheFunction.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_SetFunction(m_pHandle, hTheFunction));
	}
	
	/**
	* CLevelSet::GetTransform - Returns the transformation matrix into the coordinate system of the referenced Function.
	* @return the transformation matrix
	*/
	sTransform CLevelSet::GetTransform()
	{
		sTransform resultTransform;
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_GetTransform(m_pHandle, &resultTransform));
		
		return resultTransform;
	}
	
	/**
	* CLevelSet::SetTransform - Sets the transformation matrix into the coordinate system of the referenced Function.
	* @param[in] Transform - new transformation matrix
	*/
	void CLevelSet::SetTransform(const sTransform & Transform)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_SetTransform(m_pHandle, &Transform));
	}
	
	/**
	* CLevelSet::GetChannelName - Returns the name of the function output channel to use.
	* @return the name of the function output channel
	*/
	std::string CLevelSet::GetChannelName()
	{
		Lib3MF_uint32 bytesNeededChannelName = 0;
		Lib3MF_uint32 bytesWrittenChannelName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_GetChannelName(m_pHandle, 0, &bytesNeededChannelName, nullptr));
		std::vector<char> bufferChannelName(bytesNeededChannelName);
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_GetChannelName(m_pHandle, bytesNeededChannelName, &bytesWrittenChannelName, &bufferChannelName[0]));
		
		return std::string(&bufferChannelName[0]);
	}
	
	/**
	* CLevelSet::SetChannelName - Sets the name of the function output channel to use.
	* @param[in] sChannelName - new name of the function output channel
	*/
	void CLevelSet::SetChannelName(const std::string & sChannelName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_SetChannelName(m_pHandle, sChannelName.c_str()));
	}
	
	/**
	* CLevelSet::SetMinFeatureSize - Sets the minimal feature size as a hint for the function evaluator
	* @param[in] dMinFeatureSize - minimal feature size
	*/
	void CLevelSet::SetMinFeatureSize(const Lib3MF_double dMinFeatureSize)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_SetMinFeatureSize(m_pHandle, dMinFeatureSize));
	}
	
	/**
	* CLevelSet::GetMinFeatureSize - Returns the minimal feature size as a hint for the function evaluator
	* @return minimal feature size
	*/
	Lib3MF_double CLevelSet::GetMinFeatureSize()
	{
		Lib3MF_double resultMinFeatureSize = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_GetMinFeatureSize(m_pHandle, &resultMinFeatureSize));
		
		return resultMinFeatureSize;
	}
	
	/**
	* CLevelSet::SetFallBackValue - Sets the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
	* @param[in] dFallBackValue - fallback value
	*/
	void CLevelSet::SetFallBackValue(const Lib3MF_double dFallBackValue)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_SetFallBackValue(m_pHandle, dFallBackValue));
	}
	
	/**
	* CLevelSet::GetFallBackValue - Returns the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
	* @return fallback value
	*/
	Lib3MF_double CLevelSet::GetFallBackValue()
	{
		Lib3MF_double resultFallBackValue = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_GetFallBackValue(m_pHandle, &resultFallBackValue));
		
		return resultFallBackValue;
	}
	
	/**
	* CLevelSet::SetMeshBBoxOnly - If set only the bounding box of the mesh is intersected with the boundary
	* @param[in] bMeshBBoxOnly - If set only the bounding box of the mesh is intersected with the boundary
	*/
	void CLevelSet::SetMeshBBoxOnly(const bool bMeshBBoxOnly)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_SetMeshBBoxOnly(m_pHandle, bMeshBBoxOnly));
	}
	
	/**
	* CLevelSet::GetMeshBBoxOnly - If set only the bounding box of the mesh is intersected with the boundary
	* @return If set only the bounding box of the mesh is intersected with the boundary
	*/
	bool CLevelSet::GetMeshBBoxOnly()
	{
		bool resultMeshBBoxOnly = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_GetMeshBBoxOnly(m_pHandle, &resultMeshBBoxOnly));
		
		return resultMeshBBoxOnly;
	}
	
	/**
	* CLevelSet::SetMesh - Sets the mesh to use as evaluation domain
	* @param[in] pTheMesh - The mesh
	*/
	void CLevelSet::SetMesh(classParam<CMeshObject> pTheMesh)
	{
		Lib3MFHandle hTheMesh = pTheMesh.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_SetMesh(m_pHandle, hTheMesh));
	}
	
	/**
	* CLevelSet::GetMesh - Returns the mesh that is used as evaluation domain
	* @return The mesh
	*/
	PMeshObject CLevelSet::GetMesh()
	{
		Lib3MFHandle hTheMesh = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_GetMesh(m_pHandle, &hTheMesh));
		
		if (hTheMesh) {
			return std::shared_ptr<CMeshObject>(dynamic_cast<CMeshObject*>(m_pWrapper->polymorphicFactory(hTheMesh)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CLevelSet::GetVolumeData - Retrieves the VolumeData this Object.
	* @return the VolumeData of this Object
	*/
	PVolumeData CLevelSet::GetVolumeData()
	{
		Lib3MFHandle hTheVolumeData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_GetVolumeData(m_pHandle, &hTheVolumeData));
		
		if (hTheVolumeData) {
			return std::shared_ptr<CVolumeData>(dynamic_cast<CVolumeData*>(m_pWrapper->polymorphicFactory(hTheVolumeData)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CLevelSet::SetVolumeData - Sets the VolumeData of this LevelSet.
	* @param[in] pTheVolumeData - the VolumeData of this MeshObject
	*/
	void CLevelSet::SetVolumeData(classParam<CVolumeData> pTheVolumeData)
	{
		Lib3MFHandle hTheVolumeData = pTheVolumeData.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_LevelSet_SetVolumeData(m_pHandle, hTheVolumeData));
	}
	
	/**
	 * Method definitions for class CBeamLattice
	 */
	
	/**
	* CBeamLattice::GetMinLength - Returns the minimal length of beams for the beamlattice.
	* @return minimal length of beams for the beamlattice
	*/
	Lib3MF_double CBeamLattice::GetMinLength()
	{
		Lib3MF_double resultMinLength = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetMinLength(m_pHandle, &resultMinLength));
		
		return resultMinLength;
	}
	
	/**
	* CBeamLattice::SetMinLength - Sets the minimal length of beams for the beamlattice.
	* @param[in] dMinLength - minimal length of beams for the beamlattice
	*/
	void CBeamLattice::SetMinLength(const Lib3MF_double dMinLength)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_SetMinLength(m_pHandle, dMinLength));
	}
	
	/**
	* CBeamLattice::GetClipping - Returns the clipping mode and the clipping-mesh for the beamlattice of this mesh.
	* @param[out] eClipMode - contains the clip mode of this mesh
	* @param[out] nUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object or an undefined value if pClipMode is MODELBEAMLATTICECLIPMODE_NONE
	*/
	void CBeamLattice::GetClipping(eBeamLatticeClipMode & eClipMode, Lib3MF_uint32 & nUniqueResourceID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetClipping(m_pHandle, &eClipMode, &nUniqueResourceID));
	}
	
	/**
	* CBeamLattice::SetClipping - Sets the clipping mode and the clipping-mesh for the beamlattice of this mesh.
	* @param[in] eClipMode - contains the clip mode of this mesh
	* @param[in] nUniqueResourceID - the UniqueResourceID of the clipping mesh-object. This mesh-object has to be defined before setting the Clipping.
	*/
	void CBeamLattice::SetClipping(const eBeamLatticeClipMode eClipMode, const Lib3MF_uint32 nUniqueResourceID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_SetClipping(m_pHandle, eClipMode, nUniqueResourceID));
	}
	
	/**
	* CBeamLattice::GetRepresentation - Returns the representation-mesh for the beamlattice of this mesh.
	* @return flag whether the beamlattice has a representation mesh.
	* @param[out] nUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object.
	*/
	bool CBeamLattice::GetRepresentation(Lib3MF_uint32 & nUniqueResourceID)
	{
		bool resultHasRepresentation = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetRepresentation(m_pHandle, &resultHasRepresentation, &nUniqueResourceID));
		
		return resultHasRepresentation;
	}
	
	/**
	* CBeamLattice::SetRepresentation - Sets the representation-mesh for the beamlattice of this mesh.
	* @param[in] nUniqueResourceID - the UniqueResourceID of the representation mesh-object. This mesh-object has to be defined before setting the representation.
	*/
	void CBeamLattice::SetRepresentation(const Lib3MF_uint32 nUniqueResourceID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_SetRepresentation(m_pHandle, nUniqueResourceID));
	}
	
	/**
	* CBeamLattice::GetBallOptions - Returns the ball mode and the default ball radius for the beamlattice of this mesh.
	* @param[out] eBallMode - contains the ball mode of this mesh
	* @param[out] dBallRadius - default ball radius of balls for the beamlattice
	*/
	void CBeamLattice::GetBallOptions(eBeamLatticeBallMode & eBallMode, Lib3MF_double & dBallRadius)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetBallOptions(m_pHandle, &eBallMode, &dBallRadius));
	}
	
	/**
	* CBeamLattice::SetBallOptions - Sets the ball mode and thedefault ball radius for the beamlattice.
	* @param[in] eBallMode - contains the ball mode of this mesh
	* @param[in] dBallRadius - default ball radius of balls for the beamlattice
	*/
	void CBeamLattice::SetBallOptions(const eBeamLatticeBallMode eBallMode, const Lib3MF_double dBallRadius)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_SetBallOptions(m_pHandle, eBallMode, dBallRadius));
	}
	
	/**
	* CBeamLattice::GetBeamCount - Returns the beam count of a mesh object.
	* @return filled with the beam count.
	*/
	Lib3MF_uint32 CBeamLattice::GetBeamCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetBeamCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CBeamLattice::GetBeam - Returns indices, radii and capmodes of a single beam of a mesh object.
	* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
	* @return filled with the beam indices, radii and capmodes.
	*/
	sBeam CBeamLattice::GetBeam(const Lib3MF_uint32 nIndex)
	{
		sBeam resultBeamInfo;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetBeam(m_pHandle, nIndex, &resultBeamInfo));
		
		return resultBeamInfo;
	}
	
	/**
	* CBeamLattice::AddBeam - Adds a single beam to a mesh object.
	* @param[in] BeamInfo - contains the node indices, radii and capmodes.
	* @return filled with the new Index of the beam.
	*/
	Lib3MF_uint32 CBeamLattice::AddBeam(const sBeam & BeamInfo)
	{
		Lib3MF_uint32 resultIndex = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_AddBeam(m_pHandle, &BeamInfo, &resultIndex));
		
		return resultIndex;
	}
	
	/**
	* CBeamLattice::SetBeam - Sets the indices, radii and capmodes of a single beam of a mesh object.
	* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
	* @param[in] BeamInfo - filled with the beam indices, radii and capmodes.
	*/
	void CBeamLattice::SetBeam(const Lib3MF_uint32 nIndex, const sBeam & BeamInfo)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_SetBeam(m_pHandle, nIndex, &BeamInfo));
	}
	
	/**
	* CBeamLattice::SetBeams - Sets all beam indices, radii and capmodes of a mesh object.
	* @param[in] BeamInfoBuffer - contains information of a number of  beams
	*/
	void CBeamLattice::SetBeams(const CInputVector<sBeam> & BeamInfoBuffer)
	{
		Lib3MF_uint64 nBeamInfoSize = BeamInfoBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_SetBeams(m_pHandle, nBeamInfoSize, BeamInfoBuffer.data()));
	}
	
	/**
	* CBeamLattice::GetBeams - obtains all beam indices, radii and capmodes of a mesh object.
	* @param[out] BeamInfoBuffer - contains information of all beams
	*/
	void CBeamLattice::GetBeams(std::vector<sBeam> & BeamInfoBuffer)
	{
		Lib3MF_uint64 elementsNeededBeamInfo = 0;
		Lib3MF_uint64 elementsWrittenBeamInfo = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetBeams(m_pHandle, 0, &elementsNeededBeamInfo, nullptr));
		BeamInfoBuffer.resize((size_t) elementsNeededBeamInfo);
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetBeams(m_pHandle, elementsNeededBeamInfo, &elementsWrittenBeamInfo, BeamInfoBuffer.data()));
	}
	
	/**
	* CBeamLattice::GetBallCount - Returns the ball count of a mesh object.
	* @return filled with the ball count.
	*/
	Lib3MF_uint32 CBeamLattice::GetBallCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetBallCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CBeamLattice::GetBall - Returns index and radius of a single ball of a mesh object.
	* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
	* @return filled with the ball node index and radius.
	*/
	sBall CBeamLattice::GetBall(const Lib3MF_uint32 nIndex)
	{
		sBall resultBallInfo;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetBall(m_pHandle, nIndex, &resultBallInfo));
		
		return resultBallInfo;
	}
	
	/**
	* CBeamLattice::AddBall - Adds a single ball to a mesh object.
	* @param[in] BallInfo - contains the node index and radius.
	* @return filled with the new Index of the ball.
	*/
	Lib3MF_uint32 CBeamLattice::AddBall(const sBall & BallInfo)
	{
		Lib3MF_uint32 resultIndex = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_AddBall(m_pHandle, &BallInfo, &resultIndex));
		
		return resultIndex;
	}
	
	/**
	* CBeamLattice::SetBall - Sets the index and radius of a single ball of a mesh object.
	* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
	* @param[in] BallInfo - filled with the ball node index and radius.
	*/
	void CBeamLattice::SetBall(const Lib3MF_uint32 nIndex, const sBall & BallInfo)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_SetBall(m_pHandle, nIndex, &BallInfo));
	}
	
	/**
	* CBeamLattice::SetBalls - Sets all ball indices and radii of a mesh object.
	* @param[in] BallInfoBuffer - contains information of a number of  balls
	*/
	void CBeamLattice::SetBalls(const CInputVector<sBall> & BallInfoBuffer)
	{
		Lib3MF_uint64 nBallInfoSize = BallInfoBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_SetBalls(m_pHandle, nBallInfoSize, BallInfoBuffer.data()));
	}
	
	/**
	* CBeamLattice::GetBalls - obtains all ball indices and radii of a mesh object.
	* @param[out] BallInfoBuffer - contains information of all balls
	*/
	void CBeamLattice::GetBalls(std::vector<sBall> & BallInfoBuffer)
	{
		Lib3MF_uint64 elementsNeededBallInfo = 0;
		Lib3MF_uint64 elementsWrittenBallInfo = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetBalls(m_pHandle, 0, &elementsNeededBallInfo, nullptr));
		BallInfoBuffer.resize((size_t) elementsNeededBallInfo);
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetBalls(m_pHandle, elementsNeededBallInfo, &elementsWrittenBallInfo, BallInfoBuffer.data()));
	}
	
	/**
	* CBeamLattice::GetBeamSetCount - Returns the number of beamsets of a mesh object.
	* @return filled with the beamset count.
	*/
	Lib3MF_uint32 CBeamLattice::GetBeamSetCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetBeamSetCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CBeamLattice::AddBeamSet - Adds an empty beamset to a mesh object
	* @return the new beamset
	*/
	PBeamSet CBeamLattice::AddBeamSet()
	{
		Lib3MFHandle hBeamSet = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_AddBeamSet(m_pHandle, &hBeamSet));
		
		if (!hBeamSet) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBeamSet>(dynamic_cast<CBeamSet*>(m_pWrapper->polymorphicFactory(hBeamSet)));
	}
	
	/**
	* CBeamLattice::GetBeamSet - Returns a beamset of a mesh object
	* @param[in] nIndex - index of the requested beamset (0 ... beamsetcount-1).
	* @return the requested beamset
	*/
	PBeamSet CBeamLattice::GetBeamSet(const Lib3MF_uint32 nIndex)
	{
		Lib3MFHandle hBeamSet = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLattice_GetBeamSet(m_pHandle, nIndex, &hBeamSet));
		
		if (!hBeamSet) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBeamSet>(dynamic_cast<CBeamSet*>(m_pWrapper->polymorphicFactory(hBeamSet)));
	}
	
	/**
	 * Method definitions for class CFunctionReference
	 */
	
	/**
	* CFunctionReference::GetFunctionResourceID - Returns the UniqueResourceID of the Function. Only functions with a 'pos'-input are allowed.
	* @return returns the UniqueResourceID.
	*/
	Lib3MF_uint32 CFunctionReference::GetFunctionResourceID()
	{
		Lib3MF_uint32 resultUniqueResourceID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionReference_GetFunctionResourceID(m_pHandle, &resultUniqueResourceID));
		
		return resultUniqueResourceID;
	}
	
	/**
	* CFunctionReference::SetFunctionResourceID - Sets the UniqueResourceID to refer to.
	* @param[in] nUniqueResourceID - UniqueResourceID of the function
	*/
	void CFunctionReference::SetFunctionResourceID(const Lib3MF_uint32 nUniqueResourceID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionReference_SetFunctionResourceID(m_pHandle, nUniqueResourceID));
	}
	
	/**
	* CFunctionReference::GetTransform - Returns the transformation matrix into the coordinate system of the referenced Function.
	* @return the transformation matrix
	*/
	sTransform CFunctionReference::GetTransform()
	{
		sTransform resultTransform;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionReference_GetTransform(m_pHandle, &resultTransform));
		
		return resultTransform;
	}
	
	/**
	* CFunctionReference::SetTransform - Sets the transformation matrix into the coordinate system of the referenced Function.
	* @param[in] Transform - new transformation matrix
	*/
	void CFunctionReference::SetTransform(const sTransform & Transform)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionReference_SetTransform(m_pHandle, &Transform));
	}
	
	/**
	* CFunctionReference::GetChannelName - Returns the name of the function output channel to use.
	* @return the name of the function output channel
	*/
	std::string CFunctionReference::GetChannelName()
	{
		Lib3MF_uint32 bytesNeededChannelName = 0;
		Lib3MF_uint32 bytesWrittenChannelName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionReference_GetChannelName(m_pHandle, 0, &bytesNeededChannelName, nullptr));
		std::vector<char> bufferChannelName(bytesNeededChannelName);
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionReference_GetChannelName(m_pHandle, bytesNeededChannelName, &bytesWrittenChannelName, &bufferChannelName[0]));
		
		return std::string(&bufferChannelName[0]);
	}
	
	/**
	* CFunctionReference::SetChannelName - Sets the name of the function output channel to use.
	* @param[in] sChannelName - new name of the function output channel
	*/
	void CFunctionReference::SetChannelName(const std::string & sChannelName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionReference_SetChannelName(m_pHandle, sChannelName.c_str()));
	}
	
	/**
	* CFunctionReference::SetMinFeatureSize - Sets the minimal feature size as a hint for the function evaluator
	* @param[in] dMinFeatureSize - minimal feature size
	*/
	void CFunctionReference::SetMinFeatureSize(const Lib3MF_double dMinFeatureSize)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionReference_SetMinFeatureSize(m_pHandle, dMinFeatureSize));
	}
	
	/**
	* CFunctionReference::GetMinFeatureSize - Returns the minimal feature size as a hint for the function evaluator
	* @return minimal feature size
	*/
	Lib3MF_double CFunctionReference::GetMinFeatureSize()
	{
		Lib3MF_double resultMinFeatureSize = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionReference_GetMinFeatureSize(m_pHandle, &resultMinFeatureSize));
		
		return resultMinFeatureSize;
	}
	
	/**
	* CFunctionReference::SetFallBackValue - Sets the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
	* @param[in] dFallBackValue - fallback value
	*/
	void CFunctionReference::SetFallBackValue(const Lib3MF_double dFallBackValue)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionReference_SetFallBackValue(m_pHandle, dFallBackValue));
	}
	
	/**
	* CFunctionReference::GetFallBackValue - Returns the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
	* @return fallback value
	*/
	Lib3MF_double CFunctionReference::GetFallBackValue()
	{
		Lib3MF_double resultFallBackValue = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionReference_GetFallBackValue(m_pHandle, &resultFallBackValue));
		
		return resultFallBackValue;
	}
	
	/**
	 * Method definitions for class CVolumeDataColor
	 */
	
	/**
	 * Method definitions for class CMaterialMapping
	 */
	
	/**
	 * Method definitions for class CVolumeDataComposite
	 */
	
	/**
	* CVolumeDataComposite::GetBaseMaterialGroup - Returns the BaseMaterialGroup used within this volume data item
	* @return The BaseMaterialGroup instance of this VolumeDataComposite element
	*/
	PBaseMaterialGroup CVolumeDataComposite::GetBaseMaterialGroup()
	{
		Lib3MFHandle hBaseMaterialGroupInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeDataComposite_GetBaseMaterialGroup(m_pHandle, &hBaseMaterialGroupInstance));
		
		if (!hBaseMaterialGroupInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBaseMaterialGroup>(dynamic_cast<CBaseMaterialGroup*>(m_pWrapper->polymorphicFactory(hBaseMaterialGroupInstance)));
	}
	
	/**
	* CVolumeDataComposite::SetBaseMaterialGroup - Sets the BaseMaterialGroup to use within this volume data item.
	* @param[in] pBaseMaterialGroupInstance - The new BaseMaterialGroup instance of this VolumeDataComposite element
	*/
	void CVolumeDataComposite::SetBaseMaterialGroup(classParam<CBaseMaterialGroup> pBaseMaterialGroupInstance)
	{
		Lib3MFHandle hBaseMaterialGroupInstance = pBaseMaterialGroupInstance.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeDataComposite_SetBaseMaterialGroup(m_pHandle, hBaseMaterialGroupInstance));
	}
	
	/**
	* CVolumeDataComposite::GetMaterialMappingCount - Returns the number of material mappings of this VolumeDataComposite element
	* @return the number of material mappings.
	*/
	Lib3MF_uint32 CVolumeDataComposite::GetMaterialMappingCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeDataComposite_GetMaterialMappingCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CVolumeDataComposite::GetMaterialMapping - Returns MaterialMapping with given index
	* @param[in] nIndex - Index of the MaterialMapping in question.
	* @return MaterialMapping used in this element
	*/
	PMaterialMapping CVolumeDataComposite::GetMaterialMapping(const Lib3MF_uint32 nIndex)
	{
		Lib3MFHandle hTheMaterialMapping = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeDataComposite_GetMaterialMapping(m_pHandle, nIndex, &hTheMaterialMapping));
		
		if (!hTheMaterialMapping) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMaterialMapping>(dynamic_cast<CMaterialMapping*>(m_pWrapper->polymorphicFactory(hTheMaterialMapping)));
	}
	
	/**
	* CVolumeDataComposite::AddMaterialMapping - Adds a MaterialMapping
	* @param[in] Transform - new transformation matrix
	* @return The new MaterialMapping
	*/
	PMaterialMapping CVolumeDataComposite::AddMaterialMapping(const sTransform & Transform)
	{
		Lib3MFHandle hTheMaterialMapping = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeDataComposite_AddMaterialMapping(m_pHandle, &Transform, &hTheMaterialMapping));
		
		if (!hTheMaterialMapping) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMaterialMapping>(dynamic_cast<CMaterialMapping*>(m_pWrapper->polymorphicFactory(hTheMaterialMapping)));
	}
	
	/**
	* CVolumeDataComposite::RemoveMaterialMapping - Removes the MaterialMapping with given index
	* @param[in] nIndex - The index of the MaterialMapping to be removed.
	*/
	void CVolumeDataComposite::RemoveMaterialMapping(const Lib3MF_uint32 nIndex)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeDataComposite_RemoveMaterialMapping(m_pHandle, nIndex));
	}
	
	/**
	 * Method definitions for class CVolumeDataProperty
	 */
	
	/**
	* CVolumeDataProperty::GetName - Gets the qualified name of this property.
	* @return The qualified name of this property.
	*/
	std::string CVolumeDataProperty::GetName()
	{
		Lib3MF_uint32 bytesNeededPropertyName = 0;
		Lib3MF_uint32 bytesWrittenPropertyName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeDataProperty_GetName(m_pHandle, 0, &bytesNeededPropertyName, nullptr));
		std::vector<char> bufferPropertyName(bytesNeededPropertyName);
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeDataProperty_GetName(m_pHandle, bytesNeededPropertyName, &bytesWrittenPropertyName, &bufferPropertyName[0]));
		
		return std::string(&bufferPropertyName[0]);
	}
	
	/**
	* CVolumeDataProperty::SetIsRequired - Sets whether this property is required to process this 3MF document instance.
	* @param[in] bIsRequired - New value for whether this property is required to process this 3MF document instance.
	*/
	void CVolumeDataProperty::SetIsRequired(const bool bIsRequired)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeDataProperty_SetIsRequired(m_pHandle, bIsRequired));
	}
	
	/**
	* CVolumeDataProperty::IsRequired - Returns whether this property is required to process this 3MF document instance.
	* @return Is this property required to process this 3MF document instance?
	*/
	bool CVolumeDataProperty::IsRequired()
	{
		bool resultIsRequired = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeDataProperty_IsRequired(m_pHandle, &resultIsRequired));
		
		return resultIsRequired;
	}
	
	/**
	 * Method definitions for class CVolumeData
	 */
	
	/**
	* CVolumeData::GetComposite - Returns the VolumeDataComposite of this VolumeData instance
	* @return filled with the VolumeDataComposite of this VolumeData instance.
	*/
	PVolumeDataComposite CVolumeData::GetComposite()
	{
		Lib3MFHandle hTheCompositeData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeData_GetComposite(m_pHandle, &hTheCompositeData));
		
		if (hTheCompositeData) {
			return std::shared_ptr<CVolumeDataComposite>(dynamic_cast<CVolumeDataComposite*>(m_pWrapper->polymorphicFactory(hTheCompositeData)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CVolumeData::CreateNewComposite - Creates a new VolumeDataComposite for this VolumeData instance
	* @return The new VolumeDataComposite of this VolumeData instance.
	*/
	PVolumeDataComposite CVolumeData::CreateNewComposite()
	{
		Lib3MFHandle hTheCompositeData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeData_CreateNewComposite(m_pHandle, &hTheCompositeData));
		
		if (!hTheCompositeData) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CVolumeDataComposite>(dynamic_cast<CVolumeDataComposite*>(m_pWrapper->polymorphicFactory(hTheCompositeData)));
	}
	
	/**
	* CVolumeData::RemoveComposite - Removes the VolumeDataComposite of this VolumeData instance
	*/
	void CVolumeData::RemoveComposite()
	{
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeData_RemoveComposite(m_pHandle));
	}
	
	/**
	* CVolumeData::GetColor - Returns the VolumeDataColor of this VolumeData instance
	* @return filled with the VolumeDataColor of this VolumeData instance.
	*/
	PVolumeDataColor CVolumeData::GetColor()
	{
		Lib3MFHandle hTheColorData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeData_GetColor(m_pHandle, &hTheColorData));
		
		if (hTheColorData) {
			return std::shared_ptr<CVolumeDataColor>(dynamic_cast<CVolumeDataColor*>(m_pWrapper->polymorphicFactory(hTheColorData)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CVolumeData::CreateNewColor - Creates a new VolumeDataColor for this VolumeData instance
	* @param[in] pTheFunction - Function used in this element
	* @return The new VolumeDataColor of this VolumeData instance.
	*/
	PVolumeDataColor CVolumeData::CreateNewColor(classParam<CFunction> pTheFunction)
	{
		Lib3MFHandle hTheFunction = pTheFunction.GetHandle();
		Lib3MFHandle hTheColorData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeData_CreateNewColor(m_pHandle, hTheFunction, &hTheColorData));
		
		if (!hTheColorData) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CVolumeDataColor>(dynamic_cast<CVolumeDataColor*>(m_pWrapper->polymorphicFactory(hTheColorData)));
	}
	
	/**
	* CVolumeData::RemoveColor - Removes the VolumeDataColor of this VolumeData instance
	*/
	void CVolumeData::RemoveColor()
	{
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeData_RemoveColor(m_pHandle));
	}
	
	/**
	* CVolumeData::GetPropertyCount - Returns the number of VolumeDataProperty
	* @return the number of VolumeDataProperty-elements within this VolumeData
	*/
	Lib3MF_uint32 CVolumeData::GetPropertyCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeData_GetPropertyCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CVolumeData::GetProperty - Returns the VolumeDataProperty at a given Index
	* @param[in] nIndex - the index of the VolumeDataProperty to be returned.
	* @return the VolumeDataProperty at the given index.
	*/
	PVolumeDataProperty CVolumeData::GetProperty(const Lib3MF_uint32 nIndex)
	{
		Lib3MFHandle hTheVolumeDataProperty = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeData_GetProperty(m_pHandle, nIndex, &hTheVolumeDataProperty));
		
		if (!hTheVolumeDataProperty) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CVolumeDataProperty>(dynamic_cast<CVolumeDataProperty*>(m_pWrapper->polymorphicFactory(hTheVolumeDataProperty)));
	}
	
	/**
	* CVolumeData::AddPropertyFromFunction - Adds a new VolumeDataProperty from a Function
	* @param[in] sName - the qualified name (namespace+name) of the Property
	* @param[in] pTheFunction - Function used in this element
	* @return the newly created VolumeDataProperty.
	*/
	PVolumeDataProperty CVolumeData::AddPropertyFromFunction(const std::string & sName, classParam<CFunction> pTheFunction)
	{
		Lib3MFHandle hTheFunction = pTheFunction.GetHandle();
		Lib3MFHandle hTheVolumeDataProperty = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeData_AddPropertyFromFunction(m_pHandle, sName.c_str(), hTheFunction, &hTheVolumeDataProperty));
		
		if (!hTheVolumeDataProperty) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CVolumeDataProperty>(dynamic_cast<CVolumeDataProperty*>(m_pWrapper->polymorphicFactory(hTheVolumeDataProperty)));
	}
	
	/**
	* CVolumeData::RemoveProperty - Removes the VolumeDataProperty with a given index
	* @param[in] nIndex - the index of the VolumeDataProperty to be removed.
	*/
	void CVolumeData::RemoveProperty(const Lib3MF_uint32 nIndex)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_VolumeData_RemoveProperty(m_pHandle, nIndex));
	}
	
	/**
	 * Method definitions for class CComponent
	 */
	
	/**
	* CComponent::GetObjectResource - Returns the Resource Instance of the component.
	* @return filled with the Resource Instance.
	*/
	PObject CComponent::GetObjectResource()
	{
		Lib3MFHandle hObjectResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Component_GetObjectResource(m_pHandle, &hObjectResource));
		
		if (!hObjectResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CObject>(dynamic_cast<CObject*>(m_pWrapper->polymorphicFactory(hObjectResource)));
	}
	
	/**
	* CComponent::GetObjectResourceID - Returns the UniqueResourceID of the component.
	* @return returns the UniqueResourceID.
	*/
	Lib3MF_uint32 CComponent::GetObjectResourceID()
	{
		Lib3MF_uint32 resultUniqueResourceID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Component_GetObjectResourceID(m_pHandle, &resultUniqueResourceID));
		
		return resultUniqueResourceID;
	}
	
	/**
	* CComponent::GetUUID - returns, whether a component has a UUID and, if true, the component's UUID
	* @param[out] bHasUUID - flag whether the component has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	std::string CComponent::GetUUID(bool & bHasUUID)
	{
		Lib3MF_uint32 bytesNeededUUID = 0;
		Lib3MF_uint32 bytesWrittenUUID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Component_GetUUID(m_pHandle, &bHasUUID, 0, &bytesNeededUUID, nullptr));
		std::vector<char> bufferUUID(bytesNeededUUID);
		CheckError(m_pWrapper->m_WrapperTable.m_Component_GetUUID(m_pHandle, &bHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]));
		
		return std::string(&bufferUUID[0]);
	}
	
	/**
	* CComponent::SetUUID - sets the component's UUID
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	void CComponent::SetUUID(const std::string & sUUID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Component_SetUUID(m_pHandle, sUUID.c_str()));
	}
	
	/**
	* CComponent::HasTransform - Returns, if the component has a different transformation than the identity matrix
	* @return if true is returned, the transformation is not equal than the identity
	*/
	bool CComponent::HasTransform()
	{
		bool resultHasTransform = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Component_HasTransform(m_pHandle, &resultHasTransform));
		
		return resultHasTransform;
	}
	
	/**
	* CComponent::GetTransform - Returns the transformation matrix of the component.
	* @return filled with the component transformation matrix
	*/
	sTransform CComponent::GetTransform()
	{
		sTransform resultTransform;
		CheckError(m_pWrapper->m_WrapperTable.m_Component_GetTransform(m_pHandle, &resultTransform));
		
		return resultTransform;
	}
	
	/**
	* CComponent::SetTransform - Sets the transformation matrix of the component.
	* @param[in] Transform - new transformation matrix
	*/
	void CComponent::SetTransform(const sTransform & Transform)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Component_SetTransform(m_pHandle, &Transform));
	}
	
	/**
	 * Method definitions for class CComponentsObject
	 */
	
	/**
	* CComponentsObject::AddComponent - Adds a new component to a components object.
	* @param[in] pObjectResource - object to add as component. Must not lead to circular references!
	* @param[in] Transform - optional transform matrix for the component.
	* @return new component instance
	*/
	PComponent CComponentsObject::AddComponent(classParam<CObject> pObjectResource, const sTransform & Transform)
	{
		Lib3MFHandle hObjectResource = pObjectResource.GetHandle();
		Lib3MFHandle hComponentInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComponentsObject_AddComponent(m_pHandle, hObjectResource, &Transform, &hComponentInstance));
		
		if (!hComponentInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CComponent>(dynamic_cast<CComponent*>(m_pWrapper->polymorphicFactory(hComponentInstance)));
	}
	
	/**
	* CComponentsObject::GetComponent - Retrieves a component from a component object.
	* @param[in] nIndex - index of the component to retrieve (0 to componentcount - 1)
	* @return component instance
	*/
	PComponent CComponentsObject::GetComponent(const Lib3MF_uint32 nIndex)
	{
		Lib3MFHandle hComponentInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComponentsObject_GetComponent(m_pHandle, nIndex, &hComponentInstance));
		
		if (!hComponentInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CComponent>(dynamic_cast<CComponent*>(m_pWrapper->polymorphicFactory(hComponentInstance)));
	}
	
	/**
	* CComponentsObject::GetComponentCount - Retrieves a component count of a component object.
	* @return returns the component count
	*/
	Lib3MF_uint32 CComponentsObject::GetComponentCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ComponentsObject_GetComponentCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	 * Method definitions for class CBeamSet
	 */
	
	/**
	* CBeamSet::SetName - Sets a beamset's name string
	* @param[in] sName - new name of the beamset.
	*/
	void CBeamSet::SetName(const std::string & sName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_SetName(m_pHandle, sName.c_str()));
	}
	
	/**
	* CBeamSet::GetName - Retrieves a beamset's name string
	* @return returns the name of the beamset.
	*/
	std::string CBeamSet::GetName()
	{
		Lib3MF_uint32 bytesNeededName = 0;
		Lib3MF_uint32 bytesWrittenName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_GetName(m_pHandle, 0, &bytesNeededName, nullptr));
		std::vector<char> bufferName(bytesNeededName);
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_GetName(m_pHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]));
		
		return std::string(&bufferName[0]);
	}
	
	/**
	* CBeamSet::SetIdentifier - Sets a beamset's identifier string
	* @param[in] sIdentifier - new name of the beamset.
	*/
	void CBeamSet::SetIdentifier(const std::string & sIdentifier)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_SetIdentifier(m_pHandle, sIdentifier.c_str()));
	}
	
	/**
	* CBeamSet::GetIdentifier - Retrieves a beamset's identifier string
	* @return returns the identifier of the beamset.
	*/
	std::string CBeamSet::GetIdentifier()
	{
		Lib3MF_uint32 bytesNeededIdentifier = 0;
		Lib3MF_uint32 bytesWrittenIdentifier = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_GetIdentifier(m_pHandle, 0, &bytesNeededIdentifier, nullptr));
		std::vector<char> bufferIdentifier(bytesNeededIdentifier);
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_GetIdentifier(m_pHandle, bytesNeededIdentifier, &bytesWrittenIdentifier, &bufferIdentifier[0]));
		
		return std::string(&bufferIdentifier[0]);
	}
	
	/**
	* CBeamSet::GetReferenceCount - Retrieves the reference count of a beamset
	* @return returns the reference count
	*/
	Lib3MF_uint32 CBeamSet::GetReferenceCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_GetReferenceCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CBeamSet::SetReferences - Sets the references of a beamset
	* @param[in] ReferencesBuffer - the new indices of all beams in this beamset
	*/
	void CBeamSet::SetReferences(const CInputVector<Lib3MF_uint32> & ReferencesBuffer)
	{
		Lib3MF_uint64 nReferencesSize = ReferencesBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_SetReferences(m_pHandle, nReferencesSize, ReferencesBuffer.data()));
	}
	
	/**
	* CBeamSet::GetReferences - Retrieves the references of a beamset
	* @param[out] ReferencesBuffer - retrieves the indices of all beams in this beamset
	*/
	void CBeamSet::GetReferences(std::vector<Lib3MF_uint32> & ReferencesBuffer)
	{
		Lib3MF_uint64 elementsNeededReferences = 0;
		Lib3MF_uint64 elementsWrittenReferences = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_GetReferences(m_pHandle, 0, &elementsNeededReferences, nullptr));
		ReferencesBuffer.resize((size_t) elementsNeededReferences);
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_GetReferences(m_pHandle, elementsNeededReferences, &elementsWrittenReferences, ReferencesBuffer.data()));
	}
	
	/**
	* CBeamSet::GetBallReferenceCount - Retrieves the ball reference count of a beamset
	* @return returns the ball reference count
	*/
	Lib3MF_uint32 CBeamSet::GetBallReferenceCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_GetBallReferenceCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CBeamSet::SetBallReferences - Sets the ball references of a beamset
	* @param[in] BallReferencesBuffer - the new indices of all balls in this beamset
	*/
	void CBeamSet::SetBallReferences(const CInputVector<Lib3MF_uint32> & BallReferencesBuffer)
	{
		Lib3MF_uint64 nBallReferencesSize = BallReferencesBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_SetBallReferences(m_pHandle, nBallReferencesSize, BallReferencesBuffer.data()));
	}
	
	/**
	* CBeamSet::GetBallReferences - Retrieves the ball references of a beamset
	* @param[out] BallReferencesBuffer - retrieves the indices of all balls in this beamset
	*/
	void CBeamSet::GetBallReferences(std::vector<Lib3MF_uint32> & BallReferencesBuffer)
	{
		Lib3MF_uint64 elementsNeededBallReferences = 0;
		Lib3MF_uint64 elementsWrittenBallReferences = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_GetBallReferences(m_pHandle, 0, &elementsNeededBallReferences, nullptr));
		BallReferencesBuffer.resize((size_t) elementsNeededBallReferences);
		CheckError(m_pWrapper->m_WrapperTable.m_BeamSet_GetBallReferences(m_pHandle, elementsNeededBallReferences, &elementsWrittenBallReferences, BallReferencesBuffer.data()));
	}
	
	/**
	 * Method definitions for class CBaseMaterialGroup
	 */
	
	/**
	* CBaseMaterialGroup::GetCount - Retrieves the count of base materials in the material group.
	* @return returns the count of base materials.
	*/
	Lib3MF_uint32 CBaseMaterialGroup::GetCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BaseMaterialGroup_GetCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CBaseMaterialGroup::GetAllPropertyIDs - returns all the PropertyIDs of all materials in this group
	* @param[out] PropertyIDsBuffer - PropertyID of the material in the material group.
	*/
	void CBaseMaterialGroup::GetAllPropertyIDs(std::vector<Lib3MF_uint32> & PropertyIDsBuffer)
	{
		Lib3MF_uint64 elementsNeededPropertyIDs = 0;
		Lib3MF_uint64 elementsWrittenPropertyIDs = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BaseMaterialGroup_GetAllPropertyIDs(m_pHandle, 0, &elementsNeededPropertyIDs, nullptr));
		PropertyIDsBuffer.resize((size_t) elementsNeededPropertyIDs);
		CheckError(m_pWrapper->m_WrapperTable.m_BaseMaterialGroup_GetAllPropertyIDs(m_pHandle, elementsNeededPropertyIDs, &elementsWrittenPropertyIDs, PropertyIDsBuffer.data()));
	}
	
	/**
	* CBaseMaterialGroup::AddMaterial - Adds a new material to the material group
	* @param[in] sName - new name of the base material.
	* @param[in] DisplayColor - Display color of the material
	* @return returns new PropertyID of the new material in the material group.
	*/
	Lib3MF_uint32 CBaseMaterialGroup::AddMaterial(const std::string & sName, const sColor & DisplayColor)
	{
		Lib3MF_uint32 resultPropertyID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BaseMaterialGroup_AddMaterial(m_pHandle, sName.c_str(), &DisplayColor, &resultPropertyID));
		
		return resultPropertyID;
	}
	
	/**
	* CBaseMaterialGroup::RemoveMaterial - Removes a material from the material group.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	*/
	void CBaseMaterialGroup::RemoveMaterial(const Lib3MF_uint32 nPropertyID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BaseMaterialGroup_RemoveMaterial(m_pHandle, nPropertyID));
	}
	
	/**
	* CBaseMaterialGroup::GetName - Returns the base material's name
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @return returns the name of the base material.
	*/
	std::string CBaseMaterialGroup::GetName(const Lib3MF_uint32 nPropertyID)
	{
		Lib3MF_uint32 bytesNeededName = 0;
		Lib3MF_uint32 bytesWrittenName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BaseMaterialGroup_GetName(m_pHandle, nPropertyID, 0, &bytesNeededName, nullptr));
		std::vector<char> bufferName(bytesNeededName);
		CheckError(m_pWrapper->m_WrapperTable.m_BaseMaterialGroup_GetName(m_pHandle, nPropertyID, bytesNeededName, &bytesWrittenName, &bufferName[0]));
		
		return std::string(&bufferName[0]);
	}
	
	/**
	* CBaseMaterialGroup::SetName - Sets a base material's name
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[in] sName - new name of the base material.
	*/
	void CBaseMaterialGroup::SetName(const Lib3MF_uint32 nPropertyID, const std::string & sName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BaseMaterialGroup_SetName(m_pHandle, nPropertyID, sName.c_str()));
	}
	
	/**
	* CBaseMaterialGroup::SetDisplayColor - Sets a base material's display color.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[in] TheColor - The base material's display color
	*/
	void CBaseMaterialGroup::SetDisplayColor(const Lib3MF_uint32 nPropertyID, const sColor & TheColor)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BaseMaterialGroup_SetDisplayColor(m_pHandle, nPropertyID, &TheColor));
	}
	
	/**
	* CBaseMaterialGroup::GetDisplayColor - Returns a base material's display color.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @return The base material's display color
	*/
	sColor CBaseMaterialGroup::GetDisplayColor(const Lib3MF_uint32 nPropertyID)
	{
		sColor resultTheColor;
		CheckError(m_pWrapper->m_WrapperTable.m_BaseMaterialGroup_GetDisplayColor(m_pHandle, nPropertyID, &resultTheColor));
		
		return resultTheColor;
	}
	
	/**
	 * Method definitions for class CColorGroup
	 */
	
	/**
	* CColorGroup::GetCount - Retrieves the count of base materials in this Color Group.
	* @return returns the count of colors within this color group.
	*/
	Lib3MF_uint32 CColorGroup::GetCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ColorGroup_GetCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CColorGroup::GetAllPropertyIDs - returns all the PropertyIDs of all colors within this group
	* @param[out] PropertyIDsBuffer - PropertyID of the color in the color group.
	*/
	void CColorGroup::GetAllPropertyIDs(std::vector<Lib3MF_uint32> & PropertyIDsBuffer)
	{
		Lib3MF_uint64 elementsNeededPropertyIDs = 0;
		Lib3MF_uint64 elementsWrittenPropertyIDs = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ColorGroup_GetAllPropertyIDs(m_pHandle, 0, &elementsNeededPropertyIDs, nullptr));
		PropertyIDsBuffer.resize((size_t) elementsNeededPropertyIDs);
		CheckError(m_pWrapper->m_WrapperTable.m_ColorGroup_GetAllPropertyIDs(m_pHandle, elementsNeededPropertyIDs, &elementsWrittenPropertyIDs, PropertyIDsBuffer.data()));
	}
	
	/**
	* CColorGroup::AddColor - Adds a new value.
	* @param[in] TheColor - The new color
	* @return PropertyID of the new color within this color group.
	*/
	Lib3MF_uint32 CColorGroup::AddColor(const sColor & TheColor)
	{
		Lib3MF_uint32 resultPropertyID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ColorGroup_AddColor(m_pHandle, &TheColor, &resultPropertyID));
		
		return resultPropertyID;
	}
	
	/**
	* CColorGroup::RemoveColor - Removes a color from the color group.
	* @param[in] nPropertyID - PropertyID of the color to be removed from the color group.
	*/
	void CColorGroup::RemoveColor(const Lib3MF_uint32 nPropertyID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ColorGroup_RemoveColor(m_pHandle, nPropertyID));
	}
	
	/**
	* CColorGroup::SetColor - Sets a color value.
	* @param[in] nPropertyID - PropertyID of a color within this color group.
	* @param[in] TheColor - The color
	*/
	void CColorGroup::SetColor(const Lib3MF_uint32 nPropertyID, const sColor & TheColor)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ColorGroup_SetColor(m_pHandle, nPropertyID, &TheColor));
	}
	
	/**
	* CColorGroup::GetColor - Sets a color value.
	* @param[in] nPropertyID - PropertyID of a color within this color group.
	* @return The color
	*/
	sColor CColorGroup::GetColor(const Lib3MF_uint32 nPropertyID)
	{
		sColor resultTheColor;
		CheckError(m_pWrapper->m_WrapperTable.m_ColorGroup_GetColor(m_pHandle, nPropertyID, &resultTheColor));
		
		return resultTheColor;
	}
	
	/**
	 * Method definitions for class CTexture2DGroup
	 */
	
	/**
	* CTexture2DGroup::GetCount - Retrieves the count of tex2coords in the Texture2DGroup.
	* @return returns the count of tex2coords.
	*/
	Lib3MF_uint32 CTexture2DGroup::GetCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2DGroup_GetCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CTexture2DGroup::GetAllPropertyIDs - returns all the PropertyIDs of all tex2coords in this Texture2DGroup
	* @param[out] PropertyIDsBuffer - PropertyID of the tex2coords in the Texture2DGroup.
	*/
	void CTexture2DGroup::GetAllPropertyIDs(std::vector<Lib3MF_uint32> & PropertyIDsBuffer)
	{
		Lib3MF_uint64 elementsNeededPropertyIDs = 0;
		Lib3MF_uint64 elementsWrittenPropertyIDs = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2DGroup_GetAllPropertyIDs(m_pHandle, 0, &elementsNeededPropertyIDs, nullptr));
		PropertyIDsBuffer.resize((size_t) elementsNeededPropertyIDs);
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2DGroup_GetAllPropertyIDs(m_pHandle, elementsNeededPropertyIDs, &elementsWrittenPropertyIDs, PropertyIDsBuffer.data()));
	}
	
	/**
	* CTexture2DGroup::AddTex2Coord - Adds a new tex2coord to the Texture2DGroup
	* @param[in] UVCoordinate - The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	* @return returns new PropertyID of the new tex2coord in the Texture2DGroup.
	*/
	Lib3MF_uint32 CTexture2DGroup::AddTex2Coord(const sTex2Coord & UVCoordinate)
	{
		Lib3MF_uint32 resultPropertyID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2DGroup_AddTex2Coord(m_pHandle, &UVCoordinate, &resultPropertyID));
		
		return resultPropertyID;
	}
	
	/**
	* CTexture2DGroup::GetTex2Coord - Obtains a tex2coord to the Texture2DGroup
	* @param[in] nPropertyID - the PropertyID of the tex2coord in the Texture2DGroup.
	* @return The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	*/
	sTex2Coord CTexture2DGroup::GetTex2Coord(const Lib3MF_uint32 nPropertyID)
	{
		sTex2Coord resultUVCoordinate;
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2DGroup_GetTex2Coord(m_pHandle, nPropertyID, &resultUVCoordinate));
		
		return resultUVCoordinate;
	}
	
	/**
	* CTexture2DGroup::RemoveTex2Coord - Removes a tex2coords from the Texture2DGroup.
	* @param[in] nPropertyID - PropertyID of the tex2coords in the Texture2DGroup.
	*/
	void CTexture2DGroup::RemoveTex2Coord(const Lib3MF_uint32 nPropertyID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2DGroup_RemoveTex2Coord(m_pHandle, nPropertyID));
	}
	
	/**
	* CTexture2DGroup::GetTexture2D - Obtains the texture2D instance of this group.
	* @return the texture2D instance of this group.
	*/
	PTexture2D CTexture2DGroup::GetTexture2D()
	{
		Lib3MFHandle hTexture2DInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2DGroup_GetTexture2D(m_pHandle, &hTexture2DInstance));
		
		if (!hTexture2DInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTexture2D>(dynamic_cast<CTexture2D*>(m_pWrapper->polymorphicFactory(hTexture2DInstance)));
	}
	
	/**
	 * Method definitions for class CCompositeMaterials
	 */
	
	/**
	* CCompositeMaterials::GetCount - Retrieves the count of Composite-s in the CompositeMaterials.
	* @return returns the count of Composite-s
	*/
	Lib3MF_uint32 CCompositeMaterials::GetCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_CompositeMaterials_GetCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CCompositeMaterials::GetAllPropertyIDs - returns all the PropertyIDs of all Composite-Mixing Values in this CompositeMaterials
	* @param[out] PropertyIDsBuffer - PropertyID of the Composite-Mixing Values in the CompositeMaterials.
	*/
	void CCompositeMaterials::GetAllPropertyIDs(std::vector<Lib3MF_uint32> & PropertyIDsBuffer)
	{
		Lib3MF_uint64 elementsNeededPropertyIDs = 0;
		Lib3MF_uint64 elementsWrittenPropertyIDs = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_CompositeMaterials_GetAllPropertyIDs(m_pHandle, 0, &elementsNeededPropertyIDs, nullptr));
		PropertyIDsBuffer.resize((size_t) elementsNeededPropertyIDs);
		CheckError(m_pWrapper->m_WrapperTable.m_CompositeMaterials_GetAllPropertyIDs(m_pHandle, elementsNeededPropertyIDs, &elementsWrittenPropertyIDs, PropertyIDsBuffer.data()));
	}
	
	/**
	* CCompositeMaterials::GetBaseMaterialGroup - Obtains the BaseMaterialGroup instance of this CompositeMaterials.
	* @return returns the BaseMaterialGroup instance of this CompositeMaterials
	*/
	PBaseMaterialGroup CCompositeMaterials::GetBaseMaterialGroup()
	{
		Lib3MFHandle hBaseMaterialGroupInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_CompositeMaterials_GetBaseMaterialGroup(m_pHandle, &hBaseMaterialGroupInstance));
		
		if (!hBaseMaterialGroupInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBaseMaterialGroup>(dynamic_cast<CBaseMaterialGroup*>(m_pWrapper->polymorphicFactory(hBaseMaterialGroupInstance)));
	}
	
	/**
	* CCompositeMaterials::AddComposite - Adds a new Composite-Mixing Values to the CompositeMaterials.
	* @param[in] CompositeBuffer - The Composite Constituents to be added as composite
	* @return returns new PropertyID of the new Composite in the CompositeMaterials.
	*/
	Lib3MF_uint32 CCompositeMaterials::AddComposite(const CInputVector<sCompositeConstituent> & CompositeBuffer)
	{
		Lib3MF_uint64 nCompositeSize = CompositeBuffer.size();
		Lib3MF_uint32 resultPropertyID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_CompositeMaterials_AddComposite(m_pHandle, nCompositeSize, CompositeBuffer.data(), &resultPropertyID));
		
		return resultPropertyID;
	}
	
	/**
	* CCompositeMaterials::RemoveComposite - Removes a Composite-Maxing Ratio from the CompositeMaterials.
	* @param[in] nPropertyID - PropertyID of the  Composite-Mixing Values in the CompositeMaterials to be removed.
	*/
	void CCompositeMaterials::RemoveComposite(const Lib3MF_uint32 nPropertyID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_CompositeMaterials_RemoveComposite(m_pHandle, nPropertyID));
	}
	
	/**
	* CCompositeMaterials::GetComposite - Obtains a Composite-Maxing Ratio of this CompositeMaterials.
	* @param[in] nPropertyID - the PropertyID of the Composite-Maxing Ratio in the CompositeMaterials.
	* @param[out] CompositeBuffer - The Composite-Mixing Values with the given PropertyID
	*/
	void CCompositeMaterials::GetComposite(const Lib3MF_uint32 nPropertyID, std::vector<sCompositeConstituent> & CompositeBuffer)
	{
		Lib3MF_uint64 elementsNeededComposite = 0;
		Lib3MF_uint64 elementsWrittenComposite = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_CompositeMaterials_GetComposite(m_pHandle, nPropertyID, 0, &elementsNeededComposite, nullptr));
		CompositeBuffer.resize((size_t) elementsNeededComposite);
		CheckError(m_pWrapper->m_WrapperTable.m_CompositeMaterials_GetComposite(m_pHandle, nPropertyID, elementsNeededComposite, &elementsWrittenComposite, CompositeBuffer.data()));
	}
	
	/**
	 * Method definitions for class CMultiPropertyGroup
	 */
	
	/**
	* CMultiPropertyGroup::GetCount - Retrieves the count of MultiProperty-s in the MultiPropertyGroup.
	* @return returns the count of MultiProperty-s
	*/
	Lib3MF_uint32 CMultiPropertyGroup::GetCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_GetCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CMultiPropertyGroup::GetAllPropertyIDs - returns all the PropertyIDs of all MultiProperty-s in this MultiPropertyGroup
	* @param[out] PropertyIDsBuffer - PropertyID of the MultiProperty-s in the MultiPropertyGroup.
	*/
	void CMultiPropertyGroup::GetAllPropertyIDs(std::vector<Lib3MF_uint32> & PropertyIDsBuffer)
	{
		Lib3MF_uint64 elementsNeededPropertyIDs = 0;
		Lib3MF_uint64 elementsWrittenPropertyIDs = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_GetAllPropertyIDs(m_pHandle, 0, &elementsNeededPropertyIDs, nullptr));
		PropertyIDsBuffer.resize((size_t) elementsNeededPropertyIDs);
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_GetAllPropertyIDs(m_pHandle, elementsNeededPropertyIDs, &elementsWrittenPropertyIDs, PropertyIDsBuffer.data()));
	}
	
	/**
	* CMultiPropertyGroup::AddMultiProperty - Adds a new MultiProperty to the MultiPropertyGroup.
	* @param[in] PropertyIDsBuffer - The PropertyIDs of the new MultiProperty.
	* @return returns the PropertyID of the new MultiProperty in the MultiPropertyGroup.
	*/
	Lib3MF_uint32 CMultiPropertyGroup::AddMultiProperty(const CInputVector<Lib3MF_uint32> & PropertyIDsBuffer)
	{
		Lib3MF_uint64 nPropertyIDsSize = PropertyIDsBuffer.size();
		Lib3MF_uint32 resultPropertyID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_AddMultiProperty(m_pHandle, nPropertyIDsSize, PropertyIDsBuffer.data(), &resultPropertyID));
		
		return resultPropertyID;
	}
	
	/**
	* CMultiPropertyGroup::SetMultiProperty - Sets the PropertyIDs of a MultiProperty.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be changed.
	* @param[in] PropertyIDsBuffer - The new PropertyIDs of the MultiProperty
	*/
	void CMultiPropertyGroup::SetMultiProperty(const Lib3MF_uint32 nPropertyID, const CInputVector<Lib3MF_uint32> & PropertyIDsBuffer)
	{
		Lib3MF_uint64 nPropertyIDsSize = PropertyIDsBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_SetMultiProperty(m_pHandle, nPropertyID, nPropertyIDsSize, PropertyIDsBuffer.data()));
	}
	
	/**
	* CMultiPropertyGroup::GetMultiProperty - Obtains the PropertyIDs of a MultiProperty.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be queried.
	* @param[out] PropertyIDsBuffer - The PropertyIDs of the MultiProperty
	*/
	void CMultiPropertyGroup::GetMultiProperty(const Lib3MF_uint32 nPropertyID, std::vector<Lib3MF_uint32> & PropertyIDsBuffer)
	{
		Lib3MF_uint64 elementsNeededPropertyIDs = 0;
		Lib3MF_uint64 elementsWrittenPropertyIDs = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_GetMultiProperty(m_pHandle, nPropertyID, 0, &elementsNeededPropertyIDs, nullptr));
		PropertyIDsBuffer.resize((size_t) elementsNeededPropertyIDs);
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_GetMultiProperty(m_pHandle, nPropertyID, elementsNeededPropertyIDs, &elementsWrittenPropertyIDs, PropertyIDsBuffer.data()));
	}
	
	/**
	* CMultiPropertyGroup::RemoveMultiProperty - Removes a MultiProperty from this MultiPropertyGroup.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be removed.
	*/
	void CMultiPropertyGroup::RemoveMultiProperty(const Lib3MF_uint32 nPropertyID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_RemoveMultiProperty(m_pHandle, nPropertyID));
	}
	
	/**
	* CMultiPropertyGroup::GetLayerCount - Retrieves the number of layers of this MultiPropertyGroup.
	* @return returns the number of layers
	*/
	Lib3MF_uint32 CMultiPropertyGroup::GetLayerCount()
	{
		Lib3MF_uint32 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_GetLayerCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CMultiPropertyGroup::AddLayer - Adds a MultiPropertyLayer to this MultiPropertyGroup.
	* @param[in] TheLayer - The MultiPropertyLayer to add to this MultiPropertyGroup
	* @return returns the index of this MultiPropertyLayer
	*/
	Lib3MF_uint32 CMultiPropertyGroup::AddLayer(const sMultiPropertyLayer & TheLayer)
	{
		Lib3MF_uint32 resultLayerIndex = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_AddLayer(m_pHandle, &TheLayer, &resultLayerIndex));
		
		return resultLayerIndex;
	}
	
	/**
	* CMultiPropertyGroup::GetLayer - Obtains a MultiPropertyLayer of this MultiPropertyGroup.
	* @param[in] nLayerIndex - The Index of the MultiPropertyLayer queried
	* @return The MultiPropertyLayer with index LayerIndex within MultiPropertyGroup
	*/
	sMultiPropertyLayer CMultiPropertyGroup::GetLayer(const Lib3MF_uint32 nLayerIndex)
	{
		sMultiPropertyLayer resultTheLayer;
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_GetLayer(m_pHandle, nLayerIndex, &resultTheLayer));
		
		return resultTheLayer;
	}
	
	/**
	* CMultiPropertyGroup::RemoveLayer - Removes a MultiPropertyLayer from this MultiPropertyGroup.
	* @param[in] nLayerIndex - The Index of the MultiPropertyLayer to be removed
	*/
	void CMultiPropertyGroup::RemoveLayer(const Lib3MF_uint32 nLayerIndex)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_MultiPropertyGroup_RemoveLayer(m_pHandle, nLayerIndex));
	}
	
	/**
	 * Method definitions for class CImage3D
	 */
	
	/**
	* CImage3D::GetName - returns the name of this Image3D
	* @return the name of this Image3D
	*/
	std::string CImage3D::GetName()
	{
		Lib3MF_uint32 bytesNeededName = 0;
		Lib3MF_uint32 bytesWrittenName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Image3D_GetName(m_pHandle, 0, &bytesNeededName, nullptr));
		std::vector<char> bufferName(bytesNeededName);
		CheckError(m_pWrapper->m_WrapperTable.m_Image3D_GetName(m_pHandle, bytesNeededName, &bytesWrittenName, &bufferName[0]));
		
		return std::string(&bufferName[0]);
	}
	
	/**
	* CImage3D::SetName - sets a new name of this Image3D
	* @param[in] sName - the new name of this Image3D
	*/
	void CImage3D::SetName(const std::string & sName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Image3D_SetName(m_pHandle, sName.c_str()));
	}
	
	/**
	* CImage3D::IsImageStack - Retrieves, if this Image3D is a ImageStack
	* @return returns, whether the Image3D is an ImageStack
	*/
	bool CImage3D::IsImageStack()
	{
		bool resultIsImageStack = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Image3D_IsImageStack(m_pHandle, &resultIsImageStack));
		
		return resultIsImageStack;
	}
	
	/**
	 * Method definitions for class CImageStack
	 */
	
	/**
	* CImageStack::GetRowCount - Retrieves the number of rows in each image of this image3d
	* @return number of rows
	*/
	Lib3MF_uint32 CImageStack::GetRowCount()
	{
		Lib3MF_uint32 resultRowCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImageStack_GetRowCount(m_pHandle, &resultRowCount));
		
		return resultRowCount;
	}
	
	/**
	* CImageStack::SetRowCount - Sets the number of rows in each image of this image3d
	* @param[in] nRowCount - number of rows
	*/
	void CImageStack::SetRowCount(const Lib3MF_uint32 nRowCount)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImageStack_SetRowCount(m_pHandle, nRowCount));
	}
	
	/**
	* CImageStack::GetColumnCount - Retrieves the number of columns in each image of this image3d
	* @return number of columns
	*/
	Lib3MF_uint32 CImageStack::GetColumnCount()
	{
		Lib3MF_uint32 resultColumnCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImageStack_GetColumnCount(m_pHandle, &resultColumnCount));
		
		return resultColumnCount;
	}
	
	/**
	* CImageStack::SetColumnCount - Sets the number of columns in each image of this image3d
	* @param[in] nColumnCount - number of columns
	*/
	void CImageStack::SetColumnCount(const Lib3MF_uint32 nColumnCount)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImageStack_SetColumnCount(m_pHandle, nColumnCount));
	}
	
	/**
	* CImageStack::GetSheetCount - Retrieves the number of images in the stack.
	* @return number of images
	*/
	Lib3MF_uint32 CImageStack::GetSheetCount()
	{
		Lib3MF_uint32 resultSheetCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImageStack_GetSheetCount(m_pHandle, &resultSheetCount));
		
		return resultSheetCount;
	}
	
	/**
	* CImageStack::GetSheet - Retrieves a sheet of the stack. Raises an error if sheet is not set.
	* @param[in] nIndex - index of the image (0-based)
	* @return attachment containing the image
	*/
	PAttachment CImageStack::GetSheet(const Lib3MF_uint32 nIndex)
	{
		Lib3MFHandle hSheet = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImageStack_GetSheet(m_pHandle, nIndex, &hSheet));
		
		if (!hSheet) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CAttachment>(dynamic_cast<CAttachment*>(m_pWrapper->polymorphicFactory(hSheet)));
	}
	
	/**
	* CImageStack::SetSheet - Sets a sheet to an existing attachment.
	* @param[in] nIndex - index of the image (0-based)
	* @param[in] pSheet - attachment containing the image
	*/
	void CImageStack::SetSheet(const Lib3MF_uint32 nIndex, classParam<CAttachment> pSheet)
	{
		Lib3MFHandle hSheet = pSheet.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_ImageStack_SetSheet(m_pHandle, nIndex, hSheet));
	}
	
	/**
	* CImageStack::CreateEmptySheet - Creates a new sheet attachment with empty data.
	* @param[in] nIndex - index of the image (0-based)
	* @param[in] sPath - path of part in the package
	* @return attachment containing the image
	*/
	PAttachment CImageStack::CreateEmptySheet(const Lib3MF_uint32 nIndex, const std::string & sPath)
	{
		Lib3MFHandle hSheet = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImageStack_CreateEmptySheet(m_pHandle, nIndex, sPath.c_str(), &hSheet));
		
		if (!hSheet) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CAttachment>(dynamic_cast<CAttachment*>(m_pWrapper->polymorphicFactory(hSheet)));
	}
	
	/**
	* CImageStack::CreateSheetFromBuffer - Creates a new sheet attachment from a memory buffer.
	* @param[in] nIndex - index of the image (0-based)
	* @param[in] sPath - path of part in the package
	* @param[in] DataBuffer - binary image data
	* @return attachment containing the image
	*/
	PAttachment CImageStack::CreateSheetFromBuffer(const Lib3MF_uint32 nIndex, const std::string & sPath, const CInputVector<Lib3MF_uint8> & DataBuffer)
	{
		Lib3MF_uint64 nDataSize = DataBuffer.size();
		Lib3MFHandle hSheet = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImageStack_CreateSheetFromBuffer(m_pHandle, nIndex, sPath.c_str(), nDataSize, DataBuffer.data(), &hSheet));
		
		if (!hSheet) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CAttachment>(dynamic_cast<CAttachment*>(m_pWrapper->polymorphicFactory(hSheet)));
	}
	
	/**
	* CImageStack::CreateSheetFromFile - Creates a new sheet attachment from a file on disk.
	* @param[in] nIndex - index of the image (0-based)
	* @param[in] sPath - path of part in the package
	* @param[in] sFileName - file name to read from
	* @return attachment containing the image
	*/
	PAttachment CImageStack::CreateSheetFromFile(const Lib3MF_uint32 nIndex, const std::string & sPath, const std::string & sFileName)
	{
		Lib3MFHandle hSheet = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImageStack_CreateSheetFromFile(m_pHandle, nIndex, sPath.c_str(), sFileName.c_str(), &hSheet));
		
		if (!hSheet) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CAttachment>(dynamic_cast<CAttachment*>(m_pWrapper->polymorphicFactory(hSheet)));
	}
	
	/**
	 * Method definitions for class CAttachment
	 */
	
	/**
	* CAttachment::GetPath - Retrieves an attachment's package path. This function will be removed in a later release.
	* @return returns the attachment's package path string
	*/
	std::string CAttachment::GetPath()
	{
		Lib3MF_uint32 bytesNeededPath = 0;
		Lib3MF_uint32 bytesWrittenPath = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_GetPath(m_pHandle, 0, &bytesNeededPath, nullptr));
		std::vector<char> bufferPath(bytesNeededPath);
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_GetPath(m_pHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]));
		
		return std::string(&bufferPath[0]);
	}
	
	/**
	* CAttachment::SetPath - Sets an attachment's package path. This function will be removed in a later release.
	* @param[in] sPath - new path of the attachment.
	*/
	void CAttachment::SetPath(const std::string & sPath)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_SetPath(m_pHandle, sPath.c_str()));
	}
	
	/**
	* CAttachment::PackagePart - Returns the PackagePart that is this attachment.
	* @return The PackagePart of this attachment.
	*/
	PPackagePart CAttachment::PackagePart()
	{
		Lib3MFHandle hPackagePart = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_PackagePart(m_pHandle, &hPackagePart));
		
		if (!hPackagePart) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CPackagePart>(dynamic_cast<CPackagePart*>(m_pWrapper->polymorphicFactory(hPackagePart)));
	}
	
	/**
	* CAttachment::GetRelationShipType - Retrieves an attachment's relationship type
	* @return returns the attachment's package relationship type string
	*/
	std::string CAttachment::GetRelationShipType()
	{
		Lib3MF_uint32 bytesNeededPath = 0;
		Lib3MF_uint32 bytesWrittenPath = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_GetRelationShipType(m_pHandle, 0, &bytesNeededPath, nullptr));
		std::vector<char> bufferPath(bytesNeededPath);
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_GetRelationShipType(m_pHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]));
		
		return std::string(&bufferPath[0]);
	}
	
	/**
	* CAttachment::SetRelationShipType - Sets an attachment's relationship type.
	* @param[in] sPath - new relationship type string.
	*/
	void CAttachment::SetRelationShipType(const std::string & sPath)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_SetRelationShipType(m_pHandle, sPath.c_str()));
	}
	
	/**
	* CAttachment::WriteToFile - Writes out the attachment as file.
	* @param[in] sFileName - file to write into.
	*/
	void CAttachment::WriteToFile(const std::string & sFileName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_WriteToFile(m_pHandle, sFileName.c_str()));
	}
	
	/**
	* CAttachment::ReadFromFile - Reads an attachment from a file. The path of this file is only read when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer methods.
	* @param[in] sFileName - file to read from.
	*/
	void CAttachment::ReadFromFile(const std::string & sFileName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_ReadFromFile(m_pHandle, sFileName.c_str()));
	}
	
	/**
	* CAttachment::ReadFromCallback - Reads an attachment from the data provided by a callback function. This callback function is only invoked when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer methods.
	* @param[in] pTheReadCallback - Callback to call for reading a data chunk
	* @param[in] nStreamSize - number of bytes the callback returns
	* @param[in] pTheSeekCallback - Callback to call for seeking in the stream.
	* @param[in] pUserData - Userdata that is passed to the callback function
	*/
	void CAttachment::ReadFromCallback(const ReadCallback pTheReadCallback, const Lib3MF_uint64 nStreamSize, const SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_ReadFromCallback(m_pHandle, pTheReadCallback, nStreamSize, pTheSeekCallback, pUserData));
	}
	
	/**
	* CAttachment::GetStreamSize - Retrieves the size of the attachment stream
	* @return the stream size
	*/
	Lib3MF_uint64 CAttachment::GetStreamSize()
	{
		Lib3MF_uint64 resultStreamSize = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_GetStreamSize(m_pHandle, &resultStreamSize));
		
		return resultStreamSize;
	}
	
	/**
	* CAttachment::WriteToBuffer - Writes out the attachment into a buffer
	* @param[out] BufferBuffer - Buffer to write into
	*/
	void CAttachment::WriteToBuffer(std::vector<Lib3MF_uint8> & BufferBuffer)
	{
		Lib3MF_uint64 elementsNeededBuffer = 0;
		Lib3MF_uint64 elementsWrittenBuffer = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_WriteToBuffer(m_pHandle, 0, &elementsNeededBuffer, nullptr));
		BufferBuffer.resize((size_t) elementsNeededBuffer);
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_WriteToBuffer(m_pHandle, elementsNeededBuffer, &elementsWrittenBuffer, BufferBuffer.data()));
	}
	
	/**
	* CAttachment::ReadFromBuffer - Reads an attachment from a memory buffer. This buffer is immediately read (in contrast to the ReadFromCallback and ReadFromFile-methods).
	* @param[in] BufferBuffer - Buffer to read from
	*/
	void CAttachment::ReadFromBuffer(const CInputVector<Lib3MF_uint8> & BufferBuffer)
	{
		Lib3MF_uint64 nBufferSize = BufferBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_Attachment_ReadFromBuffer(m_pHandle, nBufferSize, BufferBuffer.data()));
	}
	
	/**
	 * Method definitions for class CTexture2D
	 */
	
	/**
	* CTexture2D::GetAttachment - Retrieves the attachment located at the path of the texture.
	* @return attachment that holds the texture's image information.
	*/
	PAttachment CTexture2D::GetAttachment()
	{
		Lib3MFHandle hAttachment = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2D_GetAttachment(m_pHandle, &hAttachment));
		
		if (!hAttachment) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CAttachment>(dynamic_cast<CAttachment*>(m_pWrapper->polymorphicFactory(hAttachment)));
	}
	
	/**
	* CTexture2D::SetAttachment - Sets the texture's package path to the path of the attachment.
	* @param[in] pAttachment - attachment that holds the texture's image information.
	*/
	void CTexture2D::SetAttachment(classParam<CAttachment> pAttachment)
	{
		Lib3MFHandle hAttachment = pAttachment.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2D_SetAttachment(m_pHandle, hAttachment));
	}
	
	/**
	* CTexture2D::GetContentType - Retrieves a texture's content type.
	* @return returns content type enum.
	*/
	eTextureType CTexture2D::GetContentType()
	{
		eTextureType resultContentType = (eTextureType) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2D_GetContentType(m_pHandle, &resultContentType));
		
		return resultContentType;
	}
	
	/**
	* CTexture2D::SetContentType - Retrieves a texture's content type.
	* @param[in] eContentType - new Content Type
	*/
	void CTexture2D::SetContentType(const eTextureType eContentType)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2D_SetContentType(m_pHandle, eContentType));
	}
	
	/**
	* CTexture2D::GetTileStyleUV - Retrieves a texture's tilestyle type.
	* @param[out] eTileStyleU - returns tilestyle type enum.
	* @param[out] eTileStyleV - returns tilestyle type enum.
	*/
	void CTexture2D::GetTileStyleUV(eTextureTileStyle & eTileStyleU, eTextureTileStyle & eTileStyleV)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2D_GetTileStyleUV(m_pHandle, &eTileStyleU, &eTileStyleV));
	}
	
	/**
	* CTexture2D::SetTileStyleUV - Sets a texture's tilestyle type.
	* @param[in] eTileStyleU - new tilestyle type enum.
	* @param[in] eTileStyleV - new tilestyle type enum.
	*/
	void CTexture2D::SetTileStyleUV(const eTextureTileStyle eTileStyleU, const eTextureTileStyle eTileStyleV)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2D_SetTileStyleUV(m_pHandle, eTileStyleU, eTileStyleV));
	}
	
	/**
	* CTexture2D::GetFilter - Retrieves a texture's filter type.
	* @return returns filter type enum.
	*/
	eTextureFilter CTexture2D::GetFilter()
	{
		eTextureFilter resultFilter = (eTextureFilter) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2D_GetFilter(m_pHandle, &resultFilter));
		
		return resultFilter;
	}
	
	/**
	* CTexture2D::SetFilter - Sets a texture's filter type.
	* @param[in] eFilter - sets new filter type enum.
	*/
	void CTexture2D::SetFilter(const eTextureFilter eFilter)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Texture2D_SetFilter(m_pHandle, eFilter));
	}
	
	/**
	 * Method definitions for class CImplicitPort
	 */
	
	/**
	* CImplicitPort::GetIdentifier - Retrieves the identifier of the port
	* @return the identifier
	*/
	std::string CImplicitPort::GetIdentifier()
	{
		Lib3MF_uint32 bytesNeededIdentifier = 0;
		Lib3MF_uint32 bytesWrittenIdentifier = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPort_GetIdentifier(m_pHandle, 0, &bytesNeededIdentifier, nullptr));
		std::vector<char> bufferIdentifier(bytesNeededIdentifier);
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPort_GetIdentifier(m_pHandle, bytesNeededIdentifier, &bytesWrittenIdentifier, &bufferIdentifier[0]));
		
		return std::string(&bufferIdentifier[0]);
	}
	
	/**
	* CImplicitPort::SetIdentifier - Sets the identifier of the port
	* @param[in] sIdentifier - the identifier
	*/
	void CImplicitPort::SetIdentifier(const std::string & sIdentifier)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPort_SetIdentifier(m_pHandle, sIdentifier.c_str()));
	}
	
	/**
	* CImplicitPort::GetDisplayName - Retrieves the display name of the port
	* @return the display name
	*/
	std::string CImplicitPort::GetDisplayName()
	{
		Lib3MF_uint32 bytesNeededDisplayName = 0;
		Lib3MF_uint32 bytesWrittenDisplayName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPort_GetDisplayName(m_pHandle, 0, &bytesNeededDisplayName, nullptr));
		std::vector<char> bufferDisplayName(bytesNeededDisplayName);
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPort_GetDisplayName(m_pHandle, bytesNeededDisplayName, &bytesWrittenDisplayName, &bufferDisplayName[0]));
		
		return std::string(&bufferDisplayName[0]);
	}
	
	/**
	* CImplicitPort::SetDisplayName - Sets the display name of the port
	* @param[in] sDisplayName - the display name
	*/
	void CImplicitPort::SetDisplayName(const std::string & sDisplayName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPort_SetDisplayName(m_pHandle, sDisplayName.c_str()));
	}
	
	/**
	* CImplicitPort::SetType - Sets the type of the port
	* @param[in] eImplicitPortType - the type
	*/
	void CImplicitPort::SetType(const eImplicitPortType eImplicitPortType)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPort_SetType(m_pHandle, eImplicitPortType));
	}
	
	/**
	* CImplicitPort::GetType - Retrieves the type of the port
	* @return the type
	*/
	eImplicitPortType CImplicitPort::GetType()
	{
		eImplicitPortType resultImplicitPortType = (eImplicitPortType) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPort_GetType(m_pHandle, &resultImplicitPortType));
		
		return resultImplicitPortType;
	}
	
	/**
	* CImplicitPort::GetReference - Retrieves the reference of the port, only used for input ports
	* @return the reference
	*/
	std::string CImplicitPort::GetReference()
	{
		Lib3MF_uint32 bytesNeededReference = 0;
		Lib3MF_uint32 bytesWrittenReference = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPort_GetReference(m_pHandle, 0, &bytesNeededReference, nullptr));
		std::vector<char> bufferReference(bytesNeededReference);
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPort_GetReference(m_pHandle, bytesNeededReference, &bytesWrittenReference, &bufferReference[0]));
		
		return std::string(&bufferReference[0]);
	}
	
	/**
	* CImplicitPort::SetReference - Sets the reference of the port, only used for input ports
	* @param[in] sReference - the reference
	*/
	void CImplicitPort::SetReference(const std::string & sReference)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPort_SetReference(m_pHandle, sReference.c_str()));
	}
	
	/**
	 * Method definitions for class CIterator
	 */
	
	/**
	* CIterator::MoveNext - Iterates to the next item in the list.
	* @return Iterates to the next item in the list.
	*/
	bool CIterator::MoveNext()
	{
		bool resultHasNext = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Iterator_MoveNext(m_pHandle, &resultHasNext));
		
		return resultHasNext;
	}
	
	/**
	* CIterator::MovePrevious - Iterates to the previous item in the list.
	* @return Iterates to the previous item in the list.
	*/
	bool CIterator::MovePrevious()
	{
		bool resultHasPrevious = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Iterator_MovePrevious(m_pHandle, &resultHasPrevious));
		
		return resultHasPrevious;
	}
	
	/**
	* CIterator::Count - Returns the number of items the iterator captures.
	* @return returns the number of items the iterator captures.
	*/
	Lib3MF_uint64 CIterator::Count()
	{
		Lib3MF_uint64 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Iterator_Count(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	 * Method definitions for class CImplicitPortIterator
	 */
	
	/**
	* CImplicitPortIterator::GetCurrent - Returns the current element
	* @return The current element
	*/
	PImplicitPort CImplicitPortIterator::GetCurrent()
	{
		Lib3MFHandle hPort = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitPortIterator_GetCurrent(m_pHandle, &hPort));
		
		if (!hPort) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hPort)));
	}
	
	/**
	 * Method definitions for class CImplicitNode
	 */
	
	/**
	* CImplicitNode::GetIdentifier - Retrieves the identifier of the node
	* @return the identifier
	*/
	std::string CImplicitNode::GetIdentifier()
	{
		Lib3MF_uint32 bytesNeededIdentifier = 0;
		Lib3MF_uint32 bytesWrittenIdentifier = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_GetIdentifier(m_pHandle, 0, &bytesNeededIdentifier, nullptr));
		std::vector<char> bufferIdentifier(bytesNeededIdentifier);
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_GetIdentifier(m_pHandle, bytesNeededIdentifier, &bytesWrittenIdentifier, &bufferIdentifier[0]));
		
		return std::string(&bufferIdentifier[0]);
	}
	
	/**
	* CImplicitNode::SetIdentifier - Sets the identifier of the node
	* @param[in] sIdentifier - the identifier
	*/
	void CImplicitNode::SetIdentifier(const std::string & sIdentifier)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_SetIdentifier(m_pHandle, sIdentifier.c_str()));
	}
	
	/**
	* CImplicitNode::GetDisplayName - Retrieves the display name of the node
	* @return the display name
	*/
	std::string CImplicitNode::GetDisplayName()
	{
		Lib3MF_uint32 bytesNeededDisplayName = 0;
		Lib3MF_uint32 bytesWrittenDisplayName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_GetDisplayName(m_pHandle, 0, &bytesNeededDisplayName, nullptr));
		std::vector<char> bufferDisplayName(bytesNeededDisplayName);
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_GetDisplayName(m_pHandle, bytesNeededDisplayName, &bytesWrittenDisplayName, &bufferDisplayName[0]));
		
		return std::string(&bufferDisplayName[0]);
	}
	
	/**
	* CImplicitNode::SetDisplayName - Sets the display name of the node
	* @param[in] sDisplayName - the display name
	*/
	void CImplicitNode::SetDisplayName(const std::string & sDisplayName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_SetDisplayName(m_pHandle, sDisplayName.c_str()));
	}
	
	/**
	* CImplicitNode::GetTag - Retrieves the tag of the node
	* @return the tag
	*/
	std::string CImplicitNode::GetTag()
	{
		Lib3MF_uint32 bytesNeededTag = 0;
		Lib3MF_uint32 bytesWrittenTag = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_GetTag(m_pHandle, 0, &bytesNeededTag, nullptr));
		std::vector<char> bufferTag(bytesNeededTag);
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_GetTag(m_pHandle, bytesNeededTag, &bytesWrittenTag, &bufferTag[0]));
		
		return std::string(&bufferTag[0]);
	}
	
	/**
	* CImplicitNode::SetTag - Sets the tag of the node
	* @param[in] sTag - the tag
	*/
	void CImplicitNode::SetTag(const std::string & sTag)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_SetTag(m_pHandle, sTag.c_str()));
	}
	
	/**
	* CImplicitNode::GetNodeType - Retrieves the type of the node
	* @return the type of the node
	*/
	eImplicitNodeType CImplicitNode::GetNodeType()
	{
		eImplicitNodeType resultType = (eImplicitNodeType) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_GetNodeType(m_pHandle, &resultType));
		
		return resultType;
	}
	
	/**
	* CImplicitNode::AddInput - Add an input
	* @param[in] sIdentifier - the identifier of the input
	* @param[in] sDisplayName - the display name of the input
	* @return 
	*/
	PImplicitPort CImplicitNode::AddInput(const std::string & sIdentifier, const std::string & sDisplayName)
	{
		Lib3MFHandle hPort = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_AddInput(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), &hPort));
		
		if (!hPort) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hPort)));
	}
	
	/**
	* CImplicitNode::GetInputs - Retrieves the inputs
	* @return the iterator for the inputs
	*/
	PImplicitPortIterator CImplicitNode::GetInputs()
	{
		Lib3MFHandle hIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_GetInputs(m_pHandle, &hIterator));
		
		if (!hIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPortIterator>(dynamic_cast<CImplicitPortIterator*>(m_pWrapper->polymorphicFactory(hIterator)));
	}
	
	/**
	* CImplicitNode::AddOutput - Add an output
	* @param[in] sIdentifier - the identifier of the output
	* @param[in] sDisplayName - the display name of the output
	* @return 
	*/
	PImplicitPort CImplicitNode::AddOutput(const std::string & sIdentifier, const std::string & sDisplayName)
	{
		Lib3MFHandle hPort = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_AddOutput(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), &hPort));
		
		if (!hPort) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hPort)));
	}
	
	/**
	* CImplicitNode::GetOutputs - Retrieves the outputs
	* @return the iterator the outputs
	*/
	PImplicitPortIterator CImplicitNode::GetOutputs()
	{
		Lib3MFHandle hIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_GetOutputs(m_pHandle, &hIterator));
		
		if (!hIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPortIterator>(dynamic_cast<CImplicitPortIterator*>(m_pWrapper->polymorphicFactory(hIterator)));
	}
	
	/**
	* CImplicitNode::FindInput - Retrieves an input
	* @param[in] sIdentifier - the identifier of the input
	* @return the input port
	*/
	PImplicitPort CImplicitNode::FindInput(const std::string & sIdentifier)
	{
		Lib3MFHandle hInput = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_FindInput(m_pHandle, sIdentifier.c_str(), &hInput));
		
		if (hInput) {
			return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hInput)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CImplicitNode::FindOutput - Retrieves an output
	* @param[in] sIdentifier - the identifier of the output
	* @return the output port
	*/
	PImplicitPort CImplicitNode::FindOutput(const std::string & sIdentifier)
	{
		Lib3MFHandle hOutput = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_FindOutput(m_pHandle, sIdentifier.c_str(), &hOutput));
		
		if (hOutput) {
			return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hOutput)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CImplicitNode::AreTypesValid - Checks if the types of the input and output ports are valid for the node type
	* @return true, if the types are valid
	*/
	bool CImplicitNode::AreTypesValid()
	{
		bool resultValid = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitNode_AreTypesValid(m_pHandle, &resultValid));
		
		return resultValid;
	}
	
	/**
	 * Method definitions for class COneInputNode
	 */
	
	/**
	* COneInputNode::GetInputA - Retrieves the input
	* @return the input
	*/
	PImplicitPort COneInputNode::GetInputA()
	{
		Lib3MFHandle hInput = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_OneInputNode_GetInputA(m_pHandle, &hInput));
		
		if (!hInput) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hInput)));
	}
	
	/**
	* COneInputNode::GetOutputResult - Retrieves the output
	* @return the output
	*/
	PImplicitPort COneInputNode::GetOutputResult()
	{
		Lib3MFHandle hResult = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_OneInputNode_GetOutputResult(m_pHandle, &hResult));
		
		if (!hResult) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hResult)));
	}
	
	/**
	 * Method definitions for class CSinNode
	 */
	
	/**
	 * Method definitions for class CCosNode
	 */
	
	/**
	 * Method definitions for class CTanNode
	 */
	
	/**
	 * Method definitions for class CArcSinNode
	 */
	
	/**
	 * Method definitions for class CArcCosNode
	 */
	
	/**
	 * Method definitions for class CArcTanNode
	 */
	
	/**
	 * Method definitions for class CSinhNode
	 */
	
	/**
	 * Method definitions for class CCoshNode
	 */
	
	/**
	 * Method definitions for class CTanhNode
	 */
	
	/**
	 * Method definitions for class CRoundNode
	 */
	
	/**
	 * Method definitions for class CCeilNode
	 */
	
	/**
	 * Method definitions for class CFloorNode
	 */
	
	/**
	 * Method definitions for class CSignNode
	 */
	
	/**
	 * Method definitions for class CFractNode
	 */
	
	/**
	 * Method definitions for class CAbsNode
	 */
	
	/**
	 * Method definitions for class CExpNode
	 */
	
	/**
	 * Method definitions for class CLogNode
	 */
	
	/**
	 * Method definitions for class CLog2Node
	 */
	
	/**
	 * Method definitions for class CLog10Node
	 */
	
	/**
	 * Method definitions for class CLengthNode
	 */
	
	/**
	 * Method definitions for class CTransposeNode
	 */
	
	/**
	 * Method definitions for class CInverseNode
	 */
	
	/**
	 * Method definitions for class CSqrtNode
	 */
	
	/**
	 * Method definitions for class CResourceIdNode
	 */
	
	/**
	* CResourceIdNode::SetResource - Sets the Resource that the resourceid attribute of the node will point to
	* @param[in] pResource - the resource
	*/
	void CResourceIdNode::SetResource(classParam<CResource> pResource)
	{
		Lib3MFHandle hResource = pResource.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceIdNode_SetResource(m_pHandle, hResource));
	}
	
	/**
	* CResourceIdNode::GetResource - Retrieves the resource of the node
	* @return the resource
	*/
	PResource CResourceIdNode::GetResource()
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceIdNode_GetResource(m_pHandle, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CResource>(dynamic_cast<CResource*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	* CResourceIdNode::GetOutputValue - Retrieves the output
	* @return the output
	*/
	PImplicitPort CResourceIdNode::GetOutputValue()
	{
		Lib3MFHandle hValue = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceIdNode_GetOutputValue(m_pHandle, &hValue));
		
		if (!hValue) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hValue)));
	}
	
	/**
	 * Method definitions for class CTwoInputNode
	 */
	
	/**
	* CTwoInputNode::GetInputB - Retrieves the second input
	* @return the second input
	*/
	PImplicitPort CTwoInputNode::GetInputB()
	{
		Lib3MFHandle hB = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_TwoInputNode_GetInputB(m_pHandle, &hB));
		
		if (!hB) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hB)));
	}
	
	/**
	 * Method definitions for class CAdditionNode
	 */
	
	/**
	 * Method definitions for class CSubtractionNode
	 */
	
	/**
	 * Method definitions for class CMultiplicationNode
	 */
	
	/**
	 * Method definitions for class CDivisionNode
	 */
	
	/**
	 * Method definitions for class CDotNode
	 */
	
	/**
	 * Method definitions for class CCrossNode
	 */
	
	/**
	 * Method definitions for class CArcTan2Node
	 */
	
	/**
	 * Method definitions for class CMatVecMultiplicationNode
	 */
	
	/**
	 * Method definitions for class CMinNode
	 */
	
	/**
	 * Method definitions for class CMaxNode
	 */
	
	/**
	 * Method definitions for class CFmodNode
	 */
	
	/**
	 * Method definitions for class CModNode
	 */
	
	/**
	 * Method definitions for class CPowNode
	 */
	
	/**
	 * Method definitions for class CSelectNode
	 */
	
	/**
	* CSelectNode::GetInputB - Retrieves the second input
	* @return the second input
	*/
	PImplicitPort CSelectNode::GetInputB()
	{
		Lib3MFHandle hB = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_SelectNode_GetInputB(m_pHandle, &hB));
		
		if (!hB) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hB)));
	}
	
	/**
	* CSelectNode::GetInputC - Retrieves the third input
	* @return the third input
	*/
	PImplicitPort CSelectNode::GetInputC()
	{
		Lib3MFHandle hC = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_SelectNode_GetInputC(m_pHandle, &hC));
		
		if (!hC) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hC)));
	}
	
	/**
	* CSelectNode::GetInputD - Retrieves the fourth input
	* @return the fourth input
	*/
	PImplicitPort CSelectNode::GetInputD()
	{
		Lib3MFHandle hD = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_SelectNode_GetInputD(m_pHandle, &hD));
		
		if (!hD) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hD)));
	}
	
	/**
	 * Method definitions for class CClampNode
	 */
	
	/**
	* CClampNode::GetInputMin - Retrieves the input for the lower limit
	* @return the input for the lower limit
	*/
	PImplicitPort CClampNode::GetInputMin()
	{
		Lib3MFHandle hMin = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ClampNode_GetInputMin(m_pHandle, &hMin));
		
		if (!hMin) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hMin)));
	}
	
	/**
	* CClampNode::GetInputMax - Retrieves the input for the upper limit
	* @return the input for the upper limit
	*/
	PImplicitPort CClampNode::GetInputMax()
	{
		Lib3MFHandle hMax = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ClampNode_GetInputMax(m_pHandle, &hMax));
		
		if (!hMax) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hMax)));
	}
	
	/**
	 * Method definitions for class CComposeVectorNode
	 */
	
	/**
	* CComposeVectorNode::GetInputX - Retrieves the input for the x component
	* @return the input for the x component
	*/
	PImplicitPort CComposeVectorNode::GetInputX()
	{
		Lib3MFHandle hX = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeVectorNode_GetInputX(m_pHandle, &hX));
		
		if (!hX) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hX)));
	}
	
	/**
	* CComposeVectorNode::GetInputY - Retrieves the input for the y component
	* @return the input for the y component
	*/
	PImplicitPort CComposeVectorNode::GetInputY()
	{
		Lib3MFHandle hY = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeVectorNode_GetInputY(m_pHandle, &hY));
		
		if (!hY) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hY)));
	}
	
	/**
	* CComposeVectorNode::GetInputZ - Retrieves the input for the z component
	* @return the input for the z component
	*/
	PImplicitPort CComposeVectorNode::GetInputZ()
	{
		Lib3MFHandle hZ = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeVectorNode_GetInputZ(m_pHandle, &hZ));
		
		if (!hZ) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hZ)));
	}
	
	/**
	* CComposeVectorNode::GetOutputResult - Retrieves the output
	* @return the output
	*/
	PImplicitPort CComposeVectorNode::GetOutputResult()
	{
		Lib3MFHandle hResult = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeVectorNode_GetOutputResult(m_pHandle, &hResult));
		
		if (!hResult) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hResult)));
	}
	
	/**
	 * Method definitions for class CVectorFromScalarNode
	 */
	
	/**
	 * Method definitions for class CDecomposeVectorNode
	 */
	
	/**
	* CDecomposeVectorNode::GetInputA - Retrieves the input
	* @return the input port for the vector to decompose
	*/
	PImplicitPort CDecomposeVectorNode::GetInputA()
	{
		Lib3MFHandle hA = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_DecomposeVectorNode_GetInputA(m_pHandle, &hA));
		
		if (!hA) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hA)));
	}
	
	/**
	* CDecomposeVectorNode::GetOutputX - Retrieves the output for the x component
	* @return the output for the x component
	*/
	PImplicitPort CDecomposeVectorNode::GetOutputX()
	{
		Lib3MFHandle hX = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_DecomposeVectorNode_GetOutputX(m_pHandle, &hX));
		
		if (!hX) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hX)));
	}
	
	/**
	* CDecomposeVectorNode::GetOutputY - Retrieves the output for the y component
	* @return the output for the y component
	*/
	PImplicitPort CDecomposeVectorNode::GetOutputY()
	{
		Lib3MFHandle hY = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_DecomposeVectorNode_GetOutputY(m_pHandle, &hY));
		
		if (!hY) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hY)));
	}
	
	/**
	* CDecomposeVectorNode::GetOutputZ - Retrieves the output for the z component
	* @return the output for the z component
	*/
	PImplicitPort CDecomposeVectorNode::GetOutputZ()
	{
		Lib3MFHandle hZ = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_DecomposeVectorNode_GetOutputZ(m_pHandle, &hZ));
		
		if (!hZ) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hZ)));
	}
	
	/**
	 * Method definitions for class CComposeMatrixNode
	 */
	
	/**
	* CComposeMatrixNode::GetInputM00 - Retrieves the input for the element 0 0
	* @return the input for the m00 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM00()
	{
		Lib3MFHandle hM00 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM00(m_pHandle, &hM00));
		
		if (!hM00) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM00)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM01 - Retrieves the input for the element 0 1
	* @return the input for the m01 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM01()
	{
		Lib3MFHandle hM01 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM01(m_pHandle, &hM01));
		
		if (!hM01) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM01)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM02 - Retrieves the input for the element 0 2
	* @return the input for the m02 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM02()
	{
		Lib3MFHandle hM02 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM02(m_pHandle, &hM02));
		
		if (!hM02) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM02)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM03 - Retrieves the input for the element 0 3
	* @return the input for the m03 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM03()
	{
		Lib3MFHandle hM03 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM03(m_pHandle, &hM03));
		
		if (!hM03) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM03)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM10 - Retrieves the input for the element 1 0
	* @return the input for the m10 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM10()
	{
		Lib3MFHandle hM10 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM10(m_pHandle, &hM10));
		
		if (!hM10) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM10)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM11 - Retrieves the input for the element 1 1
	* @return the input for the m11 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM11()
	{
		Lib3MFHandle hM11 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM11(m_pHandle, &hM11));
		
		if (!hM11) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM11)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM12 - Retrieves the input for the element 1 2
	* @return the input for the m12 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM12()
	{
		Lib3MFHandle hM12 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM12(m_pHandle, &hM12));
		
		if (!hM12) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM12)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM13 - Retrieves the input for the element 1 3
	* @return the input for the m13 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM13()
	{
		Lib3MFHandle hM13 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM13(m_pHandle, &hM13));
		
		if (!hM13) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM13)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM20 - Retrieves the input for the element 2 0
	* @return the input for the m20 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM20()
	{
		Lib3MFHandle hM20 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM20(m_pHandle, &hM20));
		
		if (!hM20) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM20)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM21 - Retrieves the input for the element 2 1
	* @return 
	*/
	PImplicitPort CComposeMatrixNode::GetInputM21()
	{
		Lib3MFHandle hM21 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM21(m_pHandle, &hM21));
		
		if (!hM21) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM21)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM22 - Retrieves the input for the element 2 2
	* @return the input for the m22 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM22()
	{
		Lib3MFHandle hM22 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM22(m_pHandle, &hM22));
		
		if (!hM22) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM22)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM23 - Retrieves the input for the element 2 3
	* @return the input for the m23 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM23()
	{
		Lib3MFHandle hM23 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM23(m_pHandle, &hM23));
		
		if (!hM23) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM23)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM30 - Retrieves the input for the element 3 0
	* @return the input for the m30 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM30()
	{
		Lib3MFHandle hM30 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM30(m_pHandle, &hM30));
		
		if (!hM30) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM30)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM31 - Retrieves the input for the element 3 1
	* @return the input for the m31 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM31()
	{
		Lib3MFHandle hM31 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM31(m_pHandle, &hM31));
		
		if (!hM31) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM31)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM32 - Retrieves the input for the element 3 2
	* @return the input for the m32 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM32()
	{
		Lib3MFHandle hM32 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM32(m_pHandle, &hM32));
		
		if (!hM32) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM32)));
	}
	
	/**
	* CComposeMatrixNode::GetInputM33 - Retrieves the input for the element 3 3
	* @return the input for the m33 element
	*/
	PImplicitPort CComposeMatrixNode::GetInputM33()
	{
		Lib3MFHandle hM33 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetInputM33(m_pHandle, &hM33));
		
		if (!hM33) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hM33)));
	}
	
	/**
	* CComposeMatrixNode::GetOutputResult - Retrieves the output
	* @return the output
	*/
	PImplicitPort CComposeMatrixNode::GetOutputResult()
	{
		Lib3MFHandle hResult = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ComposeMatrixNode_GetOutputResult(m_pHandle, &hResult));
		
		if (!hResult) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hResult)));
	}
	
	/**
	 * Method definitions for class CMatrixFromRowsNode
	 */
	
	/**
	* CMatrixFromRowsNode::GetInputA - Retrieves the input for the first row
	* @return the input for the first row
	*/
	PImplicitPort CMatrixFromRowsNode::GetInputA()
	{
		Lib3MFHandle hRow0 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MatrixFromRowsNode_GetInputA(m_pHandle, &hRow0));
		
		if (!hRow0) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hRow0)));
	}
	
	/**
	* CMatrixFromRowsNode::GetInputB - Retrieves the input for the second row
	* @return the input for the second row
	*/
	PImplicitPort CMatrixFromRowsNode::GetInputB()
	{
		Lib3MFHandle hRow1 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MatrixFromRowsNode_GetInputB(m_pHandle, &hRow1));
		
		if (!hRow1) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hRow1)));
	}
	
	/**
	* CMatrixFromRowsNode::GetInputC - Retrieves the input for the third row
	* @return the input for the third row
	*/
	PImplicitPort CMatrixFromRowsNode::GetInputC()
	{
		Lib3MFHandle hRow2 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MatrixFromRowsNode_GetInputC(m_pHandle, &hRow2));
		
		if (!hRow2) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hRow2)));
	}
	
	/**
	* CMatrixFromRowsNode::GetInputD - Retrieves the input for the fourth row
	* @return the input for the fourth row
	*/
	PImplicitPort CMatrixFromRowsNode::GetInputD()
	{
		Lib3MFHandle hRow3 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MatrixFromRowsNode_GetInputD(m_pHandle, &hRow3));
		
		if (!hRow3) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hRow3)));
	}
	
	/**
	* CMatrixFromRowsNode::GetOutputResult - Retrieves the output
	* @return the output
	*/
	PImplicitPort CMatrixFromRowsNode::GetOutputResult()
	{
		Lib3MFHandle hResult = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MatrixFromRowsNode_GetOutputResult(m_pHandle, &hResult));
		
		if (!hResult) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hResult)));
	}
	
	/**
	 * Method definitions for class CMatrixFromColumnsNode
	 */
	
	/**
	* CMatrixFromColumnsNode::GetInputA - Retrieves the input for the first column
	* @return the input for the first column
	*/
	PImplicitPort CMatrixFromColumnsNode::GetInputA()
	{
		Lib3MFHandle hColumn0 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MatrixFromColumnsNode_GetInputA(m_pHandle, &hColumn0));
		
		if (!hColumn0) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hColumn0)));
	}
	
	/**
	* CMatrixFromColumnsNode::GetInputB - Retrieves the input for the second column
	* @return the input for the second column
	*/
	PImplicitPort CMatrixFromColumnsNode::GetInputB()
	{
		Lib3MFHandle hColumn1 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MatrixFromColumnsNode_GetInputB(m_pHandle, &hColumn1));
		
		if (!hColumn1) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hColumn1)));
	}
	
	/**
	* CMatrixFromColumnsNode::GetInputC - Retrieves the input for the third column
	* @return the input for the third column
	*/
	PImplicitPort CMatrixFromColumnsNode::GetInputC()
	{
		Lib3MFHandle hColumn2 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MatrixFromColumnsNode_GetInputC(m_pHandle, &hColumn2));
		
		if (!hColumn2) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hColumn2)));
	}
	
	/**
	* CMatrixFromColumnsNode::GetInputD - Retrieves the input for the fourth column
	* @return the input for the fourth column
	*/
	PImplicitPort CMatrixFromColumnsNode::GetInputD()
	{
		Lib3MFHandle hColumn3 = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MatrixFromColumnsNode_GetInputD(m_pHandle, &hColumn3));
		
		if (!hColumn3) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hColumn3)));
	}
	
	/**
	* CMatrixFromColumnsNode::GetOutputResult - Retrieves the output
	* @return the output
	*/
	PImplicitPort CMatrixFromColumnsNode::GetOutputResult()
	{
		Lib3MFHandle hResult = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MatrixFromColumnsNode_GetOutputResult(m_pHandle, &hResult));
		
		if (!hResult) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hResult)));
	}
	
	/**
	 * Method definitions for class CConstantNode
	 */
	
	/**
	* CConstantNode::SetConstant - Sets the constant value of the node
	* @param[in] dValue - the value
	*/
	void CConstantNode::SetConstant(const Lib3MF_double dValue)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ConstantNode_SetConstant(m_pHandle, dValue));
	}
	
	/**
	* CConstantNode::GetConstant - Retrieves the constant value of the node
	* @return the value
	*/
	Lib3MF_double CConstantNode::GetConstant()
	{
		Lib3MF_double resultValue = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ConstantNode_GetConstant(m_pHandle, &resultValue));
		
		return resultValue;
	}
	
	/**
	* CConstantNode::GetOutputValue - Retrieves the output
	* @return the output
	*/
	PImplicitPort CConstantNode::GetOutputValue()
	{
		Lib3MFHandle hValue = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ConstantNode_GetOutputValue(m_pHandle, &hValue));
		
		if (!hValue) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hValue)));
	}
	
	/**
	 * Method definitions for class CConstVecNode
	 */
	
	/**
	* CConstVecNode::SetVector - Sets the vector value of the node
	* @param[in] Value - the value
	*/
	void CConstVecNode::SetVector(const sVector & Value)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ConstVecNode_SetVector(m_pHandle, &Value));
	}
	
	/**
	* CConstVecNode::GetVector - Retrieves the vector value of the node
	* @return the value
	*/
	sVector CConstVecNode::GetVector()
	{
		sVector resultValue;
		CheckError(m_pWrapper->m_WrapperTable.m_ConstVecNode_GetVector(m_pHandle, &resultValue));
		
		return resultValue;
	}
	
	/**
	* CConstVecNode::GetOutputVector - Retrieves the output
	* @return the output
	*/
	PImplicitPort CConstVecNode::GetOutputVector()
	{
		Lib3MFHandle hVector = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ConstVecNode_GetOutputVector(m_pHandle, &hVector));
		
		if (!hVector) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hVector)));
	}
	
	/**
	 * Method definitions for class CConstMatNode
	 */
	
	/**
	* CConstMatNode::SetMatrix - Sets the matrix value of the node
	* @param[in] Value - the value
	*/
	void CConstMatNode::SetMatrix(const sMatrix4x4 & Value)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ConstMatNode_SetMatrix(m_pHandle, &Value));
	}
	
	/**
	* CConstMatNode::GetMatrix - Retrieves the matrix value of the node
	* @return the matrix
	*/
	sMatrix4x4 CConstMatNode::GetMatrix()
	{
		sMatrix4x4 resultValue;
		CheckError(m_pWrapper->m_WrapperTable.m_ConstMatNode_GetMatrix(m_pHandle, &resultValue));
		
		return resultValue;
	}
	
	/**
	* CConstMatNode::GetOutputMatrix - Retrieves the output
	* @return the output
	*/
	PImplicitPort CConstMatNode::GetOutputMatrix()
	{
		Lib3MFHandle hMatrix = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ConstMatNode_GetOutputMatrix(m_pHandle, &hMatrix));
		
		if (!hMatrix) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hMatrix)));
	}
	
	/**
	 * Method definitions for class CMeshNode
	 */
	
	/**
	* CMeshNode::GetInputMesh - Retrieves the input for the model resource id of the mesh
	* @return the input port for the model resource id of the mesh
	*/
	PImplicitPort CMeshNode::GetInputMesh()
	{
		Lib3MFHandle hMesh = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshNode_GetInputMesh(m_pHandle, &hMesh));
		
		if (!hMesh) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hMesh)));
	}
	
	/**
	* CMeshNode::GetInputPos - Retrieves the input for the position
	* @return the input port for the position
	*/
	PImplicitPort CMeshNode::GetInputPos()
	{
		Lib3MFHandle hPos = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshNode_GetInputPos(m_pHandle, &hPos));
		
		if (!hPos) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hPos)));
	}
	
	/**
	* CMeshNode::GetOutputDistance - Retrieves the output
	* @return the output port for the signed distance to the mesh
	*/
	PImplicitPort CMeshNode::GetOutputDistance()
	{
		Lib3MFHandle hDistance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_MeshNode_GetOutputDistance(m_pHandle, &hDistance));
		
		if (!hDistance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hDistance)));
	}
	
	/**
	 * Method definitions for class CUnsignedMeshNode
	 */
	
	/**
	* CUnsignedMeshNode::GetInputMesh - Retrieves the input for the model resource id of the mesh
	* @return the input port for the model resource id of the mesh
	*/
	PImplicitPort CUnsignedMeshNode::GetInputMesh()
	{
		Lib3MFHandle hMesh = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_UnsignedMeshNode_GetInputMesh(m_pHandle, &hMesh));
		
		if (!hMesh) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hMesh)));
	}
	
	/**
	* CUnsignedMeshNode::GetInputPos - Retrieves the input for the position
	* @return the input port for the position
	*/
	PImplicitPort CUnsignedMeshNode::GetInputPos()
	{
		Lib3MFHandle hPos = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_UnsignedMeshNode_GetInputPos(m_pHandle, &hPos));
		
		if (!hPos) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hPos)));
	}
	
	/**
	* CUnsignedMeshNode::GetOutputDistance - Retrieves the output
	* @return the output port for the unsigned distance to the mesh
	*/
	PImplicitPort CUnsignedMeshNode::GetOutputDistance()
	{
		Lib3MFHandle hDistance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_UnsignedMeshNode_GetOutputDistance(m_pHandle, &hDistance));
		
		if (!hDistance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hDistance)));
	}
	
	/**
	 * Method definitions for class CBeamLatticeNode
	 */
	
	/**
	* CBeamLatticeNode::GetInputBeamLattice - Retrieves the input for the model resource id of the beam lattice
	* @return the input port for the model resource id of the beam lattice (mesh with beamlattice extension)
	*/
	PImplicitPort CBeamLatticeNode::GetInputBeamLattice()
	{
		Lib3MFHandle hBeamLattice = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLatticeNode_GetInputBeamLattice(m_pHandle, &hBeamLattice));
		
		if (!hBeamLattice) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hBeamLattice)));
	}
	
	/**
	* CBeamLatticeNode::GetInputPos - Retrieves the input for the position
	* @return the input port for the position
	*/
	PImplicitPort CBeamLatticeNode::GetInputPos()
	{
		Lib3MFHandle hPos = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLatticeNode_GetInputPos(m_pHandle, &hPos));
		
		if (!hPos) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hPos)));
	}
	
	/**
	* CBeamLatticeNode::GetOutputDistance - Retrieves the output
	* @return the output port for the signed distance to the beam lattice
	*/
	PImplicitPort CBeamLatticeNode::GetOutputDistance()
	{
		Lib3MFHandle hDistance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLatticeNode_GetOutputDistance(m_pHandle, &hDistance));
		
		if (!hDistance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hDistance)));
	}
	
	/**
	* CBeamLatticeNode::SetAccurateRange - Sets the accurate range for distance computation
	* @param[in] dAccurateRange - the accurate range in model units
	*/
	void CBeamLatticeNode::SetAccurateRange(const Lib3MF_double dAccurateRange)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLatticeNode_SetAccurateRange(m_pHandle, dAccurateRange));
	}
	
	/**
	* CBeamLatticeNode::GetAccurateRange - Retrieves the accurate range for distance computation
	* @return the accurate range in model units
	*/
	Lib3MF_double CBeamLatticeNode::GetAccurateRange()
	{
		Lib3MF_double resultAccurateRange = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BeamLatticeNode_GetAccurateRange(m_pHandle, &resultAccurateRange));
		
		return resultAccurateRange;
	}
	
	/**
	 * Method definitions for class CFunctionGradientNode
	 */
	
	/**
	* CFunctionGradientNode::GetInputFunctionID - Retrieves the input for the function id
	* @return the input port for the function
	*/
	PImplicitPort CFunctionGradientNode::GetInputFunctionID()
	{
		Lib3MFHandle hFunction = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_GetInputFunctionID(m_pHandle, &hFunction));
		
		if (!hFunction) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hFunction)));
	}
	
	/**
	* CFunctionGradientNode::GetInputPos - Retrieves the input for the position
	* @return the input port for the position
	*/
	PImplicitPort CFunctionGradientNode::GetInputPos()
	{
		Lib3MFHandle hPos = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_GetInputPos(m_pHandle, &hPos));
		
		if (!hPos) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hPos)));
	}
	
	/**
	* CFunctionGradientNode::GetInputStep - Retrieves the input for the finite difference step
	* @return the input port for the finite difference step
	*/
	PImplicitPort CFunctionGradientNode::GetInputStep()
	{
		Lib3MFHandle hStep = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_GetInputStep(m_pHandle, &hStep));
		
		if (!hStep) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hStep)));
	}
	
	/**
	* CFunctionGradientNode::SetScalarOutputName - Sets the name of the referenced scalar output
	* @param[in] sScalarOutputName - the name of the scalar output of the referenced function
	*/
	void CFunctionGradientNode::SetScalarOutputName(const std::string & sScalarOutputName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_SetScalarOutputName(m_pHandle, sScalarOutputName.c_str()));
	}
	
	/**
	* CFunctionGradientNode::GetScalarOutputName - Retrieves the name of the referenced scalar output
	* @return the name of the scalar output of the referenced function
	*/
	std::string CFunctionGradientNode::GetScalarOutputName()
	{
		Lib3MF_uint32 bytesNeededScalarOutputName = 0;
		Lib3MF_uint32 bytesWrittenScalarOutputName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_GetScalarOutputName(m_pHandle, 0, &bytesNeededScalarOutputName, nullptr));
		std::vector<char> bufferScalarOutputName(bytesNeededScalarOutputName);
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_GetScalarOutputName(m_pHandle, bytesNeededScalarOutputName, &bytesWrittenScalarOutputName, &bufferScalarOutputName[0]));
		
		return std::string(&bufferScalarOutputName[0]);
	}
	
	/**
	* CFunctionGradientNode::SetVectorInputName - Sets the name of the referenced vector input
	* @param[in] sVectorInputName - the name of the vector input (float3) of the referenced function
	*/
	void CFunctionGradientNode::SetVectorInputName(const std::string & sVectorInputName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_SetVectorInputName(m_pHandle, sVectorInputName.c_str()));
	}
	
	/**
	* CFunctionGradientNode::GetVectorInputName - Retrieves the name of the referenced vector input
	* @return the name of the vector input (float3) of the referenced function
	*/
	std::string CFunctionGradientNode::GetVectorInputName()
	{
		Lib3MF_uint32 bytesNeededVectorInputName = 0;
		Lib3MF_uint32 bytesWrittenVectorInputName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_GetVectorInputName(m_pHandle, 0, &bytesNeededVectorInputName, nullptr));
		std::vector<char> bufferVectorInputName(bytesNeededVectorInputName);
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_GetVectorInputName(m_pHandle, bytesNeededVectorInputName, &bytesWrittenVectorInputName, &bufferVectorInputName[0]));
		
		return std::string(&bufferVectorInputName[0]);
	}
	
	/**
	* CFunctionGradientNode::GetOutputNormalizedGradient - Retrieves the normalized gradient output
	* @return the output port for the normalized gradient
	*/
	PImplicitPort CFunctionGradientNode::GetOutputNormalizedGradient()
	{
		Lib3MFHandle hNormalizedGradient = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_GetOutputNormalizedGradient(m_pHandle, &hNormalizedGradient));
		
		if (!hNormalizedGradient) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hNormalizedGradient)));
	}
	
	/**
	* CFunctionGradientNode::GetOutputGradient - Retrieves the raw gradient output
	* @return the output port for the raw gradient
	*/
	PImplicitPort CFunctionGradientNode::GetOutputGradient()
	{
		Lib3MFHandle hGradient = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_GetOutputGradient(m_pHandle, &hGradient));
		
		if (!hGradient) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hGradient)));
	}
	
	/**
	* CFunctionGradientNode::GetOutputMagnitude - Retrieves the gradient magnitude output
	* @return the output port for the gradient magnitude
	*/
	PImplicitPort CFunctionGradientNode::GetOutputMagnitude()
	{
		Lib3MFHandle hMagnitude = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionGradientNode_GetOutputMagnitude(m_pHandle, &hMagnitude));
		
		if (!hMagnitude) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hMagnitude)));
	}
	
	/**
	 * Method definitions for class CNormalizeDistanceNode
	 */
	
	/**
	* CNormalizeDistanceNode::GetInputFunctionID - Retrieves the input for the function id
	* @return the input port for the function
	*/
	PImplicitPort CNormalizeDistanceNode::GetInputFunctionID()
	{
		Lib3MFHandle hFunction = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_NormalizeDistanceNode_GetInputFunctionID(m_pHandle, &hFunction));
		
		if (!hFunction) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hFunction)));
	}
	
	/**
	* CNormalizeDistanceNode::GetInputPos - Retrieves the input for the position
	* @return the input port for the position (vector)
	*/
	PImplicitPort CNormalizeDistanceNode::GetInputPos()
	{
		Lib3MFHandle hPos = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_NormalizeDistanceNode_GetInputPos(m_pHandle, &hPos));
		
		if (!hPos) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hPos)));
	}
	
	/**
	* CNormalizeDistanceNode::GetInputStep - Retrieves the input for the finite difference step
	* @return the input port for the finite difference step
	*/
	PImplicitPort CNormalizeDistanceNode::GetInputStep()
	{
		Lib3MFHandle hStep = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_NormalizeDistanceNode_GetInputStep(m_pHandle, &hStep));
		
		if (!hStep) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hStep)));
	}
	
	/**
	* CNormalizeDistanceNode::SetScalarOutputName - Sets the name of the referenced scalar output
	* @param[in] sScalarOutputName - the name of the scalar output of the referenced function
	*/
	void CNormalizeDistanceNode::SetScalarOutputName(const std::string & sScalarOutputName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_NormalizeDistanceNode_SetScalarOutputName(m_pHandle, sScalarOutputName.c_str()));
	}
	
	/**
	* CNormalizeDistanceNode::GetScalarOutputName - Retrieves the name of the referenced scalar output
	* @return the name of the scalar output of the referenced function
	*/
	std::string CNormalizeDistanceNode::GetScalarOutputName()
	{
		Lib3MF_uint32 bytesNeededScalarOutputName = 0;
		Lib3MF_uint32 bytesWrittenScalarOutputName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_NormalizeDistanceNode_GetScalarOutputName(m_pHandle, 0, &bytesNeededScalarOutputName, nullptr));
		std::vector<char> bufferScalarOutputName(bytesNeededScalarOutputName);
		CheckError(m_pWrapper->m_WrapperTable.m_NormalizeDistanceNode_GetScalarOutputName(m_pHandle, bytesNeededScalarOutputName, &bytesWrittenScalarOutputName, &bufferScalarOutputName[0]));
		
		return std::string(&bufferScalarOutputName[0]);
	}
	
	/**
	* CNormalizeDistanceNode::SetVectorInputName - Sets the name of the referenced vector input
	* @param[in] sVectorInputName - the name of the vector input (float3) of the referenced function
	*/
	void CNormalizeDistanceNode::SetVectorInputName(const std::string & sVectorInputName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_NormalizeDistanceNode_SetVectorInputName(m_pHandle, sVectorInputName.c_str()));
	}
	
	/**
	* CNormalizeDistanceNode::GetVectorInputName - Retrieves the name of the referenced vector input
	* @return the name of the vector input (float3) of the referenced function
	*/
	std::string CNormalizeDistanceNode::GetVectorInputName()
	{
		Lib3MF_uint32 bytesNeededVectorInputName = 0;
		Lib3MF_uint32 bytesWrittenVectorInputName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_NormalizeDistanceNode_GetVectorInputName(m_pHandle, 0, &bytesNeededVectorInputName, nullptr));
		std::vector<char> bufferVectorInputName(bytesNeededVectorInputName);
		CheckError(m_pWrapper->m_WrapperTable.m_NormalizeDistanceNode_GetVectorInputName(m_pHandle, bytesNeededVectorInputName, &bytesWrittenVectorInputName, &bufferVectorInputName[0]));
		
		return std::string(&bufferVectorInputName[0]);
	}
	
	/**
	* CNormalizeDistanceNode::GetOutputResult - Retrieves the normalized result output
	* @return the output port for the normalized distance
	*/
	PImplicitPort CNormalizeDistanceNode::GetOutputResult()
	{
		Lib3MFHandle hResult = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_NormalizeDistanceNode_GetOutputResult(m_pHandle, &hResult));
		
		if (!hResult) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hResult)));
	}
	
	/**
	 * Method definitions for class CFunctionCallNode
	 */
	
	/**
	* CFunctionCallNode::GetInputFunctionID - Retrieves the input for the function id
	* @return the input port for the function
	*/
	PImplicitPort CFunctionCallNode::GetInputFunctionID()
	{
		Lib3MFHandle hFunction = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionCallNode_GetInputFunctionID(m_pHandle, &hFunction));
		
		if (!hFunction) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hFunction)));
	}
	
	/**
	 * Method definitions for class CNodeIterator
	 */
	
	/**
	* CNodeIterator::GetCurrent - Returns the current element
	* @return The current element
	*/
	PImplicitNode CNodeIterator::GetCurrent()
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_NodeIterator_GetCurrent(m_pHandle, &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitNode>(dynamic_cast<CImplicitNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	 * Method definitions for class CFunction
	 */
	
	/**
	* CFunction::GetDisplayName - Retrieves the display name of the function
	* @return the display name
	*/
	std::string CFunction::GetDisplayName()
	{
		Lib3MF_uint32 bytesNeededDisplayName = 0;
		Lib3MF_uint32 bytesWrittenDisplayName = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Function_GetDisplayName(m_pHandle, 0, &bytesNeededDisplayName, nullptr));
		std::vector<char> bufferDisplayName(bytesNeededDisplayName);
		CheckError(m_pWrapper->m_WrapperTable.m_Function_GetDisplayName(m_pHandle, bytesNeededDisplayName, &bytesWrittenDisplayName, &bufferDisplayName[0]));
		
		return std::string(&bufferDisplayName[0]);
	}
	
	/**
	* CFunction::SetDisplayName - Sets the display name of the function
	* @param[in] sDisplayName - the display name
	*/
	void CFunction::SetDisplayName(const std::string & sDisplayName)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Function_SetDisplayName(m_pHandle, sDisplayName.c_str()));
	}
	
	/**
	* CFunction::AddInput - Add an input
	* @param[in] sIdentifier - the identifier of the input
	* @param[in] sDisplayName - the display name of the input
	* @param[in] eType - the type of the input
	* @return The added input port
	*/
	PImplicitPort CFunction::AddInput(const std::string & sIdentifier, const std::string & sDisplayName, const eImplicitPortType eType)
	{
		Lib3MFHandle hPort = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Function_AddInput(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), eType, &hPort));
		
		if (!hPort) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hPort)));
	}
	
	/**
	* CFunction::GetInputs - Retrieves the inputs
	* @return iterator for the list of inputs
	*/
	PImplicitPortIterator CFunction::GetInputs()
	{
		Lib3MFHandle hIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Function_GetInputs(m_pHandle, &hIterator));
		
		if (!hIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPortIterator>(dynamic_cast<CImplicitPortIterator*>(m_pWrapper->polymorphicFactory(hIterator)));
	}
	
	/**
	* CFunction::RemoveInput - Removes an input
	* @param[in] pInput - The input to be removed
	*/
	void CFunction::RemoveInput(classParam<CImplicitPort> pInput)
	{
		Lib3MFHandle hInput = pInput.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_Function_RemoveInput(m_pHandle, hInput));
	}
	
	/**
	* CFunction::AddOutput - Add an output
	* @param[in] sIdentifier - the identifier of the output
	* @param[in] sDisplayName - the display name of the output
	* @param[in] eType - the type of the input
	* @return The added input port
	*/
	PImplicitPort CFunction::AddOutput(const std::string & sIdentifier, const std::string & sDisplayName, const eImplicitPortType eType)
	{
		Lib3MFHandle hPort = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Function_AddOutput(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), eType, &hPort));
		
		if (!hPort) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hPort)));
	}
	
	/**
	* CFunction::GetOutputs - Retrieves the outputs
	* @return iterator for the outputs
	*/
	PImplicitPortIterator CFunction::GetOutputs()
	{
		Lib3MFHandle hIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Function_GetOutputs(m_pHandle, &hIterator));
		
		if (!hIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPortIterator>(dynamic_cast<CImplicitPortIterator*>(m_pWrapper->polymorphicFactory(hIterator)));
	}
	
	/**
	* CFunction::RemoveOutput - Removes an output
	* @param[in] pOutput - The output to be removed
	*/
	void CFunction::RemoveOutput(classParam<CImplicitPort> pOutput)
	{
		Lib3MFHandle hOutput = pOutput.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_Function_RemoveOutput(m_pHandle, hOutput));
	}
	
	/**
	* CFunction::FindInput - Retrieves an input
	* @param[in] sIdentifier - the identifier of the input
	* @return the input port
	*/
	PImplicitPort CFunction::FindInput(const std::string & sIdentifier)
	{
		Lib3MFHandle hInput = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Function_FindInput(m_pHandle, sIdentifier.c_str(), &hInput));
		
		if (!hInput) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hInput)));
	}
	
	/**
	* CFunction::FindOutput - Retrieves an output
	* @param[in] sIdentifier - the identifier of the output
	* @return the output port
	*/
	PImplicitPort CFunction::FindOutput(const std::string & sIdentifier)
	{
		Lib3MFHandle hOutput = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Function_FindOutput(m_pHandle, sIdentifier.c_str(), &hOutput));
		
		if (!hOutput) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitPort>(dynamic_cast<CImplicitPort*>(m_pWrapper->polymorphicFactory(hOutput)));
	}
	
	/**
	 * Method definitions for class CImplicitFunction
	 */
	
	/**
	* CImplicitFunction::GetIdentifier - Retrieves the identifier of the function
	* @return the identifier
	*/
	std::string CImplicitFunction::GetIdentifier()
	{
		Lib3MF_uint32 bytesNeededIdentifier = 0;
		Lib3MF_uint32 bytesWrittenIdentifier = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_GetIdentifier(m_pHandle, 0, &bytesNeededIdentifier, nullptr));
		std::vector<char> bufferIdentifier(bytesNeededIdentifier);
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_GetIdentifier(m_pHandle, bytesNeededIdentifier, &bytesWrittenIdentifier, &bufferIdentifier[0]));
		
		return std::string(&bufferIdentifier[0]);
	}
	
	/**
	* CImplicitFunction::SetIdentifier - Sets the identifier of the function
	* @param[in] sIdentifier - the identifier
	*/
	void CImplicitFunction::SetIdentifier(const std::string & sIdentifier)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_SetIdentifier(m_pHandle, sIdentifier.c_str()));
	}
	
	/**
	* CImplicitFunction::AddNode - Add a node
	* @param[in] eNodeType - the type of the node
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PImplicitNode CImplicitFunction::AddNode(const eImplicitNodeType eNodeType, const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddNode(m_pHandle, eNodeType, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImplicitNode>(dynamic_cast<CImplicitNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddSinNode - Add a SinNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PSinNode CImplicitFunction::AddSinNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddSinNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSinNode>(dynamic_cast<CSinNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddCosNode - Add a CosNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PCosNode CImplicitFunction::AddCosNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddCosNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CCosNode>(dynamic_cast<CCosNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddTanNode - Add a TanNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PTanNode CImplicitFunction::AddTanNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddTanNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTanNode>(dynamic_cast<CTanNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddArcSinNode - Add a ArcSinNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PArcSinNode CImplicitFunction::AddArcSinNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddArcSinNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CArcSinNode>(dynamic_cast<CArcSinNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddArcCosNode - Add a ArcCosNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PArcCosNode CImplicitFunction::AddArcCosNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddArcCosNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CArcCosNode>(dynamic_cast<CArcCosNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddArcTan2Node - Add a ArcTan2Node
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PArcTan2Node CImplicitFunction::AddArcTan2Node(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddArcTan2Node(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CArcTan2Node>(dynamic_cast<CArcTan2Node*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddSinhNode - Add a SinhNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PSinhNode CImplicitFunction::AddSinhNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddSinhNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSinhNode>(dynamic_cast<CSinhNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddCoshNode - Add a CoshNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PCoshNode CImplicitFunction::AddCoshNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddCoshNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CCoshNode>(dynamic_cast<CCoshNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddTanhNode - Add a TanhNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PTanhNode CImplicitFunction::AddTanhNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddTanhNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTanhNode>(dynamic_cast<CTanhNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddRoundNode - Add a RoundNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PRoundNode CImplicitFunction::AddRoundNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddRoundNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CRoundNode>(dynamic_cast<CRoundNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddCeilNode - Add a CeilNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PCeilNode CImplicitFunction::AddCeilNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddCeilNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CCeilNode>(dynamic_cast<CCeilNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddFloorNode - Add a FloorNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PFloorNode CImplicitFunction::AddFloorNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddFloorNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CFloorNode>(dynamic_cast<CFloorNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddSignNode - Add a SignNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PSignNode CImplicitFunction::AddSignNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddSignNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSignNode>(dynamic_cast<CSignNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddFractNode - Add a FractNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PFractNode CImplicitFunction::AddFractNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddFractNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CFractNode>(dynamic_cast<CFractNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddAbsNode - Add a AbsNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PAbsNode CImplicitFunction::AddAbsNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddAbsNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CAbsNode>(dynamic_cast<CAbsNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddExpNode - Add a ExpNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PExpNode CImplicitFunction::AddExpNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddExpNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CExpNode>(dynamic_cast<CExpNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddLogNode - Add a LogNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PLogNode CImplicitFunction::AddLogNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddLogNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CLogNode>(dynamic_cast<CLogNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddLog2Node - Add a Log2Node
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PLog2Node CImplicitFunction::AddLog2Node(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddLog2Node(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CLog2Node>(dynamic_cast<CLog2Node*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddLog10Node - Add a Log10Node
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PLog10Node CImplicitFunction::AddLog10Node(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddLog10Node(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CLog10Node>(dynamic_cast<CLog10Node*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddLengthNode - Add a LengthNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PLengthNode CImplicitFunction::AddLengthNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddLengthNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CLengthNode>(dynamic_cast<CLengthNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddTransposeNode - Add a TransposeNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PTransposeNode CImplicitFunction::AddTransposeNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddTransposeNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTransposeNode>(dynamic_cast<CTransposeNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddInverseNode - Add a InverseNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PInverseNode CImplicitFunction::AddInverseNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddInverseNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CInverseNode>(dynamic_cast<CInverseNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddSqrtNode - Add a SqrtNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PSqrtNode CImplicitFunction::AddSqrtNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddSqrtNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSqrtNode>(dynamic_cast<CSqrtNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddResourceIdNode - Add a ResourceIdNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PResourceIdNode CImplicitFunction::AddResourceIdNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddResourceIdNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CResourceIdNode>(dynamic_cast<CResourceIdNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddAdditionNode - Add an AdditionNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PAdditionNode CImplicitFunction::AddAdditionNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddAdditionNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CAdditionNode>(dynamic_cast<CAdditionNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddSubtractionNode - Add a SubtractionNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PSubtractionNode CImplicitFunction::AddSubtractionNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddSubtractionNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSubtractionNode>(dynamic_cast<CSubtractionNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddMultiplicationNode - Add a MultiplicationNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PMultiplicationNode CImplicitFunction::AddMultiplicationNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddMultiplicationNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMultiplicationNode>(dynamic_cast<CMultiplicationNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddDivisionNode - Add a DivisionNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PDivisionNode CImplicitFunction::AddDivisionNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddDivisionNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CDivisionNode>(dynamic_cast<CDivisionNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddDotNode - Add a DotNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PDotNode CImplicitFunction::AddDotNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddDotNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CDotNode>(dynamic_cast<CDotNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddCrossNode - Add a CrossNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PCrossNode CImplicitFunction::AddCrossNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddCrossNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CCrossNode>(dynamic_cast<CCrossNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddMatVecMultiplicationNode - Add a MatVecMultiplicationNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PMatVecMultiplicationNode CImplicitFunction::AddMatVecMultiplicationNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddMatVecMultiplicationNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMatVecMultiplicationNode>(dynamic_cast<CMatVecMultiplicationNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddMinNode - Add a MinNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PMinNode CImplicitFunction::AddMinNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddMinNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMinNode>(dynamic_cast<CMinNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddMaxNode - Add a MaxNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PMaxNode CImplicitFunction::AddMaxNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddMaxNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMaxNode>(dynamic_cast<CMaxNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddFmodNode - Add a FmodNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PFmodNode CImplicitFunction::AddFmodNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddFmodNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CFmodNode>(dynamic_cast<CFmodNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddPowNode - Add a PowNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PPowNode CImplicitFunction::AddPowNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddPowNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CPowNode>(dynamic_cast<CPowNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddSelectNode - Add a SelectNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PSelectNode CImplicitFunction::AddSelectNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddSelectNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSelectNode>(dynamic_cast<CSelectNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddClampNode - Add a ClampNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] eConfiguration - the configuration of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PClampNode CImplicitFunction::AddClampNode(const std::string & sIdentifier, const eImplicitNodeConfiguration eConfiguration, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddClampNode(m_pHandle, sIdentifier.c_str(), eConfiguration, sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CClampNode>(dynamic_cast<CClampNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddComposeVectorNode - Add a ComposeVectorNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PComposeVectorNode CImplicitFunction::AddComposeVectorNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddComposeVectorNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CComposeVectorNode>(dynamic_cast<CComposeVectorNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddVectorFromScalarNode - Add a VectorFromScalar
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PVectorFromScalarNode CImplicitFunction::AddVectorFromScalarNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddVectorFromScalarNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CVectorFromScalarNode>(dynamic_cast<CVectorFromScalarNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddDecomposeVectorNode - Add a DecomposeVectorNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PDecomposeVectorNode CImplicitFunction::AddDecomposeVectorNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddDecomposeVectorNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CDecomposeVectorNode>(dynamic_cast<CDecomposeVectorNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddComposeMatrixNode - Add a ComposeMatrixNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PComposeMatrixNode CImplicitFunction::AddComposeMatrixNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddComposeMatrixNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CComposeMatrixNode>(dynamic_cast<CComposeMatrixNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddMatrixFromRowsNode - Add a MatrixFromRowsNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PMatrixFromRowsNode CImplicitFunction::AddMatrixFromRowsNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddMatrixFromRowsNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMatrixFromRowsNode>(dynamic_cast<CMatrixFromRowsNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddMatrixFromColumnsNode - Add a MatrixFromColumnsNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PMatrixFromColumnsNode CImplicitFunction::AddMatrixFromColumnsNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddMatrixFromColumnsNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMatrixFromColumnsNode>(dynamic_cast<CMatrixFromColumnsNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddConstantNode - Add a ConstantNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PConstantNode CImplicitFunction::AddConstantNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddConstantNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CConstantNode>(dynamic_cast<CConstantNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddConstVecNode - Add a ConstVecNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PConstVecNode CImplicitFunction::AddConstVecNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddConstVecNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CConstVecNode>(dynamic_cast<CConstVecNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddConstMatNode - Add a ConstMatNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PConstMatNode CImplicitFunction::AddConstMatNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddConstMatNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CConstMatNode>(dynamic_cast<CConstMatNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddMeshNode - Add a MeshNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PMeshNode CImplicitFunction::AddMeshNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddMeshNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMeshNode>(dynamic_cast<CMeshNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddUnsignedMeshNode - Add a UnsignedMeshNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PUnsignedMeshNode CImplicitFunction::AddUnsignedMeshNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddUnsignedMeshNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CUnsignedMeshNode>(dynamic_cast<CUnsignedMeshNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddBeamLatticeNode - Add a BeamLatticeNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PBeamLatticeNode CImplicitFunction::AddBeamLatticeNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddBeamLatticeNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBeamLatticeNode>(dynamic_cast<CBeamLatticeNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddFunctionGradientNode - Add a FunctionGradientNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PFunctionGradientNode CImplicitFunction::AddFunctionGradientNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddFunctionGradientNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CFunctionGradientNode>(dynamic_cast<CFunctionGradientNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddNormalizeDistanceNode - Add a NormalizeDistanceNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PNormalizeDistanceNode CImplicitFunction::AddNormalizeDistanceNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddNormalizeDistanceNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CNormalizeDistanceNode>(dynamic_cast<CNormalizeDistanceNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::AddFunctionCallNode - Add a FunctionCallNode
	* @param[in] sIdentifier - the identifier of the node
	* @param[in] sDisplayName - the display name of the node
	* @param[in] sTag - the tag of the node
	* @return the added node
	*/
	PFunctionCallNode CImplicitFunction::AddFunctionCallNode(const std::string & sIdentifier, const std::string & sDisplayName, const std::string & sTag)
	{
		Lib3MFHandle hNode = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddFunctionCallNode(m_pHandle, sIdentifier.c_str(), sDisplayName.c_str(), sTag.c_str(), &hNode));
		
		if (!hNode) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CFunctionCallNode>(dynamic_cast<CFunctionCallNode*>(m_pWrapper->polymorphicFactory(hNode)));
	}
	
	/**
	* CImplicitFunction::GetNodes - Retrieves the nodes
	* @return iterator for the list of nodes
	*/
	PNodeIterator CImplicitFunction::GetNodes()
	{
		Lib3MFHandle hIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_GetNodes(m_pHandle, &hIterator));
		
		if (!hIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CNodeIterator>(dynamic_cast<CNodeIterator*>(m_pWrapper->polymorphicFactory(hIterator)));
	}
	
	/**
	* CImplicitFunction::RemoveNode - Removes a node
	* @param[in] pNode - The node to be removed
	*/
	void CImplicitFunction::RemoveNode(classParam<CImplicitNode> pNode)
	{
		Lib3MFHandle hNode = pNode.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_RemoveNode(m_pHandle, hNode));
	}
	
	/**
	* CImplicitFunction::AddLink - Add a link
	* @param[in] pSource - the source port
	* @param[in] pTarget - the target port
	*/
	void CImplicitFunction::AddLink(classParam<CImplicitPort> pSource, classParam<CImplicitPort> pTarget)
	{
		Lib3MFHandle hSource = pSource.GetHandle();
		Lib3MFHandle hTarget = pTarget.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddLink(m_pHandle, hSource, hTarget));
	}
	
	/**
	* CImplicitFunction::AddLinkByNames - Add a link
	* @param[in] sSource - name of the source port in the format nodename.portname
	* @param[in] sTarget - name of the target port in the format nodename.portname
	*/
	void CImplicitFunction::AddLinkByNames(const std::string & sSource, const std::string & sTarget)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_AddLinkByNames(m_pHandle, sSource.c_str(), sTarget.c_str()));
	}
	
	/**
	* CImplicitFunction::Clear - Clears the function
	*/
	void CImplicitFunction::Clear()
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_Clear(m_pHandle));
	}
	
	/**
	* CImplicitFunction::SortNodesTopologically - Sorts the nodes topologically
	*/
	void CImplicitFunction::SortNodesTopologically()
	{
		CheckError(m_pWrapper->m_WrapperTable.m_ImplicitFunction_SortNodesTopologically(m_pHandle));
	}
	
	/**
	 * Method definitions for class CFunctionFromImage3D
	 */
	
	/**
	* CFunctionFromImage3D::GetImage3D - Returns the selected 3D image.
	* @return image instance
	*/
	PImage3D CFunctionFromImage3D::GetImage3D()
	{
		Lib3MFHandle hImage3D = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionFromImage3D_GetImage3D(m_pHandle, &hImage3D));
		
		if (!hImage3D) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CImage3D>(dynamic_cast<CImage3D*>(m_pWrapper->polymorphicFactory(hImage3D)));
	}
	
	/**
	* CFunctionFromImage3D::SetImage3D - Sets the 3D image of the selector.
	* @param[in] pImage3D - image instance
	*/
	void CFunctionFromImage3D::SetImage3D(classParam<CImage3D> pImage3D)
	{
		Lib3MFHandle hImage3D = pImage3D.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionFromImage3D_SetImage3D(m_pHandle, hImage3D));
	}
	
	/**
	* CFunctionFromImage3D::SetFilter - Sets the texture filter of the selector.
	* @param[in] eFilter - texture filter
	*/
	void CFunctionFromImage3D::SetFilter(const eTextureFilter eFilter)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionFromImage3D_SetFilter(m_pHandle, eFilter));
	}
	
	/**
	* CFunctionFromImage3D::GetFilter - Returns the texture filter of the selector.
	* @return texture filter
	*/
	eTextureFilter CFunctionFromImage3D::GetFilter()
	{
		eTextureFilter resultFilter = (eTextureFilter) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionFromImage3D_GetFilter(m_pHandle, &resultFilter));
		
		return resultFilter;
	}
	
	/**
	* CFunctionFromImage3D::SetTileStyles - Sets the tile styles of the selector.
	* @param[in] eTileStyleU - tile style in U
	* @param[in] eTileStyleV - tile style in V
	* @param[in] eTileStyleW - tile style in W
	*/
	void CFunctionFromImage3D::SetTileStyles(const eTextureTileStyle eTileStyleU, const eTextureTileStyle eTileStyleV, const eTextureTileStyle eTileStyleW)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionFromImage3D_SetTileStyles(m_pHandle, eTileStyleU, eTileStyleV, eTileStyleW));
	}
	
	/**
	* CFunctionFromImage3D::GetTileStyles - Retrieves the tile styles of the selector.
	* @param[out] eTileStyleU - tile style in U
	* @param[out] eTileStyleV - tile style in V
	* @param[out] eTileStyleW - tile style in W
	*/
	void CFunctionFromImage3D::GetTileStyles(eTextureTileStyle & eTileStyleU, eTextureTileStyle & eTileStyleV, eTextureTileStyle & eTileStyleW)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionFromImage3D_GetTileStyles(m_pHandle, &eTileStyleU, &eTileStyleV, &eTileStyleW));
	}
	
	/**
	* CFunctionFromImage3D::GetOffset - returns the offset value for the pixel values in the Image3D
	* @return the offset value for the pixel values in the Image3D
	*/
	Lib3MF_double CFunctionFromImage3D::GetOffset()
	{
		Lib3MF_double resultOffset = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionFromImage3D_GetOffset(m_pHandle, &resultOffset));
		
		return resultOffset;
	}
	
	/**
	* CFunctionFromImage3D::SetOffset - Sets the offset value for the pixel values in the Image3D
	* @param[in] dOffset - the offset value for the pixel values in the Image3D
	*/
	void CFunctionFromImage3D::SetOffset(const Lib3MF_double dOffset)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionFromImage3D_SetOffset(m_pHandle, dOffset));
	}
	
	/**
	* CFunctionFromImage3D::GetScale - returns the scale value for the pixel values in the Image3D
	* @return the scale value for the pixel values in the Image3D
	*/
	Lib3MF_double CFunctionFromImage3D::GetScale()
	{
		Lib3MF_double resultScale = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionFromImage3D_GetScale(m_pHandle, &resultScale));
		
		return resultScale;
	}
	
	/**
	* CFunctionFromImage3D::SetScale - Sets the scale value for the pixel values in the Image3D
	* @param[in] dScale - the scale value for the pixel values in the Image3D
	*/
	void CFunctionFromImage3D::SetScale(const Lib3MF_double dScale)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_FunctionFromImage3D_SetScale(m_pHandle, dScale));
	}
	
	/**
	 * Method definitions for class CBuildItem
	 */
	
	/**
	* CBuildItem::GetObjectResource - Retrieves the object resource associated to a build item
	* @return returns the associated resource instance
	*/
	PObject CBuildItem::GetObjectResource()
	{
		Lib3MFHandle hObjectResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_GetObjectResource(m_pHandle, &hObjectResource));
		
		if (!hObjectResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CObject>(dynamic_cast<CObject*>(m_pWrapper->polymorphicFactory(hObjectResource)));
	}
	
	/**
	* CBuildItem::GetUUID - returns, whether a build item has a UUID and, if true, the build item's UUID
	* @param[out] bHasUUID - flag whether the build item has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	std::string CBuildItem::GetUUID(bool & bHasUUID)
	{
		Lib3MF_uint32 bytesNeededUUID = 0;
		Lib3MF_uint32 bytesWrittenUUID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_GetUUID(m_pHandle, &bHasUUID, 0, &bytesNeededUUID, nullptr));
		std::vector<char> bufferUUID(bytesNeededUUID);
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_GetUUID(m_pHandle, &bHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]));
		
		return std::string(&bufferUUID[0]);
	}
	
	/**
	* CBuildItem::SetUUID - sets the build item's UUID
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	void CBuildItem::SetUUID(const std::string & sUUID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_SetUUID(m_pHandle, sUUID.c_str()));
	}
	
	/**
	* CBuildItem::GetObjectResourceID - Retrieves the object UniqueResourceID associated to a build item
	* @return returns the UniqueResourceID of the object
	*/
	Lib3MF_uint32 CBuildItem::GetObjectResourceID()
	{
		Lib3MF_uint32 resultUniqueResourceID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_GetObjectResourceID(m_pHandle, &resultUniqueResourceID));
		
		return resultUniqueResourceID;
	}
	
	/**
	* CBuildItem::HasObjectTransform - Checks, if a build item has a non-identity transformation matrix
	* @return returns true, if the transformation matrix is not the identity
	*/
	bool CBuildItem::HasObjectTransform()
	{
		bool resultHasTransform = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_HasObjectTransform(m_pHandle, &resultHasTransform));
		
		return resultHasTransform;
	}
	
	/**
	* CBuildItem::GetObjectTransform - Retrieves a build item's transformation matrix.
	* @return returns the transformation matrix
	*/
	sTransform CBuildItem::GetObjectTransform()
	{
		sTransform resultTransform;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_GetObjectTransform(m_pHandle, &resultTransform));
		
		return resultTransform;
	}
	
	/**
	* CBuildItem::SetObjectTransform - Sets a build item's transformation matrix.
	* @param[in] Transform - new transformation matrix
	*/
	void CBuildItem::SetObjectTransform(const sTransform & Transform)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_SetObjectTransform(m_pHandle, &Transform));
	}
	
	/**
	* CBuildItem::GetPartNumber - Retrieves a build item's part number string
	* @return Returns a build item's part number string
	*/
	std::string CBuildItem::GetPartNumber()
	{
		Lib3MF_uint32 bytesNeededPartNumber = 0;
		Lib3MF_uint32 bytesWrittenPartNumber = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_GetPartNumber(m_pHandle, 0, &bytesNeededPartNumber, nullptr));
		std::vector<char> bufferPartNumber(bytesNeededPartNumber);
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_GetPartNumber(m_pHandle, bytesNeededPartNumber, &bytesWrittenPartNumber, &bufferPartNumber[0]));
		
		return std::string(&bufferPartNumber[0]);
	}
	
	/**
	* CBuildItem::SetPartNumber - Sets a build item's part number string
	* @param[in] sSetPartnumber - new part number string for referencing parts from the outside world
	*/
	void CBuildItem::SetPartNumber(const std::string & sSetPartnumber)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_SetPartNumber(m_pHandle, sSetPartnumber.c_str()));
	}
	
	/**
	* CBuildItem::GetMetaDataGroup - Returns the metadatagroup of this build item
	* @return returns an Instance of the metadatagroup of this build item
	*/
	PMetaDataGroup CBuildItem::GetMetaDataGroup()
	{
		Lib3MFHandle hMetaDataGroup = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_GetMetaDataGroup(m_pHandle, &hMetaDataGroup));
		
		if (!hMetaDataGroup) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMetaDataGroup>(dynamic_cast<CMetaDataGroup*>(m_pWrapper->polymorphicFactory(hMetaDataGroup)));
	}
	
	/**
	* CBuildItem::GetOutbox - Returns the outbox of a build item
	* @return Outbox of this build item
	*/
	sBox CBuildItem::GetOutbox()
	{
		sBox resultOutbox;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItem_GetOutbox(m_pHandle, &resultOutbox));
		
		return resultOutbox;
	}
	
	/**
	 * Method definitions for class CBuildItemIterator
	 */
	
	/**
	* CBuildItemIterator::MoveNext - Iterates to the next build item in the list.
	* @return Iterates to the next build item in the list.
	*/
	bool CBuildItemIterator::MoveNext()
	{
		bool resultHasNext = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItemIterator_MoveNext(m_pHandle, &resultHasNext));
		
		return resultHasNext;
	}
	
	/**
	* CBuildItemIterator::MovePrevious - Iterates to the previous build item in the list.
	* @return Iterates to the previous build item in the list.
	*/
	bool CBuildItemIterator::MovePrevious()
	{
		bool resultHasPrevious = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItemIterator_MovePrevious(m_pHandle, &resultHasPrevious));
		
		return resultHasPrevious;
	}
	
	/**
	* CBuildItemIterator::GetCurrent - Returns the build item the iterator points at.
	* @return returns the build item instance.
	*/
	PBuildItem CBuildItemIterator::GetCurrent()
	{
		Lib3MFHandle hBuildItem = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItemIterator_GetCurrent(m_pHandle, &hBuildItem));
		
		if (!hBuildItem) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBuildItem>(dynamic_cast<CBuildItem*>(m_pWrapper->polymorphicFactory(hBuildItem)));
	}
	
	/**
	* CBuildItemIterator::Clone - Creates a new build item iterator with the same build item list.
	* @return returns the cloned Iterator instance
	*/
	PBuildItemIterator CBuildItemIterator::Clone()
	{
		Lib3MFHandle hOutBuildItemIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItemIterator_Clone(m_pHandle, &hOutBuildItemIterator));
		
		if (!hOutBuildItemIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBuildItemIterator>(dynamic_cast<CBuildItemIterator*>(m_pWrapper->polymorphicFactory(hOutBuildItemIterator)));
	}
	
	/**
	* CBuildItemIterator::Count - Returns the number of build items the iterator captures.
	* @return returns the number of build items the iterator captures.
	*/
	Lib3MF_uint64 CBuildItemIterator::Count()
	{
		Lib3MF_uint64 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_BuildItemIterator_Count(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	 * Method definitions for class CSlice
	 */
	
	/**
	* CSlice::SetVertices - Set all vertices of a slice. All polygons will be cleared.
	* @param[in] VerticesBuffer - contains the positions.
	*/
	void CSlice::SetVertices(const CInputVector<sPosition2D> & VerticesBuffer)
	{
		Lib3MF_uint64 nVerticesSize = VerticesBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_Slice_SetVertices(m_pHandle, nVerticesSize, VerticesBuffer.data()));
	}
	
	/**
	* CSlice::GetVertices - Get all vertices of a slice
	* @param[out] VerticesBuffer - contains the positions.
	*/
	void CSlice::GetVertices(std::vector<sPosition2D> & VerticesBuffer)
	{
		Lib3MF_uint64 elementsNeededVertices = 0;
		Lib3MF_uint64 elementsWrittenVertices = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Slice_GetVertices(m_pHandle, 0, &elementsNeededVertices, nullptr));
		VerticesBuffer.resize((size_t) elementsNeededVertices);
		CheckError(m_pWrapper->m_WrapperTable.m_Slice_GetVertices(m_pHandle, elementsNeededVertices, &elementsWrittenVertices, VerticesBuffer.data()));
	}
	
	/**
	* CSlice::GetVertexCount - Get the number of vertices in a slice
	* @return the number of vertices in the slice
	*/
	Lib3MF_uint64 CSlice::GetVertexCount()
	{
		Lib3MF_uint64 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Slice_GetVertexCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CSlice::AddPolygon - Add a new polygon to this slice
	* @param[in] IndicesBuffer - the new indices of the new polygon
	* @return the index of the new polygon
	*/
	Lib3MF_uint64 CSlice::AddPolygon(const CInputVector<Lib3MF_uint32> & IndicesBuffer)
	{
		Lib3MF_uint64 nIndicesSize = IndicesBuffer.size();
		Lib3MF_uint64 resultIndex = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Slice_AddPolygon(m_pHandle, nIndicesSize, IndicesBuffer.data(), &resultIndex));
		
		return resultIndex;
	}
	
	/**
	* CSlice::GetPolygonCount - Get the number of polygons in the slice
	* @return the number of polygons in the slice
	*/
	Lib3MF_uint64 CSlice::GetPolygonCount()
	{
		Lib3MF_uint64 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Slice_GetPolygonCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CSlice::SetPolygonIndices - Set all indices of a polygon
	* @param[in] nIndex - the index of the polygon to manipulate
	* @param[in] IndicesBuffer - the new indices of the index-th polygon
	*/
	void CSlice::SetPolygonIndices(const Lib3MF_uint64 nIndex, const CInputVector<Lib3MF_uint32> & IndicesBuffer)
	{
		Lib3MF_uint64 nIndicesSize = IndicesBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_Slice_SetPolygonIndices(m_pHandle, nIndex, nIndicesSize, IndicesBuffer.data()));
	}
	
	/**
	* CSlice::GetPolygonIndices - Get all vertices of a slice
	* @param[in] nIndex - the index of the polygon to manipulate
	* @param[out] IndicesBuffer - the indices of the index-th polygon 
	*/
	void CSlice::GetPolygonIndices(const Lib3MF_uint64 nIndex, std::vector<Lib3MF_uint32> & IndicesBuffer)
	{
		Lib3MF_uint64 elementsNeededIndices = 0;
		Lib3MF_uint64 elementsWrittenIndices = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Slice_GetPolygonIndices(m_pHandle, nIndex, 0, &elementsNeededIndices, nullptr));
		IndicesBuffer.resize((size_t) elementsNeededIndices);
		CheckError(m_pWrapper->m_WrapperTable.m_Slice_GetPolygonIndices(m_pHandle, nIndex, elementsNeededIndices, &elementsWrittenIndices, IndicesBuffer.data()));
	}
	
	/**
	* CSlice::GetPolygonIndexCount - Get the number of vertices in a slice
	* @param[in] nIndex - the index of the polygon to manipulate
	* @return the number of indices of the index-th polygon
	*/
	Lib3MF_uint64 CSlice::GetPolygonIndexCount(const Lib3MF_uint64 nIndex)
	{
		Lib3MF_uint64 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Slice_GetPolygonIndexCount(m_pHandle, nIndex, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CSlice::GetZTop - Get the upper Z-Coordinate of this slice.
	* @return the upper Z-Coordinate of this slice
	*/
	Lib3MF_double CSlice::GetZTop()
	{
		Lib3MF_double resultZTop = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Slice_GetZTop(m_pHandle, &resultZTop));
		
		return resultZTop;
	}
	
	/**
	 * Method definitions for class CSliceStack
	 */
	
	/**
	* CSliceStack::GetBottomZ - Get the lower Z-Coordinate of the slice stack.
	* @return the lower Z-Coordinate the slice stack
	*/
	Lib3MF_double CSliceStack::GetBottomZ()
	{
		Lib3MF_double resultZBottom = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStack_GetBottomZ(m_pHandle, &resultZBottom));
		
		return resultZBottom;
	}
	
	/**
	* CSliceStack::GetSliceCount - Returns the number of slices
	* @return the number of slices
	*/
	Lib3MF_uint64 CSliceStack::GetSliceCount()
	{
		Lib3MF_uint64 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStack_GetSliceCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CSliceStack::GetSlice - Query a slice from the slice stack
	* @param[in] nSliceIndex - the index of the slice
	* @return the Slice instance
	*/
	PSlice CSliceStack::GetSlice(const Lib3MF_uint64 nSliceIndex)
	{
		Lib3MFHandle hTheSlice = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStack_GetSlice(m_pHandle, nSliceIndex, &hTheSlice));
		
		if (!hTheSlice) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSlice>(dynamic_cast<CSlice*>(m_pWrapper->polymorphicFactory(hTheSlice)));
	}
	
	/**
	* CSliceStack::AddSlice - Returns the number of slices
	* @param[in] dZTop - upper Z coordinate of the slice
	* @return a new Slice instance
	*/
	PSlice CSliceStack::AddSlice(const Lib3MF_double dZTop)
	{
		Lib3MFHandle hTheSlice = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStack_AddSlice(m_pHandle, dZTop, &hTheSlice));
		
		if (!hTheSlice) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSlice>(dynamic_cast<CSlice*>(m_pWrapper->polymorphicFactory(hTheSlice)));
	}
	
	/**
	* CSliceStack::GetSliceRefCount - Returns the number of slice refs
	* @return the number of slicereferences
	*/
	Lib3MF_uint64 CSliceStack::GetSliceRefCount()
	{
		Lib3MF_uint64 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStack_GetSliceRefCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CSliceStack::AddSliceStackReference - Adds another existing slicestack as sliceref in this slicestack
	* @param[in] pTheSliceStack - the slicestack to use as sliceref
	*/
	void CSliceStack::AddSliceStackReference(classParam<CSliceStack> pTheSliceStack)
	{
		Lib3MFHandle hTheSliceStack = pTheSliceStack.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStack_AddSliceStackReference(m_pHandle, hTheSliceStack));
	}
	
	/**
	* CSliceStack::GetSliceStackReference - Adds another existing slicestack as sliceref in this slicestack
	* @param[in] nSliceRefIndex - the index of the slice ref
	* @return the slicestack that is used as sliceref
	*/
	PSliceStack CSliceStack::GetSliceStackReference(const Lib3MF_uint64 nSliceRefIndex)
	{
		Lib3MFHandle hTheSliceStack = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStack_GetSliceStackReference(m_pHandle, nSliceRefIndex, &hTheSliceStack));
		
		if (!hTheSliceStack) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSliceStack>(dynamic_cast<CSliceStack*>(m_pWrapper->polymorphicFactory(hTheSliceStack)));
	}
	
	/**
	* CSliceStack::CollapseSliceReferences - Removes the indirection of slices via slice-refs, i.e. creates the slices of all slice refs of this SliceStack as actual slices of this SliceStack. All previously existing slices or slicerefs will be removed.
	*/
	void CSliceStack::CollapseSliceReferences()
	{
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStack_CollapseSliceReferences(m_pHandle));
	}
	
	/**
	* CSliceStack::SetOwnPath - Sets the package path where this Slice should be stored. Input an empty string to reset the path
	* @param[in] sPath - the package path where this Slice should be stored
	*/
	void CSliceStack::SetOwnPath(const std::string & sPath)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStack_SetOwnPath(m_pHandle, sPath.c_str()));
	}
	
	/**
	* CSliceStack::GetOwnPath - Obtains the package path where this Slice should be stored. Returns an empty string if the slicestack is stored within the root model.
	* @return the package path where this Slice will be stored
	*/
	std::string CSliceStack::GetOwnPath()
	{
		Lib3MF_uint32 bytesNeededPath = 0;
		Lib3MF_uint32 bytesWrittenPath = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStack_GetOwnPath(m_pHandle, 0, &bytesNeededPath, nullptr));
		std::vector<char> bufferPath(bytesNeededPath);
		CheckError(m_pWrapper->m_WrapperTable.m_SliceStack_GetOwnPath(m_pHandle, bytesNeededPath, &bytesWrittenPath, &bufferPath[0]));
		
		return std::string(&bufferPath[0]);
	}
	
	/**
	 * Method definitions for class CConsumer
	 */
	
	/**
	* CConsumer::GetConsumerID - Gets the consumerid
	* @return A unique identifier for the consumers
	*/
	std::string CConsumer::GetConsumerID()
	{
		Lib3MF_uint32 bytesNeededConsumerID = 0;
		Lib3MF_uint32 bytesWrittenConsumerID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Consumer_GetConsumerID(m_pHandle, 0, &bytesNeededConsumerID, nullptr));
		std::vector<char> bufferConsumerID(bytesNeededConsumerID);
		CheckError(m_pWrapper->m_WrapperTable.m_Consumer_GetConsumerID(m_pHandle, bytesNeededConsumerID, &bytesWrittenConsumerID, &bufferConsumerID[0]));
		
		return std::string(&bufferConsumerID[0]);
	}
	
	/**
	* CConsumer::GetKeyID - Getts the keyid
	* @return The identifier for the key of this consumer
	*/
	std::string CConsumer::GetKeyID()
	{
		Lib3MF_uint32 bytesNeededKeyID = 0;
		Lib3MF_uint32 bytesWrittenKeyID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Consumer_GetKeyID(m_pHandle, 0, &bytesNeededKeyID, nullptr));
		std::vector<char> bufferKeyID(bytesNeededKeyID);
		CheckError(m_pWrapper->m_WrapperTable.m_Consumer_GetKeyID(m_pHandle, bytesNeededKeyID, &bytesWrittenKeyID, &bufferKeyID[0]));
		
		return std::string(&bufferKeyID[0]);
	}
	
	/**
	* CConsumer::GetKeyValue - Gets the keyvalue associated with this consumer
	* @return The public key, when available, of this consumer
	*/
	std::string CConsumer::GetKeyValue()
	{
		Lib3MF_uint32 bytesNeededKeyValue = 0;
		Lib3MF_uint32 bytesWrittenKeyValue = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Consumer_GetKeyValue(m_pHandle, 0, &bytesNeededKeyValue, nullptr));
		std::vector<char> bufferKeyValue(bytesNeededKeyValue);
		CheckError(m_pWrapper->m_WrapperTable.m_Consumer_GetKeyValue(m_pHandle, bytesNeededKeyValue, &bytesWrittenKeyValue, &bufferKeyValue[0]));
		
		return std::string(&bufferKeyValue[0]);
	}
	
	/**
	 * Method definitions for class CAccessRight
	 */
	
	/**
	* CAccessRight::GetConsumer - Gets the consumer associated with this access right
	* @return The consumer instance
	*/
	PConsumer CAccessRight::GetConsumer()
	{
		Lib3MFHandle hConsumer = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_AccessRight_GetConsumer(m_pHandle, &hConsumer));
		
		if (!hConsumer) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CConsumer>(dynamic_cast<CConsumer*>(m_pWrapper->polymorphicFactory(hConsumer)));
	}
	
	/**
	* CAccessRight::GetWrappingAlgorithm - Gets the associated encryption algorithm
	* @return The algorithm used for the key in this accessright
	*/
	eWrappingAlgorithm CAccessRight::GetWrappingAlgorithm()
	{
		eWrappingAlgorithm resultAlgorithm = (eWrappingAlgorithm) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_AccessRight_GetWrappingAlgorithm(m_pHandle, &resultAlgorithm));
		
		return resultAlgorithm;
	}
	
	/**
	* CAccessRight::GetMgfAlgorithm - Gets the associated mask generation function algorithm
	* @return The MFG1 algorithm
	*/
	eMgfAlgorithm CAccessRight::GetMgfAlgorithm()
	{
		eMgfAlgorithm resultAlgorithm = (eMgfAlgorithm) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_AccessRight_GetMgfAlgorithm(m_pHandle, &resultAlgorithm));
		
		return resultAlgorithm;
	}
	
	/**
	* CAccessRight::GetDigestMethod - Gets the digest method assoicated
	* @return The digest method for this accessright
	*/
	eDigestMethod CAccessRight::GetDigestMethod()
	{
		eDigestMethod resultAlgorithm = (eDigestMethod) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_AccessRight_GetDigestMethod(m_pHandle, &resultAlgorithm));
		
		return resultAlgorithm;
	}
	
	/**
	 * Method definitions for class CContentEncryptionParams
	 */
	
	/**
	* CContentEncryptionParams::GetEncryptionAlgorithm - Returns the encryption method to be used in this encryption process
	* @return 
	*/
	eEncryptionAlgorithm CContentEncryptionParams::GetEncryptionAlgorithm()
	{
		eEncryptionAlgorithm resultAlgorithm = (eEncryptionAlgorithm) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetEncryptionAlgorithm(m_pHandle, &resultAlgorithm));
		
		return resultAlgorithm;
	}
	
	/**
	* CContentEncryptionParams::GetKey - Gets the key for the resource associated
	* @param[out] ByteDataBuffer - Pointer to a buffer where to place the key.
	*/
	void CContentEncryptionParams::GetKey(std::vector<Lib3MF_uint8> & ByteDataBuffer)
	{
		Lib3MF_uint64 elementsNeededByteData = 0;
		Lib3MF_uint64 elementsWrittenByteData = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetKey(m_pHandle, 0, &elementsNeededByteData, nullptr));
		ByteDataBuffer.resize((size_t) elementsNeededByteData);
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetKey(m_pHandle, elementsNeededByteData, &elementsWrittenByteData, ByteDataBuffer.data()));
	}
	
	/**
	* CContentEncryptionParams::GetInitializationVector - Gets the IV data
	* @param[out] ByteDataBuffer - Pointer to a buffer where to place the data.
	*/
	void CContentEncryptionParams::GetInitializationVector(std::vector<Lib3MF_uint8> & ByteDataBuffer)
	{
		Lib3MF_uint64 elementsNeededByteData = 0;
		Lib3MF_uint64 elementsWrittenByteData = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetInitializationVector(m_pHandle, 0, &elementsNeededByteData, nullptr));
		ByteDataBuffer.resize((size_t) elementsNeededByteData);
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetInitializationVector(m_pHandle, elementsNeededByteData, &elementsWrittenByteData, ByteDataBuffer.data()));
	}
	
	/**
	* CContentEncryptionParams::GetAuthenticationTag - A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	* @param[out] ByteDataBuffer - Pointer to a buffer where to place the data.
	*/
	void CContentEncryptionParams::GetAuthenticationTag(std::vector<Lib3MF_uint8> & ByteDataBuffer)
	{
		Lib3MF_uint64 elementsNeededByteData = 0;
		Lib3MF_uint64 elementsWrittenByteData = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetAuthenticationTag(m_pHandle, 0, &elementsNeededByteData, nullptr));
		ByteDataBuffer.resize((size_t) elementsNeededByteData);
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetAuthenticationTag(m_pHandle, elementsNeededByteData, &elementsWrittenByteData, ByteDataBuffer.data()));
	}
	
	/**
	* CContentEncryptionParams::SetAuthenticationTag - Sets the authentication tag
	* @param[in] ByteDataBuffer - The authentication tag size
	*/
	void CContentEncryptionParams::SetAuthenticationTag(const CInputVector<Lib3MF_uint8> & ByteDataBuffer)
	{
		Lib3MF_uint64 nByteDataSize = ByteDataBuffer.size();
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_SetAuthenticationTag(m_pHandle, nByteDataSize, ByteDataBuffer.data()));
	}
	
	/**
	* CContentEncryptionParams::GetAdditionalAuthenticationData - A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	* @param[out] ByteDataBuffer - Buffer where the data will be placed
	*/
	void CContentEncryptionParams::GetAdditionalAuthenticationData(std::vector<Lib3MF_uint8> & ByteDataBuffer)
	{
		Lib3MF_uint64 elementsNeededByteData = 0;
		Lib3MF_uint64 elementsWrittenByteData = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetAdditionalAuthenticationData(m_pHandle, 0, &elementsNeededByteData, nullptr));
		ByteDataBuffer.resize((size_t) elementsNeededByteData);
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetAdditionalAuthenticationData(m_pHandle, elementsNeededByteData, &elementsWrittenByteData, ByteDataBuffer.data()));
	}
	
	/**
	* CContentEncryptionParams::GetDescriptor - A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	* @return 
	*/
	Lib3MF_uint64 CContentEncryptionParams::GetDescriptor()
	{
		Lib3MF_uint64 resultDescriptor = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetDescriptor(m_pHandle, &resultDescriptor));
		
		return resultDescriptor;
	}
	
	/**
	* CContentEncryptionParams::GetKeyUUID - Gets the resourcedatagroup keyuuid
	* @return The resourcedatagroup keyuuid that may be use to reference an external key
	*/
	std::string CContentEncryptionParams::GetKeyUUID()
	{
		Lib3MF_uint32 bytesNeededUUID = 0;
		Lib3MF_uint32 bytesWrittenUUID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetKeyUUID(m_pHandle, 0, &bytesNeededUUID, nullptr));
		std::vector<char> bufferUUID(bytesNeededUUID);
		CheckError(m_pWrapper->m_WrapperTable.m_ContentEncryptionParams_GetKeyUUID(m_pHandle, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]));
		
		return std::string(&bufferUUID[0]);
	}
	
	/**
	 * Method definitions for class CResourceData
	 */
	
	/**
	* CResourceData::GetPath - Gets the encrypted part path
	* @return The part path
	*/
	PPackagePart CResourceData::GetPath()
	{
		Lib3MFHandle hPath = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceData_GetPath(m_pHandle, &hPath));
		
		if (!hPath) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CPackagePart>(dynamic_cast<CPackagePart*>(m_pWrapper->polymorphicFactory(hPath)));
	}
	
	/**
	* CResourceData::GetEncryptionAlgorithm - Gets the encryption algorithm used to encrypt this ResourceData
	* @return The encryption algorithm
	*/
	eEncryptionAlgorithm CResourceData::GetEncryptionAlgorithm()
	{
		eEncryptionAlgorithm resultEncryptionAlgorithm = (eEncryptionAlgorithm) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceData_GetEncryptionAlgorithm(m_pHandle, &resultEncryptionAlgorithm));
		
		return resultEncryptionAlgorithm;
	}
	
	/**
	* CResourceData::GetCompression - Tells whether this ResourceData is compressed or not
	* @return The compression method
	*/
	eCompression CResourceData::GetCompression()
	{
		eCompression resultCompression = (eCompression) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceData_GetCompression(m_pHandle, &resultCompression));
		
		return resultCompression;
	}
	
	/**
	* CResourceData::GetAdditionalAuthenticationData - Tells whether this ResourceData is compressed or not
	* @param[out] ByteDataBuffer - The compression method
	*/
	void CResourceData::GetAdditionalAuthenticationData(std::vector<Lib3MF_uint8> & ByteDataBuffer)
	{
		Lib3MF_uint64 elementsNeededByteData = 0;
		Lib3MF_uint64 elementsWrittenByteData = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceData_GetAdditionalAuthenticationData(m_pHandle, 0, &elementsNeededByteData, nullptr));
		ByteDataBuffer.resize((size_t) elementsNeededByteData);
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceData_GetAdditionalAuthenticationData(m_pHandle, elementsNeededByteData, &elementsWrittenByteData, ByteDataBuffer.data()));
	}
	
	/**
	 * Method definitions for class CResourceDataGroup
	 */
	
	/**
	* CResourceDataGroup::GetKeyUUID - Sets the resourcedatagroup keyuuid
	* @return The new resourcedatagroup keyuuid.
	*/
	std::string CResourceDataGroup::GetKeyUUID()
	{
		Lib3MF_uint32 bytesNeededUUID = 0;
		Lib3MF_uint32 bytesWrittenUUID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceDataGroup_GetKeyUUID(m_pHandle, 0, &bytesNeededUUID, nullptr));
		std::vector<char> bufferUUID(bytesNeededUUID);
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceDataGroup_GetKeyUUID(m_pHandle, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]));
		
		return std::string(&bufferUUID[0]);
	}
	
	/**
	* CResourceDataGroup::AddAccessRight - Add accessright to resourcedatagroup element
	* @param[in] pConsumer - The Consumer reference
	* @param[in] eWrappingAlgorithm - The key wrapping algorithm to be used
	* @param[in] eMgfAlgorithm - The mask generation function to be used
	* @param[in] eDigestMethod - The digest mechanism to be used
	* @return The acess right instance
	*/
	PAccessRight CResourceDataGroup::AddAccessRight(classParam<CConsumer> pConsumer, const eWrappingAlgorithm eWrappingAlgorithm, const eMgfAlgorithm eMgfAlgorithm, const eDigestMethod eDigestMethod)
	{
		Lib3MFHandle hConsumer = pConsumer.GetHandle();
		Lib3MFHandle hTheAccessRight = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceDataGroup_AddAccessRight(m_pHandle, hConsumer, eWrappingAlgorithm, eMgfAlgorithm, eDigestMethod, &hTheAccessRight));
		
		if (!hTheAccessRight) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CAccessRight>(dynamic_cast<CAccessRight*>(m_pWrapper->polymorphicFactory(hTheAccessRight)));
	}
	
	/**
	* CResourceDataGroup::FindAccessRightByConsumer - Finds the AccessRight associated with a Consumer
	* @param[in] pConsumer - The Consumer instance
	* @return The AcessRight instance
	*/
	PAccessRight CResourceDataGroup::FindAccessRightByConsumer(classParam<CConsumer> pConsumer)
	{
		Lib3MFHandle hConsumer = pConsumer.GetHandle();
		Lib3MFHandle hTheAccessRight = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceDataGroup_FindAccessRightByConsumer(m_pHandle, hConsumer, &hTheAccessRight));
		
		if (hTheAccessRight) {
			return std::shared_ptr<CAccessRight>(dynamic_cast<CAccessRight*>(m_pWrapper->polymorphicFactory(hTheAccessRight)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CResourceDataGroup::RemoveAccessRight - Removes access from a Consumer on this resource data group
	* @param[in] pConsumer - The Consumer instance
	*/
	void CResourceDataGroup::RemoveAccessRight(classParam<CConsumer> pConsumer)
	{
		Lib3MFHandle hConsumer = pConsumer.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_ResourceDataGroup_RemoveAccessRight(m_pHandle, hConsumer));
	}
	
	/**
	 * Method definitions for class CKeyStore
	 */
	
	/**
	* CKeyStore::AddConsumer - Adds a consumer to the keystore
	* @param[in] sConsumerID - A unique identifier for the consumer
	* @param[in] sKeyID - The id of the key of the consumer
	* @param[in] sKeyValue - The public key for this consumer in PEM format
	* @return The consumer instance
	*/
	PConsumer CKeyStore::AddConsumer(const std::string & sConsumerID, const std::string & sKeyID, const std::string & sKeyValue)
	{
		Lib3MFHandle hConsumer = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_AddConsumer(m_pHandle, sConsumerID.c_str(), sKeyID.c_str(), sKeyValue.c_str(), &hConsumer));
		
		if (!hConsumer) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CConsumer>(dynamic_cast<CConsumer*>(m_pWrapper->polymorphicFactory(hConsumer)));
	}
	
	/**
	* CKeyStore::GetConsumerCount - Gets the number of consumers in the keystore
	* @return The consumer count
	*/
	Lib3MF_uint64 CKeyStore::GetConsumerCount()
	{
		Lib3MF_uint64 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_GetConsumerCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CKeyStore::GetConsumer - Get a consumer from the keystore
	* @param[in] nConsumerIndex - The index of the consumer
	* @return The consumer instance
	*/
	PConsumer CKeyStore::GetConsumer(const Lib3MF_uint64 nConsumerIndex)
	{
		Lib3MFHandle hConsumer = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_GetConsumer(m_pHandle, nConsumerIndex, &hConsumer));
		
		if (!hConsumer) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CConsumer>(dynamic_cast<CConsumer*>(m_pWrapper->polymorphicFactory(hConsumer)));
	}
	
	/**
	* CKeyStore::RemoveConsumer - Removes a consumer from the keystore
	* @param[in] pConsumer - The consumer instance to remove
	*/
	void CKeyStore::RemoveConsumer(classParam<CConsumer> pConsumer)
	{
		Lib3MFHandle hConsumer = pConsumer.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_RemoveConsumer(m_pHandle, hConsumer));
	}
	
	/**
	* CKeyStore::FindConsumer - Finds a consumer by ID
	* @param[in] sConsumerID - The ID of the consumer
	* @return The consumer instance
	*/
	PConsumer CKeyStore::FindConsumer(const std::string & sConsumerID)
	{
		Lib3MFHandle hConsumer = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_FindConsumer(m_pHandle, sConsumerID.c_str(), &hConsumer));
		
		if (hConsumer) {
			return std::shared_ptr<CConsumer>(dynamic_cast<CConsumer*>(m_pWrapper->polymorphicFactory(hConsumer)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CKeyStore::GetResourceDataGroupCount - Gets the number of resource data group in the keysore
	* @return The number of resource data available
	*/
	Lib3MF_uint64 CKeyStore::GetResourceDataGroupCount()
	{
		Lib3MF_uint64 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_GetResourceDataGroupCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CKeyStore::AddResourceDataGroup - Adds a resource data group into the keystore.
	* @return The resource data group instance
	*/
	PResourceDataGroup CKeyStore::AddResourceDataGroup()
	{
		Lib3MFHandle hResourceDataGroup = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_AddResourceDataGroup(m_pHandle, &hResourceDataGroup));
		
		if (!hResourceDataGroup) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CResourceDataGroup>(dynamic_cast<CResourceDataGroup*>(m_pWrapper->polymorphicFactory(hResourceDataGroup)));
	}
	
	/**
	* CKeyStore::GetResourceDataGroup - Gets a resource data group
	* @param[in] nResourceDataIndex - The index of the resource data
	* @return The resource data group instance
	*/
	PResourceDataGroup CKeyStore::GetResourceDataGroup(const Lib3MF_uint64 nResourceDataIndex)
	{
		Lib3MFHandle hResourceDataGroup = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_GetResourceDataGroup(m_pHandle, nResourceDataIndex, &hResourceDataGroup));
		
		if (!hResourceDataGroup) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CResourceDataGroup>(dynamic_cast<CResourceDataGroup*>(m_pWrapper->polymorphicFactory(hResourceDataGroup)));
	}
	
	/**
	* CKeyStore::RemoveResourceDataGroup - Removes a resource data group
	* @param[in] pResourceDataGroup - The resource data group instance
	*/
	void CKeyStore::RemoveResourceDataGroup(classParam<CResourceDataGroup> pResourceDataGroup)
	{
		Lib3MFHandle hResourceDataGroup = pResourceDataGroup.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_RemoveResourceDataGroup(m_pHandle, hResourceDataGroup));
	}
	
	/**
	* CKeyStore::FindResourceDataGroup - Finds a resource data group that contains a particular resourcedata
	* @param[in] pPartPath - The target path for the resourcedata hold by the resource data group
	* @return The data resource instance
	*/
	PResourceDataGroup CKeyStore::FindResourceDataGroup(classParam<CPackagePart> pPartPath)
	{
		Lib3MFHandle hPartPath = pPartPath.GetHandle();
		Lib3MFHandle hResourceDataGroup = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_FindResourceDataGroup(m_pHandle, hPartPath, &hResourceDataGroup));
		
		if (hResourceDataGroup) {
			return std::shared_ptr<CResourceDataGroup>(dynamic_cast<CResourceDataGroup*>(m_pWrapper->polymorphicFactory(hResourceDataGroup)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CKeyStore::AddResourceData - Add resourcedata to resourcedatagroup element
	* @param[in] pResourceDataGroup - The resource data group where to add this resource data
	* @param[in] pPartPath - The path of the part to be encrypted
	* @param[in] eAlgorithm - The encryption algorithm to be used to encrypt this resource
	* @param[in] eCompression - Whether compression should be used prior to encryption
	* @param[in] AdditionalAuthenticationDataBuffer - Additional data to be encrypted along the contents for better security
	* @return The data resource instance
	*/
	PResourceData CKeyStore::AddResourceData(classParam<CResourceDataGroup> pResourceDataGroup, classParam<CPackagePart> pPartPath, const eEncryptionAlgorithm eAlgorithm, const eCompression eCompression, const CInputVector<Lib3MF_uint8> & AdditionalAuthenticationDataBuffer)
	{
		Lib3MFHandle hResourceDataGroup = pResourceDataGroup.GetHandle();
		Lib3MFHandle hPartPath = pPartPath.GetHandle();
		Lib3MF_uint64 nAdditionalAuthenticationDataSize = AdditionalAuthenticationDataBuffer.size();
		Lib3MFHandle hResourceData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_AddResourceData(m_pHandle, hResourceDataGroup, hPartPath, eAlgorithm, eCompression, nAdditionalAuthenticationDataSize, AdditionalAuthenticationDataBuffer.data(), &hResourceData));
		
		if (!hResourceData) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CResourceData>(dynamic_cast<CResourceData*>(m_pWrapper->polymorphicFactory(hResourceData)));
	}
	
	/**
	* CKeyStore::RemoveResourceData - Removes a resource data
	* @param[in] pResourceData - The resource data to be removed
	*/
	void CKeyStore::RemoveResourceData(classParam<CResourceData> pResourceData)
	{
		Lib3MFHandle hResourceData = pResourceData.GetHandle();
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_RemoveResourceData(m_pHandle, hResourceData));
	}
	
	/**
	* CKeyStore::FindResourceData - Finds a resource data on this resource group
	* @param[in] pResourcePath - The target path for the resourcedata
	* @return The resource data instance
	*/
	PResourceData CKeyStore::FindResourceData(classParam<CPackagePart> pResourcePath)
	{
		Lib3MFHandle hResourcePath = pResourcePath.GetHandle();
		Lib3MFHandle hResourceData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_FindResourceData(m_pHandle, hResourcePath, &hResourceData));
		
		if (hResourceData) {
			return std::shared_ptr<CResourceData>(dynamic_cast<CResourceData*>(m_pWrapper->polymorphicFactory(hResourceData)));
		} else {
			return nullptr;
		}
	}
	
	/**
	* CKeyStore::GetResourceDataCount - Gets the number of resource data in the keysore
	* @return The number of resource data available
	*/
	Lib3MF_uint64 CKeyStore::GetResourceDataCount()
	{
		Lib3MF_uint64 resultCount = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_GetResourceDataCount(m_pHandle, &resultCount));
		
		return resultCount;
	}
	
	/**
	* CKeyStore::GetResourceData - Gets a resource data
	* @param[in] nResourceDataIndex - The index of the resource data
	* @return The data resource instance
	*/
	PResourceData CKeyStore::GetResourceData(const Lib3MF_uint64 nResourceDataIndex)
	{
		Lib3MFHandle hResourceData = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_GetResourceData(m_pHandle, nResourceDataIndex, &hResourceData));
		
		if (!hResourceData) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CResourceData>(dynamic_cast<CResourceData*>(m_pWrapper->polymorphicFactory(hResourceData)));
	}
	
	/**
	* CKeyStore::GetUUID - Gets the keystore UUID
	* @param[out] bHasUUID - flag whether the keystore has a UUID
	* @return returns the keystore uuid.
	*/
	std::string CKeyStore::GetUUID(bool & bHasUUID)
	{
		Lib3MF_uint32 bytesNeededUUID = 0;
		Lib3MF_uint32 bytesWrittenUUID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_GetUUID(m_pHandle, &bHasUUID, 0, &bytesNeededUUID, nullptr));
		std::vector<char> bufferUUID(bytesNeededUUID);
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_GetUUID(m_pHandle, &bHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]));
		
		return std::string(&bufferUUID[0]);
	}
	
	/**
	* CKeyStore::SetUUID - Sets the keystore UUID
	* @param[in] sUUID - The new keystore uuid.
	*/
	void CKeyStore::SetUUID(const std::string & sUUID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_KeyStore_SetUUID(m_pHandle, sUUID.c_str()));
	}
	
	/**
	 * Method definitions for class CModel
	 */
	
	/**
	* CModel::RootModelPart - Returns the PackagePart within the OPC package that holds the root model.
	* @return the PackagePart within the OPC package that holds the model-file
	*/
	PPackagePart CModel::RootModelPart()
	{
		Lib3MFHandle hRootModelPart = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_RootModelPart(m_pHandle, &hRootModelPart));
		
		if (!hRootModelPart) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CPackagePart>(dynamic_cast<CPackagePart*>(m_pWrapper->polymorphicFactory(hRootModelPart)));
	}
	
	/**
	* CModel::FindOrCreatePackagePart - Returns a new PackagePart for use within the OPC package.
	* @param[in] sAbsolutePath - the absolute Path (physical location) within the OPC package
	* @return the new PackagePart within the OPC package
	*/
	PPackagePart CModel::FindOrCreatePackagePart(const std::string & sAbsolutePath)
	{
		Lib3MFHandle hModelPart = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_FindOrCreatePackagePart(m_pHandle, sAbsolutePath.c_str(), &hModelPart));
		
		if (!hModelPart) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CPackagePart>(dynamic_cast<CPackagePart*>(m_pWrapper->polymorphicFactory(hModelPart)));
	}
	
	/**
	* CModel::SetUnit - sets the units of a model.
	* @param[in] eUnit - Unit enum value for the model unit
	*/
	void CModel::SetUnit(const eModelUnit eUnit)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Model_SetUnit(m_pHandle, eUnit));
	}
	
	/**
	* CModel::GetUnit - returns the units of a model.
	* @return Unit enum value for the model unit
	*/
	eModelUnit CModel::GetUnit()
	{
		eModelUnit resultUnit = (eModelUnit) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetUnit(m_pHandle, &resultUnit));
		
		return resultUnit;
	}
	
	/**
	* CModel::GetLanguage - retrieves the language of a model
	* @return language identifier
	*/
	std::string CModel::GetLanguage()
	{
		Lib3MF_uint32 bytesNeededLanguage = 0;
		Lib3MF_uint32 bytesWrittenLanguage = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetLanguage(m_pHandle, 0, &bytesNeededLanguage, nullptr));
		std::vector<char> bufferLanguage(bytesNeededLanguage);
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetLanguage(m_pHandle, bytesNeededLanguage, &bytesWrittenLanguage, &bufferLanguage[0]));
		
		return std::string(&bufferLanguage[0]);
	}
	
	/**
	* CModel::SetLanguage - sets the language of a model
	* @param[in] sLanguage - language identifier
	*/
	void CModel::SetLanguage(const std::string & sLanguage)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Model_SetLanguage(m_pHandle, sLanguage.c_str()));
	}
	
	/**
	* CModel::QueryWriter - creates a model writer instance for a specific file type
	* @param[in] sWriterClass -  string identifier for the file type
	* @return  string identifier for the file type
	*/
	PWriter CModel::QueryWriter(const std::string & sWriterClass)
	{
		Lib3MFHandle hWriterInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_QueryWriter(m_pHandle, sWriterClass.c_str(), &hWriterInstance));
		
		if (!hWriterInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CWriter>(dynamic_cast<CWriter*>(m_pWrapper->polymorphicFactory(hWriterInstance)));
	}
	
	/**
	* CModel::QueryReader - creates a model reader instance for a specific file type
	* @param[in] sReaderClass -  string identifier for the file type
	* @return  string identifier for the file type
	*/
	PReader CModel::QueryReader(const std::string & sReaderClass)
	{
		Lib3MFHandle hReaderInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_QueryReader(m_pHandle, sReaderClass.c_str(), &hReaderInstance));
		
		if (!hReaderInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CReader>(dynamic_cast<CReader*>(m_pWrapper->polymorphicFactory(hReaderInstance)));
	}
	
	/**
	* CModel::GetResourceByID - finds a model resource by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the resource instance
	*/
	PResource CModel::GetResourceByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		Lib3MFHandle hResource = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetResourceByID(m_pHandle, nUniqueResourceID, &hResource));
		
		if (!hResource) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CResource>(dynamic_cast<CResource*>(m_pWrapper->polymorphicFactory(hResource)));
	}
	
	/**
	* CModel::GetTexture2DByID - finds a model texture by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the texture2d instance
	*/
	PTexture2D CModel::GetTexture2DByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		Lib3MFHandle hTextureInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetTexture2DByID(m_pHandle, nUniqueResourceID, &hTextureInstance));
		
		if (!hTextureInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTexture2D>(dynamic_cast<CTexture2D*>(m_pWrapper->polymorphicFactory(hTextureInstance)));
	}
	
	/**
	* CModel::GetPropertyTypeByID - returns a Property's type
	* @param[in] nUniqueResourceID - Resource ID of the Property to Query
	* @return returns a Property's type
	*/
	ePropertyType CModel::GetPropertyTypeByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		ePropertyType resultThePropertyType = (ePropertyType) 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetPropertyTypeByID(m_pHandle, nUniqueResourceID, &resultThePropertyType));
		
		return resultThePropertyType;
	}
	
	/**
	* CModel::GetBaseMaterialGroupByID - finds a model base material group by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the BaseMaterialGroup instance
	*/
	PBaseMaterialGroup CModel::GetBaseMaterialGroupByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		Lib3MFHandle hBaseMaterialGroupInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetBaseMaterialGroupByID(m_pHandle, nUniqueResourceID, &hBaseMaterialGroupInstance));
		
		if (!hBaseMaterialGroupInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBaseMaterialGroup>(dynamic_cast<CBaseMaterialGroup*>(m_pWrapper->polymorphicFactory(hBaseMaterialGroupInstance)));
	}
	
	/**
	* CModel::GetTexture2DGroupByID - finds a model texture2d group by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the Texture2DGroup instance
	*/
	PTexture2DGroup CModel::GetTexture2DGroupByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		Lib3MFHandle hTexture2DGroupInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetTexture2DGroupByID(m_pHandle, nUniqueResourceID, &hTexture2DGroupInstance));
		
		if (!hTexture2DGroupInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTexture2DGroup>(dynamic_cast<CTexture2DGroup*>(m_pWrapper->polymorphicFactory(hTexture2DGroupInstance)));
	}
	
	/**
	* CModel::GetCompositeMaterialsByID - finds a model CompositeMaterials by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the CompositeMaterials instance
	*/
	PCompositeMaterials CModel::GetCompositeMaterialsByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		Lib3MFHandle hCompositeMaterialsInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetCompositeMaterialsByID(m_pHandle, nUniqueResourceID, &hCompositeMaterialsInstance));
		
		if (!hCompositeMaterialsInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CCompositeMaterials>(dynamic_cast<CCompositeMaterials*>(m_pWrapper->polymorphicFactory(hCompositeMaterialsInstance)));
	}
	
	/**
	* CModel::GetMultiPropertyGroupByID - finds a model MultiPropertyGroup by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the MultiPropertyGroup instance
	*/
	PMultiPropertyGroup CModel::GetMultiPropertyGroupByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		Lib3MFHandle hMultiPropertyGroupInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetMultiPropertyGroupByID(m_pHandle, nUniqueResourceID, &hMultiPropertyGroupInstance));
		
		if (!hMultiPropertyGroupInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMultiPropertyGroup>(dynamic_cast<CMultiPropertyGroup*>(m_pWrapper->polymorphicFactory(hMultiPropertyGroupInstance)));
	}
	
	/**
	* CModel::GetMeshObjectByID - finds a mesh object by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the mesh object instance
	*/
	PMeshObject CModel::GetMeshObjectByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		Lib3MFHandle hMeshObjectInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetMeshObjectByID(m_pHandle, nUniqueResourceID, &hMeshObjectInstance));
		
		if (!hMeshObjectInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMeshObject>(dynamic_cast<CMeshObject*>(m_pWrapper->polymorphicFactory(hMeshObjectInstance)));
	}
	
	/**
	* CModel::GetComponentsObjectByID - finds a components object by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the components object instance
	*/
	PComponentsObject CModel::GetComponentsObjectByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		Lib3MFHandle hComponentsObjectInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetComponentsObjectByID(m_pHandle, nUniqueResourceID, &hComponentsObjectInstance));
		
		if (!hComponentsObjectInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CComponentsObject>(dynamic_cast<CComponentsObject*>(m_pWrapper->polymorphicFactory(hComponentsObjectInstance)));
	}
	
	/**
	* CModel::GetColorGroupByID - finds a model color group by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the ColorGroup instance
	*/
	PColorGroup CModel::GetColorGroupByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		Lib3MFHandle hColorGroupInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetColorGroupByID(m_pHandle, nUniqueResourceID, &hColorGroupInstance));
		
		if (!hColorGroupInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CColorGroup>(dynamic_cast<CColorGroup*>(m_pWrapper->polymorphicFactory(hColorGroupInstance)));
	}
	
	/**
	* CModel::GetSliceStackByID - finds a model slicestack by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the slicestack instance
	*/
	PSliceStack CModel::GetSliceStackByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		Lib3MFHandle hSliceStacInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetSliceStackByID(m_pHandle, nUniqueResourceID, &hSliceStacInstance));
		
		if (!hSliceStacInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CSliceStack>(dynamic_cast<CSliceStack*>(m_pWrapper->polymorphicFactory(hSliceStacInstance)));
	}
	
	/**
	* CModel::GetLevelSetByID - finds a level set object by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the level set object instance
	*/
	PLevelSet CModel::GetLevelSetByID(const Lib3MF_uint32 nUniqueResourceID)
	{
		Lib3MFHandle hLevelSetObjectInstance = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetLevelSetByID(m_pHandle, nUniqueResourceID, &hLevelSetObjectInstance));
		
		if (!hLevelSetObjectInstance) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CLevelSet>(dynamic_cast<CLevelSet*>(m_pWrapper->polymorphicFactory(hLevelSetObjectInstance)));
	}
	
	/**
	* CModel::GetBuildUUID - returns, whether a build has a UUID and, if true, the build's UUID
	* @param[out] bHasUUID - flag whether the build has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	std::string CModel::GetBuildUUID(bool & bHasUUID)
	{
		Lib3MF_uint32 bytesNeededUUID = 0;
		Lib3MF_uint32 bytesWrittenUUID = 0;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetBuildUUID(m_pHandle, &bHasUUID, 0, &bytesNeededUUID, nullptr));
		std::vector<char> bufferUUID(bytesNeededUUID);
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetBuildUUID(m_pHandle, &bHasUUID, bytesNeededUUID, &bytesWrittenUUID, &bufferUUID[0]));
		
		return std::string(&bufferUUID[0]);
	}
	
	/**
	* CModel::SetBuildUUID - sets the build's UUID
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	void CModel::SetBuildUUID(const std::string & sUUID)
	{
		CheckError(m_pWrapper->m_WrapperTable.m_Model_SetBuildUUID(m_pHandle, sUUID.c_str()));
	}
	
	/**
	* CModel::GetBuildItems - creates a build item iterator instance with all build items.
	* @return returns the iterator instance.
	*/
	PBuildItemIterator CModel::GetBuildItems()
	{
		Lib3MFHandle hBuildItemIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetBuildItems(m_pHandle, &hBuildItemIterator));
		
		if (!hBuildItemIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBuildItemIterator>(dynamic_cast<CBuildItemIterator*>(m_pWrapper->polymorphicFactory(hBuildItemIterator)));
	}
	
	/**
	* CModel::GetOutbox - Returns the outbox of a Model
	* @return Outbox of this Model
	*/
	sBox CModel::GetOutbox()
	{
		sBox resultOutbox;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetOutbox(m_pHandle, &resultOutbox));
		
		return resultOutbox;
	}
	
	/**
	* CModel::GetResources - creates a resource iterator instance with all resources.
	* @return returns the iterator instance.
	*/
	PResourceIterator CModel::GetResources()
	{
		Lib3MFHandle hResourceIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetResources(m_pHandle, &hResourceIterator));
		
		if (!hResourceIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CResourceIterator>(dynamic_cast<CResourceIterator*>(m_pWrapper->polymorphicFactory(hResourceIterator)));
	}
	
	/**
	* CModel::GetObjects - creates a resource iterator instance with all object resources.
	* @return returns the iterator instance.
	*/
	PObjectIterator CModel::GetObjects()
	{
		Lib3MFHandle hResourceIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetObjects(m_pHandle, &hResourceIterator));
		
		if (!hResourceIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CObjectIterator>(dynamic_cast<CObjectIterator*>(m_pWrapper->polymorphicFactory(hResourceIterator)));
	}
	
	/**
	* CModel::GetMeshObjects - creates a resource iterator instance with all mesh object resources.
	* @return returns the iterator instance.
	*/
	PMeshObjectIterator CModel::GetMeshObjects()
	{
		Lib3MFHandle hResourceIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetMeshObjects(m_pHandle, &hResourceIterator));
		
		if (!hResourceIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CMeshObjectIterator>(dynamic_cast<CMeshObjectIterator*>(m_pWrapper->polymorphicFactory(hResourceIterator)));
	}
	
	/**
	* CModel::GetComponentsObjects - creates a resource iterator instance with all components object resources.
	* @return returns the iterator instance.
	*/
	PComponentsObjectIterator CModel::GetComponentsObjects()
	{
		Lib3MFHandle hResourceIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetComponentsObjects(m_pHandle, &hResourceIterator));
		
		if (!hResourceIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CComponentsObjectIterator>(dynamic_cast<CComponentsObjectIterator*>(m_pWrapper->polymorphicFactory(hResourceIterator)));
	}
	
	/**
	* CModel::GetTexture2Ds - creates a Texture2DIterator instance with all texture2d resources.
	* @return returns the iterator instance.
	*/
	PTexture2DIterator CModel::GetTexture2Ds()
	{
		Lib3MFHandle hResourceIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetTexture2Ds(m_pHandle, &hResourceIterator));
		
		if (!hResourceIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTexture2DIterator>(dynamic_cast<CTexture2DIterator*>(m_pWrapper->polymorphicFactory(hResourceIterator)));
	}
	
	/**
	* CModel::GetBaseMaterialGroups - creates a BaseMaterialGroupIterator instance with all base material resources.
	* @return returns the iterator instance.
	*/
	PBaseMaterialGroupIterator CModel::GetBaseMaterialGroups()
	{
		Lib3MFHandle hResourceIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetBaseMaterialGroups(m_pHandle, &hResourceIterator));
		
		if (!hResourceIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CBaseMaterialGroupIterator>(dynamic_cast<CBaseMaterialGroupIterator*>(m_pWrapper->polymorphicFactory(hResourceIterator)));
	}
	
	/**
	* CModel::GetColorGroups - creates a ColorGroupIterator instance with all ColorGroup resources.
	* @return returns the iterator instance.
	*/
	PColorGroupIterator CModel::GetColorGroups()
	{
		Lib3MFHandle hResourceIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetColorGroups(m_pHandle, &hResourceIterator));
		
		if (!hResourceIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CColorGroupIterator>(dynamic_cast<CColorGroupIterator*>(m_pWrapper->polymorphicFactory(hResourceIterator)));
	}
	
	/**
	* CModel::GetTexture2DGroups - creates a Texture2DGroupIterator instance with all base material resources.
	* @return returns the iterator instance.
	*/
	PTexture2DGroupIterator CModel::GetTexture2DGroups()
	{
		Lib3MFHandle hResourceIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetTexture2DGroups(m_pHandle, &hResourceIterator));
		
		if (!hResourceIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CTexture2DGroupIterator>(dynamic_cast<CTexture2DGroupIterator*>(m_pWrapper->polymorphicFactory(hResourceIterator)));
	}
	
	/**
	* CModel::GetCompositeMaterials - creates a CompositeMaterialsIterator instance with all CompositeMaterials resources.
	* @return returns the iterator instance.
	*/
	PCompositeMaterialsIterator CModel::GetCompositeMaterials()
	{
		Lib3MFHandle hResourceIterator = (Lib3MFHandle)nullptr;
		CheckError(m_pWrapper->m_WrapperTable.m_Model_GetCompositeMaterials(m_pHandle, &hResourceIterator));
		
		if (!hResourceIterator) {
			CheckError(LIB3MF_ERROR_INVALIDPARAM);
		}
		return std::shared_ptr<CCompositeMaterialsIterator>(dynamic_cast<CCompositeMaterialsIterator*>(m_pWrapper->polymorphicFactory(hResourceIterator)));
	}
	
	/**
	* CModel::GetMultiPropertyGroups - creates a MultiPropertyGroupsIterator instan