/*
 * SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __gb110_dev_riscv_pri_h__
#define __gb110_dev_riscv_pri_h__

#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT                        0x00000700     /* R--4R */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_GLOBAL_MEM             0:0            /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_GLOBAL_MEM_FAULTED     0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_GLOBAL_MEM_NO_FAULT    0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ROM                    1:1            /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ROM_FAULTED            0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ROM_NO_FAULT           0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ITCM                   2:2            /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ITCM_FAULTED           0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ITCM_NO_FAULT          0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_DTCM                   3:3            /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_DTCM_FAULTED           0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_DTCM_NO_FAULT          0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ICACHE                 4:4            /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ICACHE_FAULTED         0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ICACHE_NO_FAULT        0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_DCACHE                 5:5            /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_DCACHE_FAULTED         0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_DCACHE_NO_FAULT        0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_RVCORE                 6:6            /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_RVCORE_FAULTED         0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_RVCORE_NO_FAULT        0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_REG                    7:7            /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_REG_FAULTED            0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_REG_NO_FAULT           0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_SE_LOGIC               8:8            /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_SE_LOGIC_FAULTED       0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_SE_LOGIC_NO_FAULT      0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_SE_KSLT                9:9            /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_SE_KSLT_FAULTED        0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_SE_KSLT_NO_FAULT       0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_TKE                    10:10          /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_TKE_FAULTED            0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_TKE_NO_FAULT           0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_FBIF                   11:11          /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_FBIF_FAULTED           0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_FBIF_NO_FAULT          0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_MPURAM                 12:12          /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_MPURAM_FAULTED         0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_MPURAM_NO_FAULT        0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN0             16:16          /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN0_FAULTED     0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN0_NO_FAULT    0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN1             17:17          /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN1_FAULTED     0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN1_NO_FAULT    0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN2             18:18          /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN2_FAULTED     0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN2_NO_FAULT    0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN3             19:19          /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN3_FAULTED     0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN3_NO_FAULT    0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN4             20:20          /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN4_FAULTED     0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN4_NO_FAULT    0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN5             21:21          /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN5_FAULTED     0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN5_NO_FAULT    0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN6             22:22          /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN6_FAULTED     0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN6_NO_FAULT    0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN7             23:23          /* R-IVF */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN7_FAULTED     0x00000001     /* R---V */
#define NV_PRISCV_RISCV_FAULT_CONTAINMENT_SRCSTAT_ENGINE_IN7_NO_FAULT    0x00000000     /* R-I-V */

#endif // __gb110_dev_riscv_pri_h__
