"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWorker = exports.setBuildHash = void 0;
const worker_config_1 = require("./worker_config");
let buildHash;
/**
 * Sets the build hash for worker URL generation.
 * This should be called during application initialization before any workers are created.
 * @param hash The build hash string
 */
function setBuildHash(hash) {
    buildHash = hash;
}
exports.setBuildHash = setBuildHash;
/**
 * Creates a web worker from a served URL based on the worker label.
 * @param label The worker label/ID (e.g., 'ppl', 'json', 'xjson')
 * @returns A new Worker instance
 */
function getWorker(label) {
    if (!buildHash) {
        throw new Error('Build hash must be set before initializing editor workers');
    }
    const workerUrl = (0, worker_config_1.getWorkerUrl)(label, buildHash);
    if (!workerUrl) {
        throw new Error(`No worker available for language: ${label}`);
    }
    return new Worker(workerUrl);
}
exports.getWorker = getWorker;
// @ts-ignore
window.MonacoEnvironment = {
    getWorker,
};
//# sourceMappingURL=monaco_environment.js.map