/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.vendor;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.pool.ValidConnectionCheckerAdapter;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class OracleValidConnectionChecker
extends ValidConnectionCheckerAdapter
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = -2227528634302168877L;
    private static final Log LOG = LogFactory.getLog(OracleValidConnectionChecker.class);
    private int timeout = 1;
    private String defaultValidateQuery = "SELECT 'x' FROM DUAL";

    public OracleValidConnectionChecker() {
        this.configFromProperties(System.getProperties());
    }

    @Override
    public void configFromProperties(Properties properties2) {
        String property = properties2.getProperty("druid.oracle.pingTimeout");
        if (property != null && property.length() > 0) {
            int value = Integer.parseInt(property);
            this.setTimeout(value);
        }
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValidConnection(Connection conn, String validateQuery, int validationQueryTimeout) {
        if (validateQuery == null || validateQuery.isEmpty()) {
            validateQuery = this.defaultValidateQuery;
        }
        try {
            if (conn.isClosed()) {
                return false;
            }
        }
        catch (SQLException ex) {
            return false;
        }
        try {
            boolean bl;
            if (conn instanceof DruidPooledConnection) {
                conn = ((DruidPooledConnection)conn).getConnection();
            }
            if (conn instanceof ConnectionProxy) {
                conn = ((ConnectionProxy)conn).getRawObject();
            }
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.createStatement();
                stmt.setQueryTimeout(this.timeout);
                rs = stmt.executeQuery(validateQuery);
                bl = true;
                JdbcUtils.close(rs);
            }
            catch (SQLException e) {
                boolean bl2 = false;
                return bl2;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (Exception e2) {
                    LOG.warn("Unexpected error in ping", e2);
                    boolean bl3 = false;
                    JdbcUtils.close(rs);
                    JdbcUtils.close(stmt);
                    return bl3;
                }
            }
            finally {
                JdbcUtils.close(rs);
                JdbcUtils.close(stmt);
            }
            JdbcUtils.close(stmt);
            return bl;
        }
        catch (Exception e) {
            LOG.warn("Unexpected error in pingDatabase", e);
            return false;
        }
    }
}

