/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.PseudoField;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MemberExpression
extends Expression {
    public final @Nullable Expression expression;
    public final PseudoField field;

    public MemberExpression(Expression expression, Field field) {
        this(expression, Types.field(field));
    }

    public MemberExpression(@Nullable Expression expression, PseudoField field) {
        super(ExpressionType.MemberAccess, field.getType());
        this.expression = expression;
        this.field = Objects.requireNonNull(field, "field");
        if (!Modifier.isStatic(field.getModifiers())) {
            Objects.requireNonNull(expression, "must specify expression if field is not static");
        }
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression expression1 = this.expression == null ? null : this.expression.accept(shuttle);
        return shuttle.visit(this, expression1);
    }

    @Override
    public <R> R accept(Visitor<R> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    public @Nullable Object evaluate(Evaluator evaluator) {
        Object o = this.expression == null ? null : this.expression.evaluate(evaluator);
        try {
            return this.field.get(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("error while evaluating " + this, e);
        }
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (writer.requireParentheses(this, lprec, rprec)) {
            return;
        }
        if (this.expression != null) {
            this.expression.accept(writer, lprec, this.nodeType.lprec);
        } else {
            assert ((this.field.getModifiers() & 8) != 0);
            writer.append(this.field.getDeclaringClass());
        }
        writer.append('.').append(this.field.getName());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MemberExpression that = (MemberExpression)o;
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        return this.field.equals(that.field);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.expression, this.field});
    }
}

