/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlBitOpAggFunction;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableCollection;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.collect.ImmutableSortedMap;
import shaded.com.google.common.collect.ImmutableSortedSet;

public abstract class Match
extends SingleRel {
    private static final String STAR = "*";
    protected final ImmutableMap<String, RexNode> measures;
    protected final RexNode pattern;
    protected final boolean strictStart;
    protected final boolean strictEnd;
    protected final boolean allRows;
    protected final RexNode after;
    protected final ImmutableMap<String, RexNode> patternDefinitions;
    protected final Set<RexMRAggCall> aggregateCalls;
    protected final Map<String, SortedSet<RexMRAggCall>> aggregateCallsPreVar;
    protected final ImmutableMap<String, SortedSet<String>> subsets;
    protected final ImmutableBitSet partitionKeys;
    protected final RelCollation orderKeys;
    protected final @Nullable RexNode interval;

    protected Match(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType rowType, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, @Nullable RexNode interval) {
        super(cluster, traitSet, input);
        this.rowType = Objects.requireNonNull(rowType, "rowType");
        this.pattern = Objects.requireNonNull(pattern, "pattern");
        Preconditions.checkArgument(!patternDefinitions.isEmpty());
        this.strictStart = strictStart;
        this.strictEnd = strictEnd;
        this.patternDefinitions = ImmutableMap.copyOf(patternDefinitions);
        this.measures = ImmutableMap.copyOf(measures);
        this.after = Objects.requireNonNull(after, "after");
        this.subsets = Match.copyMap(subsets);
        this.allRows = allRows;
        this.partitionKeys = Objects.requireNonNull(partitionKeys, "partitionKeys");
        this.orderKeys = Objects.requireNonNull(orderKeys, "orderKeys");
        this.interval = interval;
        AggregateFinder aggregateFinder = new AggregateFinder();
        for (RexNode rex : this.patternDefinitions.values()) {
            if (!(rex instanceof RexCall)) continue;
            aggregateFinder.go((RexCall)rex);
        }
        for (RexNode rex : this.measures.values()) {
            if (!(rex instanceof RexCall)) continue;
            aggregateFinder.go((RexCall)rex);
        }
        this.aggregateCalls = ImmutableSortedSet.copyOf(aggregateFinder.aggregateCalls);
        this.aggregateCallsPreVar = Match.copyMap(aggregateFinder.aggregateCallsPerVar);
    }

    private static <K extends Comparable<K>, V> ImmutableSortedMap<K, SortedSet<V>> copyMap(Map<K, ? extends SortedSet<V>> map) {
        ImmutableSortedMap.Builder b = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<K, SortedSet<V>> e : map.entrySet()) {
            b.put((Object)e.getKey(), ImmutableSortedSet.copyOf((Collection)e.getValue()));
        }
        return b.build();
    }

    public ImmutableMap<String, RexNode> getMeasures() {
        return this.measures;
    }

    public RexNode getAfter() {
        return this.after;
    }

    public RexNode getPattern() {
        return this.pattern;
    }

    public boolean isStrictStart() {
        return this.strictStart;
    }

    public boolean isStrictEnd() {
        return this.strictEnd;
    }

    public boolean isAllRows() {
        return this.allRows;
    }

    public ImmutableMap<String, RexNode> getPatternDefinitions() {
        return this.patternDefinitions;
    }

    public ImmutableMap<String, SortedSet<String>> getSubsets() {
        return this.subsets;
    }

    public ImmutableBitSet getPartitionKeys() {
        return this.partitionKeys;
    }

    public RelCollation getOrderKeys() {
        return this.orderKeys;
    }

    public @Nullable RexNode getInterval() {
        return this.interval;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("partition", this.getPartitionKeys().asList()).item("order", this.getOrderKeys()).item("outputFields", this.getRowType().getFieldNames()).item("allRows", this.isAllRows()).item("after", this.getAfter()).item("pattern", this.getPattern()).item("isStrictStarts", this.isStrictStart()).item("isStrictEnds", this.isStrictEnd()).itemIf("interval", this.getInterval(), this.getInterval() != null).item("subsets", ((ImmutableCollection)this.getSubsets().values()).asList()).item("patternDefinitions", ((ImmutableCollection)this.getPatternDefinitions().values()).asList()).item("inputFields", this.getInput().getRowType().getFieldNames());
    }

    public static final class RexMRAggCall
    extends RexCall
    implements Comparable<RexMRAggCall> {
        public final int ordinal;

        RexMRAggCall(SqlAggFunction aggFun, RelDataType type2, List<RexNode> operands, int ordinal) {
            super(type2, aggFun, operands);
            this.ordinal = ordinal;
            this.digest = this.toString();
        }

        @Override
        public int compareTo(RexMRAggCall o) {
            return this.toString().compareTo(o.toString());
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return obj == this || obj instanceof RexMRAggCall && this.toString().equals(obj.toString());
        }

        @Override
        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private static class PatternVarFinder
    extends RexVisitorImpl<Void> {
        final Set<String> patternVars = new HashSet<String>();

        PatternVarFinder() {
            super(true);
        }

        @Override
        public Void visitPatternFieldRef(RexPatternFieldRef fieldRef) {
            this.patternVars.add(fieldRef.getAlpha());
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            this.visitEach(call.operands);
            return null;
        }

        public Set<String> go(RexNode rex) {
            rex.accept(this);
            return this.patternVars;
        }

        public Set<String> go(List<RexNode> rexNodeList) {
            this.visitEach(rexNodeList);
            return this.patternVars;
        }
    }

    private static class AggregateFinder
    extends RexVisitorImpl<Void> {
        final NavigableSet<RexMRAggCall> aggregateCalls = new TreeSet<RexMRAggCall>();
        final Map<String, NavigableSet<RexMRAggCall>> aggregateCallsPerVar = new TreeMap<String, NavigableSet<RexMRAggCall>>();

        AggregateFinder() {
            super(true);
        }

        @Override
        public Void visitCall(RexCall call) {
            SqlAggFunction aggFunction = null;
            switch (call.getKind()) {
                case SUM: {
                    aggFunction = new SqlSumAggFunction(call.getType());
                    break;
                }
                case SUM0: {
                    aggFunction = new SqlSumEmptyIsZeroAggFunction();
                    break;
                }
                case MAX: 
                case MIN: {
                    aggFunction = new SqlMinMaxAggFunction(call.getKind());
                    break;
                }
                case COUNT: {
                    aggFunction = SqlStdOperatorTable.COUNT;
                    break;
                }
                case ANY_VALUE: {
                    aggFunction = SqlStdOperatorTable.ANY_VALUE;
                    break;
                }
                case BIT_AND: 
                case BIT_OR: 
                case BIT_XOR: {
                    aggFunction = new SqlBitOpAggFunction(call.getKind());
                    break;
                }
                default: {
                    this.visitEach(call.operands);
                }
            }
            if (aggFunction != null) {
                RexMRAggCall aggCall = new RexMRAggCall(aggFunction, call.getType(), call.getOperands(), this.aggregateCalls.size());
                this.aggregateCalls.add(aggCall);
                Set<String> pv = new PatternVarFinder().go(call.getOperands());
                if (pv.isEmpty()) {
                    pv.add(Match.STAR);
                }
                for (String alpha : pv) {
                    NavigableSet<Object> set;
                    if (this.aggregateCallsPerVar.containsKey(alpha)) {
                        set = this.aggregateCallsPerVar.get(alpha);
                    } else {
                        set = new TreeSet();
                        this.aggregateCallsPerVar.put(alpha, set);
                    }
                    boolean update = true;
                    for (RexMRAggCall rexMRAggCall : set) {
                        if (!rexMRAggCall.equals(aggCall)) continue;
                        update = false;
                        break;
                    }
                    if (!update) continue;
                    set.add(aggCall);
                }
            }
            return null;
        }

        public void go(RexCall call) {
            call.accept(this);
        }
    }
}

