/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TableMacroImpl
extends ReflectiveFunctionBase
implements TableMacro {
    private TableMacroImpl(Method method) {
        super(method);
    }

    public static @Nullable TableMacro create(Class<?> clazz) {
        Method method = TableMacroImpl.findMethod(clazz, "eval");
        if (method == null) {
            return null;
        }
        return TableMacroImpl.create(method);
    }

    public static @Nullable TableMacro create(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (!ReflectUtil.isStatic(method) && !TableMacroImpl.classHasPublicZeroArgsConstructor(clazz)) {
            throw Static.RESOURCE.requireDefaultConstructor(clazz.getName()).ex();
        }
        Class<?> returnType = method.getReturnType();
        if (!TranslatableTable.class.isAssignableFrom(returnType)) {
            return null;
        }
        return new TableMacroImpl(method);
    }

    @Override
    public TranslatableTable apply(List<? extends @Nullable Object> arguments2) {
        try {
            Object o = null;
            if (!ReflectUtil.isStatic(this.method)) {
                Constructor<?> constructor = this.method.getDeclaringClass().getConstructor(new Class[0]);
                o = constructor.newInstance(new Object[0]);
            }
            return (TranslatableTable)Objects.requireNonNull(this.method.invoke(o, arguments2.toArray()), () -> "got null from " + this.method + " with arguments " + arguments2);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Expected " + Arrays.toString(this.method.getParameterTypes()) + " actual " + arguments2, e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

