/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;

public class SqlOverOperator
extends SqlBinaryOperator {
    public SqlOverOperator() {
        super("OVER", SqlKind.OVER, 20, true, ReturnTypes.ARG0_FORCE_NULLABLE, null, (SqlOperandTypeChecker)OperandTypes.ANY_IGNORE);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope2, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlCall aggCall = (SqlCall)call.operand(0);
        switch (aggCall.getKind()) {
            case RESPECT_NULLS: 
            case IGNORE_NULLS: {
                validator.validateCall(aggCall, scope2);
                aggCall = (SqlCall)aggCall.operand(0);
                break;
            }
        }
        if (!aggCall.getOperator().isAggregator()) {
            throw validator.newValidationError(aggCall, Static.RESOURCE.overNonAggregate());
        }
        Object window = call.operand(1);
        validator.validateWindow((SqlNode)window, scope2, aggCall);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope2, SqlCall call) {
        this.validateOperands(validator, scope2, call);
        Object agg = call.operand(0);
        if (!(agg instanceof SqlCall)) {
            throw new IllegalStateException("Argument to SqlOverOperator should be SqlCall, got " + agg.getClass() + ": " + agg);
        }
        Object window = call.operand(1);
        SqlWindow w = validator.resolveWindow((SqlNode)window, scope2);
        final int groupCount = w.isAlwaysNonEmpty() ? 1 : 0;
        SqlCall aggCall = (SqlCall)agg;
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope2, aggCall){

            @Override
            public int getGroupCount() {
                return groupCount;
            }
        };
        RelDataType ret = aggCall.getOperator().inferReturnType(opBinding);
        validator.setValidatedNodeType(call, ret);
        validator.setValidatedNodeType((SqlNode)agg, ret);
        return ret;
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor2, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (onlyExpressions) {
            for (Ord<SqlNode> operand : Ord.zip(call.getOperandList())) {
                if (operand == null || operand.i == 1 && operand.e instanceof SqlIdentifier) continue;
                argHandler.visitChild(visitor2, call, operand.i, (SqlNode)operand.e);
            }
        } else {
            super.acceptCall(visitor2, call, onlyExpressions, argHandler);
        }
    }
}

