/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.interfaces.XECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.NamedParameterSpec;
import java.util.Optional;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPublicKey;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.jcajce.interfaces.XDHPrivateKey;
import org.bouncycastle.jcajce.interfaces.XDHPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.Prov11XDHPublicKey;

class Prov11XDHPrivateKey
implements Destroyable,
XDHPrivateKey,
XECPrivateKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricXDHPrivateKey baseKey;

    Prov11XDHPrivateKey(AsymmetricXDHPrivateKey privKey) {
        this.baseKey = privKey;
    }

    Prov11XDHPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.baseKey = new AsymmetricXDHPrivateKey(keyInfo);
    }

    @Override
    public String getAlgorithm() {
        return this.getBaseKey().getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed((Destroyable)this);
        return "PKCS#8";
    }

    @Override
    public byte[] getPublicData() {
        return this.getBaseKey().getPublicData();
    }

    @Override
    public byte[] getEncoded() {
        return this.getBaseKey().getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public AsymmetricXDHPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed((Destroyable)this);
        return this.baseKey;
    }

    @Override
    public XDHPublicKey getPublicKey() {
        return new Prov11XDHPublicKey(new AsymmetricXDHPublicKey(this.baseKey.getAlgorithm(), this.baseKey.getPublicData()));
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("XDH");
        }
        AsymmetricXDHPublicKey pubKey = new AsymmetricXDHPublicKey(this.baseKey.getAlgorithm(), this.baseKey.getPublicData());
        return KeyUtil.keyToString("Private Key", this.getAlgorithm(), pubKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Prov11XDHPrivateKey) {
            return this.baseKey.equals(((Prov11XDHPrivateKey)o).baseKey);
        }
        return false;
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricXDHPrivateKey(enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }

    @Override
    public Optional<byte[]> getScalar() {
        return Optional.of(this.baseKey.getSecret());
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        if (this.baseKey.getAlgorithm().equals(EdEC.Algorithm.X448)) {
            return NamedParameterSpec.X448;
        }
        return NamedParameterSpec.X25519;
    }
}

