/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.subquery;

import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import java.util.HashMap;
import java.util.Map;
import shaded.com.google.common.base.Strings;

public class NestedQueryContext {
    private static final String SEPARATOR = ".";
    private static final String EMPTY = "";
    private final Map<String, String> aliasParents = new HashMap<String, String>();

    public boolean isNested(SQLExprTableSource table) {
        String parent = this.parent(table);
        if (Strings.isNullOrEmpty(parent)) {
            return !Strings.isNullOrEmpty(this.aliasParents.get(this.alias(table)));
        }
        return this.aliasParents.containsKey(parent);
    }

    public void add(SQLTableSource table) {
        if (table instanceof SQLExprTableSource) {
            this.process((SQLExprTableSource)table);
        } else if (table instanceof SQLJoinTableSource) {
            this.add(((SQLJoinTableSource)table).getLeft());
            this.add(((SQLJoinTableSource)table).getRight());
        } else {
            throw new IllegalStateException("unsupported table source");
        }
    }

    private void process(SQLExprTableSource table) {
        String alias = this.alias(table);
        String parent = this.parent(table);
        if (!Strings.isNullOrEmpty(alias)) {
            this.aliasParents.putIfAbsent(alias, parent);
        }
    }

    private String parent(SQLExprTableSource table) {
        String tableName = table.getExpr().toString();
        int index = tableName.indexOf(SEPARATOR);
        return index == -1 ? EMPTY : tableName.substring(0, index);
    }

    private String alias(SQLExprTableSource table) {
        if (Strings.isNullOrEmpty(table.getAlias())) {
            return table.getExpr().toString();
        }
        return table.getAlias();
    }
}

