/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.SearchModule;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.opensearch.search.builder.PointInTimeBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.ShardDocSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;
import org.opensearch.sql.opensearch.storage.OpenSearchStorageEngine;

public class OpenSearchQueryRequest
implements OpenSearchRequest {
    private static final Logger LOG = LogManager.getLogger();
    private final OpenSearchRequest.IndexName indexName;
    private final SearchSourceBuilder sourceBuilder;
    private final OpenSearchExprValueFactory exprValueFactory;
    private final List<String> includes;
    private boolean needClean = true;
    private boolean searchDone = false;
    private String pitId;
    private final TimeValue cursorKeepAlive;
    private Object[] searchAfter;
    private SearchResponse searchResponse = null;
    private Map<String, Object> afterKey;

    static OpenSearchQueryRequest of(String indexName, int size, OpenSearchExprValueFactory factory, List<String> includes) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(0);
        sourceBuilder.size(size);
        sourceBuilder.timeout(DEFAULT_QUERY_TIMEOUT);
        return OpenSearchQueryRequest.of(indexName, sourceBuilder, factory, includes);
    }

    static OpenSearchQueryRequest of(String indexName, SearchSourceBuilder sourceBuilder, OpenSearchExprValueFactory factory, List<String> includes) {
        return OpenSearchQueryRequest.of(new OpenSearchRequest.IndexName(indexName), sourceBuilder, factory, includes);
    }

    public static OpenSearchQueryRequest of(OpenSearchRequest.IndexName indexName, SearchSourceBuilder sourceBuilder, OpenSearchExprValueFactory factory, List<String> includes) {
        return new OpenSearchQueryRequest(indexName, sourceBuilder, factory, includes, null, null);
    }

    public static OpenSearchQueryRequest pitOf(OpenSearchRequest.IndexName indexName, SearchSourceBuilder sourceBuilder, OpenSearchExprValueFactory factory, List<String> includes, TimeValue cursorKeepAlive, String pitId) {
        return new OpenSearchQueryRequest(indexName, sourceBuilder, factory, includes, cursorKeepAlive, pitId);
    }

    OpenSearchQueryRequest(OpenSearchRequest.IndexName indexName, SearchSourceBuilder sourceBuilder, OpenSearchExprValueFactory factory, List<String> includes, TimeValue cursorKeepAlive, String pitId) {
        this.indexName = indexName;
        this.sourceBuilder = sourceBuilder;
        this.exprValueFactory = factory;
        this.includes = includes;
        this.cursorKeepAlive = cursorKeepAlive;
        this.pitId = pitId;
    }

    public boolean isCountAggRequest() {
        return !this.searchDone && this.sourceBuilder.size() == 0 && this.sourceBuilder.trackTotalHitsUpTo() != null && this.sourceBuilder.trackTotalHitsUpTo() == Integer.MAX_VALUE;
    }

    public OpenSearchQueryRequest(StreamInput in, OpenSearchStorageEngine engine) throws IOException {
        String sourceBuilderString = in.readString();
        NamedXContentRegistry xContentRegistry = new NamedXContentRegistry(new SearchModule(Settings.EMPTY, Collections.emptyList()).getNamedXContents());
        XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, DeprecationHandler.IGNORE_DEPRECATIONS, sourceBuilderString);
        this.sourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
        this.cursorKeepAlive = in.readTimeValue();
        this.pitId = in.readString();
        this.includes = in.readStringList();
        this.indexName = new OpenSearchRequest.IndexName(in);
        int length = in.readVInt();
        this.searchAfter = new Object[length];
        for (int i = 0; i < length; ++i) {
            this.searchAfter[i] = in.readGenericValue();
        }
        OpenSearchIndex index = (OpenSearchIndex)engine.getTable(null, this.indexName.toString());
        this.exprValueFactory = new OpenSearchExprValueFactory(index.getFieldOpenSearchTypes(), index.isFieldTypeTolerance());
    }

    @Override
    public OpenSearchResponse search(Function<SearchRequest, SearchResponse> searchAction, Function<SearchScrollRequest, SearchResponse> scrollAction) {
        if (this.pitId == null) {
            return this.search(searchAction);
        }
        return this.searchWithPIT(searchAction);
    }

    private OpenSearchResponse search(Function<SearchRequest, SearchResponse> searchAction) {
        OpenSearchResponse openSearchResponse;
        if (this.searchDone) {
            openSearchResponse = new OpenSearchResponse(SearchHits.empty(), this.exprValueFactory, this.includes, this.isCountAggRequest());
        } else {
            if (this.sourceBuilder.aggregations() != null) {
                this.sourceBuilder.aggregations().getAggregatorFactories().stream().filter(a -> a instanceof CompositeAggregationBuilder).forEach(c -> ((CompositeAggregationBuilder)c).aggregateAfter(this.afterKey));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.sourceBuilder);
                }
            }
            SearchRequest searchRequest = new SearchRequest().indices(this.indexName.getIndexNames()).source(this.sourceBuilder);
            this.searchResponse = searchAction.apply(searchRequest);
            openSearchResponse = new OpenSearchResponse(this.searchResponse, this.exprValueFactory, this.includes, this.isCountAggRequest());
            if (openSearchResponse.isAggregationResponse()) {
                openSearchResponse.getAggregations().asList().stream().filter(a -> a instanceof InternalComposite).forEach(c -> {
                    this.afterKey = ((InternalComposite)c).afterKey();
                });
            }
            this.searchDone = this.afterKey != null ? openSearchResponse.isEmpty() : true;
            this.needClean = this.searchDone;
        }
        return openSearchResponse;
    }

    public OpenSearchResponse searchWithPIT(Function<SearchRequest, SearchResponse> searchAction) {
        OpenSearchResponse openSearchResponse;
        if (this.searchDone) {
            openSearchResponse = new OpenSearchResponse(SearchHits.empty(), this.exprValueFactory, this.includes, this.isCountAggRequest());
        } else {
            this.sourceBuilder.pointInTimeBuilder(new PointInTimeBuilder(this.pitId));
            this.sourceBuilder.timeout(this.cursorKeepAlive);
            if (this.searchAfter != null) {
                this.sourceBuilder.searchAfter(this.searchAfter);
            }
            if (this.sourceBuilder.sorts() == null || this.sourceBuilder.sorts().isEmpty()) {
                this.sourceBuilder.sort("_doc", SortOrder.ASC);
                this.sourceBuilder.sort((SortBuilder)SortBuilders.shardDocSort());
            } else {
                if (this.sourceBuilder.sorts().stream().noneMatch(b -> {
                    FieldSortBuilder f;
                    return b instanceof FieldSortBuilder && (f = (FieldSortBuilder)b).fieldName().equals("_doc");
                })) {
                    this.sourceBuilder.sort("_doc", SortOrder.ASC);
                }
                if (this.sourceBuilder.sorts().stream().noneMatch(ShardDocSortBuilder.class::isInstance)) {
                    this.sourceBuilder.sort((SortBuilder)SortBuilders.shardDocSort());
                }
            }
            SearchRequest searchRequest = new SearchRequest().indices(this.indexName.getIndexNames()).source(this.sourceBuilder);
            this.searchResponse = searchAction.apply(searchRequest);
            openSearchResponse = new OpenSearchResponse(this.searchResponse, this.exprValueFactory, this.includes, this.isCountAggRequest());
            this.needClean = openSearchResponse.isEmpty();
            this.searchDone = openSearchResponse.isEmpty();
            SearchHit[] searchHits = this.searchResponse.getHits().getHits();
            if (searchHits != null && searchHits.length > 0) {
                this.searchAfter = searchHits[searchHits.length - 1].getSortValues();
                this.sourceBuilder.searchAfter(this.searchAfter);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.sourceBuilder);
                }
            }
        }
        return openSearchResponse;
    }

    @Override
    public void clean(Consumer<String> cleanAction) {
        try {
            if (this.pitId != null && this.needClean) {
                cleanAction.accept(this.pitId);
                this.searchDone = true;
            }
        }
        finally {
            this.pitId = null;
            this.searchAfter = null;
            this.afterKey = null;
        }
    }

    @Override
    public void forceClean(Consumer<String> cleanAction) {
        try {
            if (this.pitId != null) {
                cleanAction.accept(this.pitId);
                this.searchDone = true;
            }
        }
        finally {
            this.pitId = null;
            this.searchAfter = null;
            this.afterKey = null;
        }
    }

    @Override
    public boolean hasAnotherBatch() {
        if (this.pitId != null) {
            return !this.needClean;
        }
        return false;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.pitId != null) {
            out.writeString(this.sourceBuilder.toString());
            out.writeTimeValue(this.sourceBuilder.timeout());
            out.writeString(this.sourceBuilder.pointInTimeBuilder().getId());
            out.writeStringCollection(this.includes);
            this.indexName.writeTo(out);
            if (this.searchAfter != null) {
                out.writeVInt(this.searchAfter.length);
                for (Object obj : this.searchAfter) {
                    out.writeGenericValue(obj);
                }
            }
        } else {
            throw new UnsupportedOperationException("OpenSearchQueryRequest serialization is not implemented.");
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchQueryRequest)) {
            return false;
        }
        OpenSearchQueryRequest other = (OpenSearchQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OpenSearchRequest.IndexName this$indexName = this.getIndexName();
        OpenSearchRequest.IndexName other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !((Object)this$indexName).equals(other$indexName)) {
            return false;
        }
        SearchSourceBuilder this$sourceBuilder = this.getSourceBuilder();
        SearchSourceBuilder other$sourceBuilder = other.getSourceBuilder();
        if (this$sourceBuilder == null ? other$sourceBuilder != null : !this$sourceBuilder.equals(other$sourceBuilder)) {
            return false;
        }
        String this$pitId = this.getPitId();
        String other$pitId = other.getPitId();
        if (this$pitId == null ? other$pitId != null : !this$pitId.equals(other$pitId)) {
            return false;
        }
        TimeValue this$cursorKeepAlive = this.getCursorKeepAlive();
        TimeValue other$cursorKeepAlive = other.getCursorKeepAlive();
        if (this$cursorKeepAlive == null ? other$cursorKeepAlive != null : !this$cursorKeepAlive.equals(other$cursorKeepAlive)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSearchAfter(), other.getSearchAfter())) {
            return false;
        }
        SearchResponse this$searchResponse = this.getSearchResponse();
        SearchResponse other$searchResponse = other.getSearchResponse();
        if (this$searchResponse == null ? other$searchResponse != null : !this$searchResponse.equals(other$searchResponse)) {
            return false;
        }
        Map<String, Object> this$afterKey = this.getAfterKey();
        Map<String, Object> other$afterKey = other.getAfterKey();
        return !(this$afterKey == null ? other$afterKey != null : !((Object)this$afterKey).equals(other$afterKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchQueryRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OpenSearchRequest.IndexName $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : ((Object)$indexName).hashCode());
        SearchSourceBuilder $sourceBuilder = this.getSourceBuilder();
        result = result * 59 + ($sourceBuilder == null ? 43 : $sourceBuilder.hashCode());
        String $pitId = this.getPitId();
        result = result * 59 + ($pitId == null ? 43 : $pitId.hashCode());
        TimeValue $cursorKeepAlive = this.getCursorKeepAlive();
        result = result * 59 + ($cursorKeepAlive == null ? 43 : $cursorKeepAlive.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSearchAfter());
        SearchResponse $searchResponse = this.getSearchResponse();
        result = result * 59 + ($searchResponse == null ? 43 : $searchResponse.hashCode());
        Map<String, Object> $afterKey = this.getAfterKey();
        result = result * 59 + ($afterKey == null ? 43 : ((Object)$afterKey).hashCode());
        return result;
    }

    @Generated
    public OpenSearchRequest.IndexName getIndexName() {
        return this.indexName;
    }

    @Generated
    public SearchSourceBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    @Override
    @Generated
    public OpenSearchExprValueFactory getExprValueFactory() {
        return this.exprValueFactory;
    }

    @Generated
    public List<String> getIncludes() {
        return this.includes;
    }

    @Generated
    public boolean isNeedClean() {
        return this.needClean;
    }

    @Generated
    public boolean isSearchDone() {
        return this.searchDone;
    }

    @Generated
    public String getPitId() {
        return this.pitId;
    }

    @Generated
    public TimeValue getCursorKeepAlive() {
        return this.cursorKeepAlive;
    }

    @Generated
    public Object[] getSearchAfter() {
        return this.searchAfter;
    }

    @Generated
    public SearchResponse getSearchResponse() {
        return this.searchResponse;
    }

    @Generated
    public Map<String, Object> getAfterKey() {
        return this.afterKey;
    }

    @Generated
    public String toString() {
        return "OpenSearchQueryRequest(indexName=" + String.valueOf(this.getIndexName()) + ", sourceBuilder=" + String.valueOf(this.getSourceBuilder()) + ", pitId=" + this.getPitId() + ", cursorKeepAlive=" + String.valueOf(this.getCursorKeepAlive()) + ", searchAfter=" + Arrays.deepToString(this.getSearchAfter()) + ", searchResponse=" + String.valueOf(this.getSearchResponse()) + ")";
    }
}

