/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.GetFrameCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import org.jetbrains.annotations.NotNull;

public class GetArrayCommand
extends GetFrameCommand {
    private final String myVariableName;
    private final int myRowOffset;
    private final int myColOffset;
    private final int myRows;
    private final int myColumns;
    private final String myFormat;
    private ArrayChunk myChunk;

    public GetArrayCommand(RemoteDebugger debugger, String threadId, String frameId, PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) {
        super(debugger, 143, threadId, frameId);
        this.myVariableName = var.getEvaluationExpression();
        this.myRowOffset = rowOffset;
        this.myColOffset = colOffset;
        this.myRows = rows;
        this.myColumns = cols;
        this.myFormat = format;
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        payload.add(this.myRowOffset);
        payload.add(this.myColOffset);
        payload.add(this.myRows);
        payload.add(this.myColumns);
        payload.add(this.myFormat);
        if (this.myVariableName.contains("BY_ID")) {
            payload.add(this.getThreadId()).add(this.myVariableName);
        } else {
            super.buildPayload(payload);
            payload.add(this.myVariableName);
        }
    }

    @Override
    protected void processResponse(@NotNull ProtocolFrame response) throws PyDebuggerException {
        if (response == null) {
            GetArrayCommand.$$$reportNull$$$0(0);
        }
        if (GetArrayCommand.isErrorCommand(response.getCommand())) {
            String payload = response.getPayload();
            if (payload.contains("ExceedingArrayDimensionsException")) {
                throw new IllegalArgumentException(this.myVariableName + " has more than two dimensions");
            }
            throw new PyDebuggerException(payload);
        }
        this.myChunk = ProtocolParser.parseArrayValues(response.getPayload(), (PyFrameAccessor)this.myDebugProcess);
    }

    public ArrayChunk getArray() {
        return this.myChunk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/jetbrains/python/debugger/pydev/GetArrayCommand", "processResponse"));
    }
}

