/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesTreeCompatibilityProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserConflictsNodeKt;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.TagChangesBrowserNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserConflictsNode;", "Lcom/intellij/openapi/vcs/changes/ui/TagChangesBrowserNode;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "showResolveConflictsDialog", "getTextPresentation", "", "getSortWeight", "", "intellij.platform.vcs.impl.shared"})
@ApiStatus.Internal
public final class ChangesBrowserConflictsNode
extends TagChangesBrowserNode {
    @NotNull
    private final Project project;

    public ChangesBrowserConflictsNode(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(ChangesBrowserConflictsNodeKt.CONFLICTS_NODE_TAG, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, true);
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
        renderer.append(VcsBundle.message((String)"changes.nodetitle.merge.conflicts", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        renderer.append(FontUtil.spaceAndThinSpace(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        renderer.append(VcsBundle.message((String)"changes.nodetitle.merge.conflicts.resolve.link.label", (Object[])new Object[0]), SimpleTextAttributes.LINK_BOLD_ATTRIBUTES, () -> ChangesBrowserConflictsNode.render$lambda$0(this));
    }

    private final void showResolveConflictsDialog() {
        ChangesTreeCompatibilityProvider changesTreeCompatibilityProvider = ChangesTreeCompatibilityProvider.Companion.getInstance();
        List<Change> list = this.getAllChangesUnder();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllChangesUnder(...)");
        changesTreeCompatibilityProvider.showResolveConflictsDialog(this.project, list);
    }

    @Override
    @NotNull
    public String getTextPresentation() {
        String string = VcsBundle.message((String)"changes.nodetitle.merge.conflicts", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public int getSortWeight() {
        return 0;
    }

    private static final void render$lambda$0(ChangesBrowserConflictsNode this$0) {
        this$0.showResolveConflictsDialog();
    }
}

