/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.OpenGLApi;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.RenderTargetsKt;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.context.ContextBasedContextHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/skiko/context/OpenGLContextHandler;", "Lorg/jetbrains/skiko/context/ContextBasedContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "makeContext", "Lorg/jetbrains/skia/DirectContext;", "currentWidth", "", "currentHeight", "isSizeChanged", "", "width", "height", "initCanvas", "", "rendererInfo", "", "skiko"})
public final class OpenGLContextHandler
extends ContextBasedContextHandler {
    private int currentWidth;
    private int currentHeight;

    public OpenGLContextHandler(@NotNull SkiaLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super(layer, "OpenGL");
    }

    @Override
    @NotNull
    protected DirectContext makeContext() {
        return RenderTargetsKt.makeGLContext();
    }

    private final boolean isSizeChanged(int width, int height) {
        if (width != this.currentWidth || height != this.currentHeight) {
            this.currentWidth = width;
            this.currentHeight = height;
            return true;
        }
        return false;
    }

    @Override
    protected void initCanvas() {
        int h;
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        if (this.isSizeChanged(w, h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0)) || this.getSurface() == null) {
            this.disposeCanvas();
            OpenGLApi gl = OpenGLApi.Companion.getInstance();
            int fbId = gl.glGetIntegerv(gl.getGL_DRAW_FRAMEBUFFER_BINDING());
            this.setRenderTarget(RenderTargetsKt.makeGLRenderTarget(w, h, 0, 8, fbId, 32856));
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget(directContext, backendRenderTarget, SurfaceOrigin.BOTTOM_LEFT, SurfaceColorFormat.RGBA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null));
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
        }
        Surface surface = this.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        this.setCanvas(surface.getCanvas());
    }

    @Override
    @NotNull
    public String rendererInfo() {
        OpenGLApi gl = OpenGLApi.Companion.getInstance();
        return super.rendererInfo() + "Vendor: " + gl.glGetString(gl.getGL_VENDOR()) + "\nModel: " + gl.glGetString(gl.getGL_RENDERER()) + "\nTotal VRAM: " + gl.glGetIntegerv(gl.getGL_TOTAL_MEMORY()) / 1024 + " MB\n";
    }
}

