/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.jetbrains.nativecerts.NativeTrustedRootsInternalUtils;
import org.jetbrains.nativecerts.linux.LinuxTrustedCertificatesUtil;
import org.jetbrains.nativecerts.mac.SecurityFrameworkUtil;
import org.jetbrains.nativecerts.win32.Crypt32ExtUtil;

public class NativeTrustedCertificates {
    private static final Logger LOGGER = Logger.getLogger(NativeTrustedCertificates.class.getName());

    public static Collection<X509Certificate> getCustomOsSpecificTrustedCertificates() {
        try {
            if (NativeTrustedRootsInternalUtils.isLinux) {
                return LinuxTrustedCertificatesUtil.getSystemCertificates();
            }
            if (NativeTrustedRootsInternalUtils.isMac) {
                List<X509Certificate> admin = SecurityFrameworkUtil.getTrustedRoots();
                return new HashSet<X509Certificate>(admin);
            }
            if (NativeTrustedRootsInternalUtils.isWindows) {
                return Crypt32ExtUtil.getCustomTrustedRootCertificates();
            }
            LOGGER.warning("Unable to get custom trusted certificates list from the operating system: unsupported system, not a Linux/Mac OS/Windows: " + System.getProperty("os.name"));
            return Collections.emptySet();
        }
        catch (Throwable t) {
            LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to get custom trusted certificates list from the operating system", t));
            return Collections.emptySet();
        }
    }
}

